//  Date : 04/11/2001    (11.04.2001)
//

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.263,0.255,0.255> }

camera {  //  Camera Camera01
  location  <      6.841,     -66.800,      15.140>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.37330,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         49.77098    // Vertical      37.328
  look_at   <      0.292,       0.827,      12.801>
}



light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  0.5
  fade_power 0.9
  rotate <-105.589157, 0.0, 27.004091>
  translate  <14.026359, -60.163726, 9.846845>
}


light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  scale <1.614208, 0.957405, 1.041949>
  rotate <44.08947, 0.480518, 32.142643>
  translate  <20.704423, -32.67371, 33.167129>
}


light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-6.35391, -62.205402, 9.568653>
}


//
// ********  MATERIALS  *******
//

#include "antfortress.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#include "D:\MORAY31\Udo\ant.inc"

#declare head_GREENBUGE_Ref = object {
  head_GREENBUGE
}
#declare torso_GREENBUG_Ref = object {
  torso_GREENBUG
}
#declare eye_BUG_EYEB_Ref = object {
  eye_BUG_EYEB
}
#declare eye01_BUG_EYEG_Ref = object {
  eye01_BUG_EYEG
}
#declare antena01_GREENBUGU_Ref = object {
  antena01_GREENBUGU
}
#declare antena02_GREENBUGU_Ref = object {
  antena02_GREENBUGU
}
#declare leg_ft_rt_GREENBUG_Ref = object {
  leg_ft_rt_GREENBUG
}
#declare leg_mid_rt_GREENBUG_Ref = object {
  leg_mid_rt_GREENBUG
}
#declare leg_bk_rt_GREENBUGG_Ref = object {
  leg_bk_rt_GREENBUGG
}
#declare leg_bk_lt_GREENBUGG_Ref = object {
  leg_bk_lt_GREENBUGG
}
#declare mandible_GREENBUGG_Ref = object {
  mandible_GREENBUGG
}
#declare mandible01_GREENBUG_Ref = object {
  mandible01_GREENBUG
}
#declare leg_fr_lt_GREENBUGG_Ref = object {
  leg_fr_lt_GREENBUGG
}
#declare leg_mid_lt_GREENBUG_Ref = object {
  leg_mid_lt_GREENBUG
}
#declare tail_GREENBUGE_Ref = object {
  tail_GREENBUGE
}
#declare Ant_group = union { // Ant_group
  object { head_GREENBUGE_Ref }
  object { torso_GREENBUG_Ref }
  object { eye_BUG_EYEB_Ref }
  object { eye01_BUG_EYEG_Ref }
  object { antena01_GREENBUGU_Ref }
  object { antena02_GREENBUGU_Ref }
  object { leg_ft_rt_GREENBUG_Ref }
  object { leg_mid_rt_GREENBUG_Ref }
  object { leg_bk_rt_GREENBUGG_Ref }
  object { leg_bk_lt_GREENBUGG_Ref }
  object { mandible_GREENBUGG_Ref }
  object { mandible01_GREENBUG_Ref }
  object { leg_fr_lt_GREENBUGG_Ref }
  object { leg_mid_lt_GREENBUG_Ref }
  object { tail_GREENBUGE_Ref }
  material {
    BlackLeather
  }
  scale 0.004
  rotate -148.258438*z
  translate  <-0.162005, -10.90807, 1.853825>
}
#declare Ant_group1 = object {
  object { // Ant_group1->Ant_group
    Ant_group
    rotate <-0.0, -0.0, -58.0014>
    translate  <18.388517, 4.183631, -0.0>
  }
}
#declare Ant_group10 = object {
  object { // Ant_group10->Ant_group1
    Ant_group1
    rotate <0.0, -0.0, -0.0>
    translate  <-25.722606, -16.775613, -0.0>
  }
}
#declare Ant_group11 = object {
  object { // Ant_group11->Ant_group10
    Ant_group10
    rotate -0.0*z
    translate  <-2.483824, -2.759804, 0.0>
  }
}




#declare head_GREENBUGE1_Ref = object {
  head_GREENBUGE
}
#declare torso_GREENBUG1_Ref = object {
  torso_GREENBUG
}
#declare eye_BUG_EYEB1_Ref = object {
  eye_BUG_EYEB
}
#declare eye01_BUG_EYEG1_Ref = object {
  eye01_BUG_EYEG
}
#declare antena01_GREENBUGU1_Ref = object {
  antena01_GREENBUGU
}
#declare antena02_GREENBUGU1_Ref = object {
  antena02_GREENBUGU
}
#declare leg_ft_rt_GREENBUG1_Ref = object {
  leg_ft_rt_GREENBUG
}
#declare leg_mid_rt_GREENBUG1_Ref = object {
  leg_mid_rt_GREENBUG
}
#declare leg_bk_rt_GREENBUGG1_Ref = object {
  leg_bk_rt_GREENBUGG
}
#declare leg_bk_lt_GREENBUGG1_Ref = object {
  leg_bk_lt_GREENBUGG
}
#declare mandible_GREENBUGG1_Ref = object {
  mandible_GREENBUGG
}
#declare mandible01_GREENBUG1_Ref = object {
  mandible01_GREENBUG
}
#declare leg_fr_lt_GREENBUGG1_Ref = object {
  leg_fr_lt_GREENBUGG
}
#declare leg_mid_lt_GREENBUG1_Ref = object {
  leg_mid_lt_GREENBUG
}
#declare tail_GREENBUGE1_Ref = object {
  tail_GREENBUGE
}
#declare Ant_group6 = union {
  object { head_GREENBUGE1_Ref }
  object { torso_GREENBUG1_Ref }
  object { eye_BUG_EYEB1_Ref }
  object { eye01_BUG_EYEG1_Ref }
  object { antena01_GREENBUGU1_Ref }
  object { antena02_GREENBUGU1_Ref }
  object { leg_ft_rt_GREENBUG1_Ref }
  object { leg_mid_rt_GREENBUG1_Ref }
  object { leg_bk_rt_GREENBUGG1_Ref }
  object { leg_bk_lt_GREENBUGG1_Ref }
  object { mandible_GREENBUGG1_Ref }
  object { mandible01_GREENBUG1_Ref }
  object { leg_fr_lt_GREENBUGG1_Ref }
  object { leg_mid_lt_GREENBUG1_Ref }
  object { tail_GREENBUGE1_Ref }
  material {
    BlackLeather
  }
  scale 0.004
  rotate 179.319809*z
  translate  <0.886519, -1.35898, 0.824062>
}
#declare Ant_group5 = object {
  object { // Ant_group5->Ant_group6
    Ant_group6
    rotate <0.0, -0.0, -0.0>
    translate  <-0.044772, -3.178806, -0.0>
  }
}
#declare SB3 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  material {
    DMFWood4
  }
  scale <-0.558382, -1.265598, -24.216471>
  rotate -180.0*x
}
#declare R6 = object {
  cylinder { // R6
    <0,0,1>, <0,0,0>, 1 
    material {
      DMFWood4
    }
    scale <0.342803, 0.342803, 4.694511>
    rotate -90.0*y
    translate  <4.774688, 0.035524, -9.247775>
  }
}
#declare Ladder1 = union {
  object { SB3 }
  object { // SB4->SB3
    SB3
    translate  4.926845*x
  }
  object { R6 }
  object { // R7->R6
    R6
    rotate <0.0, -0.0, -0.0>
    translate  5.0*z
  }
  object { // R8->R6
    R6
    rotate <0.0, -0.0, -0.0>
    translate  10.0*z
  }
  object { // R9->R6
    R6
    rotate <0.0, -0.0, -0.0>
    translate  15.0*z
  }
  object { // R10->R6
    R6
    rotate <0.0, -0.0, -0.0>
    translate  20.0*z
  }
  scale 0.328421
  rotate 90.483788*x
  translate  <0.027344, -4.720106, 1.217792>
}
#declare LadderCarriers = union { // LadderCarriers
  object { // Ant_group4->Ant_group5
    Ant_group5
    rotate 0.0*x
    translate  <-0.044772, -2.999718, 0.0>
  }
  object { Ant_group5 }
  object { Ant_group6 }
  object { Ladder1 }
  rotate 28.336052*z
  translate  <2.755063, -18.121676, 1.006395>
}
#declare head_GREENBUGE2_Ref = object {
  head_GREENBUGE
}
#declare torso_GREENBUG2_Ref = object {
  torso_GREENBUG
}
#declare eye_BUG_EYEB2_Ref = object {
  eye_BUG_EYEB
}
#declare eye01_BUG_EYEG2_Ref = object {
  eye01_BUG_EYEG
}
#declare antena01_GREENBUGU2_Ref = object {
  antena01_GREENBUGU
}
#declare antena02_GREENBUGU2_Ref = object {
  antena02_GREENBUGU
}
#declare leg_ft_rt_GREENBUG2_Ref = object {
  leg_ft_rt_GREENBUG
}
#declare leg_mid_rt_GREENBUG2_Ref = object {
  leg_mid_rt_GREENBUG
}
#declare leg_bk_rt_GREENBUGG2_Ref = object {
  leg_bk_rt_GREENBUGG
}
#declare leg_bk_lt_GREENBUGG2_Ref = object {
  leg_bk_lt_GREENBUGG
}
#declare mandible_GREENBUGG2_Ref = object {
  mandible_GREENBUGG
}
#declare mandible01_GREENBUG2_Ref = object {
  mandible01_GREENBUG
}
#declare leg_fr_lt_GREENBUGG2_Ref = object {
  leg_fr_lt_GREENBUGG
}
#declare leg_mid_lt_GREENBUG2_Ref = object {
  leg_mid_lt_GREENBUG
}
#declare tail_GREENBUGE2_Ref = object {
  tail_GREENBUGE
}
#declare Ant_group3 = union { // Ant_group3
  object { head_GREENBUGE2_Ref }
  object { torso_GREENBUG2_Ref }
  object { eye_BUG_EYEB2_Ref }
  object { eye01_BUG_EYEG2_Ref }
  object { antena01_GREENBUGU2_Ref }
  object { antena02_GREENBUGU2_Ref }
  object { leg_ft_rt_GREENBUG2_Ref }
  object { leg_mid_rt_GREENBUG2_Ref }
  object { leg_bk_rt_GREENBUGG2_Ref }
  object { leg_bk_lt_GREENBUGG2_Ref }
  object { mandible_GREENBUGG2_Ref }
  object { mandible01_GREENBUG2_Ref }
  object { leg_fr_lt_GREENBUGG2_Ref }
  object { leg_mid_lt_GREENBUG2_Ref }
  object { tail_GREENBUGE2_Ref }
  material {
    BlackLeather
  }
  scale 0.004
  rotate <112.479401, -169.569489, -20.942413>
  translate  <-21.268205, -4.045483, 8.345138>
}




#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.066190, 0.560691, 1.204748>, <0.066436, 0.552366, 1.207649>, <0.075784, 0.533284, 1.213589>, <0.067010, 0.532941, 1.214417>, 
      <0.067081, 0.514190, 1.168417>, <0.067327, 0.505865, 1.171317>, <0.076675, 0.486784, 1.177257>, <0.067901, 0.486440, 1.178085>, 
      <0.068270, 0.452190, 1.119975>, <0.068516, 0.443865, 1.122875>, <0.077863, 0.424783, 1.128815>, <0.069090, 0.424440, 1.129644>, 
      <0.069161, 0.405689, 1.083643>, <0.069407, 0.397364, 1.086544>, <0.078755, 0.378282, 1.092484>, <0.069981, 0.377939, 1.093312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068956, 0.525070, 1.403946>, <0.069202, 0.516745, 1.406847>, <0.078550, 0.497663, 1.412786>, <0.069776, 0.497320, 1.413615>, 
      <0.068126, 0.535756, 1.344187>, <0.068372, 0.527431, 1.347087>, <0.077720, 0.508350, 1.353027>, <0.068946, 0.508006, 1.353856>, 
      <0.067020, 0.550005, 1.264507>, <0.067266, 0.541680, 1.267408>, <0.076613, 0.522598, 1.273348>, <0.067840, 0.522255, 1.274176>, 
      <0.066190, 0.560691, 1.204748>, <0.066436, 0.552366, 1.207649>, <0.075784, 0.533284, 1.213589>, <0.067010, 0.532941, 1.214417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060536, 0.555731, 1.216715>, <-0.059645, 0.509231, 1.180383>, <-0.058456, 0.447230, 1.131941>, <-0.057565, 0.400730, 1.095609>, 
      <-0.022272, 0.548894, 1.216026>, <-0.021381, 0.502394, 1.179694>, <-0.020192, 0.440393, 1.131252>, <-0.019301, 0.393893, 1.094920>, 
      <0.028336, 0.531427, 1.218069>, <0.029227, 0.484927, 1.181738>, <0.030415, 0.422926, 1.133295>, <0.031307, 0.376426, 1.096964>, 
      <0.067010, 0.532941, 1.214417>, <0.067901, 0.486440, 1.178085>, <0.069090, 0.424440, 1.129644>, <0.069981, 0.377939, 1.093312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057770, 0.520110, 1.415913>, <-0.058600, 0.530796, 1.356154>, <-0.059706, 0.545045, 1.276474>, <-0.060536, 0.555731, 1.216715>, 
      <-0.019506, 0.513273, 1.415224>, <-0.020336, 0.523959, 1.355464>, <-0.021442, 0.538208, 1.275785>, <-0.022272, 0.548894, 1.216026>, 
      <0.031102, 0.495806, 1.417267>, <0.030272, 0.506493, 1.357508>, <0.029165, 0.520741, 1.277829>, <0.028336, 0.531427, 1.218069>, 
      <0.069776, 0.497320, 1.413615>, <0.068946, 0.508006, 1.353856>, <0.067840, 0.522255, 1.274176>, <0.067010, 0.532941, 1.214417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060236, 0.543309, 1.228018>, <-0.060482, 0.551634, 1.225117>, <-0.069830, 0.570716, 1.219178>, <-0.061056, 0.571059, 1.218349>, 
      <-0.059375, 0.496761, 1.188201>, <-0.059621, 0.505086, 1.185300>, <-0.068969, 0.524168, 1.179360>, <-0.060195, 0.524511, 1.178532>, 
      <-0.058228, 0.434697, 1.135110>, <-0.058474, 0.443022, 1.132210>, <-0.067821, 0.462104, 1.126270>, <-0.059048, 0.462447, 1.125441>, 
      <-0.057367, 0.388149, 1.095293>, <-0.057613, 0.396474, 1.092392>, <-0.066961, 0.415556, 1.086452>, <-0.058187, 0.415899, 1.085624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057163, 0.493654, 1.420431>, <-0.057409, 0.501979, 1.417530>, <-0.066756, 0.521061, 1.411591>, <-0.057982, 0.521404, 1.410762>, 
      <-0.058085, 0.508551, 1.362707>, <-0.058331, 0.516876, 1.359806>, <-0.067678, 0.535957, 1.353867>, <-0.058904, 0.536301, 1.353038>, 
      <-0.059314, 0.528412, 1.285742>, <-0.059560, 0.536737, 1.282841>, <-0.068907, 0.555819, 1.276901>, <-0.060134, 0.556163, 1.276073>, 
      <-0.060236, 0.543309, 1.228018>, <-0.060482, 0.551634, 1.225117>, <-0.069830, 0.570716, 1.219178>, <-0.061056, 0.571059, 1.218349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.066490, 0.548268, 1.216051>, <0.067351, 0.501720, 1.176234>, <0.068498, 0.439656, 1.123144>, <0.069359, 0.393108, 1.083327>, 
      <0.028226, 0.555105, 1.216740>, <0.029087, 0.508557, 1.176923>, <0.030235, 0.446493, 1.123833>, <0.031095, 0.399945, 1.084016>, 
      <-0.022381, 0.572572, 1.214697>, <-0.021521, 0.526024, 1.174879>, <-0.020373, 0.463960, 1.121790>, <-0.019512, 0.417412, 1.081972>, 
      <-0.061056, 0.571059, 1.218349>, <-0.060195, 0.524511, 1.178532>, <-0.059048, 0.462447, 1.125441>, <-0.058187, 0.415899, 1.085624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.069564, 0.498613, 1.408464>, <0.068642, 0.513509, 1.350740>, <0.067412, 0.533372, 1.273775>, <0.066490, 0.548268, 1.216051>, 
      <0.031300, 0.505450, 1.409153>, <0.030378, 0.520347, 1.351430>, <0.029148, 0.540209, 1.274464>, <0.028226, 0.555105, 1.216740>, 
      <-0.019307, 0.522917, 1.407110>, <-0.020230, 0.537814, 1.349386>, <-0.021459, 0.557676, 1.272421>, <-0.022381, 0.572572, 1.214697>, 
      <-0.057982, 0.521404, 1.410762>, <-0.058904, 0.536301, 1.353038>, <-0.060134, 0.556163, 1.276073>, <-0.061056, 0.571059, 1.218349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.111583, -0.206981, 1.886527>, <0.113617, -0.184320, 1.866215>, <0.045970, -0.182666, 1.867704>, <0.015595, -0.180648, 1.865819>, 
      <0.111583, -0.206981, 1.886527>, <0.110639, -0.217500, 1.895955>, <0.043188, -0.213644, 1.895470>, <0.012814, -0.211626, 1.893585>, 
      <0.111583, -0.206981, 1.886527>, <0.110639, -0.217500, 1.895955>, <0.053471, -0.265546, 1.925399>, <0.008998, -0.262592, 1.922639>, 
      <0.111583, -0.206981, 1.886527>, <0.108604, -0.240162, 1.916267>, <0.050799, -0.286863, 1.961131>, <0.006325, -0.283908, 1.958371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.081389, -0.194160, 1.874552>, <-0.084409, -0.227798, 1.904702>, <-0.038762, -0.280912, 1.955573>, <0.006325, -0.283908, 1.958371>, 
      <-0.081389, -0.194160, 1.874552>, <-0.082442, -0.205885, 1.885061>, <-0.036090, -0.259596, 1.919841>, <0.008998, -0.262592, 1.922639>, 
      <-0.081389, -0.194160, 1.874552>, <-0.082442, -0.205885, 1.885061>, <-0.016558, -0.209675, 1.891762>, <0.012814, -0.211626, 1.893585>, 
      <-0.081389, -0.194160, 1.874552>, <-0.079422, -0.172247, 1.854911>, <-0.013777, -0.178697, 1.863996>, <0.015595, -0.180648, 1.865819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117432, -0.177663, 1.917919>, <0.115826, -0.211885, 1.948488>, <0.052062, -0.257538, 1.992518>, <0.006325, -0.254589, 1.989763>, 
      <0.117432, -0.177663, 1.917919>, <0.116988, -0.187115, 1.926362>, <0.053417, -0.220329, 1.975651>, <0.007680, -0.217379, 1.972896>, 
      <0.117432, -0.177663, 1.917919>, <0.116988, -0.187115, 1.926362>, <0.042765, -0.185635, 1.928255>, <0.009661, -0.183501, 1.926262>, 
      <0.117432, -0.177663, 1.917919>, <0.118594, -0.152894, 1.895793>, <0.044195, -0.155169, 1.901041>, <0.011091, -0.153034, 1.899047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117432, -0.177663, 1.917919>, <0.115677, -0.186458, 1.908501>, <0.113338, -0.198186, 1.895945>, <0.111583, -0.206981, 1.886527>, 
      <0.115826, -0.211885, 1.948488>, <0.114071, -0.220680, 1.939070>, <0.110359, -0.231366, 1.925684>, <0.108604, -0.240162, 1.916267>, 
      <0.052062, -0.257538, 1.992518>, <0.051635, -0.269269, 1.997835>, <0.049973, -0.293451, 1.972175>, <0.050799, -0.286863, 1.961131>, 
      <0.006325, -0.254589, 1.989763>, <0.005898, -0.266319, 1.995080>, <0.005499, -0.290496, 1.969415>, <0.006325, -0.283908, 1.958371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.081389, -0.164842, 1.905945>, <-0.082973, -0.198585, 1.936087>, <-0.038773, -0.251681, 1.987047>, <0.006325, -0.254589, 1.989763>, 
      <-0.081389, -0.173637, 1.896527>, <-0.082973, -0.207381, 1.926669>, <-0.039200, -0.263411, 1.992364>, <0.005898, -0.266319, 1.995080>, 
      <-0.081389, -0.185365, 1.883970>, <-0.084409, -0.219003, 1.914120>, <-0.039588, -0.287501, 1.966617>, <0.005499, -0.290496, 1.969415>, 
      <-0.081389, -0.194160, 1.874552>, <-0.084409, -0.227798, 1.904702>, <-0.038762, -0.280912, 1.955573>, <0.006325, -0.283908, 1.958371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.081389, -0.164842, 1.905945>, <-0.080408, -0.143939, 1.887273>, <-0.016846, -0.151232, 1.897364>, <0.011091, -0.153034, 1.899047>, 
      <-0.081389, -0.164842, 1.905945>, <-0.081992, -0.177682, 1.917414>, <-0.018276, -0.181699, 1.924579>, <0.009661, -0.183501, 1.926262>, 
      <-0.081389, -0.164842, 1.905945>, <-0.081992, -0.177682, 1.917414>, <-0.037418, -0.214471, 1.970180>, <0.007680, -0.217379, 1.972896>, 
      <-0.081389, -0.164842, 1.905945>, <-0.082973, -0.198585, 1.936087>, <-0.038773, -0.251681, 1.987047>, <0.006325, -0.254589, 1.989763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106833, -0.021914, 1.779500>, <0.106833, -0.058268, 1.809834>, <0.067433, -0.088521, 1.835077>, <0.020086, -0.088521, 1.835077>, 
      <0.106833, -0.021914, 1.779500>, <0.106833, -0.021914, 1.779500>, <0.067433, -0.048557, 1.801731>, <0.020086, -0.048557, 1.801731>, 
      <0.106833, -0.021914, 1.779500>, <0.106833, -0.021914, 1.779500>, <0.067433, 0.004728, 1.757269>, <0.020086, 0.004728, 1.757269>, 
      <0.106833, -0.021914, 1.779500>, <0.106833, 0.014439, 1.749166>, <0.067433, 0.044692, 1.723923>, <0.020086, 0.044692, 1.723923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.066661, -0.021914, 1.779500>, <-0.066661, 0.014439, 1.749166>, <-0.027261, 0.044692, 1.723923>, <0.020086, 0.044692, 1.723923>, 
      <-0.066661, -0.021914, 1.779500>, <-0.066661, -0.021914, 1.779500>, <-0.027261, 0.004728, 1.757269>, <0.020086, 0.004728, 1.757269>, 
      <-0.066661, -0.021914, 1.779500>, <-0.066661, -0.021914, 1.779500>, <-0.027261, -0.048557, 1.801731>, <0.020086, -0.048557, 1.801731>, 
      <-0.066661, -0.021914, 1.779500>, <-0.066661, -0.058268, 1.809834>, <-0.027261, -0.088521, 1.835077>, <0.020086, -0.088521, 1.835077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106833, 0.089239, 1.912712>, <0.106833, 0.052886, 1.943046>, <0.067433, 0.022633, 1.968289>, <0.020086, 0.022633, 1.968289>, 
      <0.106833, 0.055893, 1.872748>, <0.106833, 0.019540, 1.903082>, <0.067433, -0.010713, 1.928325>, <0.020086, -0.010713, 1.928325>, 
      <0.106833, 0.011432, 1.819464>, <0.106833, -0.024922, 1.849797>, <0.067433, -0.055175, 1.875041>, <0.020086, -0.055175, 1.875041>, 
      <0.106833, -0.021914, 1.779500>, <0.106833, -0.058268, 1.809834>, <0.067433, -0.088521, 1.835077>, <0.020086, -0.088521, 1.835077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106833, 0.089239, 1.912712>, <0.106833, 0.125592, 1.882378>, <0.067433, 0.155845, 1.857135>, <0.020086, 0.155845, 1.857135>, 
      <0.106833, 0.089239, 1.912712>, <0.106833, 0.089239, 1.912712>, <0.067433, 0.115881, 1.890481>, <0.020086, 0.115881, 1.890481>, 
      <0.106833, 0.089239, 1.912712>, <0.106833, 0.089239, 1.912712>, <0.067433, 0.062597, 1.934943>, <0.020086, 0.062597, 1.934943>, 
      <0.106833, 0.089239, 1.912712>, <0.106833, 0.052886, 1.943046>, <0.067433, 0.022633, 1.968289>, <0.020086, 0.022633, 1.968289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106833, 0.089239, 1.912712>, <0.106833, 0.055893, 1.872748>, <0.106833, 0.011432, 1.819464>, <0.106833, -0.021914, 1.779500>, 
      <0.106833, 0.125592, 1.882378>, <0.106833, 0.092246, 1.842415>, <0.106833, 0.047785, 1.789130>, <0.106833, 0.014439, 1.749166>, 
      <0.067433, 0.155845, 1.857135>, <0.067433, 0.122499, 1.817171>, <0.067433, 0.078038, 1.763887>, <0.067433, 0.044692, 1.723923>, 
      <0.020086, 0.155845, 1.857135>, <0.020086, 0.122499, 1.817171>, <0.020086, 0.078038, 1.763887>, <0.020086, 0.044692, 1.723923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.066661, 0.089239, 1.912712>, <-0.066661, 0.125592, 1.882378>, <-0.027261, 0.155845, 1.857135>, <0.020086, 0.155845, 1.857135>, 
      <-0.066661, 0.055893, 1.872748>, <-0.066661, 0.092246, 1.842415>, <-0.027261, 0.122499, 1.817171>, <0.020086, 0.122499, 1.817171>, 
      <-0.066661, 0.011432, 1.819464>, <-0.066661, 0.047785, 1.789130>, <-0.027261, 0.078038, 1.763887>, <0.020086, 0.078038, 1.763887>, 
      <-0.066661, -0.021914, 1.779500>, <-0.066661, 0.014439, 1.749166>, <-0.027261, 0.044692, 1.723923>, <0.020086, 0.044692, 1.723923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.066661, 0.089239, 1.912712>, <-0.066661, 0.055893, 1.872748>, <-0.066661, 0.011432, 1.819464>, <-0.066661, -0.021914, 1.779500>, 
      <-0.066661, 0.052886, 1.943046>, <-0.066661, 0.019540, 1.903082>, <-0.066661, -0.024922, 1.849797>, <-0.066661, -0.058268, 1.809834>, 
      <-0.027261, 0.022633, 1.968289>, <-0.027261, -0.010713, 1.928325>, <-0.027261, -0.055175, 1.875041>, <-0.027261, -0.088521, 1.835077>, 
      <0.020086, 0.022633, 1.968289>, <0.020086, -0.010713, 1.928325>, <0.020086, -0.055175, 1.875041>, <0.020086, -0.088521, 1.835077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.066661, 0.089239, 1.912712>, <-0.066661, 0.052886, 1.943046>, <-0.027261, 0.022633, 1.968289>, <0.020086, 0.022633, 1.968289>, 
      <-0.066661, 0.089239, 1.912712>, <-0.066661, 0.089239, 1.912712>, <-0.027261, 0.062597, 1.934943>, <0.020086, 0.062597, 1.934943>, 
      <-0.066661, 0.089239, 1.912712>, <-0.066661, 0.089239, 1.912712>, <-0.027261, 0.115881, 1.890481>, <0.020086, 0.115881, 1.890481>, 
      <-0.066661, 0.089239, 1.912712>, <-0.066661, 0.125592, 1.882378>, <-0.027261, 0.155845, 1.857135>, <0.020086, 0.155845, 1.857135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.047617, 2.051629>, <0.097743, -0.047617, 2.051629>, <0.231894, -0.005849, 2.014980>, <0.301008, 0.046102, 1.969396>, 
      <0.000000, 0.045219, 1.970172>, <0.097743, 0.045219, 1.970172>, <0.144561, 0.059796, 1.957381>, <0.213676, 0.111747, 1.911797>, 
      <0.000000, 0.169000, 1.861562>, <0.003215, 0.169000, 1.861562>, <0.094959, 0.197565, 1.836497>, <0.097232, 0.199273, 1.834998>, 
      <0.000000, 0.261836, 1.780104>, <0.003215, 0.261836, 1.780104>, <0.007627, 0.263209, 1.778898>, <0.009900, 0.264918, 1.777399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.301008, 0.046102, 1.969396>, <-0.231894, -0.005849, 2.014980>, <-0.097743, -0.047617, 2.051629>, <0.000000, -0.047617, 2.051629>, 
      <-0.213676, 0.111747, 1.911797>, <-0.144561, 0.059796, 1.957381>, <-0.097743, 0.045219, 1.970172>, <0.000000, 0.045219, 1.970172>, 
      <-0.097232, 0.199273, 1.834998>, <-0.094959, 0.197565, 1.836497>, <-0.003215, 0.169000, 1.861562>, <0.000000, 0.169000, 1.861562>, 
      <-0.009900, 0.264918, 1.777399>, <-0.007627, 0.263209, 1.778898>, <-0.003215, 0.261836, 1.780104>, <0.000000, 0.261836, 1.780104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.425689, 0.272360, 1.770869>, <-0.425689, 0.198890, 1.835334>, <-0.370122, 0.098053, 1.923812>, <-0.301008, 0.046102, 1.969396>, 
      <-0.302183, 0.272360, 1.770869>, <-0.302183, 0.198890, 1.835334>, <-0.282790, 0.163698, 1.866213>, <-0.213676, 0.111747, 1.911797>, 
      <-0.137507, 0.272360, 1.770869>, <-0.137507, 0.269943, 1.772989>, <-0.099506, 0.200982, 1.833499>, <-0.097232, 0.199273, 1.834998>, 
      <-0.014001, 0.272360, 1.770869>, <-0.014001, 0.269943, 1.772989>, <-0.012173, 0.266627, 1.775900>, <-0.009900, 0.264918, 1.777399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.301008, 0.498618, 1.572343>, <-0.370122, 0.446667, 1.617927>, <-0.425689, 0.345830, 1.706404>, <-0.425689, 0.272360, 1.770869>, 
      <-0.213676, 0.432973, 1.629942>, <-0.282790, 0.381022, 1.675526>, <-0.302183, 0.345830, 1.706404>, <-0.302183, 0.272360, 1.770869>, 
      <-0.097232, 0.345447, 1.706741>, <-0.099506, 0.343738, 1.708240>, <-0.137507, 0.274776, 1.768749>, <-0.137507, 0.272360, 1.770869>, 
      <-0.009900, 0.279802, 1.764340>, <-0.012173, 0.278093, 1.765839>, <-0.014001, 0.274776, 1.768749>, <-0.014001, 0.272360, 1.770869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.592337, 1.490110>, <-0.097743, 0.592337, 1.490110>, <-0.231894, 0.550569, 1.526759>, <-0.301008, 0.498618, 1.572343>, 
      <0.000000, 0.499501, 1.571568>, <-0.097743, 0.499501, 1.571568>, <-0.144561, 0.484924, 1.584358>, <-0.213676, 0.432973, 1.629942>, 
      <0.000000, 0.375720, 1.680177>, <-0.003215, 0.375720, 1.680177>, <-0.094959, 0.347156, 1.705242>, <-0.097232, 0.345447, 1.706741>, 
      <0.000000, 0.282884, 1.761635>, <-0.003215, 0.282884, 1.761635>, <-0.007627, 0.281511, 1.762841>, <-0.009900, 0.279802, 1.764340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.301008, 0.498618, 1.572343>, <0.231894, 0.550569, 1.526759>, <0.097743, 0.592337, 1.490110>, <0.000000, 0.592337, 1.490110>, 
      <0.213676, 0.432973, 1.629942>, <0.144561, 0.484924, 1.584358>, <0.097743, 0.499501, 1.571568>, <0.000000, 0.499501, 1.571568>, 
      <0.097232, 0.345447, 1.706741>, <0.094959, 0.347156, 1.705242>, <0.003215, 0.375720, 1.680177>, <0.000000, 0.375720, 1.680177>, 
      <0.009900, 0.279802, 1.764340>, <0.007627, 0.281511, 1.762841>, <0.003215, 0.282884, 1.761635>, <0.000000, 0.282884, 1.761635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.204816, 1.872471>, <0.097742, -0.204816, 1.872471>, <0.231894, -0.163048, 1.835823>, <0.301008, -0.111097, 1.790239>, 
      <0.000000, -0.161606, 1.929442>, <0.097742, -0.161606, 1.929442>, <0.235496, -0.118716, 1.891809>, <0.304611, -0.066765, 1.846225>, 
      <0.000000, -0.094777, 1.997882>, <0.097743, -0.094777, 1.997882>, <0.231894, -0.053009, 1.961233>, <0.301008, -0.001058, 1.915649>, 
      <0.000000, -0.047617, 2.051629>, <0.097743, -0.047617, 2.051629>, <0.231894, -0.005849, 2.014980>, <0.301008, 0.046102, 1.969396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.301008, -0.111097, 1.790239>, <-0.231894, -0.163048, 1.835823>, <-0.097742, -0.204816, 1.872471>, <0.000000, -0.204816, 1.872471>, 
      <-0.304611, -0.066765, 1.846225>, <-0.235496, -0.118716, 1.891809>, <-0.097742, -0.161606, 1.929442>, <0.000000, -0.161606, 1.929442>, 
      <-0.301008, -0.001058, 1.915649>, <-0.231894, -0.053009, 1.961233>, <-0.097743, -0.094777, 1.997882>, <0.000000, -0.094777, 1.997882>, 
      <-0.301008, 0.046102, 1.969396>, <-0.231894, -0.005849, 2.014980>, <-0.097743, -0.047617, 2.051629>, <0.000000, -0.047617, 2.051629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.425689, 0.115161, 1.591712>, <-0.425689, 0.041691, 1.656177>, <-0.370122, -0.059146, 1.744655>, <-0.301008, -0.111097, 1.790239>, 
      <-0.430784, 0.162201, 1.645322>, <-0.430784, 0.088731, 1.709787>, <-0.373725, -0.014814, 1.800642>, <-0.304611, -0.066765, 1.846225>, 
      <-0.425689, 0.225200, 1.717122>, <-0.425689, 0.151730, 1.781587>, <-0.370122, 0.050893, 1.870065>, <-0.301008, -0.001058, 1.915649>, 
      <-0.425689, 0.272360, 1.770869>, <-0.425689, 0.198890, 1.835334>, <-0.370122, 0.098053, 1.923812>, <-0.301008, 0.046102, 1.969396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.301008, 0.341419, 1.393186>, <-0.370122, 0.289468, 1.438770>, <-0.425689, 0.188631, 1.527247>, <-0.425689, 0.115161, 1.591712>, 
      <-0.304611, 0.391167, 1.444421>, <-0.373725, 0.339215, 1.490004>, <-0.430784, 0.235671, 1.580857>, <-0.430784, 0.162201, 1.645322>, 
      <-0.301008, 0.451458, 1.518596>, <-0.370122, 0.399507, 1.564180>, <-0.425689, 0.298670, 1.652657>, <-0.425689, 0.225200, 1.717122>, 
      <-0.301008, 0.498618, 1.572343>, <-0.370122, 0.446667, 1.617927>, <-0.425689, 0.345830, 1.706404>, <-0.425689, 0.272360, 1.770869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.435139, 1.310953>, <-0.097743, 0.435139, 1.310953>, <-0.231894, 0.393370, 1.347602>, <-0.301008, 0.341419, 1.393186>, 
      <0.000000, 0.486008, 1.361203>, <-0.097743, 0.486008, 1.361203>, <-0.235496, 0.443118, 1.398837>, <-0.304611, 0.391167, 1.444421>, 
      <0.000000, 0.545178, 1.436363>, <-0.097743, 0.545178, 1.436363>, <-0.231894, 0.503409, 1.473012>, <-0.301008, 0.451458, 1.518596>, 
      <0.000000, 0.592337, 1.490110>, <-0.097743, 0.592337, 1.490110>, <-0.231894, 0.550569, 1.526759>, <-0.301008, 0.498618, 1.572343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.301008, 0.341419, 1.393186>, <0.231894, 0.393370, 1.347602>, <0.097743, 0.435139, 1.310953>, <0.000000, 0.435139, 1.310953>, 
      <0.304611, 0.391167, 1.444421>, <0.235496, 0.443118, 1.398837>, <0.097743, 0.486008, 1.361203>, <0.000000, 0.486008, 1.361203>, 
      <0.301008, 0.451458, 1.518596>, <0.231894, 0.503409, 1.473012>, <0.097743, 0.545178, 1.436363>, <0.000000, 0.545178, 1.436363>, 
      <0.301008, 0.498618, 1.572343>, <0.231894, 0.550569, 1.526759>, <0.097743, 0.592337, 1.490110>, <0.000000, 0.592337, 1.490110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.194644, 1.857781>, <0.093762, -0.194644, 1.857781>, <0.222450, -0.154577, 1.822625>, <0.288750, -0.104741, 1.778898>, 
      <0.000000, -0.198570, 1.854132>, <0.093762, -0.198570, 1.854132>, <0.222835, -0.158383, 1.818871>, <0.289135, -0.108547, 1.775143>, 
      <0.000000, -0.208055, 1.868200>, <0.097742, -0.208055, 1.868200>, <0.231624, -0.166372, 1.831626>, <0.300738, -0.114420, 1.786042>, 
      <0.000000, -0.204816, 1.872471>, <0.097742, -0.204816, 1.872471>, <0.231894, -0.163048, 1.835823>, <0.301008, -0.111097, 1.790239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288750, -0.104741, 1.778898>, <-0.222450, -0.154577, 1.822625>, <-0.093762, -0.194644, 1.857781>, <0.000000, -0.194644, 1.857781>, 
      <-0.289135, -0.108547, 1.775143>, <-0.222835, -0.158383, 1.818871>, <-0.093762, -0.198570, 1.854132>, <0.000000, -0.198570, 1.854132>, 
      <-0.300738, -0.114420, 1.786042>, <-0.231624, -0.166372, 1.831626>, <-0.097742, -0.208055, 1.868200>, <0.000000, -0.208055, 1.868200>, 
      <-0.301008, -0.111097, 1.790239>, <-0.231894, -0.163048, 1.835823>, <-0.097742, -0.204816, 1.872471>, <0.000000, -0.204816, 1.872471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.408354, 0.112303, 1.588455>, <-0.408354, 0.041825, 1.650295>, <-0.355050, -0.054905, 1.735170>, <-0.288750, -0.104741, 1.778898>, 
      <-0.408898, 0.108786, 1.584446>, <-0.408898, 0.038308, 1.646287>, <-0.355435, -0.058712, 1.731416>, <-0.289135, -0.108547, 1.775143>, 
      <-0.425307, 0.111635, 1.587693>, <-0.425307, 0.038164, 1.652158>, <-0.369852, -0.062469, 1.740458>, <-0.300738, -0.114420, 1.786042>, 
      <-0.425689, 0.115161, 1.591712>, <-0.425689, 0.041691, 1.656177>, <-0.370122, -0.059146, 1.744655>, <-0.301008, -0.111097, 1.790239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288750, 0.329348, 1.398013>, <-0.355050, 0.279512, 1.441740>, <-0.408354, 0.182781, 1.526615>, <-0.408354, 0.112303, 1.588455>, 
      <-0.289135, 0.326120, 1.393751>, <-0.355435, 0.276284, 1.437478>, <-0.408898, 0.179264, 1.522606>, <-0.408898, 0.108786, 1.584446>, 
      <-0.300738, 0.337690, 1.389345>, <-0.369852, 0.285739, 1.434929>, <-0.425307, 0.185104, 1.523228>, <-0.425307, 0.111635, 1.587693>, 
      <-0.301008, 0.341419, 1.393186>, <-0.370122, 0.289468, 1.438770>, <-0.425689, 0.188631, 1.527247>, <-0.425689, 0.115161, 1.591712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.419251, 1.319129>, <-0.093762, 0.419251, 1.319129>, <-0.222450, 0.379184, 1.354286>, <-0.288750, 0.329348, 1.398013>, 
      <0.000000, 0.416143, 1.314762>, <-0.093762, 0.416143, 1.314762>, <-0.222835, 0.375956, 1.350023>, <-0.289135, 0.326120, 1.393751>, 
      <0.000000, 0.431325, 1.307186>, <-0.097743, 0.431325, 1.307186>, <-0.231624, 0.389641, 1.343761>, <-0.300738, 0.337690, 1.389345>, 
      <0.000000, 0.435139, 1.310953>, <-0.097743, 0.435139, 1.310953>, <-0.231894, 0.393370, 1.347602>, <-0.301008, 0.341419, 1.393186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.288750, 0.329348, 1.398013>, <0.222450, 0.379184, 1.354286>, <0.093762, 0.419251, 1.319129>, <0.000000, 0.419251, 1.319129>, 
      <0.289135, 0.326120, 1.393751>, <0.222835, 0.375956, 1.350023>, <0.093762, 0.416143, 1.314762>, <0.000000, 0.416143, 1.314762>, 
      <0.300738, 0.337690, 1.389345>, <0.231624, 0.389641, 1.343761>, <0.097743, 0.431325, 1.307186>, <0.000000, 0.431325, 1.307186>, 
      <0.301008, 0.341419, 1.393186>, <0.231894, 0.393370, 1.347602>, <0.097743, 0.435139, 1.310953>, <0.000000, 0.435139, 1.310953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.048479, 2.017793>, <0.092767, -0.048479, 2.017793>, <0.220090, -0.008837, 1.983010>, <0.285686, 0.040470, 1.939747>, 
      <0.000000, -0.092328, 1.969789>, <0.092767, -0.092328, 1.969789>, <0.221009, -0.052400, 1.934756>, <0.286605, -0.003093, 1.891492>, 
      <0.000000, -0.147024, 1.902046>, <0.093762, -0.147024, 1.902046>, <0.217783, -0.108409, 1.868166>, <0.284083, -0.058574, 1.824438>, 
      <0.000000, -0.194644, 1.857781>, <0.093762, -0.194644, 1.857781>, <0.222450, -0.154577, 1.822625>, <0.288750, -0.104741, 1.778898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.285686, 0.040470, 1.939747>, <-0.220090, -0.008837, 1.983010>, <-0.092767, -0.048479, 2.017793>, <0.000000, -0.048479, 2.017793>, 
      <-0.286605, -0.003093, 1.891492>, <-0.221009, -0.052400, 1.934756>, <-0.092767, -0.092328, 1.969789>, <0.000000, -0.092328, 1.969789>, 
      <-0.284083, -0.058574, 1.824438>, <-0.217783, -0.108409, 1.868166>, <-0.093762, -0.147024, 1.902046>, <0.000000, -0.147024, 1.902046>, 
      <-0.288750, -0.104741, 1.778898>, <-0.222450, -0.154577, 1.822625>, <-0.093762, -0.194644, 1.857781>, <0.000000, -0.194644, 1.857781>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.404021, 0.255211, 1.751326>, <-0.404021, 0.185481, 1.812510>, <-0.351282, 0.089777, 1.896484>, <-0.285686, 0.040470, 1.939747>, 
      <-0.405321, 0.212339, 1.702465>, <-0.405321, 0.142608, 1.763648>, <-0.352202, 0.046213, 1.848229>, <-0.286605, -0.003093, 1.891492>, 
      <-0.401754, 0.154963, 1.637074>, <-0.401754, 0.084484, 1.698914>, <-0.350383, -0.008738, 1.780711>, <-0.284083, -0.058574, 1.824438>, 
      <-0.408354, 0.112303, 1.588455>, <-0.408354, 0.041825, 1.650295>, <-0.355050, -0.054905, 1.735170>, <-0.288750, -0.104741, 1.778898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.285686, 0.469953, 1.562904>, <-0.351283, 0.420646, 1.606168>, <-0.404021, 0.324941, 1.690142>, <-0.404021, 0.255211, 1.751326>, 
      <-0.286605, 0.427772, 1.513437>, <-0.352202, 0.378465, 1.556700>, <-0.405321, 0.282069, 1.641281>, <-0.405321, 0.212339, 1.702465>, 
      <-0.284083, 0.368500, 1.449709>, <-0.350383, 0.318664, 1.493437>, <-0.401754, 0.225441, 1.575234>, <-0.401754, 0.154963, 1.637074>, 
      <-0.288750, 0.329348, 1.398013>, <-0.355050, 0.279512, 1.441740>, <-0.408354, 0.182781, 1.526615>, <-0.408354, 0.112303, 1.588455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.558901, 1.484857>, <-0.092767, 0.558901, 1.484857>, <-0.220090, 0.519260, 1.519640>, <-0.285686, 0.469953, 1.562904>, 
      <0.000000, 0.517006, 1.435139>, <-0.092767, 0.517006, 1.435139>, <-0.221009, 0.477078, 1.470173>, <-0.286605, 0.427772, 1.513437>, 
      <0.000000, 0.456949, 1.372100>, <-0.093762, 0.456949, 1.372100>, <-0.217783, 0.418335, 1.405982>, <-0.284083, 0.368500, 1.449709>, 
      <0.000000, 0.419251, 1.319129>, <-0.093762, 0.419251, 1.319129>, <-0.222450, 0.379184, 1.354286>, <-0.288750, 0.329348, 1.398013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.285686, 0.469953, 1.562904>, <0.220090, 0.519260, 1.519641>, <0.092767, 0.558901, 1.484857>, <0.000000, 0.558901, 1.484857>, 
      <0.286605, 0.427772, 1.513437>, <0.221009, 0.477078, 1.470173>, <0.092767, 0.517006, 1.435139>, <0.000000, 0.517006, 1.435139>, 
      <0.284083, 0.368500, 1.449709>, <0.217783, 0.418335, 1.405982>, <0.093762, 0.456949, 1.372100>, <0.000000, 0.456949, 1.372100>, 
      <0.288750, 0.329348, 1.398013>, <0.222450, 0.379184, 1.354286>, <0.093762, 0.419251, 1.319129>, <0.000000, 0.419251, 1.319129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.425689, 0.115161, 1.591712>, <0.425689, 0.188631, 1.527247>, <0.370122, 0.289468, 1.438770>, <0.301008, 0.341419, 1.393186>, 
      <0.425307, 0.111635, 1.587693>, <0.425307, 0.185104, 1.523228>, <0.369852, 0.285739, 1.434929>, <0.300738, 0.337690, 1.389345>, 
      <0.408898, 0.108786, 1.584446>, <0.408898, 0.179264, 1.522606>, <0.355435, 0.276284, 1.437478>, <0.289135, 0.326120, 1.393751>, 
      <0.408354, 0.112303, 1.588455>, <0.408354, 0.182781, 1.526615>, <0.355050, 0.279512, 1.441740>, <0.288750, 0.329348, 1.398013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.425689, 0.115161, 1.591712>, <0.425689, 0.041691, 1.656177>, <0.370122, -0.059146, 1.744655>, <0.301008, -0.111097, 1.790239>, 
      <0.425307, 0.111635, 1.587693>, <0.425307, 0.038164, 1.652158>, <0.369852, -0.062469, 1.740458>, <0.300738, -0.114420, 1.786042>, 
      <0.408898, 0.108786, 1.584446>, <0.408898, 0.038308, 1.646287>, <0.355435, -0.058712, 1.731416>, <0.289135, -0.108547, 1.775143>, 
      <0.408354, 0.112303, 1.588455>, <0.408354, 0.041825, 1.650295>, <0.355050, -0.054905, 1.735170>, <0.288750, -0.104741, 1.778898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.425689, 0.272360, 1.770869>, <0.302183, 0.272360, 1.770869>, <0.137507, 0.272360, 1.770869>, <0.014001, 0.272360, 1.770869>, 
      <0.425689, 0.345830, 1.706404>, <0.302183, 0.345830, 1.706404>, <0.137507, 0.274776, 1.768749>, <0.014001, 0.274776, 1.768749>, 
      <0.370122, 0.446667, 1.617927>, <0.282790, 0.381022, 1.675526>, <0.099506, 0.343738, 1.708240>, <0.012173, 0.278093, 1.765839>, 
      <0.301008, 0.498618, 1.572343>, <0.213676, 0.432973, 1.629942>, <0.097232, 0.345447, 1.706741>, <0.009900, 0.279802, 1.764340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.425689, 0.272360, 1.770869>, <0.425689, 0.198890, 1.835334>, <0.370122, 0.098053, 1.923812>, <0.301008, 0.046102, 1.969396>, 
      <0.302183, 0.272360, 1.770869>, <0.302183, 0.198890, 1.835334>, <0.282790, 0.163698, 1.866213>, <0.213676, 0.111747, 1.911797>, 
      <0.137507, 0.272360, 1.770869>, <0.137507, 0.269943, 1.772989>, <0.099506, 0.200982, 1.833499>, <0.097232, 0.199273, 1.834998>, 
      <0.014001, 0.272360, 1.770869>, <0.014001, 0.269943, 1.772989>, <0.012173, 0.266627, 1.775900>, <0.009900, 0.264918, 1.777399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.425689, 0.272360, 1.770869>, <0.425689, 0.345830, 1.706404>, <0.370122, 0.446667, 1.617927>, <0.301008, 0.498618, 1.572343>, 
      <0.425689, 0.225200, 1.717122>, <0.425689, 0.298670, 1.652657>, <0.370122, 0.399507, 1.564180>, <0.301008, 0.451458, 1.518596>, 
      <0.430784, 0.162201, 1.645322>, <0.430784, 0.235671, 1.580857>, <0.373725, 0.339215, 1.490004>, <0.304611, 0.391167, 1.444421>, 
      <0.425689, 0.115161, 1.591712>, <0.425689, 0.188631, 1.527247>, <0.370122, 0.289468, 1.438770>, <0.301008, 0.341419, 1.393186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.425689, 0.272360, 1.770869>, <0.425689, 0.225200, 1.717122>, <0.430784, 0.162201, 1.645322>, <0.425689, 0.115161, 1.591712>, 
      <0.425689, 0.198890, 1.835334>, <0.425689, 0.151730, 1.781587>, <0.430784, 0.088731, 1.709787>, <0.425689, 0.041691, 1.656177>, 
      <0.370122, 0.098053, 1.923812>, <0.370122, 0.050893, 1.870065>, <0.373725, -0.014814, 1.800642>, <0.370122, -0.059146, 1.744655>, 
      <0.301008, 0.046102, 1.969396>, <0.301008, -0.001058, 1.915649>, <0.304611, -0.066765, 1.846225>, <0.301008, -0.111097, 1.790239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.404021, 0.255211, 1.751325>, <0.404021, 0.324941, 1.690141>, <0.351282, 0.420646, 1.606167>, <0.285686, 0.469953, 1.562904>, 
      <0.405321, 0.212339, 1.702464>, <0.405321, 0.282069, 1.641280>, <0.352202, 0.378465, 1.556700>, <0.286605, 0.427772, 1.513437>, 
      <0.401754, 0.154962, 1.637073>, <0.401754, 0.225441, 1.575233>, <0.350383, 0.318664, 1.493437>, <0.284083, 0.368500, 1.449709>, 
      <0.408354, 0.112303, 1.588455>, <0.408354, 0.182781, 1.526615>, <0.355050, 0.279512, 1.441740>, <0.288750, 0.329348, 1.398013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.404021, 0.255211, 1.751325>, <0.405321, 0.212339, 1.702464>, <0.401754, 0.154962, 1.637073>, <0.408354, 0.112303, 1.588455>, 
      <0.404021, 0.185481, 1.812509>, <0.405321, 0.142608, 1.763648>, <0.401754, 0.084484, 1.698913>, <0.408354, 0.041825, 1.650295>, 
      <0.351282, 0.089777, 1.896484>, <0.352202, 0.046213, 1.848229>, <0.350383, -0.008738, 1.780711>, <0.355050, -0.054905, 1.735170>, 
      <0.285686, 0.040470, 1.939747>, <0.286605, -0.003093, 1.891492>, <0.284083, -0.058574, 1.824438>, <0.288750, -0.104741, 1.778898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.142867, -0.175078, 1.137284>, <0.142867, -0.242092, 1.137284>, <0.087100, -0.297860, 1.137284>, <0.020086, -0.297860, 1.137284>, 
      <0.142867, -0.175078, 1.137284>, <0.142867, -0.175078, 1.137284>, <0.087100, -0.224191, 1.137284>, <0.020086, -0.224191, 1.137284>, 
      <0.142867, -0.175078, 1.137284>, <0.142867, -0.175078, 1.137284>, <0.087100, -0.125966, 1.137284>, <0.020086, -0.125966, 1.137284>, 
      <0.142867, -0.175078, 1.137284>, <0.142867, -0.108064, 1.137284>, <0.087100, -0.052297, 1.137284>, <0.020086, -0.052297, 1.137284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.102695, -0.175078, 1.137284>, <-0.102695, -0.108064, 1.137284>, <-0.046928, -0.052297, 1.137284>, <0.020086, -0.052297, 1.137284>, 
      <-0.102695, -0.175078, 1.137284>, <-0.102695, -0.175078, 1.137284>, <-0.046928, -0.125966, 1.137284>, <0.020086, -0.125966, 1.137284>, 
      <-0.102695, -0.175078, 1.137284>, <-0.102695, -0.175078, 1.137284>, <-0.046928, -0.224191, 1.137284>, <0.020086, -0.224191, 1.137284>, 
      <-0.102695, -0.175078, 1.137284>, <-0.102695, -0.242092, 1.137284>, <-0.046928, -0.297860, 1.137284>, <0.020086, -0.297860, 1.137284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.142867, -0.175078, 1.382846>, <0.142867, -0.242092, 1.382846>, <0.087100, -0.297860, 1.382846>, <0.020086, -0.297860, 1.382846>, 
      <0.142867, -0.175078, 1.309177>, <0.142867, -0.242092, 1.309177>, <0.087100, -0.297860, 1.309177>, <0.020086, -0.297860, 1.309177>, 
      <0.142867, -0.175078, 1.210953>, <0.142867, -0.242092, 1.210953>, <0.087100, -0.297860, 1.210953>, <0.020086, -0.297860, 1.210953>, 
      <0.142867, -0.175078, 1.137284>, <0.142867, -0.242092, 1.137284>, <0.087100, -0.297860, 1.137284>, <0.020086, -0.297860, 1.137284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.142867, -0.175078, 1.382846>, <0.142867, -0.108064, 1.382846>, <0.087100, -0.052297, 1.382846>, <0.020086, -0.052297, 1.382846>, 
      <0.142867, -0.175078, 1.382846>, <0.142867, -0.175078, 1.382846>, <0.087100, -0.125966, 1.382846>, <0.020086, -0.125966, 1.382846>, 
      <0.142867, -0.175078, 1.382846>, <0.142867, -0.175078, 1.382846>, <0.087100, -0.224191, 1.382846>, <0.020086, -0.224191, 1.382846>, 
      <0.142867, -0.175078, 1.382846>, <0.142867, -0.242092, 1.382846>, <0.087100, -0.297860, 1.382846>, <0.020086, -0.297860, 1.382846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.142867, -0.175078, 1.382846>, <0.142867, -0.175078, 1.309177>, <0.142867, -0.175078, 1.210953>, <0.142867, -0.175078, 1.137284>, 
      <0.142867, -0.108064, 1.382846>, <0.142867, -0.108064, 1.309177>, <0.142867, -0.108064, 1.210953>, <0.142867, -0.108064, 1.137284>, 
      <0.087100, -0.052297, 1.382846>, <0.087100, -0.052297, 1.309177>, <0.087100, -0.052297, 1.210953>, <0.087100, -0.052297, 1.137284>, 
      <0.020086, -0.052297, 1.382846>, <0.020086, -0.052297, 1.309177>, <0.020086, -0.052297, 1.210953>, <0.020086, -0.052297, 1.137284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.102695, -0.175078, 1.382846>, <-0.102695, -0.108064, 1.382846>, <-0.046928, -0.052297, 1.382846>, <0.020086, -0.052297, 1.382846>, 
      <-0.102695, -0.175078, 1.309177>, <-0.102695, -0.108064, 1.309177>, <-0.046928, -0.052297, 1.309177>, <0.020086, -0.052297, 1.309177>, 
      <-0.102695, -0.175078, 1.210953>, <-0.102695, -0.108064, 1.210953>, <-0.046928, -0.052297, 1.210953>, <0.020086, -0.052297, 1.210953>, 
      <-0.102695, -0.175078, 1.137284>, <-0.102695, -0.108064, 1.137284>, <-0.046928, -0.052297, 1.137284>, <0.020086, -0.052297, 1.137284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.102695, -0.175078, 1.382846>, <-0.102695, -0.175078, 1.309177>, <-0.102695, -0.175078, 1.210953>, <-0.102695, -0.175078, 1.137284>, 
      <-0.102695, -0.242092, 1.382846>, <-0.102695, -0.242092, 1.309177>, <-0.102695, -0.242092, 1.210953>, <-0.102695, -0.242092, 1.137284>, 
      <-0.046928, -0.297860, 1.382846>, <-0.046928, -0.297860, 1.309177>, <-0.046928, -0.297860, 1.210953>, <-0.046928, -0.297860, 1.137284>, 
      <0.020086, -0.297860, 1.382846>, <0.020086, -0.297860, 1.309177>, <0.020086, -0.297860, 1.210953>, <0.020086, -0.297860, 1.137284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.102695, -0.175078, 1.382846>, <-0.102695, -0.242092, 1.382846>, <-0.046928, -0.297860, 1.382846>, <0.020086, -0.297860, 1.382846>, 
      <-0.102695, -0.175078, 1.382846>, <-0.102695, -0.175078, 1.382846>, <-0.046928, -0.224191, 1.382846>, <0.020086, -0.224191, 1.382846>, 
      <-0.102695, -0.175078, 1.382846>, <-0.102695, -0.175078, 1.382846>, <-0.046928, -0.125966, 1.382846>, <0.020086, -0.125966, 1.382846>, 
      <-0.102695, -0.175078, 1.382846>, <-0.102695, -0.108064, 1.382846>, <-0.046928, -0.052297, 1.382846>, <0.020086, -0.052297, 1.382846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.420022, 1.272399>, <0.096441, -0.420022, 1.272399>, <0.228806, -0.365194, 1.272399>, <0.297000, -0.297000, 1.272399>, 
      <0.000000, -0.297616, 1.286800>, <0.096441, -0.297616, 1.286800>, <0.142252, -0.278640, 1.286800>, <0.210446, -0.210446, 1.286800>, 
      <0.000000, -0.134407, 1.306001>, <0.002756, -0.134407, 1.306001>, <0.093092, -0.096989, 1.306001>, <0.095040, -0.095040, 1.306001>, 
      <0.000000, -0.012001, 1.320402>, <0.002756, -0.012001, 1.320402>, <0.006537, -0.010434, 1.320402>, <0.008486, -0.008486, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.297000, -0.297000, 1.272399>, <-0.228806, -0.365194, 1.272399>, <-0.096441, -0.420022, 1.272399>, <0.000000, -0.420022, 1.272399>, 
      <-0.210446, -0.210446, 1.286800>, <-0.142252, -0.278640, 1.286800>, <-0.096441, -0.297616, 1.286800>, <0.000000, -0.297616, 1.286800>, 
      <-0.095040, -0.095040, 1.306001>, <-0.093092, -0.096989, 1.306001>, <-0.002756, -0.134407, 1.306001>, <0.000000, -0.134407, 1.306001>, 
      <-0.008486, -0.008486, 1.320402>, <-0.006537, -0.010434, 1.320402>, <-0.002756, -0.012001, 1.320402>, <0.000000, -0.012001, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.420022, 0.000000, 1.272399>, <-0.420022, -0.096441, 1.272399>, <-0.365194, -0.228806, 1.272399>, <-0.297000, -0.297000, 1.272399>, 
      <-0.297616, 0.000000, 1.286800>, <-0.297616, -0.096441, 1.286800>, <-0.278640, -0.142252, 1.286800>, <-0.210446, -0.210446, 1.286800>, 
      <-0.134407, 0.000000, 1.306001>, <-0.134407, -0.002756, 1.306001>, <-0.096989, -0.093092, 1.306001>, <-0.095040, -0.095040, 1.306001>, 
      <-0.012001, 0.000000, 1.320402>, <-0.012001, -0.002756, 1.320402>, <-0.010434, -0.006537, 1.320402>, <-0.008486, -0.008486, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.297000, 0.297000, 1.272399>, <-0.365194, 0.228806, 1.272399>, <-0.420022, 0.096441, 1.272399>, <-0.420022, 0.000000, 1.272399>, 
      <-0.210446, 0.210446, 1.286800>, <-0.278640, 0.142252, 1.286800>, <-0.297616, 0.096441, 1.286800>, <-0.297616, 0.000000, 1.286800>, 
      <-0.095040, 0.095040, 1.306001>, <-0.096989, 0.093092, 1.306001>, <-0.134407, 0.002756, 1.306001>, <-0.134407, 0.000000, 1.306001>, 
      <-0.008486, 0.008486, 1.320402>, <-0.010434, 0.006537, 1.320402>, <-0.012001, 0.002756, 1.320402>, <-0.012001, 0.000000, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.420022, 1.272399>, <-0.096441, 0.420022, 1.272399>, <-0.228806, 0.365194, 1.272399>, <-0.297000, 0.297000, 1.272399>, 
      <0.000000, 0.297616, 1.286800>, <-0.096441, 0.297616, 1.286800>, <-0.142252, 0.278640, 1.286800>, <-0.210446, 0.210446, 1.286800>, 
      <0.000000, 0.134407, 1.306001>, <-0.002756, 0.134407, 1.306001>, <-0.093092, 0.096989, 1.306001>, <-0.095040, 0.095040, 1.306001>, 
      <0.000000, 0.012001, 1.320402>, <-0.002756, 0.012001, 1.320402>, <-0.006537, 0.010434, 1.320402>, <-0.008486, 0.008486, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.297000, 0.297000, 1.272399>, <0.228806, 0.365194, 1.272399>, <0.096441, 0.420022, 1.272399>, <0.000000, 0.420022, 1.272399>, 
      <0.210446, 0.210446, 1.286800>, <0.142252, 0.278640, 1.286800>, <0.096441, 0.297616, 1.286800>, <0.000000, 0.297616, 1.286800>, 
      <0.095040, 0.095040, 1.306001>, <0.093092, 0.096989, 1.306001>, <0.002756, 0.134407, 1.306001>, <0.000000, 0.134407, 1.306001>, 
      <0.008486, 0.008486, 1.320402>, <0.006537, 0.010434, 1.320402>, <0.002756, 0.012001, 1.320402>, <0.000000, 0.012001, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.408021, 0.924382>, <0.093686, -0.408021, 0.924382>, <0.222269, -0.354760, 0.924382>, <0.288515, -0.288514, 0.924382>, 
      <0.000000, -0.411621, 1.028787>, <0.093686, -0.411621, 1.028787>, <0.224815, -0.357306, 1.028787>, <0.291061, -0.291060, 1.028787>, 
      <0.000000, -0.416422, 1.167994>, <0.096441, -0.416422, 1.167994>, <0.226260, -0.362648, 1.167994>, <0.294455, -0.294454, 1.167994>, 
      <0.000000, -0.420022, 1.272399>, <0.096441, -0.420022, 1.272399>, <0.228806, -0.365194, 1.272399>, <0.297000, -0.297000, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288514, -0.288514, 0.924382>, <-0.222268, -0.354760, 0.924382>, <-0.093686, -0.408021, 0.924382>, <0.000000, -0.408021, 0.924382>, 
      <-0.291060, -0.291060, 1.028787>, <-0.224814, -0.357306, 1.028787>, <-0.093686, -0.411621, 1.028787>, <0.000000, -0.411621, 1.028787>, 
      <-0.294454, -0.294454, 1.167994>, <-0.226260, -0.362648, 1.167994>, <-0.096441, -0.416422, 1.167994>, <0.000000, -0.416422, 1.167994>, 
      <-0.297000, -0.297000, 1.272399>, <-0.228806, -0.365194, 1.272399>, <-0.096441, -0.420022, 1.272399>, <0.000000, -0.420022, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.408021, 0.000000, 0.924382>, <-0.408021, -0.093686, 0.924382>, <-0.354760, -0.222268, 0.924382>, <-0.288514, -0.288514, 0.924382>, 
      <-0.411621, 0.000000, 1.028787>, <-0.411621, -0.093686, 1.028787>, <-0.357306, -0.224814, 1.028787>, <-0.291060, -0.291060, 1.028787>, 
      <-0.416422, 0.000000, 1.167994>, <-0.416422, -0.096441, 1.167994>, <-0.362648, -0.226260, 1.167994>, <-0.294454, -0.294454, 1.167994>, 
      <-0.420022, 0.000000, 1.272399>, <-0.420022, -0.096441, 1.272399>, <-0.365194, -0.228806, 1.272399>, <-0.297000, -0.297000, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288514, 0.288514, 0.924382>, <-0.354760, 0.222268, 0.924382>, <-0.408021, 0.093686, 0.924382>, <-0.408021, 0.000000, 0.924382>, 
      <-0.291060, 0.291060, 1.028787>, <-0.357306, 0.224814, 1.028787>, <-0.411621, 0.093686, 1.028787>, <-0.411621, 0.000000, 1.028787>, 
      <-0.294454, 0.294454, 1.167994>, <-0.362648, 0.226260, 1.167994>, <-0.416422, 0.096441, 1.167994>, <-0.416422, 0.000000, 1.167994>, 
      <-0.297000, 0.297000, 1.272399>, <-0.365194, 0.228806, 1.272399>, <-0.420022, 0.096441, 1.272399>, <-0.420022, 0.000000, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.408021, 0.924382>, <-0.093686, 0.408021, 0.924382>, <-0.222268, 0.354760, 0.924382>, <-0.288514, 0.288514, 0.924382>, 
      <0.000000, 0.411621, 1.028787>, <-0.093686, 0.411621, 1.028787>, <-0.224814, 0.357306, 1.028787>, <-0.291060, 0.291060, 1.028787>, 
      <0.000000, 0.416422, 1.167994>, <-0.096441, 0.416422, 1.167994>, <-0.226260, 0.362648, 1.167994>, <-0.294454, 0.294454, 1.167994>, 
      <0.000000, 0.420022, 1.272399>, <-0.096441, 0.420022, 1.272399>, <-0.228806, 0.365194, 1.272399>, <-0.297000, 0.297000, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.288514, 0.288514, 0.924382>, <0.222268, 0.354760, 0.924382>, <0.093686, 0.408021, 0.924382>, <0.000000, 0.408021, 0.924382>, 
      <0.291060, 0.291060, 1.028787>, <0.224814, 0.357306, 1.028787>, <0.093686, 0.411621, 1.028787>, <0.000000, 0.411621, 1.028787>, 
      <0.294454, 0.294454, 1.167994>, <0.226260, 0.362648, 1.167994>, <0.096441, 0.416422, 1.167994>, <0.000000, 0.416422, 1.167994>, 
      <0.297000, 0.297000, 1.272399>, <0.228806, 0.365194, 1.272399>, <0.096441, 0.420022, 1.272399>, <0.000000, 0.420022, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.360018, 1.188396>, <0.082664, -0.360018, 1.188396>, <0.196120, -0.313023, 1.188396>, <0.254572, -0.254571, 1.188396>, 
      <0.000000, -0.374419, 1.109192>, <0.082664, -0.374419, 1.109192>, <0.206303, -0.323206, 1.109192>, <0.264755, -0.264754, 1.109192>, 
      <0.000000, -0.393620, 1.003586>, <0.093686, -0.393620, 1.003586>, <0.212086, -0.344577, 1.003586>, <0.278332, -0.278331, 1.003586>, 
      <0.000000, -0.408021, 0.924382>, <0.093686, -0.408021, 0.924382>, <0.222269, -0.354760, 0.924382>, <0.288515, -0.288514, 0.924382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.254571, -0.254572, 1.188396>, <-0.196119, -0.313024, 1.188396>, <-0.082664, -0.360018, 1.188396>, <0.000000, -0.360018, 1.188396>, 
      <-0.264754, -0.264755, 1.109192>, <-0.206302, -0.323207, 1.109192>, <-0.082664, -0.374419, 1.109192>, <0.000000, -0.374419, 1.109192>, 
      <-0.278331, -0.278331, 1.003586>, <-0.212085, -0.344577, 1.003586>, <-0.093686, -0.393620, 1.003586>, <0.000000, -0.393620, 1.003586>, 
      <-0.288514, -0.288514, 0.924382>, <-0.222268, -0.354760, 0.924382>, <-0.093686, -0.408021, 0.924382>, <0.000000, -0.408021, 0.924382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.360018, 0.000000, 1.188396>, <-0.360018, -0.082664, 1.188396>, <-0.313023, -0.196120, 1.188396>, <-0.254571, -0.254572, 1.188396>, 
      <-0.374419, 0.000000, 1.109192>, <-0.374419, -0.082664, 1.109192>, <-0.323206, -0.206302, 1.109192>, <-0.264754, -0.264755, 1.109192>, 
      <-0.393620, 0.000000, 1.003586>, <-0.393620, -0.093686, 1.003586>, <-0.344577, -0.212086, 1.003586>, <-0.278331, -0.278331, 1.003586>, 
      <-0.408021, 0.000000, 0.924382>, <-0.408021, -0.093686, 0.924382>, <-0.354760, -0.222268, 0.924382>, <-0.288514, -0.288514, 0.924382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.254571, 0.254571, 1.188396>, <-0.313023, 0.196119, 1.188396>, <-0.360018, 0.082664, 1.188396>, <-0.360018, 0.000000, 1.188396>, 
      <-0.264754, 0.264754, 1.109192>, <-0.323206, 0.206302, 1.109192>, <-0.374419, 0.082664, 1.109192>, <-0.374419, 0.000000, 1.109192>, 
      <-0.278331, 0.278331, 1.003586>, <-0.344577, 0.212085, 1.003586>, <-0.393620, 0.093686, 1.003586>, <-0.393620, 0.000000, 1.003586>, 
      <-0.288514, 0.288514, 0.924382>, <-0.354760, 0.222268, 0.924382>, <-0.408021, 0.093686, 0.924382>, <-0.408021, 0.000000, 0.924382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.360018, 1.188396>, <-0.082664, 0.360018, 1.188396>, <-0.196119, 0.313023, 1.188396>, <-0.254571, 0.254571, 1.188396>, 
      <0.000000, 0.374419, 1.109192>, <-0.082664, 0.374419, 1.109192>, <-0.206302, 0.323206, 1.109192>, <-0.264754, 0.264754, 1.109192>, 
      <0.000000, 0.393620, 1.003586>, <-0.093686, 0.393620, 1.003586>, <-0.212085, 0.344577, 1.003586>, <-0.278331, 0.278331, 1.003586>, 
      <0.000000, 0.408021, 0.924382>, <-0.093686, 0.408021, 0.924382>, <-0.222268, 0.354760, 0.924382>, <-0.288514, 0.288514, 0.924382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254571, 0.254571, 1.188396>, <0.196119, 0.313023, 1.188396>, <0.082664, 0.360018, 1.188396>, <0.000000, 0.360018, 1.188396>, 
      <0.264754, 0.264754, 1.109192>, <0.206302, 0.323206, 1.109192>, <0.082664, 0.374419, 1.109192>, <0.000000, 0.374419, 1.109192>, 
      <0.278331, 0.278331, 1.003586>, <0.212085, 0.344577, 1.003586>, <0.093686, 0.393620, 1.003586>, <0.000000, 0.393620, 1.003586>, 
      <0.288514, 0.288514, 0.924382>, <0.222268, 0.354760, 0.924382>, <0.093686, 0.408021, 0.924382>, <0.000000, 0.408021, 0.924382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.420022, 0.000000, 1.272399>, <0.420022, 0.096441, 1.272399>, <0.365194, 0.228806, 1.272399>, <0.297000, 0.297000, 1.272399>, 
      <0.297616, 0.000000, 1.286800>, <0.297616, 0.096441, 1.286800>, <0.278640, 0.142252, 1.286800>, <0.210446, 0.210446, 1.286800>, 
      <0.134407, 0.000000, 1.306001>, <0.134407, 0.002756, 1.306001>, <0.096989, 0.093092, 1.306001>, <0.095040, 0.095040, 1.306001>, 
      <0.012001, 0.000000, 1.320402>, <0.012001, 0.002756, 1.320402>, <0.010434, 0.006537, 1.320402>, <0.008486, 0.008486, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.420022, 0.000000, 1.272399>, <0.297616, 0.000000, 1.286800>, <0.134407, 0.000000, 1.306001>, <0.012001, 0.000000, 1.320402>, 
      <0.420022, -0.096441, 1.272399>, <0.297616, -0.096441, 1.286800>, <0.134407, -0.002756, 1.306001>, <0.012001, -0.002756, 1.320402>, 
      <0.365194, -0.228806, 1.272399>, <0.278640, -0.142252, 1.286800>, <0.096989, -0.093092, 1.306001>, <0.010434, -0.006537, 1.320402>, 
      <0.297000, -0.297000, 1.272399>, <0.210446, -0.210446, 1.286800>, <0.095040, -0.095040, 1.306001>, <0.008486, -0.008486, 1.320402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.408021, 0.000000, 0.924382>, <0.408021, 0.093686, 0.924382>, <0.354760, 0.222268, 0.924382>, <0.288514, 0.288514, 0.924382>, 
      <0.411621, 0.000000, 1.028787>, <0.411621, 0.093686, 1.028787>, <0.357306, 0.224814, 1.028787>, <0.291060, 0.291060, 1.028787>, 
      <0.416422, 0.000000, 1.167994>, <0.416422, 0.096441, 1.167994>, <0.362648, 0.226260, 1.167994>, <0.294454, 0.294454, 1.167994>, 
      <0.420022, 0.000000, 1.272399>, <0.420022, 0.096441, 1.272399>, <0.365194, 0.228806, 1.272399>, <0.297000, 0.297000, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.408021, 0.000000, 0.924382>, <0.411621, 0.000000, 1.028787>, <0.416422, 0.000000, 1.167994>, <0.420022, 0.000000, 1.272399>, 
      <0.408021, -0.093686, 0.924382>, <0.411621, -0.093686, 1.028787>, <0.416422, -0.096441, 1.167994>, <0.420022, -0.096441, 1.272399>, 
      <0.354761, -0.222268, 0.924382>, <0.357306, -0.224814, 1.028787>, <0.362649, -0.226260, 1.167994>, <0.365194, -0.228806, 1.272399>, 
      <0.288515, -0.288514, 0.924382>, <0.291061, -0.291060, 1.028787>, <0.294455, -0.294454, 1.167994>, <0.297000, -0.297000, 1.272399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.360018, 0.000000, 1.188396>, <0.360018, 0.082664, 1.188396>, <0.313023, 0.196119, 1.188396>, <0.254571, 0.254571, 1.188396>, 
      <0.374419, 0.000000, 1.109192>, <0.374419, 0.082664, 1.109192>, <0.323206, 0.206302, 1.109192>, <0.264754, 0.264754, 1.109192>, 
      <0.393620, 0.000000, 1.003586>, <0.393620, 0.093686, 1.003586>, <0.344577, 0.212085, 1.003586>, <0.278331, 0.278331, 1.003586>, 
      <0.408021, 0.000000, 0.924382>, <0.408021, 0.093686, 0.924382>, <0.354760, 0.222268, 0.924382>, <0.288514, 0.288514, 0.924382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.360018, 0.000000, 1.188396>, <0.374419, 0.000000, 1.109192>, <0.393620, 0.000000, 1.003586>, <0.408021, 0.000000, 0.924382>, 
      <0.360018, -0.082664, 1.188396>, <0.374419, -0.082664, 1.109192>, <0.393620, -0.093686, 1.003586>, <0.408021, -0.093686, 0.924382>, 
      <0.313024, -0.196119, 1.188396>, <0.323207, -0.206302, 1.109192>, <0.344578, -0.212085, 1.003586>, <0.354761, -0.222268, 0.924382>, 
      <0.254572, -0.254571, 1.188396>, <0.264755, -0.264754, 1.109192>, <0.278332, -0.278331, 1.003586>, <0.288515, -0.288514, 0.924382>
    }
  }
  material {
    White_Plastic
  }
}
#declare sPatchObj5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006418, -0.482452, -0.319483>, <-0.104091, -0.479393, -0.322068>, <-0.251705, -0.491698, -0.339599>, <-0.361488, -0.478622, -0.341830>, 
      <0.004926, -0.510747, -0.622521>, <-0.105583, -0.507688, -0.625107>, <-0.225943, -0.521757, -0.637632>, <-0.335726, -0.508681, -0.639863>, 
      <0.002530, -0.510998, -1.029072>, <-0.107713, -0.511657, -1.027936>, <-0.254865, -0.500460, -1.041141>, <-0.363353, -0.480949, -1.043343>, 
      <0.000863, -0.523232, -1.333182>, <-0.109380, -0.523891, -1.332045>, <-0.255664, -0.501458, -1.341789>, <-0.364152, -0.481947, -1.343991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006418, -0.482452, -0.319483>, <0.095458, -0.484917, -0.317400>, <0.214617, -0.508315, -0.324535>, <0.302979, -0.497014, -0.326286>, 
      <0.004926, -0.510747, -0.622521>, <0.093966, -0.513211, -0.620439>, <0.194933, -0.538246, -0.631239>, <0.283295, -0.526945, -0.632990>, 
      <0.002530, -0.510998, -1.029072>, <0.120024, -0.510296, -1.030284>, <0.248109, -0.505475, -1.041838>, <0.363481, -0.483315, -1.044118>, 
      <0.000863, -0.523232, -1.333182>, <0.118358, -0.522530, -1.334393>, <0.274038, -0.499604, -1.349480>, <0.389410, -0.477444, -1.351760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.010059, -0.348822, 0.534753>, <-0.164155, -0.348822, 0.534753>, <-0.349229, -0.328435, 0.345708>, <-0.503209, -0.319698, 0.264689>, 
      <0.008967, -0.388911, 0.278482>, <-0.165247, -0.388911, 0.278482>, <-0.162202, -0.375144, 0.340424>, <-0.316182, -0.366407, 0.259405>, 
      <0.007690, -0.458338, -0.061220>, <-0.102819, -0.455279, -0.063805>, <-0.268230, -0.472417, -0.148435>, <-0.378013, -0.459342, -0.150666>, 
      <0.006418, -0.482452, -0.319483>, <-0.104091, -0.479393, -0.322068>, <-0.251705, -0.491698, -0.339599>, <-0.361488, -0.478622, -0.341830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.010059, -0.348822, 0.534753>, <0.176325, -0.348822, 0.534753>, <0.348223, -0.328435, 0.345708>, <0.493151, -0.319698, 0.264688>, 
      <0.008967, -0.388911, 0.278482>, <0.175233, -0.388911, 0.278482>, <0.160829, -0.377318, 0.348980>, <0.305756, -0.368581, 0.267961>, 
      <0.007690, -0.458338, -0.061220>, <0.096730, -0.460802, -0.059137>, <0.226964, -0.489541, -0.132150>, <0.315326, -0.478239, -0.133901>, 
      <0.006418, -0.482452, -0.319483>, <0.095458, -0.484917, -0.317400>, <0.214617, -0.508315, -0.324535>, <0.302979, -0.497014, -0.326286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.697767, -0.394031, -0.333181>, <0.735366, -0.407197, -0.634675>, <0.695218, -0.391262, -1.042770>, <0.694126, -0.390075, -1.346880>, 
      <0.579331, -0.424926, -0.331112>, <0.616929, -0.438092, -0.632606>, <0.603804, -0.417473, -1.044234>, <0.602711, -0.416286, -1.348344>, 
      <0.424384, -0.481487, -0.328691>, <0.404700, -0.511417, -0.635395>, <0.456865, -0.465378, -1.045963>, <0.482795, -0.459507, -1.353605>, 
      <0.302979, -0.497014, -0.326286>, <0.283295, -0.526945, -0.632990>, <0.363481, -0.483315, -1.044118>, <0.389410, -0.477444, -1.351760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.697767, -0.394031, -0.333181>, <0.579331, -0.424926, -0.331112>, <0.424384, -0.481487, -0.328691>, <0.302979, -0.497014, -0.326286>, 
      <0.697767, -0.394031, -0.333181>, <0.555731, -0.416662, -0.141876>, <0.436731, -0.462712, -0.136306>, <0.315326, -0.478239, -0.133901>, 
      <0.697767, -0.394031, -0.333181>, <0.555731, -0.416662, -0.141876>, <0.490430, -0.320408, 0.264736>, <0.305756, -0.368581, 0.267961>, 
      <0.697767, -0.394031, -0.333181>, <0.674168, -0.385767, -0.143945>, <0.677825, -0.271525, 0.261463>, <0.493151, -0.319698, 0.264688>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.667593, -0.402174, -0.333181>, <-0.699604, -0.417572, -0.635215>, <-0.672086, -0.401954, -1.042770>, <-0.674011, -0.401859, -1.346879>, 
      <-0.575762, -0.425108, -0.335776>, <-0.607773, -0.440507, -0.637810>, <-0.579128, -0.425980, -1.041903>, <-0.581053, -0.425885, -1.346013>, 
      <-0.455492, -0.467426, -0.343740>, <-0.429729, -0.497485, -0.641774>, <-0.457834, -0.463958, -1.045260>, <-0.458634, -0.464955, -1.345909>, 
      <-0.361488, -0.478622, -0.341830>, <-0.335726, -0.508681, -0.639863>, <-0.363353, -0.480949, -1.043343>, <-0.364152, -0.481947, -1.343991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.667593, -0.402174, -0.333181>, <-0.575762, -0.425108, -0.335776>, <-0.455492, -0.467426, -0.343740>, <-0.361488, -0.478622, -0.341830>, 
      <-0.667593, -0.402174, -0.333181>, <-0.556009, -0.415607, -0.149405>, <-0.472017, -0.448145, -0.152576>, <-0.378013, -0.459342, -0.150666>, 
      <-0.667593, -0.402174, -0.333181>, <-0.556009, -0.415607, -0.149405>, <-0.498177, -0.320955, 0.264547>, <-0.316182, -0.366407, 0.259405>, 
      <-0.667593, -0.402174, -0.333181>, <-0.647841, -0.392672, -0.146810>, <-0.685204, -0.274246, 0.269831>, <-0.503209, -0.319698, 0.264689>
    }
  }
  material {
    Stroielabel
    scale <1.412683, 1.861743, 0.992159>
    rotate 90.521286*x
    translate <-0.703988, -0.525554, -1.347288>
  }
}
#declare Syrupyies = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.441019, -0.356592>, <0.000000, -0.430632, -0.356592>, <0.000000, -0.338954, -0.356592>, <0.000000, -0.005803, -0.356591>, 
      <0.193767, -0.441019, -0.356592>, <0.193767, -0.430632, -0.356592>, <0.002550, -0.338954, -0.356592>, <0.002550, -0.005803, -0.356591>, 
      <0.459032, -0.397497, -0.356592>, <0.444127, -0.390152, -0.356592>, <0.484096, -0.240804, -0.356592>, <0.006040, -0.005230, -0.356591>, 
      <0.632842, -0.311848, -0.356592>, <0.617937, -0.304503, -0.356592>, <0.486383, -0.239677, -0.356592>, <0.008327, -0.004103, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.632842, -0.311848, -0.356592>, <-0.617937, -0.304503, -0.356592>, <-0.486383, -0.239677, -0.356592>, <-0.008327, -0.004103, -0.356591>, 
      <-0.459032, -0.397497, -0.356592>, <-0.444127, -0.390152, -0.356592>, <-0.484096, -0.240804, -0.356592>, <-0.006040, -0.005230, -0.356591>, 
      <-0.193767, -0.441019, -0.356592>, <-0.193767, -0.430632, -0.356592>, <-0.002550, -0.338954, -0.356592>, <-0.002550, -0.005803, -0.356591>, 
      <0.000000, -0.441019, -0.356592>, <0.000000, -0.430632, -0.356592>, <0.000000, -0.338954, -0.356592>, <0.000000, -0.005803, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.894974, 0.000000, -0.356592>, <-0.873896, 0.000000, -0.356592>, <-0.687849, 0.000000, -0.356592>, <-0.011776, 0.000000, -0.356591>, 
      <-0.894974, -0.122215, -0.356592>, <-0.873896, -0.122215, -0.356592>, <-0.687849, -0.001608, -0.356592>, <-0.011776, -0.001608, -0.356591>, 
      <-0.742470, -0.257826, -0.356592>, <-0.727565, -0.250482, -0.356592>, <-0.487825, -0.238966, -0.356592>, <-0.009769, -0.003392, -0.356591>, 
      <-0.632842, -0.311848, -0.356592>, <-0.617937, -0.304503, -0.356592>, <-0.486383, -0.239677, -0.356592>, <-0.008327, -0.004103, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.632842, 0.311848, -0.356592>, <-0.617937, 0.304503, -0.356592>, <-0.486383, 0.239677, -0.356592>, <-0.008327, 0.004103, -0.356591>, 
      <-0.742470, 0.257826, -0.356592>, <-0.727565, 0.250482, -0.356592>, <-0.487825, 0.238966, -0.356592>, <-0.009769, 0.003392, -0.356591>, 
      <-0.894974, 0.122215, -0.356592>, <-0.873896, 0.122215, -0.356592>, <-0.687849, 0.001608, -0.356592>, <-0.011776, 0.001608, -0.356591>, 
      <-0.894974, 0.000000, -0.356592>, <-0.873896, 0.000000, -0.356592>, <-0.687849, 0.000000, -0.356592>, <-0.011776, 0.000000, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.441019, -0.356592>, <0.000000, 0.430632, -0.356592>, <0.000000, 0.338954, -0.356592>, <0.000000, 0.005803, -0.356591>, 
      <-0.193767, 0.441019, -0.356592>, <-0.193767, 0.430632, -0.356592>, <-0.002550, 0.338954, -0.356592>, <-0.002550, 0.005803, -0.356591>, 
      <-0.459032, 0.397497, -0.356592>, <-0.444127, 0.390152, -0.356592>, <-0.484096, 0.240804, -0.356592>, <-0.006040, 0.005230, -0.356591>, 
      <-0.632842, 0.311848, -0.356592>, <-0.617937, 0.304503, -0.356592>, <-0.486383, 0.239677, -0.356592>, <-0.008327, 0.004103, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.632842, 0.311848, -0.356592>, <0.617937, 0.304503, -0.356592>, <0.486383, 0.239677, -0.356592>, <0.008327, 0.004103, -0.356591>, 
      <0.459032, 0.397497, -0.356592>, <0.444127, 0.390152, -0.356592>, <0.484096, 0.240804, -0.356592>, <0.006040, 0.005230, -0.356591>, 
      <0.193767, 0.441019, -0.356592>, <0.193767, 0.430632, -0.356592>, <0.002550, 0.338954, -0.356592>, <0.002550, 0.005803, -0.356591>, 
      <0.000000, 0.441019, -0.356592>, <0.000000, 0.430632, -0.356592>, <0.000000, 0.338954, -0.356592>, <0.000000, 0.005803, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.464231, -0.546278>, <0.000000, -0.461561, -0.489010>, <0.000000, -0.441573, -0.361119>, <0.000000, -0.441019, -0.356592>, 
      <0.203966, -0.464231, -0.546278>, <0.203966, -0.461561, -0.489010>, <0.193767, -0.441573, -0.361119>, <0.193767, -0.441019, -0.356592>, 
      <0.483192, -0.418417, -0.546278>, <0.479324, -0.416511, -0.488453>, <0.459827, -0.397889, -0.361119>, <0.459032, -0.397497, -0.356592>, 
      <0.666150, -0.328260, -0.546278>, <0.662282, -0.326354, -0.488453>, <0.633637, -0.312240, -0.361119>, <0.632842, -0.311848, -0.356592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.666149, -0.328261, -0.546278>, <-0.662281, -0.326355, -0.488453>, <-0.633637, -0.312240, -0.361119>, <-0.632842, -0.311848, -0.356592>, 
      <-0.483191, -0.418418, -0.546278>, <-0.479323, -0.416512, -0.488453>, <-0.459827, -0.397889, -0.361119>, <-0.459032, -0.397497, -0.356592>, 
      <-0.203965, -0.464231, -0.546278>, <-0.203965, -0.461562, -0.489010>, <-0.193767, -0.441573, -0.361119>, <-0.193767, -0.441019, -0.356592>, 
      <0.000000, -0.464231, -0.546278>, <0.000000, -0.461561, -0.489010>, <0.000000, -0.441573, -0.361119>, <0.000000, -0.441019, -0.356592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.942078, 0.000000, -0.546278>, <-0.936556, 0.000000, -0.487905>, <-0.896098, 0.000000, -0.361119>, <-0.894974, 0.000000, -0.356592>, 
      <-0.942078, -0.128648, -0.546278>, <-0.936556, -0.128648, -0.487905>, <-0.896098, -0.122215, -0.361119>, <-0.894974, -0.122215, -0.356592>, 
      <-0.781547, -0.271396, -0.546278>, <-0.777679, -0.269490, -0.488453>, <-0.743265, -0.258218, -0.361119>, <-0.742470, -0.257826, -0.356592>, 
      <-0.666149, -0.328261, -0.546278>, <-0.662281, -0.326355, -0.488453>, <-0.633637, -0.312240, -0.361119>, <-0.632842, -0.311848, -0.356592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.666150, 0.328261, -0.546278>, <-0.662282, 0.326355, -0.488453>, <-0.633637, 0.312240, -0.361119>, <-0.632842, 0.311848, -0.356592>, 
      <-0.781548, 0.271396, -0.546278>, <-0.777680, 0.269490, -0.488453>, <-0.743265, 0.258218, -0.361119>, <-0.742470, 0.257826, -0.356592>, 
      <-0.942078, 0.128648, -0.546278>, <-0.936556, 0.128648, -0.487905>, <-0.896098, 0.122215, -0.361119>, <-0.894974, 0.122215, -0.356592>, 
      <-0.942078, 0.000000, -0.546278>, <-0.936556, 0.000000, -0.487905>, <-0.896098, 0.000000, -0.361119>, <-0.894974, 0.000000, -0.356592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.464231, -0.546278>, <0.000000, 0.461561, -0.489010>, <0.000000, 0.441573, -0.361119>, <0.000000, 0.441019, -0.356592>, 
      <-0.203965, 0.464231, -0.546278>, <-0.203965, 0.461561, -0.489010>, <-0.193767, 0.441573, -0.361119>, <-0.193767, 0.441019, -0.356592>, 
      <-0.483192, 0.418418, -0.546278>, <-0.479324, 0.416512, -0.488453>, <-0.459827, 0.397889, -0.361119>, <-0.459032, 0.397497, -0.356592>, 
      <-0.666150, 0.328261, -0.546278>, <-0.662282, 0.326355, -0.488453>, <-0.633637, 0.312240, -0.361119>, <-0.632842, 0.311848, -0.356592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.666149, 0.328261, -0.546278>, <0.662281, 0.326355, -0.488453>, <0.633637, 0.312240, -0.361119>, <0.632842, 0.311848, -0.356592>, 
      <0.483191, 0.418418, -0.546278>, <0.479323, 0.416512, -0.488453>, <0.459827, 0.397889, -0.361119>, <0.459032, 0.397497, -0.356592>, 
      <0.203965, 0.464231, -0.546278>, <0.203965, 0.461561, -0.489010>, <0.193767, 0.441573, -0.361119>, <0.193767, 0.441019, -0.356592>, 
      <0.000000, 0.464231, -0.546278>, <0.000000, 0.461561, -0.489010>, <0.000000, 0.441573, -0.361119>, <0.000000, 0.441019, -0.356592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.487442, -1.352444>, <0.000000, -0.501469, -1.110901>, <0.000000, -0.475498, -0.787966>, <0.000000, -0.464231, -0.546278>, 
      <0.214164, -0.487442, -1.352444>, <0.214164, -0.501469, -1.110901>, <0.203966, -0.475498, -0.787966>, <0.203966, -0.464231, -0.546278>, 
      <0.507352, -0.439339, -1.352444>, <0.527440, -0.449238, -1.111376>, <0.499342, -0.426375, -0.787714>, <0.483192, -0.418417, -0.546278>, 
      <0.699458, -0.344674, -1.352444>, <0.719547, -0.354573, -1.111376>, <0.682300, -0.336218, -0.787714>, <0.666150, -0.328260, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.699457, -0.344674, -1.352444>, <-0.719545, -0.354573, -1.111376>, <-0.682299, -0.336219, -0.787714>, <-0.666149, -0.328261, -0.546278>, 
      <-0.507351, -0.439339, -1.352444>, <-0.527440, -0.449238, -1.111376>, <-0.499341, -0.426376, -0.787714>, <-0.483191, -0.418418, -0.546278>, 
      <-0.214164, -0.487442, -1.352444>, <-0.214164, -0.501469, -1.110901>, <-0.203965, -0.475498, -0.787966>, <-0.203965, -0.464231, -0.546278>, 
      <0.000000, -0.487442, -1.352444>, <0.000000, -0.501469, -1.110901>, <0.000000, -0.475498, -0.787966>, <0.000000, -0.464231, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.989182, 0.000000, -1.352444>, <-1.017536, 0.000000, -1.111847>, <-0.964894, 0.000000, -0.787463>, <-0.942078, 0.000000, -0.546278>, 
      <-0.989182, -0.135080, -1.352444>, <-1.017536, -0.135080, -1.111847>, <-0.964894, -0.128648, -0.787463>, <-0.942078, -0.128648, -0.546278>, 
      <-0.820625, -0.284966, -1.352444>, <-0.840713, -0.294865, -1.111376>, <-0.797697, -0.279354, -0.787714>, <-0.781547, -0.271396, -0.546278>, 
      <-0.699457, -0.344674, -1.352444>, <-0.719545, -0.354573, -1.111376>, <-0.682299, -0.336219, -0.787714>, <-0.666149, -0.328261, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.699457, 0.344674, -1.352444>, <-0.719546, 0.354573, -1.111376>, <-0.682300, 0.336219, -0.787714>, <-0.666150, 0.328261, -0.546278>, 
      <-0.820625, 0.284966, -1.352444>, <-0.840713, 0.294865, -1.111376>, <-0.797698, 0.279355, -0.787714>, <-0.781548, 0.271396, -0.546278>, 
      <-0.989182, 0.135080, -1.352444>, <-1.017536, 0.135080, -1.111847>, <-0.964894, 0.128648, -0.787463>, <-0.942078, 0.128648, -0.546278>, 
      <-0.989182, 0.000000, -1.352444>, <-1.017536, 0.000000, -1.111847>, <-0.964894, 0.000000, -0.787463>, <-0.942078, 0.000000, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.487442, -1.352444>, <0.000000, 0.501469, -1.110901>, <0.000000, 0.475498, -0.787966>, <0.000000, 0.464231, -0.546278>, 
      <-0.214164, 0.487442, -1.352444>, <-0.214164, 0.501469, -1.110901>, <-0.203965, 0.475498, -0.787966>, <-0.203965, 0.464231, -0.546278>, 
      <-0.507351, 0.439339, -1.352444>, <-0.527440, 0.449238, -1.111376>, <-0.499342, 0.426376, -0.787714>, <-0.483192, 0.418418, -0.546278>, 
      <-0.699457, 0.344674, -1.352444>, <-0.719546, 0.354573, -1.111376>, <-0.682300, 0.336219, -0.787714>, <-0.666150, 0.328261, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.699457, 0.344674, -1.352444>, <0.719545, 0.354573, -1.111376>, <0.682299, 0.336219, -0.787714>, <0.666149, 0.328261, -0.546278>, 
      <0.507351, 0.439339, -1.352444>, <0.527440, 0.449238, -1.111376>, <0.499341, 0.426376, -0.787714>, <0.483191, 0.418418, -0.546278>, 
      <0.214164, 0.487442, -1.352444>, <0.214164, 0.501469, -1.110901>, <0.203965, 0.475498, -0.787966>, <0.203965, 0.464231, -0.546278>, 
      <0.000000, 0.487442, -1.352444>, <0.000000, 0.501469, -1.110901>, <0.000000, 0.475498, -0.787966>, <0.000000, 0.464231, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.382990, -1.945214>, <0.000000, -0.414326, -1.767383>, <0.000000, -0.476973, -1.532711>, <0.000000, -0.487442, -1.352444>, 
      <0.168272, -0.382990, -1.945214>, <0.168272, -0.414326, -1.767383>, <0.214164, -0.476973, -1.532711>, <0.214164, -0.487442, -1.352444>, 
      <0.398633, -0.345194, -1.945214>, <0.443599, -0.367352, -1.767383>, <0.492021, -0.431784, -1.536413>, <0.507352, -0.439339, -1.352444>, 
      <0.549574, -0.270815, -1.945214>, <0.594539, -0.292973, -1.767383>, <0.684128, -0.337120, -1.536413>, <0.699458, -0.344674, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.549574, -0.270815, -1.945214>, <-0.594539, -0.292973, -1.767383>, <-0.684127, -0.337120, -1.536413>, <-0.699457, -0.344674, -1.352444>, 
      <-0.398633, -0.345194, -1.945214>, <-0.443598, -0.367352, -1.767383>, <-0.492021, -0.431784, -1.536413>, <-0.507351, -0.439339, -1.352444>, 
      <-0.168272, -0.382990, -1.945214>, <-0.168272, -0.414326, -1.767383>, <-0.214164, -0.476973, -1.532711>, <-0.214164, -0.487442, -1.352444>, 
      <0.000000, -0.382990, -1.945214>, <0.000000, -0.414326, -1.767383>, <0.000000, -0.476973, -1.532711>, <0.000000, -0.487442, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.777215, 0.000000, -1.945214>, <-0.840805, 0.000000, -1.767383>, <-0.967078, 0.000000, -1.540005>, <-0.989182, 0.000000, -1.352444>, 
      <-0.777215, -0.106134, -1.945214>, <-0.840805, -0.106134, -1.767383>, <-0.967078, -0.135080, -1.540005>, <-0.989182, -0.135080, -1.352444>, 
      <-0.644777, -0.223902, -1.945214>, <-0.689742, -0.246059, -1.767383>, <-0.805294, -0.277411, -1.536413>, <-0.820625, -0.284966, -1.352444>, 
      <-0.549574, -0.270815, -1.945214>, <-0.594539, -0.292973, -1.767383>, <-0.684127, -0.337120, -1.536413>, <-0.699457, -0.344674, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.549574, 0.270815, -1.945214>, <-0.594539, 0.292973, -1.767383>, <-0.684126, 0.337120, -1.536413>, <-0.699457, 0.344674, -1.352444>, 
      <-0.644777, 0.223902, -1.945214>, <-0.689742, 0.246059, -1.767383>, <-0.805294, 0.277411, -1.536413>, <-0.820625, 0.284966, -1.352444>, 
      <-0.777215, 0.106134, -1.945214>, <-0.840805, 0.106134, -1.767383>, <-0.967078, 0.135080, -1.540005>, <-0.989182, 0.135080, -1.352444>, 
      <-0.777215, 0.000000, -1.945214>, <-0.840805, 0.000000, -1.767383>, <-0.967078, 0.000000, -1.540005>, <-0.989182, 0.000000, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.382990, -1.945214>, <0.000000, 0.414326, -1.767383>, <0.000000, 0.476973, -1.532711>, <0.000000, 0.487442, -1.352444>, 
      <-0.168272, 0.382990, -1.945214>, <-0.168272, 0.414326, -1.767383>, <-0.214164, 0.476973, -1.532711>, <-0.214164, 0.487442, -1.352444>, 
      <-0.398633, 0.345194, -1.945214>, <-0.443598, 0.367352, -1.767383>, <-0.492021, 0.431784, -1.536413>, <-0.507351, 0.439339, -1.352444>, 
      <-0.549574, 0.270815, -1.945214>, <-0.594539, 0.292973, -1.767383>, <-0.684126, 0.337120, -1.536413>, <-0.699457, 0.344674, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.549574, 0.270815, -1.945214>, <0.594539, 0.292973, -1.767383>, <0.684127, 0.337120, -1.536413>, <0.699457, 0.344674, -1.352444>, 
      <0.398633, 0.345194, -1.945214>, <0.443598, 0.367352, -1.767383>, <0.492021, 0.431784, -1.536413>, <0.507351, 0.439339, -1.352444>, 
      <0.168272, 0.382990, -1.945214>, <0.168272, 0.414326, -1.767383>, <0.214164, 0.476973, -1.532711>, <0.214164, 0.487442, -1.352444>, 
      <0.000000, 0.382990, -1.945214>, <0.000000, 0.414326, -1.767383>, <0.000000, 0.476973, -1.532711>, <0.000000, 0.487442, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.945213>, <0.000000, -0.114897, -1.945213>, <0.000000, -0.268093, -1.945214>, <0.000000, -0.382990, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.000000, -0.114897, -1.945213>, <0.168272, -0.268093, -1.945214>, <0.168272, -0.382990, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.164872, -0.081244, -1.945213>, <0.233761, -0.263950, -1.945214>, <0.398633, -0.345194, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.164872, -0.081244, -1.945213>, <0.384702, -0.189571, -1.945214>, <0.549574, -0.270815, -1.945214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.945213>, <-0.164872, -0.081244, -1.945213>, <-0.384702, -0.189571, -1.945214>, <-0.549574, -0.270815, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.164872, -0.081244, -1.945213>, <-0.233761, -0.263950, -1.945214>, <-0.398633, -0.345194, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.000000, -0.114897, -1.945213>, <-0.168272, -0.268093, -1.945214>, <-0.168272, -0.382990, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.000000, -0.114897, -1.945213>, <0.000000, -0.268093, -1.945214>, <0.000000, -0.382990, -1.945214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.945213>, <-0.233165, 0.000000, -1.945213>, <-0.544050, 0.000000, -1.945214>, <-0.777215, 0.000000, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.233165, 0.000000, -1.945213>, <-0.544050, -0.106134, -1.945214>, <-0.777215, -0.106134, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.164872, -0.081244, -1.945213>, <-0.479905, -0.142657, -1.945214>, <-0.644777, -0.223902, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.164872, -0.081244, -1.945213>, <-0.384702, -0.189571, -1.945214>, <-0.549574, -0.270815, -1.945214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.945213>, <-0.164872, 0.081244, -1.945213>, <-0.384702, 0.189571, -1.945214>, <-0.549574, 0.270815, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.164872, 0.081244, -1.945213>, <-0.479905, 0.142657, -1.945214>, <-0.644777, 0.223902, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.233165, 0.000000, -1.945213>, <-0.544050, 0.106134, -1.945214>, <-0.777215, 0.106134, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.233165, 0.000000, -1.945213>, <-0.544050, 0.000000, -1.945214>, <-0.777215, 0.000000, -1.945214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.945213>, <0.000000, 0.114897, -1.945213>, <0.000000, 0.268093, -1.945214>, <0.000000, 0.382990, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.000000, 0.114897, -1.945213>, <-0.168272, 0.268093, -1.945214>, <-0.168272, 0.382990, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.164872, 0.081244, -1.945213>, <-0.233761, 0.263950, -1.945214>, <-0.398633, 0.345194, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <-0.164872, 0.081244, -1.945213>, <-0.384702, 0.189571, -1.945214>, <-0.549574, 0.270815, -1.945214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -1.945213>, <0.164872, 0.081244, -1.945213>, <0.384702, 0.189571, -1.945214>, <0.549574, 0.270815, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.164872, 0.081244, -1.945213>, <0.233761, 0.263950, -1.945214>, <0.398633, 0.345194, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.000000, 0.114897, -1.945213>, <0.168272, 0.268093, -1.945214>, <0.168272, 0.382990, -1.945214>, 
      <0.000000, 0.000000, -1.945213>, <0.000000, 0.114897, -1.945213>, <0.000000, 0.268093, -1.945214>, <0.000000, 0.382990, -1.945214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.989182, 0.000000, -1.352444>, <1.017536, 0.000000, -1.111847>, <0.964894, 0.000000, -0.787463>, <0.942078, 0.000000, -0.546278>, 
      <0.989182, 0.135080, -1.352444>, <1.017536, 0.135080, -1.111847>, <0.964894, 0.128648, -0.787463>, <0.942078, 0.128648, -0.546278>, 
      <0.820625, 0.284966, -1.352444>, <0.840713, 0.294865, -1.111376>, <0.797697, 0.279354, -0.787714>, <0.781547, 0.271396, -0.546278>, 
      <0.699457, 0.344674, -1.352444>, <0.719545, 0.354573, -1.111376>, <0.682299, 0.336219, -0.787714>, <0.666149, 0.328261, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.989182, 0.000000, -1.352444>, <0.989182, -0.135080, -1.352444>, <0.820626, -0.284966, -1.352444>, <0.699458, -0.344674, -1.352444>, 
      <1.017536, 0.000000, -1.111847>, <1.017536, -0.135080, -1.111847>, <0.840714, -0.294865, -1.111376>, <0.719547, -0.354573, -1.111376>, 
      <0.964894, 0.000000, -0.787463>, <0.964894, -0.128648, -0.787463>, <0.797698, -0.279354, -0.787714>, <0.682300, -0.336218, -0.787714>, 
      <0.942078, 0.000000, -0.546278>, <0.942078, -0.128648, -0.546278>, <0.781547, -0.271395, -0.546278>, <0.666150, -0.328260, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.777214, 0.000000, -1.945214>, <0.840804, 0.000000, -1.767383>, <0.967078, 0.000000, -1.540005>, <0.989182, 0.000000, -1.352444>, 
      <0.777214, 0.106134, -1.945214>, <0.840804, 0.106134, -1.767383>, <0.967078, 0.135080, -1.540005>, <0.989182, 0.135080, -1.352444>, 
      <0.644777, 0.223902, -1.945214>, <0.689742, 0.246059, -1.767383>, <0.805294, 0.277411, -1.536413>, <0.820625, 0.284966, -1.352444>, 
      <0.549574, 0.270815, -1.945214>, <0.594539, 0.292973, -1.767383>, <0.684127, 0.337120, -1.536413>, <0.699457, 0.344674, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.777214, 0.000000, -1.945214>, <0.777214, -0.106134, -1.945214>, <0.644777, -0.223902, -1.945214>, <0.549574, -0.270815, -1.945214>, 
      <0.840804, 0.000000, -1.767383>, <0.840804, -0.106134, -1.767383>, <0.689742, -0.246059, -1.767383>, <0.594539, -0.292973, -1.767383>, 
      <0.967078, 0.000000, -1.540005>, <0.967078, -0.135080, -1.540005>, <0.805295, -0.277412, -1.536413>, <0.684128, -0.337120, -1.536413>, 
      <0.989182, 0.000000, -1.352444>, <0.989182, -0.135080, -1.352444>, <0.820626, -0.284966, -1.352444>, <0.699458, -0.344674, -1.352444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.777214, 0.000000, -1.945214>, <0.777214, 0.106134, -1.945214>, <0.644777, 0.223902, -1.945214>, <0.549574, 0.270815, -1.945214>, 
      <0.544050, 0.000000, -1.945214>, <0.544050, 0.106134, -1.945214>, <0.479905, 0.142657, -1.945214>, <0.384702, 0.189571, -1.945214>, 
      <0.233164, 0.000000, -1.945213>, <0.233164, 0.000000, -1.945213>, <0.164872, 0.081244, -1.945213>, <0.164872, 0.081244, -1.945213>, 
      <0.000000, 0.000000, -1.945213>, <0.000000, 0.000000, -1.945213>, <0.000000, 0.000000, -1.945213>, <0.000000, 0.000000, -1.945213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.777214, 0.000000, -1.945214>, <0.544050, 0.000000, -1.945214>, <0.233164, 0.000000, -1.945213>, <0.000000, 0.000000, -1.945213>, 
      <0.777214, -0.106134, -1.945214>, <0.544050, -0.106134, -1.945214>, <0.233164, 0.000000, -1.945213>, <0.000000, 0.000000, -1.945213>, 
      <0.644777, -0.223902, -1.945214>, <0.479905, -0.142657, -1.945214>, <0.164872, -0.081244, -1.945213>, <0.000000, 0.000000, -1.945213>, 
      <0.549574, -0.270815, -1.945214>, <0.384702, -0.189571, -1.945214>, <0.164872, -0.081244, -1.945213>, <0.000000, 0.000000, -1.945213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.894974, 0.000000, -0.356592>, <0.873896, 0.000000, -0.356592>, <0.687849, 0.000000, -0.356592>, <0.011776, 0.000000, -0.356591>, 
      <0.894974, 0.122215, -0.356592>, <0.873896, 0.122215, -0.356592>, <0.687849, 0.001608, -0.356592>, <0.011776, 0.001608, -0.356591>, 
      <0.742470, 0.257826, -0.356592>, <0.727565, 0.250482, -0.356592>, <0.487825, 0.238966, -0.356592>, <0.009769, 0.003392, -0.356591>, 
      <0.632842, 0.311848, -0.356592>, <0.617937, 0.304503, -0.356592>, <0.486383, 0.239677, -0.356592>, <0.008327, 0.004103, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.894974, 0.000000, -0.356592>, <0.894974, -0.122215, -0.356592>, <0.742470, -0.257826, -0.356592>, <0.632842, -0.311848, -0.356592>, 
      <0.873896, 0.000000, -0.356592>, <0.873896, -0.122215, -0.356592>, <0.727565, -0.250482, -0.356592>, <0.617937, -0.304503, -0.356592>, 
      <0.687849, 0.000000, -0.356592>, <0.687849, -0.001608, -0.356592>, <0.487825, -0.238966, -0.356592>, <0.486383, -0.239677, -0.356592>, 
      <0.011776, 0.000000, -0.356591>, <0.011776, -0.001608, -0.356591>, <0.009769, -0.003392, -0.356591>, <0.008327, -0.004103, -0.356591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.894974, 0.000000, -0.356592>, <0.894974, 0.122215, -0.356592>, <0.742470, 0.257826, -0.356592>, <0.632842, 0.311848, -0.356592>, 
      <0.896098, 0.000000, -0.361119>, <0.896098, 0.122215, -0.361119>, <0.743265, 0.258218, -0.361119>, <0.633637, 0.312240, -0.361119>, 
      <0.936556, 0.000000, -0.487905>, <0.936556, 0.128648, -0.487905>, <0.777679, 0.269490, -0.488453>, <0.662281, 0.326355, -0.488453>, 
      <0.942078, 0.000000, -0.546278>, <0.942078, 0.128648, -0.546278>, <0.781547, 0.271396, -0.546278>, <0.666149, 0.328261, -0.546278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.894974, 0.000000, -0.356592>, <0.896098, 0.000000, -0.361119>, <0.936556, 0.000000, -0.487905>, <0.942078, 0.000000, -0.546278>, 
      <0.894974, -0.122215, -0.356592>, <0.896098, -0.122215, -0.361119>, <0.936556, -0.128648, -0.487905>, <0.942078, -0.128648, -0.546278>, 
      <0.742470, -0.257826, -0.356592>, <0.743265, -0.258218, -0.361119>, <0.777679, -0.269489, -0.488453>, <0.781547, -0.271395, -0.546278>, 
      <0.632842, -0.311848, -0.356592>, <0.633637, -0.312240, -0.361119>, <0.662282, -0.326354, -0.488453>, <0.666150, -0.328260, -0.546278>
    }
  }
  material {
    Syrup_Tex
  }
}
#declare sPatchObj6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005462, -0.367077, 0.864770>, <0.005462, -0.377678, 0.883321>, <0.005462, -0.424141, 0.847685>, <0.005462, -0.427163, 0.826534>, 
      <0.089747, -0.367077, 0.864770>, <0.089747, -0.377678, 0.883321>, <0.103543, -0.424141, 0.847685>, <0.103543, -0.427163, 0.826534>, 
      <0.205427, -0.319161, 0.864770>, <0.212922, -0.326657, 0.883321>, <0.236022, -0.369267, 0.847685>, <0.238159, -0.371404, 0.826534>, 
      <0.265025, -0.259563, 0.864770>, <0.272521, -0.267059, 0.883321>, <0.305376, -0.299914, 0.847685>, <0.307513, -0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.254100, -0.259563, 0.864770>, <-0.261596, -0.267059, 0.883321>, <-0.294451, -0.299914, 0.847685>, <-0.296588, -0.302050, 0.826534>, 
      <-0.194502, -0.319161, 0.864770>, <-0.201998, -0.326657, 0.883321>, <-0.225098, -0.369267, 0.847685>, <-0.227234, -0.371404, 0.826534>, 
      <-0.078822, -0.367077, 0.864770>, <-0.078822, -0.377678, 0.883321>, <-0.092619, -0.424141, 0.847685>, <-0.092619, -0.427163, 0.826534>, 
      <0.005462, -0.367077, 0.864770>, <0.005462, -0.377678, 0.883321>, <0.005462, -0.424141, 0.847685>, <0.005462, -0.427163, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.361615, 0.000000, 0.864770>, <-0.372216, 0.000000, 0.883321>, <-0.418679, 0.000000, 0.847685>, <-0.421701, 0.000000, 0.826534>, 
      <-0.361615, -0.084285, 0.864770>, <-0.372215, -0.084285, 0.883321>, <-0.418679, -0.098081, 0.847685>, <-0.421701, -0.098081, 0.826534>, 
      <-0.313698, -0.199965, 0.864770>, <-0.321194, -0.207460, 0.883321>, <-0.363805, -0.230560, 0.847685>, <-0.365942, -0.232696, 0.826534>, 
      <-0.254100, -0.259563, 0.864770>, <-0.261596, -0.267059, 0.883321>, <-0.294451, -0.299914, 0.847685>, <-0.296588, -0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.254101, 0.259563, 0.864770>, <-0.261597, 0.267059, 0.883321>, <-0.294451, 0.299914, 0.847685>, <-0.296588, 0.302050, 0.826534>, 
      <-0.313699, 0.199965, 0.864770>, <-0.321195, 0.207460, 0.883321>, <-0.363805, 0.230560, 0.847685>, <-0.365942, 0.232696, 0.826534>, 
      <-0.361615, 0.084285, 0.864770>, <-0.372216, 0.084285, 0.883321>, <-0.418679, 0.098081, 0.847685>, <-0.421701, 0.098081, 0.826534>, 
      <-0.361615, 0.000000, 0.864770>, <-0.372216, 0.000000, 0.883321>, <-0.418679, 0.000000, 0.847685>, <-0.421701, 0.000000, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005462, 0.367077, 0.864770>, <0.005462, 0.377678, 0.883321>, <0.005462, 0.424141, 0.847685>, <0.005462, 0.427163, 0.826534>, 
      <-0.078823, 0.367077, 0.864770>, <-0.078823, 0.377678, 0.883321>, <-0.092619, 0.424141, 0.847685>, <-0.092619, 0.427163, 0.826534>, 
      <-0.194503, 0.319161, 0.864770>, <-0.201999, 0.326657, 0.883321>, <-0.225098, 0.369267, 0.847685>, <-0.227234, 0.371404, 0.826534>, 
      <-0.254101, 0.259563, 0.864770>, <-0.261597, 0.267059, 0.883321>, <-0.294451, 0.299914, 0.847685>, <-0.296588, 0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265025, 0.259563, 0.864770>, <0.272521, 0.267059, 0.883321>, <0.305375, 0.299914, 0.847685>, <0.307512, 0.302050, 0.826534>, 
      <0.205427, 0.319161, 0.864770>, <0.212922, 0.326657, 0.883321>, <0.236022, 0.369267, 0.847685>, <0.238158, 0.371404, 0.826534>, 
      <0.089747, 0.367077, 0.864770>, <0.089747, 0.377678, 0.883321>, <0.103543, 0.424141, 0.847685>, <0.103543, 0.427163, 0.826534>, 
      <0.005462, 0.367077, 0.864770>, <0.005462, 0.377678, 0.883321>, <0.005462, 0.424141, 0.847685>, <0.005462, 0.427163, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005462, -0.383464, 0.750061>, <0.005462, -0.354137, 0.768724>, <0.005462, -0.349830, 0.834588>, <0.005462, -0.367077, 0.864770>, 
      <0.093509, -0.383464, 0.750061>, <0.093509, -0.354137, 0.768724>, <0.089747, -0.349830, 0.834588>, <0.089747, -0.367077, 0.864770>, 
      <0.214354, -0.333409, 0.750061>, <0.193616, -0.312671, 0.768724>, <0.193231, -0.306966, 0.834588>, <0.205427, -0.319161, 0.864770>, 
      <0.276613, -0.271150, 0.750061>, <0.255875, -0.250412, 0.768724>, <0.252830, -0.247368, 0.834588>, <0.265025, -0.259563, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005462, -0.383464, 0.750061>, <0.093509, -0.383464, 0.750061>, <0.214354, -0.333409, 0.750061>, <0.276613, -0.271150, 0.750061>, 
      <0.005462, -0.405757, 0.735875>, <0.093509, -0.405757, 0.735875>, <0.230117, -0.349172, 0.735875>, <0.292376, -0.286913, 0.735875>, 
      <0.005462, -0.430900, 0.800376>, <0.103543, -0.430900, 0.800376>, <0.240802, -0.374046, 0.800376>, <0.310155, -0.304692, 0.800376>, 
      <0.005462, -0.427163, 0.826534>, <0.103543, -0.427163, 0.826534>, <0.238159, -0.371404, 0.826534>, <0.307513, -0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265688, -0.271150, 0.750061>, <-0.244950, -0.250412, 0.768724>, <-0.241905, -0.247368, 0.834588>, <-0.254100, -0.259563, 0.864770>, 
      <-0.203429, -0.333409, 0.750061>, <-0.182691, -0.312671, 0.768724>, <-0.182307, -0.306966, 0.834588>, <-0.194502, -0.319161, 0.864770>, 
      <-0.082585, -0.383464, 0.750061>, <-0.082585, -0.354137, 0.768724>, <-0.078822, -0.349830, 0.834588>, <-0.078822, -0.367077, 0.864770>, 
      <0.005462, -0.383464, 0.750061>, <0.005462, -0.354137, 0.768724>, <0.005462, -0.349830, 0.834588>, <0.005462, -0.367077, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265688, -0.271150, 0.750061>, <-0.203429, -0.333409, 0.750061>, <-0.082585, -0.383464, 0.750061>, <0.005462, -0.383464, 0.750061>, 
      <-0.281451, -0.286913, 0.735875>, <-0.219193, -0.349172, 0.735875>, <-0.082585, -0.405757, 0.735875>, <0.005462, -0.405757, 0.735875>, 
      <-0.299231, -0.304692, 0.800376>, <-0.229877, -0.374046, 0.800376>, <-0.092619, -0.430900, 0.800376>, <0.005462, -0.430900, 0.800376>, 
      <-0.296588, -0.302050, 0.826534>, <-0.227234, -0.371404, 0.826534>, <-0.092619, -0.427163, 0.826534>, <0.005462, -0.427163, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.378002, 0.000000, 0.750061>, <-0.348675, 0.000000, 0.768724>, <-0.344368, 0.000000, 0.834588>, <-0.361615, 0.000000, 0.864770>, 
      <-0.378002, -0.088047, 0.750061>, <-0.348675, -0.088047, 0.768724>, <-0.344368, -0.084285, 0.834588>, <-0.361615, -0.084285, 0.864770>, 
      <-0.327947, -0.208891, 0.750061>, <-0.307209, -0.188154, 0.768724>, <-0.301503, -0.187769, 0.834588>, <-0.313698, -0.199965, 0.864770>, 
      <-0.265688, -0.271150, 0.750061>, <-0.244950, -0.250412, 0.768724>, <-0.241905, -0.247368, 0.834588>, <-0.254100, -0.259563, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.378002, 0.000000, 0.750061>, <-0.378002, -0.088047, 0.750061>, <-0.327947, -0.208891, 0.750061>, <-0.265688, -0.271150, 0.750061>, 
      <-0.400295, 0.000000, 0.735875>, <-0.400295, -0.088047, 0.735875>, <-0.343710, -0.224654, 0.735875>, <-0.281451, -0.286913, 0.735875>, 
      <-0.425438, 0.000000, 0.800376>, <-0.425438, -0.098081, 0.800376>, <-0.368584, -0.235339, 0.800376>, <-0.299231, -0.304692, 0.800376>, 
      <-0.421701, 0.000000, 0.826534>, <-0.421701, -0.098081, 0.826534>, <-0.365942, -0.232696, 0.826534>, <-0.296588, -0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265688, 0.271150, 0.750061>, <-0.244950, 0.250412, 0.768724>, <-0.241906, 0.247368, 0.834588>, <-0.254101, 0.259563, 0.864770>, 
      <-0.327947, 0.208891, 0.750061>, <-0.307209, 0.188154, 0.768724>, <-0.301504, 0.187769, 0.834588>, <-0.313699, 0.199965, 0.864770>, 
      <-0.378002, 0.088047, 0.750061>, <-0.348675, 0.088047, 0.768724>, <-0.344368, 0.084285, 0.834588>, <-0.361615, 0.084285, 0.864770>, 
      <-0.378002, 0.000000, 0.750061>, <-0.348675, 0.000000, 0.768724>, <-0.344368, 0.000000, 0.834588>, <-0.361615, 0.000000, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265688, 0.271150, 0.750061>, <-0.327947, 0.208891, 0.750061>, <-0.378002, 0.088047, 0.750061>, <-0.378002, 0.000000, 0.750061>, 
      <-0.281451, 0.286913, 0.735875>, <-0.343710, 0.224654, 0.735875>, <-0.400295, 0.088047, 0.735875>, <-0.400295, 0.000000, 0.735875>, 
      <-0.299230, 0.304692, 0.800376>, <-0.368584, 0.235339, 0.800376>, <-0.425438, 0.098081, 0.800376>, <-0.425438, 0.000000, 0.800376>, 
      <-0.296588, 0.302050, 0.826534>, <-0.365942, 0.232696, 0.826534>, <-0.421701, 0.098081, 0.826534>, <-0.421701, 0.000000, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005462, 0.383464, 0.750061>, <0.005462, 0.354137, 0.768724>, <0.005462, 0.349830, 0.834588>, <0.005462, 0.367077, 0.864770>, 
      <-0.082585, 0.383464, 0.750061>, <-0.082585, 0.354137, 0.768724>, <-0.078823, 0.349830, 0.834588>, <-0.078823, 0.367077, 0.864770>, 
      <-0.203429, 0.333409, 0.750061>, <-0.182692, 0.312671, 0.768724>, <-0.182307, 0.306966, 0.834588>, <-0.194503, 0.319161, 0.864770>, 
      <-0.265688, 0.271150, 0.750061>, <-0.244950, 0.250412, 0.768724>, <-0.241906, 0.247368, 0.834588>, <-0.254101, 0.259563, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005462, 0.383464, 0.750061>, <-0.082585, 0.383464, 0.750061>, <-0.203429, 0.333409, 0.750061>, <-0.265688, 0.271150, 0.750061>, 
      <0.005462, 0.405757, 0.735875>, <-0.082585, 0.405757, 0.735875>, <-0.219192, 0.349172, 0.735875>, <-0.281451, 0.286913, 0.735875>, 
      <0.005462, 0.430900, 0.800376>, <-0.092619, 0.430900, 0.800376>, <-0.229877, 0.374046, 0.800376>, <-0.299230, 0.304692, 0.800376>, 
      <0.005462, 0.427163, 0.826534>, <-0.092619, 0.427163, 0.826534>, <-0.227234, 0.371404, 0.826534>, <-0.296588, 0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.276613, 0.271150, 0.750061>, <0.255875, 0.250412, 0.768724>, <0.252830, 0.247367, 0.834588>, <0.265025, 0.259563, 0.864770>, 
      <0.214354, 0.333409, 0.750061>, <0.193616, 0.312671, 0.768724>, <0.193232, 0.306966, 0.834588>, <0.205427, 0.319161, 0.864770>, 
      <0.093509, 0.383464, 0.750061>, <0.093509, 0.354137, 0.768724>, <0.089747, 0.349830, 0.834588>, <0.089747, 0.367077, 0.864770>, 
      <0.005462, 0.383464, 0.750061>, <0.005462, 0.354137, 0.768724>, <0.005462, 0.349830, 0.834588>, <0.005462, 0.367077, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.276613, 0.271150, 0.750061>, <0.214354, 0.333409, 0.750061>, <0.093509, 0.383464, 0.750061>, <0.005462, 0.383464, 0.750061>, 
      <0.292376, 0.286913, 0.735875>, <0.230117, 0.349172, 0.735875>, <0.093509, 0.405757, 0.735875>, <0.005462, 0.405757, 0.735875>, 
      <0.310155, 0.304692, 0.800376>, <0.240801, 0.374046, 0.800376>, <0.103543, 0.430900, 0.800376>, <0.005462, 0.430900, 0.800376>, 
      <0.307512, 0.302050, 0.826534>, <0.238158, 0.371404, 0.826534>, <0.103543, 0.427163, 0.826534>, <0.005462, 0.427163, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.372540, 0.000000, 0.864770>, <0.383141, 0.000000, 0.883321>, <0.429604, 0.000000, 0.847685>, <0.432626, 0.000000, 0.826534>, 
      <0.372540, 0.084285, 0.864770>, <0.383141, 0.084285, 0.883321>, <0.429604, 0.098081, 0.847685>, <0.432626, 0.098081, 0.826534>, 
      <0.324623, 0.199965, 0.864770>, <0.332119, 0.207460, 0.883321>, <0.374729, 0.230560, 0.847685>, <0.376866, 0.232696, 0.826534>, 
      <0.265025, 0.259563, 0.864770>, <0.272521, 0.267059, 0.883321>, <0.305375, 0.299914, 0.847685>, <0.307512, 0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.372540, 0.000000, 0.864770>, <0.372540, -0.084285, 0.864770>, <0.324623, -0.199965, 0.864770>, <0.265025, -0.259563, 0.864770>, 
      <0.383141, 0.000000, 0.883321>, <0.383141, -0.084285, 0.883321>, <0.332119, -0.207461, 0.883321>, <0.272521, -0.267059, 0.883321>, 
      <0.429604, 0.000000, 0.847685>, <0.429605, -0.098081, 0.847685>, <0.374730, -0.230560, 0.847685>, <0.305376, -0.299914, 0.847685>, 
      <0.432626, 0.000000, 0.826534>, <0.432626, -0.098081, 0.826534>, <0.376867, -0.232696, 0.826534>, <0.307513, -0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.388927, 0.000000, 0.750061>, <0.359600, 0.000000, 0.768724>, <0.355293, 0.000000, 0.834588>, <0.372540, 0.000000, 0.864770>, 
      <0.388927, 0.088047, 0.750061>, <0.359600, 0.088047, 0.768724>, <0.355293, 0.084285, 0.834588>, <0.372540, 0.084285, 0.864770>, 
      <0.338872, 0.208891, 0.750061>, <0.318134, 0.188154, 0.768724>, <0.312428, 0.187769, 0.834588>, <0.324623, 0.199965, 0.864770>, 
      <0.276613, 0.271150, 0.750061>, <0.255875, 0.250412, 0.768724>, <0.252830, 0.247367, 0.834588>, <0.265025, 0.259563, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.388927, 0.000000, 0.750061>, <0.388927, -0.088047, 0.750061>, <0.338872, -0.208891, 0.750061>, <0.276613, -0.271150, 0.750061>, 
      <0.359600, 0.000000, 0.768724>, <0.359600, -0.088047, 0.768724>, <0.318134, -0.188154, 0.768724>, <0.255875, -0.250412, 0.768724>, 
      <0.355293, 0.000000, 0.834588>, <0.355293, -0.084285, 0.834588>, <0.312428, -0.187769, 0.834588>, <0.252830, -0.247368, 0.834588>, 
      <0.372540, 0.000000, 0.864770>, <0.372540, -0.084285, 0.864770>, <0.324623, -0.199965, 0.864770>, <0.265025, -0.259563, 0.864770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.388927, 0.000000, 0.750061>, <0.388927, 0.088047, 0.750061>, <0.338872, 0.208891, 0.750061>, <0.276613, 0.271150, 0.750061>, 
      <0.411220, 0.000000, 0.735875>, <0.411220, 0.088047, 0.735875>, <0.354635, 0.224654, 0.735875>, <0.292376, 0.286913, 0.735875>, 
      <0.436363, 0.000000, 0.800376>, <0.436363, 0.098081, 0.800376>, <0.379508, 0.235339, 0.800376>, <0.310155, 0.304692, 0.800376>, 
      <0.432626, 0.000000, 0.826534>, <0.432626, 0.098081, 0.826534>, <0.376866, 0.232696, 0.826534>, <0.307512, 0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.388927, 0.000000, 0.750061>, <0.411220, 0.000000, 0.735875>, <0.436363, 0.000000, 0.800376>, <0.432626, 0.000000, 0.826534>, 
      <0.388927, -0.088047, 0.750061>, <0.411220, -0.088047, 0.735875>, <0.436363, -0.098081, 0.800376>, <0.432626, -0.098081, 0.826534>, 
      <0.338872, -0.208891, 0.750061>, <0.354635, -0.224654, 0.735875>, <0.379509, -0.235339, 0.800376>, <0.376867, -0.232696, 0.826534>, 
      <0.276613, -0.271150, 0.750061>, <0.292376, -0.286913, 0.735875>, <0.310155, -0.304692, 0.800376>, <0.307513, -0.302050, 0.826534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.351272, 0.702775>, <0.089840, -0.351272, 0.702775>, <0.213901, -0.307859, 0.702775>, <0.281239, -0.248387, 0.702775>, 
      <0.000000, -0.349988, 0.835612>, <0.089840, -0.349988, 0.835612>, <0.179926, -0.306981, 0.831214>, <0.247264, -0.247509, 0.831214>, 
      <0.000000, -0.338245, 1.012468>, <0.085081, -0.338245, 1.012468>, <0.207039, -0.295496, 1.012468>, <0.270809, -0.239175, 1.012468>, 
      <0.000000, -0.332662, 1.145193>, <0.085081, -0.332662, 1.145193>, <0.202569, -0.291548, 1.145193>, <0.266339, -0.235227, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.281238, -0.248387, 0.702775>, <-0.213901, -0.307859, 0.702775>, <-0.089840, -0.351272, 0.702775>, <0.000000, -0.351272, 0.702775>, 
      <-0.247263, -0.247509, 0.831214>, <-0.179925, -0.306981, 0.831214>, <-0.089840, -0.349988, 0.835612>, <0.000000, -0.349988, 0.835612>, 
      <-0.270809, -0.239176, 1.012468>, <-0.207039, -0.295497, 1.012468>, <-0.085081, -0.338245, 1.012468>, <0.000000, -0.338245, 1.012468>, 
      <-0.266339, -0.235228, 1.145193>, <-0.202569, -0.291549, 1.145193>, <-0.085081, -0.332662, 1.145193>, <0.000000, -0.332662, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.397731, 0.000000, 0.702775>, <-0.397731, -0.082304, 0.702775>, <-0.342927, -0.193904, 0.702775>, <-0.281238, -0.248387, 0.702775>, 
      <-0.351174, 0.000000, 0.827228>, <-0.351174, -0.082304, 0.827228>, <-0.308952, -0.193026, 0.831214>, <-0.247263, -0.247509, 0.831214>, 
      <-0.382981, 0.000000, 1.012468>, <-0.382981, -0.077944, 1.012468>, <-0.329230, -0.187579, 1.012468>, <-0.270809, -0.239176, 1.012468>, 
      <-0.376660, 0.000000, 1.145193>, <-0.376660, -0.077944, 1.145193>, <-0.324760, -0.183631, 1.145193>, <-0.266339, -0.235228, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.281238, 0.248387, 0.702775>, <-0.342927, 0.193904, 0.702775>, <-0.397731, 0.082304, 0.702775>, <-0.397731, 0.000000, 0.702775>, 
      <-0.247263, 0.247509, 0.831214>, <-0.308952, 0.193026, 0.831214>, <-0.351174, 0.082304, 0.827228>, <-0.351174, 0.000000, 0.827228>, 
      <-0.270809, 0.239176, 1.012468>, <-0.329230, 0.187579, 1.012468>, <-0.382981, 0.077944, 1.012468>, <-0.382981, 0.000000, 1.012468>, 
      <-0.266339, 0.235228, 1.145193>, <-0.324760, 0.183631, 1.145193>, <-0.376660, 0.077944, 1.145193>, <-0.376660, 0.000000, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.351272, 0.702775>, <-0.089840, 0.351272, 0.702775>, <-0.213901, 0.307859, 0.702775>, <-0.281238, 0.248387, 0.702775>, 
      <0.000000, 0.349988, 0.835612>, <-0.089840, 0.349988, 0.835612>, <-0.179925, 0.306981, 0.831214>, <-0.247263, 0.247509, 0.831214>, 
      <0.000000, 0.338245, 1.012468>, <-0.085081, 0.338245, 1.012468>, <-0.207039, 0.295497, 1.012468>, <-0.270809, 0.239176, 1.012468>, 
      <0.000000, 0.332662, 1.145193>, <-0.085081, 0.332662, 1.145193>, <-0.202569, 0.291549, 1.145193>, <-0.266339, 0.235228, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.281238, 0.248387, 0.702775>, <0.213901, 0.307859, 0.702775>, <0.089840, 0.351272, 0.702775>, <0.000000, 0.351272, 0.702775>, 
      <0.247263, 0.247509, 0.831214>, <0.179925, 0.306981, 0.831214>, <0.089840, 0.349988, 0.835612>, <0.000000, 0.349988, 0.835612>, 
      <0.270809, 0.239176, 1.012468>, <0.207039, 0.295497, 1.012468>, <0.085081, 0.338245, 1.012468>, <0.000000, 0.338245, 1.012468>, 
      <0.266339, 0.235228, 1.145193>, <0.202569, 0.291549, 1.145193>, <0.085081, 0.332662, 1.145193>, <0.000000, 0.332662, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.341028, 0.279495>, <0.151593, -0.341028, 0.279495>, <0.359040, -0.307497, 0.279495>, <0.495339, -0.241143, 0.279495>, 
      <0.000000, -0.327590, 0.405803>, <0.151593, -0.327590, 0.405803>, <0.309079, -0.297500, 0.412383>, <0.445379, -0.231146, 0.412383>, 
      <0.000000, -0.352500, 0.575760>, <0.089840, -0.352500, 0.575760>, <0.250296, -0.308799, 0.565190>, <0.317634, -0.249327, 0.565190>, 
      <0.000000, -0.351272, 0.702775>, <0.089840, -0.351272, 0.702775>, <0.213901, -0.307859, 0.702775>, <0.281239, -0.248387, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.495339, -0.241143, 0.279495>, <-0.359040, -0.307497, 0.279495>, <-0.151593, -0.341028, 0.279495>, <0.000000, -0.341028, 0.279495>, 
      <-0.445379, -0.231146, 0.412383>, <-0.309079, -0.297500, 0.412383>, <-0.151593, -0.327590, 0.405803>, <0.000000, -0.327590, 0.405803>, 
      <-0.317633, -0.249327, 0.565190>, <-0.250296, -0.308799, 0.565190>, <-0.089840, -0.352500, 0.575760>, <0.000000, -0.352500, 0.575760>, 
      <-0.281238, -0.248387, 0.702775>, <-0.213901, -0.307859, 0.702775>, <-0.089840, -0.351272, 0.702775>, <0.000000, -0.351272, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700515, 0.000000, 0.279495>, <-0.700515, -0.094986, 0.279495>, <-0.580742, -0.199567, 0.279495>, <-0.495339, -0.241143, 0.279495>, 
      <-0.627220, 0.000000, 0.417349>, <-0.627220, -0.094986, 0.417349>, <-0.530782, -0.189570, 0.412383>, <-0.445379, -0.231146, 0.412383>, 
      <-0.452435, 0.000000, 0.556544>, <-0.452435, -0.082304, 0.556544>, <-0.379322, -0.194844, 0.565190>, <-0.317633, -0.249327, 0.565190>, 
      <-0.397731, 0.000000, 0.702775>, <-0.397731, -0.082304, 0.702775>, <-0.342927, -0.193904, 0.702775>, <-0.281238, -0.248387, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.495339, 0.241143, 0.279495>, <-0.580742, 0.199567, 0.279495>, <-0.700515, 0.094986, 0.279495>, <-0.700515, 0.000000, 0.279495>, 
      <-0.445379, 0.231146, 0.412383>, <-0.530782, 0.189570, 0.412383>, <-0.627220, 0.094986, 0.417349>, <-0.627220, 0.000000, 0.417349>, 
      <-0.317633, 0.249327, 0.565190>, <-0.379322, 0.194844, 0.565190>, <-0.452435, 0.082304, 0.556544>, <-0.452435, 0.000000, 0.556544>, 
      <-0.281238, 0.248387, 0.702775>, <-0.342927, 0.193904, 0.702775>, <-0.397731, 0.082304, 0.702775>, <-0.397731, 0.000000, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.341028, 0.279495>, <-0.151593, 0.341028, 0.279495>, <-0.359040, 0.307497, 0.279495>, <-0.495339, 0.241143, 0.279495>, 
      <0.000000, 0.327590, 0.405803>, <-0.151593, 0.327590, 0.405803>, <-0.309079, 0.297500, 0.412383>, <-0.445379, 0.231146, 0.412383>, 
      <0.000000, 0.352500, 0.575760>, <-0.089840, 0.352500, 0.575760>, <-0.250296, 0.308799, 0.565190>, <-0.317633, 0.249327, 0.565190>, 
      <0.000000, 0.351272, 0.702775>, <-0.089840, 0.351272, 0.702775>, <-0.213901, 0.307859, 0.702775>, <-0.281238, 0.248387, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.495339, 0.241143, 0.279495>, <0.359040, 0.307497, 0.279495>, <0.151593, 0.341028, 0.279495>, <0.000000, 0.341028, 0.279495>, 
      <0.445379, 0.231146, 0.412383>, <0.309079, 0.297500, 0.412383>, <0.151593, 0.327590, 0.405803>, <0.000000, 0.327590, 0.405803>, 
      <0.317633, 0.249327, 0.565190>, <0.250296, 0.308799, 0.565190>, <0.089840, 0.352500, 0.575760>, <0.000000, 0.352500, 0.575760>, 
      <0.281238, 0.248387, 0.702775>, <0.213901, 0.307859, 0.702775>, <0.089840, 0.351272, 0.702775>, <0.000000, 0.351272, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.461293, -0.331345>, <0.205053, -0.461293, -0.331345>, <0.485657, -0.415937, -0.331345>, <0.670024, -0.326183, -0.331345>, 
      <0.000000, -0.442026, -0.145571>, <0.205053, -0.442026, -0.145571>, <0.457088, -0.402029, -0.141691>, <0.641454, -0.312275, -0.141691>, 
      <0.000000, -0.360787, 0.093773>, <0.151593, -0.360787, 0.093773>, <0.426544, -0.321005, 0.099942>, <0.562843, -0.254651, 0.099942>, 
      <0.000000, -0.341028, 0.279495>, <0.151593, -0.341028, 0.279495>, <0.359040, -0.307497, 0.279495>, <0.495339, -0.241143, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.670024, -0.326184, -0.331345>, <-0.485658, -0.415938, -0.331345>, <-0.205053, -0.461293, -0.331345>, <0.000000, -0.461293, -0.331345>, 
      <-0.641454, -0.312276, -0.141691>, <-0.457088, -0.402030, -0.141691>, <-0.205053, -0.442026, -0.145571>, <0.000000, -0.442026, -0.145571>, 
      <-0.562843, -0.254651, 0.099942>, <-0.426544, -0.321005, 0.099942>, <-0.151593, -0.360787, 0.093773>, <0.000000, -0.360787, 0.093773>, 
      <-0.495339, -0.241143, 0.279495>, <-0.359040, -0.307497, 0.279495>, <-0.151593, -0.341028, 0.279495>, <0.000000, -0.341028, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.947556, 0.000000, -0.331345>, <-0.947556, -0.128483, -0.331345>, <-0.785545, -0.269946, -0.331345>, <-0.670024, -0.326184, -0.331345>, 
      <-0.906369, 0.000000, -0.138012>, <-0.906369, -0.128483, -0.138012>, <-0.756975, -0.256037, -0.141691>, <-0.641454, -0.312276, -0.141691>, 
      <-0.793313, 0.000000, 0.104960>, <-0.793313, -0.094986, 0.104960>, <-0.648246, -0.213075, 0.099942>, <-0.562843, -0.254651, 0.099942>, 
      <-0.700515, 0.000000, 0.279495>, <-0.700515, -0.094986, 0.279495>, <-0.580742, -0.199567, 0.279495>, <-0.495339, -0.241143, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.670024, 0.326184, -0.331345>, <-0.785545, 0.269946, -0.331345>, <-0.947556, 0.128483, -0.331345>, <-0.947556, 0.000000, -0.331345>, 
      <-0.641454, 0.312276, -0.141691>, <-0.756975, 0.256037, -0.141691>, <-0.906369, 0.128483, -0.138012>, <-0.906369, 0.000000, -0.138012>, 
      <-0.562843, 0.254651, 0.099942>, <-0.648246, 0.213075, 0.099942>, <-0.793313, 0.094986, 0.104960>, <-0.793313, 0.000000, 0.104960>, 
      <-0.495339, 0.241143, 0.279495>, <-0.580742, 0.199567, 0.279495>, <-0.700515, 0.094986, 0.279495>, <-0.700515, 0.000000, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.461293, -0.331345>, <-0.205053, 0.461293, -0.331345>, <-0.485658, 0.415938, -0.331345>, <-0.670024, 0.326184, -0.331345>, 
      <0.000000, 0.442026, -0.145571>, <-0.205053, 0.442026, -0.145571>, <-0.457088, 0.402030, -0.141691>, <-0.641454, 0.312276, -0.141691>, 
      <0.000000, 0.360787, 0.093773>, <-0.151593, 0.360787, 0.093773>, <-0.426544, 0.321005, 0.099942>, <-0.562843, 0.254651, 0.099942>, 
      <0.000000, 0.341028, 0.279495>, <-0.151593, 0.341028, 0.279495>, <-0.359040, 0.307497, 0.279495>, <-0.495339, 0.241143, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.670024, 0.326184, -0.331345>, <0.485658, 0.415938, -0.331345>, <0.205053, 0.461293, -0.331345>, <0.000000, 0.461293, -0.331345>, 
      <0.641454, 0.312276, -0.141691>, <0.457088, 0.402030, -0.141691>, <0.205053, 0.442026, -0.145571>, <0.000000, 0.442026, -0.145571>, 
      <0.562843, 0.254651, 0.099942>, <0.426544, 0.321005, 0.099942>, <0.151593, 0.360787, 0.093773>, <0.000000, 0.360787, 0.093773>, 
      <0.495339, 0.241143, 0.279495>, <0.359040, 0.307497, 0.279495>, <0.151593, 0.341028, 0.279495>, <0.000000, 0.341028, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.509070, -1.340786>, <0.226291, -0.509070, -1.340786>, <0.535957, -0.459017, -1.340786>, <0.739419, -0.359967, -1.340786>, 
      <0.000000, -0.520820, -1.037843>, <0.226291, -0.520820, -1.037843>, <0.553035, -0.467330, -1.037664>, <0.756497, -0.368281, -1.037664>, 
      <0.000000, -0.492568, -0.632899>, <0.205053, -0.492567, -0.632899>, <0.530780, -0.437904, -0.630886>, <0.715147, -0.348150, -0.630886>, 
      <0.000000, -0.461293, -0.331345>, <0.205053, -0.461293, -0.331345>, <0.485657, -0.415937, -0.331345>, <0.670024, -0.326183, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739419, -0.359967, -1.340786>, <-0.535957, -0.459017, -1.340786>, <-0.226291, -0.509070, -1.340786>, <0.000000, -0.509070, -1.340786>, 
      <-0.756497, -0.368281, -1.037664>, <-0.553035, -0.467331, -1.037664>, <-0.226291, -0.520820, -1.037843>, <0.000000, -0.520820, -1.037843>, 
      <-0.715147, -0.348151, -0.630886>, <-0.530780, -0.437905, -0.630886>, <-0.205053, -0.492568, -0.632899>, <0.000000, -0.492568, -0.632899>, 
      <-0.670024, -0.326184, -0.331345>, <-0.485658, -0.415938, -0.331345>, <-0.205053, -0.461293, -0.331345>, <0.000000, -0.461293, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045696, 0.000000, -1.340786>, <-1.045696, -0.141790, -1.340786>, <-0.866904, -0.297904, -1.340786>, <-0.739419, -0.359967, -1.340786>, 
      <-1.069861, 0.000000, -1.037487>, <-1.069861, -0.141790, -1.037487>, <-0.883982, -0.306218, -1.037664>, <-0.756497, -0.368281, -1.037664>, 
      <-1.010952, 0.000000, -0.628927>, <-1.010952, -0.128483, -0.628927>, <-0.830668, -0.291913, -0.630886>, <-0.715147, -0.348151, -0.630886>, 
      <-0.947556, 0.000000, -0.331345>, <-0.947556, -0.128483, -0.331345>, <-0.785545, -0.269946, -0.331345>, <-0.670024, -0.326184, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739419, 0.359967, -1.340786>, <-0.866904, 0.297904, -1.340786>, <-1.045696, 0.141790, -1.340786>, <-1.045696, 0.000000, -1.340786>, 
      <-0.756497, 0.368281, -1.037664>, <-0.883982, 0.306218, -1.037664>, <-1.069861, 0.141790, -1.037487>, <-1.069861, 0.000000, -1.037487>, 
      <-0.715147, 0.348151, -0.630886>, <-0.830668, 0.291913, -0.630886>, <-1.010952, 0.128483, -0.628927>, <-1.010952, 0.000000, -0.628927>, 
      <-0.670024, 0.326184, -0.331345>, <-0.785545, 0.269946, -0.331345>, <-0.947556, 0.128483, -0.331345>, <-0.947556, 0.000000, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.509070, -1.340786>, <-0.226291, 0.509070, -1.340786>, <-0.535957, 0.459017, -1.340786>, <-0.739419, 0.359967, -1.340786>, 
      <0.000000, 0.520820, -1.037843>, <-0.226291, 0.520820, -1.037843>, <-0.553035, 0.467331, -1.037664>, <-0.756497, 0.368281, -1.037664>, 
      <0.000000, 0.492568, -0.632899>, <-0.205053, 0.492568, -0.632899>, <-0.530780, 0.437905, -0.630886>, <-0.715147, 0.348151, -0.630886>, 
      <0.000000, 0.461293, -0.331345>, <-0.205053, 0.461293, -0.331345>, <-0.485658, 0.415938, -0.331345>, <-0.670024, 0.326184, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.739419, 0.359967, -1.340786>, <0.535957, 0.459017, -1.340786>, <0.226291, 0.509070, -1.340786>, <0.000000, 0.509070, -1.340786>, 
      <0.756497, 0.368281, -1.037664>, <0.553035, 0.467331, -1.037664>, <0.226291, 0.520820, -1.037843>, <0.000000, 0.520820, -1.037843>, 
      <0.715147, 0.348151, -0.630886>, <0.530780, 0.437905, -0.630886>, <0.205053, 0.492568, -0.632899>, <0.000000, 0.492568, -0.632899>, 
      <0.670024, 0.326184, -0.331345>, <0.485658, 0.415938, -0.331345>, <0.205053, 0.461293, -0.331345>, <0.000000, 0.461293, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.397042, -1.987862>, <0.176492, -0.397042, -1.987862>, <0.418011, -0.358003, -1.987862>, <0.576698, -0.280751, -1.987862>, 
      <0.000000, -0.430650, -1.793739>, <0.176492, -0.430650, -1.793739>, <0.466828, -0.381768, -1.793739>, <0.625514, -0.304516, -1.793739>, 
      <0.000000, -0.501434, -1.537649>, <0.226291, -0.501434, -1.537649>, <0.524623, -0.453500, -1.541964>, <0.728085, -0.354449, -1.541964>, 
      <0.000000, -0.509070, -1.340786>, <0.226291, -0.509070, -1.340786>, <0.535957, -0.459017, -1.340786>, <0.739419, -0.359967, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576698, -0.280751, -1.987862>, <-0.418011, -0.358003, -1.987862>, <-0.176492, -0.397042, -1.987862>, <0.000000, -0.397042, -1.987862>, 
      <-0.625514, -0.304516, -1.793739>, <-0.466828, -0.381768, -1.793739>, <-0.176492, -0.430650, -1.793739>, <0.000000, -0.430650, -1.793739>, 
      <-0.728085, -0.354449, -1.541964>, <-0.524623, -0.453499, -1.541964>, <-0.226291, -0.501434, -1.537649>, <0.000000, -0.501434, -1.537649>, 
      <-0.739419, -0.359967, -1.340786>, <-0.535957, -0.459017, -1.340786>, <-0.226291, -0.509070, -1.340786>, <0.000000, -0.509070, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.815575, 0.000000, -1.987862>, <-0.815575, -0.110587, -1.987862>, <-0.676129, -0.232346, -1.987862>, <-0.576698, -0.280751, -1.987862>, 
      <-0.884611, 0.000000, -1.793739>, <-0.884611, -0.110587, -1.793739>, <-0.724945, -0.256111, -1.793739>, <-0.625514, -0.304516, -1.793739>, 
      <-1.029332, 0.000000, -1.546168>, <-1.029332, -0.141790, -1.546168>, <-0.855570, -0.292386, -1.541964>, <-0.728085, -0.354449, -1.541964>, 
      <-1.045696, 0.000000, -1.340786>, <-1.045696, -0.141790, -1.340786>, <-0.866904, -0.297904, -1.340786>, <-0.739419, -0.359967, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576698, 0.280751, -1.987862>, <-0.676129, 0.232346, -1.987862>, <-0.815575, 0.110587, -1.987862>, <-0.815575, 0.000000, -1.987862>, 
      <-0.625514, 0.304516, -1.793739>, <-0.724945, 0.256111, -1.793739>, <-0.884611, 0.110587, -1.793739>, <-0.884611, 0.000000, -1.793739>, 
      <-0.728085, 0.354449, -1.541964>, <-0.855570, 0.292386, -1.541964>, <-1.029332, 0.141790, -1.546168>, <-1.029332, 0.000000, -1.546168>, 
      <-0.739419, 0.359967, -1.340786>, <-0.866904, 0.297904, -1.340786>, <-1.045696, 0.141790, -1.340786>, <-1.045696, 0.000000, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.397042, -1.987862>, <-0.176492, 0.397042, -1.987862>, <-0.418011, 0.358003, -1.987862>, <-0.576698, 0.280751, -1.987862>, 
      <0.000000, 0.430650, -1.793739>, <-0.176492, 0.430650, -1.793739>, <-0.466828, 0.381768, -1.793739>, <-0.625514, 0.304516, -1.793739>, 
      <0.000000, 0.501434, -1.537649>, <-0.226291, 0.501434, -1.537649>, <-0.524623, 0.453499, -1.541964>, <-0.728085, 0.354449, -1.541964>, 
      <0.000000, 0.509070, -1.340786>, <-0.226291, 0.509070, -1.340786>, <-0.535957, 0.459017, -1.340786>, <-0.739419, 0.359967, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576698, 0.280751, -1.987862>, <0.418011, 0.358003, -1.987862>, <0.176492, 0.397042, -1.987862>, <0.000000, 0.397042, -1.987862>, 
      <0.625514, 0.304516, -1.793739>, <0.466828, 0.381768, -1.793739>, <0.176492, 0.430650, -1.793739>, <0.000000, 0.430650, -1.793739>, 
      <0.728085, 0.354449, -1.541964>, <0.524623, 0.453499, -1.541964>, <0.226291, 0.501434, -1.537649>, <0.000000, 0.501434, -1.537649>, 
      <0.739419, 0.359967, -1.340786>, <0.535957, 0.459017, -1.340786>, <0.226291, 0.509070, -1.340786>, <0.000000, 0.509070, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, 
      <0.000000, -0.119113, -2.002357>, <0.000000, -0.119113, -2.002357>, <0.173009, -0.084225, -2.002357>, <0.173009, -0.084225, -2.002357>, 
      <0.000000, -0.277929, -1.994074>, <0.176492, -0.277929, -1.994074>, <0.245002, -0.273778, -1.994074>, <0.403689, -0.196526, -1.994074>, 
      <0.000000, -0.397042, -1.987862>, <0.176492, -0.397042, -1.987862>, <0.418011, -0.358003, -1.987862>, <0.576698, -0.280751, -1.987862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, 
      <-0.173009, -0.084225, -2.002357>, <-0.173009, -0.084225, -2.002357>, <0.000000, -0.119113, -2.002357>, <0.000000, -0.119113, -2.002357>, 
      <-0.403689, -0.196526, -1.994074>, <-0.245002, -0.273778, -1.994074>, <-0.176492, -0.277929, -1.994074>, <0.000000, -0.277929, -1.994074>, 
      <-0.576698, -0.280751, -1.987862>, <-0.418011, -0.358003, -1.987862>, <-0.176492, -0.397042, -1.987862>, <0.000000, -0.397042, -1.987862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, 
      <-0.244672, 0.000000, -2.002357>, <-0.244672, 0.000000, -2.002357>, <-0.173009, -0.084225, -2.002357>, <-0.173009, -0.084225, -2.002357>, 
      <-0.570902, 0.000000, -1.994074>, <-0.570902, -0.110587, -1.994074>, <-0.503119, -0.148120, -1.994074>, <-0.403689, -0.196526, -1.994074>, 
      <-0.815575, 0.000000, -1.987862>, <-0.815575, -0.110587, -1.987862>, <-0.676129, -0.232346, -1.987862>, <-0.576698, -0.280751, -1.987862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, 
      <-0.173009, 0.084225, -2.002357>, <-0.173009, 0.084225, -2.002357>, <-0.244672, 0.000000, -2.002357>, <-0.244672, 0.000000, -2.002357>, 
      <-0.403689, 0.196526, -1.994074>, <-0.503119, 0.148120, -1.994074>, <-0.570902, 0.110587, -1.994074>, <-0.570902, 0.000000, -1.994074>, 
      <-0.576698, 0.280751, -1.987862>, <-0.676129, 0.232346, -1.987862>, <-0.815575, 0.110587, -1.987862>, <-0.815575, 0.000000, -1.987862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, 
      <0.000000, 0.119113, -2.002357>, <0.000000, 0.119113, -2.002357>, <-0.173009, 0.084225, -2.002357>, <-0.173009, 0.084225, -2.002357>, 
      <0.000000, 0.277929, -1.994074>, <-0.176492, 0.277929, -1.994074>, <-0.245002, 0.273778, -1.994074>, <-0.403689, 0.196526, -1.994074>, 
      <0.000000, 0.397042, -1.987862>, <-0.176492, 0.397042, -1.987862>, <-0.418011, 0.358003, -1.987862>, <-0.576698, 0.280751, -1.987862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, 
      <0.173009, 0.084225, -2.002357>, <0.173009, 0.084225, -2.002357>, <0.000000, 0.119113, -2.002357>, <0.000000, 0.119113, -2.002357>, 
      <0.403689, 0.196526, -1.994074>, <0.245002, 0.273778, -1.994074>, <0.176492, 0.277929, -1.994074>, <0.000000, 0.277929, -1.994074>, 
      <0.576698, 0.280751, -1.987862>, <0.418011, 0.358003, -1.987862>, <0.176492, 0.397042, -1.987862>, <0.000000, 0.397042, -1.987862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.397731, 0.000000, 0.702775>, <0.397731, 0.082304, 0.702775>, <0.342927, 0.193904, 0.702775>, <0.281238, 0.248387, 0.702775>, 
      <0.351174, 0.000000, 0.827228>, <0.351174, 0.082304, 0.827228>, <0.308952, 0.193026, 0.831214>, <0.247263, 0.247509, 0.831214>, 
      <0.382981, 0.000000, 1.012468>, <0.382981, 0.077944, 1.012468>, <0.329230, 0.187579, 1.012468>, <0.270809, 0.239176, 1.012468>, 
      <0.376660, 0.000000, 1.145193>, <0.376660, 0.077944, 1.145193>, <0.324760, 0.183631, 1.145193>, <0.266339, 0.235228, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.397731, 0.000000, 0.702775>, <0.351174, 0.000000, 0.827228>, <0.382981, 0.000000, 1.012468>, <0.376660, 0.000000, 1.145193>, 
      <0.397731, -0.082304, 0.702775>, <0.351174, -0.082304, 0.827228>, <0.382981, -0.077944, 1.012468>, <0.376660, -0.077944, 1.145193>, 
      <0.342928, -0.193904, 0.702775>, <0.308953, -0.193026, 0.831214>, <0.329230, -0.187578, 1.012468>, <0.324760, -0.183630, 1.145193>, 
      <0.281239, -0.248387, 0.702775>, <0.247264, -0.247509, 0.831214>, <0.270809, -0.239175, 1.012468>, <0.266339, -0.235227, 1.145193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700515, 0.000000, 0.279495>, <0.700515, 0.094986, 0.279495>, <0.580742, 0.199567, 0.279495>, <0.495339, 0.241143, 0.279495>, 
      <0.627220, 0.000000, 0.417349>, <0.627220, 0.094986, 0.417349>, <0.530782, 0.189570, 0.412383>, <0.445379, 0.231146, 0.412383>, 
      <0.452435, 0.000000, 0.556544>, <0.452435, 0.082304, 0.556544>, <0.379322, 0.194844, 0.565190>, <0.317633, 0.249327, 0.565190>, 
      <0.397731, 0.000000, 0.702775>, <0.397731, 0.082304, 0.702775>, <0.342927, 0.193904, 0.702775>, <0.281238, 0.248387, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700515, 0.000000, 0.279495>, <0.627220, 0.000000, 0.417349>, <0.452435, 0.000000, 0.556544>, <0.397731, 0.000000, 0.702775>, 
      <0.700515, -0.094986, 0.279495>, <0.627220, -0.094986, 0.417349>, <0.452436, -0.082304, 0.556544>, <0.397731, -0.082304, 0.702775>, 
      <0.580742, -0.199567, 0.279495>, <0.530782, -0.189570, 0.412383>, <0.379323, -0.194844, 0.565190>, <0.342928, -0.193904, 0.702775>, 
      <0.495339, -0.241143, 0.279495>, <0.445379, -0.231146, 0.412383>, <0.317634, -0.249327, 0.565190>, <0.281239, -0.248387, 0.702775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.947556, 0.000000, -0.331345>, <0.947556, 0.128483, -0.331345>, <0.785545, 0.269946, -0.331345>, <0.670024, 0.326184, -0.331345>, 
      <0.906369, 0.000000, -0.138012>, <0.906369, 0.128483, -0.138012>, <0.756975, 0.256037, -0.141691>, <0.641454, 0.312276, -0.141691>, 
      <0.793313, 0.000000, 0.104960>, <0.793313, 0.094986, 0.104960>, <0.648246, 0.213075, 0.099942>, <0.562843, 0.254651, 0.099942>, 
      <0.700515, 0.000000, 0.279495>, <0.700515, 0.094986, 0.279495>, <0.580742, 0.199567, 0.279495>, <0.495339, 0.241143, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.947556, 0.000000, -0.331345>, <0.906369, 0.000000, -0.138012>, <0.793313, 0.000000, 0.104960>, <0.700515, 0.000000, 0.279495>, 
      <0.947556, -0.128483, -0.331345>, <0.906369, -0.128483, -0.138012>, <0.793313, -0.094986, 0.104960>, <0.700515, -0.094986, 0.279495>, 
      <0.785545, -0.269945, -0.331345>, <0.756975, -0.256036, -0.141691>, <0.648246, -0.213074, 0.099942>, <0.580742, -0.199567, 0.279495>, 
      <0.670024, -0.326183, -0.331345>, <0.641454, -0.312275, -0.141691>, <0.562843, -0.254651, 0.099942>, <0.495339, -0.241143, 0.279495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.045696, 0.000000, -1.340786>, <1.045696, 0.141790, -1.340786>, <0.866904, 0.297904, -1.340786>, <0.739419, 0.359967, -1.340786>, 
      <1.069861, 0.000000, -1.037487>, <1.069861, 0.141790, -1.037487>, <0.883982, 0.306218, -1.037664>, <0.756497, 0.368281, -1.037664>, 
      <1.010952, 0.000000, -0.628927>, <1.010952, 0.128483, -0.628927>, <0.830668, 0.291913, -0.630886>, <0.715147, 0.348151, -0.630886>, 
      <0.947556, 0.000000, -0.331345>, <0.947556, 0.128483, -0.331345>, <0.785545, 0.269946, -0.331345>, <0.670024, 0.326184, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.045696, 0.000000, -1.340786>, <1.069861, 0.000000, -1.037487>, <1.010952, 0.000000, -0.628927>, <0.947556, 0.000000, -0.331345>, 
      <1.045696, -0.141790, -1.340786>, <1.069861, -0.141790, -1.037487>, <1.010952, -0.128483, -0.628927>, <0.947556, -0.128483, -0.331345>, 
      <0.866904, -0.297904, -1.340786>, <0.883982, -0.306217, -1.037664>, <0.830668, -0.291912, -0.630886>, <0.785545, -0.269945, -0.331345>, 
      <0.739419, -0.359967, -1.340786>, <0.756497, -0.368281, -1.037664>, <0.715147, -0.348150, -0.630886>, <0.670024, -0.326183, -0.331345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.815575, 0.000000, -1.987862>, <0.815575, 0.110587, -1.987862>, <0.676129, 0.232346, -1.987862>, <0.576698, 0.280751, -1.987862>, 
      <0.884611, 0.000000, -1.793739>, <0.884611, 0.110587, -1.793739>, <0.724945, 0.256111, -1.793739>, <0.625514, 0.304516, -1.793739>, 
      <1.029332, 0.000000, -1.546168>, <1.029332, 0.141790, -1.546168>, <0.855570, 0.292386, -1.541964>, <0.728085, 0.354449, -1.541964>, 
      <1.045696, 0.000000, -1.340786>, <1.045696, 0.141790, -1.340786>, <0.866904, 0.297904, -1.340786>, <0.739419, 0.359967, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.815575, 0.000000, -1.987862>, <0.884611, 0.000000, -1.793739>, <1.029332, 0.000000, -1.546168>, <1.045696, 0.000000, -1.340786>, 
      <0.815575, -0.110587, -1.987862>, <0.884611, -0.110587, -1.793739>, <1.029332, -0.141790, -1.546168>, <1.045696, -0.141790, -1.340786>, 
      <0.676129, -0.232346, -1.987862>, <0.724945, -0.256111, -1.793739>, <0.855570, -0.292386, -1.541964>, <0.866904, -0.297904, -1.340786>, 
      <0.576698, -0.280751, -1.987862>, <0.625514, -0.304516, -1.793739>, <0.728085, -0.354449, -1.541964>, <0.739419, -0.359967, -1.340786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, <0.000000, 0.000000, -2.008569>, 
      <0.244672, 0.000000, -2.002357>, <0.244672, 0.000000, -2.002357>, <0.173009, 0.084225, -2.002357>, <0.173009, 0.084225, -2.002357>, 
      <0.570902, 0.000000, -1.994074>, <0.570902, 0.110587, -1.994074>, <0.503119, 0.148120, -1.994074>, <0.403689, 0.196526, -1.994074>, 
      <0.815575, 0.000000, -1.987862>, <0.815575, 0.110587, -1.987862>, <0.676129, 0.232346, -1.987862>, <0.576698, 0.280751, -1.987862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -2.008569>, <0.244672, 0.000000, -2.002357>, <0.570902, 0.000000, -1.994074>, <0.815575, 0.000000, -1.987862>, 
      <0.000000, 0.000000, -2.008569>, <0.244672, 0.000000, -2.002357>, <0.570902, -0.110587, -1.994074>, <0.815575, -0.110587, -1.987862>, 
      <0.000000, 0.000000, -2.008569>, <0.173009, -0.084225, -2.002357>, <0.503119, -0.148120, -1.994074>, <0.676129, -0.232346, -1.987862>, 
      <0.000000, 0.000000, -2.008569>, <0.173009, -0.084225, -2.002357>, <0.403689, -0.196526, -1.994074>, <0.576698, -0.280751, -1.987862>
    }
  }
  material {
    Crystal
  }
}
#declare SyrupBottle = union { // SyrupBottle
  object { sPatchObj4 }
  object { sPatchObj5 }
  object { Syrupyies }
  object { sPatchObj6 }
  scale 6.256825
  rotate 41.100445*z
  translate  <-16.200476, 1.620048, 13.575243>
}




#declare SB1 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  material {
    DMFWood4
  }
  scale <-0.558382, -1.265598, -24.216471>
  rotate -180.0*x
}
#declare R1 = object {
  cylinder { // R1
    <0,0,1>, <0,0,0>, 1 
    material {
      DMFWood4
    }
    scale <0.342803, 0.342803, 4.694511>
    rotate -90.0*y
    translate  <4.774688, 0.035524, -9.247775>
  }
}




#declare MHEAD = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.490166, -0.199340, -0.072423>, <-0.485124, -0.198864, -0.196553>, <-0.461051, -0.237891, -0.378189>, <-0.374973, -0.249389, -0.467027>, 
      <-0.422097, 0.164818, -0.065063>, <-0.417055, 0.165294, -0.189192>, <-0.408559, 0.123911, -0.319293>, <-0.322481, 0.112412, -0.408131>, 
      <-0.267962, 0.634632, -0.021114>, <-0.276750, 0.626750, -0.076484>, <-0.242209, 0.609942, -0.225865>, <-0.217076, 0.575193, -0.262824>, 
      <-0.172732, 0.992048, 0.000875>, <-0.181519, 0.984166, -0.054494>, <-0.174539, 0.963334, -0.138349>, <-0.149406, 0.928585, -0.175308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.409268, -0.252625, 0.377228>, <-0.497846, -0.243663, 0.271800>, <-0.495767, -0.199869, 0.065452>, <-0.490166, -0.199340, -0.072423>, 
      <-0.354333, 0.126793, 0.329899>, <-0.442910, 0.135754, 0.224471>, <-0.427698, 0.164290, 0.072813>, <-0.422097, 0.164818, -0.065063>, 
      <-0.196336, 0.602052, 0.185961>, <-0.217565, 0.585787, 0.159424>, <-0.262114, 0.639877, 0.015733>, <-0.267962, 0.634632, -0.021114>, 
      <-0.105080, 0.968342, 0.103989>, <-0.126309, 0.952077, 0.077452>, <-0.166884, 0.997293, 0.037722>, <-0.172732, 0.992048, 0.000875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.006403, -0.248284, 0.503367>, <-0.133009, -0.249803, 0.506424>, <-0.327969, -0.260850, 0.473993>, <-0.409268, -0.252625, 0.377228>, 
      <-0.012692, 0.168852, 0.451675>, <-0.139297, 0.167334, 0.454732>, <-0.273033, 0.118567, 0.426664>, <-0.354333, 0.126793, 0.329899>, 
      <-0.003380, 0.711470, 0.300946>, <-0.067798, 0.717922, 0.302787>, <-0.159842, 0.630012, 0.231580>, <-0.196336, 0.602052, 0.185961>, 
      <-0.002084, 1.122793, 0.214194>, <-0.066502, 1.129245, 0.216035>, <-0.068586, 0.996303, 0.149609>, <-0.105080, 0.968342, 0.103989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.379746, -0.243161, 0.358179>, <0.290312, -0.241045, 0.443716>, <0.117324, -0.246800, 0.500380>, <-0.006403, -0.248284, 0.503367>, 
      <0.334066, 0.120760, 0.307045>, <0.244632, 0.122876, 0.392582>, <0.111036, 0.170336, 0.448688>, <-0.012692, 0.168852, 0.451675>, 
      <0.222924, 0.586606, 0.175028>, <0.161044, 0.581412, 0.225678>, <0.076324, 0.703487, 0.298667>, <-0.003380, 0.711470, 0.300946>, 
      <0.155714, 0.942220, 0.096534>, <0.093834, 0.937026, 0.147184>, <0.077619, 1.114810, 0.211916>, <-0.002084, 1.122793, 0.214194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.574472, -0.262027, -0.052196>, <0.571797, -0.256580, 0.084056>, <0.478295, -0.245493, 0.263924>, <0.379746, -0.243161, 0.358179>, 
      <0.524679, 0.167060, -0.043606>, <0.522004, 0.172507, 0.092645>, <0.432615, 0.118429, 0.212790>, <0.334066, 0.120760, 0.307045>, 
      <0.364567, 0.723603, -0.024259>, <0.366370, 0.732625, 0.053144>, <0.283115, 0.591658, 0.125759>, <0.222924, 0.586606, 0.175028>, 
      <0.274608, 1.146016, -0.012286>, <0.276411, 1.155038, 0.065117>, <0.215906, 0.947272, 0.047266>, <0.155714, 0.942220, 0.096534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.395781, -0.275817, -0.458703>, <0.497097, -0.275765, -0.372111>, <0.577086, -0.267350, -0.185343>, <0.574472, -0.262027, -0.052196>, 
      <0.350083, 0.090011, -0.420509>, <0.451399, 0.090063, -0.333917>, <0.527292, 0.161737, -0.176753>, <0.524679, 0.167060, -0.043606>, 
      <0.222854, 0.552392, -0.279510>, <0.268832, 0.626387, -0.232316>, <0.362275, 0.712135, -0.122644>, <0.364567, 0.723603, -0.024259>, 
      <0.148743, 0.907339, -0.202713>, <0.194720, 0.981334, -0.155519>, <0.272316, 1.134548, -0.110671>, <0.274608, 1.146016, -0.012286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.499163, -0.754305, -0.034422>, <-0.506268, -0.758079, -0.165192>, <-0.494291, -0.799067, -0.365633>, <-0.400575, -0.802613, -0.457122>, 
      <-0.523333, -0.589200, -0.037914>, <-0.530438, -0.592974, -0.168684>, <-0.523039, -0.637748, -0.393254>, <-0.429323, -0.641295, -0.484743>, 
      <-0.520826, -0.363367, -0.075738>, <-0.515784, -0.362892, -0.199868>, <-0.484606, -0.400247, -0.404618>, <-0.398528, -0.411745, -0.493456>, 
      <-0.490166, -0.199340, -0.072423>, <-0.485124, -0.198864, -0.196553>, <-0.461051, -0.237891, -0.378189>, <-0.374973, -0.249389, -0.467027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.358237, -0.780123, 0.322095>, <-0.442228, -0.768999, 0.243937>, <-0.492912, -0.750984, 0.080629>, <-0.499163, -0.754305, -0.034422>, 
      <-0.387822, -0.625742, 0.351116>, <-0.471813, -0.614619, 0.272958>, <-0.517082, -0.585880, 0.077137>, <-0.523333, -0.589200, -0.037914>, 
      <-0.432000, -0.409630, 0.396813>, <-0.520578, -0.400668, 0.291385>, <-0.526427, -0.363896, 0.062137>, <-0.520826, -0.363367, -0.075738>, 
      <-0.409268, -0.252625, 0.377228>, <-0.497846, -0.243663, 0.271800>, <-0.495767, -0.199869, 0.065452>, <-0.490166, -0.199340, -0.072423>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.027265, -0.824026, 0.455447>, <-0.095719, -0.828410, 0.453281>, <-0.268554, -0.792001, 0.405550>, <-0.358237, -0.780123, 0.322095>, 
      <0.015109, -0.657407, 0.502693>, <-0.107875, -0.661791, 0.500527>, <-0.298138, -0.637620, 0.434571>, <-0.387822, -0.625742, 0.351116>, 
      <-0.003806, -0.420561, 0.524716>, <-0.130412, -0.422079, 0.527772>, <-0.350701, -0.417855, 0.493578>, <-0.432000, -0.409630, 0.396813>, 
      <-0.006403, -0.248284, 0.503367>, <-0.133009, -0.249803, 0.506424>, <-0.327969, -0.260850, 0.473993>, <-0.409268, -0.252625, 0.377228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.368652, -0.754213, 0.334898>, <0.293658, -0.763061, 0.415727>, <0.137792, -0.820086, 0.457394>, <0.027265, -0.824026, 0.455447>, 
      <0.401321, -0.609621, 0.374792>, <0.326327, -0.618469, 0.455620>, <0.125636, -0.653468, 0.504640>, <0.015109, -0.657407, 0.502693>, 
      <0.398682, -0.394018, 0.379376>, <0.309248, -0.391902, 0.464913>, <0.119921, -0.419077, 0.521729>, <-0.003806, -0.420561, 0.524716>, 
      <0.379746, -0.243161, 0.358179>, <0.290312, -0.241045, 0.443716>, <0.117324, -0.246800, 0.500380>, <-0.006403, -0.248284, 0.503367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.496794, -0.768631, -0.050614>, <0.499131, -0.770358, 0.071303>, <0.451332, -0.744458, 0.245785>, <0.368652, -0.754213, 0.334898>, 
      <0.539695, -0.620979, -0.050826>, <0.542032, -0.622706, 0.071092>, <0.484001, -0.599867, 0.285679>, <0.401321, -0.609621, 0.374792>, 
      <0.592193, -0.414730, -0.055253>, <0.589518, -0.409283, 0.080999>, <0.497231, -0.396349, 0.285121>, <0.398682, -0.394018, 0.379376>, 
      <0.574472, -0.262027, -0.052196>, <0.571797, -0.256580, 0.084056>, <0.478295, -0.245493, 0.263924>, <0.379746, -0.243161, 0.358179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.355044, -0.744157, -0.375135>, <0.427870, -0.743277, -0.297443>, <0.494754, -0.767123, -0.157076>, <0.496794, -0.768631, -0.050614>, 
      <0.380570, -0.606889, -0.407145>, <0.453397, -0.606009, -0.329453>, <0.537655, -0.619472, -0.157287>, <0.539695, -0.620979, -0.050826>, 
      <0.413442, -0.417199, -0.473464>, <0.514758, -0.417147, -0.386872>, <0.594806, -0.420053, -0.188399>, <0.592193, -0.414730, -0.055253>, 
      <0.395781, -0.275817, -0.458703>, <0.497097, -0.275765, -0.372111>, <0.577086, -0.267350, -0.185343>, <0.574472, -0.262027, -0.052196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.357316, -1.106838, -0.053229>, <-0.353002, -1.109070, -0.142779>, <-0.291297, -1.118972, -0.263795>, <-0.221338, -1.111522, -0.319411>, 
      <-0.437303, -1.025689, -0.046545>, <-0.432989, -1.027921, -0.136095>, <-0.349557, -1.051109, -0.335814>, <-0.279599, -1.043660, -0.391430>, 
      <-0.482634, -0.867216, -0.032034>, <-0.489739, -0.870991, -0.162804>, <-0.474426, -0.910545, -0.346545>, <-0.380709, -0.914091, -0.438035>, 
      <-0.499163, -0.754305, -0.034422>, <-0.506268, -0.758079, -0.165192>, <-0.494291, -0.799067, -0.365633>, <-0.400575, -0.802613, -0.457122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247241, -1.098118, 0.218291>, <-0.317154, -1.099253, 0.164968>, <-0.361546, -1.104649, 0.034576>, <-0.357316, -1.106838, -0.053229>, 
      <-0.299010, -1.022478, 0.270998>, <-0.368923, -1.023613, 0.217675>, <-0.441533, -1.023500, 0.041260>, <-0.437303, -1.025689, -0.046545>, 
      <-0.338668, -0.882241, 0.302899>, <-0.422658, -0.871117, 0.224741>, <-0.476383, -0.863896, 0.083017>, <-0.482634, -0.867216, -0.032034>, 
      <-0.358237, -0.780123, 0.322095>, <-0.442228, -0.768999, 0.243937>, <-0.492912, -0.750984, 0.080629>, <-0.499163, -0.754305, -0.034422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.055747, -1.100135, 0.261817>, <-0.033894, -1.112133, 0.277744>, <-0.174230, -1.096933, 0.273977>, <-0.247241, -1.098118, 0.218291>, 
      <0.063282, -1.038926, 0.342472>, <-0.026358, -1.050924, 0.358399>, <-0.225999, -1.021293, 0.326684>, <-0.299010, -1.022478, 0.270998>, 
      <0.034374, -0.921466, 0.427817>, <-0.088610, -0.925850, 0.425651>, <-0.248984, -0.894118, 0.386354>, <-0.338668, -0.882241, 0.302899>, 
      <0.027265, -0.824026, 0.455447>, <-0.095719, -0.828410, 0.453281>, <-0.268554, -0.792001, 0.405550>, <-0.358237, -0.780123, 0.322095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.200108, -1.038243, 0.138810>, <0.160712, -1.037422, 0.183859>, <0.114170, -1.092315, 0.251437>, <0.055747, -1.100135, 0.261817>, 
      <0.252595, -0.958322, 0.203118>, <0.213199, -0.957500, 0.248167>, <0.121705, -1.031106, 0.332092>, <0.063282, -1.038926, 0.342472>, 
      <0.344130, -0.862747, 0.304953>, <0.269137, -0.871595, 0.385781>, <0.144901, -0.917527, 0.429764>, <0.034374, -0.921466, 0.427817>, 
      <0.368652, -0.754213, 0.334898>, <0.293658, -0.763061, 0.415727>, <0.137792, -0.820086, 0.457394>, <0.027265, -0.824026, 0.455447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.329297, -1.105839, -0.050987>, <0.321814, -1.095635, 0.019690>, <0.247370, -1.039229, 0.084766>, <0.200108, -1.038243, 0.138810>, 
      <0.408546, -1.025359, -0.049816>, <0.401064, -1.015156, 0.020861>, <0.299856, -0.959307, 0.149074>, <0.252595, -0.958322, 0.203118>, 
      <0.465278, -0.877100, -0.050459>, <0.467614, -0.878827, 0.071459>, <0.426810, -0.852993, 0.215839>, <0.344130, -0.862747, 0.304953>, 
      <0.496794, -0.768631, -0.050614>, <0.499131, -0.770358, 0.071303>, <0.451332, -0.744458, 0.245785>, <0.368652, -0.754213, 0.334898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.243098, -1.096865, -0.267239>, <0.287774, -1.103794, -0.213939>, <0.336581, -1.115771, -0.119785>, <0.329297, -1.105839, -0.050987>, 
      <0.305109, -1.010737, -0.313156>, <0.349785, -1.017665, -0.259856>, <0.415830, -1.035292, -0.118614>, <0.408546, -1.025359, -0.049816>, 
      <0.334437, -0.854970, -0.349294>, <0.407264, -0.854090, -0.271602>, <0.463237, -0.875592, -0.156920>, <0.465278, -0.877100, -0.050459>, 
      <0.355044, -0.744157, -0.375135>, <0.427870, -0.743277, -0.297443>, <0.494754, -0.767123, -0.157076>, <0.496794, -0.768631, -0.050614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.100920, -1.158334, -0.067701>, <-0.101631, -1.157065, -0.071152>, <-0.095242, -1.160846, -0.073979>, <-0.092183, -1.161827, -0.075904>, 
      <-0.175470, -1.133531, -0.066621>, <-0.176180, -1.132262, -0.070072>, <-0.150974, -1.145436, -0.134989>, <-0.147915, -1.146417, -0.136914>, 
      <-0.302252, -1.162702, -0.057830>, <-0.297938, -1.164934, -0.147381>, <-0.248649, -1.168647, -0.211077>, <-0.178691, -1.161197, -0.266693>, 
      <-0.357316, -1.106838, -0.053229>, <-0.353002, -1.109070, -0.142779>, <-0.291297, -1.118972, -0.263795>, <-0.221338, -1.111522, -0.319411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.070543, -1.200471, 0.029191>, <-0.095723, -1.198201, 0.008011>, <-0.094662, -1.169510, -0.037308>, <-0.100920, -1.158334, -0.067701>, 
      <-0.116094, -1.170929, 0.092622>, <-0.141273, -1.168658, 0.071442>, <-0.169212, -1.144707, -0.036228>, <-0.175470, -1.133531, -0.066621>, 
      <-0.206361, -1.157848, 0.176670>, <-0.276273, -1.158982, 0.123348>, <-0.306482, -1.160513, 0.029975>, <-0.302252, -1.162702, -0.057830>, 
      <-0.247241, -1.098118, 0.218291>, <-0.317154, -1.099253, 0.164968>, <-0.361546, -1.104649, 0.034576>, <-0.357316, -1.106838, -0.053229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014846, -1.166096, 0.004702>, <-0.035059, -1.171315, 0.006633>, <-0.054538, -1.201914, 0.042654>, <-0.070543, -1.200471, 0.029191>, 
      <0.011622, -1.139257, 0.077975>, <-0.008591, -1.144476, 0.079906>, <-0.100088, -1.172372, 0.106086>, <-0.116094, -1.170929, 0.092622>, 
      <0.049632, -1.149811, 0.196359>, <-0.040009, -1.161809, 0.212286>, <-0.133349, -1.156663, 0.232357>, <-0.206361, -1.157848, 0.176670>, 
      <0.055747, -1.100135, 0.261817>, <-0.033894, -1.112133, 0.277744>, <-0.174230, -1.096933, 0.273977>, <-0.247241, -1.098118, 0.218291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105419, -1.155038, 0.012376>, <0.073272, -1.154054, 0.029217>, <0.020156, -1.157058, 0.001357>, <-0.014846, -1.166096, 0.004702>, 
      <0.146516, -1.129183, 0.045780>, <0.114369, -1.128199, 0.062621>, <0.046624, -1.130219, 0.074630>, <0.011622, -1.139257, 0.077975>, 
      <0.173263, -1.079119, 0.105919>, <0.133868, -1.078298, 0.150968>, <0.108055, -1.141991, 0.185979>, <0.049632, -1.149811, 0.196359>, 
      <0.200108, -1.038243, 0.138810>, <0.160712, -1.037422, 0.183859>, <0.114170, -1.092315, 0.251437>, <0.055747, -1.100135, 0.261817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101887, -1.169668, -0.056449>, <0.110542, -1.165647, -0.037591>, <0.124134, -1.155611, 0.002572>, <0.105419, -1.155038, 0.012376>, 
      <0.171095, -1.154446, -0.054943>, <0.179750, -1.150425, -0.036085>, <0.165232, -1.129755, 0.035976>, <0.146516, -1.129183, 0.045780>, 
      <0.279569, -1.156339, -0.051722>, <0.272086, -1.146136, 0.018955>, <0.220525, -1.080105, 0.051875>, <0.173263, -1.079119, 0.105919>, 
      <0.329297, -1.105839, -0.050987>, <0.321814, -1.095635, 0.019690>, <0.247370, -1.039229, 0.084766>, <0.200108, -1.038243, 0.138810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.035992, -1.187292, -0.138892>, <0.064686, -1.184088, -0.124863>, <0.088741, -1.175775, -0.085091>, <0.101887, -1.169668, -0.056449>, 
      <0.093755, -1.171149, -0.188709>, <0.122450, -1.167945, -0.174679>, <0.157949, -1.160553, -0.083585>, <0.171095, -1.154446, -0.054943>, 
      <0.201287, -1.154936, -0.236280>, <0.245963, -1.161865, -0.182980>, <0.286853, -1.166272, -0.120519>, <0.279569, -1.156339, -0.051722>, 
      <0.243098, -1.096865, -0.267239>, <0.287774, -1.103794, -0.213939>, <0.336581, -1.115771, -0.119785>, <0.329297, -1.105839, -0.050987>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046858, -1.210127, -0.057726>, <-0.035956, -1.199081, -0.068286>, <-0.021629, -1.181266, -0.079013>, <-0.011294, -1.169600, -0.089475>, 
      <-0.063077, -1.194589, -0.060719>, <-0.052175, -1.183544, -0.071278>, <-0.045896, -1.178935, -0.074942>, <-0.035561, -1.167268, -0.085404>, 
      <-0.079422, -1.165487, -0.068012>, <-0.080132, -1.164217, -0.071463>, <-0.078855, -1.165378, -0.056040>, <-0.075796, -1.166358, -0.057965>, 
      <-0.100920, -1.158334, -0.067701>, <-0.101631, -1.157065, -0.071152>, <-0.095242, -1.160846, -0.073979>, <-0.092183, -1.161827, -0.075904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060365, -1.219318, -0.041943>, <-0.058659, -1.219484, -0.048539>, <-0.050816, -1.214137, -0.053892>, <-0.046858, -1.210127, -0.057726>, 
      <-0.063418, -1.213664, -0.020603>, <-0.061713, -1.213830, -0.027199>, <-0.067034, -1.198599, -0.056885>, <-0.063077, -1.194589, -0.060719>, 
      <-0.058384, -1.208357, 0.012259>, <-0.083564, -1.206086, -0.008921>, <-0.073164, -1.176662, -0.037620>, <-0.079422, -1.165487, -0.068012>, 
      <-0.070543, -1.200471, 0.029191>, <-0.095723, -1.198201, 0.008011>, <-0.094662, -1.169510, -0.037308>, <-0.100920, -1.158334, -0.067701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.052207, -1.209605, -0.037042>, <-0.054744, -1.212726, -0.036359>, <-0.061386, -1.219218, -0.037995>, <-0.060365, -1.219318, -0.041943>, 
      <-0.040999, -1.196552, -0.024519>, <-0.043535, -1.199673, -0.023836>, <-0.064439, -1.213564, -0.016654>, <-0.063418, -1.213664, -0.020603>, 
      <-0.021681, -1.173027, -0.014221>, <-0.041894, -1.178246, -0.012289>, <-0.042379, -1.209800, 0.025723>, <-0.058384, -1.208357, 0.012259>, 
      <-0.014846, -1.166096, 0.004702>, <-0.035059, -1.171315, 0.006633>, <-0.054538, -1.201914, 0.042654>, <-0.070543, -1.200471, 0.029191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.031751, -1.184110, -0.049646>, <-0.040359, -1.189139, -0.046320>, <-0.045672, -1.201564, -0.038801>, <-0.052207, -1.209605, -0.037042>, 
      <0.009400, -1.175388, -0.031039>, <0.000792, -1.180418, -0.027713>, <-0.034464, -1.188511, -0.026278>, <-0.040999, -1.196552, -0.024519>, 
      <0.073344, -1.175217, -0.013695>, <0.041196, -1.174233, 0.003146>, <0.013321, -1.163990, -0.017566>, <-0.021681, -1.173027, -0.014221>, 
      <0.105419, -1.155038, 0.012376>, <0.073272, -1.154054, 0.029217>, <0.020156, -1.157058, 0.001357>, <-0.014846, -1.166096, 0.004702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002296, -1.177761, -0.058103>, <-0.006499, -1.181890, -0.053632>, <-0.022991, -1.178992, -0.053031>, <-0.031751, -1.184110, -0.049646>, 
      <0.032173, -1.175333, -0.057607>, <0.023378, -1.179462, -0.053136>, <0.018160, -1.170270, -0.034424>, <0.009400, -1.175388, -0.031039>, 
      <0.072614, -1.176106, -0.057086>, <0.081269, -1.172085, -0.038228>, <0.092059, -1.175790, -0.023499>, <0.073344, -1.175217, -0.013695>, 
      <0.101887, -1.169668, -0.056449>, <0.110542, -1.165647, -0.037591>, <0.124134, -1.155611, 0.002572>, <0.105419, -1.155038, 0.012376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.023168, -1.158329, -0.077565>, <0.021676, -1.163461, -0.068693>, <0.010813, -1.173763, -0.062433>, <0.002296, -1.177761, -0.058103>, 
      <0.027015, -1.167018, -0.095963>, <0.025523, -1.172149, -0.087091>, <0.040691, -1.171335, -0.061937>, <0.032173, -1.175333, -0.057607>, 
      <0.020651, -1.191579, -0.125661>, <0.049345, -1.188376, -0.111632>, <0.059468, -1.182214, -0.085728>, <0.072614, -1.176106, -0.057086>, 
      <0.035992, -1.187292, -0.138892>, <0.064686, -1.184088, -0.124863>, <0.088741, -1.175775, -0.085091>, <0.101887, -1.169668, -0.056449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.018617, -0.262330, -0.559092>, <0.109280, -0.266715, -0.557711>, <0.298493, -0.275867, -0.541852>, <0.395781, -0.275817, -0.458703>, 
      <-0.021126, 0.042496, -0.503879>, <0.106771, 0.038110, -0.502498>, <0.252795, 0.089962, -0.503658>, <0.350083, 0.090011, -0.420509>, 
      <0.005917, 0.432659, -0.361833>, <0.075379, 0.427709, -0.368218>, <0.190403, 0.500165, -0.312820>, <0.222854, 0.552392, -0.279510>, 
      <0.016431, 0.730511, -0.277294>, <0.085894, 0.725561, -0.283679>, <0.116291, 0.855112, -0.236023>, <0.148743, 0.907339, -0.202713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.018617, -0.262330, -0.559092>, <-0.021126, 0.042496, -0.503879>, <0.005917, 0.432659, -0.361833>, <0.016431, 0.730511, -0.277294>, 
      <-0.129031, -0.258544, -0.560284>, <-0.131540, 0.046282, -0.505072>, <-0.076846, 0.438556, -0.354226>, <-0.066331, 0.736409, -0.269687>, 
      <-0.298420, -0.259615, -0.546034>, <-0.245929, 0.102186, -0.487138>, <-0.180087, 0.524052, -0.317217>, <-0.112417, 0.877444, -0.229702>, 
      <-0.374973, -0.249389, -0.467027>, <-0.322481, 0.112412, -0.408131>, <-0.217076, 0.575193, -0.262824>, <-0.149406, 0.928585, -0.175308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.018617, -0.262330, -0.559092>, <-0.017368, -0.414124, -0.586586>, <0.015293, -0.624319, -0.583415>, <0.028818, -0.774285, -0.549856>, 
      <0.109280, -0.266715, -0.557711>, <0.110529, -0.418510, -0.585205>, <0.125705, -0.615777, -0.571435>, <0.139230, -0.765743, -0.537876>, 
      <0.298493, -0.275867, -0.541852>, <0.316154, -0.417249, -0.556613>, <0.304396, -0.607810, -0.488409>, <0.278869, -0.745077, -0.456399>, 
      <0.395781, -0.275817, -0.458703>, <0.413442, -0.417199, -0.473464>, <0.380570, -0.606889, -0.407145>, <0.355044, -0.744157, -0.375135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.018617, -0.262330, -0.559092>, <-0.129031, -0.258544, -0.560284>, <-0.298420, -0.259615, -0.546034>, <-0.374973, -0.249389, -0.467027>, 
      <-0.017368, -0.414124, -0.586586>, <-0.127781, -0.410338, -0.587779>, <-0.321976, -0.421971, -0.572463>, <-0.398528, -0.411745, -0.493456>, 
      <0.015293, -0.624319, -0.583415>, <-0.115612, -0.634446, -0.597618>, <-0.334859, -0.644869, -0.576961>, <-0.429323, -0.641295, -0.484743>, 
      <0.028818, -0.774285, -0.549856>, <-0.102086, -0.784412, -0.564060>, <-0.306112, -0.806188, -0.549340>, <-0.400575, -0.802613, -0.457122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.053602, -1.063081, -0.379904>, <0.120061, -1.060984, -0.372438>, <0.200328, -1.090232, -0.318265>, <0.243098, -1.096865, -0.267239>, 
      <0.062223, -0.994068, -0.452870>, <0.128681, -0.991971, -0.445404>, <0.262340, -1.004103, -0.364182>, <0.305109, -1.010737, -0.313156>, 
      <0.037656, -0.872276, -0.527928>, <0.148068, -0.863734, -0.515948>, <0.258263, -0.855890, -0.430558>, <0.334437, -0.854970, -0.349294>, 
      <0.028818, -0.774285, -0.549856>, <0.139230, -0.765743, -0.537876>, <0.278869, -0.745077, -0.456399>, <0.355044, -0.744157, -0.375135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.053602, -1.063081, -0.379904>, <0.062223, -0.994068, -0.452870>, <0.037656, -0.872276, -0.527928>, <0.028818, -0.774285, -0.549856>, 
      <-0.031517, -1.065767, -0.389466>, <-0.022896, -0.996754, -0.462431>, <-0.093249, -0.882403, -0.542132>, <-0.102086, -0.784412, -0.564060>, 
      <-0.154489, -1.104404, -0.372555>, <-0.212750, -1.036541, -0.444574>, <-0.286246, -0.917666, -0.530253>, <-0.306112, -0.806188, -0.549340>, 
      <-0.221338, -1.111522, -0.319411>, <-0.279599, -1.043660, -0.391430>, <-0.380709, -0.914091, -0.438035>, <-0.400575, -0.802613, -0.457122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.053602, -1.063081, -0.379904>, <0.045935, -1.124459, -0.315011>, <-0.008955, -1.157594, -0.201939>, <-0.022302, -1.183534, -0.117168>, 
      <0.120061, -1.060984, -0.372438>, <0.112394, -1.122361, -0.307546>, <0.007564, -1.160877, -0.210057>, <-0.005782, -1.186816, -0.125286>, 
      <0.200328, -1.090232, -0.318265>, <0.158518, -1.148303, -0.287306>, <0.077042, -1.173015, -0.196880>, <0.019279, -1.189158, -0.147063>, 
      <0.243098, -1.096865, -0.267239>, <0.201287, -1.154936, -0.236280>, <0.093755, -1.171149, -0.188709>, <0.035992, -1.187292, -0.138892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.053602, -1.063081, -0.379904>, <-0.031517, -1.065767, -0.389466>, <-0.154489, -1.104404, -0.372555>, <-0.221338, -1.111522, -0.319411>, 
      <0.045935, -1.124459, -0.315011>, <-0.039183, -1.127145, -0.324573>, <-0.111842, -1.154079, -0.319837>, <-0.178691, -1.161197, -0.266693>, 
      <-0.008955, -1.157594, -0.201939>, <-0.031223, -1.153171, -0.190996>, <-0.127328, -1.153016, -0.149867>, <-0.147915, -1.146417, -0.136914>, 
      <-0.022302, -1.183534, -0.117168>, <-0.044569, -1.179110, -0.106225>, <-0.071596, -1.168426, -0.088857>, <-0.092183, -1.161827, -0.075904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012307, -1.143340, -0.117618>, <0.024260, -1.139431, -0.113487>, <0.025075, -1.151771, -0.088904>, <0.023168, -1.158329, -0.077565>, 
      <0.001924, -1.155398, -0.117483>, <0.013877, -1.151489, -0.113352>, <0.028923, -1.160460, -0.107302>, <0.027015, -1.167018, -0.095963>, 
      <-0.024671, -1.188138, -0.102121>, <-0.008151, -1.191420, -0.110239>, <0.003938, -1.193445, -0.133833>, <0.020651, -1.191579, -0.125661>, 
      <-0.022302, -1.183534, -0.117168>, <-0.005782, -1.186816, -0.125286>, <0.019279, -1.189158, -0.147063>, <0.035992, -1.187292, -0.138892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012307, -1.143340, -0.117618>, <0.001924, -1.155398, -0.117483>, <-0.024671, -1.188138, -0.102121>, <-0.022302, -1.183534, -0.117168>, 
      <0.000076, -1.147340, -0.121845>, <-0.010307, -1.159399, -0.121710>, <-0.046939, -1.183714, -0.091178>, <-0.044569, -1.179110, -0.106225>, 
      <-0.003836, -1.161182, -0.097024>, <-0.028103, -1.158850, -0.092953>, <-0.055209, -1.172957, -0.070918>, <-0.071596, -1.168426, -0.088857>, 
      <-0.011294, -1.169600, -0.089475>, <-0.035561, -1.167268, -0.085404>, <-0.075796, -1.166358, -0.057965>, <-0.092183, -1.161827, -0.075904>
    }
  }
  material {
    ZMatchjheadt
  }
}
#declare MatchStickB = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, 
      <0.050754, 5.906773, -0.090138>, <0.050754, 5.906773, -0.090138>, <-0.102124, 5.906773, -0.090138>, <-0.102124, 5.906773, -0.090138>, 
      <0.223989, 6.014663, -0.264092>, <0.071111, 6.014663, -0.264092>, <-0.123417, 6.014703, -0.264091>, <-0.276296, 6.014703, -0.264091>, 
      <0.229112, 5.906773, -0.268496>, <0.076234, 5.906773, -0.268496>, <-0.127604, 5.906773, -0.268496>, <-0.280482, 5.906773, -0.268496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, 
      <0.050754, 5.906773, 0.062740>, <0.050754, 5.906773, 0.062740>, <0.050754, 5.906773, -0.090138>, <0.050754, 5.906773, -0.090138>, 
      <0.223990, 6.014641, 0.236195>, <0.223990, 6.014641, 0.083317>, <0.223989, 6.014663, -0.111214>, <0.223989, 6.014663, -0.264092>, 
      <0.229112, 5.906773, 0.241098>, <0.229112, 5.906773, 0.088220>, <0.229112, 5.906773, -0.115618>, <0.229112, 5.906773, -0.268496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, <-0.025685, 5.906773, -0.013699>, 
      <-0.102124, 5.906773, 0.062740>, <-0.102124, 5.906773, 0.062740>, <0.050754, 5.906773, 0.062740>, <0.050754, 5.906773, 0.062740>, 
      <-0.276296, 6.014682, 0.236193>, <-0.123418, 6.014682, 0.236193>, <0.071112, 6.014641, 0.236195>, <0.223990, 6.014641, 0.236195>, 
      <-0.280482, 5.906773, 0.241098>, <-0.127604, 5.906773, 0.241098>, <0.076234, 5.906773, 0.241098>, <0.229112, 5.906773, 0.241098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025685, 5.906773, -0.013699>, <-0.102124, 5.906773, 0.062740>, <-0.276296, 6.014682, 0.236193>, <-0.280482, 5.906773, 0.241098>, 
      <-0.025685, 5.906773, -0.013699>, <-0.102124, 5.906773, 0.062740>, <-0.276296, 6.014682, 0.083315>, <-0.280482, 5.906773, 0.088220>, 
      <-0.025685, 5.906773, -0.013699>, <-0.102124, 5.906773, -0.090138>, <-0.276296, 6.014703, -0.111212>, <-0.280482, 5.906773, -0.115618>, 
      <-0.025685, 5.906773, -0.013699>, <-0.102124, 5.906773, -0.090138>, <-0.276296, 6.014703, -0.264091>, <-0.280482, 5.906773, -0.268496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254797, 0.000000, -0.254797>, <0.247091, 1.772032, -0.258907>, <0.313093, 4.138184, -0.340685>, <0.229112, 5.906773, -0.268496>, 
      <0.101919, 0.000000, -0.254797>, <0.094213, 1.772032, -0.258907>, <0.160215, 4.138184, -0.340685>, <0.076234, 5.906773, -0.268496>, 
      <-0.101919, 0.000000, -0.254797>, <-0.109624, 1.772032, -0.258907>, <-0.196230, 4.137522, -0.340712>, <-0.127604, 5.906773, -0.268496>, 
      <-0.254797, 0.000000, -0.254797>, <-0.262503, 1.772032, -0.258907>, <-0.349108, 4.137522, -0.340712>, <-0.280482, 5.906773, -0.268496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254797, 0.000000, 0.254797>, <0.247091, 1.772032, 0.250687>, <0.313076, 4.138536, 0.321474>, <0.229112, 5.906773, 0.241098>, 
      <0.254797, 0.000000, 0.101919>, <0.247091, 1.772032, 0.097809>, <0.313076, 4.138536, 0.168596>, <0.229112, 5.906773, 0.088220>, 
      <0.254797, 0.000000, -0.101919>, <0.247091, 1.772032, -0.106029>, <0.313093, 4.138184, -0.187807>, <0.229112, 5.906773, -0.115618>, 
      <0.254797, 0.000000, -0.254797>, <0.247091, 1.772032, -0.258907>, <0.313093, 4.138184, -0.340685>, <0.229112, 5.906773, -0.268496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.254797, 0.000000, 0.254797>, <-0.262503, 1.772032, 0.250687>, <-0.349094, 4.137875, 0.321504>, <-0.280482, 5.906773, 0.241098>, 
      <-0.101919, 0.000000, 0.254797>, <-0.109624, 1.772032, 0.250687>, <-0.196216, 4.137875, 0.321504>, <-0.127604, 5.906773, 0.241098>, 
      <0.101919, 0.000000, 0.254797>, <0.094213, 1.772032, 0.250687>, <0.160198, 4.138536, 0.321474>, <0.076234, 5.906773, 0.241098>, 
      <0.254797, 0.000000, 0.254797>, <0.247091, 1.772032, 0.250687>, <0.313076, 4.138536, 0.321474>, <0.229112, 5.906773, 0.241098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.254797, 0.000000, 0.254797>, <-0.254797, 0.000000, 0.101919>, <-0.254797, 0.000000, -0.101919>, <-0.254797, 0.000000, -0.254797>, 
      <-0.262503, 1.772032, 0.250687>, <-0.262503, 1.772032, 0.097809>, <-0.262503, 1.772032, -0.106029>, <-0.262503, 1.772032, -0.258907>, 
      <-0.349094, 4.137875, 0.321504>, <-0.349094, 4.137875, 0.168626>, <-0.349108, 4.137522, -0.187834>, <-0.349108, 4.137522, -0.340712>, 
      <-0.280482, 5.906773, 0.241098>, <-0.280482, 5.906773, 0.088220>, <-0.280482, 5.906773, -0.115618>, <-0.280482, 5.906773, -0.268496>
    }
  }
  material {
    T_Wood10
  }
}
#declare Matcstick = union {
  object { MHEAD }
  object { MatchStickB }
  scale <1.858655, 1.98132, 1.858655>
  rotate 90.0*z
  translate  <4.505781, 5.759797, 5.781237>
}
#declare Matcstick2 = object {
  object { // Matcstick2->Matcstick
    Matcstick
    rotate <0.0, -0.0, -0.0>
    translate  <0.149381, 3.435752, 0.0>
  }
}
#declare Matcstick1 = object {
  object { // Matcstick1->Matcstick
    Matcstick
    rotate <0.0, -0.0, 180.0>
    translate  <-0.522832, 13.294866, 0.0>
  }
}
#declare Cone001 = object {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      B_Silver
    }
    scale <0.423707, 0.473262, 3.5276>
    rotate 22.429295*y
    translate  <-0.722581, 0.948129, -1.778681>
  }
}
#declare head_GREENBUGE3_Ref = object {
  head_GREENBUGE
}
#declare torso_GREENBUG3_Ref = object {
  torso_GREENBUG
}
#declare eye_BUG_EYEB3_Ref = object {
  eye_BUG_EYEB
}
#declare eye01_BUG_EYEG3_Ref = object {
  eye01_BUG_EYEG
}
#declare antena01_GREENBUGU3_Ref = object {
  antena01_GREENBUGU
}
#declare antena02_GREENBUGU3_Ref = object {
  antena02_GREENBUGU
}
#declare leg_ft_rt_GREENBUG3_Ref = object {
  leg_ft_rt_GREENBUG
}
#declare leg_mid_rt_GREENBUG3_Ref = object {
  leg_mid_rt_GREENBUG
}
#declare leg_bk_rt_GREENBUGG3_Ref = object {
  leg_bk_rt_GREENBUGG
}
#declare leg_bk_lt_GREENBUGG3_Ref = object {
  leg_bk_lt_GREENBUGG
}
#declare mandible_GREENBUGG3_Ref = object {
  mandible_GREENBUGG
}
#declare mandible01_GREENBUG3_Ref = object {
  mandible01_GREENBUG
}
#declare leg_fr_lt_GREENBUGG3_Ref = object {
  leg_fr_lt_GREENBUGG
}
#declare leg_mid_lt_GREENBUG3_Ref = object {
  leg_mid_lt_GREENBUG
}
#declare tail_GREENBUGE3_Ref = object {
  tail_GREENBUGE
}
#declare Ant_group9 = union {
  object { head_GREENBUGE3_Ref }
  object { torso_GREENBUG3_Ref }
  object { eye_BUG_EYEB3_Ref }
  object { eye01_BUG_EYEG3_Ref }
  object { antena01_GREENBUGU3_Ref }
  object { antena02_GREENBUGU3_Ref }
  object { leg_ft_rt_GREENBUG3_Ref }
  object { leg_mid_rt_GREENBUG3_Ref }
  object { leg_bk_rt_GREENBUGG3_Ref }
  object { leg_bk_lt_GREENBUGG3_Ref }
  object { mandible_GREENBUGG3_Ref }
  object { mandible01_GREENBUG3_Ref }
  object { leg_fr_lt_GREENBUGG3_Ref }
  object { leg_mid_lt_GREENBUG3_Ref }
  object { tail_GREENBUGE3_Ref }
  material {
    BlackLeather_1
  }
  scale 0.004
  rotate -88.593048*z
  translate  <-5.426033, 4.485637, 0.872491>
}
#declare Puller1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.252206, 0.000000, 0.000000>, <0.286840, 0.716928, 0.126351>, <0.252206, 1.658904, 0.373973>, <0.252206, 2.369863, 0.534247>, 
      <0.258027, 0.000000, -0.097918>, <0.292660, 0.716928, 0.028433>, <0.258027, 1.658904, 0.276055>, <0.258027, 2.369863, 0.436329>, 
      <0.111790, 0.000000, -0.087822>, <0.113225, 0.719737, 0.026749>, <0.111790, 1.658904, 0.286150>, <0.111790, 2.369863, 0.446424>, 
      <0.013699, 0.000000, -0.087822>, <0.015135, 0.719737, 0.026749>, <0.013699, 1.658904, 0.286150>, <0.013699, 2.369863, 0.446424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.142617>, <-0.000475, 0.714102, 0.288246>, <0.000000, 1.658904, 0.516590>, <0.000000, 2.369863, 0.676863>, 
      <0.111820, 0.000000, 0.142617>, <0.111346, 0.714102, 0.288246>, <0.111820, 1.658904, 0.516590>, <0.111820, 2.369863, 0.676863>, 
      <0.245570, 0.000000, 0.111623>, <0.280204, 0.716928, 0.237974>, <0.245570, 1.658904, 0.485596>, <0.245570, 2.369863, 0.645870>, 
      <0.252206, 0.000000, 0.000000>, <0.286840, 0.716928, 0.126351>, <0.252206, 1.658904, 0.373973>, <0.252206, 2.369863, 0.534247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.252206, 0.000000, 0.000000>, <-0.287791, 0.716883, 0.126343>, <-0.252206, 1.658904, 0.373973>, <-0.252206, 2.369863, 0.534247>, 
      <-0.258841, 0.000000, 0.111623>, <-0.294426, 0.716883, 0.237966>, <-0.258841, 1.658904, 0.485596>, <-0.258841, 2.369863, 0.645870>, 
      <-0.111820, 0.000000, 0.142617>, <-0.112295, 0.714102, 0.288246>, <-0.111820, 1.658904, 0.516590>, <-0.111820, 2.369863, 0.676863>, 
      <0.000000, 0.000000, 0.142617>, <-0.000475, 0.714102, 0.288246>, <0.000000, 1.658904, 0.516590>, <0.000000, 2.369863, 0.676863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.252206, 0.000000, 0.000000>, <-0.245793, 0.000000, -0.107885>, <-0.094376, 0.000000, -0.087822>, <0.013699, 0.000000, -0.087822>, 
      <-0.287791, 0.716883, 0.126343>, <-0.281378, 0.716883, 0.018458>, <-0.092940, 0.719737, 0.026749>, <0.015135, 0.719737, 0.026749>, 
      <-0.252206, 1.658904, 0.373973>, <-0.245793, 1.658904, 0.266088>, <-0.094376, 1.658904, 0.286150>, <0.013699, 1.658904, 0.286150>, 
      <-0.252206, 2.369863, 0.534247>, <-0.245793, 2.369863, 0.426362>, <-0.094376, 2.369863, 0.446424>, <0.013699, 2.369863, 0.446424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107942, -0.616438, 0.007944>, <0.151221, -0.431507, 0.005561>, <0.243179, -0.186849, -0.032930>, <0.252206, 0.000000, 0.000000>, 
      <0.110388, -0.616438, -0.033194>, <0.153667, -0.431507, -0.035577>, <0.249000, -0.186849, -0.130848>, <0.258027, 0.000000, -0.097918>, 
      <0.048951, -0.616438, -0.028952>, <0.050738, -0.431507, -0.046613>, <0.111423, -0.183471, -0.117028>, <0.111790, 0.000000, -0.087822>, 
      <0.007741, -0.616438, -0.028952>, <0.009528, -0.431507, -0.046613>, <0.013333, -0.183471, -0.117028>, <0.013699, 0.000000, -0.087822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.001986, -0.616438, 0.067860>, <0.001390, -0.431507, 0.090287>, <0.000121, -0.182530, 0.105393>, <0.000000, 0.000000, 0.142617>, 
      <0.048964, -0.616438, 0.067860>, <0.048368, -0.431507, 0.090287>, <0.111942, -0.182530, 0.105393>, <0.111820, 0.000000, 0.142617>, 
      <0.105155, -0.616438, 0.054839>, <0.148434, -0.431507, 0.052456>, <0.236544, -0.186849, 0.078693>, <0.245570, 0.000000, 0.111623>, 
      <0.107942, -0.616438, 0.007944>, <0.151221, -0.431507, 0.005561>, <0.243179, -0.186849, -0.032930>, <0.252206, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.103970, -0.616438, 0.007944>, <-0.148441, -0.431507, 0.005561>, <-0.242918, -0.187108, -0.032976>, <-0.252206, 0.000000, 0.000000>, 
      <-0.106758, -0.616438, 0.054839>, <-0.151229, -0.431507, 0.052456>, <-0.249554, -0.187108, 0.078648>, <-0.258841, 0.000000, 0.111623>, 
      <-0.044992, -0.616438, 0.067860>, <-0.045588, -0.431507, 0.090287>, <-0.111699, -0.182530, 0.105393>, <-0.111820, 0.000000, 0.142617>, 
      <0.001986, -0.616438, 0.067860>, <0.001390, -0.431507, 0.090287>, <0.000121, -0.182530, 0.105393>, <0.000000, 0.000000, 0.142617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.103970, -0.616438, 0.007944>, <-0.101276, -0.616438, -0.037381>, <-0.037663, -0.616438, -0.028952>, <0.007741, -0.616438, -0.028952>, 
      <-0.148441, -0.431507, 0.005561>, <-0.145747, -0.431507, -0.039764>, <-0.035876, -0.431507, -0.046613>, <0.009528, -0.431507, -0.046613>, 
      <-0.242918, -0.187108, -0.032976>, <-0.236505, -0.187108, -0.140860>, <-0.094742, -0.183471, -0.117028>, <0.013333, -0.183471, -0.117028>, 
      <-0.252206, 0.000000, 0.000000>, <-0.245793, 0.000000, -0.107885>, <-0.094376, 0.000000, -0.087822>, <0.013699, 0.000000, -0.087822>
    }
  }
  material {
    T_Wood10
  }
  rotate <-4.279229, 0.027394, -87.09565>
  translate  <-4.676878, 1.847685, 1.33231>
}
#declare NeckRing2 = object {
  torus { // NeckRing2
    1.442, 0.5  rotate -x*90
    material {
      T_Wood10
    }
    scale <0.425707, 0.360002, 0.204476>
    rotate -57.63501*y
    translate  <-5.553309, 1.757981, 0.88598>
  }
}




//
// ********  OBJECTS  *******
//





object { // Ant_group12->Ant_group11
  Ant_group11
  rotate -0.0*z
  translate  <1.379902, 7.727451, 0.0>
}


object { Ant_group11 }


object { Ant_group10 }


object { // LadderCarriers1->LadderCarriers
  LadderCarriers
  rotate <0.0, 0.0, 0.0>
  translate  <-14.911656, 6.710245, 0.0>
}


object { // Ant_group7->Ant_group3
  Ant_group3
  rotate <-60.783897, 17.901785, -0.0>
  translate  <-4.490417, -11.416623, -11.869983>
}


object { Ant_group3 }


object { // Ant_group2->Ant_group1
  Ant_group1
  rotate <0.0, -0.0, -63.982983>
  translate  <-29.577298, 6.615975, -0.0>
}


object { Ant_group1 }


object { // SyrupBottle1->SyrupBottle
  SyrupBottle
  rotate -61.755814*z
  translate  <11.981881, -10.512392, 0.0>
}


object { Ant_group }


box { // BackWall
  <-1, -1, -1>, <1, 1, 1>
  material {
    KitchenTiles_1
    scale <0.522869, 0.781403, 1.0>
    rotate 90.0*x
    translate <-1.002839, 0.000000, 1.012071>
  }
  scale <53.572113, 1.0, 33.201378>
  translate  <-2.003641, 20.275189, 31.495225>
}


box { // TableTop
  <-1, -1, -1>, <1, 1, 1>
  material {
    KitchenTopMarble
  }
  scale <50.415581, 29.736176, 1.0>
  translate  <0.703086, -4.51984, 0.0>
}




#declare RndCube001 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <11.75807, 10.412675, 1.655304>
}
#declare Socket = difference {
  object { RndCube001 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <6.948546, 6.593039, 0.906385>
    translate  <-0.093615, 0.0, -0.748918>
  }
  material {
    WallSockText
  }
  translate  <-1.240653, 0.524892, 0.0>
}
#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000881, -1.428468, 0.917808>, <0.000881, -1.428468, 0.908405>, <-0.006944, -1.428468, 0.900581>, <-0.016346, -1.428468, 0.900581>, 
      <0.053949, -1.412564, 0.917808>, <0.053949, -1.412564, 0.908405>, <-0.001643, -1.412564, 0.852814>, <-0.011045, -1.412564, 0.852814>, 
      <0.170608, -1.430391, 0.917808>, <0.170608, -1.430391, 0.821501>, <0.096975, -1.425730, 0.747262>, <0.000668, -1.425730, 0.747262>, 
      <0.177776, -1.375456, 0.917808>, <0.177776, -1.375456, 0.821501>, <0.097630, -1.375456, 0.741357>, <0.001323, -1.375456, 0.741357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.016346, -1.428468, 0.935035>, <-0.006944, -1.428468, 0.935035>, <0.000881, -1.428468, 0.927211>, <0.000881, -1.428468, 0.917808>, 
      <-0.011045, -1.412564, 0.982803>, <-0.001643, -1.412564, 0.982803>, <0.053949, -1.412564, 0.927211>, <0.053949, -1.412564, 0.917808>, 
      <0.000668, -1.425730, 1.088356>, <0.096976, -1.425730, 1.088356>, <0.170608, -1.430391, 1.014116>, <0.170608, -1.430391, 0.917808>, 
      <0.001323, -1.375456, 1.094261>, <0.097631, -1.375456, 1.094261>, <0.177776, -1.375456, 1.014116>, <0.177776, -1.375456, 0.917808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033573, -1.428468, 0.917808>, <-0.033573, -1.428468, 0.927211>, <-0.025749, -1.428468, 0.935035>, <-0.016346, -1.428468, 0.935035>, 
      <-0.076039, -1.412564, 0.917808>, <-0.076039, -1.412564, 0.927211>, <-0.020448, -1.412564, 0.982803>, <-0.011045, -1.412564, 0.982803>, 
      <-0.170419, -1.420557, 0.917808>, <-0.170419, -1.420557, 1.014115>, <-0.095640, -1.425730, 1.088356>, <0.000668, -1.425730, 1.088356>, 
      <-0.175128, -1.375456, 0.917808>, <-0.175128, -1.375456, 1.014115>, <-0.094984, -1.375456, 1.094261>, <0.001323, -1.375456, 1.094261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033573, -1.428468, 0.917808>, <-0.076039, -1.412564, 0.917808>, <-0.170419, -1.420557, 0.917808>, <-0.175128, -1.375456, 0.917808>, 
      <-0.033573, -1.428468, 0.908405>, <-0.076039, -1.412564, 0.908405>, <-0.170419, -1.420557, 0.821501>, <-0.175128, -1.375456, 0.821501>, 
      <-0.025749, -1.428468, 0.900581>, <-0.020448, -1.412564, 0.852814>, <-0.095639, -1.425730, 0.747262>, <-0.094984, -1.375456, 0.741357>, 
      <-0.016346, -1.428468, 0.900581>, <-0.011045, -1.412564, 0.852814>, <0.000668, -1.425730, 0.747262>, <0.001323, -1.375456, 0.741357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.177776, -0.072789, 0.917808>, <0.177776, -0.463589, 0.917808>, <0.228341, -0.987941, 0.917808>, <0.177776, -1.375456, 0.917808>, 
      <0.177776, -0.072789, 0.821501>, <0.177776, -0.463589, 0.821501>, <0.228341, -0.987941, 0.821501>, <0.177776, -1.375456, 0.821501>, 
      <0.097630, -0.072789, 0.741357>, <0.097630, -0.463589, 0.741357>, <0.102689, -0.987356, 0.695775>, <0.097630, -1.375456, 0.741357>, 
      <0.001323, -0.072789, 0.741357>, <0.001323, -0.463589, 0.741357>, <0.006381, -0.987356, 0.695775>, <0.001323, -1.375456, 0.741357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.001323, -0.072789, 1.094261>, <0.001323, -0.463589, 1.094261>, <0.006381, -0.987356, 1.139844>, <0.001323, -1.375456, 1.094261>, 
      <0.097631, -0.072789, 1.094261>, <0.097631, -0.463589, 1.094261>, <0.102689, -0.987356, 1.139844>, <0.097631, -1.375456, 1.094261>, 
      <0.177776, -0.072789, 1.014116>, <0.177776, -0.463589, 1.014116>, <0.228341, -0.987941, 1.014116>, <0.177776, -1.375456, 1.014116>, 
      <0.177776, -0.072789, 0.917808>, <0.177776, -0.463589, 0.917808>, <0.228341, -0.987941, 0.917808>, <0.177776, -1.375456, 0.917808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175128, -0.072789, 0.917808>, <-0.175128, -0.463589, 0.917808>, <-0.215713, -0.986769, 0.917808>, <-0.175128, -1.375456, 0.917808>, 
      <-0.175128, -0.072789, 1.014115>, <-0.175128, -0.463589, 1.014115>, <-0.215713, -0.986769, 1.014115>, <-0.175128, -1.375456, 1.014115>, 
      <-0.094984, -0.072789, 1.094261>, <-0.094984, -0.463589, 1.094261>, <-0.089926, -0.987356, 1.139844>, <-0.094984, -1.375456, 1.094261>, 
      <0.001323, -0.072789, 1.094261>, <0.001323, -0.463589, 1.094261>, <0.006381, -0.987356, 1.139844>, <0.001323, -1.375456, 1.094261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175128, -0.072789, 0.917808>, <-0.175128, -0.072789, 0.821501>, <-0.094984, -0.072789, 0.741357>, <0.001323, -0.072789, 0.741357>, 
      <-0.175128, -0.463589, 0.917808>, <-0.175128, -0.463589, 0.821501>, <-0.094984, -0.463589, 0.741357>, <0.001323, -0.463589, 0.741357>, 
      <-0.215713, -0.986769, 0.917808>, <-0.215713, -0.986769, 0.821501>, <-0.089926, -0.987356, 0.695775>, <0.006381, -0.987356, 0.695775>, 
      <-0.175128, -1.375456, 0.917808>, <-0.175128, -1.375456, 0.821501>, <-0.094984, -1.375456, 0.741357>, <0.001323, -1.375456, 0.741357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.424314, -1.328767, 0.000000>, <0.424314, -1.328767, -0.007289>, <0.418248, -1.328767, -0.013355>, <0.410959, -1.328767, -0.013355>, 
      <0.465454, -1.316438, 0.000000>, <0.465454, -1.316438, -0.007289>, <0.422358, -1.316438, -0.050386>, <0.415069, -1.316438, -0.050386>, 
      <0.556852, -1.330372, 0.000000>, <0.556852, -1.330372, -0.074660>, <0.498898, -1.326731, -0.133006>, <0.424238, -1.326731, -0.133006>, 
      <0.561448, -1.287671, 0.000000>, <0.561448, -1.287671, -0.074660>, <0.499318, -1.287671, -0.136790>, <0.424658, -1.287671, -0.136790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.410959, -1.328767, 0.013355>, <0.418248, -1.328767, 0.013355>, <0.424314, -1.328767, 0.007289>, <0.424314, -1.328767, 0.000000>, 
      <0.415069, -1.316438, 0.050386>, <0.422358, -1.316438, 0.050386>, <0.465454, -1.316438, 0.007289>, <0.465454, -1.316438, 0.000000>, 
      <0.424238, -1.326731, 0.133007>, <0.498898, -1.326731, 0.133007>, <0.556852, -1.330372, 0.074660>, <0.556852, -1.330372, 0.000000>, 
      <0.424658, -1.287671, 0.136791>, <0.499318, -1.287671, 0.136791>, <0.561448, -1.287671, 0.074660>, <0.561448, -1.287671, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.397604, -1.328767, 0.000000>, <0.397604, -1.328767, 0.007289>, <0.403670, -1.328767, 0.013355>, <0.410959, -1.328767, 0.013355>, 
      <0.364683, -1.316438, 0.000000>, <0.364683, -1.316438, 0.007289>, <0.407780, -1.316438, 0.050386>, <0.415069, -1.316438, 0.050386>, 
      <0.290884, -1.322695, 0.000000>, <0.290884, -1.322695, 0.074660>, <0.349578, -1.326731, 0.133007>, <0.424238, -1.326731, 0.133007>, 
      <0.287867, -1.287671, 0.000000>, <0.287867, -1.287671, 0.074660>, <0.349998, -1.287671, 0.136791>, <0.424658, -1.287671, 0.136791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.397604, -1.328767, 0.000000>, <0.364683, -1.316438, 0.000000>, <0.290884, -1.322695, 0.000000>, <0.287867, -1.287671, 0.000000>, 
      <0.397604, -1.328767, -0.007289>, <0.364683, -1.316438, -0.007289>, <0.290884, -1.322695, -0.074660>, <0.287867, -1.287671, -0.074660>, 
      <0.403670, -1.328767, -0.013355>, <0.407780, -1.316438, -0.050386>, <0.349578, -1.326731, -0.133006>, <0.349998, -1.287671, -0.136790>, 
      <0.410959, -1.328767, -0.013355>, <0.415069, -1.316438, -0.050386>, <0.424238, -1.326731, -0.133006>, <0.424658, -1.287671, -0.136790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.561448, -0.054794, 0.000000>, <0.561448, -0.424657, 0.000000>, <0.601032, -0.919932, 0.000000>, <0.561448, -1.287671, 0.000000>, 
      <0.561448, -0.054794, -0.074660>, <0.561448, -0.424657, -0.074660>, <0.601032, -0.919932, -0.074660>, <0.561448, -1.287671, -0.074660>, 
      <0.499318, -0.054794, -0.136790>, <0.499318, -0.424657, -0.136790>, <0.503276, -0.919553, -0.172457>, <0.499318, -1.287671, -0.136790>, 
      <0.424658, -0.054794, -0.136790>, <0.424658, -0.424657, -0.136790>, <0.428616, -0.919553, -0.172457>, <0.424658, -1.287671, -0.136790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.424658, -0.054794, 0.136791>, <0.424658, -0.424657, 0.136791>, <0.428616, -0.919553, 0.172458>, <0.424658, -1.287671, 0.136791>, 
      <0.499318, -0.054794, 0.136791>, <0.499318, -0.424657, 0.136791>, <0.503277, -0.919553, 0.172458>, <0.499318, -1.287671, 0.136791>, 
      <0.561448, -0.054794, 0.074660>, <0.561448, -0.424657, 0.074660>, <0.601032, -0.919932, 0.074660>, <0.561448, -1.287671, 0.074660>, 
      <0.561448, -0.054794, 0.000000>, <0.561448, -0.424657, 0.000000>, <0.601032, -0.919932, 0.000000>, <0.561448, -1.287671, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287867, -0.054794, 0.000000>, <0.287867, -0.424657, 0.000000>, <0.256125, -0.919172, 0.000000>, <0.287867, -1.287671, 0.000000>, 
      <0.287867, -0.054794, 0.074660>, <0.287867, -0.424657, 0.074660>, <0.256125, -0.919172, 0.074660>, <0.287867, -1.287671, 0.074660>, 
      <0.349998, -0.054794, 0.136791>, <0.349998, -0.424657, 0.136791>, <0.353956, -0.919553, 0.172458>, <0.349998, -1.287671, 0.136791>, 
      <0.424658, -0.054794, 0.136791>, <0.424658, -0.424657, 0.136791>, <0.428616, -0.919553, 0.172458>, <0.424658, -1.287671, 0.136791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287867, -0.054794, 0.000000>, <0.287867, -0.054794, -0.074660>, <0.349998, -0.054794, -0.136790>, <0.424658, -0.054794, -0.136790>, 
      <0.287867, -0.424657, 0.000000>, <0.287867, -0.424657, -0.074660>, <0.349998, -0.424657, -0.136790>, <0.424658, -0.424657, -0.136790>, 
      <0.256125, -0.919172, 0.000000>, <0.256125, -0.919172, -0.074660>, <0.353956, -0.919553, -0.172457>, <0.428616, -0.919553, -0.172457>, 
      <0.287867, -1.287671, 0.000000>, <0.287867, -1.287671, -0.074660>, <0.349998, -1.287671, -0.136790>, <0.424658, -1.287671, -0.136790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.425001, -1.301370, -0.041096>, <-0.425001, -1.301370, -0.048385>, <-0.431067, -1.301370, -0.054451>, <-0.438356, -1.301370, -0.054451>, 
      <-0.383861, -1.289041, -0.041096>, <-0.383861, -1.289041, -0.048385>, <-0.426957, -1.289041, -0.091481>, <-0.434247, -1.289041, -0.091481>, 
      <-0.292463, -1.302975, -0.041096>, <-0.292463, -1.302975, -0.115756>, <-0.350418, -1.299334, -0.174101>, <-0.425078, -1.299334, -0.174101>, 
      <-0.287867, -1.260274, -0.041096>, <-0.287867, -1.260274, -0.115756>, <-0.349998, -1.260274, -0.177886>, <-0.424658, -1.260274, -0.177886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.438356, -1.301370, -0.027741>, <-0.431067, -1.301370, -0.027741>, <-0.425001, -1.301370, -0.033807>, <-0.425001, -1.301370, -0.041096>, 
      <-0.434247, -1.289041, 0.009290>, <-0.426957, -1.289041, 0.009290>, <-0.383861, -1.289041, -0.033807>, <-0.383861, -1.289041, -0.041096>, 
      <-0.425078, -1.299334, 0.091911>, <-0.350418, -1.299334, 0.091911>, <-0.292463, -1.302975, 0.033564>, <-0.292463, -1.302975, -0.041096>, 
      <-0.424658, -1.260274, 0.095695>, <-0.349998, -1.260274, 0.095695>, <-0.287867, -1.260274, 0.033564>, <-0.287867, -1.260274, -0.041096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.451711, -1.301370, -0.041096>, <-0.451711, -1.301370, -0.033807>, <-0.445645, -1.301370, -0.027741>, <-0.438356, -1.301370, -0.027741>, 
      <-0.484632, -1.289041, -0.041096>, <-0.484632, -1.289041, -0.033807>, <-0.441536, -1.289041, 0.009290>, <-0.434247, -1.289041, 0.009290>, 
      <-0.558431, -1.295298, -0.041096>, <-0.558431, -1.295298, 0.033564>, <-0.499738, -1.299334, 0.091911>, <-0.425078, -1.299334, 0.091911>, 
      <-0.561448, -1.260274, -0.041096>, <-0.561448, -1.260274, 0.033564>, <-0.499318, -1.260274, 0.095695>, <-0.424658, -1.260274, 0.095695>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.451711, -1.301370, -0.041096>, <-0.484632, -1.289041, -0.041096>, <-0.558431, -1.295298, -0.041096>, <-0.561448, -1.260274, -0.041096>, 
      <-0.451711, -1.301370, -0.048385>, <-0.484632, -1.289041, -0.048385>, <-0.558431, -1.295298, -0.115756>, <-0.561448, -1.260274, -0.115756>, 
      <-0.445645, -1.301370, -0.054451>, <-0.441536, -1.289041, -0.091481>, <-0.499738, -1.299334, -0.174101>, <-0.499318, -1.260274, -0.177886>, 
      <-0.438356, -1.301370, -0.054451>, <-0.434247, -1.289041, -0.091481>, <-0.425078, -1.299334, -0.174101>, <-0.424658, -1.260274, -0.177886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287867, -0.027397, -0.041096>, <-0.287867, -0.397260, -0.041096>, <-0.248283, -0.892535, -0.041096>, <-0.287867, -1.260274, -0.041096>, 
      <-0.287867, -0.027397, -0.115756>, <-0.287867, -0.397260, -0.115756>, <-0.248283, -0.892535, -0.115756>, <-0.287867, -1.260274, -0.115756>, 
      <-0.349998, -0.027397, -0.177886>, <-0.349998, -0.397260, -0.177886>, <-0.346040, -0.892156, -0.213553>, <-0.349998, -1.260274, -0.177886>, 
      <-0.424658, -0.027397, -0.177886>, <-0.424658, -0.397260, -0.177886>, <-0.420700, -0.892156, -0.213553>, <-0.424658, -1.260274, -0.177886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.424658, -0.027397, 0.095695>, <-0.424658, -0.397260, 0.095695>, <-0.420700, -0.892156, 0.131362>, <-0.424658, -1.260274, 0.095695>, 
      <-0.349998, -0.027397, 0.095695>, <-0.349998, -0.397260, 0.095695>, <-0.346040, -0.892156, 0.131362>, <-0.349998, -1.260274, 0.095695>, 
      <-0.287867, -0.027397, 0.033564>, <-0.287867, -0.397260, 0.033564>, <-0.248283, -0.892535, 0.033564>, <-0.287867, -1.260274, 0.033564>, 
      <-0.287867, -0.027397, -0.041096>, <-0.287867, -0.397260, -0.041096>, <-0.248283, -0.892535, -0.041096>, <-0.287867, -1.260274, -0.041096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561448, -0.027397, -0.041096>, <-0.561448, -0.397260, -0.041096>, <-0.593190, -0.891776, -0.041096>, <-0.561448, -1.260274, -0.041096>, 
      <-0.561448, -0.027397, 0.033564>, <-0.561448, -0.397260, 0.033564>, <-0.593190, -0.891776, 0.033564>, <-0.561448, -1.260274, 0.033564>, 
      <-0.499318, -0.027397, 0.095695>, <-0.499318, -0.397260, 0.095695>, <-0.495360, -0.892156, 0.131362>, <-0.499318, -1.260274, 0.095695>, 
      <-0.424658, -0.027397, 0.095695>, <-0.424658, -0.397260, 0.095695>, <-0.420700, -0.892156, 0.131362>, <-0.424658, -1.260274, 0.095695>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561448, -0.027397, -0.041096>, <-0.561448, -0.027397, -0.115756>, <-0.499318, -0.027397, -0.177886>, <-0.424658, -0.027397, -0.177886>, 
      <-0.561448, -0.397260, -0.041096>, <-0.561448, -0.397260, -0.115756>, <-0.499318, -0.397260, -0.177886>, <-0.424658, -0.397260, -0.177886>, 
      <-0.593190, -0.891776, -0.041096>, <-0.593190, -0.891776, -0.115756>, <-0.495360, -0.892156, -0.213553>, <-0.420700, -0.892156, -0.213553>, 
      <-0.561448, -1.260274, -0.041096>, <-0.561448, -1.260274, -0.115756>, <-0.499318, -1.260274, -0.177886>, <-0.424658, -1.260274, -0.177886>
    }
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <0.016849, -0.506849, -0.191781>, <0.016849, -0.506849, -0.191781>, <-0.126986, -0.506849, -0.187672>, <-0.126986, -0.506849, -0.187672>, 
      <0.022877, -0.506849, -0.520548>, <-0.120959, -0.506849, -0.516439>, <-0.168904, -0.506849, -0.515069>, <-0.312740, -0.506849, -0.510959>, 
      <0.027397, -0.506849, -0.767123>, <-0.116439, -0.506849, -0.763014>, <-0.308219, -0.506849, -0.757534>, <-0.452055, -0.506849, -0.753425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <0.164795, -0.506849, -0.187672>, <0.164795, -0.506849, -0.187672>, <0.016849, -0.506849, -0.191781>, <0.016849, -0.506849, -0.191781>, 
      <0.368082, -0.506849, -0.510959>, <0.220137, -0.506849, -0.515069>, <0.170822, -0.506849, -0.516439>, <0.022877, -0.506849, -0.520548>, 
      <0.520548, -0.506849, -0.753425>, <0.372603, -0.506849, -0.757534>, <0.175342, -0.506849, -0.763014>, <0.027397, -0.506849, -0.767123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <0.185343, -0.506849, -0.154795>, <0.185343, -0.506849, -0.154795>, <0.164795, -0.506849, -0.187672>, <0.164795, -0.506849, -0.187672>, 
      <0.416027, -0.506849, -0.434247>, <0.395479, -0.506849, -0.467124>, <0.388630, -0.506849, -0.478083>, <0.368082, -0.506849, -0.510959>, 
      <0.589041, -0.506849, -0.643836>, <0.568493, -0.506849, -0.676713>, <0.541096, -0.506849, -0.720548>, <0.520548, -0.506849, -0.753425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <0.201781, -0.506849, 0.104109>, <0.201781, -0.506849, 0.104109>, <0.185343, -0.506849, -0.154795>, <0.185343, -0.506849, -0.154795>, 
      <0.454384, -0.506849, 0.169863>, <0.437945, -0.506849, -0.089041>, <0.432466, -0.506849, -0.175343>, <0.416027, -0.506849, -0.434247>, 
      <0.643836, -0.506849, 0.219178>, <0.627398, -0.506849, -0.039726>, <0.605479, -0.506849, -0.384932>, <0.589041, -0.506849, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <0.099041, -0.506849, 0.400000>, <0.099041, -0.506849, 0.400000>, <0.201781, -0.506849, 0.104109>, <0.201781, -0.506849, 0.104109>, 
      <0.214658, -0.506849, 0.860274>, <0.317398, -0.506849, 0.564384>, <0.351644, -0.506849, 0.465753>, <0.454384, -0.506849, 0.169863>, 
      <0.301370, -0.506849, 1.205480>, <0.404110, -0.506849, 0.909589>, <0.541096, -0.506849, 0.515069>, <0.643836, -0.506849, 0.219178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <0.004521, -0.506849, 0.412328>, <0.004521, -0.506849, 0.412328>, <0.099041, -0.506849, 0.400000>, <0.099041, -0.506849, 0.400000>, 
      <-0.005891, -0.506849, 0.889041>, <0.088630, -0.506849, 0.876712>, <0.120137, -0.506849, 0.872603>, <0.214658, -0.506849, 0.860274>, 
      <-0.013699, -0.506849, 1.246575>, <0.080822, -0.506849, 1.234247>, <0.206849, -0.506849, 1.217809>, <0.301370, -0.506849, 1.205480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <-0.077671, -0.506849, 0.395890>, <-0.077671, -0.506849, 0.395890>, <0.004521, -0.506849, 0.412328>, <0.004521, -0.506849, 0.412328>, 
      <-0.197671, -0.506849, 0.850685>, <-0.115479, -0.506849, 0.867123>, <-0.088082, -0.506849, 0.872603>, <-0.005891, -0.506849, 0.889041>, 
      <-0.287671, -0.506849, 1.191781>, <-0.205479, -0.506849, 1.208219>, <-0.095891, -0.506849, 1.230137>, <-0.013699, -0.506849, 1.246575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <-0.184521, -0.506849, 0.112328>, <-0.184521, -0.506849, 0.112328>, <-0.077671, -0.506849, 0.395890>, <-0.077671, -0.506849, 0.395890>, 
      <-0.446987, -0.506849, 0.189041>, <-0.340137, -0.506849, 0.472602>, <-0.304521, -0.506849, 0.567123>, <-0.197671, -0.506849, 0.850685>, 
      <-0.643836, -0.506849, 0.246575>, <-0.536987, -0.506849, 0.530137>, <-0.394521, -0.506849, 0.908219>, <-0.287671, -0.506849, 1.191781>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, <0.012329, -0.506849, 0.054794>, 
      <-0.159863, -0.506849, -0.154795>, <-0.159863, -0.506849, -0.154795>, <-0.184521, -0.506849, 0.112328>, <-0.184521, -0.506849, 0.112328>, 
      <-0.389452, -0.506849, -0.434247>, <-0.414110, -0.506849, -0.167124>, <-0.422329, -0.506849, -0.078083>, <-0.446987, -0.506849, 0.189041>, 
      <-0.561644, -0.506849, -0.643836>, <-0.586302, -0.506849, -0.376713>, <-0.619178, -0.506849, -0.020548>, <-0.643836, -0.506849, 0.246575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012329, -0.506849, 0.054794>, <-0.159863, -0.506849, -0.154795>, <-0.389452, -0.506849, -0.434247>, <-0.561644, -0.506849, -0.643836>, 
      <0.012329, -0.506849, 0.054794>, <-0.159863, -0.506849, -0.154795>, <-0.356575, -0.506849, -0.467124>, <-0.528767, -0.506849, -0.676713>, 
      <0.012329, -0.506849, 0.054794>, <-0.126986, -0.506849, -0.187672>, <-0.345616, -0.506849, -0.478083>, <-0.484932, -0.506849, -0.720548>, 
      <0.012329, -0.506849, 0.054794>, <-0.126986, -0.506849, -0.187672>, <-0.312740, -0.506849, -0.510959>, <-0.452055, -0.506849, -0.753425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.027397, 0.000000, -0.767123>, <0.027397, -0.152055, -0.767123>, <0.027397, -0.354794, -0.767123>, <0.027397, -0.506849, -0.767123>, 
      <-0.116497, 0.000000, -0.767123>, <-0.116497, -0.152055, -0.767123>, <-0.116439, -0.354794, -0.763014>, <-0.116439, -0.506849, -0.763014>, 
      <-0.311213, 0.000000, -0.782903>, <-0.311213, -0.152055, -0.782903>, <-0.308219, -0.354794, -0.757534>, <-0.308219, -0.506849, -0.757534>, 
      <-0.452055, 0.000000, -0.753425>, <-0.452055, -0.152055, -0.753425>, <-0.452055, -0.354794, -0.753425>, <-0.452055, -0.506849, -0.753425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.520548, 0.000000, -0.753425>, <0.520548, -0.152055, -0.753425>, <0.520548, -0.354794, -0.753425>, <0.520548, -0.506849, -0.753425>, 
      <0.375987, 0.000000, -0.785158>, <0.375987, -0.152055, -0.785158>, <0.372603, -0.354794, -0.757534>, <0.372603, -0.506849, -0.757534>, 
      <0.175399, 0.000000, -0.767123>, <0.175399, -0.152055, -0.767123>, <0.175342, -0.354794, -0.763014>, <0.175342, -0.506849, -0.763014>, 
      <0.027397, 0.000000, -0.767123>, <0.027397, -0.152055, -0.767123>, <0.027397, -0.354794, -0.767123>, <0.027397, -0.506849, -0.767123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.589041, 0.000000, -0.643836>, <0.589041, -0.152055, -0.643836>, <0.589041, -0.354794, -0.643836>, <0.589041, -0.506849, -0.643836>, 
      <0.584166, 0.000000, -0.682298>, <0.584166, -0.152055, -0.682298>, <0.568493, -0.354794, -0.676713>, <0.568493, -0.506849, -0.676713>, 
      <0.558416, 0.000000, -0.745113>, <0.558416, -0.152055, -0.745113>, <0.541096, -0.354794, -0.720548>, <0.541096, -0.506849, -0.720548>, 
      <0.520548, 0.000000, -0.753425>, <0.520548, -0.152055, -0.753425>, <0.520548, -0.354794, -0.753425>, <0.520548, -0.506849, -0.753425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.643836, 0.000000, 0.219178>, <0.643836, -0.152055, 0.219178>, <0.643836, -0.354794, 0.219178>, <0.643836, -0.506849, 0.219178>, 
      <0.683712, 0.000000, -0.037165>, <0.683712, -0.152055, -0.037165>, <0.627398, -0.354794, -0.039726>, <0.627398, -0.506849, -0.039726>, 
      <0.621665, 0.000000, -0.386470>, <0.621665, -0.152055, -0.386470>, <0.605479, -0.354794, -0.384932>, <0.605479, -0.506849, -0.384932>, 
      <0.589041, 0.000000, -0.643836>, <0.589041, -0.152055, -0.643836>, <0.589041, -0.354794, -0.643836>, <0.589041, -0.506849, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.301370, 0.000000, 1.205480>, <0.301370, -0.152055, 1.205480>, <0.301370, -0.354794, 1.205480>, <0.301370, -0.506849, 1.205480>, 
      <0.470212, 0.000000, 0.941664>, <0.470212, -0.152055, 0.941664>, <0.404110, -0.354794, 0.909589>, <0.404110, -0.506849, 0.909589>, 
      <0.595692, 0.000000, 0.528676>, <0.595692, -0.152055, 0.528676>, <0.541096, -0.354794, 0.515069>, <0.541096, -0.506849, 0.515069>, 
      <0.643836, 0.000000, 0.219178>, <0.643836, -0.152055, 0.219178>, <0.643836, -0.354794, 0.219178>, <0.643836, -0.506849, 0.219178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013699, 0.000000, 1.246575>, <-0.013699, -0.152055, 1.246575>, <-0.013699, -0.354794, 1.246575>, <-0.013699, -0.506849, 1.246575>, 
      <0.081597, 0.000000, 1.248791>, <0.081597, -0.152055, 1.248791>, <0.080822, -0.354794, 1.234247>, <0.080822, -0.506849, 1.234247>, 
      <0.249987, 0.000000, 1.285766>, <0.249987, -0.152055, 1.285766>, <0.206849, -0.354794, 1.217809>, <0.206849, -0.506849, 1.217809>, 
      <0.301370, 0.000000, 1.205480>, <0.301370, -0.152055, 1.205480>, <0.301370, -0.354794, 1.205480>, <0.301370, -0.506849, 1.205480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287671, 0.000000, 1.191781>, <-0.287671, -0.152055, 1.191781>, <-0.287671, -0.354794, 1.191781>, <-0.287671, -0.506849, 1.191781>, 
      <-0.242985, 0.000000, 1.262695>, <-0.242985, -0.152055, 1.262695>, <-0.205479, -0.354794, 1.208219>, <-0.205479, -0.506849, 1.208219>, 
      <-0.097496, 0.000000, 1.244626>, <-0.097496, -0.152055, 1.244626>, <-0.095891, -0.354794, 1.230137>, <-0.095891, -0.506849, 1.230137>, 
      <-0.013699, 0.000000, 1.246575>, <-0.013699, -0.152055, 1.246575>, <-0.013699, -0.354794, 1.246575>, <-0.013699, -0.506849, 1.246575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.643836, 0.000000, 0.246575>, <-0.643836, -0.152055, 0.246575>, <-0.643836, -0.354794, 0.246575>, <-0.643836, -0.506849, 0.246575>, 
      <-0.599104, 0.000000, 0.546280>, <-0.599104, -0.152055, 0.546280>, <-0.536987, -0.354794, 0.530137>, <-0.536987, -0.506849, 0.530137>, 
      <-0.449220, 0.000000, 0.935410>, <-0.449220, -0.152055, 0.935410>, <-0.394521, -0.354794, 0.908219>, <-0.394521, -0.506849, 0.908219>, 
      <-0.287671, 0.000000, 1.191781>, <-0.287671, -0.152055, 1.191781>, <-0.287671, -0.354794, 1.191781>, <-0.287671, -0.506849, 1.191781>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561644, 0.000000, -0.643836>, <-0.561644, -0.152055, -0.643836>, <-0.561644, -0.354794, -0.643836>, <-0.561644, -0.506849, -0.643836>, 
      <-0.612170, 0.000000, -0.380378>, <-0.612170, -0.152055, -0.380378>, <-0.586302, -0.354794, -0.376713>, <-0.586302, -0.506849, -0.376713>, 
      <-0.683436, 0.000000, -0.018745>, <-0.683436, -0.152055, -0.018745>, <-0.619178, -0.354794, -0.020548>, <-0.619178, -0.506849, -0.020548>, 
      <-0.643836, 0.000000, 0.246575>, <-0.643836, -0.152055, 0.246575>, <-0.643836, -0.354794, 0.246575>, <-0.643836, -0.506849, 0.246575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561644, 0.000000, -0.643836>, <-0.552887, 0.000000, -0.689499>, <-0.497564, 0.000000, -0.743900>, <-0.452055, 0.000000, -0.753425>, 
      <-0.561644, -0.152055, -0.643836>, <-0.552887, -0.152055, -0.689499>, <-0.497564, -0.152055, -0.743900>, <-0.452055, -0.152055, -0.753425>, 
      <-0.561644, -0.354794, -0.643836>, <-0.528767, -0.354794, -0.676713>, <-0.484932, -0.354794, -0.720548>, <-0.452055, -0.354794, -0.753425>, 
      <-0.561644, -0.506849, -0.643836>, <-0.528767, -0.506849, -0.676713>, <-0.484932, -0.506849, -0.720548>, <-0.452055, -0.506849, -0.753425>
    }
  }
}
#declare sPatchObj2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.188471, -0.028643, -0.275936>, <-0.188471, -0.028643, -0.275936>, <-0.157649, -0.028643, -0.307785>, <-0.157649, -0.028643, -0.307785>, 
      <-0.403399, -0.061173, -0.487828>, <-0.372577, -0.061173, -0.519677>, <-0.374651, -0.061187, -0.554166>, <-0.331101, -0.061187, -0.562398>, 
      <-0.561644, -0.028643, -0.643836>, <-0.530822, -0.028643, -0.675685>, <-0.502454, -0.028643, -0.741768>, <-0.458904, -0.028643, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.188471, -0.028643, -0.275936>, <-0.188471, -0.028643, -0.275936>, <-0.188471, -0.028643, -0.275936>, <-0.188471, -0.028643, -0.275936>, 
      <-0.403399, -0.061173, -0.487828>, <-0.403399, -0.061173, -0.487828>, <-0.403399, -0.061173, -0.487828>, <-0.403399, -0.061173, -0.487828>, 
      <-0.561644, -0.028643, -0.643836>, <-0.561644, -0.028643, -0.643836>, <-0.561644, -0.028643, -0.643836>, <-0.561644, -0.028643, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.258334, -0.028643, -0.259498>, <-0.258334, -0.028643, -0.259498>, <-0.188471, -0.028643, -0.275936>, <-0.188471, -0.028643, -0.275936>, 
      <-0.566415, -0.061278, -0.448846>, <-0.513026, -0.061278, -0.496812>, <-0.473262, -0.061173, -0.471389>, <-0.403399, -0.061173, -0.487828>, 
      <-0.794521, -0.028643, -0.589041>, <-0.741133, -0.028643, -0.637007>, <-0.631507, -0.028643, -0.627398>, <-0.561644, -0.028643, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.319977, -0.028643, -0.157786>, <-0.319977, -0.028643, -0.157786>, <-0.258334, -0.028643, -0.259498>, <-0.258334, -0.028643, -0.259498>, 
      <-0.710366, -0.061316, -0.210724>, <-0.732196, -0.061316, -0.327638>, <-0.654886, -0.061278, -0.369359>, <-0.566415, -0.061278, -0.448846>, 
      <-1.000000, -0.028643, -0.250000>, <-1.021830, -0.028643, -0.366914>, <-0.882993, -0.028643, -0.509555>, <-0.794521, -0.028643, -0.589041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.212101, -0.028643, -0.011895>, <-0.212101, -0.028643, -0.011895>, <-0.319977, -0.028643, -0.157786>, <-0.319977, -0.028643, -0.157786>, 
      <-0.459015, -0.061132, 0.131186>, <-0.539535, -0.061132, -0.031411>, <-0.677062, -0.061316, -0.032364>, <-0.710366, -0.061316, -0.210724>, 
      <-0.640411, -0.028643, 0.236301>, <-0.720932, -0.028643, 0.073704>, <-0.966696, -0.028643, -0.071640>, <-1.000000, -0.028643, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.107306, -0.028643, 0.271667>, <-0.107306, -0.028643, 0.271667>, <-0.212101, -0.028643, -0.011895>, <-0.212101, -0.028643, -0.011895>, 
      <-0.212596, -0.061408, 0.792900>, <-0.374059, -0.061408, 0.537324>, <-0.324857, -0.061132, 0.402093>, <-0.459015, -0.061132, 0.131186>, 
      <-0.291096, -0.028643, 1.181507>, <-0.452558, -0.028643, 0.925931>, <-0.506254, -0.028643, 0.507209>, <-0.640411, -0.028643, 0.236301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.019977, -0.028643, 0.292214>, <-0.019977, -0.028643, 0.292214>, <-0.107306, -0.028643, 0.271667>, <-0.107306, -0.028643, 0.271667>, 
      <-0.008534, -0.061415, 0.840830>, <-0.098248, -0.061415, 0.840830>, <-0.164680, -0.061408, 0.868746>, <-0.212596, -0.061408, 0.792900>, 
      <0.000000, -0.028643, 1.250000>, <-0.089714, -0.028643, 1.250000>, <-0.243180, -0.028643, 1.257353>, <-0.291096, -0.028643, 1.181507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <0.074029, -0.028643, 0.271667>, <0.074029, -0.028643, 0.271667>, <-0.019977, -0.028643, 0.292214>, <-0.019977, -0.028643, 0.292214>, 
      <0.211127, -0.061411, 0.792865>, <0.158474, -0.061411, 0.873409>, <0.087692, -0.061415, 0.840830>, <-0.008534, -0.061415, 0.840830>, 
      <0.313356, -0.028643, 1.181507>, <0.260704, -0.028643, 1.262050>, <0.096226, -0.028643, 1.250000>, <0.000000, -0.028643, 1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <0.178824, -0.028643, -0.011895>, <0.178824, -0.028643, -0.011895>, <0.074029, -0.028643, 0.271667>, <0.074029, -0.028643, 0.271667>, 
      <0.457341, -0.061197, 0.130974>, <0.352546, -0.061197, 0.414536>, <0.376541, -0.061411, 0.539829>, <0.211127, -0.061411, 0.792865>, 
      <0.662671, -0.028643, 0.236301>, <0.557877, -0.028643, 0.519863>, <0.478770, -0.028643, 0.928471>, <0.313356, -0.028643, 1.181507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <0.286701, -0.028643, -0.157786>, <0.286701, -0.028643, -0.157786>, <0.178824, -0.028643, -0.011895>, <0.178824, -0.028643, -0.011895>, 
      <0.708695, -0.061345, -0.210689>, <0.675391, -0.061345, -0.032330>, <0.565218, -0.061197, -0.014916>, <0.457341, -0.061197, 0.130974>, 
      <1.022260, -0.028643, -0.250000>, <0.988956, -0.028643, -0.071640>, <0.770548, -0.028643, 0.090411>, <0.662671, -0.028643, 0.236301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <0.225057, -0.028643, -0.259498>, <0.225057, -0.028643, -0.259498>, <0.286701, -0.028643, -0.157786>, <0.286701, -0.028643, -0.157786>, 
      <0.564796, -0.061311, -0.448705>, <0.653268, -0.061311, -0.369219>, <0.730525, -0.061345, -0.327603>, <0.708695, -0.061345, -0.210689>, 
      <0.816781, -0.028643, -0.589041>, <0.905253, -0.028643, -0.509555>, <1.044090, -0.028643, -0.366914>, <1.022260, -0.028643, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <0.155194, -0.028643, -0.275936>, <0.155194, -0.028643, -0.275936>, <0.225057, -0.028643, -0.259498>, <0.225057, -0.028643, -0.259498>, 
      <0.401842, -0.061221, -0.487599>, <0.466556, -0.061221, -0.456563>, <0.511408, -0.061311, -0.496672>, <0.564796, -0.061311, -0.448705>, 
      <0.583904, -0.028643, -0.643836>, <0.648618, -0.028643, -0.612800>, <0.763393, -0.028643, -0.637007>, <0.816781, -0.028643, -0.589041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <0.124372, -0.028643, -0.307785>, <0.124372, -0.028643, -0.307785>, <0.155194, -0.028643, -0.275936>, <0.155194, -0.028643, -0.275936>, 
      <0.329628, -0.061224, -0.562183>, <0.373234, -0.061224, -0.554255>, <0.361879, -0.061221, -0.506764>, <0.401842, -0.061221, -0.487599>, 
      <0.481164, -0.028643, -0.750000>, <0.524770, -0.028643, -0.742072>, <0.543941, -0.028643, -0.663002>, <0.583904, -0.028643, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, <-0.028539, -0.028643, -0.118265>, 
      <-0.019977, -0.028643, -0.307785>, <-0.019977, -0.028643, -0.307785>, <0.124372, -0.028643, -0.307785>, <0.124372, -0.028643, -0.307785>, 
      <-0.008436, -0.061037, -0.563263>, <0.135913, -0.061037, -0.563263>, <0.187607, -0.061224, -0.588005>, <0.329628, -0.061224, -0.562183>, 
      <0.000000, -0.028643, -0.750000>, <0.144349, -0.028643, -0.750000>, <0.339143, -0.028643, -0.775822>, <0.481164, -0.028643, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.028539, -0.028643, -0.118265>, <-0.019977, -0.028643, -0.307785>, <-0.008436, -0.061037, -0.563263>, <0.000000, -0.028643, -0.750000>, 
      <-0.028539, -0.028643, -0.118265>, <-0.019977, -0.028643, -0.307785>, <-0.146107, -0.061037, -0.563263>, <-0.137671, -0.028643, -0.750000>, 
      <-0.028539, -0.028643, -0.118265>, <-0.157649, -0.028643, -0.307785>, <-0.195826, -0.061187, -0.587968>, <-0.323628, -0.028643, -0.775570>, 
      <-0.028539, -0.028643, -0.118265>, <-0.157649, -0.028643, -0.307785>, <-0.331101, -0.061187, -0.562398>, <-0.458904, -0.028643, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561644, 0.080946, -0.643836>, <-0.558736, 0.076900, -0.676333>, <-0.584809, -0.023881, -0.666674>, <-0.561644, -0.028643, -0.643836>, 
      <-0.561644, 0.080946, -0.643836>, <-0.558736, 0.044023, -0.676333>, <-0.584809, -0.023881, -0.666674>, <-0.561644, -0.028643, -0.643836>, 
      <-0.561644, 0.080946, -0.643836>, <-0.558736, 0.044023, -0.676333>, <-0.584809, -0.023881, -0.666674>, <-0.561644, -0.028643, -0.643836>, 
      <-0.561644, 0.080946, -0.643836>, <-0.561644, 0.048069, -0.643836>, <-0.584809, -0.023881, -0.666674>, <-0.561644, -0.028643, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561644, 0.080946, -0.643836>, <-0.561644, 0.048069, -0.643836>, <-0.584809, -0.023881, -0.666674>, <-0.561644, -0.028643, -0.643836>, 
      <-0.530822, 0.080946, -0.675685>, <-0.530822, 0.048069, -0.675685>, <-0.553987, -0.023881, -0.698523>, <-0.530822, -0.028643, -0.675685>, 
      <-0.502454, 0.080946, -0.741768>, <-0.505295, 0.079091, -0.774469>, <-0.520777, -0.023977, -0.768664>, <-0.502454, -0.028643, -0.741768>, 
      <-0.458904, 0.080946, -0.750000>, <-0.461745, 0.079091, -0.782701>, <-0.477227, -0.023977, -0.776896>, <-0.458904, -0.028643, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.794521, 0.080946, -0.589041>, <-0.794521, 0.048069, -0.589041>, <-0.822325, -0.024665, -0.606129>, <-0.794521, -0.028643, -0.589041>, 
      <-0.741133, 0.080946, -0.637007>, <-0.741133, 0.048069, -0.637007>, <-0.768936, -0.024665, -0.654096>, <-0.741133, -0.028643, -0.637007>, 
      <-0.631507, 0.080946, -0.627398>, <-0.628599, 0.076900, -0.659894>, <-0.654672, -0.023881, -0.650235>, <-0.631507, -0.028643, -0.627398>, 
      <-0.561644, 0.080946, -0.643836>, <-0.558736, 0.076900, -0.676333>, <-0.584809, -0.023881, -0.666674>, <-0.561644, -0.028643, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, 0.080946, -0.250000>, <-1.000000, 0.048069, -0.250000>, <-1.032377, -0.024991, -0.254391>, <-1.000000, -0.028643, -0.250000>, 
      <-1.021830, 0.080946, -0.366914>, <-1.021830, 0.048069, -0.366914>, <-1.054207, -0.024991, -0.371304>, <-1.021830, -0.028643, -0.366914>, 
      <-0.882993, 0.080946, -0.509555>, <-0.882993, 0.048069, -0.509555>, <-0.910796, -0.024665, -0.526643>, <-0.882993, -0.028643, -0.509555>, 
      <-0.794521, 0.080946, -0.589041>, <-0.794521, 0.048069, -0.589041>, <-0.822325, -0.024665, -0.606129>, <-0.794521, -0.028643, -0.589041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.640411, 0.080946, 0.236301>, <-0.643319, 0.076900, 0.268798>, <-0.668521, -0.023608, 0.252590>, <-0.640411, -0.028643, 0.236301>, 
      <-0.720932, 0.080946, 0.073704>, <-0.723840, 0.076900, 0.106201>, <-0.749042, -0.023608, 0.089993>, <-0.720932, -0.028643, 0.073704>, 
      <-0.966696, 0.080946, -0.071640>, <-0.966696, 0.048069, -0.071640>, <-0.999073, -0.024991, -0.076031>, <-0.966696, -0.028643, -0.071640>, 
      <-1.000000, 0.080946, -0.250000>, <-1.000000, 0.048069, -0.250000>, <-1.032377, -0.024991, -0.254391>, <-1.000000, -0.028643, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.640411, 0.080946, 0.236301>, <-0.720932, 0.080946, 0.073704>, <-0.966696, 0.080946, -0.071640>, <-1.000000, 0.080946, -0.250000>, 
      <-0.616961, 0.113573, -0.025733>, <-0.697481, 0.113573, -0.188330>, <-0.988527, 0.080946, -0.188554>, <-1.021830, 0.080946, -0.366914>, 
      <-0.585094, 0.113573, -0.381802>, <-0.654958, 0.113573, -0.365364>, <-0.829604, 0.080946, -0.557521>, <-0.882993, 0.080946, -0.509555>, 
      <-0.561644, 0.080946, -0.643836>, <-0.631507, 0.080946, -0.627398>, <-0.741133, 0.080946, -0.637007>, <-0.794521, 0.080946, -0.589041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.291096, 0.080946, 1.181507>, <-0.288255, 0.079091, 1.214208>, <-0.297584, -0.025935, 1.213623>, <-0.291096, -0.028643, 1.181507>, 
      <-0.452558, 0.080946, 0.925931>, <-0.449717, 0.079091, 0.958632>, <-0.459046, -0.025935, 0.958047>, <-0.452558, -0.028643, 0.925931>, 
      <-0.506254, 0.080946, 0.507209>, <-0.509162, 0.076900, 0.539705>, <-0.534364, -0.023608, 0.523498>, <-0.506254, -0.028643, 0.507209>, 
      <-0.640411, 0.080946, 0.236301>, <-0.643319, 0.076900, 0.268798>, <-0.668521, -0.023608, 0.252590>, <-0.640411, -0.028643, 0.236301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.291096, 0.080946, 1.181507>, <-0.452558, 0.080946, 0.925931>, <-0.506254, 0.080946, 0.507209>, <-0.640411, 0.080946, 0.236301>, 
      <-0.341358, 0.113770, 0.602978>, <-0.502820, 0.113770, 0.347402>, <-0.482803, 0.113573, 0.245175>, <-0.616961, 0.113573, -0.025733>, 
      <-0.408642, 0.113770, -0.171471>, <-0.452192, 0.113770, -0.163239>, <-0.554273, 0.113573, -0.413652>, <-0.585094, 0.113573, -0.381802>, 
      <-0.458904, 0.080946, -0.750000>, <-0.502454, 0.080946, -0.741768>, <-0.530822, 0.080946, -0.675685>, <-0.561644, 0.080946, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.080946, 1.250000>, <0.000000, 0.079147, 1.282828>, <0.000683, -0.026019, 1.282765>, <0.000000, -0.028643, 1.250000>, 
      <-0.089714, 0.080946, 1.250000>, <-0.089714, 0.079147, 1.282828>, <-0.089030, -0.026019, 1.282765>, <-0.089714, -0.028643, 1.250000>, 
      <-0.243180, 0.080946, 1.257353>, <-0.240339, 0.079091, 1.290054>, <-0.249667, -0.025935, 1.289469>, <-0.243180, -0.028643, 1.257353>, 
      <-0.291096, 0.080946, 1.181507>, <-0.288255, 0.079091, 1.214208>, <-0.297584, -0.025935, 1.213623>, <-0.291096, -0.028643, 1.181507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.313356, 0.080946, 1.181507>, <0.310515, 0.079091, 1.214208>, <0.321692, -0.025971, 1.213197>, <0.313356, -0.028643, 1.181507>, 
      <0.260704, 0.080946, 1.262050>, <0.257863, 0.079091, 1.294751>, <0.269039, -0.025971, 1.293740>, <0.260704, -0.028643, 1.262050>, 
      <0.096226, 0.080946, 1.250000>, <0.096226, 0.079147, 1.282828>, <0.096910, -0.026019, 1.282765>, <0.096226, -0.028643, 1.250000>, 
      <0.000000, 0.080946, 1.250000>, <0.000000, 0.079147, 1.282828>, <0.000683, -0.026019, 1.282765>, <0.000000, -0.028643, 1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.662671, 0.080946, 0.236301>, <0.662671, 0.048069, 0.236301>, <0.691637, -0.024051, 0.251159>, <0.662671, -0.028643, 0.236301>, 
      <0.557877, 0.080946, 0.519863>, <0.557877, 0.048069, 0.519863>, <0.586842, -0.024051, 0.534721>, <0.557877, -0.028643, 0.519863>, 
      <0.478770, 0.080946, 0.928471>, <0.475929, 0.079091, 0.961172>, <0.487106, -0.025971, 0.960161>, <0.478770, -0.028643, 0.928471>, 
      <0.313356, 0.080946, 1.181507>, <0.310515, 0.079091, 1.214208>, <0.321692, -0.025971, 1.213197>, <0.313356, -0.028643, 1.181507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.022260, 0.080946, -0.250000>, <1.022260, 0.048069, -0.250000>, <1.054708, -0.025259, -0.254068>, <1.022260, -0.028643, -0.250000>, 
      <0.988956, 0.080946, -0.071640>, <0.988956, 0.048069, -0.071640>, <1.021404, -0.025259, -0.075708>, <0.988956, -0.028643, -0.071640>, 
      <0.770548, 0.080946, 0.090411>, <0.770548, 0.048069, 0.090411>, <0.799513, -0.024051, 0.105269>, <0.770548, -0.028643, 0.090411>, 
      <0.662671, 0.080946, 0.236301>, <0.662671, 0.048069, 0.236301>, <0.691637, -0.024051, 0.251159>, <0.662671, -0.028643, 0.236301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.816781, 0.080946, -0.589041>, <0.822765, 0.076691, -0.621087>, <0.845321, -0.024943, -0.604936>, <0.816781, -0.028643, -0.589041>, 
      <0.905253, 0.080946, -0.509555>, <0.911237, 0.076691, -0.541601>, <0.933793, -0.024943, -0.525449>, <0.905253, -0.028643, -0.509555>, 
      <1.044090, 0.080946, -0.366914>, <1.044090, 0.048069, -0.366914>, <1.076538, -0.025259, -0.370981>, <1.044090, -0.028643, -0.366914>, 
      <1.022260, 0.080946, -0.250000>, <1.022260, 0.048069, -0.250000>, <1.054708, -0.025259, -0.254068>, <1.022260, -0.028643, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.816781, 0.080946, -0.589041>, <0.770937, 0.113546, -0.343521>, <0.708904, 0.080946, -0.011302>, <0.662671, 0.080946, 0.236301>, 
      <0.816781, 0.080946, -0.589041>, <0.859409, 0.113546, -0.264035>, <0.816781, 0.080946, -0.157192>, <0.770548, 0.080946, 0.090411>, 
      <0.816781, 0.080946, -0.589041>, <0.859409, 0.113546, -0.264035>, <1.010787, 0.080946, -0.188554>, <0.988956, 0.080946, -0.071640>, 
      <0.816781, 0.080946, -0.589041>, <0.905253, 0.080946, -0.509555>, <1.044090, 0.080946, -0.366914>, <1.022260, 0.080946, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583904, 0.080946, -0.643836>, <0.607355, 0.113573, -0.381802>, <0.639041, 0.080946, -0.027740>, <0.662671, 0.080946, 0.236301>, 
      <0.583904, 0.080946, -0.643836>, <0.672068, 0.113573, -0.350766>, <0.685274, 0.080946, -0.275343>, <0.708904, 0.080946, -0.011302>, 
      <0.583904, 0.080946, -0.643836>, <0.672068, 0.113573, -0.350766>, <0.717549, 0.113546, -0.391487>, <0.770937, 0.113546, -0.343521>, 
      <0.583904, 0.080946, -0.643836>, <0.648618, 0.080946, -0.612800>, <0.763393, 0.080946, -0.637007>, <0.816781, 0.080946, -0.589041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583904, 0.080946, -0.643836>, <0.580996, 0.076900, -0.676333>, <0.608626, -0.024219, -0.665052>, <0.583904, -0.028643, -0.643836>, 
      <0.648618, 0.080946, -0.612800>, <0.645709, 0.076900, -0.645297>, <0.673340, -0.024219, -0.634016>, <0.648618, -0.028643, -0.612800>, 
      <0.763393, 0.080946, -0.637007>, <0.769376, 0.076691, -0.669053>, <0.791933, -0.024943, -0.652902>, <0.763393, -0.028643, -0.637007>, 
      <0.816781, 0.080946, -0.589041>, <0.822765, 0.076691, -0.621087>, <0.845321, -0.024943, -0.604936>, <0.816781, -0.028643, -0.589041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583904, 0.080946, -0.643836>, <0.648618, 0.080946, -0.612800>, <0.763393, 0.080946, -0.637007>, <0.816781, 0.080946, -0.589041>, 
      <0.607355, 0.113573, -0.381802>, <0.672068, 0.113573, -0.350766>, <0.851864, 0.080946, -0.557521>, <0.905253, 0.080946, -0.509555>, 
      <0.639041, 0.080946, -0.027740>, <0.746918, 0.080946, -0.173630>, <1.010787, 0.080946, -0.188554>, <1.044090, 0.080946, -0.366914>, 
      <0.662671, 0.080946, 0.236301>, <0.770548, 0.080946, 0.090411>, <0.988956, 0.080946, -0.071640>, <1.022260, 0.080946, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481164, 0.080946, -0.750000>, <0.484005, 0.079091, -0.782701>, <0.501623, -0.024244, -0.775357>, <0.481164, -0.028643, -0.750000>, 
      <0.524770, 0.080946, -0.742072>, <0.527611, 0.079091, -0.774773>, <0.545229, -0.024244, -0.767428>, <0.524770, -0.028643, -0.742072>, 
      <0.543941, 0.080946, -0.663002>, <0.541033, 0.076900, -0.695499>, <0.568664, -0.024219, -0.684218>, <0.543941, -0.028643, -0.663002>, 
      <0.583904, 0.080946, -0.643836>, <0.580996, 0.076900, -0.676333>, <0.608626, -0.024219, -0.665052>, <0.583904, -0.028643, -0.643836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481164, 0.080946, -0.750000>, <0.524770, 0.080946, -0.742072>, <0.543941, 0.080946, -0.663002>, <0.583904, 0.080946, -0.643836>, 
      <0.430902, 0.113770, -0.171471>, <0.474508, 0.113770, -0.163543>, <0.567392, 0.113573, -0.400968>, <0.607355, 0.113573, -0.381802>, 
      <0.363618, 0.113770, 0.602978>, <0.529032, 0.113770, 0.349942>, <0.534246, 0.080946, 0.255822>, <0.639041, 0.080946, -0.027740>, 
      <0.313356, 0.080946, 1.181507>, <0.478770, 0.080946, 0.928471>, <0.557877, 0.080946, 0.519863>, <0.662671, 0.080946, 0.236301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.080946, -0.750000>, <0.000000, 0.079147, -0.782828>, <0.001462, -0.023029, -0.782361>, <0.000000, -0.028643, -0.750000>, 
      <0.144349, 0.080946, -0.750000>, <0.144349, 0.079147, -0.782828>, <0.145811, -0.023029, -0.782361>, <0.144349, -0.028643, -0.750000>, 
      <0.339143, 0.080946, -0.775822>, <0.341984, 0.079091, -0.808523>, <0.359602, -0.024244, -0.801179>, <0.339143, -0.028643, -0.775822>, 
      <0.481164, 0.080946, -0.750000>, <0.484005, 0.079091, -0.782701>, <0.501623, -0.024244, -0.775357>, <0.481164, -0.028643, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.080946, -0.750000>, <0.144349, 0.080946, -0.750000>, <0.339143, 0.080946, -0.775822>, <0.481164, 0.080946, -0.750000>, 
      <0.000000, 0.113774, -0.150899>, <0.144349, 0.113774, -0.150899>, <0.288881, 0.113770, -0.197293>, <0.430902, 0.113770, -0.171471>, 
      <0.000000, 0.113774, 0.650899>, <0.096226, 0.113774, 0.650899>, <0.310966, 0.113770, 0.683522>, <0.363618, 0.113770, 0.602978>, 
      <0.000000, 0.080946, 1.250000>, <0.096226, 0.080946, 1.250000>, <0.260704, 0.080946, 1.262050>, <0.313356, 0.080946, 1.181507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.080946, -0.750000>, <0.000000, 0.113774, -0.150899>, <0.000000, 0.113774, 0.650899>, <0.000000, 0.080946, 1.250000>, 
      <-0.137671, 0.080946, -0.750000>, <-0.137671, 0.113774, -0.150899>, <-0.089714, 0.113774, 0.650899>, <-0.089714, 0.080946, 1.250000>, 
      <-0.323628, 0.080946, -0.775570>, <-0.273366, 0.113770, -0.197042>, <-0.293442, 0.113770, 0.678824>, <-0.243180, 0.080946, 1.257353>, 
      <-0.458904, 0.080946, -0.750000>, <-0.408642, 0.113770, -0.171471>, <-0.341358, 0.113770, 0.602978>, <-0.291096, 0.080946, 1.181507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.080946, -0.750000>, <-0.137671, 0.080946, -0.750000>, <-0.323628, 0.080946, -0.775570>, <-0.458904, 0.080946, -0.750000>, 
      <0.000000, 0.079147, -0.782828>, <-0.137671, 0.079147, -0.782828>, <-0.326469, 0.079091, -0.808272>, <-0.461745, 0.079091, -0.782701>, 
      <0.001462, -0.023029, -0.782361>, <-0.136209, -0.023029, -0.782361>, <-0.341951, -0.023977, -0.802466>, <-0.477227, -0.023977, -0.776896>, 
      <0.000000, -0.028643, -0.750000>, <-0.137671, -0.028643, -0.750000>, <-0.323628, -0.028643, -0.775570>, <-0.458904, -0.028643, -0.750000>
    }
  }
}
#declare Plug = union {
  object { sPatchObj }
  object { sPatchObj1 }
  object { sPatchObj2 }
  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Bkant.ttf",
    "Snyman",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.265128, 0.32767, 0.32767>
    rotate <90.0, -0.0, 180.0>
    translate  <0.484703, -0.195848, 0.265805>
  }

  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Bkant.ttf",
    "Co.",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.32767
    rotate <90.0, -0.0, 180.0>
    translate  <0.234534, -0.195848, -0.500339>
  }

  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Bkant.ttf",
    "Electric",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.32767
    rotate <90.0, -0.0, 180.0>
    translate  <0.53161, -0.195848, -0.156356>
  }

  material {
    PlugText
  }
  scale 3.05185
  rotate <90.0, 0.0, 180.0>
  translate  <-2.887151, 0.286305, 2.540217>
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.308219, -0.109589, 0.250000>, <-0.308219, -0.109589, 0.022017>, <-0.269863, -0.032877, -0.275000>, <-0.253425, 0.000000, -0.500000>, 
      <-0.308219, -0.109589, 0.250000>, <-0.148744, -0.069720, 0.022017>, <-0.122525, 0.008050, -0.050924>, <-0.106087, 0.040927, -0.275924>, 
      <-0.308219, -0.109589, 0.250000>, <-0.148744, -0.069720, 0.022017>, <0.039829, -0.069720, -0.018253>, <0.199304, -0.109589, -0.018253>, 
      <-0.308219, -0.109589, 0.250000>, <-0.148744, -0.069720, 0.250000>, <0.080251, -0.069720, 0.250000>, <0.239726, -0.109589, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.253425, 0.000000, 1.000000>, <-0.269863, -0.032877, 0.775000>, <-0.308219, -0.109589, 0.477983>, <-0.308219, -0.109589, 0.250000>, 
      <-0.185617, 0.000000, 1.000000>, <-0.202055, -0.032877, 0.775000>, <-0.148744, -0.069720, 0.477983>, <-0.148744, -0.069720, 0.250000>, 
      <-0.095205, 0.000000, 1.000000>, <-0.015484, 0.040883, 0.776168>, <0.116175, -0.069720, 0.488406>, <0.080251, -0.069720, 0.250000>, 
      <-0.027397, 0.000000, 1.000000>, <0.052324, 0.040883, 0.776168>, <0.275650, -0.109589, 0.488406>, <0.239726, -0.109589, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184932, 0.000000, -0.500000>, <0.201370, -0.032877, -0.275000>, <0.239726, -0.109589, 0.022017>, <0.239726, -0.109589, 0.250000>, 
      <0.129452, 0.000000, -0.500000>, <0.145891, -0.032877, -0.275000>, <0.199304, -0.109589, -0.246236>, <0.199304, -0.109589, -0.018253>, 
      <0.055480, 0.000000, -0.500000>, <-0.020548, 0.000000, -0.500000>, <-0.030059, 0.040927, -0.275924>, <-0.106087, 0.040927, -0.275924>, 
      <0.000000, 0.000000, -0.500000>, <-0.076027, 0.000000, -0.500000>, <-0.177398, 0.000000, -0.500000>, <-0.253425, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184932, 0.000000, 1.000000>, <0.121233, 0.000000, 1.000000>, <0.036302, 0.000000, 1.000000>, <-0.027397, 0.000000, 1.000000>, 
      <0.184932, 0.000000, 1.000000>, <0.137672, -0.032877, 0.775000>, <0.116023, 0.040883, 0.776168>, <0.052324, 0.040883, 0.776168>, 
      <0.184932, 0.000000, 1.000000>, <0.137672, -0.032877, 0.775000>, <0.275650, -0.109589, 0.716388>, <0.275650, -0.109589, 0.488406>, 
      <0.184932, 0.000000, 1.000000>, <0.201370, -0.032877, 0.775000>, <0.239726, -0.109589, 0.477983>, <0.239726, -0.109589, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.308219, -0.246575, 0.250000>, <-0.308219, -0.205479, 0.250000>, <-0.348088, -0.119556, 0.250000>, <-0.308219, -0.109589, 0.250000>, 
      <-0.308219, -0.246575, 0.475600>, <-0.308219, -0.205479, 0.475600>, <-0.348088, -0.119556, 0.477983>, <-0.308219, -0.109589, 0.477983>, 
      <-0.269863, -0.246575, 0.775000>, <-0.269863, -0.172602, 0.775000>, <-0.269863, -0.106849, 0.775000>, <-0.269863, -0.032877, 0.775000>, 
      <-0.253425, -0.246575, 1.000000>, <-0.253425, -0.172602, 1.000000>, <-0.253425, -0.073972, 1.000000>, <-0.253425, 0.000000, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.253425, -0.246575, -0.500000>, <-0.253425, -0.172602, -0.500000>, <-0.293601, -0.011160, -0.561101>, <-0.253425, 0.000000, -0.500000>, 
      <-0.269863, -0.246575, -0.275000>, <-0.269863, -0.172602, -0.275000>, <-0.310039, -0.044037, -0.336101>, <-0.269863, -0.032877, -0.275000>, 
      <-0.308219, -0.246575, 0.024400>, <-0.308219, -0.205479, 0.024400>, <-0.348088, -0.119556, 0.022017>, <-0.308219, -0.109589, 0.022017>, 
      <-0.308219, -0.246575, 0.250000>, <-0.308219, -0.205479, 0.250000>, <-0.348088, -0.119556, 0.250000>, <-0.308219, -0.109589, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.246575, -0.500000>, <0.000000, -0.172602, -0.500000>, <0.000000, -0.073972, -0.500000>, <0.000000, 0.000000, -0.500000>, 
      <-0.076027, -0.246575, -0.500000>, <-0.076027, -0.172602, -0.500000>, <-0.076027, -0.073972, -0.500000>, <-0.076027, 0.000000, -0.500000>, 
      <-0.177398, -0.246575, -0.500000>, <-0.177398, -0.172602, -0.500000>, <-0.217573, -0.011160, -0.561101>, <-0.177398, 0.000000, -0.500000>, 
      <-0.253425, -0.246575, -0.500000>, <-0.253425, -0.172602, -0.500000>, <-0.293601, -0.011160, -0.561101>, <-0.253425, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184932, -0.246575, -0.500000>, <0.184932, -0.172602, -0.500000>, <0.184932, -0.073972, -0.500000>, <0.184932, 0.000000, -0.500000>, 
      <0.129452, -0.246575, -0.500000>, <0.129452, -0.172602, -0.500000>, <0.129452, -0.073972, -0.500000>, <0.129452, 0.000000, -0.500000>, 
      <0.055480, -0.246575, -0.500000>, <0.055480, -0.172602, -0.500000>, <0.055480, -0.073972, -0.500000>, <0.055480, 0.000000, -0.500000>, 
      <0.000000, -0.246575, -0.500000>, <0.000000, -0.172602, -0.500000>, <0.000000, -0.073972, -0.500000>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.239726, -0.246575, 0.250000>, <0.239726, -0.205479, 0.250000>, <0.279595, -0.119556, 0.250000>, <0.239726, -0.109589, 0.250000>, 
      <0.239726, -0.246575, 0.024400>, <0.239726, -0.205479, 0.024400>, <0.279595, -0.119556, 0.022017>, <0.239726, -0.109589, 0.022017>, 
      <0.201370, -0.246575, -0.275000>, <0.201370, -0.172602, -0.275000>, <0.201370, -0.106849, -0.275000>, <0.201370, -0.032877, -0.275000>, 
      <0.184932, -0.246575, -0.500000>, <0.184932, -0.172602, -0.500000>, <0.184932, -0.073972, -0.500000>, <0.184932, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184932, -0.246575, 1.000000>, <0.184932, -0.172602, 1.000000>, <0.184932, -0.073972, 1.000000>, <0.184932, 0.000000, 1.000000>, 
      <0.201370, -0.246575, 0.775000>, <0.201370, -0.172602, 0.775000>, <0.201370, -0.106849, 0.775000>, <0.201370, -0.032877, 0.775000>, 
      <0.239726, -0.246575, 0.475600>, <0.239726, -0.205479, 0.475600>, <0.279595, -0.119556, 0.477983>, <0.239726, -0.109589, 0.477983>, 
      <0.239726, -0.246575, 0.250000>, <0.239726, -0.205479, 0.250000>, <0.279595, -0.119556, 0.250000>, <0.239726, -0.109589, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.027397, -0.246575, 1.000000>, <-0.027397, -0.172602, 1.000000>, <-0.051857, -0.012543, 1.068675>, <-0.027397, 0.000000, 1.000000>, 
      <0.036302, -0.246575, 1.000000>, <0.036302, -0.172602, 1.000000>, <0.011842, -0.012543, 1.068675>, <0.036302, 0.000000, 1.000000>, 
      <0.121233, -0.246575, 1.000000>, <0.121233, -0.172602, 1.000000>, <0.121233, -0.073972, 1.000000>, <0.121233, 0.000000, 1.000000>, 
      <0.184932, -0.246575, 1.000000>, <0.184932, -0.172602, 1.000000>, <0.184932, -0.073972, 1.000000>, <0.184932, 0.000000, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.027397, -0.246575, 1.000000>, <-0.095205, -0.246575, 1.000000>, <-0.185617, -0.246575, 1.000000>, <-0.253425, -0.246575, 1.000000>, 
      <-0.027397, -0.172602, 1.000000>, <-0.095205, -0.172602, 1.000000>, <-0.185617, -0.172602, 1.000000>, <-0.253425, -0.172602, 1.000000>, 
      <-0.051857, -0.012543, 1.068675>, <-0.119665, -0.012543, 1.068675>, <-0.185617, -0.073972, 1.000000>, <-0.253425, -0.073972, 1.000000>, 
      <-0.027397, 0.000000, 1.000000>, <-0.095205, 0.000000, 1.000000>, <-0.185617, 0.000000, 1.000000>, <-0.253425, 0.000000, 1.000000>
    }
  }
  material {
    plugbutton
  }
  scale 2.622393
  rotate 90.0*x
  translate  <2.672176, 1.47924, 1.195396>
}
union { // WallSocknPlug
  object { Socket }
  object { Plug }
  object { sPatchObj3 }
  scale 1.588736
  rotate 90.0*x
  translate  <-23.549452, 18.555023, 34.392372>
}


object { SyrupBottle }


union { // Ladder
  object { SB1 }
  object { // SB2->SB1
    SB1
    translate  4.926845*x
  }
  object { R1 }
  object { // R2->R1
    R1
    rotate <0.0, -0.0, -0.0>
    translate  5.0*z
  }
  object { // R3->R1
    R1
    rotate <0.0, -0.0, -0.0>
    translate  10.0*z
  }
  object { // R4->R1
    R1
    rotate <0.0, -0.0, -0.0>
    translate  15.0*z
  }
  object { // R5->R1
    R1
    rotate <0.0, -0.0, -0.0>
    translate  20.0*z
  }
  scale 0.354858
  rotate <-18.58473, -1.025709, -28.606543>
  translate  <-22.182726, -3.693584, 5.187106>
}


object { LadderCarriers }


union { // PlugWire
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.283362, -2.705267, 0.000000>, <-4.283362, -2.705267, -0.048964>, <-4.283827, -2.630412, -0.027652>, <-4.284131, -2.581449, -0.027652>, 
      <-3.699992, -2.584570, 0.000000>, <-3.699992, -2.584570, -0.048964>, <-3.700457, -2.509715, -0.027652>, <-3.700760, -2.460752, -0.027652>, 
      <-2.918116, -2.441775, 0.000000>, <-2.918116, -2.441775, -0.048964>, <-2.918568, -2.366974, -0.027652>, <-2.918872, -2.318010, -0.027652>, 
      <-2.338794, -2.302943, 0.000000>, <-2.338794, -2.302943, -0.048964>, <-2.339258, -2.228088, -0.027652>, <-2.339562, -2.179124, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.284131, -2.581449, 0.027652>, <-4.283827, -2.630412, 0.027652>, <-4.283362, -2.705267, 0.048964>, <-4.283362, -2.705267, 0.000000>, 
      <-3.700760, -2.460752, 0.027652>, <-3.700457, -2.509715, 0.027652>, <-3.699992, -2.584570, 0.048964>, <-3.699992, -2.584570, 0.000000>, 
      <-2.918872, -2.318010, 0.027652>, <-2.918568, -2.366974, 0.027652>, <-2.918116, -2.441775, 0.048964>, <-2.918116, -2.441775, 0.000000>, 
      <-2.339562, -2.179124, 0.027652>, <-2.339258, -2.228088, 0.027652>, <-2.338794, -2.302943, 0.048964>, <-2.338794, -2.302943, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.284900, -2.457630, 0.000000>, <-4.284900, -2.457630, 0.048964>, <-4.284435, -2.532485, 0.027652>, <-4.284131, -2.581449, 0.027652>, 
      <-3.701529, -2.336933, 0.000000>, <-3.701529, -2.336933, 0.048964>, <-3.701064, -2.411788, 0.027652>, <-3.700760, -2.460752, 0.027652>, 
      <-2.919628, -2.194247, 0.000000>, <-2.919628, -2.194247, 0.048964>, <-2.919176, -2.269047, 0.027652>, <-2.918872, -2.318010, 0.027652>, 
      <-2.340331, -2.055306, 0.000000>, <-2.340331, -2.055306, 0.048964>, <-2.339866, -2.130161, 0.027652>, <-2.339562, -2.179124, 0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.284900, -2.457630, 0.000000>, <-3.701529, -2.336933, 0.000000>, <-2.919628, -2.194247, 0.000000>, <-2.340331, -2.055306, 0.000000>, 
      <-4.284900, -2.457630, -0.048964>, <-3.701529, -2.336933, -0.048964>, <-2.919628, -2.194247, -0.048964>, <-2.340331, -2.055306, -0.048964>, 
      <-4.284435, -2.532485, -0.027652>, <-3.701064, -2.411788, -0.027652>, <-2.919176, -2.269047, -0.027652>, <-2.339866, -2.130161, -0.027652>, 
      <-4.284131, -2.581449, -0.027652>, <-3.700760, -2.460752, -0.027652>, <-2.918872, -2.318010, -0.027652>, <-2.339562, -2.179124, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.066166, -1.934280, 0.000000>, <-1.397314, -2.154133, 0.000000>, <-1.952253, -2.210310, 0.000000>, <-2.338794, -2.302943, 0.000000>, 
      <-1.066166, -1.934280, -0.048964>, <-1.397314, -2.154133, -0.048964>, <-1.952253, -2.210310, -0.048964>, <-2.338794, -2.302943, -0.048964>, 
      <-1.098944, -1.866981, -0.027652>, <-1.416298, -2.077880, -0.027652>, <-1.968717, -2.139253, -0.027652>, <-2.339258, -2.228088, -0.027652>, 
      <-1.120384, -1.822960, -0.027652>, <-1.437738, -2.033860, -0.027652>, <-1.969021, -2.090289, -0.027652>, <-2.339562, -2.179124, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.120384, -1.822960, 0.027652>, <-1.437738, -2.033860, 0.027652>, <-1.969021, -2.090289, 0.027652>, <-2.339562, -2.179124, 0.027652>, 
      <-1.098944, -1.866981, 0.027652>, <-1.416298, -2.077880, 0.027652>, <-1.968717, -2.139253, 0.027652>, <-2.339258, -2.228088, 0.027652>, 
      <-1.066166, -1.934280, 0.048964>, <-1.397314, -2.154133, 0.048964>, <-1.952253, -2.210310, 0.048964>, <-2.338794, -2.302943, 0.048964>, 
      <-1.066166, -1.934280, 0.000000>, <-1.397314, -2.154133, 0.000000>, <-1.952253, -2.210310, 0.000000>, <-2.338794, -2.302943, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.174602, -1.711640, 0.000000>, <-1.478163, -1.913591, 0.000000>, <-1.985787, -1.970270, 0.000000>, <-2.340331, -2.055306, 0.000000>, 
      <-1.174602, -1.711640, 0.048964>, <-1.478163, -1.913591, 0.048964>, <-1.985787, -1.970270, 0.048964>, <-2.340331, -2.055306, 0.048964>, 
      <-1.141825, -1.778939, 0.027652>, <-1.459179, -1.989839, 0.027652>, <-1.969325, -2.041326, 0.027652>, <-2.339866, -2.130161, 0.027652>, 
      <-1.120384, -1.822960, 0.027652>, <-1.437738, -2.033860, 0.027652>, <-1.969021, -2.090289, 0.027652>, <-2.339562, -2.179124, 0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.174602, -1.711640, 0.000000>, <-1.174602, -1.711640, -0.048964>, <-1.141825, -1.778939, -0.027652>, <-1.120384, -1.822960, -0.027652>, 
      <-1.478163, -1.913591, 0.000000>, <-1.478163, -1.913591, -0.048964>, <-1.459179, -1.989839, -0.027652>, <-1.437738, -2.033860, -0.027652>, 
      <-1.985787, -1.970270, 0.000000>, <-1.985787, -1.970270, -0.048964>, <-1.969325, -2.041326, -0.027652>, <-1.969021, -2.090289, -0.027652>, 
      <-2.340331, -2.055306, 0.000000>, <-2.340331, -2.055306, -0.048964>, <-2.339866, -2.130161, -0.027652>, <-2.339562, -2.179124, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.062230, -0.791505, 0.000000>, <-0.259815, -1.202849, 0.000000>, <-0.685988, -1.681875, 0.000000>, <-1.066166, -1.934280, 0.000000>, 
      <-0.062230, -0.791505, -0.048964>, <-0.259815, -1.202849, -0.048964>, <-0.685988, -1.681875, -0.048964>, <-1.066166, -1.934280, -0.048964>, 
      <-0.130514, -0.760832, -0.027652>, <-0.314944, -1.150441, -0.027652>, <-0.739934, -1.628398, -0.027652>, <-1.098944, -1.866981, -0.027652>, 
      <-0.175179, -0.740768, -0.027652>, <-0.359609, -1.130377, -0.027652>, <-0.761374, -1.584378, -0.027652>, <-1.120384, -1.822960, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175179, -0.740768, 0.027652>, <-0.359609, -1.130377, 0.027652>, <-0.761374, -1.584378, 0.027652>, <-1.120384, -1.822960, 0.027652>, 
      <-0.130514, -0.760832, 0.027652>, <-0.314944, -1.150441, 0.027652>, <-0.739934, -1.628398, 0.027652>, <-1.098944, -1.866981, 0.027652>, 
      <-0.062230, -0.791505, 0.048964>, <-0.259815, -1.202849, 0.048964>, <-0.685988, -1.681875, 0.048964>, <-1.066166, -1.934280, 0.048964>, 
      <-0.062230, -0.791505, 0.000000>, <-0.259815, -1.202849, 0.000000>, <-0.685988, -1.681875, 0.000000>, <-1.066166, -1.934280, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288127, -0.690032, 0.000000>, <-0.459434, -1.057878, 0.000000>, <-0.836756, -1.486881, 0.000000>, <-1.174602, -1.711640, 0.000000>, 
      <-0.288127, -0.690032, 0.048964>, <-0.459434, -1.057878, 0.048964>, <-0.836756, -1.486881, 0.048964>, <-1.174602, -1.711640, 0.048964>, 
      <-0.219844, -0.720705, 0.027652>, <-0.404274, -1.110314, 0.027652>, <-0.782815, -1.540357, 0.027652>, <-1.141825, -1.778939, 0.027652>, 
      <-0.175179, -0.740768, 0.027652>, <-0.359609, -1.130377, 0.027652>, <-0.761374, -1.584378, 0.027652>, <-1.120384, -1.822960, 0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288127, -0.690032, 0.000000>, <-0.288127, -0.690032, -0.048964>, <-0.219844, -0.720705, -0.027652>, <-0.175179, -0.740768, -0.027652>, 
      <-0.459434, -1.057878, 0.000000>, <-0.459434, -1.057878, -0.048964>, <-0.404274, -1.110314, -0.027652>, <-0.359609, -1.130377, -0.027652>, 
      <-0.836756, -1.486881, 0.000000>, <-0.836756, -1.486881, -0.048964>, <-0.782815, -1.540357, -0.027652>, <-0.761374, -1.584378, -0.027652>, 
      <-1.174602, -1.711640, 0.000000>, <-1.174602, -1.711640, -0.048964>, <-1.141825, -1.778939, -0.027652>, <-1.120384, -1.822960, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.099327, 0.492108, 0.000000>, <0.066970, 0.105337, 0.000000>, <0.105820, -0.441651, 0.000000>, <-0.062230, -0.791505, 0.000000>, 
      <0.099327, 0.492108, -0.048964>, <0.066970, 0.105337, -0.048964>, <0.105820, -0.441651, -0.048964>, <-0.062230, -0.791505, -0.048964>, 
      <0.024470, 0.492108, -0.027652>, <-0.005356, 0.120689, -0.027652>, <0.028912, -0.424045, -0.027652>, <-0.130514, -0.760832, -0.027652>, 
      <-0.024494, 0.492108, -0.027652>, <-0.054321, 0.120689, -0.027652>, <-0.015753, -0.403981, -0.027652>, <-0.175179, -0.740768, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.024494, 0.492108, 0.027652>, <-0.054321, 0.120689, 0.027652>, <-0.015753, -0.403981, 0.027652>, <-0.175179, -0.740768, 0.027652>, 
      <0.024470, 0.492108, 0.027652>, <-0.005356, 0.120689, 0.027652>, <0.028912, -0.424045, 0.027652>, <-0.130514, -0.760832, 0.027652>, 
      <0.099327, 0.492108, 0.048964>, <0.066970, 0.105337, 0.048964>, <0.105820, -0.441651, 0.048964>, <-0.062230, -0.791505, 0.048964>, 
      <0.099327, 0.492108, 0.000000>, <0.066970, 0.105337, 0.000000>, <0.105820, -0.441651, 0.000000>, <-0.062230, -0.791505, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.148315, 0.492108, 0.000000>, <-0.175650, 0.136042, 0.000000>, <-0.137366, -0.366301, 0.000000>, <-0.288127, -0.690032, 0.000000>, 
      <-0.148315, 0.492108, 0.048964>, <-0.175650, 0.136042, 0.048964>, <-0.137366, -0.366301, 0.048964>, <-0.288127, -0.690032, 0.048964>, 
      <-0.073458, 0.492108, 0.027652>, <-0.103285, 0.120689, 0.027652>, <-0.060418, -0.383918, 0.027652>, <-0.219844, -0.720705, 0.027652>, 
      <-0.024494, 0.492108, 0.027652>, <-0.054321, 0.120689, 0.027652>, <-0.015753, -0.403981, 0.027652>, <-0.175179, -0.740768, 0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.148315, 0.492108, 0.000000>, <-0.148315, 0.492108, -0.048964>, <-0.073458, 0.492108, -0.027652>, <-0.024494, 0.492108, -0.027652>, 
      <-0.175650, 0.136042, 0.000000>, <-0.175650, 0.136042, -0.048964>, <-0.103285, 0.120689, -0.027652>, <-0.054321, 0.120689, -0.027652>, 
      <-0.137366, -0.366301, 0.000000>, <-0.137366, -0.366301, -0.048964>, <-0.060418, -0.383918, -0.027652>, <-0.015753, -0.403981, -0.027652>, 
      <-0.288127, -0.690032, 0.000000>, <-0.288127, -0.690032, -0.048964>, <-0.219844, -0.720705, -0.027652>, <-0.175179, -0.740768, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107219, 1.233919, 0.000000>, <0.104851, 1.011376, 0.000000>, <0.117882, 0.713889, 0.000000>, <0.099327, 0.492108, 0.000000>, 
      <0.107219, 1.233919, -0.048964>, <0.104851, 1.011376, -0.048964>, <0.117882, 0.713889, -0.048964>, <0.099327, 0.492108, -0.048964>, 
      <0.032362, 1.233919, -0.027652>, <0.029995, 1.011376, -0.027652>, <0.042285, 0.713950, -0.027652>, <0.024470, 0.492108, -0.027652>, 
      <-0.016602, 1.233919, -0.027652>, <-0.018970, 1.011376, -0.027652>, <-0.006679, 0.713950, -0.027652>, <-0.024494, 0.492108, -0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.016602, 1.233919, 0.027652>, <-0.018970, 1.011376, 0.027652>, <-0.006679, 0.713950, 0.027652>, <-0.024494, 0.492108, 0.027652>, 
      <0.032362, 1.233919, 0.027652>, <0.029995, 1.011376, 0.027652>, <0.042285, 0.713950, 0.027652>, <0.024470, 0.492108, 0.027652>, 
      <0.107219, 1.233919, 0.048964>, <0.104851, 1.011376, 0.048964>, <0.117882, 0.713889, 0.048964>, <0.099327, 0.492108, 0.048964>, 
      <0.107219, 1.233919, 0.000000>, <0.104851, 1.011376, 0.000000>, <0.117882, 0.713889, 0.000000>, <0.099327, 0.492108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140423, 1.233919, 0.000000>, <-0.142791, 1.011376, 0.000000>, <-0.131279, 0.714011, 0.000000>, <-0.148315, 0.492108, 0.000000>, 
      <-0.140423, 1.233919, 0.048964>, <-0.142791, 1.011376, 0.048964>, <-0.131279, 0.714011, 0.048964>, <-0.148315, 0.492108, 0.048964>, 
      <-0.065567, 1.233919, 0.027652>, <-0.067934, 1.011376, 0.027652>, <-0.055643, 0.713950, 0.027652>, <-0.073458, 0.492108, 0.027652>, 
      <-0.016602, 1.233919, 0.027652>, <-0.018970, 1.011376, 0.027652>, <-0.006679, 0.713950, 0.027652>, <-0.024494, 0.492108, 0.027652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140423, 1.233919, 0.000000>, <-0.140423, 1.233919, -0.048964>, <-0.065567, 1.233919, -0.027652>, <-0.016602, 1.233919, -0.027652>, 
      <-0.142791, 1.011376, 0.000000>, <-0.142791, 1.011376, -0.048964>, <-0.067934, 1.011376, -0.027652>, <-0.018970, 1.011376, -0.027652>, 
      <-0.131279, 0.714011, 0.000000>, <-0.131279, 0.714011, -0.048964>, <-0.055643, 0.713950, -0.027652>, <-0.006679, 0.713950, -0.027652>, 
      <-0.148315, 0.492108, 0.000000>, <-0.148315, 0.492108, -0.048964>, <-0.073458, 0.492108, -0.027652>, <-0.024494, 0.492108, -0.027652>
    }
  }
  material {
    GreyWire_js
  }
  scale 4.993047
  rotate 90.0*x
  translate  <-28.207635, 15.598855, 26.034488>
}


union { // SugarBag
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.607817, -0.420941, -0.750000>, <-0.277150, -0.612231, -0.750000>, <0.350986, -0.602218, -0.750000>, <0.665038, -0.384723, -0.750000>, 
      <-0.476762, -0.330179, -0.904220>, <-0.146095, -0.521469, -0.904220>, <0.204959, -0.517741, -0.907053>, <0.519011, -0.300247, -0.907053>, 
      <-0.182345, -0.126282, -0.750000>, <-0.182345, -0.126282, -0.750000>, <0.199511, -0.115417, -0.750000>, <0.199511, -0.115417, -0.750000>, 
      <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.665038, 0.384723, -0.750000>, <-0.864240, 0.246767, -0.750000>, <-0.817558, -0.299607, -0.750000>, <-0.607817, -0.420941, -0.750000>, 
      <-0.519011, 0.300247, -0.907053>, <-0.718212, 0.162290, -0.907053>, <-0.686502, -0.208845, -0.904220>, <-0.476762, -0.330179, -0.904220>, 
      <-0.199511, 0.115417, -0.750000>, <-0.199511, 0.115417, -0.750000>, <-0.182345, -0.126282, -0.750000>, <-0.182345, -0.126282, -0.750000>, 
      <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.718834, -0.497826, 0.095890>, <-0.327772, -0.724055, 0.095890>, <0.415093, -0.712212, 0.095890>, <0.786505, -0.454992, 0.095890>, 
      <-0.718834, -0.497826, -0.161091>, <-0.327772, -0.724055, -0.161091>, <0.415093, -0.712212, -0.161345>, <0.786505, -0.454992, -0.161345>, 
      <-0.759657, -0.526097, -0.571322>, <-0.428990, -0.717387, -0.571322>, <0.513958, -0.696497, -0.574724>, <0.828009, -0.479002, -0.574724>, 
      <-0.607817, -0.420941, -0.750000>, <-0.277150, -0.612231, -0.750000>, <0.350986, -0.602218, -0.750000>, <0.665038, -0.384723, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.786505, 0.454992, 0.095890>, <-1.022091, 0.291838, 0.095890>, <-0.966884, -0.354330, 0.095890>, <-0.718834, -0.497826, 0.095890>, 
      <-0.786505, 0.454992, -0.161345>, <-1.022091, 0.291838, -0.161345>, <-0.966884, -0.354330, -0.161091>, <-0.718834, -0.497826, -0.161091>, 
      <-0.828009, 0.479002, -0.574724>, <-1.027211, 0.341046, -0.574724>, <-0.969397, -0.404763, -0.571322>, <-0.759657, -0.526097, -0.571322>, 
      <-0.665038, 0.384723, -0.750000>, <-0.864240, 0.246767, -0.750000>, <-0.817558, -0.299607, -0.750000>, <-0.607817, -0.420941, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.607817, -0.420941, 1.000000>, <-0.277150, -0.612231, 1.000000>, <0.350986, -0.602218, 1.000000>, <0.665038, -0.384723, 1.000000>, 
      <-0.748429, -0.518321, 0.785631>, <-0.417762, -0.709611, 0.785631>, <0.502632, -0.689945, 0.788701>, <0.816684, -0.472450, 0.788701>, 
      <-0.718834, -0.497826, 0.370132>, <-0.327772, -0.724055, 0.370132>, <0.415093, -0.712212, 0.370371>, <0.786505, -0.454992, 0.370371>, 
      <-0.718834, -0.497826, 0.095890>, <-0.327772, -0.724055, 0.095890>, <0.415093, -0.712212, 0.095890>, <0.786505, -0.454992, 0.095890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.665038, 0.384723, 1.000000>, <-0.864240, 0.246767, 1.000000>, <-0.817558, -0.299607, 1.000000>, <-0.607817, -0.420941, 1.000000>, 
      <-0.816684, 0.472450, 0.788701>, <-1.015886, 0.334494, 0.788701>, <-0.958170, -0.396987, 0.785631>, <-0.748429, -0.518321, 0.785631>, 
      <-0.786505, 0.454992, 0.370371>, <-1.022091, 0.291838, 0.370371>, <-0.966884, -0.354330, 0.370132>, <-0.718834, -0.497826, 0.370132>, 
      <-0.786505, 0.454992, 0.095890>, <-1.022091, 0.291838, 0.095890>, <-0.966884, -0.354330, 0.095890>, <-0.718834, -0.497826, 0.095890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.718834, 0.497826, 0.095890>, <0.327772, 0.724055, 0.095890>, <-0.415093, 0.712212, 0.095890>, <-0.786505, 0.454992, 0.095890>, 
      <0.718834, 0.497826, -0.161091>, <0.327772, 0.724055, -0.161091>, <-0.415093, 0.712212, -0.161345>, <-0.786505, 0.454992, -0.161345>, 
      <0.759657, 0.526097, -0.571322>, <0.428990, 0.717387, -0.571322>, <-0.513958, 0.696497, -0.574724>, <-0.828009, 0.479002, -0.574724>, 
      <0.607817, 0.420941, -0.750000>, <0.277150, 0.612231, -0.750000>, <-0.350986, 0.602218, -0.750000>, <-0.665038, 0.384723, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.718834, 0.497826, 0.095890>, <0.718834, 0.497826, -0.161091>, <0.759657, 0.526097, -0.571322>, <0.607817, 0.420941, -0.750000>, 
      <0.966884, 0.354330, 0.095890>, <0.966884, 0.354330, -0.161091>, <0.969397, 0.404763, -0.571322>, <0.817558, 0.299607, -0.750000>, 
      <1.022091, -0.291838, 0.095890>, <1.022091, -0.291838, -0.161345>, <1.027211, -0.341046, -0.574724>, <0.864240, -0.246767, -0.750000>, 
      <0.786505, -0.454992, 0.095890>, <0.786505, -0.454992, -0.161345>, <0.828009, -0.479002, -0.574724>, <0.665038, -0.384723, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -0.750000>, <0.182345, 0.126282, -0.750000>, <0.476762, 0.330179, -0.904220>, <0.607817, 0.420941, -0.750000>, 
      <0.000000, 0.000000, -0.750000>, <0.182345, 0.126282, -0.750000>, <0.146095, 0.521469, -0.904220>, <0.277150, 0.612231, -0.750000>, 
      <0.000000, 0.000000, -0.750000>, <-0.199511, 0.115417, -0.750000>, <-0.204959, 0.517741, -0.907053>, <-0.350986, 0.602218, -0.750000>, 
      <0.000000, 0.000000, -0.750000>, <-0.199511, 0.115417, -0.750000>, <-0.519011, 0.300247, -0.907053>, <-0.665038, 0.384723, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>, <0.000000, 0.000000, -0.750000>, 
      <0.182345, 0.126282, -0.750000>, <0.182345, 0.126282, -0.750000>, <0.199511, -0.115417, -0.750000>, <0.199511, -0.115417, -0.750000>, 
      <0.476762, 0.330179, -0.904220>, <0.686502, 0.208845, -0.904220>, <0.718212, -0.162290, -0.907053>, <0.519011, -0.300247, -0.907053>, 
      <0.607817, 0.420941, -0.750000>, <0.817558, 0.299607, -0.750000>, <0.864240, -0.246767, -0.750000>, <0.665038, -0.384723, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.607817, 0.420941, 1.000000>, <0.277150, 0.612231, 1.000000>, <-0.350986, 0.602218, 1.000000>, <-0.665038, 0.384723, 1.000000>, 
      <0.748429, 0.518321, 0.785631>, <0.417762, 0.709611, 0.785631>, <-0.502632, 0.689945, 0.788701>, <-0.816684, 0.472450, 0.788701>, 
      <0.718834, 0.497826, 0.370132>, <0.327772, 0.724055, 0.370132>, <-0.415093, 0.712212, 0.370371>, <-0.786505, 0.454992, 0.370371>, 
      <0.718834, 0.497826, 0.095890>, <0.327772, 0.724055, 0.095890>, <-0.415093, 0.712212, 0.095890>, <-0.786505, 0.454992, 0.095890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.607817, 0.420941, 1.000000>, <0.748429, 0.518321, 0.785631>, <0.718834, 0.497826, 0.370132>, <0.718834, 0.497826, 0.095890>, 
      <0.817558, 0.299607, 1.000000>, <0.958170, 0.396987, 0.785631>, <0.966884, 0.354330, 0.370132>, <0.966884, 0.354330, 0.095890>, 
      <0.864240, -0.246767, 1.000000>, <1.015886, -0.334494, 0.788701>, <1.022091, -0.291838, 0.370371>, <1.022091, -0.291838, 0.095890>, 
      <0.665038, -0.384723, 1.000000>, <0.816684, -0.472450, 0.788701>, <0.786505, -0.454992, 0.370371>, <0.786505, -0.454992, 0.095890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <-0.229052, -0.006517, 1.191781>, <-0.490328, -0.339574, 1.179117>, <-0.607817, -0.420941, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <0.008415, 0.000239, 1.191781>, <-0.159661, -0.530864, 1.179117>, <-0.277150, -0.612231, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <0.008415, 0.000239, 1.191781>, <0.219737, -0.526290, 1.182879>, <0.350986, -0.602218, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <0.237467, 0.006757, 1.191781>, <0.533789, -0.308795, 1.182879>, <0.665038, -0.384723, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <-0.229052, -0.006517, 1.191781>, <-0.490328, -0.339574, 1.179117>, <-0.607817, -0.420941, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <-0.466518, -0.013274, 1.191781>, <-0.700068, -0.218240, 1.179117>, <-0.817558, -0.299607, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <-0.466518, -0.013274, 1.191781>, <-0.732990, 0.170839, 1.182879>, <-0.864240, 0.246767, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <-0.237467, -0.006757, 1.191781>, <-0.533789, 0.308795, 1.182879>, <-0.665038, 0.384723, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <0.237467, 0.006757, 1.191781>, <0.533789, -0.308795, 1.182879>, <0.665038, -0.384723, 1.000000>, 
      <-0.237467, -0.006757, 1.191781>, <0.000000, 0.000000, 1.191781>, <0.219737, -0.526290, 1.182879>, <0.350986, -0.602218, 1.000000>, 
      <-0.533789, 0.308795, 1.182879>, <-0.732990, 0.170839, 1.182879>, <-0.486891, -0.490897, 1.000000>, <-0.277150, -0.612231, 1.000000>, 
      <-0.665038, 0.384723, 1.000000>, <-0.864240, 0.246767, 1.000000>, <-0.817558, -0.299607, 1.000000>, <-0.607817, -0.420941, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <0.237467, 0.006757, 1.191781>, <0.533789, -0.308795, 1.182879>, <0.665038, -0.384723, 1.000000>, 
      <-0.237467, -0.006757, 1.191781>, <0.000000, 0.000000, 1.191781>, <0.732990, -0.170839, 1.182879>, <0.864240, -0.246767, 1.000000>, 
      <-0.533789, 0.308795, 1.182879>, <-0.219737, 0.526290, 1.182879>, <0.486891, 0.490897, 1.000000>, <0.817558, 0.299607, 1.000000>, 
      <-0.665038, 0.384723, 1.000000>, <-0.350986, 0.602218, 1.000000>, <0.277150, 0.612231, 1.000000>, <0.607817, 0.420941, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <-0.237467, -0.006757, 1.191781>, <-0.533789, 0.308795, 1.182879>, <-0.665038, 0.384723, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <-0.008415, -0.000239, 1.191781>, <-0.219737, 0.526290, 1.182879>, <-0.350986, 0.602218, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <-0.008415, -0.000239, 1.191781>, <0.159661, 0.530864, 1.179117>, <0.277150, 0.612231, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <0.229052, 0.006517, 1.191781>, <0.490328, 0.339574, 1.179117>, <0.607817, 0.420941, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <-0.229052, -0.006517, 1.191781>, <-0.490328, -0.339574, 1.179117>, <-0.607817, -0.420941, 1.000000>, 
      <0.229052, 0.006517, 1.191781>, <0.000000, 0.000000, 1.191781>, <-0.700068, -0.218240, 1.179117>, <-0.817558, -0.299607, 1.000000>, 
      <0.490328, 0.339574, 1.179117>, <0.159661, 0.530864, 1.179117>, <-0.550188, 0.464262, 1.000000>, <-0.864240, 0.246767, 1.000000>, 
      <0.607817, 0.420941, 1.000000>, <0.277150, 0.612231, 1.000000>, <-0.350986, 0.602218, 1.000000>, <-0.665038, 0.384723, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <0.237467, 0.006757, 1.191781>, <0.533789, -0.308795, 1.182879>, <0.665038, -0.384723, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <0.466518, 0.013274, 1.191781>, <0.732990, -0.170839, 1.182879>, <0.864240, -0.246767, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <0.466518, 0.013274, 1.191781>, <0.700068, 0.218240, 1.179117>, <0.817558, 0.299607, 1.000000>, 
      <0.000000, 0.000000, 1.191781>, <0.229052, 0.006517, 1.191781>, <0.490328, 0.339574, 1.179117>, <0.607817, 0.420941, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.191781>, <0.229052, 0.006517, 1.191781>, <0.490328, 0.339574, 1.179117>, <0.607817, 0.420941, 1.000000>, 
      <-0.229052, -0.006517, 1.191781>, <0.000000, 0.000000, 1.191781>, <0.700068, 0.218240, 1.179117>, <0.817558, 0.299607, 1.000000>, 
      <-0.490328, -0.339574, 1.179117>, <-0.159661, -0.530864, 1.179117>, <0.550188, -0.464262, 1.000000>, <0.864240, -0.246767, 1.000000>, 
      <-0.607817, -0.420941, 1.000000>, <-0.277150, -0.612231, 1.000000>, <0.350986, -0.602218, 1.000000>, <0.665038, -0.384723, 1.000000>
    }
  }
  material {
    SugarBagTexture
    scale <1.677365, 1.757055, 1.0>
    rotate 90.0*x
    translate <-0.828364, -0.634354, -0.737132>
  }
  scale 7.822611
  rotate 27.976885*z
  translate  <-6.398571, -1.611749, 7.542501>
}


#declare Matches = union {
  object { // Matcstick4->Matcstick2
    Matcstick2
    rotate -0.0*z
    translate  <0.07469, 3.585133, 0.0>
  }
  object { // Matcstick3->Matcstick1
    Matcstick1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.07469, 3.435752, 0.0>
  }
  object { Matcstick2 }
  object { Matcstick1 }
  object { Matcstick }
}
#declare CSG002 = intersection {
  torus { // Sweetie1
    1.3, 0.7  rotate -x*90
    sturm
    material {
      Orange_js_LS_1
    }
    scale <1.655304, 1.717221, 1.119537>
    rotate -90.0*x
    translate  <0.0, 0.119537, 4.303326>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Orange_js_LS_1
    }
    scale 3.174078
    rotate -90.0*x
    translate  <0.0, -1.505131, 4.306347>
  }
}
#declare LifesaverText1 = union {
  text {   // R11
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "R",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <-90.0, 42.269714, 180.0>
    translate  <1.171395, -0.105691, 3.216228>
  }

  text {   // E3
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <-90.0, 63.433746, 180.0>
    translate  <1.609972, -0.105691, 4.020286>
  }

  text {   // V1
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "V",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, 77.479691, -0.0>
    translate  <1.488145, -0.105691, 5.092362>
  }

  text {   // A1
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, 47.19276, 0.0>
    translate  <0.952107, -0.105691, 5.750227>
  }

  text {   // S1
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "S",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, 6.596345, 0.0>
    translate  <0.14805, -0.105691, 5.99388>
  }

  text {   // E1
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -24.920923, 0.0>
    translate  <-0.680373, -0.105691, 5.823323>
  }

  text {   // F1
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "F",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -37.422352, 0.0>
    translate  <-1.386969, -0.105691, 5.336015>
  }

  text {   // I1
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "I",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -55.238682, 0.0>
    translate  <-1.679353, -0.105691, 4.824343>
  }

  text {   // L1
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "L",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -83.328743, 0.0>
    translate  <-1.825545, -0.105691, 3.971555>
  }

  material {
    Orange_js_LS_1
  }
  translate  0.281842*y
}
#declare LifeSaver1 = union {
  object { CSG002 }
  object { LifesaverText1 }
  material {
    Orange_js_LS_1
  }
  scale 0.829442
  rotate 180.0*x
  translate  <0.055888, 16.240971, 3.470628>
}
#declare CSG001 = intersection {
  torus { // Sweetie
    1.3, 0.7  rotate -x*90
    sturm
    material {
      Pink_js_LS
    }
    scale <1.655304, 1.717221, 1.119537>
    rotate -90.0*x
    translate  <0.0, 0.119537, 4.303326>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Pink_js_LS
    }
    scale 3.174078
    rotate -90.0*x
    translate  <0.0, -1.505131, 4.306347>
  }
}
#declare LifesaverText = union {
  text {   // R
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "R",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <-90.0, 42.269714, 180.0>
    translate  <1.171395, -0.105691, 3.216228>
  }

  text {   // E2
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <-90.0, 63.433746, 180.0>
    translate  <1.609972, -0.105691, 4.020286>
  }

  text {   // V
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "V",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, 77.479691, -0.0>
    translate  <1.488145, -0.105691, 5.092362>
  }

  text {   // A
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, 47.19276, 0.0>
    translate  <0.952107, -0.105691, 5.750227>
  }

  text {   // S
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "S",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, 6.596345, 0.0>
    translate  <0.14805, -0.105691, 5.99388>
  }

  text {   // E
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -24.920923, 0.0>
    translate  <-0.680373, -0.105691, 5.823323>
  }

  text {   // F
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "F",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -37.422352, 0.0>
    translate  <-1.386969, -0.105691, 5.336015>
  }

  text {   // I
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "I",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -55.238682, 0.0>
    translate  <-1.679353, -0.105691, 4.824343>
  }

  text {   // L
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "L",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, -83.328743, 0.0>
    translate  <-1.825545, -0.105691, 3.971555>
  }

  material {
    Pink_js_LS
  }
  translate  0.281842*y
}
#declare LifeSaver = union {
  object { CSG001 }
  object { LifesaverText }
  scale 0.829442
  translate  <-0.019063, 2.487704, -3.64394>
}
#declare WheelAssembly = union {
  object { // Cone002->Cone001
    Cone001
    material {
      B_Silver
    }
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 16.866739, -0.0>
  }
  object { Cone001 }
  cylinder { // Axle
    <0,0,1>, <0,0,0>, 1 
    scale <0.675226, 0.719156, 18.456076>
    rotate -90.0*x
    translate  <-0.038922, -0.0, -0.233535>
  }
  object { LifeSaver1 }
  object { LifeSaver }
  material {
    EMBWood1
  }
  translate  <0.0, -0.122665, 4.5134>
}
#declare WorkersAnts = union {
  object { // Ant_group8->Ant_group9
    Ant_group9
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -2.688849, -0.0>
  }
  object { Ant_group9 }
  object { // puller2->Puller1
    Puller1
    material {
      T_Wood10
    }
    rotate <-0.0, -0.0, -5.905835>
    translate  <-0.25114, 2.296138, 0.0>
  }
  object { // NeckRing1->NeckRing2
    NeckRing2
    material {
      T_Wood10
    }
    rotate -0.0*z
    translate  <-0.035877, 2.726664, 0.0>
  }
  object { Puller1 }
  object { NeckRing2 }
  scale 2.804568
  translate  <-0.154812, 0.0, 1.238496>
}
union { // AntCart
  object { Matches }
  object { WheelAssembly }
  object { WorkersAnts }
  scale 0.356561
  rotate -39.362877*z
  translate  <-0.771253, -30.496817, 0.41185>
}


