#version unofficial MegaPov 0.7;    


#declare pearls =       
   texture  
   {   
          normal { bump_map { png "pearltex5.png" interpolate 2 bump_size 12 } rotate <55,55,55> scale 14 } 
          pigment { image_map { png "pearltex4.png" interpolate 2 } rotate <55,55,55> scale 14 }  
          finish { ambient 0.25 diffuse 0.4 brilliance 5  specular 40 roughness 0.09 }   
   }
   
#declare pearls2 =       
   texture  
   {   
          normal { bump_map { png "pearls2.png" interpolate 2 bump_size 10 } rotate <45,45,45> scale 20 } 
          pigment { image_map { png "pearls2.png" interpolate 2 } rotate <45,45,45> scale 20 }  
          finish { ambient 0.1 diffuse 0.4 }   
   }

#macro Shell_e (Ro, Nt, Rao, Rb, Na, Ho, Pxz, Dy)
  #declare Ra = pow(Rao,12/Nt);
  #declare Pne = 4*Nt*Nt;
  #declare Rt = pi*2/(Nt-0.5);
  #declare Yt = 2*pi/Nt/4/Nt;
  #macro Rs (P)
    0.85*Ro*pow(Ra,P)/Rb*(1+0.1*pow(sin(1.5*Rt*P+1.1*pi),2))
  #end
  #macro Rl (P)
    0.7*Ro*pow(Ra,P)
  #end
  #macro Hl (P)
    Ho*pow(Ra,P*P)
  #end
  #macro Ka (P)
    Dy*12*Yt*pow(P,0.9)
  #end
  #macro Triangle_units (P1,P2,P3)
    smooth_triangle { 
      <cos(Ka(P1))*(Rs(P1)*cos(Rt*P1)+Rl(P1)),
        (Rs(P1)*cos(Rt*P1)+Rl(P1))*sin(Ka(P1)), Pxz*Rs(P1)*sin(Rt*P1)+Hl(P1)>,
      <cos(Ka(P1))*cos(Rt*P1), sin(Ka(P1))*(1+0.05*sin(P1*30)), Pxz*sin(Rt*P1)*(1+0.05*cos(P1*30))>
      <cos(Ka(P2))*(Rs(P2)*cos(Rt*P2)+Rl(P2)),
        (Rs(P2)*cos(Rt*P2)+Rl(P2))*sin(Ka(P2)), Pxz*Rs(P2)*sin(Rt*P2)+Hl(P2)>,
      <cos(Ka(P2))*cos(Rt*P2), sin(Ka(P2))*(1+0.05*sin(P2*30)), Pxz*sin(Rt*P2)*(1+0.05*cos(P2*30))>
      <cos(Ka(P3))*( Rs(P3)*cos(Rt*P3)+Rl(P3)),
        (Rs(P3)*cos(Rt*P3)+Rl(P3))*sin(Ka(P3)), Pxz*Rs(P3)*sin(Rt*P3)+Hl(P3)>,
      <cos(Ka(P3))*cos(Rt*P3), sin(Ka(P3))*(1+0.05*sin(P3*30)), Pxz*sin(Rt*P3)*(1+0.05*cos(P3*30))>
        }
  #end                                                                                            
  union {
    #declare Pn =Nt+int(Nt/2);
    #while (Pn < Na*Pne-Nt)
      Triangle_units (Pn,Pn-1,Pn-Nt)
      Triangle_units (Pn,Pn-Nt+1,Pn-Nt)        
      #declare Pn =Pn +1;
    #end 
  }     
#end                                                      


#declare muschel = union {
                   object {Shell_e (10,72,0.988,1.2,0.2,1,1.00,-0.8) texture {pearls2 scale 0.3} scale 1.02 translate x*1.001 rotate z*188 }
                   object {Shell_e (10,72,0.988,1.2,0.2,1,1.00,-0.8) texture {pearls scale 0.3} translate x*1 rotate z*188 }             
                          scale z*1.3 rotate x*180 rotate y*(120+180) translate < -3.7,-3.7,-5> }



                   
