/*
 *	"Home, Sweet Home"
 *
 *  Created for the "Fortress" round of the IRTC
 *	Copyright 2001 Mark Wagner
 *
 *  Plates macro is by Jeff Lee
 *  Background forest is modified from the trees in the Genesis Toolkit
 *  Trees are made using Gilles Tran's Maketree macro
 *  Truck model is from the 3D Cafe collection
 */
 
// Render settings: +w800 +h400 +a0.3
// Render time: 1 hour, 7 minutes, 32 seconds

#declare included = true;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "skies.inc"

#declare cm = 1/2.54;	      /* 1 POV unit = 1 inch */
#include "units.inc"		  /* www.geocities.com/Rengaw03/Pov-Ray.html */


#include "plates.inc" /* Available from http://www.gate.net/~shipbrk/raytrace/plates.html */

#include "house.pov"

#macro Greyscale(Color)
    rgb (0.297*Color.red + 0.589*Color.green + 0.114*Color.blue)
#end

#include "country_grass2.inc" /* Modified version of TonyB's modifications to
                               * SamuelT's country_grass macro.  The original
                               * is available from news://news.povray.org/  
                               */

global_settings{assumed_gamma 1}

object{House translate <-30,0,-20>*feet}

/* Wall */
union{
	difference{
		cylinder{y*-20*feet, y*3.5*feet, 75*feet}
		cylinder{y*-21*feet, y*6*feet, 73*feet}
	}
	intersection{
		difference{
			cylinder{y*3*feet, y*4*feet, 75*feet}
			cylinder{y*2.9*feet, y*6*feet, 73*feet}
		}
		torus{74*feet, 3*feet translate y*1*feet}
	}
	#declare BricksTexture = MakeCylindricalPlates(
		75*feet, 5*feet, 2*feet, 2*inch, 
		texture{
			pigment{granite}
		},
		texture{
			pigment{rgb .8}
		}
	)
	translate y*0
	
	texture{
		BricksTexture
		translate y*-19.9*feet
	}
}

#declare Spike = union{
	intersection{
		union{
			cone{y*0,3*inch,y*2*feet, 0}
			sphere{0, 3*inch}
			cylinder{0*inch, y*-8*inch, 2*inch}
			translate x*-.25*inch+y*6*inch
		}
		union{
			cone{y*0,3*inch,y*2*feet, 0}
			sphere{0, 3*inch}
			cylinder{0*inch, y*-8*inch, 2*inch}
			translate x*.25*inch+y*6*inch
		}
	}
	texture{
		pigment {rgb <.4, .4, .45>} 
		normal {dents .6 scale .3} 
		finish {phong .3 phong_size 10 metallic}
		scale inch
	}
}

#declare Counter = 0;
#while(Counter < 360)
	object{Spike translate x*74.5*feet+y*4*feet rotate y*Counter}
	#declare Counter = Counter + 1;
#end

/* Ground */
union{
	intersection{
		sphere{y*-.1*mile, .1*mile}
		box{<-300,-20,-300>*feet,<300,0,300>*feet}
		cylinder{y*-30*feet,y*10*feet,74.5*feet}
		pigment{Jade}
	}
	difference{
		union{
			intersection{
				sphere{y*-.1*mile, .1*mile}
				box{<-300,-20,-300>*feet,<300,0,300>*feet}
				cylinder{y*-30*feet,y*10*feet,74.5*feet inverse}
				pigment{rgb .4}
			}
			plane {y, -20*feet pigment{rgb .4}}
		}
		torus{80*feet, 5*feet translate y*-8*feet pigment{rgb .3}}
	}
}

/* Driveway */
intersection{
	sphere{y*-.1*mile, .1*mile+6*inch}
	box{<10,0,-10>*feet,<32,-20,-80>*feet}
	pigment{rgb .5}
}

object{#include "toyota textured.pov" scale .30*foot rotate x*-5 translate z*-40*feet+x*17*feet+y*2.3*feet}

/* Background trees */
/* Trees based on those in the Genesis Toolkit
 *  <http://www.rhein-ruhr.de/~schrammel/index.htm>
 */
#declare Tann1 = object{
 cone{<0,0,0>,1,<0,1,0>,0 open
  texture{
   pigment{
    image_map{ png "tanne1.png" interpolate 2.0 transmit 1 1.0 }
    rotate<90,0,0>translate<0.5,0.5,0.5>scale<2,2,2>
   }
  }
 }
}
#declare Trunk = object{
   cone{<0,-10,0>,0.2,<0,10,0>,0}
   texture{
    pigment{ color rgb<0.501, 0.313, 0.184>} 
    normal{
     bumps 
     bump_size -2
     scale< .02, .1, .02>
    }
   }
}
#declare Tree1 = object{
 union{
  object{Trunk scale<1,0.9,1>}
  object{Tann1 scale<1.5,1,1.5> rotate<0,90,0>  translate<0,4.5,0>}
  object{Tann1 scale<2,2,2>     rotate<0,0,0>   translate<0,5,0>}
  object{Tann1 scale<2,2,2>     rotate<0,120,0> translate<0,6,0>}
  object{Tann1 scale<2,2,2>     rotate<0,180,0> translate<0,7,0>}
  object{Tann1 scale<1.5,1,1.5> rotate<0,90,0>  translate<0,8,0>}
 }
 scale <1,2,1>
 translate y*-8
}

// Trees in the yard, created using Gilles Tran's Maketree macros
#include "maketree\\\\txttree.inc"
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_1}
#declare Leaf=object{#include "gtleaf7.inc"} // declares the Leaf object
#declare GTTree=object{#include "gttree7.inc"
//        texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "gtfoliage7.inc"
        texture{txtLeaf} 
}
                                                     
union{
     object{GTTree}
     object{Foliage1}
     scale (20/70)*feet
     translate x*40*feet+z*-40*feet
}

union{
     object{GTTree}
     object{Foliage1}
     scale (20/70)*feet
     translate x*-40*feet
}



#declare VegeObject = plane{y, -20}
#declare VegeList = array[1]
#declare VegeList[0] = object{Tree1}
#declare VegeExcludeCircle = array[1][2]
#declare VegeExcludeCircle[0][0] = <0,0>;
#declare VegeExcludeCircle[0][1] = <85*feet,85*feet>;
#declare VegeExcludeBox = array[1][2]
#declare VegeExcludeBox[0][0] = <-20,-20>*feet;
#declare VegeExcludeBox[0][1] = <-100,-100>*feet;
#declare VegeMinBox = <-100,-100>*feet;
#declare VegeMaxBox = <200,200>*feet;
#declare VegeMinScale = 4.5*feet;
#declare VegeMaxScale = 6*feet;
#declare VegeSeed = seed(2);
#declare VegeNumber = 250;
//#declare Verbose = true;
#include "vegetate.inc" /* http://www.geocities.com/Rengaw03/Pov-Ray.html */

/* Grass */
/*
#declare Target = sphere{y*-.1*mile, .1*mile}
#declare xCounter = -74;
#while(xCounter < 74)
	#declare yCounter = -74;
	#while(yCounter < 74)
		#if((xCounter*xCounter)+(yCounter*yCounter) < 5625)
			#declare zHeight = trace(Target, y*100*feet+x*xCounter*feet+z*yCounter*feet, -y);
			object{GrassSquare translate zHeight pigment{rgb <0,1,0>}}
		#end
		#declare yCounter = yCounter + 1;
	#end
	#declare xCounter = xCounter + 1;
#end*/

/* Grass outside the wall */
//country_grass(1, <0,0>,<75*feet,4*inch>,5*foot,50,150,360,360,1*mile,sphere{y*-.1*mile, .1*mile},360,pigment{bozo})
/* Sky */
sky_sphere{
	pigment{
		gradient y
		color_map{
			[0.5 Greyscale(SummerSky)]
			[1.0 Greyscale(NewMidnightBlue)]
		}
		scale 2
		translate -1
	}
}

sphere{
	y*-7950*mile, 7953*mile
	texture{T_Cloud3 scale 5*mile}
	hollow
}

light_source{vnormalize(<-.15,1,-1>)*50*miles, rgb 1}
light_source{vnormalize(<-1,.5,0>)*60*feet, rgb .05 shadowless}


#declare GroundView = camera{
	location vnormalize(<-1,.12,-1>)*90*feet
	look_at 0
}

#declare WideAngle = camera{
	ultra_wide_angle
	angle 105
	up y
	right 2*x
	location vnormalize(<-1,.12,-1>)*90*feet
	look_at 0
}

#declare TopView = camera{
	location y*1*mile
	look_at 0
	angle 4
}

camera{WideAngle}


