//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 19 materials and 159 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/22/2001    (22.04.2001)
//
#version unofficial MegaPov 0.7;

#include "colors.inc"

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  ambient_light 2
  radiosity {
    brightness       2 //3.3
    count            300  //100
    distance_maximum 0.1 //0.0
    error_bound      0.2  //0.4
    gray_threshold   0.1  //0.5
    low_error_factor 0.5  //0.8
    minimum_reuse    0.001  //0.015
    nearest_count    6
    recursion_limit  1 
  }
}

background { color <0.000,0.000,0.000> }

camera {location <30, 25, -50> look_at <0,3,0> } 
//camera {location <30, 15, -50> look_at <0,3,0> } 
//camera {location <65.7, 36, -36> look_at <-7.5,1.2,-.6> }
/*
camera {  //  Camera StdCam
  location  <    -65.700,      -90.900,      35.800>
  //location  <     65.700,      90.900,      35.800>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.36123,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         42.10526    // Vertical      31.579
  look_at   <     -7.400,       0.600,       1.200>
}  */

//
// ********  MATERIALS  *******
//

#include "main_base.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare the_sun =
pigment {
gradient y
color_map {
[0.000 color rgbt 1.5*<1, .95, .9, 0>]
[0.0003 color rgbt 1.5*<1, .95, .9, .1>]
[0.0005 color rgbt <1, 1, 0.9, .2>]
[0.05 color rgbt <.7, .6, .5, .2>]
[0.1 color rgbt <.7, .6, .5, .5>]
[1 color rgbt <1, 1, 1, 1>]
}
scale 2
translate -1
rotate -100*x
}

//Light Source               
light_source {<300, 1000, 500> color rgb <1, .997, .97> }

#declare the_gradient =
pigment {
gradient y
color_map {
[0 color rgbt <.07, .06, .65, .2>]
[1 color rgb <0.2, 0.2, 1.0>]
}
}

#declare cloud_layer =
pigment {
wrinkles
turbulence .5
octaves 6
lambda 6 //3 to 6
omega 0.6 //0.2 to 0.6
color_map {
[0 color rgbt <1, 1, 1, 1>]
[0.5 color rgbt <0.98, 0.99, 0.99, .8>]
[1 color rgbt <1, 1, 1, 1>]
}
scale <.8, .1, .8>
}

sky_sphere {
pigment {the_gradient}
pigment {the_sun}
pigment {cloud_layer}
}

//cloud plane 1
//uses gradient z and pigment_map to make clouds redder towards horizon

#declare red_hue =
pigment {
wrinkles
turbulence .4
lambda 4
octaves 3
omega .7
color_map {
[0 color rgbt <1,1,1, 1>]
[.2 color rgbt <1,1,1, 1>]
[.5 color rgbt 1.5*<1, .4, .4, .4>]
[.8 color rgbt <1,1,1, 1>]
[1 color rgbt <1,1,1, 1>]
}
}

#declare lighter_hue =
pigment {
quilted
turbulence .4
lambda 4
octaves 3
omega .7
color_map {
[0 color rgbt <1,1,1, 1>]
[.2 color rgbt <1,1,1, 1>]
[.5 color rgbt <1, .3, .97, 1>]
[.8 color rgbt <1,1,1, 1>]
[1 color rgbt <1,1,1, 1>]
}
}

//cloud layer 2

plane {-y,-1200
texture {
pigment {
bozo
turbulence .05
omega .7
color_map {
[0 color rgbt <.8, .8, .8, 1>]
[.5 color rgbft <1,.85, .79, .5, .6>]
[1 color rgbt <1,.85,.79, 1>]}}
finish {ambient 1 diffuse .5}
scale 2000
translate <1500,900,-2000>}
hollow
}

// Cloud plane 3
plane { y, 300.0
hollow on
pigment {
bozo
omega .5
lambda 5
octaves 6
turbulence 0.5
color_map {
[0.0 0.6 color rgbf <1, 1, 1, 1>
color rgbf <1, 1, 1, 1>]
[0.6 0.8 color rgbf <1, 1, 1, 1>
color rgb <1, .9, .8>]
[0.8 1.001 color rgb <1, .9, .8>
color rgb <1, 1, .9>]
}
//quick_color rgb <.8, .4, .2>
scale <1000.0, 200.0, 800.0>
}
finish {
ambient 1
diffuse 0.0
}

translate -450*x
rotate 6*y
}

fog {
distance 2000
colour rgbt<0.6, 0.6, .6, .66>
fog_type 2
fog_offset 1
fog_alt 10
}

fog {
distance 2000
colour rgbt<0.6, 0.62, .6, .66>
fog_type 2
fog_offset 20
fog_alt 10
turbulence 0.2
turb_depth 0.2
}

fog {
distance 2000
color rgbt <.68,.7,.68, .66>
fog_type 2
fog_offset 40
fog_alt 20
turbulence 0.1
turb_depth 0.2
}

//
// ********  OBJECTS  *******
//

union {

#include "C:\Cads\Rhinoceros\v2\objects\Fortress\rocketsmesh.inc"

#declare Default_ducts2_Ref = object {
  Default_ducts
  material {
    WrinkleGray
  }
}
#declare Default_control_box2_Ref = object {
  Default_control_box
  material {
    ocean_color
  }
}
#declare Default_box_legs5_Ref = object {
  Default_box_legs
  material {
    Rust1
  }
}
#declare Default_rocket_box5_Ref = object {
  Default_rocket_box
  material {
    Tx_3
  }
}
#declare Default_rocket_covers5_Ref = object {
  Default_rocket_covers
  material {
    Tx_1
  }
}
union { // UserDefGroup53
  object { Default_ducts2_Ref }
  object { Default_control_box2_Ref }
  object { Default_box_legs5_Ref }
  object { Default_rocket_box5_Ref }
  object { Default_rocket_covers5_Ref }
  rotate 90.0*z
  translate  <16.9, -4.4, 3.0>
}


#declare Default_ducts1_Ref = object {
  Default_ducts
  material {
    WrinkleGray
  }
}
#declare Default_control_box1_Ref = object {
  Default_control_box
  material {
    ocean_color
  }
}
#declare Default_box_legs4_Ref = object {
  Default_box_legs
  material {
    Rust1
  }
}
#declare Default_rocket_box4_Ref = object {
  Default_rocket_box
  material {
    Tx_3
  }
}
#declare Default_rocket_covers4_Ref = object {
  Default_rocket_covers
  material {
    Tx_1
  }
}
union { // UserDefGroup52
  object { Default_ducts1_Ref }
  object { Default_control_box1_Ref }
  object { Default_box_legs4_Ref }
  object { Default_rocket_box4_Ref }
  object { Default_rocket_covers4_Ref }
  rotate -90.0*z
  translate  <-16.1, 0, 3.0>
}


#declare Default_ducts_Ref = object {
  Default_ducts
  material {
    WrinkleGray
  }
}
#declare Default_control_box_Ref = object {
  Default_control_box
  material {
    ocean_color
  }
}
#declare Default_box_legs3_Ref = object {
  Default_box_legs
  material {
    Rust1
  }
}
#declare Default_rocket_box3_Ref = object {
  Default_rocket_box
  material {
    Tx_3
  }
}
#declare Default_rocket_covers3_Ref = object {
  Default_rocket_covers
  material {
    Tx_1
  }
}
union { // UserDefGroup51
  object { Default_ducts_Ref }
  object { Default_control_box_Ref }
  object { Default_box_legs3_Ref }
  object { Default_rocket_box3_Ref }
  object { Default_rocket_covers3_Ref }
  translate  <0, -16.7, 3.0>
}

#include "C:\Cads\Rhinoceros\v2\objects\Fortress\rubber_boatmesh.inc"

#declare Default_boat_transom_Ref = object {
  Default_boat_transom
  material {
    BallWood
  }
}
#declare Default_boat_ropes_Ref = object {
  Default_boat_ropes
  material {
    DryGrass
  }
}
#declare Default_boat_bottom_Ref = object {
  Default_boat_bottom
  material {
    DGray
  }
}
#declare Default_boat_seats_Ref = object {
  Default_boat_seats
  material {
    BallWood
  }
}
#declare Default_boat_hull_Ref = object {
  Default_boat_hull
  material {
    DGray
  }
}
union { // UserDefGroup50
  object { Default_boat_ropes_Ref }
  union {
  object { Default_boat_transom_Ref }
  object { Default_boat_bottom_Ref }
  object { Default_boat_seats_Ref }
  object { Default_boat_hull_Ref }
  translate <0,0,0.2>
        }
  scale <-1.0, 1.0, 1.0>
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\cannons.inc"

#declare Layer_01_Right_Barrel_Ref = object {
  Layer_01_Right_Barrel
  material {
    Rust1
  }
}
#declare Layer_01_Left_Barrel_Ref = object {
  Layer_01_Left_Barrel
  material {
    Rust1
  }
}
#declare Default_Cannon_spacers_Ref = object {
  Default_Cannon_spacers
  material {
    Tx_3
  }
}
#declare Default_Cannon_actuator1_Ref = object {
  Default_Cannon_actuator1
  material {
    Brushed_Aluminum
  }
}
#declare Default_Cannon_actuator2_Ref = object {
  Default_Cannon_actuator2
  material {
    Brushed_Aluminum
  }
}
#declare Default_Cannon_support2_Ref = object {
  Default_Cannon_support2
  material {
    Tx_3
  }
}
#declare Default_Cannon_support1_Ref = object {
  Default_Cannon_support1
  material {
    Tx_3
  }
}
#declare Layer_01_Cannon_base_Ref = object {
  Layer_01_Cannon_base
  material {
    RoughStone
  }
}
#declare Default_Cannon_pin_Ref = object {
  Default_Cannon_pin
  material {
    Brushed_Aluminum
  }
}
#declare Default_Cannon_loader1_Ref = object {
  Default_Cannon_loader1
  material {
    Tx_3
  }
}
#declare Default_Cannon_loader2_Ref = object {
  Default_Cannon_loader2
  material {
    Tx_3
  }
}
#declare Default_Cannon_antenna_Ref = object {
  Default_Cannon_antenna
  material {
    Rust1
  }
}
#declare Default_Cannon_axel_Ref = object {
  Default_Cannon_axel
  material {
    Brushed_Aluminum
  }
}
#declare Default_Cannon_actuator3_Ref = object {
  Default_Cannon_actuator1
  scale <1,-1,1>
  material {
    Brushed_Aluminum
  }
}
#declare Default_Cannon_actuator4_Ref = object {
  Default_Cannon_actuator2
  scale <1,-1,1>
  material {
    Brushed_Aluminum
  }
}
#declare Default_Cannon_spacers1_Ref = object {
  Default_Cannon_spacers
  scale <1,-1,1>
  material {
    Tx_3
  }
}
union { // UserDefGroup48
  object { Layer_01_Right_Barrel_Ref }
  object { Layer_01_Left_Barrel_Ref }
  object { Default_Cannon_spacers_Ref }
  object { Default_Cannon_actuator1_Ref }
  object { Default_Cannon_actuator2_Ref }
  object { Default_Cannon_support2_Ref }
  object { Default_Cannon_support1_Ref }
  object { Layer_01_Cannon_base_Ref }
  object { Default_Cannon_pin_Ref }
  object { Default_Cannon_loader1_Ref }
  object { Default_Cannon_loader2_Ref }
  object { Default_Cannon_antenna_Ref }
  object { Default_Cannon_axel_Ref }
  object { Default_Cannon_actuator3_Ref }
  object { Default_Cannon_actuator4_Ref }
  object { Default_Cannon_spacers1_Ref }
  rotate -15.0*z
  translate  <-25.0, 25.1, 3.0>
}
union { // UserDefGroup48a
  object { Layer_01_Right_Barrel_Ref }
  object { Layer_01_Left_Barrel_Ref }
  object { Default_Cannon_spacers_Ref }
  object { Default_Cannon_actuator1_Ref }
  object { Default_Cannon_actuator2_Ref }
  object { Default_Cannon_support2_Ref }
  object { Default_Cannon_support1_Ref }
  object { Layer_01_Cannon_base_Ref }
  object { Default_Cannon_pin_Ref }
  object { Default_Cannon_loader1_Ref }
  object { Default_Cannon_loader2_Ref }
  object { Default_Cannon_antenna_Ref }
  object { Default_Cannon_axel_Ref }
  object { Default_Cannon_actuator3_Ref }
  object { Default_Cannon_actuator4_Ref }
  object { Default_Cannon_spacers1_Ref }
  rotate 230.0*z
  translate  <25.0, -25.1, 3.0>
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\railingmesh.inc"

object {
  Layer_03_main_railing
  material {
    Tx_3
  }
}

#include "C:\Cads\Rhinoceros\v2\objects\Fortress\misc2_itemsmesh.inc"

#declare Default_Barrels_group_Ref = object {
  Default_Barrels_group
  material {
    WrinkleGray
  }
}
#declare Default_lg_crate_Ref = object {
  Default_lg_crate
  material {
    T_Wood35
  }
}
#declare Default_sm_crate2_Ref = object {
  Default_sm_crate2
  material {
    BallWood
  }
}
#declare Default_sm_crate3_Ref = object {
  Default_sm_crate3
  material {
    BallWood
  }
}
#declare Default_sm_crate1_Ref = object {
  Default_sm_crate1
  material {
    BallWood
  }
}
#declare Default_lg_container_Ref = object {
  Default_lg_container
  material {
    Tx_1
  }
}
#declare Default_std_cylinders_Ref = object {
  Default_std_cylinders
  material {
    WrinkleGray
  }
}
#declare Default_loose_barrel1_Ref = object {
  Default_loose_barrel1
  material {
    WrinkleGray
  }
}
union { // UserDefGroup47
  object { Default_Barrels_group_Ref }
  object { Default_lg_crate_Ref }
  object { Default_sm_crate2_Ref }
  object { Default_sm_crate3_Ref }
  object { Default_sm_crate1_Ref }
  object { Default_lg_container_Ref }
  object { Default_std_cylinders_Ref }
  object { Default_loose_barrel1_Ref }
translate <0,-7,0>
}





#include "C:\Cads\Rhinoceros\v2\objects\Fortress\wire_fencemesh.inc"

#declare Base_Posts32_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh32_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup46
  object { Base_Posts32_Ref }
  object { Base_wire_mesh32_Ref }
  rotate -90.0*z
  translate  <-0.0, -51.9, 0.5>
}


#declare Base_Posts31_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh31_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup45
  object { Base_Posts31_Ref }
  object { Base_wire_mesh31_Ref }
  rotate -90.0*z
  translate  <7.6, -52.9, 0.5>
}


#declare Base_Posts30_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh30_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup44
  object { Base_Posts30_Ref }
  object { Base_wire_mesh30_Ref }
  rotate -90.0*z
  translate  <-7.0, -53.7, 0.5>
}


#declare Base_Posts29_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh29_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup43
  object { Base_Posts29_Ref }
  object { Base_wire_mesh29_Ref }
  rotate -90.0*z
  translate  <14.1, -51.6, 0.5>
}


#declare Base_Posts28_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh28_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup42
  object { Base_Posts28_Ref }
  object { Base_wire_mesh28_Ref }
  rotate -90.0*z
  translate  <-14.2, -51.7, 0.5>
}


#declare Base_Posts27_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh27_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup41
  object { Base_Posts27_Ref }
  object { Base_wire_mesh27_Ref }
  rotate -80.0*z
  translate  <22.0, -51.3, 0.5>
}


#declare Base_Posts26_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh26_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup40
  object { Base_Posts26_Ref }
  object { Base_wire_mesh26_Ref }
  rotate -90.0*z
  translate  <-21.6, -52.8, 0.5>
}


#declare Base_Posts25_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh25_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup39
  object { Base_Posts25_Ref }
  object { Base_wire_mesh25_Ref }
  rotate -100.0*z
  translate  <-28.9, -51.0, 0.5>
}


#declare Base_Posts24_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh24_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup38
  object { Base_Posts24_Ref }
  object { Base_wire_mesh24_Ref }
  rotate -110.0*z
  translate  <-34.9, -47.4, 0.5>
}


#declare Base_Posts23_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh23_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup37
  object { Base_Posts23_Ref }
  object { Base_wire_mesh23_Ref }
  rotate -70.0*z
  translate  <30.7, -49.5, 0.5>
}


#declare Base_Posts22_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh22_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup36
  object { Base_Posts22_Ref }
  object { Base_wire_mesh22_Ref }
  rotate -135.0*z
  translate  <-41.1, -42.6, 0.5>
}


#declare Base_Posts21_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh21_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup35
  object { Base_Posts21_Ref }
  object { Base_wire_mesh21_Ref }
  rotate 180.0*z
  translate  <-53.2, -1.7, 0.5>
}


#declare Base_Posts20_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh20_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup34
  object { Base_Posts20_Ref }
  object { Base_wire_mesh20_Ref }
  rotate 180.0*z
  translate  <-54.2, -9.3, 0.5>
}


#declare Base_Posts19_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh19_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup33
  object { Base_Posts19_Ref }
  object { Base_wire_mesh19_Ref }
  rotate 180.0*z
  translate  <-55.0, 5.3, 0.5>
}


#declare Base_Posts18_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh18_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup32
  object { Base_Posts18_Ref }
  object { Base_wire_mesh18_Ref }
  rotate 180.0*z
  translate  <-52.9, -15.8, 0.5>
}


#declare Base_Posts17_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh17_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup31
  object { Base_Posts17_Ref }
  object { Base_wire_mesh17_Ref }
  rotate 180.0*z
  translate  <-53.0, 12.5, 0.5>
}


#declare Base_Posts16_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh16_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup30
  object { Base_Posts16_Ref }
  object { Base_wire_mesh16_Ref }
  rotate -170.0*z
  translate  <-52.6, -23.7, 0.5>
}


#declare Base_Posts15_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh15_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup29
  object { Base_Posts15_Ref }
  object { Base_wire_mesh15_Ref }
  rotate 180.0*z
  translate  <-54.1, 19.9, 0.5>
}


#declare Base_Posts14_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh14_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup28
  object { Base_Posts14_Ref }
  object { Base_wire_mesh14_Ref }
  rotate 170.0*z
  translate  <-52.3, 27.2, 0.5>
}


#declare Base_Posts13_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh13_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup27
  object { Base_Posts13_Ref }
  object { Base_wire_mesh13_Ref }
  rotate 160.0*z
  translate  <-48.7, 33.2, 0.5>
}


#declare Base_Posts12_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh12_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup26
  object { Base_Posts12_Ref }
  object { Base_wire_mesh12_Ref }
  rotate -160.0*z
  translate  <-50.8, -32.4, 0.5>
}


#declare Base_Posts11_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh11_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup25
  object { Base_Posts11_Ref }
  object { Base_wire_mesh11_Ref }
  rotate 135.0*z
  translate  <-43.9, 39.4, 0.5>
}


#declare Base_Posts_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup14
  object { Base_Posts_Ref }
  object { Base_wire_mesh_Ref }
  translate  <52.3, 1.4, 0.5>
}


#declare Base_Posts1_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh1_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup15
  object { Base_Posts1_Ref }
  object { Base_wire_mesh1_Ref }
  translate  <53.3, 9.0, 0.5>
}


#declare Base_Posts2_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh2_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup16
  object { Base_Posts2_Ref }
  object { Base_wire_mesh2_Ref }
  translate  <54.1, -5.6, 0.5>
}


#declare Base_Posts3_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh3_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup17
  object { Base_Posts3_Ref }
  object { Base_wire_mesh3_Ref }
  translate  <52.0, 15.5, 0.5>
}


#declare Base_Posts4_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh4_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup18
  object { Base_Posts4_Ref }
  object { Base_wire_mesh4_Ref }
  translate  <52.1, -12.8, 0.5>
}


#declare Base_Posts5_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh5_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup19
  object { Base_Posts5_Ref }
  object { Base_wire_mesh5_Ref }
  rotate 10.0*z
  translate  <51.7, 23.4, 0.5>
}


#declare Base_Posts6_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh6_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup20
  object { Base_Posts6_Ref }
  object { Base_wire_mesh6_Ref }
  translate  <53.2, -20.2, 0.5>
}


#declare Base_Posts7_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh7_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup21
  object { Base_Posts7_Ref }
  object { Base_wire_mesh7_Ref }
  rotate -10.0*z
  translate  <51.4, -27.5, 0.5>
}


#declare Base_Posts8_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh8_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup22
  object { Base_Posts8_Ref }
  object { Base_wire_mesh8_Ref }
  rotate -20.0*z
  translate  <47.8, -33.5, 0.5>
}


#declare Base_Posts9_Ref = object {
  Base_Posts
  material {
    Rust1
  }
}
#declare Base_wire_mesh9_Ref = object {
  Base_wire_mesh
  material {
    Rust1
  }
}
union { // UserDefGroup23
  object { Base_Posts9_Ref }
  object { Base_wire_mesh9_Ref }
  rotate 20.0*z
  translate  <49.9, 32.1, 0.5>
}




#include "C:\Cads\Rhinoceros\v2\objects\Fortress\trailermesh.inc"

#declare radar_satellite_ant_Ref = object {
  radar_satellite_ant
  material {
    DryGrass
  }
}
#declare Default_com_ant_Ref = object {
  Default_com_ant
  material {
    Rust1
  }
}
#declare Default_com_ant_base_Ref = object {
  Default_com_ant_base
  material {
    Brushed_Aluminum
  }
}
#declare Default_trailer_Ref = object {
  Default_trailer
  material {
    Tx_3
  }
}
#declare Default_trailer_doors_Ref = object {
  Default_trailer_doors
  material {
    Rusty_Iron1
  }
}
#declare Default_handles_Ref = object {
  Default_handles
  material {
    Candelar_Text
  }
}
union { // UserDefGroup13
  object { radar_satellite_ant_Ref }
  object { Default_com_ant_Ref }
  object { Default_com_ant_base_Ref }
  object { Default_trailer_Ref }
  object { Default_trailer_doors_Ref }
  object { Default_handles_Ref }
  scale 1.5
  rotate -155.0*z
  translate  <-8.0, 18.1, 3.0>
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\boxesmesh.inc"

#declare Default_small_box5_Ref = object {
  Default_small_box5
  material {
    T_Wood35
  }
}
#declare Default_small_box4_Ref = object {
  Default_small_box4
  material {
    T_Wood35
  }
}
#declare Default_cylinders1_Ref = object {
  Default_cylinders1
  material {
    WrinkleGray
  }
}
#declare Default_small_box3_Ref = object {
  Default_small_box3
  material {
    T_Wood35
  }
}
#declare Default_small_box2_Ref = object {
  Default_small_box2
  material {
    T_Wood35
  }
}
#declare Default_small_box1_Ref = object {
  Default_small_box1
  material {
    T_Wood35
  }
}
#declare Default_box3_Ref = object {
  Default_box3
  material {
    BallWood
  }
}
#declare Default_box2_Ref = object {
  Default_box2
  material {
    BallWood
  }
}
#declare Default_box1_Ref = object {
  Default_box1
  material {
    BallWood
  }
}
union { // UserDefGroup12
  object { Default_small_box5_Ref }
  object { Default_small_box4_Ref }
  object { Default_cylinders1_Ref }
  object { Default_small_box3_Ref }
  object { Default_small_box2_Ref }
  object { Default_small_box1_Ref }
  object { Default_box3_Ref }
  object { Default_box2_Ref }
  object { Default_box1_Ref }
  rotate -35.0*z
  translate  <5.7, 17.3, 3.0>
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\laddersmesh.inc"

#declare ladders_ladder6_Ref = object {
  ladders_ladder6
  material {
    Rust1
  }
}
#declare ladders_ladder5_Ref = object {
  ladders_ladder5
  material {
    Rust1
  }
}
#declare ladders_ladder4_Ref = object {
  ladders_ladder4
  material {
    Rust1
  }
}
#declare ladders_ladder3_Ref = object {
  ladders_ladder3
  material {
    Rust1
  }
}
#declare ladders_ladder2_Ref = object {
  ladders_ladder2
  material {
    Rust1
  }
}
#declare ladders_ladder1_Ref = object {
  ladders_ladder1
  material {
    Rust1
  }
}
#declare ladders_tie_down1_Ref = object {
  ladders_tie_down1
  material {
    Rusty_Iron1
  }
}
#declare ladders_tie_down2_Ref = object {
  ladders_tie_down2
  material {
    Rusty_Iron1
  }
}
#declare ladders_tie_down3_Ref = object {
  ladders_tie_down3
  material {
    Rusty_Iron1
  }
}
#declare ladders_tie_down4_Ref = object {
  ladders_tie_down4
  material {
    Rusty_Iron1
  }
}
#declare ladders_tie_down5_Ref = object {
  ladders_tie_down5
  material {
    Rusty_Iron1
  }
}
#declare ladders_tie_down6_Ref = object {
  ladders_tie_down6
  material {
    Rusty_Iron1
  }
}
#declare ladders_tie_down7_Ref = object {
  ladders_tie_down7
  material {
    Rusty_Iron1
  }
}
#declare ladders_tie_down8_Ref = object {
  ladders_tie_down8
  material {
    Rusty_Iron1
  }
}
union { // UserDefGroup11
  object { ladders_ladder6_Ref }
  object { ladders_ladder5_Ref }
  object { ladders_ladder4_Ref }
  object { ladders_ladder3_Ref }
  object { ladders_ladder2_Ref }
  object { ladders_ladder1_Ref }
  object { ladders_tie_down1_Ref }
  object { ladders_tie_down2_Ref }
  object { ladders_tie_down3_Ref }
  object { ladders_tie_down4_Ref }
  object { ladders_tie_down5_Ref }
  object { ladders_tie_down6_Ref }
  object { ladders_tie_down7_Ref }
  object { ladders_tie_down8_Ref }
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\barrelsmesh.inc"

#declare Default_barrel9_Ref = object {
  Default_barrel4
  material {
    WrinkleGray
  }
}
#declare Default_barrel10_Ref = object {
  Default_barrel3
  material {
    WrinkleGray
  }
}
#declare Default_barrel11_Ref = object {
  Default_barrel2
  material {
    WrinkleGray
  }
}
#declare Default_barrel12_Ref = object {
  Default_barrel1
  material {
    WrinkleGray
  }
}
union { // UserDefGroup10
  object { Default_barrel9_Ref }
  object { Default_barrel10_Ref }
  object { Default_barrel11_Ref }
  object { Default_barrel12_Ref }
  translate  <2.4, -15.5, 3.0>
}


#declare Default_barrel5_Ref = object {
  Default_barrel4
  material {
    WrinkleGray
  }
}
#declare Default_barrel6_Ref = object {
  Default_barrel3
  material {
    WrinkleGray
  }
}
#declare Default_barrel7_Ref = object {
  Default_barrel2
  material {
    WrinkleGray
  }
}
#declare Default_barrel8_Ref = object {
  Default_barrel1
  material {
    WrinkleGray
  }
}
union { // UserDefGroup9
  object { Default_barrel5_Ref }
  object { Default_barrel6_Ref }
  object { Default_barrel7_Ref }
  object { Default_barrel8_Ref }
  rotate 10.0*z
  translate  <13.7, 11.0, 3.0>
}


#declare Default_barrel4_Ref = object {
  Default_barrel4
  material {
    WrinkleGray
  }
}
#declare Default_barrel3_Ref = object {
  Default_barrel3
  material {
    WrinkleGray
  }
}
#declare Default_barrel2_Ref = object {
  Default_barrel2
  material {
    WrinkleGray
  }
}
#declare Default_barrel1_Ref = object {
  Default_barrel1
  material {
    WrinkleGray
  }
}
union { // UserDefGroup8
  object { Default_barrel4_Ref }
  object { Default_barrel3_Ref }
  object { Default_barrel2_Ref }
  object { Default_barrel1_Ref }
  translate  <15.0, 9.0, 3.0>
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\gatling_gunmesh.inc"

#declare Default_barrels2_Ref = object {
  Default_barrels2
  material {
    WrinkleGray
  }
}
#declare Default_housing2_Ref = object {
  Default_housing2
  material {
    Tx_3
  }
}
#declare Default_barrels_Ref = object {
  Default_barrels
  material {
    WrinkleGray
  }
}
#declare Layer_02_gatbase_Ref = object {
  Layer_02_gatbase
  material {
    RoughStone
  }
}
#declare Layer_02_antennne_Ref = object {
  Layer_02_antennne
  material {
    Tx_3
  }
}
#declare Layer_02_box1_Ref = object {
  Layer_02_box1
  material {
    Brushed_Aluminum
  }
}
#declare Layer_02_pivot_Ref = object {
  Layer_02_pivot
  material {
    Candelar_Text
  }
}
#declare Default_housing_Ref = object {
  Default_housing
  material {
    Tx_3
  }
}
union { // UserDefGroup6
  object { Default_barrels2_Ref }
  object { Default_housing2_Ref }
  object { Default_barrels_Ref }
  object { Layer_02_gatbase_Ref }
  object { Layer_02_antennne_Ref }
  object { Layer_02_box1_Ref }
  object { Layer_02_pivot_Ref }
  object { Default_housing_Ref }
  rotate -250.0*z
  translate  <25.7, 26.3, 3.0>
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\wiremesh.inc"

object {
  Layer_04_barbed_wire
  material {
    BumpMetal
  }
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\supportmesh.inc"

object {
  Layer_03_support_posts
  material {
    Rust1
  }
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\small_radarmesh2.inc"

#declare radar_small_support1_Ref = object {
  radar_small_support
  material {
    Tx_3
  }
}
#declare radar_small_dish1_Ref = object {
  radar_small_dish
  material {
    Tx_3
  }
}
#declare radar_small_receiver1_Ref = object {
  radar_small_receiver
  material {
    Brushed_Aluminum
  }
}
#declare radar_small_pole1_Ref = object {
  radar_small_pole
  material {
    Candelar_Text
  }
}
#declare radar_small_anchor1_Ref = object {
  radar_small_anchor
  material {
    Brushed_Aluminum
  }
}
#declare radar_small_base1_Ref = object {
  radar_small_base
  material {
    Tx_3
  }
}
union { // UserDefGroup5
  object { radar_small_support1_Ref }
  object { radar_small_dish1_Ref }
  object { radar_small_receiver1_Ref }
  object { radar_small_pole1_Ref }
  object { radar_small_anchor1_Ref }
  object { radar_small_base1_Ref }
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\small_radarmesh1.inc"

#declare radar_small_dish_Ref = object {
  radar_small_dish
  material {
    Tx_3
  }
}
#declare radar_small_receiver_Ref = object {
  radar_small_receiver
  material {
    Brushed_Aluminum
  }
}
#declare radar_small_pole_Ref = object {
  radar_small_pole
  material {
    Candelar_Text
  }
}
#declare radar_small_base_Ref = object {
  radar_small_base
  material {
    Tx_3
  }
}
#declare radar_small_support_Ref = object {
  radar_small_support
  material {
    Tx_3
  }
}
#declare radar_small_anchor_Ref = object {
  radar_small_anchor
  material {
    Brushed_Aluminum
  }
}
union { // UserDefGroup3
  object { radar_small_dish_Ref }
  object { radar_small_receiver_Ref }
  object { radar_small_pole_Ref }
  object { radar_small_base_Ref }
  object { radar_small_support_Ref }
  object { radar_small_anchor_Ref }
}

//Water
height_field 
 { tga "c:\cads\water3.tga"
   smooth 
   scale <500,2.0,500>
   translate <-250,1,-250>
   pigment {color rgbf <1, 1, 1, 1>} 
   finish {phong 1 phong_size 90 diffuse 0 
   conserve_energy
   reflection_min .1
   reflection_max .9
   reflection_falloff 2
    }
  
   normal {ripples scale 3000 frequency 3000}

   interior { 
   ior 1.33
   media {
   absorption <.1, .05, .05>
   samples 2, 2
   }
   }
   hollow
   //} 
   rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
   scale     <  1, 1,-1> // Scale to Cube size. Now points along +Z   
   }

//water color plane
  polygon { 5, <-250, 250>, <250, 250>, <250, -250>, <-250, -250>, <-250, 250> 
  pigment {color 0.4*Blue}
  scale <1,-1,1>
  translate <0,-10,0>
  }

#include "C:\Cads\Rhinoceros\v2\objects\Fortress\basemesh.inc"

#declare radar_base_support_Ref = object {
  radar_base_support
  material {
    RoughStone
  }
}
#declare radar_base_base_Ref = object {
  radar_base_base
  material {
    RoughStone
  }
}
#declare radar_base_door1_Ref = object {
  radar_base_door1
  material {
    Tx_3
  }
}
#declare radar_base_door2_Ref = object {
  radar_base_door2
  material {
    Tx_3
  }
}
#declare radar_base_door3_Ref = object {
  radar_base_door3
  material {
    Tx_3
  }
}
union { // UserDefGroup4
  object { radar_base_support_Ref }
  object { radar_base_base_Ref }
  object { radar_base_door1_Ref }
  object { radar_base_door2_Ref }
  object { radar_base_door3_Ref }
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\helipadmesh.inc"

#declare Layer_02_Object1_Ref = object {
  Layer_02_Object1
  material {
    RoughStone
  }
}
#declare Layer_02_interior_surface_Ref = object {
  Layer_02_interior_surface
  texture { Stone8 }
}    
union { // UserDefGroup2
  object { Layer_02_Object1_Ref }
  object { Layer_02_interior_surface_Ref }
}


#include "C:\Cads\Rhinoceros\v2\objects\Fortress\main_radarmesh.inc"

#declare radar_truss_Ref = object {
  radar_truss
  material {
    Tx_3
  }
  rotate 15.0*z
}
#declare radar_support_Ref = object {
  radar_support
  material {
    Rust1
  }
  rotate 15.0*z
}
#declare radar_dish_Ref = object {
  radar_dish
  material {
    Tx_3
  }
  rotate 15.0*z
}
#declare radar_receiver_Ref = object {
  radar_receiver
  material {
    Brushed_Aluminum
  }
  rotate 15.0*z
}
#declare radar_support_rods_Ref = object {
  radar_support_rods
  material {
    Candelar_Text
  }
  rotate 15.0*z
}
union { // UserDefGroup1
  object { radar_truss_Ref }
  object { radar_support_Ref }
  object { radar_dish_Ref }
  object { radar_receiver_Ref }
  object { radar_support_rods_Ref }
}




#declare Default_barrels3_Ref = object {
  Default_barrels2
  material {
    DryGrass
  }
}
#declare Default_housing3_Ref = object {
  Default_housing2
  material {
    Tx_3
  }
}
#declare Default_barrels1_Ref = object {
  Default_barrels
  material {
    DryGrass
  }
}
#declare Layer_02_gatbase1_Ref = object {
  Layer_02_gatbase
  material {
    T_Stone15
  }
}
#declare Layer_02_antennne1_Ref = object {
  Layer_02_antennne
  material {
    Tx_3
  }
}
#declare Layer_02_box2_Ref = object {
  Layer_02_box1
  material {
    Brushed_Aluminum
  }
}
#declare Layer_02_pivot1_Ref = object {
  Layer_02_pivot
  material {
    Candelar_Text
  }
}
#declare Default_housing1_Ref = object {
  Default_housing
  material {
    Tx_3
  }
}
union { // UserDefGroup7
  object { Default_barrels3_Ref }
  object { Default_housing3_Ref }
  object { Default_barrels1_Ref }
  object { Layer_02_gatbase1_Ref }
  object { Layer_02_antennne1_Ref }
  object { Layer_02_box2_Ref }
  object { Layer_02_pivot1_Ref }
  object { Default_housing1_Ref }
  rotate -55.0*z
  translate  <-26.8, -26.4, 3.0>
}
rotate -90*x
 }
 
    
