   /********************************
   *   _  _   _ __ _  _   _  _    *
  *   /- (_) /< / /< /- _| _|    *
 *                   `          *
********************************/
 
/******************
 * Scene Settings *
 ******************/

//dammit, I've got too many switches!
#declare boHigh = on;


global_settings {
	assumed_gamma 2.2
  adc_bailout 0.0
	#if ( boHigh )
  	max_trace_level 100
  #else
  	max_trace_level 50
  #end
}



#declare CAM_FINAL		= 0;
#declare CAM_FORTRESS	= 1;
#declare CAM_HIGH			= 2;
#declare CAM_WIN			= 3;
#declare CAM_TOWN			= 4;
#declare CAM_CLOSER		= 5;
#declare CAM_MAN			= 6;
#declare CAM_YACHT		= 7;
#declare CAM_OVERVIEW	= 8;
#declare CAM = CAM_FINAL;

#declare LIGHTS_DEBUG	= 0;
#declare LIGHTS_FAST	= 1;
#declare LIGHTS_FINAL	= 2;
#if ( boHigh )
	#declare LIGHTS = LIGHTS_FINAL;
#else
	#declare LIGHTS = LIGHTS_FAST;
#end

#declare boSkyHigh					= boHigh;
#declare boSkyLow						= (!boHigh);
#declare boMediaInteraction = on;
#declare boCloudsHigh				= boHigh;
#declare boCloudsLow				= off;
#declare boGround						= on;
#declare boStars						= off;
#declare boMoon							= on;
#declare boHills						= on;
#declare boFlowers					= off;
#declare boMountainsHigh		= boHigh;
#declare boMountainsLow			= (!boHigh);
#declare boFoothills				= on;
#declare boCoastHigh				= boHigh;
#declare boCoastLow					= (!boHigh);
#declare boSea							= on;
#declare boTown							= on;
#declare boBoats						= on;
#declare boTreesHigh				= off;//boHigh; //requires tomtree macro
#declare boTreesLow					= on;//(!boHigh);
#declare boFortress					= on;
#declare boIsland						= on;
#declare boHighDirt					= boHigh;
#declare boLowDirt					= (!boHigh);
#declare boIslandClouds			= off;
#declare boManHigh					= off;//boHigh; //removed as the file was 5 megs and I have a 56k modem!
#declare boManLow						= (!boHigh);

/*****************
 * Include Files *
 *****************/

#include "colors.inc"
//#include "txttree.inc"
//#include "maketree.pov"

#if ( boTreesHigh )
	#include "fir.inc"
	#include "TOMTREE.inc"
#else
	#declare TREE =
		cone {
			<0,0,0>, 0.2, <0,1,0>, 0
			pigment {
				gradient x
				translate<0.02,0,0>
				colour_map{
					[0.02 rgb <0,.6,.2>]
					[0.02 rgb <0.35,0.65,0>]
				}
			}
			finish {
				ambient 0.1
				diffuse 0.6
				specular 0.5
				roughness 0.01
			}
		}
#end

#include "materials.inc"
#include "positions.inc"
#include "buildings.inc"
#include "param julia.inc"

/*************
 * Constants *
 *************/

#declare fEarthRad = 6000000;
#declare fSeaHeight = 2.0;

#declare gfMediaLightFactor = 0.08;

#declare rs = seed(24);

#declare man_scale	= 10;//real: 4; //(town was scaled by 2)
#declare man_rot		= <0,0,0>;
#declare man_pos		= <-120,9.75,40>;

/*************
 * The Scene *
 *************/

#switch (CAM)

	#declare pos = <0,30,-190>;
	#declare dir = <0,11.5,70>;

	#case (CAM_FINAL)
		camera {
			right			x*5/4
			up				y*1/2
			direction	z*0.75
			
			location pos
			look_at pos+dir
		}
	#break
	
	#case (CAM_CLOSER)
		camera {
			right			x*5/4
			up				y*1/2
			direction	z*2.0
			
			location pos
			look_at island_pos+<3,18,0>
		}
	#break

	#case (CAM_FORTRESS)
		camera {
			right			x
			up				y*3/4
			direction	z*0.5
			
			location <20,110,-90>
			look_at island_pos+<0,-10,0>
		}
	#break

	#case (CAM_HIGH)
		camera {
			right			-z
			up				x*3/4
			direction	-y
			
			location <0,15000,5000> //y*30000
		}
		
		cone {
			pos, 0, pos+40*dir, vlength(40*dir)/0.75
			texture {
				pigment { rgbt <1.0,0.3,0.3,0.5> }
				finish {
					ambient 0.6
					diffuse 0.4
					specular 1.0 roughness 0.01
				}
			}
		}
	#break
	
	#case (CAM_WIN)
		camera {
			right			x
			up				y*3/4
			direction	z*3.7
			
			location < 10,  h5+6, -30>
			look_at  < 10,  h5+5,  9>

			rotate island_rot
			translate island_pos
		}
	#break
	
	#case (CAM_TOWN)
		camera {
			right			x*5/4
			up				y*1/2
			direction	z*1.2
			
			location town_pos + <120,0,0> + 150*<0,5,-1>//<1,0.4,-3>
			look_at town_pos + <120,0,0>
		}
	#break

	#case (CAM_MAN)
		camera {
			right			x*4/3
			up				y
			direction	z*2
			
			location man_pos + y*man_scale*0.4 + <10,-4.5,-15>
			look_at man_pos + y*man_scale*0.4
		}
	#break
	
	#case (CAM_YACHT)
		camera {
			right			x*5/4
			up				y*1/2
			direction	z*14
			
			location pos
			look_at <0,0,2000> + <0,13,0>
		}
	#break
	
	#case (CAM_OVERVIEW)
		camera {
			right			x*4/3
			up				y
			direction	z*0.75
			
			location pos+<0,300,0>
			look_at pos+dir*5
		}

/*		cone {
			pos, 0, pos+4*dir, (vlength(2*dir)/0.75)*5/4
			texture {
				pigment {
					gradient z //dir - didn't work.
					scale 280
					translate pos 
					colour_map {
						[0.2	rgbt <1,1,1,0>]
						[0.75	rgbt <1,1,1,1>]
					}
				}
				finish {
					ambient 0.6
					diffuse 0.4
				}
			}
		}*/
		
		light_source {
			pos, rgb <0,0,50>
			spotlight
			point_at pos+dir
			radius degrees(atan2(1,0.75))-2
			falloff degrees(atan2(1,0.75))+2
		}
	#break
	
#end


#switch (LIGHTS)
	#declare light_pos = <-3,1,-2>*10000;
	
	#case (LIGHTS_DEBUG)
		light_source {
			<-3,1,-2>*10000,
			rgb 1
			media_interaction off
		}
	#break

	#case (LIGHTS_FAST)
		//exactly the same pos, brightness, etc. as final lights, but with less details
		light_source {
			light_pos,
			rgb 1.0
//			area_light <1,-2,-3>*500, <-2,-3,1>*500, 2, 2
//			jitter
			media_interaction off
		}
		
		#if ( boMediaInteraction )
			light_source {
				light_pos,
				rgb gfMediaLightFactor
				media_interaction boMediaInteraction
			}
		#end

		//another light to fake a bit of radiosity :)		
		light_source {
			<80,0.5,-80>
			rgb 0.2//<0.2, 0.22, 0.15>
			shadowless
			media_interaction off
		}
	#break
	
	#case (LIGHTS_FINAL)
		light_source {
			light_pos,
			rgb 1.0
			area_light <1,-2,-3>*500, <-2,-3,1>*500, 2,2//4, 4
			media_interaction off
			jitter
		}
		
		#if ( boMediaInteraction )
			light_source {
				light_pos,
				rgb gfMediaLightFactor
				media_interaction boMediaInteraction
			}
		#end

		//another light to fake a bit of radiosity :)		
		light_source {
			<80,0.5,-80>
			rgb 0.2//<0.2, 0.22, 0.15>
			shadowless
			media_interaction off
		}
	#break

#end


//sky stuff

#if (boSkyLow)

	sky_sphere {
	  pigment {
			#if (boStars)
				granite
				scale 0.05
				colour_map {
					[0.88 rgb <0.1, 0.2, 0.625>]
					[1.00 rgb 2]
				}
			#else
				rgb <0.1, 0.2, 0.625>
			#end
		}
	  pigment {
	    gradient y
	    scale 2
	    translate -0.5*y
	    sine_wave
	    colour_map {
	      [0.3 rgbt <0.1, 0.2, 0.625, 1.0>]
	      [1.0 rgbt <0.4, 0.5, 1.0, 0.0>]
	    }
	  }
	  pigment {
	    boxed
	    scale <1, 0.2, 1>
	    pigment_map {
	      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
	      [0.000000000001
	        gradient y
	        translate -y
	        poly_wave 0.35
	        //cubic_wave
	        colour_map {
	          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
	          [1.00 rgbt <1.0, 1.0, 1.0, 1.0>]
	        }
	      ]
	    }
	  }
	  pigment {
	  	boxed
	  	translate <0,-1,0>
	  	scale 4
	  	colour_map {
	  		[0.0000 rgbt 1]
	  		[0.0001 rgb 1]
	  	}
	  }
	}
	
#end

#if (boSkyHigh)

	#if (boStars)
		sky_sphere {
		  pigment {
				granite
				scale 0.07
				colour_map {
					[0.90 rgb 0]
					[1.00 rgb 1.5]
				}
			}
		}
	#end

	#declare fDensityFactor = 30;//20;

	#declare fSkyHeight = 50000/fDensityFactor;
	
	difference {
	
		sphere {
			<0,0,0>, fEarthRad+fSkyHeight
		}
		
		sphere {
			<0,0,0>, fEarthRad-1
		}
		
		hollow on
		//no_shadow
		
		pigment { rgbt 1 }
		interior {
			media {
	    	emission rgb <0.2,0.3,0.9>
	    	absorption <0.2,0.3,0.9>
			
			  intervals 20//20
			  samples 1, 20//20
			  confidence 0.99
			  variance 1.0/256.0
			  
			  density {
			  	spherical
			  	density_map {
			  		[0 rgb 0.00000]
			  		[(fSkyHeight/(fEarthRad+fSkyHeight))
			  			bozo
			  			scale <0.03,0.0001,0.03>
			  			colour_map {
			  				[0 rgb 0]
			  				[1 rgb 0.00003*fDensityFactor]
			  			}
			  		]
			  	}
			  	scale fEarthRad+fSkyHeight
			  }
			}
		}
		
		translate <0,-fEarthRad,0>
	
	}

#end


#if (boCloudsHigh | boCloudsLow)

	#declare nLoop = 0;
	#declare fCloudHeight = 600;
	#if ( boCloudsHigh )
		#declare nCloudLayers = 30;
	#else
		#declare nCloudLayers = 3;
	#end
	#declare fCloudSpread = 160;
	#declare fCloudThreshMin = 0.7;
	#declare fCloudThreshMax = 0.9;
	#declare fCloudBrightnessTop = 1.4;
	#declare fCloudBrightnessBot = 0.45;
	
	union {
	
		#while ( nLoop < nCloudLayers+1 )
			intersection {
				sphere {
					<0,-fEarthRad,0>, fEarthRad + fCloudHeight + fCloudSpread * (nLoop/nCloudLayers)
				}
				plane {
					-z, -2000
				}
			
				hollow on
				//no_shadow
				texture {
					pigment {
						spotted
						warp {
							turbulence 0.6
							octaves 2
							omega 0.6
							lambda 12
						}
						#declare fThreshold = abs((nLoop/nCloudLayers) - 0.5) * 2;
						#declare fThreshold = (fCloudThreshMax - fCloudThreshMin) * fThreshold;
						#declare fThreshold = fThreshold + fCloudThreshMin;
						pigment_map {
							[fThreshold	rgbt 1] //n.b. faster to compute than the following, but that one's needed as it matches the pattern of the opaque one.
							[fThreshold
									spotted
									scale 0.05
									colour_map {
										[0.5 rgbt <1.2,1.2,1.2,1>] //n.b. pretty cool effect when accidentally used same transmit as other bit!
										[0.9 rgbt <0.7,0.7,0.7,1>]
									}
							]
							[(fThreshold+0.2)
									spotted
									scale 0.05
									colour_map {
										[0.5 rgbt <1.2,1.2,1.2,pow(0.7,30/nCloudLayers)>]
										[0.9 rgbt <0.7,0.7,0.7,pow(0.7,30/nCloudLayers)>]
									}
							]
						}
						scale 3000
						scale 1.2
						translate <0,0,1000>
					}
					finish {
						diffuse 0.0
						ambient 0.(fCloudBrightnessBot) + (fCloudBrightnessTop - fCloudBrightnessBot)*(nLoop/nCloudLayers)
					}
				}
			}
			#declare nLoop = nLoop + 1;
		#end //#while

				
		bounded_by {
			sphere {
				<0,-fEarthRad,0>, fEarthRad + fCloudHeight + fCloudSpread * 1.1
			}
		}

	} //union

#end


//moon!
#if ( boMoon )
#declare moon_pos = <18000, 500, 25000>*100; //subtle moon behind clouds on bot left of view.
#declare moon_rad = 2500*100;
//#declare moon_pos = <12000, -1000, 25000>*100; //biiig moon
//#declare moon_rad = 13000*100;
//#declare moon_pos = <2000, 9000, 25000>*100; //moon over leftmost turret of fort
//#declare moon_rad = 2000*100;
//#declare moon_pos = <-11000, 6000, 25000>*100; //moon over mountains
//#declare moon_rad = 3000*100;

	sphere {
		moon_pos, moon_rad
		
		texture {
			pigment {
				rgb 1
			}
			finish {
				diffuse 0.0004 //really low, so it doesn't react to surface lights!
				ambient 0.0
			}
			normal {
				granite 0.125*moon_rad
				scale 1.7*moon_rad
				slope_map {
					[0.00 <0.0, 0.0>]
					[0.15 <1.0, 1.0>]
					[0.15 <1.0, 0.0>]
					[0.40 <0.0, 0.0>]
					[0.60 <0.0, 0.0>]
					[0.85 <1.0, 0.0>]
					[0.85 <1.0, -1.0>]
					[1.00 <0.0, 0.0>]
				}
			}
		}
	}
	
	light_source {
		(moon_pos)+(<-2,1,2>*moon_rad*20)
		rgb <1200, 1050, 1000>
		spotlight
		point_at moon_pos
		radius degrees(atan2(1.1,60))
		falloff degrees(atan2(1.2,60))
	}
#end


//background scenery
#if ( boMountainsHigh | boMountainsLow )

	height_field {
		#if ( boMountainsHigh )
			png "mountains (4096).png"
		#else
			png "mountains (256).png"
		#end
		smooth
		translate <-0.5, 0, -0.5>
		scale mountains_dim
		translate <0,-12,0>

		translate <0,fEarthRad,0>
		rotate <degrees(asin(mountains_pos.z/fEarthRad)),0,degrees(sin(-mountains_pos.x/fEarthRad))>
		translate <0,-fEarthRad,0>
		
		texture {
			gradient y
			turbulence 0.3
			octaves 3
			omega 0.8
			lambda 6
			scale mountains_dim.y
			texture_map {
				[0.5 full_rock]
				[0.5 full_snow]
			}
		}
	}

	#if ( boFoothills )
		height_field {
			png "hills.png"
			smooth
			translate <-0.5, 0, -0.5>
			scale mountains_dim
			scale <1,0.7,1>
			translate <0,-12,0>
	
			translate <0,fEarthRad,0>
			rotate <degrees(asin(mountains_pos.z/fEarthRad)),0,degrees(sin(-mountains_pos.x/fEarthRad))>
			translate <0,-fEarthRad,0>
			
			texture {
				pigment {
					spotted
					turbulence 0.7
					scale 150
					warp {
						turbulence 2.0
					}
					scale 10
					colour_map {
						[0.2 rgb <0.9, 0.7, 0.5>]//dry ground
						[0.4 rgb <0.8, 0.5, 0.3>]//wet ground
						[0.6 rgb <0.8, 1.0, 0.3>]//grassy ground
					}
					translate <0,10000,0>
				}
				normal {
					bozo 0.05
					scale 0.03
				}
				finish {
					diffuse 0.5
					ambient 0.2
				}
			}
		}
	#end

#end


#if ( boTown )

#declare docks =
	//based on my rough recollection of what shapes docks are, because I can't be bothered to find any reference ;)
	intersection {
		plane {
			-y, 10
		}
		
		plane {
			y, 2
			rotate <0,0,1.5>
			rotate <0,-30,0>
			translate <100,1,0>
		}
		
		plane {
			z, 200
		}

		plane {
			-z, 200
		}

		union {
			difference {
				torus {
					160, 25
					translate <150,0,0>
				}

				union {				
					box {
						<0,-15,-140>, <200,5,20>
						rotate <0,-40,0>
						translate <150,0,0>
					}

					box {
						<0,-15,-130>, <200,15,10>
						rotate <0,-40,0>
						translate <150,0,0>
					}
				}
			}
			
			plane {
				x, 0
				rotate <0,0,30>
				rotate <0,-28,0>
				translate <150,0,0>
			}
		}

		bounded_by {
			box { <-500,-10,-200>, <335,2+225*sin(radians(1.5))+1,200> }
		}
		
		scale <1.4,1,1>
		translate <-40,0,0>

		texture {
			full_rock
		}
	}
	
	union {
		object {
			town
			scale 2
			rotate <0,-20,0>
		}
		
		object {
			docks
		}
		
		translate <0,fEarthRad,0>
		rotate <degrees(asin(town_pos.z/fEarthRad)),0,degrees(sin(-town_pos.x/fEarthRad))>
		translate <0,-fEarthRad,0>
	}

#end


#if ( boBoats )

	#declare raymond =
		union {
			//hull
			intersection {
				sphere {
					<0,0,0>, 1
					scale <28,10,5>
					translate <0,5,0>
				}
				
				plane {
					y, 5
				}
				
				plane {
					-x, 0.7*28
				}
				
				bounded_by {
					box { <-0.7*28, -5, -5>, <28, 5, 5> }
				}
				
				texture {
					pigment {
						gradient y
						scale 10
						translate <0,5,0>
						colour_map {
							[0.15	rgb <0.75, 0.85, 0.79>]
							[0.15	rgb 0.05]
							[0.25	rgb 0.05]
							[0.25	rgb <0.05, 0.2, 0.4>]
						}
					}
					finish {
						ambient 0.2
						diffuse 0.7
						specular 0.3 roughness 0.02
					}
				}
			}
			
			//sails
			bicubic_patch {
				type 1
				flatness 0.0
				u_steps 2
				v_steps 2
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<0.05,0.6,0>, <0.4,0.6,-0.3>, <0.7,0.6,-0.3>, <0.8,0.6,0>
				<0.05,0,0>, <0.4,0.03,-0.3>, <0.7,0.03,-0.3>, <0.9,0,0>

				texture {
					pigment {
						gradient y
						rotate <5,0,0>
						scale 1.7
						colour_map {
							[0.45	rgb 1]
							[0.45	rgb <0.3,0.3,1>]
							[0.50	rgb <0.3,0.3,1>]
							[0.50	rgb 1]
							[0.55	rgb 1]
							[0.55	rgb <0.3,0.3,1>]
							[0.60	rgb <0.3,0.3,1>]
							[0.60	rgb 1]
						}
					}
					finish {
						ambient 0.4
						diffuse 0.15
						specular 0.5 roughness 0.8
					}
				}

				scale 28
				translate <0,6,0>
			}
			bicubic_patch {
				type 1
				flatness 0.0
				u_steps 2
				v_steps 2
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<-0.01,0.6,0>, <-0.15,0.6,-0.2>, <-0.3,0.6,-0.2>, <-0.4,0.6,0>
				<-0.01,0,0>, <-0.15,0.02,-0.2>, <-0.3,0.02,-0.2>, <-0.6,0,0>

				texture {
					pigment { rgb 1 }
					finish {
						ambient 0.4
						diffuse 0.4
						specular 0.2 roughness 0.8
					}
				}

				scale 28
				translate <0,6,0>
			}
		}
		
	#declare	throat_warbler =
		union {
			//hull
			intersection {
				sphere {
					<0,0,0>, 1
					scale <28,10,5>
					translate <0,5,0>
				}
				
				plane {
					y, 5
				}
				
				plane {
					-x, 0.7*28
				}
				
				bounded_by {
					box { <-0.7*28, -5, -5>, <28, 5, 5> }
				}
				
				texture {
					pigment {
						gradient y
						scale 10
						translate <0,5,0>
						colour_map {
							[0.22	rgb <0.8, 0, 0>]
							[0.22	rgb <0.9, 0.895, 0.85>]
						}
					}
					finish {
						ambient 0.2
						diffuse 0.7
						specular 0.3 roughness 0.02
					}
				}
			}
			
			//sails
			bicubic_patch {
				type 1
				flatness 0.0
				u_steps 2
				v_steps 2
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<0.05,0.6,0>, <0.4,0.6,-0.3>, <0.7,0.6,-0.3>, <0.8,0.6,0>
				<0.05,0,0>, <0.4,0.03,-0.3>, <0.7,0.03,-0.3>, <0.9,0,0>

				texture {
					pigment {
						gradient y
						rotate <5,0,-50>
						scale 1.7
						colour_map {
							[0.28	rgb 1]
							[0.28	rgb <1,0.35,0.3>]
							[0.45	rgb <1,0.9,0.3>]
							[0.45	rgb <1,0.0,0.5>]
							[0.52	rgb <1,0.6,0.5>]
							[0.52	rgb 1]
						}
					}
					finish {
						ambient 0.4
						diffuse 0.15
						specular 0.5 roughness 0.8
					}
				}

				scale 28
				translate <0,6,0>
			}
			bicubic_patch {
				type 1
				flatness 0.0
				u_steps 2
				v_steps 2
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,<0,1.7,0>,
				<-0.01,0.6,0>, <-0.15,0.6,-0.2>, <-0.3,0.6,-0.2>, <-0.4,0.6,0>
				<-0.01,0,0>, <-0.15,0.02,-0.2>, <-0.3,0.02,-0.2>, <-0.6,0,0>

				texture {
					pigment { rgb 1 }
					finish {
						ambient 0.4
						diffuse 0.4
						specular 0.2 roughness 0.8
					}
				}

				scale 28
				translate <0,6,0>
			}
		}
	
#declare mangrove =
	union {
		//hull
		difference {
			intersection {
				sphere {
					<0,0,0>, 1
					scale <60, 30, 20>
					translate <0, 10, 12>
				}
				sphere {
					<0,0,0>, 1
					scale <60, 30, 20>
					translate <0, 10, -12>
				}
				sphere {
					<0,0,0>, 1
					scale 60
					translate <20, 10, 0>
				}
				plane {
					y, 10
				}
			}
			
			cylinder {
				<0,0,-1>, <0,0,1>, 1
				scale <120,20,20>
				translate <5,23.5,0>
			}
			
			rotate <0,0,0>
			
			texture {
				pigment {
					gradient y
					scale 10
					translate <0,4,0>
					colour_map {
						[0.15	rgb <0.05, 0.2, 0.4>]
						[0.15	rgb <0.75, 0.85, 0.79>]
						[0.25	rgb <0.75, 0.85, 0.79>]
						[0.25	rgb 0.05]
					}
				}
				finish {
					ambient 0.2
					diffuse 0.7
					specular 0.3 roughness 0.02
				}
			}
		}
		
		//first sail & mast
		union {
			cylinder {
				<0,0,0>, <0,42,0>, 1.4
				texture {
					pigment { rgb <0.3,0.15,0.05> }
					finish { test_finish }
				}
			}
			bicubic_patch {
				type 1
				flatness 0.0
				u_steps 2
				v_steps 2
				<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,
				<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,
				<4,16,-9>, <9,16,-4>,<9,16,4>, <4,16,9>
				<0,5,-22>, <4,9,-8>,<4,9,8>, <6,5,22>

				texture {
					pigment { rgb 1 }
					finish {
						ambient 0.4
						diffuse 0.15
						specular 0.5 roughness 0.8
					}
				}
			}
			scale <1,1,0.8>
			rotate <0,4,0>
			translate <17,0,0>
		}
		
		//second sail & mast
		union {
			cylinder {
				<0,0,0>, <0,42,0>, 1.4
				texture {
					pigment { rgb <0.3,0.15,0.05> }
					finish { test_finish }
				}
			}
			bicubic_patch {
				type 1
				flatness 0.0
				u_steps 2
				v_steps 2
				<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,
				<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,<0,40,0.8>,
				<4,16,-9>, <9,16,-4>,<9,16,4>, <4,16,9>
				<0,5,-22>, <4,9,-8>,<4,9,8>, <6,5,22>
				
				texture {
					pigment {
						rgb 1
					}
					finish {
						ambient 0.4
						diffuse 0.15
						specular 0.5 roughness 0.8
					}
				}
			}
			scale <1,1,0.8>
			rotate <0,10,0>
			translate <-17,0,0>
		}
		
		//front sail
		bicubic_patch {
			type 1
			flatness 0.0
			u_steps 2
			v_steps 2
			<17,40,0>,<17,40,0>,<17,40,0>,<17,40,0>,
			<17,40,0>,<17,40,0>,<17,40,0>,<17,40,0>,
			<28,12,6>, <35,18,8>, <39,15,5>, <36,12,3>
			<17,3,0>, <27,12,5>, <36,8,3>, <45,3,0>
			texture {
				pigment {
					rgb 1
				}
				finish {
					ambient 0.4
					diffuse 0.15
					specular 0.5 roughness 0.8
				}
			}
		}
		
		scale 1.3
		translate <0,1,0>
	}


  object {
  	raymond
  	rotate <0,17,0>
  	translate town_pos+<240,0,0>
  }
	
  object {
  	raymond
  	rotate <0,40,0>
  	translate <1000,0,2100>
  }
	
  object {
  	throat_warbler
  	rotate <0,190,0>
  	translate <1500,0,1800>
  }

  object {
  	mangrove
  	rotate <0,-140,0>
  	translate <0,0,2000>
  }
	
#end


#if ( boSea )

	//sea sphere
	sphere {
		<0,-fEarthRad,0>, fEarthRad-fSeaHeight
		texture {
			sea_texture
		}
	}

#end


difference {

	#if ( boGround )

		//ground sphere
		intersection {

			sphere {
				<0,-fEarthRad,0>, fEarthRad
				texture { full_ground }
			}
			
			plane {
				z ,0
				rotate <0,20,0>
				translate coast_pos
				texture { full_ground }	
			}

		}
		
	#end
	
	#if ( boCoastHigh | boCoastLow )

		//the height field is within a box, so we need to do a double difference to get the dsired effect.
		difference {
		
			box {
				<0,0,0>, coast_dim+500*y
				translate <-coast_dim.x/2, -coast_dim.y, -coast_dim.z/2>
			}
		
			height_field {
				#if ( boCoastHigh )
					png "coast (1024).png"
				#else
					png "coast (256).png"
				#end
				smooth
				translate <-0.5, -1, -0.5> //shift it down by -1, so highest points just touch ground level.
				scale coast_dim
				rotate <0,-90,0>
				scale <-1,1,1>
			}
	
			translate <0,fEarthRad,0>
			rotate <degrees(asin(coast_pos.z/fEarthRad)),0,degrees(sin(-coast_pos.x/fEarthRad))>
			translate <0,-fEarthRad,0>
			
			texture { full_sand }
	
		}

	#end
}

#if ( boTreesHigh | boTreesLow )

	#macro rand_scale()	(rand(rs)*0.4 + 0.8)	#end
	#macro rand_rot() 	(rand(rs)*360) 				#end
	#macro rand_pos() 	(rand(rs)*6.0 - 3.0)	#end
	
	#declare trs = seed(256);
	
	#macro tree_line (start_pos, end_pos, nTrees)
		union {
			#while ( nTrees > 0 )
				#local r = rand(trs);
			
				object {
					TREE
					scale 15*(rand_scale()*<0,1,0>+rand_scale()*<1,0,1>)
					rotate <0,rand_rot(),0>
					translate start_pos*r + end_pos*(1-r) + 7*<rand_pos(),0,rand_pos()>
				}
			
				#declare nTrees = nTrees - 1;
			#end
		}
	#end

	tree_line ( <-70,0,120>, <30, 0, 60>, 10 )
	tree_line ( <-30,0,90>, <20, 0, 70>, 14 )
	tree_line ( <-200, 0, 230>, <-310,0,200>, 20 )
	tree_line ( <-90,0,120>, <-70, 5, 30>, 8 )

	

	//shrubbery!
	#if ( true )//boTreesHigh )
/* these slowed the render down and didn't look v good.
		#declare txtTree=texture{txtTree_5} // Bark texture
		
		#declare Leaf =
//				#include "shrub_leaf.inc"
				sphere {
					<0,0,0>, 0.3
				}

		#declare shrub =
			union {
				#include "shrub_tree.inc"
				#include "shrub_foliage.inc"
	      texture { txtLeaf_5 }
//	      bounded_by { sphere { <0,8,0>, 12 } }
	      scale 0.4
			}*/
		#declare shrub =
			union {
				union {
					sphere {
						<0,9,0>, 8
						hollow on
					}
					sphere {
						<0,9,0>, 6
						hollow on
					}
					sphere {
						<0,9,0>, 3
						hollow on
					}
					texture {
						full_shrub
	//					scale 0.2
					}
				}
				
				cylinder {
					<0,0,0>, <0,9,0>, 1.3
					texture {
						pigment { rgb <0.3,0.13,0.0> }
						finish {
							ambient 0.3
							diffuse 0.7
						}
					}
				}
				
				scale 0.4
			}
	#else
		#declare shrub =
			sphere {
				<0,8,0>, 8
				texture {
					pigment { rgb <0,1,0> }
					finish { test_finish }
				}
				scale 0.4
			}
	#end

	#macro shrubbery_line (start_pos, end_pos, nShrubs)
		union {
			#while ( nShrubs > 0 )
				#local r = rand(rs);
			
				object {
					shrub
					scale rand_scale()
					rotate <0,rand_rot(),0>
					translate start_pos*r + end_pos*(1-r) + 10*<rand_pos(),0,rand_pos()>
				}
			
				#declare nShrubs= nShrubs - 1;
			#end
		}
	#end
	
	shrubbery_line( <470,0,270>, <250,0,340>, 25 )
	shrubbery_line( <250,0,340>, <120,0,570>, 20 )
	shrubbery_line( <120,0,570>, <-70,0,850>, 20 )
	shrubbery_line( <-70,0,850>, <-200,0,1000>, 8 )
	
/*	shrubbery_line( <470,0,250>, <250,0,320>, 14 )
	shrubbery_line( <250,0,270>, <120,0,550>, 9 )
	shrubbery_line( <160,0,800>, <-150,0,550>, 11 )
	shrubbery_line( <-70,0,950>, <-200,0,850>, 8 )*/
	
#end

#if ( boHills | boFlowers )

	//spline hills
	#macro spline_hill(rad, heighttl, heighttr, heightbl, heightbr, pos, rot)
	
		bicubic_patch {
			type 1
			flatness 0.0
			u_steps 3
			v_steps 3
			<-rad,0,rad>,			<-rad/3,0,rad>,						<rad/3,0,rad>,						<rad,0,rad>,
			<-rad,0,rad/3>,		<-rad/3,heighttl,rad/3>,	<rad/3,heighttr,rad/3>,		<rad,0,rad/3>, 
			<-rad,0,-rad/3>,	<-rad/3,heightbl,-rad/3>,	<rad/3,heightbr,-rad/3>,	<rad,0,-rad/3>, 
			<-rad,0,-rad>,		<-rad/3,0,-rad>,					<rad/3,0,-rad>,						<rad,0,-rad>
	
			rotate rot
					
			translate <0,fEarthRad+pos.y,0>
			rotate <degrees(asin(pos.z/fEarthRad)),0,degrees(sin(-pos.x/fEarthRad))>
			translate <0,-fEarthRad,0>
		}
	
	#end
	
	//hills
	#declare hills = 
		union {
			spline_hill( 230, 140, 0, 40, 0, <-570,0,600>, <0,0,0> )
			spline_hill( 500, 180, 0, 40, 0, <-2000,0,4000>, <0,0,0> )
			spline_hill( 120, 80, 0, -20, 0, <-150,0,0>, <0,20,0> )
			spline_hill( 100, 0, 60, 0, 80, <180,0,50>, <0,0,0> )
		}
	
	#if ( boHills )
		object {
			hills
			texture { full_ground }
		}
	#end

	#if ( boFlowers )
		//flowers on hills
		intersection {
			object {
				hills
				translate <0,0.5,0>
			}
		
			union {
				#declare nLoop = 0;
				#while ( nLoop < 100 )
					cylinder { <0,-10,0>, <0,110,0>, 30 translate 1000*<(rand(rs)-0.5),0,rand(rs)-0.2> }
					#declare nLoop = nLoop + 1;
				#end
			}
			
			union {
				#declare nLoop = 0;
				#while ( nLoop < 2000 )
					cylinder { <0,-10,0>, <0,110,0>, 5 translate 1000*<(rand(rs)-0.5),0,rand(rs)-0.2> }
					#declare nLoop = nLoop + 1;
				#end
			}
			
			texture { full_flowers }
		}
	#end

#end

union {

	#if (boFortress)

		object {
			fortress_buildings
		}
		
	#end

	#if ( boIsland )
	
		union {
	
			//rock
			intersection {
			
				julia_fractal {
					<0,0.7,-0.2,-0.2>
					quaternion
					cube
					max_iteration 10
					precision 10//5000
	
					//rotate <0,-10,-90>
					rotate <101-180,10,-90>
					scale island_dim/2
					scale <1.1,0.9,1.0>
					translate <-2,0,0>
				}
				
				union {
					plane {
						y, 0
					}
	
					sphere {
						<0,0,0>, 1
						scale <island_dim.x*0.62,3,island_dim.z*0.51>
						translate <2,-1,-4>
					}
				}

				bounded_by {
					box {
						<-island_dim.x*0.46,-island_dim.y*0.45,-island_dim.z*0.54>, <island_dim.x*0.4,3,island_dim.z*0.4>
						rotate <0,27,0>
					}
				}
				
				texture {
					sed_rock_full
			  }
			}
			
			#if ( boLowDirt | boHighDirt )
				//earth
				union {
					#declare dirt_tex = array[3]
						{
							texture {
								pigment { rgb <0.4,0.2,0.0> }
								finish {
									diffuse 0.95
									ambient 0.05
									specular 0.3 roughness 0.5
								}
							},
							texture {
								pigment { rgb <0.4,0.4,0.0> }
								finish {
									diffuse 0.8
									ambient 0.2
									metallic
									specular 0.1 roughness 0.03
								}
							},
							texture {
								pigment { rgb 1 }
								finish {
									diffuse 0.95
									ambient 0.05
									specular 1.0 roughness 0.05
								}
							}
						}
					#declare dirt_scale = <island_dim.x*0.5-2.5,7,island_dim.x*0.2>;
					#if ( boHighDirt )
						#declare nDirt = 250000;
					#else
						#declare nDirt = 1000;
					#end
					#while (nDirt > 0)
				
						#declare randvec = <rand(rs)*2-1,rand(rs)*2-1,rand(rs)*2-1>;
		
						#if ( vdot(randvec,randvec) < 1 )
							sphere {
								//evenly distribute in a sphere
								<dirt_scale.x * randvec.x, dirt_scale.y * randvec.y, dirt_scale.z * randvec.z>,
								#if ( boHighDirt )
									0.1
								#else
									1
								#end
								texture { dirt_tex[int(rand(rs)*rand(rs)*3)] }
							}
							
							#declare nDirt = nDirt - 1;
						#end
					#end
					
					rotate <0,0,0>			
					translate <-3,5-dirt_scale.y,-18>
				}
			#end
	
	
			//dense earth just under the grass
			sphere {
				<0,0,0>, 1
				scale 0.85*<island_dim.x*0.62-1.8,0.2,island_dim.z*0.51-1.8>
				translate <-5,0,-12>
				texture {
					pigment { rgb <0.4,0.2,0.0> }
					finish {
						metallic
						diffuse 0.95
						ambient 0.05
						specular 0.9 roughness 0.01
					}
					normal {
						bozo 0.2
						scale 0.05
					}
				}
			}
	
			//island grass
			union {
				#declare grs = rs;//seed(11689);
				#declare nLoop = 0;		
				#while ( nLoop < 150 )
				
					#declare randang = rand(grs)*pi*1.5 - (pi/2);
					#declare randvec = <0.3*rand(grs),0.5*rand(grs),0.9*rand(grs)-0.3>;
		
					bicubic_patch {
						type 1
						flatness 0.0
						u_steps 5
						v_steps 5
						<-1,0,1>, <-0.33,0,1>, <0.33,0,1>, <1,0,1>,
						<0,0,0>, <-2,0.8,0>, <2,0.8,0>, <0,0,0>,
						<0,0,0>, <-2,0,-0.5>, <2,0,-0.5>,<0,0,0>,
						<0,0,0>, <0,-1,-0.5>+randvec, <0,-1,-0.5>+randvec, <0,0,0>
						
						scale 3
						rotate <0,degrees(randang),0>
						translate 0.85*<-island_dim.x*0.62*sin(randang),0,-island_dim.z*0.51*cos(randang)>
						translate <-4,0,-12>
						texture {
							pigment { rgb <0,1,0> }
							finish {
								metallic
								diffuse 0.5
								ambient rgb <0.1,0.1,0.13>
								specular 0.4 roughness 0.2
							}
						}
					}
		
					#declare nLoop = nLoop + 1;			
				#end
			}

			translate <5,0,6>
			scale 1.02

		} //union
		
	#end //#if ( boIsland )

	#if ( boIslandClouds )
		
		//clouds around island
		union {
			
			#include "pj clouds.inc"
			object {
				param_julia()
	
				translate <0.8,0.6,-0.1>
				scale <200,70,50>*1.2
				rotate <0,0,-7>//-15
				rotate <0,-45,0>
			}
	
			#include "pj dist clouds.inc"
			object {
				param_julia()
				
				translate <1.7,0.95,0.1>
				scale <300,70,50>*1.7
				rotate <-60,0,0>
				rotate <0,0,-3.5>//-15
				rotate <0,-43,0>
			}
			
			hollow on                 
			
			texture {
				pigment { rgbt <1,1,1,1> }
				finish {
					ambient rgb <0.4,0.42,0.5>
					diffuse 0.6
					specular 0.2 roughness 0.3 //0.2, 0.3
				}
			}
			interior {
				//ior 1.0001
				/*media {
				  #if ( boMediaInteraction )
					  scattering {
					    1, rgb 1
					    extinction 0.135
					  }
			    	emission rgb 0.1*<0.44,0.46,0.58>//0.07
					#else
			    	emission rgb 0.5
			    	absorption 1.0
			    #end
				
				  intervals 2//4
				  samples 1, 4//4
				  confidence 0.5//0.99
				  variance 1.0/16.0//1.0/256.0

					density {
						gradient z
						poly_wave 100//0.0001//0.005
						translate <0,0,-0.2>
						scale 1000
						colour_map {
								[0 rgb 0]
								[1 rgb 0.1]
//							[0.2 rgb 0]
//							[1 rgb 0.1]//1
						}
					}
				}*/
			}
			
			translate <-2,6,0>

		}

	#end
	
	rotate island_rot
	translate island_pos
	
}


#declare cane =
	cylinder {
		<0,0,0>, <0,0.43,0>, 0.015
		texture {
			pigment { rgb <0.18,0.08,0.0> }
			finish { test_finish }
		}
	}

#if ( boManHigh | boManLow )
	union {
		#if ( boManHigh )

			#include "oldman tex.inc"
			#include "oldman.inc"

			object {
				cane
				rotate <0,0,-10>
				translate <0.15,0,-0.06>
			}
			
			object {
				#include "pj robe.inc"
				param_julia()
				
				rotate <0,0,90>
				scale <0.11,0.15,0.07>
				translate <0,0.49,0.0>
				
				pigment { rgb <0.9, 0.87, 0.8> }
				finish {
					ambient 0.3
					diffuse 0.7
				}
			}
			
			object {
				#include "pj robe.inc"
				param_julia()
				
				rotate <0,0,90>
				scale <0.11,0.15,0.07>
				translate <0,0.41,0.0>
				
				pigment { rgb <0.9, 0.87, 0.8> }
				finish {
					ambient 0.3
					diffuse 0.7
				}
			}
			
			object {
				#include "pj robe.inc"
				param_julia()
				
				rotate <180,0,90>
				scale <0.08,0.24,0.034>
				rotate <-10,0,0>
				translate <0.0,0.4,0.0>
				
				pigment { rgb <0.5, 0.56, 0.7> }
				finish {
					ambient 0.3
					diffuse 0.7
				}
			}
	
			difference {
				object {
					#include "pj hair.inc"
					param_julia()
				}
				sphere {
					<0,0,0>, 1
					scale <1.2,1,0.9>
					translate <0,-0.1,0.6>
				}
						
				texture {
					pigment {
						spherical
						scale <1.7,2,2>
						colour_map {
							[0.445 rgb 1.0]
							[0.458 rgb 0.6]
						}
					}
					finish {
						ambient 0.3
						diffuse 0.7
						specular 0.4 roughness 0.05
					}
				}
				
				scale <0.05,0.043,0.043>
				translate <-0.016,0.7,-0.04>
			}
		
		#else //#if ( boManHigh )

			box {
				<-0.2,0,-0.1>, <0.2,0.8,0.1>
				texture { test_texture }
			}

		#end

		
		scale man_scale
		rotate man_rot
		translate man_pos
	}
#end

