#macro mBoxRounded(X,Y,Z,ri)
   #if (ri<0)
      box
      {
         <0,0,0>,<X,Y,Z>
      }                 
   #else
      union
      {
         //boxes for the surface between the cylinders
      
         box {<0,ri,ri>,<X,Y-ri,Z-ri>}
         box {<ri,0,ri>,<X-ri,Y,Z-ri>}
         box {<ri,ri,0>,<X-ri,Y-ri,Z>}
         
         //sphere's forming the hooks
         
         sphere {<ri,ri,ri>,ri}
         sphere {<ri,ri,Z-ri>,ri}
         sphere {<ri,Y-ri,ri>,ri}
         sphere {<ri,Y-ri,Z-ri>,ri}
         sphere {<X-ri,ri,ri>,ri}
         sphere {<X-ri,ri,Z-ri>,ri}
         sphere {<X-ri,Y-ri,ri>,ri}
         sphere {<X-ri,Y-ri,Z-ri>,ri}
                                     
         //cylinder's on the bottom (y=r)
                                     
         cylinder {<ri,ri,ri>,<X-ri,ri,ri>,ri}
         cylinder {<ri,ri,ri>,<ri,ri,Z-ri>,ri}
         cylinder {<X-ri,ri,Z-ri>,<X-ri,ri,ri>,ri}
         cylinder {<X-ri,ri,Z-ri>,<ri,ri,Z-ri>,ri}

         //cylinder's on top (y=Y-r)
         
         cylinder {<ri,Y-ri,ri>,<X-ri,Y-ri,ri>,ri}
         cylinder {<ri,Y-ri,ri>,<ri,Y-ri,Z-ri>,ri}
         cylinder {<X-ri,Y-ri,Z-ri>,<X-ri,Y-ri,ri>,ri}
         cylinder {<X-ri,Y-ri,Z-ri>,<ri,Y-ri,Z-ri>,ri}

         //vertical cylinder's (y=r -> y=Y-r)
         
         cylinder {<ri,ri,ri>,<ri,Y-ri,ri>,ri}
         cylinder {<X-ri,ri,ri>,<X-ri,Y-ri,ri>,ri}
         cylinder {<ri,ri,Z-ri>,<ri,Y-ri,Z-ri>,ri}
         cylinder {<X-ri,ri,Z-ri>,<X-ri,Y-ri,Z-ri>,ri}   

         translate <-0.5*X,-0.5*Y,-0.5*Z>
      }                            
   #end 
#end

#macro mCylinderRounded(height, radiusCylinder, radiusEdge)
   union
   {
      cylinder
      {
         <0,0,0>,<0,height,0>,radiusCylinder-radiusEdge
      }                                                
      cylinder
      {
         <0,radiusEdge,0>,<0,height-radiusEdge>,radiusCylinder
      }                                                       
      torus
      {
         radiusCylinder - radiusEdge, radiusEdge 
         translate <0,radiusEdge,0>
      }
      torus
      {
         radiusCylinder - radiusEdge, radiusEdge 
         translate <0,height - radiusEdge,0>
      }
   }                     
#end