#version unofficial MegaPov 0.7;   
#include "macros.inc"

#declare aantalLatjes = 11;
#declare tafelBladDikte = 1;
#declare tafelBladStraal = 15;
#declare afrondingenStraal = 0.2;
#declare latOpeningRatio = .85;

#declare latPlusOpeningBreedte = (2*tafelBladStraal)/(aantalLatjes - 1 + latOpeningRatio);
#debug str(latPlusOpeningBreedte,0,2) 

#declare randomValue = seed(324234);

#declare tafelBlad=
union
{
   #declare iCounter = 0;
   #while (iCounter < aantalLatjes)
      intersection
      {
         #if (iCounter = 5)
            union
            {
               difference
               {
                  object
                  {
                     mBoxRounded(latPlusOpeningBreedte*latOpeningRatio,tafelBladDikte,2*tafelBladStraal*1.1,afrondingenStraal) 
                     translate<iCounter*latPlusOpeningBreedte,0,0>
                     translate .5*<latPlusOpeningBreedte*latOpeningRatio,tafelBladDikte,2*tafelBladStraal>
                  }
                  cylinder
                  {
                     <tafelBladStraal,tafelBladDikte-afrondingenStraal,tafelBladStraal>,<tafelBladStraal,tafelBladDikte+0.1,tafelBladStraal>,latPlusOpeningBreedte*latOpeningRatio*0.75/2
                  }
                  cylinder
                  {
                     <tafelBladStraal,-0.1,tafelBladStraal>,<tafelBladStraal,tafelBladDikte+0.1,tafelBladStraal>,latPlusOpeningBreedte*latOpeningRatio*(0.75)/2-afrondingenStraal
                  }
               }
               torus
               {
                  latPlusOpeningBreedte*latOpeningRatio*(0.75)/2,afrondingenStraal
                  translate<tafelBladStraal,tafelBladDikte-afrondingenStraal,tafelBladStraal>
               }
            }
         #else
            object
            {
               mBoxRounded(latPlusOpeningBreedte*latOpeningRatio,tafelBladDikte,2*tafelBladStraal*1.1,afrondingenStraal) 
               translate<iCounter*latPlusOpeningBreedte,0,0>
               translate .5*<latPlusOpeningBreedte*latOpeningRatio,tafelBladDikte,2*tafelBladStraal>
            }
         #end
         cylinder
         {
            <tafelBladStraal,-0.1,tafelBladStraal>,<tafelBladStraal,tafelBladDikte +0.1,tafelBladStraal>,tafelBladStraal
         }
            
         texture
         {
            pigment
            {
               wood     
               turbulence <0.1,0.1,0.3>
               
               color_map 
               { 
                   [0.0 color rgb <0.55, 0.32, 0.2>] 
                   [0.1 color rgb <0.55, 0.32, 0.2>]
                   [0.2 color rgb .56*<0.88, 0.6, 0.4>]
                   [0.3 color rgb .7*<0.6, 0.3, 0.2>]
                   [0.4 color rgb .7*<0.6, 0.3, 0.2>]
                   [0.9 color rgb .56*<.88, .6, .4>]
                   [1.9   color rgb <.55, .32, .2>]
               }
            }               
            normal
            {
               wood 0.1
               turbulence <0.1,0.1,0.3>
            }                           
            finish
            {                   
               diffuse 0.3
               ambient 0.1    
               reflection 0.05
               specular 0.3
               roughness 0.003
            }
            scale <1/4,1/4,1>
            translate <latPlusOpeningBreedte*iCounter,0,0> 
            #declare rand1=rand(randomValue);
            #declare rand2=rand(randomValue);
            #declare rand3=rand(randomValue);
            translate <8,0,0>+10*<rand1,rand2,rand3>
            rotate <10+rand1*2,0,10>
         }                            
         texture
         {
            pigment
            {
               granite 
               turbulence <0.2,0.2,0.7>
               color_map
               {
                  [0 color rgbf<0.3,0.2,0.15,0.2>]
                  [0.1 color rgbf<0.4,0.1,0.1,0.2>]
                  [0.14 color rgbf<0.6,0.2,0.2,0.5>]
                  [0.6 color Clear]
                  [1 color Clear]
               }
            }      
            normal
            {
               granite 0.01
               turbulence <0.2,0.2,0.7>
            }
            finish
            {
               reflection 0.05
               specular 0.25
               roughness 0.005
            }
            scale <1,1,7>*2
         }
      }
   #declare iCounter = iCounter + 1;
   #end
   translate <-tafelBladStraal,0,-tafelBladStraal>
}

#declare woodTexture=
texture
{
   pigment
   {
      wood     
      turbulence <0.1,0.1,0.3>
      
      color_map 
      { 
          [0.0 color rgb <0.55, 0.32, 0.2>] 
          [0.1 color rgb <0.55, 0.32, 0.2>]
          [0.2 color rgb .56*<0.88, 0.6, 0.4>]
          [0.3 color rgb .7*<0.6, 0.3, 0.2>]
          [0.4 color rgb .7*<0.6, 0.3, 0.2>]
          [0.9 color rgb .56*<.88, .6, .4>]
          [1.9   color rgb <.55, .32, .2>]
      }
   }               
   normal
   {
      wood 0.013
      turbulence <0.1,0.1,0.3>
   }                           
   finish
   {
      specular 0.3
      roughness 0.003
   }
   scale <1/4,1/4,1>
   translate <latPlusOpeningBreedte*iCounter,0,0> 
   #declare rand1=rand(randomValue);
   #declare rand2=rand(randomValue);
   #declare rand3=rand(randomValue);
   translate <8,0,0>+10*<rand1,rand2,rand3>
   rotate <10+rand1*2,0,10>
}                            
texture
{
   pigment
   {
      granite 
      turbulence <0.2,0.2,0.7>
      color_map
      {
         [0 color rgbf<0.3,0.2,0.15,0.2>]
         [0.1 color rgbf<0.4,0.1,0.1,0.2>]
         [0.14 color rgbf<0.6,0.2,0.2,0.5>]
         [0.6 color Clear]
         [1 color Clear]
      }
   }      
   normal
   {
      granite 0.01
      turbulence <0.2,0.2,0.7>
   }
   finish
   {
      specular 0.25
      roughness 0.005
   }
   scale <1,1,7>*2
}


#declare steunLat=
object
{
   mBoxRounded(tafelBladStraal*2*.9,tafelBladDikte*1.5,latPlusOpeningBreedte*latOpeningRatio,afrondingenStraal)
}

#declare poot=
difference
{
   object
   {
      mBoxRounded(tafelBladStraal*3*.8,latPlusOpeningBreedte*latOpeningRatio,latPlusOpeningBreedte*latOpeningRatio,afrondingenStraal)
      rotate <0,0,90-25>
      translate <0,-tafelBladStraal,0>   
   }
   plane
   {
      <0,1,0>,-1.8*tafelBladStraal
   }
   plane
   {
      <0,-1,0>,tafelBladDikte
   }
   texture {woodTexture}
}

#declare table=
union
{
   object
   {
      tafelBlad
   }
   
   object
   {
      steunLat
      texture{woodTexture}
      translate <0,-0.5*tafelBladDikte*1.5,0>
      translate <0,0,tafelBladStraal*.25>
   }
   
   object
   {
      steunLat
      texture{woodTexture}
      translate <0,-0.5*tafelBladDikte*1.5,0>
      translate <0,0,-tafelBladStraal*.25>
   }
                             
   object
   {
      poot
      translate <0,0,-tafelBladStraal*.25>
   }                          
   object
   {
      poot       
      scale <-1,1,1>
      translate <0,0,-tafelBladStraal*.25>
   }                          
   object
   {
      poot
      translate <0,0,tafelBladStraal*.25>
   }                          
   object
   {
      poot
      scale <-1,1,1>
      translate <0,0,tafelBladStraal*.25>
   }   
   translate <0,-tafelBladDikte,0>                       
}


//test structures:
/*
light_source
{
   <tafelBladStraal,tafelBladStraal*2,2*tafelBladStraal> color rgb<1,1,1>*.9
}                             

light_source
{
   <tafelBladStraal,tafelBladStraal*1,-tafelBladStraal> color rgb<1,1,1>*1.2
}                             

camera 
{
   location <0,1*tafelBladStraal,-tafelBladStraal*1.5>
   direction <0,0,1>
   look_at <0,0,0>
}
*/