// Flame Building for XVITower scene
// code and image copyright (c) 2001, tls  (youknow@ucan.foad.org)
// See XVITower.pov for additional distribution-related statements

#version unofficial MegaPov 0.7;

// Three basic shapes are used. Blobs make a more natural flame
// than I could get with just image maps. 

#declare FlameShape1=    
blob {
  threshold 0.5
  cylinder { <0.0, 0.0, 0.0>, <0.5, 1.3, 0.5>, 1.4, 1 }
    cylinder { <0.6, 1.5, 0.5>, <0.4, 2.1, 0.3>, 1.1, 1 }
    cylinder { <0.6, 2.3, 0.4>, <0.7, 2.8, 0.0>, 0.8, 1 }
    cylinder { <0.5, 3.0, 0.1>, <0.3, 3.7, 0.3>, 0.4, 1 }
    sphere { <0.2, 4.0, 0.3>, 0.2, 1 }
  cylinder { <-1.0, -0.5, 0.0>, <-1.2, 1.4, -0.3>, 1.2, 1 }
    cylinder { <-1.3, 1.6, -0.3>, <-1.4, 2.7, -0.5>, 0.9, 1 }
    cylinder { <-1.5, 2.9, -0.5>, <-1.0, 3.5, -0.7>, 0.6, 1 }
    sphere { <-1.0, 3.8, -0.7>, 0.3, 1 } 
  cylinder { <-2.5, -1.0, -0.3>, <-2.4, 0.5, 0.0>, 1.3, 1 }
    cylinder { <-2.3, 0.6, -0.1>, <-2.6, 1.3, 0.2>, 1.0, 1 }
    cylinder { <-2.5, 1.4, 0.1>, <-2.4, 2.0, 0.4>, 0.8, 1 }
    cylinder { <-2.4, 2.1, 0.3>, <-2.7, 3.1, 0.0>, 0.6, 1 }
  cylinder { <1.3, 0.0, 0.0>, <1.5, 1.1, 0.1>, 1.3, 1 }
    cylinder { <1.5, 1.2, 0.2>, <1.7, 2.0, -0.3>, 0.9, 1 }
    cylinder { <1.8, 2.1, -0.3>, <1.9, 3.0, 0.0>, 0.6, 1 }
  } // end FlameShape1 

#declare FlameShape2=
blob {
  threshold .6
  sphere { <0, 0, 0>, 1.0, 1.0 }
    cylinder { <0, 0.9, -0.4>, <-0.2, 1.5, -0.2>, 0.8, 1.0 }
    cylinder { <-0.3, 1.7, -0.2>, <-0.1, 2.1, 0.0>, 0.6, 1.0 }
    cylinder { <0, 2.2, 0.1>, <0.1, 2.5, -0.1>, 0.4, 1.0 }
    cylinder { <0.1, 2.7, 0.0>, <-0.2, 3.2, 0.0>, 0.3, 1.0 }
    cylinder { <-0.1, 3.3, -0.1>, <0, 3.5, -0.3>, 0.2, 1.0 }
  sphere { <-1.0, -0.2, 0>, 1.0, 1.0 }
    cylinder { <-1.1, 0.9, -0.1>, <-1.3, 1.7, -0.2>, 0.8, 1.0 }
    cylinder { <-1.4, 1.9, -0.1>, <-1.5, 2.4, 0.0>, 0.6, 1.0 }
    cylinder { <-1.4, 2.5, -0.1>, <-1.6, 2.7, -0.3>, 0.5, 1.0 }
    cylinder { <-1.5, 2.8, -0.2>, <-1.4, 3.3, 0.1>, 0.3, 1.0 }
    sphere { <-1.5, 3.6, 0>, 0.15, 1.0 }
  sphere { <-2.0, 0.1, 0.1>, 1.0, 1.0 }
    cylinder { <-2.3, 0.8, 0.2>, <-2.5, 1.4, -0.3>, 0.8, 1.0 }
    cylinder { <-2.6, 1.5, -0.2>, <-2.4, 1.9, 0>, 0.65, 1.0 }
    cylinder { <-2.5, 2.0, 0.1>, <-2.6, 2.4, 0.4>, 0.5, 1.0 }
    cylinder { <-2.4, 2.5, 0.3>, <-2.7, 3.0, -0.4>, 0.4, 1.0 }
    cylinder { <-2.5, 3.2, -0.2>, <-2.8, 3.5, 0>, 0.25, 1.0 }
    sphere { <-2.6, 3.7, 0>, 0.15, 1.0 } 
  sphere { <1.0, 0.1, -0.1>, 1.0, 1.0 }
    cylinder { <1.2, 0.8, 0>, <1.4, 1.3, 0.1>, 0.8, 1.0 }
    cylinder { <1.3, 1.4, 0.1>, <1.1, 1.8, -0.2>, 0.65, 1.0 }
    cylinder { <1.2, 1.9, -0.1>, <1.5, 2.3, 0.2>, 0.5, 1.0 }
    cylinder { <1.4, 2.4, 0.1>, <1.4, 2.7, -0.2>, 0.3, 1.0 }
    sphere { <1.6, 2.8, -0.1>, 0.2, 1.0 }
  sphere { <2.0, -0.1, 0.1>, 1.0, 1.0 }
    cylinder { <2.3, 0.6, 0.1>, <2.4, 1.1, -0.1>, 0.85, 1.0 }
    cylinder { <2.5, 1.2, 0.0>, <2.3, 1.6, 0.1>, 0.7, 1.0 }
    cylinder { <2.4, 1.7, 0.1>, <2.6, 2.3, -0.3>, 0.5, 1.0 }
    cylinder { <2.5, 2.4, -0.3>, <2.3, 3.0, 0>, 0.3, 1.0 }
    sphere { <2.5, 3.2, -0.3>, 0.2, 1.0 } 
    } // end FlameShape2

#declare FlameShape3=    
blob {
  threshold .6
  sphere { <-2.0, -0.2, -0.2>, 1.1, 1 }
    cylinder { <-2.2, 0.6, 0.0>, <-2.4, 1.5, 0.2>, 0.9, 1 }
    cylinder { <-2.5, 1.7, 0.1>, <-2.6, 2.0, -0.3>, 0.75, 1 }
    cylinder { <-2.5, 2.2, -0.2>, <-2.3, 2.5, 0.0>, 0.55, 1 }
    cylinder { <-2.3, 2.65, -0.1>, <-2.5, 2.9, -0.5>, 0.35, 1 }
    sphere { <-2.5, 3.15, -0.4>, 0.35, 1 }
  cylinder { <-1.0, 0.0, 0.0>, <-0.8, 0.6, 0.1>, 1.0, 1 }
    cylinder { <-0.9, 0.8, 0.0>, <-1.3, 1.4, -0.3>, 0.8, 1 }
    cylinder { <-1.2, 1.5, -0.2>, <-1.2, 1.8, 0.0>, 0.6, 1 }
    cylinder { <-1.3, 1.9, -0.1>, <-1.0, 2.4, -0.3>, 0.4, 1 }
    sphere { <-1.1, 2.7, -0.2>, 0.25, 1 } 
  cylinder { <0.2, -0.1, 0.1>, <0.3, 0.7, 0.0>, 1.1, 1 }
    cylinder { <0.3, 0.8, 0.0>, <0.4, 1.4, -0.1>, 0.9, 1 }
    cylinder { <0.2, 1.5, -0.1>, <0.0, 1.9, -0.3>, 0.7, 1 }
    cylinder { <0.1, 2.0, -0.2>, <0.3, 2.4, 0.0>, 0.5, 1 }
    cylinder { <0.3, 2.5, 0.0>, <0.1, 2.9, 0.3>, 0.3, 1 }
    sphere { <0.2, 3.2, 0.0>, 0.2, 1 }
    } 

// This color_map is meant for use with an additional
// light source (see XVITower.pov); it may not work
// as expected with a pure white light, for instance.
      
#declare FlameMap1=
    color_map { 
      [0.0 rgb <0.7, 0.2, 0>]
      [0.1 rgb <0.8, 0.3, 0>]
      [0.3 rgb <0.9, 0.4, 0>]
      [0.6 rgb <0.8, 0.2, 0>]
      [0.8 rgb <0.6, 0, 0>]
      [1.0 rgb 0]
      } // end FlameMap1      

// There are two separate media declarations because they work
// in conjunction with the shapes; using this particular density map
// with another object may not quite give the results one is after.
// Tweaking scale and adding/changing warp made a big difference.

      
#declare FlameMedia1=
media {
  scattering { 1, 0.85 
    extinction .1
    }
  density {
    agate
    color_map { FlameMap1 }
    scale <1.3, 3.4, 1.5>
    } // end density
  } // end FlameMedia1, works with shape 1

#declare FlameMedia2=
media {
  scattering { 1, 0.85
    extinction .1
    }
  density {
    agate
    turbulence .3
    color_map { FlameMap1 }
    scale <0.8, 3.0, 1.1>
    warp { repeat x*1.1 flip <1, 1, 1> }
    } // end density
  } // end FlameMedia2, works with shapes 2, 3    

// Flame shapes total three, used in various scales
// and rotations in the main source.

#declare Flame1=
object { FlameShape1
  pigment { rgbf 1 }
  interior { media { FlameMedia1 } }
  hollow
  } 

#declare Flame2=
object { FlameShape2
  pigment { rgbf 1 }
  interior { media { FlameMedia2 } }
  hollow
  }

#declare Flame3=
object { FlameShape3
  pigment { rgbf 1 }
  interior { media { FlameMedia2 } }
  hollow
  }




