// Tower construction for XVITower scene -- tls (youknow@ucan.foad.org)
// code and image copyright (c) 2001, tls
// See XVITower.pov for additional distribution-related statements

#version unofficial MegaPov 0.7;
  
// color_maps for pigment-based functions

#declare IMap1=color_map { [0 rgb 0] [1 rgb 1]  } 
#declare IMap2=color_map { [0 rgb 1] [1 rgb 0]  }
#declare IMap3=color_map { [0 rgb .5] [1 rgb 1]  }
#declare IMap4=color_map { [0 rgb 0] [1 rgb .5]  }

// Noise used on most stones:

#declare F_Noise=function { noise3d(x*15, y*8, z*15) * 0.3 }

// Pigment functions

#declare F_Crackle1=function { pigment { crackle color_map { IMap1 } } }  
#declare F_Crackle2=function { pigment { crackle color_map { IMap2 } } }
#declare F_Crackle3=function { pigment { crackle color_map { IMap3 } } }
#declare F_Crackle4=function { pigment { crackle color_map { IMap4 } } }

#declare F_Bozo1=function { pigment { bozo color_map { IMap1 } } }
#declare F_Bozo2=function { pigment { bozo color_map { IMap2 } } }
#declare F_Bozo3=function { pigment { bozo color_map { IMap3 } } }
#declare F_Bozo4=function { pigment { bozo color_map { IMap4 } } }

// shape functions

#declare F_Box1=function { x*x-1 & y*y-1 & z*z-1 }
#declare F_Box2=function { "pillow" <1> }

// Finally, actual stone functions

#declare F_Stone1=function { F_Box1 + F_Crackle3(x/2, y/2, z/2) } // no noise
#declare F_Stone2=function { F_Box1 + F_Bozo1 } // no noise
#declare F_Stone3=function { F_Box1 + F_Crackle1(x/2, y/2, z/2) } // with noise
#declare F_Stone4=function { F_Box1 - F_Crackle4 } // with noise
#declare F_Stone5=function { F_Box2 - F_Bozo2 } // with noise
#declare F_Stone6=function { F_Box2 - F_Crackle2(x/2, y/2, z/2) } // with noise
#declare F_Stone7=function { F_Box1 + F_Crackle1(x*x, y*y, z*z) } // with noise
#declare F_Stone8=function { F_Box1 + F_Bozo2 } // with noise
#declare F_Stone9=function { F_Box2 - F_Crackle2 } // with noise
#declare F_Stone10=function { F_Box1 + F_Bozo1(x/2, y/2, z/2) } // with noise
#declare F_Stone11=function { F_Box1 - F_Crackle4(x/2, y/2, z/2) } // with noise
#declare F_Stone12=function { F_Box2 - F_Bozo2(x/2, y/2, z/2) } // with noise

// And, lastly, the block definitions

#declare Block1=
isosurface {
  function { F_Stone1 }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 3.1
  contained_by { box { -1.5, 1.5 } }
  scale <1.75, 1.1, 1.35>
  }

#declare Block2=
isosurface {
  function { F_Stone2 }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 3.5
  contained_by { box { -1.5, 1.5 } }
  scale <5/3, 1.1, 1.35>
  }

#declare Block3=
isosurface {
  function { F_Stone3 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 6.7
  contained_by { box { -1.5, 1.5 } }
  scale <5/3, 1, 1.3>
  }

#declare Block4=
isosurface {
  function { F_Stone4 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 7.1
  contained_by { box { -1.5, 1.5 } }
  scale <5/3, 1, 1.3>
  }

#declare Block5=
isosurface {
  function { F_Stone5 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 10.8
  contained_by { box { -1.5, 1.5 } }
  scale <2.2, 1.1, 1.2>
  }

#declare Block6=
isosurface {
  function { F_Stone6 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 11.3
  contained_by { box { -1.5, 1.5 } }
  scale <2.0, 1.1, 1.1>
  }

#declare Block7=
isosurface {
  function { F_Stone7 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 8.4
  contained_by { box { -1.5, 1.5 } }
  scale <5/3, 1, 1.3>
  }

#declare Block8=
isosurface {
  function { F_Stone8 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 5.5
  contained_by { box { -1.5, 1.5 } }
  scale <5/3, 1.1, 1.35>
  }

#declare Block9=
isosurface {
  function { F_Stone9 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 12
  contained_by { box { -1.5, 1.5 } }
  scale <1.9, 1.1, 1.15>
  }

#declare Block10=
isosurface {
  function { F_Stone10 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 6.2
  contained_by { box { -1.5, 1.5 } }
  scale <5/3, 1.1, 1.6>
  }

#declare Block11=
isosurface {
  function { F_Stone11 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 6.6
  contained_by { box { -1.5, 1.5 } }
  scale <5/3, 1, 1.3>
  }

#declare Block12=
isosurface {
  function { F_Stone12 + F_Noise }
  threshold 0
  accuracy 0.001
  method 2
  max_gradient 11.4
  contained_by { box { -1.5, 1.5 } }
  scale <1.9, 1.2, 1.15>
  }

// The following to randomly pick the block to use

#macro PickBlock(BlockRand)  
   #switch (BlockRand)
   #range (0,6)
     #declare ThisBlock=object { Block1 }
     #break
   #range (7,13)
     #declare ThisBlock=object { Block2 }
     #break
   #range (14,25)
     #declare ThisBlock=object { Block6 }
     #break
   #range (26,37)
     #declare ThisBlock=object { Block9 }
     #break
   #range (38,49)
     #declare ThisBlock=object { Block12 }
     #break
   #range (50,58)
     #declare ThisBlock=object { Block4 }
     #break
   #range (59,67)
     #declare ThisBlock=object { Block5 }
     #break
   #range (68,73)
     #declare ThisBlock=object { Block3 }
     #break
   #range (74,79)
     #declare ThisBlock=object { Block7 }
     #break
   #range (80,85)
     #declare ThisBlock=object { Block8 }
     #break
   #range (86,91)
     #declare ThisBlock=object { Block10 }
     #break
   #range (92,97)
     #declare ThisBlock=object { Block11 }
     #break 
   #end // ends switch statement
 #end // ends PickBlock macro

// Stone Texture

#declare OldStoneTex=
texture {
  pigment {
    granite // well, it -is- stone :)
    color_map {
      [0.0 rgb <0.9, 0.85, 0.5>]
      [0.3 rgb <0.9, 0.65, 0.4>]
      [0.7 rgb <1.0, 0.9, 0.3>]
      [1.0 rgb <0.8, 0.8, 0.7>]
      } // end cmap
    } // end pigment
  finish {
    brilliance 1
    specular .6 roughness .5
    diffuse .8 ambient .2
    } // end finish
  } // end StoneTex 

#declare SimpleBox= // for testing only
box {
  <-2.4, -1.4, -1.4>, <2.4, 1.4, 1.4>
  } 
  
#declare StoneTex=
texture {
  pigment {
    granite
    scale .3
    color_map {
      [0.0 rgb <.6, .35, 0> ]
      [0.2 rgb <.5, .5, .3>]
      [0.4 rgb <.4, .4, .4>]
      [0.6 rgb <.7, .7, .7>]
      [1.0 rgb <.2, .2, .1>]
      }
    }
  finish { brilliance 1
    specular .65 roughness .5
    diffuse .7 ambient .3
    }
  }

    

// Variables for while loops

#declare Radius=19; // Tower Radius
#declare Layers=25; // Blocks in height
#declare NumBlocks=24; // Blocks in circumfrence

#declare YStep=3.05; // Block height + fudge factor
#declare Rot=360/NumBlocks; // For calculating movement

#declare CountX=1; // starting value for movement loop
#declare CountY=1; // starting value for height loop 

#declare S1=seed(1999); // used for BlockRand

#declare BaseTower=union {
#while (CountY <= Layers) // Loop 1 to # layers

  #while (CountX <= NumBlocks) // Loop 1 to # of blocks
    
    #declare R1=int(rand(S1)*98);
    PickBlock(R1) // gets this block
    //#declare ThisBlock=object { SimpleBox }
    #declare Movement=(Rot*CountX) + (CountY*5); // second # jitters 5 degrees each layer
    
    object { ThisBlock
      rotate y*90 + y*Movement
      translate <-Radius * cos(radians(Movement)),
                 (YStep*CountY) + 1.5, // blocks start at -1.5
                 Radius * sin(radians(Movement))>
      texture { StoneTex }
      } // end object
    
    #declare CountX=CountX+1;   // usually we move 1
    #if(CountY = Layers)        // but on the last layer
      #declare CountX=CountX+1; // we move another 1
      #end                      // to give us crenallation
    
    #end // ends the movement loop
    
    #declare CountY=CountY+1; // move to next layer
    #declare CountX=1; // and start movement loop anew
  
  #end // and end layer loop
  
  } // end union BaseTower object

#declare TowerMortar=
difference {
  cylinder { <0, 2.5, 0>, <0, (Layers*YStep)-1.5, 0>, Radius-0.5 }
  cylinder { <0, 0, 0>, <0, (Layers*YStep), 0>, Radius-0.6 }
  normal { granite .5 }
  pigment { rgb 0.7 }
  finish { specular .4 roughness .8 }
  }

// A basic rounded window.

#declare WindowShape=
merge {
  box { <-3.5, -4.25, -3.1>, <3.5, 1.25, 3.1> }
  cylinder { <0, 0, -3.1>, <0, 0, 3.1>, 3.5 }
  } 

#declare SmRtWindow=
object { WindowShape 
  translate <7, YStep*(Layers*2/3)-2, -(Radius)>
  }

#declare SmLWindow=
object { WindowShape
  translate <-7, YStep*(Layers*2/3)-2, -(Radius)>
  }

#declare LgWindow=
object { WindowShape
  scale 1.3
  translate <0, YStep*(Layers*17/20), -(Radius-1)>
  }
    
    
#declare TheTower=
difference {
  union { // Tower + Mortar + Roof
    object { BaseTower }
    object { TowerMortar }
    cylinder { // A 'roof' for the tower
      <0, YStep*(Layers-2), 0>, <0, YStep*(Layers-1), 0>, Radius-0.6
      texture { StoneTex }
      }
    } // end Tower/Mortar/Roof union
  
  object { SmRtWindow pigment { rgb <.05, .05, .05> } }
  object { SmLWindow pigment { rgb <.05, .05, .05> } }
  object { LgWindow pigment { rgb <.05, .05, .05> } }
  
bounded_by { // a cylinder slightly larger than the tower
  cylinder { <0, -3, 0>, <0, YStep*Layers+5, 0>, Radius+1 }
  }  
  } // end difference, "TheTower"


// This is used for the crumbling of the tower.

#declare HF1=function { "ridgedmf", <0.3, 4, 2, 1.0, 1.0> }

#declare JaggedBreak=
isosurface {
  function { y-HF1(x,0,z) }
  threshold 0
  accuracy 0.01
  method 2
  eval
  contained_by { box { <-7, 0, -6>, <7, 5, 6> } }
  pigment { rgb 0 }
  scale <2,7,3>
  rotate <10, 10, 120> 
  translate <Radius, (YStep*Layers)+1, -2>
  } 

// This gets rid of odd hanging artifacts

#declare SmoothingBreak=
box { <-7, 0, -6>, <7, 2, 6> 
  pigment { rgb 0 }
  scale <2, 5, 3>
  rotate <10, 10, 120>
  translate <Radius+4.5, (YStep*Layers)+1, -2>
  }

#declare BrokenTower=
difference {
  object { TheTower }  
  object { JaggedBreak }
  object { SmoothingBreak }
  } 

