// etagere ou repose Spidey

#version unofficial megapov 0.7;

#include "colormap.mcr"

#declare LargE = 20;
#declare LongE = 100;
#declare EpE = 3;
#declare R1E = .5;

#declare Etagere = union {
	box { <-LongE+R1E, 0, 0>, <-R1E, -EpE, -LargE+R1E> }
	box { <-LongE, -R1E, 0>, <0, -EpE+R1E, -LargE+R1E> }
	box { <-LongE+R1E, 0-R1E, 0>, <-R1E, -EpE+R1E, -LargE> }
	sphere { <-R1E, -R1E, -LargE+R1E>, R1E }
	sphere { <-R1E, -EpE+R1E, -LargE+R1E>, R1E }
	cylinder { <-R1E, -R1E, -LargE+R1E>, <-R1E, -R1E, 0>, R1E }
	cylinder { <-R1E, -EpE+R1E, -LargE+R1E>, <-R1E, -EpE+R1E, 0>, R1E }
	cylinder { <-R1E, -R1E, -LargE+R1E>, <-LongE+R1E, -R1E, -LargE+R1E>, R1E }
	cylinder { <-R1E, -EpE+R1E, -LargE+R1E>, <-LongE+R1E, -EpE+R1E, -LargE+R1E>, R1E }
	cylinder { <-R1E, -R1E, -LargE+R1E>, <-R1E, -EpE+R1E, -LargE+R1E>, R1E }
}

#declare Equerre = union {
	intersection {
		union {
			torus { .35*LargE, R1E translate .5*(EpE-R1E)*y }
			torus { .35*LargE, R1E translate -.5*(EpE-R1E)*y }
			cylinder { .5*EpE*y, -.5*EpE*y, .35*LargE }
			cylinder { .5*(EpE-R1E)*y, -.5*(EpE-R1E)*y, .35*LargE+R1E }
		}
		box { <0, EpE*0.51, 0>, <.35*LargE+R1E*1.01, -EpE*0.51, .35*LargE+R1E*1.01> }
		rotate x*90
		rotate y*90
		translate <0, 0, -LargE*.35>
	}
	box { <.5*EpE, 0, 0>, <-.5*EpE, -.35*LargE, -.35*LargE>}
	intersection {
		union {
			torus { .5*.35*LargE, R1E translate .5*(EpE-R1E)*y }
			torus { .5*.35*LargE, R1E translate -.5*(EpE-R1E)*y }
		}
		box { <0, EpE*0.51, 0>, <-.5*.35*LargE-R1E*1.01, -EpE*0.51, .5*.35*LargE+R1E*1.01> }
		rotate -z*90
		translate <0, -LargE*.35*1.5, -LargE*.35>
	}
	difference {
		box {<.5*EpE, -.35*LargE, 0>, <-.5*EpE, -1.5*.35*LargE, -.35*LargE>}
		cylinder { <-.51*EpE, -LargE*.35*1.5, -LargE*.35>, <.51*EpE, -LargE*.35*1.5, -LargE*.35>, .5*.35*LargE }
	}
	difference {
		box {<.5*(EpE-R1E), -.35*LargE, 0>, <-.5*(EpE-R1E), -1.5*.35*LargE, -.35*LargE>}
		cylinder { <-.51*EpE, -LargE*.35*1.5, -LargE*.35>, <.51*EpE, -LargE*.35*1.5, -LargE*.35>, .5*.35*LargE-R1E }
	}
	intersection {
		union {
			torus { .5*.35*LargE, R1E translate .5*(EpE-R1E)*y }
			torus { .5*.35*LargE, R1E translate -.5*(EpE-R1E)*y }
			cylinder { .5*EpE*y, -.5*EpE*y, .5*.35*LargE }
			cylinder { .5*(EpE-R1E)*y, -.5*(EpE-R1E)*y, .5*.35*LargE+R1E }
		}
		box { <0, EpE*0.51, 0>, <.5*.35*LargE+R1E*1.01, -EpE*0.51, -.5*.35*LargE-R1E*1.01> }
		rotate -z*90
		translate <0, -LargE*.35*1.5, 0>
	}
}

#declare T_Etagere = texture {
	pigment {
		wood scale 2
		turbulence .05
		color_map { ColorMapScan ("meleze",30) }
	}
	normal {
		average
		normal_map {
			[1 wood 2.0 turbulence .05 ]
			[1 dents 2.0 scale .05 turbulence .3 ]
		}
	}
	finish {
		phong .05 phong_size 20
		specular .05 roughness .01
		brilliance .8
	}	
}
texture {
	pigment {
		wrinkles
		scale 2
		warp { turbulence .3 }
		color_map {
			[0 rgbf 1]
			[1 rgbf <.6, .4, .2, .5>]
		}
	}
}

