// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
// Don't have all of the following included at once, it'll cost memory and time
// to parse!
#include "FINISH.INC"   // Some basic finishes
#include "GLASS.INC"    // Glass textures
#include "GOLDS.INC"    // Gold textures
#include "METALS.INC"   // Metallic pigments, finishes, and textures
#include "STONES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"  // Great stone-textures created by Mike Miller
#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak
#include "WOODMAPS.INC" // Basic wooden colormaps
#include "WOODS.INC"    // Great wooden textures created by Dan Farmer and Paul Novak


//FIXME
// set global atmospheric fog effect in the scene.
// at the fog distance, there will be 63% visibility
 
  fog {
    fog_type 2// 1=constant, 2=ground_fog
    distance 10
    color rgb <0.3, 0.09, 0.0>
    turbulence 10
    turb_depth 1
// omega OMEGA
// lambda LAMBDA
// octaves OCTAVES
// fog_offset FOG_OFFSET
   fog_alt 0.2
   //filter 0.7
}

 fog {
    fog_type 2// 1=constant, 2=ground_fog
    distance 100
    color rgb <0.3, 0.09, 0.0>
    turbulence 10
    turb_depth 7
// omega OMEGA
// lambda LAMBDA
// octaves OCTAVES
// fog_offset FOG_OFFSET
   fog_alt 15
   //filter 0.7
}


//spider
#include "mechspider5.inc"
#include "lmount.inc"
#include "airlock.inc"

global_settings
{
  assumed_gamma 1.0
   ambient_light rgb <0.5, 0.15,0.0>
    
}

// ----------------------------------------
camera
{
  //location  <18.0, 6, -10.0>
  location <-15,6,12>
  right     4/3*x
  look_at   <-1.0, 5.0,  -10.0>
}


light_source
{
  0*x // light's position (translated below)
  color rgb <0.3, 0.05, 0.00>  // light's color
  translate <-100, 100, -100>
}


// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <0.5,0.5,0.5>      // light's color
  spotlight               // this kind of light source
  translate <2, 4.2,-1.3> // <x y z> position of light
  point_at <0, 4, -40>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}


// ----------------------------------------


//sky
// Create an infinite sphere around scene and allow any texture on it


// create a sphere shape
sky_sphere
{
 pigment {
    bozo
    turbulence 1
    color_map {
        [0.0 rgb <0.6, 0.200, 0.0>]
        [0.5 rgb <0.15, 0.050, 0.0>]
        [0.5 rgb <0.3, 0.005, 0.0>]
        [0.6 rgb <0.5, 0.100, 0.0>]
        [0.6 rgb <0.3, 0.005, 0.0>]
    }
}
}







// Access tunnel
#declare tunnel =
union{

difference{

cylinder
{
  0*z,  -100*z,  10
  // open
  texture {pigment {Yellow} }
  normal {
      waves 5.06
      frequency 5.0
      scale 5.0
      translate x*300
      translate z*300
   }
}

cylinder
{
 1*z,  -100.9*z,  9.5
  // open
}
}//end difference
}//end union



//Exterior light1
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,0>      // light's color
  spotlight               // this kind of light source
  translate <0, 9.7,-49> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 10           // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 60
  looks_like { sphere {
                       <0, 0, 0> // center of sphere <X Y Z>
                        0.5       // radius of sphere
                        pigment {rgb 1}
                        finish { ambient 1 }
                        // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
}}
               // intensity falloff radius (outer, in degrees)
}






//end tunnel






height_field
{
  tga "terrain.tga"
  texture
  {
    pigment
    {
      image_map { tga "terrainmap.tga" map_type 0 interpolate 2 once }
    rotate x*90 // lay X-Y image map down onto X-Z height field plane
    } 
    
  }
  smooth 
scale x*300
scale z*300
translate x*-150
translate z*-150
translate y*-0.3
}               


//ridge 



height_field
{
  tga "ridge.tga"
  texture
  {
    pigment
    {
      image_map { tga "ridgemap.tga" map_type 0 interpolate 2  }
    //rotate x*90 // lay X-Y image map down onto X-Z height field plane
    scale <-10,-10,-10>
    } 
    
  }
  
smooth   
scale x*300
scale z*300
scale y*50
translate x*-100
translate z*-150
translate y*-20
}


//biodome
// create a sphere shape

#declare biodome =

sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  100       // radius of sphere
   scale <1,0.5,1> // <= Note: Spheres can become ellipses by uneven scaling
  hollow
  texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
    finish  { F_Glass2 }
}

}

//lab
#declare lab =
union {
// create a box that extends between the 2 specified points
box
{
  <-10, -1, -10>  // one corner position <X1 Y1 Z1>
  < 9,  25,  10>  // other corner position <X2 Y2 Z2>
}
box
{
  <-0, -1, -20>  // one corner position <X1 Y1 Z1>
  < 20,  12,  30>  // other corner position <X2 Y2 Z2>
}

box
{
  <0, -1, -10>  // one corner position <X1 Y1 Z1>
  < -20,  18,  20>  // other corner position <X2 Y2 Z2>
}


}//end union

//compound lights
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 0.25  blue 0.0  // light's color
  translate <-15, 21, -80>

}







object {spider}
object {lmount
        translate y*3
        translate x*2.5}
object {tunnel
        translate z*-50 }   

object { airlock }
object { biodome 
        translate z*-175
        translate x*30 }
object { lab 
        translate z*-100
        translate x*-5 
        pigment {White}}