// *****************************************************
//  coordinate color macro Ver 0.2r000505a include file
//  (Povray Ver 3.1g)
//  By S.Nishimura 
// *****************************************************


// RGB light source save macro (sub)
#macro RGB_set(R_ls,G_ls,B_ls,W_cnt)
//
#switch (W_cnt)
#case (0)
 #declare R0 = R_ls; #declare G0 = G_ls; #declare B0 = B_ls;
#break
#case (1)
 #declare R1 = R_ls; #declare G1 = G_ls; #declare B1 = B_ls;
#break
#case (2)
 #declare R2 = R_ls; #declare G2 = G_ls; #declare B2 = B_ls;
#break
#case (3)
 #declare R3 = R_ls; #declare G3 = G_ls; #declare B3 = B_ls;
#break
#case (4)
 #declare R4 = R_ls; #declare G4 = G_ls; #declare B4 = B_ls;
#break
#case (5)
 #declare R5 = R_ls; #declare G5 = G_ls; #declare B5 = B_ls;
#break
#case (6)
 #declare R6 = R_ls; #declare G6 = G_ls; #declare B6 = B_ls;
#break
#case (7)
 #declare R7 = R_ls; #declare G7 = G_ls; #declare B7 = B_ls;
#break
#case (8)
 #declare R8 = R_ls; #declare G8 = G_ls; #declare B8 = B_ls;
#break
#case (9)
 #declare R9 = R_ls; #declare G9 = G_ls; #declare B9 = B_ls;
#break
#end
#end // macro end

// Smax length set macro (sub)
#macro Smax_set(Ha,Ss,r_W,g_W)
//
#local Smax_type =0;
#if(  0<=Ha & Ha< 30) #local Smax_type = 1;#end
#if( 30<=Ha & Ha< 90) #local Smax_type = 2;#end
#if( 90<=Ha & Ha<150) #local Smax_type = 3;#end
#if(150<=Ha & Ha<210) #local Smax_type = 4;#end
#if(210<=Ha & Ha<270) #local Smax_type = 5;#end
#if(270<=Ha & Ha<330) #local Smax_type = 6;#end
#if(330<=Ha & Ha<360) #local Smax_type = 1;#end
//
#switch (Smax_type)
#case (0)
 #declare Smax_length = 0;
#break
#case (1)
 #local R_ls = 1;
 #local B_ls = 2*Ss-R_ls;
 #local T_b = B_ls*cos(radians(30))*(1-tan(radians(Ha))*tan(radians(30))+tan(radians(Ha))*r_W-g_W);
 #local U_b = tan(radians(Ha))*(R_ls-sin(radians(30))*2*Ss)+2*Ss*cos(radians(30));
 #local b = T_b/U_b;
 #local r_P = b*(R_ls-sin(radians(30))*2*Ss)/(B_ls*cos(radians(30)))+tan(radians(30));
 #declare Smax_length = (r_P-r_W)/cos(radians(Ha));
#break
#case (2)
 #local G_ls = 1;
 #local B_ls = 2*Ss-G_ls;
 #local T_b = B_ls*(tan(radians(Ha))-tan(radians(Ha))*r_W*cos(radians(30))+g_W*cos(radians(30)));
 #local U_b = tan(radians(Ha))*(2*Ss-G_ls*sin(radians(30)))+G_ls*cos(radians(30));
 #local b = T_b/U_b;
 #local g_P = b*G_ls/B_ls;
 #declare Smax_length = (g_P-g_W)/sin(radians(Ha));
#break
#case (3)
 #local G_ls = 1;
 #local R_ls = 2*Ss-G_ls;
 #local T_b = tan(radians(Ha))*(R_ls+G_ls*sin(radians(30)))-cos(radians(30))*(r_W*tan(radians(Ha))*2*Ss-g_W*2*Ss+G_ls);
 #local U_b = tan(radians(Ha))*(R_ls+G_ls*sin(radians(30)))-G_ls*cos(radians(30));
 #local b = T_b/U_b;
 #local g_P = G_ls*(1-b)/(2*Ss);
 #declare Smax_length = (g_P-g_W)/sin(radians(Ha));
#break
#case (4)
 #local B_ls = 1;
 #local R_ls = 2*Ss-B_ls;
 #local T_b = B_ls*cos(radians(30))*(1-tan(radians(Ha))*tan(radians(30))+tan(radians(Ha))*r_W-g_W);
 #local U_b = tan(radians(Ha))*(R_ls-sin(radians(30))*2*Ss)+2*Ss*cos(radians(30));
 #local b = T_b/U_b;
 #local r_P = b*(R_ls-sin(radians(30))*2*Ss)/(B_ls*cos(radians(30)))+tan(radians(30));
 #declare Smax_length = (r_P-r_W)/cos(radians(Ha));
#break
#case (5)
 #local B_ls = 1;
 #local G_ls = 2*Ss-B_ls;
 #local T_b = tan(radians(Ha))*B_ls-cos(radians(30))*(r_W*tan(radians(Ha))*B_ls-g_W*B_ls);
 #local U_b = tan(radians(Ha))*(2*Ss-G_ls*sin(radians(30)))+G_ls*cos(radians(30));
 #local b = T_b/U_b;
 #local g_P = b*G_ls/B_ls;
 #declare Smax_length = (g_P-g_W)/sin(radians(Ha));
#break
#case (6)
 #local R_ls = 1;
 #local G_ls = 2*Ss-R_ls;
 #local T_b = tan(radians(Ha))*(R_ls+G_ls*sin(radians(30)))-cos(radians(30))*(r_W*tan(radians(Ha))*2*Ss-g_W*2*Ss+G_ls);
 #local U_b = tan(radians(Ha))*(R_ls+G_ls*sin(radians(30)))-G_ls*cos(radians(30));
 #local b = T_b/U_b;
 #local g_P = G_ls*(1-b)/(2*Ss);
 #declare Smax_length = (g_P-g_W)/sin(radians(Ha));
#break
#end
#end // macro end

// ***** coordinate color macro (main) *****
#macro coordinate_color(Hangle,Spurity,Sstrength,Coord_type,Color_count) // macro start
// input check
// range check
#if (Coord_type<0 | Coord_type>3) #declare Coord_type = 1; #end
#if (Color_count<0) #declare Color_count = 0; #end
#if (Color_count>9) #declare Color_count = 9; #end
#declare Hangle = mod(Hangle,360);                   // Hue_angle                          
#if (Hangle<0) #declare Hangle = 360+Hangle; #end
#if (Spurity<0) #declare Spurity = 0; #end           // Stimulation purity
#if (Spurity>1) #declare Spurity = 1; #end
#if (Sstrength<0) #declare Sstrength = 0; #end       // Stimulation strength
#if (Sstrength>1) #declare Sstrength = 1; #end

// basis value  
#local r_R = 1/cos(radians(30));
#local g_R = 0;
#local r_G = 1*tan(radians(30));
#local g_G = 1;
#local r_B = 0;
#local g_B = 0;
#local r_W = (1/3)/cos(radians(30)) + (1/3)*tan(radians(30));
#local g_W = 1/3;

// Coordinate type
#local W_Ha = Hangle; #local W_cnt = Color_count; #local C_cnt = Color_count+Coord_type;
#if(C_cnt>10) #local C_cnt = 10;#end
#while(W_cnt<C_cnt)
 #if(Coord_type=2 & W_cnt=Color_count+1) #declare Hangle = mod(W_Ha+180,360);#end
 #if(Coord_type=3 & W_cnt=Color_count+1) #declare Hangle = mod(W_Ha+120,360);#end
 #if(Coord_type=3 & W_cnt=Color_count+2) #declare Hangle = mod(W_Ha+240,360);#end
// Hue angle jugment
#local RGB_type = 0;
 #if (Hangle >= 0 & Hangle< 90) #local RGB_type = 1; #end
 #if (Hangle>= 90 & Hangle<210) #local RGB_type = 2; #end
 #if (Hangle>=210 & Hangle<330) #local RGB_type = 3; #end
 #if (Hangle>=330 & Hangle<360) #local RGB_type = 1; #end
// RGB light source calculation
#switch (RGB_type)
#case (0)
 #local R_ls = Sstrength; #local G_ls = Sstrength; #local B_ls = Sstrength;
#break
#case (1)
 #local m = (g_R-g_G)/(r_R-r_G);
#if(Sstrength<=0.5)
 #declare Smax_length = (m*(r_R-r_W)-(g_R-g_W))/(m*cos(radians(Hangle))-sin(radians(Hangle)));
#else
 Smax_set(Hangle,Sstrength,r_W,g_W)
#end
 #local S_length = Spurity*Smax_length;
 #local r_P = S_length*cos(radians(Hangle))+r_W;
 #local g_P = S_length*sin(radians(Hangle))+g_W ;
 #local r = r_P*cos(radians(30))-g_P*sin(radians(30));
 #local g = g_P;
 #local b = 1-(r+g);
 #local R_ls = 2*Sstrength*(r/(g+b));
 #if (r>g & r>b) #local R_ls = 2*Sstrength*(r/(r+b)); #end
 #local G_ls = R_ls*g/r;
 #local B_ls = R_ls*b/r;
#break
#case (2)
 #local m = (g_G-g_B)/(r_G-r_B);
#if(Sstrength<=0.5)
 #declare Smax_length = (m*(r_G-r_W)-(g_G-g_W))/(m*cos(radians(Hangle))-sin(radians(Hangle)));
#else
 Smax_set(Hangle,Sstrength,r_W,g_W)
#end
 #local S_length = Spurity*Smax_length;
 #local r_P = S_length*cos(radians(Hangle))+r_W;
 #local g_P = S_length*sin(radians(Hangle))+g_W;
 #local r = r_P*cos(radians(30))-g_P*sin(radians(30));
 #local g = g_P;
 #local b = 1-(r+g);
 #local G_ls = 2*Sstrength*(g/(r+b)); 
 #if (g>r & g>b) #local G_ls = 2*Sstrength*(g/(r+g)); #end
 #local R_ls = G_ls*r/g;
 #local B_ls = G_ls*b/g;
#break
#case (3)
 #local m = (g_B-g_R)/(r_B-r_R);
#if(Sstrength<=0.5)         
 #declare Smax_length = (m*(r_B-r_W)-(g_B-g_W))/(m*cos(radians(Hangle))-sin(radians(Hangle)));
#else
 Smax_set(Hangle,Sstrength,r_W,g_W)
#end
 #local S_length = Spurity*Smax_length;
 #local r_P = S_length*cos(radians(Hangle))+r_W;
 #local g_P = S_length*sin(radians(Hangle))+g_W;
 #local r = r_P*cos(radians(30))-g_P*sin(radians(30));
 #local g = g_P;
 #local b = 1-(r+g);
 #local B_ls = 2*Sstrength*(b/(r+g));
 #if (b>r & b>g) #local B_ls = 2*Sstrength*(b/(g+b)); #end
 #local R_ls = B_ls*r/b;
 #local G_ls = B_ls*g/b;
#break
#end
// RGB light source save
 RGB_set(R_ls,G_ls,B_ls,W_cnt)
#local W_cnt = W_cnt+1;
#end // while end

#end  // macro end