#macro Schnittpunkt_Ebene_Question(Ax,Ay,Bx,By,Cx,Cy,Dx,Dy)
 #local Fehler = 0;
 #if(Ax=Bx & Ay=By)
  #local Fehler = 1;
 #end 
 #if(Cx=Dx & Cy=Dy)
  #local Fehler = 2;
 #end
 #if((Dx-Cx)*(By-Ay)=(Dy-Cy)*(Bx-Ax))
  #local Fehler = 3;
 #end
 Fehler 
#end

#macro Schnittpunkt_Ebene(Ax,Ay,Bx,By,Cx,Cy,Dx,Dy)
 #if(Ax=Bx & Ay=By)
  #error "marco Schnittpunkt_Ebene :A=B/"
 #end 
 #if(Cx=Dx & Cy=Dy)
  #error "marco Schnittpunkt_Ebene :C=D/"
 #end
 #if((Dx-Cx)*(By-Ay)=(Dy-Cy)*(Bx-Ax))
  #error "macro Schnittpunkt_Ebene:parallele Geraden/"
 #end 
 #if(Ay!=By)
  #local faktor = (Bx-Ax)/(By-Ay);
  #local l = (Ax-Ay*faktor-Cx+Cy*faktor)/(Dx-Cx-(Dy-Cy)*faktor);
 #else
  #local l = (Ay-Cy)/(Dy-Cy); 
 #end 
 l
#end

//--------------returns point of intersection between the lines through AB and CD-----------------------------
#macro Schnittpunkt(A,B,C,D)
 #if(A.x=B.x & A.y=B.y & A.z = B.z)
  #error "macro Schnittpunkt :A=B/"
 #end 
 #if(C.x=D.x & C.y=D.y & C.z = D.z)
  #error "macro Schnittpunkt :C=D/"
 #end
 #if( Schnittpunkt_Ebene_Question(A.x,A.y,B.x,B.y,C.x,C.y,D.x,D.y) = 0 )
  #local l = Schnittpunkt_Ebene(A.x,A.y,B.x,B.y,C.x,C.y,D.x,D.y);
  #local E = C + l*(D-C);
  
  #if ((B.x-A.x)*(E.z-A.z)!=(E.x-A.x)*(B.z-A.z))
   #warning "macro Schnittpunkt : windschiefe Geraden/"
  #end 
 #else
  #if( Schnittpunkt_Ebene_Question(A.x,A.z,B.x,B.z,C.x,C.z,D.x,D.z) = 0 )
   #local l = Schnittpunkt_Ebene(A.x,A.z,B.x,B.z,C.x,C.z,D.x,D.z);
   #local E = C + l*(D-C);
   #if ((B.x-A.x)*(E.y-A.y)!=(E.x-A.x)*(B.y-A.y))
    #warning "macro Schnittpunkt : windschiefe Geraden/"
   #end 
  #else
   #if( Schnittpunkt_Ebene_Question(A.y,A.z,B.y,B.z,C.y,C.z,D.y,D.z) = 0 )
    #local l = Schnittpunkt_Ebene(A.y,A.z,B.y,B.z,C.y,C.z,D.y,D.z);
    #local E = C + l*(D-C);
    #if ((B.x-A.x)*(E.z-A.z)!=(E.x-A.x)*(B.z-A.z))
     #warning "macro Schnittpunkt : windschiefe Geraden/"
    #end 
   #else
    #error "macro Schnittpunkt : windschiefe Geraden/"
   #end
  #end
 #end
 E    
#end
//--------------angle between  the lines through AM and MB-------------
#macro get_Winkel(A,M,B)
 acos(vdot(A-M,B-M)/(sqrt (vdot(A-M,A-M)*vdot(B-M,B-M)) ))
#end
//-------- rotates A around M in the plain through AMB about angle Phi--------------------------
#macro rotate_Winkel(A,M,B, Phi)
 #local rotate_Axis = vcross(A-M,B-M);
 #if( rotate_Axis.x=0 & rotate_Axis.y=0 & rotate_Axis.z = 0)
  #error "macro rotate_Winkel : A,M,B auf einer Geraden"
 #end 
 vaxis_rotate(A-M,rotate_Axis,degrees(Phi))+M
#end
//-----------gets the middle of a circle through AB in the plain through ABC with Radius Radius----------
#macro Get_Mittelpunkt(A,B,C,Radius)
 #if(A.x=B.x & A.y=B.y & A.z = B.z)
  #error "macro Get_Mittelpunkt: A=B"
 #end 
 #if(vcross(A-B,C-B).x=0 & vcross(A-B,C-B).y=0 & vcross(A-B,C-B).z=0)
  #warning concat( "C=", str(C.x,3,1), str(C.y,3,1), str(C.z,3,1),"\n" )
 #end
 #local N = A + 0.5*(B-A);
 #local AS = vaxis_rotate(A-B,vcross(A-B,C-B),130)+B;
 #local BS = vaxis_rotate(B-A,vcross(B-A,C-A),130)+A;
 #local NS = Schnittpunkt(A,AS,B,BS);

 N + Radius/vlength(NS-N)*(NS-N)
#end
