//---Textures--------------------------------------------------------------------------------------------------
#declare Color_Seide =color rgb <1,1,1>;
#declare Seide =
texture
{
 pigment{Color_Seide}
 finish
 {
  diffuse 0.8
  brilliance 0.4
  ambient 0.3
  //irid {0.3 thickness 0.25 turbulence 0.3}
 }
}
#declare Tau =
texture
{
  pigment{rgbf<1,1,1,1>}
  finish
  {
   ambient 0
   diffuse 0
   reflection 0.001
   specular 0.8
   roughness 0.003
   phong 1
   phong_size 400
  }
}
//---Spiders threads---------------------------------------------------------------------------------------- 
#declare Random_Tropfen = seed(101);
#macro Tropfen(Random_Tropfen) 
  sphere{<0,0,0> (0.5+rand(Random_Tropfen)/2)*0.03
  interior{ ior 1.33 }
  texture{Tau}}
#end

#declare Spinnen_Faden_Dicke = 0.0015;
#declare Spinnen_Faden_Random = seed(19);

#macro Spinnen_Kettfaden(Ecke1,Ecke2)
 cylinder{Ecke1,Ecke2,Spinnen_Faden_Dicke texture{Seide} }
 #local Counter = 0;
 #while(Counter< vlength(Ecke2-Ecke1))
  object{Tropfen(Random_Tropfen) translate Ecke1+ Counter/vlength(Ecke2-Ecke1) * (Ecke2-Ecke1) translate<0,-0.005,0>}
  #local Counter = Counter + 0.1+rand(Spinnen_Faden_Random)*0.2;
 #end
#end

#macro Spinnen_Fadenbogen(A,B,C,Radius,Steps)
 #local Mittelpunkt = Get_Mittelpunkt(A,B,C,Radius);
 #local phi = get_Winkel(A,Mittelpunkt,B);

 #local Counter = 0;
 #local PunktA = A;
 #while(Counter<Steps)
  #local PunktB = rotate_Winkel(PunktA,Mittelpunkt,B, phi/Steps);//vaxis_rotate(PunktA,vcross(A-M,B-M)+M,degrees(phi))
  cylinder{PunktA,PunktB,Spinnen_Faden_Dicke texture{Seide}}
  #local PunktA = PunktB ;
  #local Counter = Counter + 1;
 #end
#end 

#macro Spinnen_Fadenbogen_Tropfen(A,B,C,Radius,Steps)
 #local Mittelpunkt = Get_Mittelpunkt(A,B,C,Radius);
 #local phi = get_Winkel(A,Mittelpunkt,B);

 #local Counter = 0;
 #local PunktA = A;
 #local Abstand = 0;
 #while(Counter<Steps)
  #local PunktB = rotate_Winkel(PunktA,Mittelpunkt,B, phi/Steps);//vaxis_rotate(PunktA,vcross(A-M,B-M)+M,degrees(phi))
  #local Abstand = Abstand+vlength(PunktB-PunktA);
  cylinder{PunktA,PunktB,Spinnen_Faden_Dicke texture{Seide}}
  #if( Abstand > 0.1)
   object{Tropfen(Random_Tropfen) translate PunktA + (0.1-rand(Spinnen_Faden_Random)*0.1)/vlength(PunktB-PunktA)*(PunktB-PunktA)translate<0,-0.005,0>}
   #local Abstand = 0;
  #end
  #local PunktA = PunktB ;
  #local Counter = Counter + 1;
 #end
#end

//---Spiders Web---------------------------------------------------------------------------------------------
#macro Spinnen_Netz(Ecke1,Ecke2,Ecke3,Faeden1,Faeden2,Faeden3,Increment,Seed2,Random_Increment)
 union
 {
  //---------------------Middle of the net-----------------------------------------------------------------
  #local Mw12 = rotate_Winkel(Ecke1,Ecke3,Ecke2,get_Winkel(Ecke1,Ecke3,Ecke2)/2);
  #local Mw13 = rotate_Winkel(Ecke1,Ecke2,Ecke3,get_Winkel(Ecke1,Ecke2,Ecke3)/2);
  
  #local Mitte = Schnittpunkt( Mw12,Ecke3,Mw13,Ecke2);
  
  //---------------------Spokes-------------------------------------------------------------------------
  #local Punktarray=array[Faeden1+Faeden2+Faeden3+1]
  
  Spinnen_Kettfaden(Ecke1,Ecke2)
  
  #local Winkel = get_Winkel(Ecke1,Mitte,Ecke2);
  #local Winkel_Increment = Winkel/Faeden1;
  #local Winkel_Counter = 0;
  #local Counter = 0;
  #while(Counter <= Faeden1-1)
   #local Punktarray[Counter]=Schnittpunkt(Ecke1,Ecke2,Mitte,rotate_Winkel(Ecke1,Mitte,Ecke2, Winkel_Counter));
   Spinnen_Kettfaden(Punktarray[Counter],Mitte)
   #local Counter = Counter + 1;
   #local Winkel_Counter = Winkel_Counter+Winkel_Increment;
  #end 

  Spinnen_Kettfaden(Ecke2,Ecke3)

  #local Winkel = get_Winkel(Ecke2,Mitte,Ecke3);
  #local Winkel_Increment = Winkel/Faeden2;
  #local Winkel_Counter = 0;
  #local Counter = 0;
  #while(Counter <= Faeden2-1)
    #local Punktarray[Counter+Faeden1]=Schnittpunkt(Ecke2,Ecke3,Mitte,rotate_Winkel(Ecke2,Mitte,Ecke3, Winkel_Counter));
   Spinnen_Kettfaden(Punktarray[Counter+Faeden1],Mitte)
   #local Counter = Counter + 1;
   #local Winkel_Counter = Winkel_Counter+Winkel_Increment;
  #end 

  Spinnen_Kettfaden(Ecke3,Ecke1)

  #local Winkel = get_Winkel(Ecke3,Mitte,Ecke1);
  #local Winkel_Increment = Winkel/Faeden3;
  #local Winkel_Counter = 0;
  #local Counter = 0;
  #while(Counter <= Faeden3-1)
   #local Punktarray[Counter+Faeden2+Faeden1]=Schnittpunkt(Ecke3,Ecke1,Mitte,rotate_Winkel(Ecke3,Mitte,Ecke1, Winkel_Counter));//Ecke3 + Counter/Faeden3*(Ecke1-Ecke3);
   Spinnen_Kettfaden(Punktarray[Counter+Faeden2+Faeden1],Mitte)
   #local Counter = Counter + 1;
   #local Winkel_Counter = Winkel_Counter+Winkel_Increment;
  #end
  
  //--------------------Spiral 1------------------------------------------------------------------------ 
  #local R_Increment = seed(Seed2);
  #local Netz_Abstand = (Increment+(rand(R_Increment)-0.5)*Random_Increment)/8;
  #local Faden = Punktarray[0];
  #local Netzecke1 = Mitte+ Netz_Abstand/vlength(Faden-Mitte)*(Faden-Mitte);
  #local Netz_Abstand = Netz_Abstand+(Increment+(rand(R_Increment)-0.5)*Random_Increment)/8;
  #local Faden = Punktarray[1];
  #local Netzecke2 = Mitte+ Netz_Abstand/vlength(Faden-Mitte)*(Faden-Mitte);
  #local Counter = 1;
  
  #while(Netz_Abstand<=vlength(Faden-Mitte)/8)
   Spinnen_Fadenbogen(Netzecke1,Netzecke2,Netzecke1+<0,2,0>,12,10)
   #local Netz_Abstand = Netz_Abstand+(Increment+(rand(R_Increment)-0.5)*Random_Increment)/8;
   #local Counter = Counter +1 ;
   
   #if(Counter=Faeden1+Faeden2+Faeden3)
    #local Counter = 0;
   #end
   #local Faden = Punktarray[Counter];
   #local Netzecke1 = Netzecke2;
   #local Netzecke2 = Mitte+ Netz_Abstand/vlength(Faden-Mitte)*(Faden-Mitte);
  #end
  //--------------Spiral 2----------------------------------------------------------------------------------------
  #local Netz_Abstand = Netz_Abstand+(Increment+(rand(R_Increment)-0.5)*Random_Increment)*3;
  #local Faden = Punktarray[0];
  #local Netzecke1 = Mitte+ Netz_Abstand/vlength(Faden-Mitte)*(Faden-Mitte);
  #local Netz_Abstand = Netz_Abstand+Increment+(rand(R_Increment)-0.5)*Random_Increment;
  #local Faden = Punktarray[1];
  #local Netzecke2 = Mitte+ Netz_Abstand/vlength(Faden-Mitte)*(Faden-Mitte);
  #local Counter = 1;
  
  #local Weiterung = 0.0001;
  
  #while(Netz_Abstand<=vlength(Faden-Mitte))
   Spinnen_Fadenbogen_Tropfen(Netzecke1,Netzecke2,Netzecke1+<0,2,0>,12,10)
   #local Netz_Abstand = Netz_Abstand+Increment+(rand(R_Increment)-0.5)*Random_Increment+Weiterung;
   #local Weiterung =Weiterung+0.0001;
   #local Counter = Counter +1 ;
   
   #if(Counter=Faeden1+Faeden2+Faeden3)
    #local Counter = 0;
   #end
   #local Faden = Punktarray[Counter];
   #local Netzecke1 = Netzecke2;
   #local Netzecke2 = Mitte+ Netz_Abstand/vlength(Faden-Mitte)*(Faden-Mitte);
  #end
 }
#end
