// textures

#declare LightsOn = 1;

#declare BodyTxt = texture{
	pigment{color rgb<0.64, 0, 0.05>}
	finish{
		ambient 0 
		diffuse 0.7 
		phong 0.8 
		reflection 0.3
	}
} 

#declare BumperTxt = texture{
	pigment{color rgb<0.3, 0, 0.03>}
	finish{
		ambient 0 
		diffuse 0.7 
		phong 0.8 
		reflection 0.3
	}
}

#declare TireTxt = texture{
	pigment{color rgb 0.3}
	finish{
		ambient 0.1 
		diffuse 0.7 
		phong 0.3
	}
}

#declare WheelDiskTxt = texture{
	pigment{color rgb <0.45, 0.46, 0.47>}
	finish {
    	ambient 0.1
    	diffuse 0.7
    	brilliance 5
    	metallic
    	specular 0.8
    	roughness 0.01
    	reflection 0.7
	}
}

#declare PlateTxt = texture{
	pigment{
	    image_map{
	        png "plate.png"
	        map_type 0
	        once 
	        filter 0, 1 
		    interpolate 2
	    }
	    translate<-0.5, -0.5, 0>
	    scale<0.79, 0.16, 1>
	    rotate y*90
	}
	finish{ambient 0.45 phong 0.5}
}

#declare StripesTxt = texture{
	BodyTxt
}

#declare WindShieldTxt = texture{
	pigment{color rgbf<0.9, 0.9, 0.91, 0.95>}
	finish{ambient 0 phong 1 reflection 0.05}
}

#declare WheelTxt = texture{
	pigment{color rgb 0.2}
	finish{ambient 0.1 phong 0.6}
} 

#declare InteriorTxt = texture{
	pigment{color rgb<1, 0.8, 0.7>}
	finish{ambient 0.15 diffuse 0.7 phong 0}
}

#declare SeatTxt = texture{
	pigment{color rgb<1, 0.8, 0.7>}
	finish{ambient 0.08 phong 0.2}
}

#declare AntennaTxt = texture{
	WheelDiskTxt
}

#declare FrontGridTxt = texture{
	WheelDiskTxt
}

#declare LightFrameTxt = texture{
	WheelDiskTxt
} 

#declare FrontLightWhiteGlassTxt = texture{
	pigment{color rgbf <0.94, 0.94, 0.96, 0.94>}
	finish{
		ambient 0.12 
		diffuse 0.7 
		phong 0.8 
		reflection 0.1
	}
}

#declare FrontLightOrangeGlassTxt = texture{
	pigment{color rgbf<1, 0.8, 0, 0.8>}
	finish{
		ambient 0.12 
		diffuse 0.7 
		phong 0.8 
		reflection 0.1
	}
}

#declare BackLightRedGlassTxt = texture{
	pigment{color rgb<0.8, 0.2, 0.2>}
	finish{
		ambient 0.12 
		diffuse 0.7 
		phong 0.8 
		reflection 0.1
	}
}

#declare BackLightOrangeGlassTxt = texture{
	pigment{color rgb<1, 0.8, 0>}
	finish{
		ambient 0.12 
		diffuse 0.7 
		phong 0.8 
		reflection 0.1
	}
}

#declare BackLightWhiteGlassTxt = texture{
	pigment{color rgb 0.95}
	finish{
		ambient 0.12 
		diffuse 0.7 
		phong 0.8 
		reflection 0.1
	}
}

#declare ReflectorTxt = texture{ 
    pigment{color rgb 0.7}
	finish {
    	ambient 0.2
    	brilliance 6
    	metallic
    	specular 0.8
    	roughness 0.01
    	reflection 0.85
	}
} 

#declare BulbTxt = texture{
	pigment{color rgb 1}
	finish{
		ambient 0.4 
		phong 1 
		reflection 0.1
	}
}

#declare FrontBody = difference {
		union{       
		    union{
				// bumper right  
				torus{0.25, 0.1 translate<-0.75, 0.85, 0.25>}
				cylinder{<-0.75, 0.65, 0.25>, <-0.75, 0.95, 0.25>, 0.25}
				cylinder{<-0.75, 0.85, 0>, <2, 0.85, 0>, 0.1}           
			
				box{<-0.75, 0.65, -0.1>, <2, 0.85, 1>}
				cylinder{<-0.75, 0.65, 0.25>, <-0.75, 0.85, 0.25>, 0.35}
			
				difference{
			    	sphere{0, 0.35 translate<-0.75, 0.65, 0.25>}
			    	plane{-y, -0.65}
				}
				cylinder{0, <2.75, 0, 0>, 0.35 translate<-0.75, 0.65, 0.25>}
			
				// bumper left  
				torus{0.25, 0.1 translate<-0.75, 0.85, 0.25 + 3 - 0.5>}
				cylinder{<-0.75, 0.65, 0.25 + 3 - 0.5>, <-0.75, 0.95, 0.25 + 3 - 0.5>, 0.25}
				cylinder{<-0.75, 0.85, 0>, <2, 0.85, 0>, 0.1 translate z*3}           
			
				box{<-0.75, 0.65, -0.1>, <2, 0.85, 3.1>}
				cylinder{<-0.75, 0.65, 0.25 + 3 - 0.5>, <-0.75, 0.85, 0.25 + 3 - 0.5>, 0.35}
			
				difference{
			    	sphere{0, 0.35 translate<-0.75, 0.65, 0.25 + 3 - 0.5>}
			    	plane{-y, -0.65}
				}
				cylinder{0, <2.75, 0, 0>, 0.35 translate<-0.75, 0.65, 0.25 + 3 - 0.5>}
				
				// front bumper  
		    	cylinder{<-1, 0.85, 0.25>, <-1, 0.85, 3 - 0.25>, 0.1}
		    	box{<-1, 0.85, 0.25>, <-0.5, 0.95, 3 - 0.25>} 
		    	box{<-1.1, 0.65, 0.25>, <-0.8, 0.85, 3 - 0.25>} 
		    	difference{
		        	cylinder{0, <0, 0, 1.25+1.25>, 1 scale<0.35, 0.35, 1> translate<-0.75, 0.65, 0.25>}
		        	plane{-y, 0 translate y*0.65}
		    	}
				
				texture{BumperTxt}
			}
			
			union{
				// wing right
				difference {
					box{<-0.75, 0.5, 0>, <2, 1.7, 1.5>}
					plane{-y, 0 rotate z*5 translate<-0.75, 1.25, 0>}
				}
			
				difference{
					cylinder{<0, 0.5, -0.1>, <0, 0.5, 1>, 0.75}
					plane{y, 0.65}
					torus{0.75, 0.1 rotate x*90 translate<0, 0.5, -0.1>}
				}
			
				// wing left
				difference {
					box{<-0.75, 0.5, 0>, <2, 1.7, 1.5>}
					plane{-y, 0 rotate z*5 translate<-0.75, 1.25, 0>}
					translate z*1.5
				}
			
				difference{
					cylinder{<0, 0.5, -0.1>, <0, 0.5, 1>, 0.75}
					plane{y, 0.65}
					torus{0.75, 0.1 rotate x*90 translate<0, 0.5, -0.1>}
					rotate y*180
					translate z*3
				}
				
				// corner right
				cylinder{<-0.75, 0.5, 0.15>, <-0.75, 1.25, 0.15>, 0.15}
				sphere{<-0.75, 1.25, 0.15>, 0.15}
				cylinder{0, <2.75, 0, 0>, 0.15 rotate z*5 translate <-0.75, 1.25, 0.15>} 
			
				// corner left
				cylinder{<-0.75, 0.5, 0.15 + 3 - 0.3>, <-0.75, 1.25, 0.15 + 3 - 0.3>, 0.15}
				sphere{<-0.75, 1.25, 0.15 + 3 - 0.3>, 0.15}
				cylinder{0, <2.75, 0, 0>, 0.15 rotate z*5 translate <-0.75, 1.25, 0.15 + 3 - 0.3>}
			
				// front
				box{<-1, 0.85, 0.25>, <-0.8, 0.95, 3 - 0.25>}
				cylinder{<-0.75, 1.25, 0.15>, <-0.75, 1.25, 3 - 0.15>, 0.15}
				box{<-0.9, 0.95, 0.15>, <-0.5, 1.25, 3 - 0.15>}
				difference{
			    	box{<-0.75, 1.2, 0.15>, <2, 1.7, 3 - 0.15>}
			    	plane{-y, 0 rotate z*5 translate <-0.75, 1.4, 0>}
				}
				
				// top 			
		    	merge{ 
		        	cylinder{<-0.002, 0, 0.03>, <3, 0, 0.03>, 0.03} 
		        	cylinder{<-0.17, 0, 0>, <3, 0, 0>, 0.03 rotate -y*14 translate z*0.03 translate z*(1.2)}
		        	difference{
		            	box{<-0.2, -0.3, 0.03>, <3, 0.03, 2>}
		            	plane{x, 0 rotate -y*7}            
		            	plane{-z, 0 rotate -y*14 translate z*(1.2+0.03)}
		        	}
		        	union{  
		            	cylinder{<0, 0, 0.03>, <0, 0, 1.2>, 0.18} 
		            	box{<-0.18, -0.15, 0.03>, <-0.1, 0, 1.2> rotate -z*5}
		            	box{<-0.18, -0.27, 0.15>, <-0.1, -0.15, 1.2-0.12> rotate -z*5}
		            	difference{
		                	cylinder{<-0.18, -0.15, 0.15>, <-0.1, -0.15, 0.15>, 0.12 rotate -z*5}
		                	plane{-y, 0 rotate -z*5 translate -y*0.15}
		                	plane{-z, 0 translate z*0.15}
		            	}
		            	difference{
		                	cylinder{<-0.18, -0.15, 0>, <-0.1, -0.15, 0>, 0.12 rotate -z*5}
		                	plane{-y, 0 rotate -z*5 translate -y*0.15}
		                	plane{z, 0}
		                	translate z*(1.2-0.12)
		            	}
		            	difference{
		                	torus{0.12, 0.03 rotate z*90 translate<-0.18+0.03, -0.15, 0.15> rotate -z*5}
		                	plane{-y, 0 rotate -z*5 translate -y*0.15}
		                	plane{-z, 0 translate z*0.15}
		            	}
		            	difference{
		                	torus{0.12, 0.03 rotate z*90 translate<-0.18+0.03, -0.15, 0.15> rotate -z*5}
		                	plane{-y, 0 rotate -z*5 translate -y*0.15}
		                	plane{z, 0 translate z*0.15}
		                	translate z*(1.2-0.24-0.03)
		            	}
			            
		            	cylinder{<-0.18+0.03, -0.15, 0.03>, <-0.18+0.03, 0, 0.03>, 0.03 rotate -z*5}
		            	cylinder{<-0.18+0.03, -0.15, 0.03>, <-0.18+0.03, 0, 0.03>, 0.03 rotate -z*5 translate z*(1.2-0.03)}
			             
		            	cylinder{<-0.15, -0.27, 0.15>, <-0.15, -0.27, 1.2-0.12>, 0.03 rotate -z*5} 
			            
		            	difference{
		                	torus{0.15, 0.03 rotate x*90}
		                	plane{-x, 0}
		                	plane{y, 0} 

		                	translate<0, 0, 0.03>
		            	}
		            	difference{
		                	torus{0.15, 0.03 rotate x*90}
		                	plane{-x, 0}
		                	plane{y, 0} 

		                	translate<0, 0, 1.2>
		            	}
			            
		            	rotate -y*7 translate -y*0.15
		        	}
		        	rotate z*5 translate<0, 0.15, 0> 
			    	translate x*0.15 rotate y*7 translate -x*0.15
			    	translate<-0.9+0.15, 1.25, 0.9>
				}
				
				texture{BodyTxt}
			}
			
			union{
				// wing smooth right
				difference {
					union{
						torus{0.63, 0.02 rotate x*90 translate<0, 0.5, -0.1>} 
						torus{0.57, 0.02 rotate x*90 translate<0, 0.5, -0.1>}
						difference{
							cylinder{<0, 0.5, -0.12>, <0, 0.5, 1>, 0.63}
							cylinder{<0, 0.5, -1>, <0, 0.5, 2>, 0.57}
						}
					}         
					plane{y, 0.63}           
				}
			
				// wing smooth left
				difference {
					union{
						torus{0.63, 0.02 rotate x*90 translate<0, 0.5, -0.1>} 
						torus{0.57, 0.02 rotate x*90 translate<0, 0.5, -0.1>}
						difference{
							cylinder{<0, 0.5, -0.12>, <0, 0.5, 1>, 0.63}
							cylinder{<0, 0.5, -1>, <0, 0.5, 2>, 0.57}
						}
					}         
					plane{y, 0.63}
					rotate y*180
					translate z*3           
				}
			
				// stripes
				difference{
					union{
						cylinder{<-0.75, 0.65, -0.1>, <2, 0.65, -0.1>, 0.02} 
						cylinder{<-0.75, 0.65, -0.1>, <2, 0.65, -0.1>, 0.02 translate z*3.2}
					
						cylinder{<-0.75, 0.75, -0.1>, <2, 0.75, -0.1>, 0.02} 
						cylinder{<-0.75, 0.75, -0.1>, <2, 0.75, -0.1>, 0.02 translate z*3.2}
					
						torus{0.35, 0.02 translate<-0.75, 0.65, 0.25>}
						torus{0.35, 0.02 translate<-0.75, 0.65, 3-0.25>}
					
						torus{0.35, 0.02 translate<-0.75, 0.75, 0.25>}
						torus{0.35, 0.02 translate<-0.75, 0.75, 3-0.25>}
					
						cylinder{<-1.1, 0.65, 0.25>, <-1.1, 0.65, 3-0.25>, 0.02}
						cylinder{<-1.1, 0.75, 0.25>, <-1.1, 0.75, 3-0.25>, 0.02}
					
						box{<-1.12, 0.65, 0.25>, <-1, 0.75, 3-0.25>} 
					
						// for plate
						cylinder{<-1.14, 0.6, 1.1>, <-1.14, 0.6, 3-1.1>, 0.01}
						cylinder{<-1.14, 0.8, 1.1>, <-1.14, 0.8, 3-1.1>, 0.01}
						box{<-1.135, 0.6, 1.1>, <-1, 0.8, 3-1.1>}
						difference{
			            	torus{0.05, 0.01 rotate z*90}
			            	plane{-z, 0}
			            	plane{y, 0}
			            	translate<-1.14, 0.8-0.05, 1.1>
			        	} 
			        	difference{
			            	torus{0.05, 0.01 rotate z*90}
			            	plane{-z, 0}
			            	plane{-y, 0}
			            	translate<-1.14, 0.6+0.05, 1.1>
			        	} 
			        	difference{
			            	torus{0.05, 0.01 rotate z*90}
			            	plane{-z, 0}
			            	plane{y, 0}
			            	rotate y*180
			            	translate<-1.14, 0.8-0.05, 3-1.1>
			        	} 
			        	difference{
			            	torus{0.05, 0.01 rotate z*90}
			            	plane{-z, 0}
			            	plane{-y, 0} 
			            	rotate y*180
			            	translate<-1.14, 0.6+0.05, 3-1.1>
			        	}
			        	cylinder{<-1.14, 0.6+0.05, 1.1-0.05>, <-1.14, 0.8-0.05, 1.1-0.05>, 0.01} 
			        	cylinder{<-1.14, 0.6+0.05, 3-1.1+0.05>, <-1.14, 0.8-0.05, 3-1.1+0.05>, 0.01}
			        	box{<-1.135, 0.65, 1.1-0.05>, <-0.9, 0.75, 1.1>}
			        	box{<-1.135, 0.65, 3-1.1+0.05>, <-0.9, 0.75, 3-1.1>}
			        	cylinder{<-1.135, 0.65, 1.1>, <-0.9, 0.65, 1.1>, 0.05}
			        	cylinder{<-1.135, 0.75, 1.1>, <-0.9, 0.75, 1.1>, 0.05}
			        	cylinder{<-1.135, 0.65, 3-1.1>, <-0.9, 0.65, 3-1.1>, 0.05}
			        	cylinder{<-1.135, 0.75, 3-1.1>, <-0.9, 0.75, 3-1.1>, 0.05}
					}
					cylinder{<0, 0.5, -6>, <0, 0.5, 6>, 0.57}
					cylinder{<4.8, 0.5, -6>, <4.8, 0.5, 6>, 0.57}          
				}
			
				texture{StripesTxt}
			}			
		}
		
		// cut
		union{
			// for right wheel
			union{
				cylinder{<0, 0.5, -1>, <0, 0.5, 0.5>, 0.55} 
				box{<-0.55, -1, -1>, <0.55, 0.5, 0.5>}
			}
		
			// for left wheel
			union{
				cylinder{<0, 0.5, -1>, <0, 0.5, 0.5>, 0.55} 
				box{<-0.55, -1, -1>, <0.55, 0.5, 0.5>}
				rotate y*180
				translate z*3
			}
		
			// low front holes
			union{
		    	cylinder{<-2, 0.48, 0.5>, <-0.6, 0.48, 0.5>, 0.1}
		    	box{<-2, 0.38, 0.5>, <-0.6, 0.58, 3-0.5>}
		    	cylinder{<-2, 0.48, 0.5>, <-0.6, 0.48, 0.5>, 0.1 translate z*2}
			}
		
			// for right light
			union{
		    	cylinder{0, <0.6, 0, 0>, 0.07}
		    	cylinder{0, <0.6, 0, 0>, 0.07 translate -y*0.12}
		    	box{<0, -0.12, -0.07>, <0.65, 0, 0.07>}    
		    
		    	// big box
		    	box{<0, -0.19, 0>, <0.65, 0.07, -1>} 
		    
		    	cylinder{<0.65, 0, 0>, <0.65, 0, -1>, 0.07}
		    	cylinder{<0.65, 0, 0>, <0.65, 0, -1>, 0.07 translate -y*0.12} 
		    	box{<0.65-0.07, -0.12, 0>, <0.65+0.07, 0, -1>}
		    
		    	sphere{0, 0.07 translate<0.6, 0, 0>}
		    	sphere{0, 0.07 translate<0.6, 0, 0> translate -y*0.12}
		    
		    	translate<-1.35, 1.18, 0.7>
			}
		
			// for left light
			union{
		    	cylinder{0, <0.6, 0, 0>, 0.07}
		    	cylinder{0, <0.6, 0, 0>, 0.07 translate -y*0.12}
		    	box{<0, -0.12, -0.07>, <0.65, 0, 0.07>}    
		    
		    	// big box
		    	box{<0, -0.19, 0>, <0.65, 0.07, -1>} 
		    
		    	cylinder{<0.65, 0, 0>, <0.65, 0, -1>, 0.07}
		    	cylinder{<0.65, 0, 0>, <0.65, 0, -1>, 0.07 translate -y*0.12} 
		    	box{<0.65-0.07, -0.12, 0>, <0.65+0.07, 0, -1>}
		    
		    	sphere{0, 0.07 translate<0.6, 0, 0>}
		    	sphere{0, 0.07 translate<0.6, 0, 0> translate -y*0.12}
		    
		    	translate y*0.06 rotate x*180 translate -y*0.06
		    
		    	translate<-1.35, 1.18, 3-0.7>
			} 
		
			// for radiator
			merge{
		    	box{<0, -0.17, 0>, <0.8, 0.07, -0.5>} 
		    
		    	cylinder{0, <0.8, 0, 0>, 0.07 translate -z*0.5}
		    	cylinder{0, <0.8, 0, 0>, 0.07 translate -y*0.1 translate -z*0.5}
		    	box{<0, -0.1, -0.07>, <0.8, 0, 0.07> translate -z*0.5}
		    
		    	union{
		        	box{<0, -0.17, 0>, <0.8, 0.07, -0.5>} 
		    
		        	cylinder{0, <0.8, 0, 0>, 0.07 translate -z*0.5}
		        	cylinder{0, <0.8, 0, 0>, 0.07 translate -y*0.1 translate -z*0.5}
		        	box{<0, -0.1, -0.07>, <0.8, 0, 0.07> translate -z*0.5}
		        
		        	translate y*0.05 rotate x*180 translate -y*0.05 translate -z*0.2
		    	}
		    
		    	translate<-1.4, 1.18, 1.6>
			}
		
			// for glass        
        	merge{ 
            	cylinder{0, <0, 3, 0>, 1.4 scale<0.3, 1, 1>}
            	box{<0, 0, -1.4>, <1, 3, 1.4>}
            	rotate z*20
            	translate<1.3, 1.55, 0>
            	translate z*1.5
        	}
        
        	// for right door
        	box{<1.29, 0.65, -3>, <1.5, 2, 0.1>}
        
        	// for left door
        	box{<1.29, 0.65, 0.1>, <1.5, 2, 3> translate z*2.8}
        
        	// for top
        	union{
            	difference{
                	cylinder{0, <0, 4, 0>, 0.2} 
                	cylinder{<0, -2, 0>, <0, 6, 0>, 0.19}
                	plane{-z, 0}
                	plane{-x, 0} 
                
                	translate<0.2, 0, 0.2> 
                	rotate z*7 
                	translate z*0.3 
            	} 
            	difference{
                	cylinder{0, <0, 4, 0>, 0.2} 
                	cylinder{<0, -2, 0>, <0, 6, 0>, 0.19}
                	plane{z, 0}
                	plane{-x, 0} 
                
                	translate<0.2, 0, 0.2> 
                	rotate z*7 
                	translate z*2.3 
            	}
            
            	box{<0.2, 0, -0.01/2>, <4, 5, 0.01/2> rotate z*7 translate z*0.3} 
            	box{<0.2, 0, -0.01/2>, <4, 5, 0.01/2> rotate z*7 translate z*2.7}
            
            	difference{
                	box{<-0.01/2, 0, 0.5>, <0.01/2, 5, 2.5> rotate z*7}
                	box{<-1, -1, 0.884>, <3, 3, 3-0.884>}
            	}
            
            	translate<-0.75, 1.2, 0>
        	}
        	
        	texture{BodyTxt}
        }
        						
	translate -z*1.5
}

#declare Plate = merge{
	box{<-0.01, -0.17/2, -0.4+0.035>, <0, 0.17/2, 0.4-0.035>}
    cylinder{<-0.01, (0.17/2)-0.035, 0.4-0.035>, <0, (0.17/2)-0.035, 0.4-0.035>, 0.035} 
    cylinder{<-0.01, -(0.17/2)+0.035, 0.4-0.035>, <0, -(0.17/2)+0.035, 0.4-0.035>, 0.035}
    cylinder{<-0.01, (0.17/2)-0.035, -0.4+0.035>, <0, (0.17/2)-0.035, -0.4+0.035>, 0.035} 
    cylinder{<-0.01, -(0.17/2)+0.035, -0.4+0.035>, <0, -(0.17/2)+0.035, -0.4+0.035>, 0.035}
    box{<-0.01, -0.17/2+0.035, -0.4+0.035>, <0, 0.17/2-0.035, -0.4>}
    box{<-0.01, -0.17/2+0.035, 0.4-0.035>, <0, 0.17/2-0.035, 0.4>}

	texture{PlateTxt}
}                  

#declare BottomGrid = union{
	cylinder{<0, 0, 0.7-0.3>, <0, 0, 2.3+0.3>, 0.1 scale <1, 0.2, 1> translate<-0.9, 0.48, 0>}
	sphere{0, 0.23 scale<1, 1, 0.14> translate<-0.85, 0.58, 0.7>}
	sphere{0, 0.23 scale<1, 1, 0.14> translate<-0.85, 0.58, 1>}
	sphere{0, 0.23 scale<1, 1, 0.14> translate<-0.85, 0.58, 1.3>}
	sphere{0, 0.23 scale<1, 1, 0.14> translate<-0.85, 0.58, 1.7>}
	sphere{0, 0.23 scale<1, 1, 0.14> translate<-0.85, 0.58, 2>}
	sphere{0, 0.23 scale<1, 1, 0.14> translate<-0.85, 0.58, 2.3>}
	translate -z*1.5
	    
	texture{BodyTxt}
}

#declare FrontLightFrame = difference{
    union{
        cylinder{0, <0, 0, -0.55>, 0.02} 
        cylinder{0, <0, 0, -0.55>, 0.02 translate -y*0.26}
        difference{
            torus{0.07, 0.02 rotate z*90}
            plane{y, 0}
            plane{z, 0}
            translate -y*0.07
        }
        difference{
            torus{0.07, 0.02 rotate z*90}
            plane{y, 0}
            plane{z, 0}
            rotate z*180
            translate -y*(0.07 + 0.12)
        }
        cylinder{<0, -0.07, 0.07>, <0, -0.19, 0.07>, 0.02}
        difference{
            torus{0.15, 0.02}
            plane{-x, 0}
            plane{-z, 0}
            translate <0.15, 0, -0.55>
        }
        difference{
            torus{0.15, 0.02}
            plane{-x, 0}
            plane{-z, 0}
            translate <0.15, -0.26, -0.55>
        }
        cylinder{<0, -0.07, 0>, <0, -0.19, 0>, 0.02 translate<0.27, 0, -0.7>}
        difference{
            torus{0.07, 0.02 rotate x*90}
            plane{y, 0}
            plane{x, 0}
            translate<0.2, -0.07, -0.7>
        } 
        difference{
            torus{0.07, 0.02 rotate x*90}
            plane{y, 0}
            plane{x, 0}
            rotate x*180
            translate<0.2, -0.19, -0.7>
        }
        cylinder{0, <0.05, 0, 0>, 0.02 translate<0.15, 0, -0.7>}
        cylinder{0, <0.05, 0, 0>, 0.02 translate<0.15, -0.26, -0.7>}
    }
	    
    // for light
	merge{
	    cylinder{0, <0.6, 0, 0>, 0.07}
	    cylinder{0, <0.6, 0, 0>, 0.07 translate -y*0.12}
	    box{<0, -0.12, -0.07>, <0.65, 0, 0.07>}    
		    
	    // big box
	    box{<0, -0.19, 0>, <0.65, 0.07, -1>} 
		    
	    cylinder{<0.65, 0, 0>, <0.65, 0, -1>, 0.07}
	    cylinder{<0.65, 0, 0>, <0.65, 0, -1>, 0.07 translate -y*0.12} 
	    box{<0.65-0.07, -0.12, 0>, <0.65+0.07, 0, -1>}
		    
	    sphere{0, 0.07 translate<0.6, 0, 0>}
	    sphere{0, 0.07 translate<0.6, 0, 0> translate -y*0.12}

	    translate<-0.45, -0.07, 0>
	}

	translate<-0.9, 0.13, 0>				          
    texture{LightFrameTxt}
}    

#declare FrontLight = union{
	object{FrontLightFrame}
	// orange glass
	merge{
	    box{<0, -0.26, 0>, <0.05, 0, 0.02>} 
	    box{<0.05, -0.26+0.07, 0>, <0.05+0.07, -0.07, 0.02>}
	    difference{
	        union{
	            cylinder{<0.05, -0.07, 0>, <0.05, -0.07, 0.02>, 0.07}
	            cylinder{<0.05, -0.26+0.07, 0>, <0.05, -0.26+0.07, 0.02>, 0.07}
	        }   
	        plane{x, 0.05}
	    }
	    
	    texture{FrontLightOrangeGlassTxt}
	    
	    translate<-0.75, 0.13, -0.7>
	}
	// white glass
	merge{
	    box{<0, -0.26, 0.1499>, <0.01, 0, 0.7>}
	    box{<0, -0.26+0.07, 0.7>, <0.01, -0.07, 0.77>}
	    cylinder{<0, -0.26+0.07, 0.7>, <0.01, -0.26+0.07, 0.7>, 0.07} 
	    cylinder{<0, -0.07, 0.7>, <0.01, -0.07, 0.7>, 0.07}
	    difference{
	        cylinder{<0.15, -0.26, 0.15>, <0.15, 0, 0.15>, 0.15}
	        cylinder{<0.15, -0.3, 0.15>, <0.15, 0.3, 0.15>, 0.14}
	        plane{-z, 0 translate z*0.15}
	        plane{-x, 0 translate x*0.15}
	    }
	    
	    texture{FrontLightWhiteGlassTxt}
	    
	    translate<-0.9, 0.13, -0.7>
	}
	// reflector
	difference{
	    merge{
	         box{<0.01, -0.26, 0.15>, <0.3, 0, 0.9>}
	         difference{
	            cylinder{0, <0, -0.26, 0>, 0.29 scale<1, 1, 0.4> translate<0.3, 0, 0.15>}
	            plane{-x, 0 translate x*0.3}
	         }
	    }
	    cylinder{<0, 0, -2>, <0, 0, 0.8>, 0.14 scale<0.6, 1, 1> rotate -y*3 translate<0.01, -0.13, 0>}
	    sphere{0, 0.12 scale<1, 1, 1.2> translate<0, -0.13, 0.55>}
	    sphere{0, 0.12 scale<1, 1, 1.2> translate<0.015, -0.13, 0.28>}
	    sphere{0, 0.12 scale<1.8, 0.7, 0.6> rotate y*6 translate<0.2, -0.13, 0.015>}
	    
	    texture{ReflectorTxt}
	    
	    translate<-0.9, 0.13, -0.7>
	}       
	// bulbs       
	#if(LightsOn = 1)  
		union{
			light_source {
				<0, 0, 0.55> color rgb 1.1
				looks_like{sphere{0, 0.05 pigment{color rgb 1.5} finish{ambient 1}}}                 
			}
			light_source {
				<0, 0, 0.28> color rgb 1.1
				looks_like{sphere{0, 0.05 pigment{color rgb 1.5} finish{ambient 1}}}                 
			}
			translate<-0.8, 0, -0.7>     
		}
    #else
		union{
			sphere{0, 0.05 translate<0, 0, 0.55>} 
			sphere{0, 0.05 translate<0.015, 0, 0.28>}
			sphere{0, 0.04 translate<0.14, 0, 0.1>} 

			texture{BulbTxt}
			translate<-0.8, 0, -0.7>
		}	
	#end
}                   

#declare FrontGrid = union {
    cylinder{<-0.02, 0, 0.3>, <-0.02, 0, -0.5>, 0.02} 
    cylinder{<-0.02, 0, 0.3>, <-0.02, 0, -0.5>, 0.02 translate -y*0.24}
        
    difference{
        torus{0.07, 0.02 rotate z*90}
        plane{y, 0}
        plane{-z, 0}
        translate<-0.02, -0.07, -0.5>
    }
    difference{
        torus{0.07, 0.02 rotate z*90}
        plane{y, 0}
        plane{-z, 0}
        rotate z*180
        translate<-0.02, -0.17, -0.5>
    }
        
    difference{
        torus{0.07, 0.02 rotate z*90}
        plane{y, 0}
        plane{-z, 0}
        rotate y*180
        translate<-0.02, -0.07, 0.3>
    }
    difference{
        torus{0.07, 0.02 rotate z*90}
        plane{y, 0}
        plane{-z, 0}
        rotate z*180
        rotate y*180
        translate<-0.02, -0.17, 0.3>
    }
       
    cylinder{<-0.02, -0.07, -0.57>, <-0.02, -0.17, -0.57>, 0.02}
    cylinder{<-0.02, -0.07, 0.37>, <-0.02, -0.17, 0.37>, 0.02}
        
    union{  
        #local num = 22;
        #local cnt = 0;
	    #while (cnt < num)   
            cylinder{0, <0, -0.24, 0>, 0.02 scale <2, 1, 0.65> translate -z*(0.522 - 0.04*cnt)}
           	#local cnt = cnt + 1;
	    #end 
    }
   		
	texture{FrontGridTxt}
	translate<-0.9, 1.18+0.07, 0.1>                                                                      	
}

#declare Wheel = union{
    // tire
    difference{
        merge{
            torus{0.4, 0.1 rotate x*90 translate -z*0.1}
            torus{0.4, 0.1 rotate x*90 translate z*0.1}
            torus{0.35, 0.1 rotate x*90 translate -z*0.1}
            torus{0.35, 0.1 rotate x*90 translate z*0.1}
            difference{
                cylinder{<0, 0, -0.2>, <0, 0, 0.2>, 0.4}
                cylinder{<0, 0, -2>, <0, 0, 2>, 0.35}
            }
            difference{
                cylinder{<0, 0, -0.1>, <0, 0, 0.1>, 0.5}
                cylinder{<0, 0, -2>, <0, 0, 2>, 0.25}
            }
        }
        difference{
            cylinder{<0, 0, -0.008>, <0, 0, 0.008>, 1}
            cylinder{<0, 0, -2>, <0, 0, 2>, 0.494}
        }
        difference{
            cylinder{<0, 0, -0.008>, <0, 0, 0.008>, 1}
            cylinder{<0, 0, -2>, <0, 0, 2>, 0.494}
            translate z*0.05
        }
        difference{
            cylinder{<0, 0, -0.008>, <0, 0, 0.008>, 1}
            cylinder{<0, 0, -2>, <0, 0, 2>, 0.494}
            translate -z*0.05
        }
        difference{
            cylinder{<0, 0, -0.008>, <0, 0, 0.008>, 1}
            cylinder{<0, 0, -2>, <0, 0, 2>, 0.494}
            translate z*0.1
        }
        difference{
            cylinder{<0, 0, -0.008>, <0, 0, 0.008>, 1}
            cylinder{<0, 0, -2>, <0, 0, 2>, 0.494}
            translate -z*0.1
        }
        union{              
            #local ang = 10;
            #local num = 360/ang;
            #local cnt = 0;
	        #while (cnt < num)
	            box{<-0.008, 0.475, -1>, <0.008, 2, 1> rotate z*ang*cnt}   
    	        #local cnt = cnt + 1;
	        #end 
        }
        
        texture{TireTxt}
    }
    
    // disk
    merge{ 
        cylinder{<0, 0, -0.14>, <0, 0, 0.14>, 0.3}
        intersection{
            torus{0.35, 0.101 rotate x*90 translate -z*0.1}
            cylinder{<0, 0, -1>, <0, 0, 1>, 0.35}
        }
        cylinder{0, <0, 0, -0.18>, 0.1}
        torus{0.1-0.03, 0.03 rotate x*90 translate -z*0.18}
        cylinder{0, <0, 0, -0.2>, 0.035}
        union{              
            #local ang = 20;
            #local num = 360/ang;
            #local cnt = 0;
	        #while (cnt < num)
	            cylinder{0, <0.3, 0, 0>, 0.01 rotate -y*10 translate <0.1-0.03, 0, -0.19> rotate z*ang*cnt}
    	        #local cnt = cnt + 1;
	        #end 
        }
        
        texture{WheelDiskTxt}
    }
}   

#declare Mirrors = union{
	// right mirror
    difference{
       	merge{
           	sphere{0, 0.1 translate z*0.05 scale<0.5, 1, 1>} 
           	sphere{<0, 0, -0.2>, 0.1 translate z*0.05 scale<0.5, 1, 1>}
           	cylinder{0, <0, 0, -0.2>, 0.1 translate z*0.05 scale<0.5, 1, 1>}
           	cylinder{0, <0, -0.4, 0>, 0.1 scale<0.7, 1, 0.6> rotate -z*50 rotate y*30}
       	} 
       	plane{-x, 0}
       	translate<1.55, 1.68, -1.53>
	}
	    
	// left mirror
    difference{
       	merge{
           	sphere{0, 0.1 translate -z*0.05 scale<0.5, 1, 1>} 
           	sphere{<0, 0, 0.2>, 0.1 translate -z*0.05 scale<0.5, 1, 1>}
           	cylinder{0, <0, 0, 0.2>, 0.1 translate -z*0.05 scale<0.5, 1, 1>}
           	cylinder{0, <0, -0.4, 0>, 0.1 scale<0.7, 1, 0.6> rotate -z*50 rotate -y*30}
       	} 
       	plane{-x, 0}
        
       	translate<1.55, 1.68, 1.53>
	}
		
	texture{BodyTxt}
}

#declare Front = union{
    difference {
        object{FrontBody}
        plane{-x, 0 translate x*1.3 texture{BodyTxt}}
    }
    object{Plate translate<-1.127, 0.7, 0>}
    object{FrontGrid}
    object{BottomGrid}
    object{FrontLight translate<0, 1.25-0.13, -0.8>}
    object{FrontLight rotate x*180 translate<0, 1.25-0.13, 0.8>}
    object{Mirrors}
}

#declare BackLightFrame = difference{
	merge{
		cylinder{<0, 0.1, 0.15>, <0, 0.1, 0.6>, 0.02} 
	    cylinder{<0, -0.1, 0.15>, <0, -0.1, 0.6>, 0.02}
	    difference{
	    	torus{0.05, 0.02 rotate z*90}
	        plane{y, 0}
	        plane{z, 0}
	        translate<0, 0.05, 0.6>
	    }
	    difference{
	    	torus{0.05, 0.02 rotate z*90}
	        plane{-y, 0}
	        plane{z, 0}
	        translate<0, -0.05, 0.6>
	    }
	    cylinder{<0, -0.05, 0.65>, <0, 0.05, 0.65>, 0.02}
	    difference{
	    	torus{0.15, 0.02}
	        plane{x, 0}
	        plane{-z, 0}
	        translate <-0.15, 0.1, 0.15>
	    } 
	    difference{
	    	torus{0.15, 0.02}
	        plane{x, 0}
	        plane{-z, 0}
	        translate <-0.15, -0.1, 0.15>
	    }
	    cylinder{<-0.2, 0.05, 0>, <-0.2, -0.05, 0>, 0.02}   	
	    difference{
	    	torus{0.05, 0.02 rotate x*90}
	        plane{y, 0}
	        plane{-x, 0}
	        translate<-0.15, 0.05, 0>
	    }
	    difference{
	    	torus{0.05, 0.02 rotate x*90}
	        plane{-y, 0}
	        plane{-x, 0}
	        translate<-0.15, -0.05, 0>
	    } 
	}
	merge{
   		cylinder{<-1, 0.05, 0.6>, <1, 0.05, 0.6>, 0.05}
		cylinder{<-1, -0.05, 0.6>, <1, -0.05, 0.6>, 0.05}
		box{<-1, 0.05, 0.4>, <1, -0.05, 0.65>}        
    	box{<-0.15, -0.1, -1>, <0.65, 0.1, 0.6>} 
	   	cylinder{<-0.15, 0.05, -1>, <-0.15, 0.05, 1>, 0.05}
	   	cylinder{<-0.15, -0.05, -1>, <-0.15, -0.05, 1>, 0.05} 
	   	box{<-0.2, -0.05, -1>, <0, 0.05, 1>}
	}
	texture{LightFrameTxt}
}

#declare BackLight = union{
	object{BackLightFrame}       
	
	// orange glass
	merge{
		difference{  
			merge{
				cylinder{<-0.15, 0.05, -0.01>, <-0.15, 0.05, 0.01>, 0.051}
	   			cylinder{<-0.15, -0.05, -0.01>, <-0.15, -0.05, 0.01>, 0.051}
	   			box{<-0.2, -0.05, -0.01>, <0, 0.05, 0.01>}
			}
			plane{-x, 0 translate -x*0.15}
		}
		difference{
			cylinder{<-0.15, -0.1, 0.15>, <-0.15, 0.1, 0.15>, 0.16} 
			cylinder{<-0.15, -0.2, 0.15>, <-0.15, 0.2, 0.15>, 0.149}
			plane{x, 0 translate -x*0.15}
			plane{-z, 0 rotate y*35 translate <-0.15, 0, 0.15>}
		}
		texture{BackLightOrangeGlassTxt}
	} 
	
	// red light
	merge{
		difference{
			cylinder{<-0.15, -0.1, 0.15>, <-0.15, 0.1, 0.15>, 0.16} 
			cylinder{<-0.15, -0.2, 0.15>, <-0.15, 0.2, 0.15>, 0.149}
			plane{x, 0 translate -x*0.15}
			plane{x, 0 rotate -y*55 translate<-0.15, 0, 0.15>}
			plane{-z, 0 translate z*0.15}
		}
		box{<-0.001, -0.1, 0.15>, <0.01, 0.1, 0.6>}
		box{<-0.001, -0.051, 0.599>, <0.01, 0.051, 0.65>}
		cylinder{<-0.001, -0.05, 0.6>, <0.01, -0.05, 0.6>, 0.051}
		cylinder{<-0.001, 0.05, 0.6>, <0.01, 0.05, 0.6>, 0.051}
		
		texture{BackLightRedGlassTxt}          
	}
	
	// white light
	box{<-0.01, -0.03, 0.2>, <0.012, 0.03, 0.45> texture{BackLightWhiteGlassTxt}}
}

#declare CenterAndBackBody = difference{
    union{
        // body
        union{
        	difference{
            	box{<1.3, 0.5, -1.5>, <6, 1.43, 1.5>}
            
            	// for right handle
	        	sphere{0, 0.2 scale<1, 0.3, 0.15> translate<2.8, 1.35, -1.5>} 
	
	        	// for left handle
	        	sphere{0, 0.2 scale<1, 0.3, 0.15> translate<2.8, 1.35, 1.5>}			
        	}
    
	    	difference{
		    	cylinder{<0, 0.5, -0.1>, <0, 0.5, 1>, 0.75}
		    	plane{y, 0.65}
		    	torus{0.75, 0.1 rotate x*90 translate<0, 0.5, -0.1>}
		    	translate <4.8, 0, -1.5>
	    	}
						
	    	difference{
		    	cylinder{<0, 0.5, -0.1>, <0, 0.5, 1>, 0.75}
		    	plane{y, 0.65}
		    	torus{0.75, 0.1 rotate x*90 translate<0, 0.5, -0.1>}
		    	rotate y*180
		    	translate <4.8, 0, 1.5>
	    	}
	    	
	    	// back
        	merge{
            	cylinder{<0, 0.5, 0>, <0, 1.43, 0>, 0.15 translate<6, 0, -1.5+0.15>}
            	cylinder{<0, 0.5, 0>, <0, 1.43, 0>, 0.15 translate<6, 0, 1.5-0.15>}
            	box{<6, 0.5, -1.5+0.15>, <6.15, 1.43, 1.5-0.15>}
            	sphere{<6, 1.43, -1.5+0.15>, 0.15}
            	sphere{<6, 1.43, 1.5-0.15>, 0.15}
            	cylinder{<6, 1.43, -1.5+0.15>, <6, 1.43, 1.5-0.15>, 0.15}
            	box{<1.3, 1.3, -1.5+0.15>, <6, 1.43+0.15, 1.5-0.15>}
            	cylinder{<1.3, 1.43, -1.5+0.15>, <6, 1.43, -1.5+0.15>, 0.15}
            	cylinder{<1.3, 1.43, 1.5-0.15>, <6, 1.43, 1.5-0.15>, 0.15}
        	}
        	
        	// right handle
			difference{
            	sphere{0, 0.17 scale<1, 0.3, 0.15> translate<2.8, 1.35, -1.5>} 
            	sphere{0, 0.15 scale<1, 0.3, 0.15> translate<2.8, 1.35, -1.5>}
            	plane{y, 1.36}
        	}
        
        	// left handle
			difference{
            	sphere{0, 0.17 scale<1, 0.3, 0.15> translate<2.8, 1.35, 1.5>} 
            	sphere{0, 0.15 scale<1, 0.3, 0.15> translate<2.8, 1.35, 1.5>}
            	plane{y, 1.36}
        	}
	    	
	    	texture{BodyTxt}
	    }
	
	    // bumper right
	    union{
	    	union{  
	        	cylinder{<1.3, 0.85, 0>, <6, 0.85, 0>, 0.1}           
	        	box{<1.3, 0.65, -0.1>, <6, 0.85, 1>}			
	        	cylinder{<1.3, 0, 0>, <6, 0, 0>, 0.35 translate<0, 0.65, 0.25>}
	        	difference{
	            	sphere{<6, 0.65, 0.25>, 0.35}
	            	plane{-y, 0 translate y*0.65}
	        	}
	        	translate -z*1.5
	    	}
			
	    	// bumper left                                            
	    	union{
	        	cylinder{<1.3, 0.85, 0>, <6, 0.85, 0>, 0.1}           
	        	box{<1.3, 0.65, -0.1>, <6, 0.85, 0.1>}
	        	cylinder{<1.3, 0, 0>, <6, 0, 0>, 0.35 translate<0, 0.65, -0.25>} 
	        	difference{
	            	sphere{<6, 0.65, -0.25>, 0.35}
	            	plane{-y, 0 translate y*0.65}
	        	}
	        	translate z*1.5
	    	}	    
	    
	    	// bumper back
	    	merge{
	        	cylinder{<6, 0.85, -1.5>, <6, 0.85, 1.5>, 0.1}
	        	box{<6, 0.65, -1.5+0.25>, <6.35, 0.85, 1.5-0.25>}
	        	difference{
	            	cylinder{<6, 0.65, -1.5+0.25>, <6, 0.65, 1.5-0.25>, 0.35}
	            	plane{-y, 0 translate y*0.65}
	        	}
	        	cylinder{<0, 0.65, 0>, <0, 0.85, 0>, 0.35 translate<6, 0, -1.5+0.25>}
	        	cylinder{<0, 0.65, 0>, <0, 0.85, 0>, 0.35 translate<6, 0, 1.5-0.25>}
	        	torus{0.25, 0.1 translate<6, 0.85, -1.5+0.25>}
	        	torus{0.25, 0.1 translate<6, 0.85, 1.5-0.25>}
	        	cylinder{<0, 0.65, 0>, <0, 0.95, 0>, 0.25 translate<6, 0, -1.5+0.25>}
	        	cylinder{<0, 0.65, 0>, <0, 0.95, 0>, 0.25 translate<6, 0, 1.5-0.25>}
	        	box{<6, 0.65, -1.5+0.25>, <6.25, 0.95, 1.5-0.25>}
	        
	        	cylinder{<6.25, 0.85, -1.5+0.25>, <6.25, 0.85, 1.5-0.25>, 0.1}
	    	}
	    	
	    	texture{BumperTxt}
	    }
	                        
	    union{
	    	// wing smooth right
	    	difference {
		    	union{
			    	torus{0.63, 0.02 rotate x*90 translate<0, 0.5, -0.1>} 
			    	torus{0.57, 0.02 rotate x*90 translate<0, 0.5, -0.1>}
			    	difference{
				    	cylinder{<0, 0.5, -0.12>, <0, 0.5, 1>, 0.63}
				    	cylinder{<0, 0.5, -1>, <0, 0.5, 2>, 0.57}
			    	}
		    	}         
		    	plane{y, 0.63}
		    	translate<4.8, 0, -1.5>           
	    	}
			
	    	// wing smooth left
	    	difference {
		    	union{
			    	torus{0.63, 0.02 rotate x*90 translate<0, 0.5, -0.1>} 
			    	torus{0.57, 0.02 rotate x*90 translate<0, 0.5, -0.1>}
			    	difference{
				    	cylinder{<0, 0.5, -0.12>, <0, 0.5, 1>, 0.63}
				    	cylinder{<0, 0.5, -1>, <0, 0.5, 2>, 0.57}
			    	}
		    	}         
		    	plane{y, 0.63}
		    	rotate y*180
		    	translate<4.8, 0, 1.5>           
	    	}
	    
	    	// stripes
	    	difference{
	        	union{
	            	cylinder{<1.3, 0.65, -0.1>, <6, 0.65, -0.1>, 0.02 translate -z*1.5} 
		        	cylinder{<1.3, 0.65, 0.1>, <6, 0.65, 0.1>, 0.02 translate z*1.5}
					
		        	cylinder{<1.3, 0.75, -0.1>, <6, 0.75, -0.1>, 0.02 translate -z*1.5} 
		        	cylinder{<1.3, 0.75, 0.1>, <6, 0.75, 0.1>, 0.02 translate z*1.5}
		
		        	torus{0.35, 0.02 translate<6, 0.75, -1.6+0.35>}
		        	torus{0.35, 0.02 translate<6, 0.65, -1.6+0.35>}
		
		        	torus{0.35, 0.02 translate<6, 0.75, 1.6-0.35>}
		        	torus{0.35, 0.02 translate<6, 0.65, 1.6-0.35>}
		
		        	cylinder{<6.35, 0.65, -1.6+0.35>, <6.35, 0.65, 1.6-0.35>, 0.02} 
		        	cylinder{<6.35, 0.75, -1.6+0.35>, <6.35, 0.75, 1.6-0.35>, 0.02}
		    	}
		    	cylinder{<4.8, 0.5, -6>, <4.8, 0.5, 6>, 0.57}
			} 
			
			texture{StripesTxt}
		}         
	}
	
	// cut
	union{
		// for right wheel
		union{
			cylinder{<0, 0.5, -1>, <0, 0.5, 0.5>, 0.55} 
			box{<-0.55, -1, -1>, <0.55, 0.5, 0.5>}
			translate<4.8, 0, -1.5>
		}
		
		// for left wheel
		union{
			cylinder{<0, 0.5, -1>, <0, 0.5, 0.5>, 0.55} 
			box{<-0.55, -1, -1>, <0.55, 0.5, 0.5>}
			rotate y*180
			translate<4.8, 0, 1.5>
		}
	
		// for salon
		difference{
	    	box{<1.31, 0.5, -1.4>, <4.8, 3, 1.4>}
	    	cylinder{<4.8, 0.5, -4>, <4.8, 0.5, 4>, 0.65}
		} 
	
		// for right door
		difference{
	    	box{<0, -1, -3>, <0.01, 3, -1.4> rotate -z*30}
	    	plane{y, 0}
	    	translate<2.75, 0.65, 0>
		}
	
		// for left door
		difference{
	    	box{<0, -1, 6>, <0.01, 3, 1.4> rotate -z*30}
	    	plane{y, 0}
	    	translate<2.75, 0.65, 0>
	    }                
	    
	    // for plate
	    box{<6.05, 1.1, -0.6>, <7, 1.4, 0.6>}            
	    
	    // for trunk
	    difference{
	    	box{<5.2, 1.4, -1.1>, <7, 3, 1.1>} 
	    	box{<5.21, 1.4+0.01, -1.1+0.01>, <7, 4, 1.1-0.01>}
	    }
	    
	    texture{BodyTxt}
	}
}

#declare BackSeat = union{
    cylinder{0, <0, 0.7, 0>, 0.1 translate z*1.15}
    cylinder{0, <0, 0.7, 0>, 0.1 translate -z*1.15}
    difference{
        torus{0.2, 0.1 rotate z*90}
        plane{y, 0}
        plane{z, 0}
        translate<0, 0.7, 1.15-0.2>
    }
    difference{
        torus{0.2, 0.1 rotate z*90}
        plane{y, 0}
        plane{-z, 0}
        translate<0, 0.7, -1.15+0.2>
    }
    cylinder{<0, 0.9, -1.15+0.2>, <0, 0.9, 1.15-0.2>, 0.1}
        
    difference{
        union{
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.9} 
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.6}
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.3}
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0}
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.3}
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.6}
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.9}
        } 
        plane{z, -1.15}        
        plane{-z, 0 translate 1.15}
        plane{-y, 0 rotate x*45 translate<0, 0.8, 1.15>} 
        plane{-y, 0 rotate -x*45 translate<0, 0.8, -1.15>}
    }
        
    difference{
        union{
            cylinder{0, <0, 0.7, 0>, 0.1 translate z*1.15}
            cylinder{0, <0, 0.7, 0>, 0.1 translate -z*1.15}
            difference{
                torus{0.2, 0.1 rotate z*90}
                plane{y, 0}
                plane{z, 0}
                translate<0, 0.7, 1.15-0.2>
            }
            difference{
                torus{0.2, 0.1 rotate z*90}
                plane{y, 0}
                plane{-z, 0}
                translate<0, 0.7, -1.15+0.2>
            }
            cylinder{<0, 0.9, -1.15+0.2>, <0, 0.9, 1.15-0.2>, 0.1}
        
            difference{
                union{
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.9} 
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.6}
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.3}
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0}
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.3}
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.6}
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.9}
                } 
                plane{z, -1.15}        
                plane{-z, 0 translate 1.15}
                plane{-y, 0 rotate x*45 translate<0, 0.8, 1.15>} 
                plane{-y, 0 rotate -x*45 translate<0, 0.8, -1.15>}
            }
            rotate z*105
            translate x*0.1
        }              
        plane{-x, 0 rotate -z*15}
    }
    texture{SeatTxt}
}

#declare FrontSeat = union{
    cylinder{0, <0, 0.7, 0>, 0.1 translate z*0.4}
    cylinder{0, <0, 0.7, 0>, 0.1 translate -z*0.4}
    difference{
        torus{0.2, 0.1 rotate z*90}
        plane{y, 0}
        plane{z, 0}
        translate<0, 0.7, 0.2>
    }
    difference{
        torus{0.2, 0.1 rotate z*90}
        plane{y, 0}
        plane{-z, 0}
        translate<0, 0.7, -0.2>
    }
    cylinder{<0, 0.9, 0.2>, <0, 0.9, -0.2>, 0.1}
        
    difference{
        union{
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.3} 
            cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.3}
        } 
        plane{z, -0.4}        
        plane{-z, 0 translate 0.4}
        plane{-y, 0 rotate x*45 translate<0, 0.8, 0.4>} 
        plane{-y, 0 rotate -x*45 translate<0, 0.8, -0.4>}
    }
        
    difference{
        union{
            cylinder{0, <0, 0.7, 0>, 0.1 translate z*0.4}
            cylinder{0, <0, 0.7, 0>, 0.1 translate -z*0.4}
            difference{
                torus{0.2, 0.1 rotate z*90}
                plane{y, 0}
                plane{z, 0}
                translate<0, 0.7, 0.2>
            }
            difference{
                torus{0.2, 0.1 rotate z*90}
                plane{y, 0}
                plane{-z, 0}
                translate<0, 0.7, -0.2>
            }
            cylinder{<0, 0.9, 0.2>, <0, 0.9, -0.2>, 0.1}
      
            difference{
                union{
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate z*0.3} 
                    cylinder{0, <0, 0.9, 0>, 0.4 scale<0.22, 1, 1> translate -z*0.3}
                } 
                plane{z, -0.4}        
                plane{-z, 0 translate 0.4}
                plane{-y, 0 rotate x*45 translate<0, 0.8, 0.4>} 
                plane{-y, 0 rotate -x*45 translate<0, 0.8, -0.4>}
           }
           rotate z*105
           translate x*0.1
        }              
        plane{-x, 0 rotate -z*15}
    }
        
    // for head
   	union{
        sphere{<0, 0.1, -0.25>, 0.1} 
        sphere{<0, 0.1, 0.25>, 0.1}
        sphere{<0, 0.3, -0.15>, 0.1}
        sphere{<0, 0.3, 0.15>, 0.1}
        cylinder{<0, 0.1, -0.25>, <0, 0.1, 0.25>, 0.1}
        cylinder{<0, 0.3, -0.15>, <0, 0.3, 0.15>, 0.1}
        cylinder{<0, 0.1, -0.25>, <0, 0.3, -0.15>, 0.1}
        cylinder{<0, 0.1, 0.25>, <0, 0.3, 0.15>, 0.1}
            
        translate y*0.8
    }          
    texture{SeatTxt}
} 

#declare Interior = union{
	union{     
    	difference{
        	box{<1.3, 0.5, -1.4>, <4.8, 1.43, 1.4>}
        	difference{
            	box{<0.9, 0.52, -1.25>, <4.7, 2, 1.25>}
            	cylinder{<4.8, 0.5, -4>, <4.8, 0.5, 4>, 0.66}
        	}
    	}
    	difference{
        	union{
            	cylinder{<1.34, 1.43, 1.4>, <4.8, 1.43, 1.4>, 0.15} 
            	cylinder{<1.34, 1.43, -1.4>, <4.8, 1.43, -1.4>, 0.15}
            	cylinder{<4.8, 1.43, -1.4>, <4.8, 1.43, 1.4>, 0.15}
        	} 
        	plane{z, -1.4}
        	plane{-z, 0 translate z*1.4}
    	}     
    	
    	texture{InteriorTxt}
    }
	object{BackSeat rotate -z*20 translate<4.2, 0.9, 0>}    
    object{FrontSeat rotate -z*20 translate<2.5, 0.8, -0.65>}
    object{FrontSeat rotate -z*20 translate<2.5, 0.8, 0.65>}
        
    // wheel
    torus{0.3, 0.03 rotate -z*80 translate<1.42, 1.44, -0.65> texture{WheelTxt}}
    	
	// central mirror 
/*	
    difference{
        merge{
            sphere{<0, 0, 0.1>, 0.06} 
            sphere{<0, 0, -0.1>, 0.06}
            cylinder{<0, 0, 0.1>, <0, 0, -0.1>, 0.06}
            cylinder{0, <0, 0.1, 0>, 0.04 scale<0.7, 1, 0.6>}
        } 
        plane{-x, 0}
        texture{InteriorTxt}
        
        translate<1.84, 2.06, 0>
	}
	*/
}

#declare Top = union{
    // glass        
    difference{
        difference{
            cone{<0, -0.1, 0>, 1.4, <0, 1.5, 0>, 1.1}
            cone{<0, -0.1, 0>, 1.35, <0, 1.5, 0>, 1.05}
            plane{y, 0 rotate z*14}
            plane{-x, 0}
            
            scale<0.14, 1, 1>
        }                                                    
        plane{-y, 0 rotate z*50 translate y*1.2}
        texture{WindShieldTxt}
        
        rotate -z*50 translate<1.2, 1.4, 0>          
    }
    
    // glass frame
    union{ 
        difference{
            difference{
                cone{<0, -0.1, 0>, 1.402, <0, 1.5, 0>, 1.102}
                cone{<0, -0.1, 0>, 1.35, <0, 1.499, 0>, 1.1}
                plane{-x, 0}
            
                scale<0.14, 1, 1>
            }                                                    
            plane{y, 0 rotate z*50 translate y*1.19}                                                    
            plane{-y, 0 rotate z*50 translate y*1.23}
        
            rotate -z*50 translate<1.2, 1.4, 0>          
        }
      
        difference{
            difference{
                cone{<0, -0.2, 0>, 1.46, <0, 1.5, 0>, 1.102}
                cone{<0, -0.2, 0>, 1.35, <0, 1.499, 0>, 1.1}
                plane{-x, 0 translate x*0.01}
            
                scale<0.14, 1, 1>
            }
        
            cone{<0, -0.2, 0>, 1.36, <0, 1.499, 0>, 1.1}
            plane{-y, 0 rotate z*50 translate y*1.23}
            plane{y, -0.15}
        
            rotate -z*50 translate<1.2, 1.4, 0>          
        }
        
        texture{BodyTxt}
    }
    
    translate -x*0.07  
}

#declare Antenna = union{
	cylinder{0, <0, 0.4, 0>, 0.012}
	cylinder{0, <0, 0.4, 0>, 0.008 translate y*0.4}
	cylinder{0, <0, 0.4, 0>, 0.005 translate y*0.8}
	cylinder{0, <0, 0.014, 0>, 0.014 translate y*1.2}
	translate<5.5, 1.57, -1.3>
		    
	texture{AntennaTxt}
}

#declare CenterAndBack = union{
    object{CenterAndBackBody}                           
    // plate
    union{                        
    	object{Plate rotate y*180 translate<6.05, 1.25, 0>}
    	cylinder{<6.05, 1.1, -0.6>, <6.05, 1.4, -0.6>, 0.1} 
    	cylinder{<6.05, 1.1, 0.6>, <6.05, 1.4, 0.6>, 0.1}
	    texture{BodyTxt}
	}
	object{BackLight translate <6.15, 1.25, -1.5>}
	object{BackLight rotate x*180 translate <6.15, 1.25, 1.5>}
	object{Antenna}
}

#declare Car = union{
    object{Front}  
    
    // front wheels
    object{Wheel translate <0, 0.5, -1.35>}
    object{Wheel rotate y*180 translate <0, 0.5, 1.35>}

    object{CenterAndBack}
    
    // back wheels
    object{Wheel translate <4.8, 0.5, -1.35>}
    object{Wheel rotate y*180 translate <4.8, 0.5, 1.35>}

    object{Top} 
    object{Interior}
}
