#macro Line(start, stop, num, typ, sz, c, randomColor)
	#local diff = stop - start;
	#local xi = diff.x/num; 
	#local yi = diff.y/num;
	#local zi = diff.z/num;
    #local cnt=0;
    #local col = c;
    #while (cnt < num)
    	#if(randomColor = 1)
    		#local R = seed(cnt*100+2);
    		#local G = seed(cnt*200+3);
    		#local B = seed(cnt*300+4);
			#local col = <rand(R), rand(G), rand(B)>;
    	#end
        #local lx = start.x + (xi * cnt);
        #local ly = start.y + (yi * cnt); 
        #local lz = start.z + (zi * cnt);
        glow{size sz type typ location<lx, ly, lz> color rgb col}
        #local cnt = cnt + 1;
    #end
#end 

#macro Circle(start, rad, rotateX, rotateY, num, typ, sz, c, randomColor)
    #local cnt=0;
    #local col = c;
    #local incr = 360/num;
    #while (cnt < num)
    	#if(randomColor = 1)
    		#local R = seed(cnt*100+2);
    		#local G = seed(cnt*200+3);
    		#local B = seed(cnt*300+4); 
    		#local col = <rand(R), rand(G), rand(B)>*2;
    	#end 
    	#local coord = vaxis_rotate(<rad, 0, 0>, z, incr*cnt);
    	#local coord1 = vaxis_rotate(coord, x, rotateX);
    	#local coord2 = vaxis_rotate(coord1, y, rotateY);
        #local lx = start.x + coord2.x;
        #local ly = start.y + coord2.y; 
        #local lz = start.z + coord2.z;
        glow{size sz type typ location<lx, ly, lz> color rgb col}
        #local cnt = cnt + 1;
    #end
#end

#macro Rectangle(start, w, h, rotateY, rotateX, rotateZ, numH, numV, typ, sz, c, randomColor)
	#local incrH = w/(numH - 1);
	#local incrV = h/(numV - 1);
    #local cnt=0;
    #local col = c;
    #while (cnt < numH)
    	#if(randomColor = 1)
    		#local R = seed(cnt*100+2);
    		#local G = seed(cnt*200+3);
    		#local B = seed(cnt*300+4);
			#local col = <rand(R), rand(G), rand(B)>;
    	#end     
    	
    	#local coord = vaxis_rotate(<cnt*incrH, 0, 0>, y, rotateY);
    	#local coord1 = vaxis_rotate(coord, x, rotateX);
    	#local coord2 = vaxis_rotate(coord1, z, rotateZ);
        #local lx = start.x + coord2.x;
        #local ly = start.y + coord2.y; 
        #local lz = start.z + coord2.z;
        glow{size sz type typ location<lx, ly, lz> color rgb col} 
        
        #local coord = vaxis_rotate(<cnt*incrH, h, 0>, y, rotateY);
    	#local coord1 = vaxis_rotate(coord, x, rotateX);
    	#local coord2 = vaxis_rotate(coord1, z, rotateZ);
        #local lx = start.x + coord2.x;
        #local ly = start.y + coord2.y; 
        #local lz = start.z + coord2.z;
        glow{size sz type typ location<lx, ly, lz> color rgb col}
        
        #local cnt = cnt + 1;
    #end 
    #local cnt=0;
    #while (cnt < (numV - 2))
    	#if(randomColor = 1)
    		#local R = seed(cnt*100+2);
    		#local G = seed(cnt*200+3);
    		#local B = seed(cnt*300+4);
			#local col = <rand(R), rand(G), rand(B)>;
    	#end     
    	        
        #local coord = vaxis_rotate(<0, incrV + cnt*incrV, 0>, y, rotateY);
    	#local coord1 = vaxis_rotate(coord, x, rotateX);
    	#local coord2 = vaxis_rotate(coord1, z, rotateZ);
        #local lx = start.x + coord2.x;
        #local ly = start.y + coord2.y; 
        #local lz = start.z + coord2.z;
        glow{size sz type typ location<lx, ly, lz> color rgb col} 
        
        #local coord = vaxis_rotate(<w, incrV + cnt*incrV, 0>, y, rotateY);
    	#local coord1 = vaxis_rotate(coord, x, rotateX);
    	#local coord2 = vaxis_rotate(coord1, z, rotateZ);
        #local lx = start.x + coord2.x;
        #local ly = start.y + coord2.y; 
        #local lz = start.z + coord2.z;
        glow{size sz type typ location<lx, ly, lz> color rgb col}
        
        #local cnt = cnt + 1;
    #end
#end

#macro Cycloid(start, rad, period, rotateX, rotateY, rotateZ, num, typ, sz, c, randomColor)
	#local pcnt = 0;
    #local cnt=0;
    #local col = c;
    #local incr = 180/(num - 1);
    #while (pcnt < period)
    	#local cnt=0;
    	#while (cnt < num)
    		#if(randomColor = 1)
    			#local R = seed(cnt*100+2);
    			#local G = seed(cnt*200+3);
    			#local B = seed(cnt*300+4); 
    			#local col = <rand(R), rand(G), rand(B)>;
    		#end 
    		#local coord = vaxis_rotate(<-rad, 0, 0>, z, incr*cnt);
    		#local tmp = <coord.x + 2 * pcnt * rad, coord.y, coord.z>;
    		#local coord1 = vaxis_rotate(tmp, x, rotateX);
    		#local coord2 = vaxis_rotate(coord1, y, rotateY); 
    		#local coord3 = vaxis_rotate(coord2, z, rotateZ);
        	#local lx = start.x + coord3.x;
        	#local ly = start.y + coord3.y; 
        	#local lz = start.z + coord3.z;
        	glow{size sz type typ location<lx, ly, lz> color rgb col}
        	#local cnt = cnt + 1;
    	#end
    	#local pcnt = pcnt + 1;
    #end
#end

#macro HalfCircle(start, rad, rotateX, rotateY, rotateZ, num, typ, sz, c, randomColor)
    #local cnt=0;
    #local col = c;
    #local incr = 180/(num - 1);
    #while (cnt < num)
    	#if(randomColor = 1)
    		#local R = seed(cnt*100+2);
    		#local G = seed(cnt*200+3);
    		#local B = seed(cnt*300+4); 
    		#local col = <rand(R), rand(G), rand(B)>;
    	#end 
    	#local coord = vaxis_rotate(<-rad, 0, 0>, z, incr*cnt);
    	#local coord1 = vaxis_rotate(coord, x, rotateX);
    	#local coord2 = vaxis_rotate(coord1, y, rotateY);
    	#local coord3 = vaxis_rotate(coord2, y, rotateZ);
        #local lx = start.x + coord3.x;
        #local ly = start.y + coord3.y; 
        #local lz = start.z + coord3.z;
       	glow{size sz type typ location<lx, ly, lz> color rgb col}
        #local cnt = cnt + 1;
    #end
#end

#macro QuarterCircle(start, rad, rotateX, rotateY, rotateZ, num, typ, sz, c, randomColor)
    #local cnt=0;
    #local col = c;
    #local incr = 90/(num - 1);
    #while (cnt < num)
    	#if(randomColor = 1)
    		#local R = seed(cnt*100+2);
    		#local G = seed(cnt*200+3);
    		#local B = seed(cnt*300+4); 
    		#local col = <rand(R), rand(G), rand(B)>;
    	#end 
    	#local coord = vaxis_rotate(<-rad, 0, 0>, z, incr*cnt);
    	#local coord1 = vaxis_rotate(coord, x, rotateX);
    	#local coord2 = vaxis_rotate(coord1, y, rotateY);
    	#local coord3 = vaxis_rotate(coord2, z, rotateZ);
        #local lx = start.x + coord3.x;
        #local ly = start.y + coord3.y; 
        #local lz = start.z + coord3.z;
       	glow{size sz type typ location<lx, ly, lz> color rgb col}
        #local cnt = cnt + 1;
    #end
#end 

//Line(<0, -2, 0>, <2, 2, 0>, 10, 0, 0.02, color rgb<0.4, 0, 0>, 1)
//Circle(<0, 0, 0>, 1, 0, 0, 35, 0, 0.02, color rgb<0.4, 0, 0>, 1)
//Rectangle(<-1.5, -1.5, 10>, 3, 3, 0, 0, 45, 10, 10, 0, 0.02, color rgb<0.4, 0, 0>, 1)
//Rectangle(<-1, -1, 10>, 2, 2, 0, 0, 45, 8, 8, 0, 0.02, color rgb<0.4, 0, 0>, 1)
//Cycloid(<-2, 0, 3>, 0.5, 5, 0, 0, 0, 6, 0, 0.02, color rgb<0.4, 0, 0>, 0)
//HalfCircle(<0, 0, 0>, 1, 180, 45, 0, 10, 0, 0.02, color rgb<0.4, 0, 0>, 1)
