#include "textures.inc"

#declare leg_part = cylinder
{
        < 0, 0, 0 >< -1.5, 0, 0 >,2
        scale< 1, 0.05, 0.05 >
}

#declare leg = union
{
        object
        {
                leg_part
        }
        object
        {
                leg_part
                rotate< 0, 0, 45 >
                translate< -1.5, 0, 0 >
        }
}

#declare legs = union
{
        object
        {
                leg
        }
        object
        {
                leg
                rotate< 0, 45, 0 >
                translate< 0, 0, 0.5 >
        }
        object
        {
                leg
                rotate< 0, -45, 0 >
                translate< 0, 0, -0.5 >
        }
        texture{ leg_texture }
}

#declare neck = union
{
        difference
        {
                sphere
                {
                        < 0, 0, 0 >, 1
                        scale< 0.75, 0.7, 0.75 >
                }
                box
                {
                        < -1, -1, -1 >
                        < 1, 0, 1 >
                }
        }
        sphere
        {
                <0, 0, 0>, 1
                scale< 0.75, 0.25, 0.75 >
        }
        texture{ neck_texture }
}

#declare head = union
{
        difference
        {
                union
                {
                        sphere
                        {
                                < 0, 0, 0 >, 1
                                scale< 0.5, 0.75, 1 >
                                texture{ head_texture }
                        }
                        union
                        {
                                sphere                
                                {
                                       <0, 0, 0 >,1
                                       translate< 2, 5, 5 >
                                }
                                sphere                
                                {
                                       <0, 0, 0 >,1
                                       translate< -2, 5, 5 >
                                }                  
                                scale< 0.1, 0.1, 0.1 >
                                texture{ eye_texture }
                        }
                }
                box
                {
                        < -1, -1, -1 >
                        < 1, 0, 1 >
                }
        }
        sphere
        {
                < 0, 0, 0 >,1
                scale< 0.5, 0.25, 1 >
                texture{ head_texture }
        }
}        

#declare wing = difference
{
        difference
        {
                difference
                {
                        sphere
                        {
                                < 0, 0, 0 >,1
                        }
                        sphere
                        {
                                < 0, 0, 0 >,0.9
                        }
        
                }
                box
                {
                        < 0, -1, -1 >
                        < 1, 1, 1 >
                }
       }
       box
       {
                < -1, -1, -1 >
                < 1, 0, 1 >
       }
}

#declare wings = union
{
        object
        {
                wing
                rotate< 0, 10, 0 >
        }
        object
        {
                wing
                rotate< 0, 170, 0 >
        }
        scale< 1, 0.75, 2 >
        texture{ wing_texture }
}

#declare bug = union
{
        sphere
        {
                < 0, 0, 0 >,1
                scale< 1, 0.5, 2 >
                texture{ body_texture }
        }
        union
        {
                object
                {
                        legs
                }
                object
                {
                        legs
                        rotate< 0, 180, 0 >
                }
        }
        object
        {
                neck
                translate< 0, 0, 1.25 >
        }
        object
        {
                head
                translate< 0, 0, 1.5 >
        }
        object
        {
                wings
        }
}