#include "textures.inc"

#declare key = union
{
        mesh
        {
                triangle{ <-1, -1, -1 >,< 1, -1, -1 >,< 1, -1, 1 > }
                triangle{ <-1, -1, -1 >,< -1, -1, 1 >,< 1, -1, 1 > }
                
                triangle{ <-1, -1, -1 >,<1, -1, -1>,<0.7, 0, -0.7> }
                triangle{ <-1, -1, -1 >,<-0.7, 0, -0.7>,<0.7, 0, -0.7> }
                
                triangle{ <-1, -1, 1 >,<1, -1, 1>,<0.7, 0, 0.7> }
                triangle{ <-1, -1, 1 >,<-0.7, 0, 0.7>,<0.7, 0, 0.7> }
                
                triangle{ <-1, -1, -1 >, <-1, -1, 1 >, < -0.7, 0, 0.7> }
                triangle{ <-1, -1, -1 >, <-0.7, 0, -0.7 >, < -0.7, 0, 0.7> }
                
                triangle{ <1, -1, -1 >, <1, -1, 1 >, < 0.7, 0, 0.7> }
                triangle{ <1, -1, -1 >, <0.7, 0, -0.7 >, < 0.7, 0, 0.7> }
                
                triangle{ <-0.7, 0, -0.7 >,< 0.7, 0, -0.7 >,< 0.7, 0, 0.7 > }
                triangle{ <-0.7, 0, -0.7 >,< -0.7, 0, 0.7 >,< 0.7, 0, 0.7 > }
        }
}

#declare shift_1 = union
{
        mesh
        {
                triangle{ <-1, -1, -1 >,< 1.5, -1, -1 >,< 1.5, -1, 1 > }
                triangle{ <-1, -1, -1 >,< -1, -1, 1 >,< 1.5, -1, 1 > }
                
                triangle{ <-1, -1, -1 >,<1.5, -1, -1>,<1.2, 0, -0.7> }
                triangle{ <-1, -1, -1 >,<-0.7, 0, -0.7>,<1.2, 0, -0.7> }
                
                triangle{ <-1, -1, 1 >,<1.5, -1, 1>,<1.2, 0, 0.7> }
                triangle{ <-1, -1, 1 >,<-0.7, 0, 0.7>,<1.2, 0, 0.7> }
                
                triangle{ <-1, -1, -1 >, <-1, -1, 1 >, < -0.7, 0, 0.7> }
                triangle{ <-1, -1, -1 >, <-0.7, 0, -0.7 >, < -0.7, 0, 0.7> }
                
                triangle{ <1.5, -1, -1 >, <1.5, -1, 1 >, < 1.2, 0, 0.7> }
                triangle{ <1.5, -1, -1 >, <1.2, 0, -0.7 >, < 1.2, 0, 0.7> }
                
                triangle{ <-0.7, 0, -0.7 >,< 1.2, 0, -0.7 >,< 1.2, 0, 0.7 > }
                triangle{ <-0.7, 0, -0.7 >,< -0.7, 0, 0.7 >,< 1.2, 0, 0.7 > }
        }
}

#declare ctrl_1 = union
{
        mesh
        {
                triangle{ <-1, -1, -1 >,< 2, -1, -1 >,< 2, -1, 1 > }
                triangle{ <-1, -1, -1 >,< -1, -1, 1 >,< 2, -1, 1 > }
                
                triangle{ <-1, -1, -1 >,<2, -1, -1>,<1.7, 0, -0.7> }
                triangle{ <-1, -1, -1 >,<-0.7, 0, -0.7>,<1.7, 0, -0.7> }
                
                triangle{ <-1, -1, 1 >,<2, -1, 1>,<1.7, 0, 0.7> }
                triangle{ <-1, -1, 1 >,<-0.7, 0, 0.7>,<1.7, 0, 0.7> }
                
                triangle{ <-1, -1, -1 >, <-1, -1, 1 >, < -0.7, 0, 0.7> }
                triangle{ <-1, -1, -1 >, <-0.7, 0, -0.7 >, < -0.7, 0, 0.7> }
                
                triangle{ <2, -1, -1 >, <2, -1, 1 >, < 1.7, 0, 0.7> }
                triangle{ <2, -1, -1 >, <1.7, 0, -0.7 >, < 1.7, 0, 0.7> }
                
                triangle{ <-0.7, 0, -0.7 >,< 1.7, 0, -0.7 >,< 1.7, 0, 0.7 > }
                triangle{ <-0.7, 0, -0.7 >,< -0.7, 0, 0.7 >,< 1.7, 0, 0.7 > }
        }
}

#declare ctrl_2 = union
{
        mesh
        {
                triangle{ <-1, -1, -1 >,< 3, -1, -1 >,< 3, -1, 1 > }
                triangle{ <-1, -1, -1 >,< -1, -1, 1 >,< 3, -1, 1 > }
                
                triangle{ <-1, -1, -1 >,<3, -1, -1>,<2.7, 0, -0.7> }
                triangle{ <-1, -1, -1 >,<-0.7, 0, -0.7>,<2.7, 0, -0.7> }
                
                triangle{ <-1, -1, 1 >,<3, -1, 1>,<2.7, 0, 0.7> }
                triangle{ <-1, -1, 1 >,<-0.7, 0, 0.7>,<2.7, 0, 0.7> }
                
                triangle{ <-1, -1, -1 >, <-1, -1, 1 >, < -0.7, 0, 0.7> }
                triangle{ <-1, -1, -1 >, <-0.7, 0, -0.7 >, < -0.7, 0, 0.7> }
                
                triangle{ <3, -1, -1 >, <3, -1, 1 >, < 2.7, 0, 0.7> }
                triangle{ <3, -1, -1 >, <2.7, 0, -0.7 >, < 2.7, 0, 0.7> }
                
                triangle{ <-0.7, 0, -0.7 >,< 2.7, 0, -0.7 >,< 2.7, 0, 0.7 > }
                triangle{ <-0.7, 0, -0.7 >,< -0.7, 0, 0.7 >,< 2.7, 0, 0.7 > }
        }
}

#declare ctrl_3 = union
{
        mesh
        {
                triangle{ <-1, -1, -1.5 >,< 3, -1, -1.5 >,< 3, -1, 1 > }
                triangle{ <-1, -1, -1.5 >,< -1, -1, 1 >,< 3, -1, 1 > }
                
                triangle{ <-1, -1, -1.5 >,<3, -1, -1.5>,<2.7, 0, -1.2> }
                triangle{ <-1, -1, -1.5 >,<-0.7, 0, -1.2>,<2.7, 0, -1.2> }
                
                triangle{ <-1, -1, 1 >,<3, -1, 1>,<2.7, 0, 0.7> }
                triangle{ <-1, -1, 1 >,<-0.7, 0, 0.7>,<2.7, 0, 0.7> }
                
                triangle{ <-1, -1, -1.5 >, <-1, -1, 1 >, < -0.7, 0, 0.7> }
                triangle{ <-1, -1, -1.5 >, <-0.7, 0, -1.2 >, < -0.7, 0, 0.7> }
                
                triangle{ <3, -1, -2 >, <3, -1, 1 >, < 2.7, 0, 0.7> }
                triangle{ <3, -1, -2 >, <2.7, 0, -1.2 >, < 2.7, 0, 0.7> }
                
                triangle{ <-0.7, 0, -1.2 >,< 2.7, 0, -1.2 >,< 2.7, 0, 0.7 > }
                triangle{ <-0.7, 0, -1.2 >,< -0.7, 0, 0.7 >,< 2.7, 0, 0.7 > }
        }
}

#declare shift_2 = union
{
        mesh
        {
                triangle{ <-1, -1, -1 >,< 2.5, -1, -1 >,< 2.5, -1, 1 > }
                triangle{ <-1, -1, -1 >,< -1, -1, 1 >,< 2.5, -1, 1 > }
                
                triangle{ <-1, -1, -1 >,<2.5, -1, -1>,<2.3, 0, -0.7> }
                triangle{ <-1, -1, -1 >,<-0.7, 0, -0.7>,<2.3, 0, -0.7> }
                
                triangle{ <-1, -1, 1 >,<2.5, -1, 1>,<2.3, 0, 0.7> }
                triangle{ <-1, -1, 1 >,<-0.7, 0, 0.7>,<2.3, 0, 0.7> }
                
                triangle{ <-1, -1, -1 >, <-1, -1, 1 >, < -0.7, 0, 0.7> }
                triangle{ <-1, -1, -1 >, <-0.7, 0, -0.7 >, < -0.7, 0, 0.7> }
                
                triangle{ <2.5, -1, -1 >, <2.5, -1, 1 >, < 2.3, 0, 0.7> }
                triangle{ <2.5, -1, -1 >, <2.3, 0, -0.7 >, < 2.3, 0, 0.7> }
                
                triangle{ <-0.7, 0, -0.7 >,< 2.3, 0, -0.7 >,< 2.3, 0, 0.7 > }
                triangle{ <-0.7, 0, -0.7 >,< -0.7, 0, 0.7 >,< 2.3, 0, 0.7 > }
        }
}

#declare shift_3 = union
{
        mesh
        {
                triangle{ <-1, -1, -1 >,< 4.5, -1, -1 >,< 4.5, -1, 1 > }
                triangle{ <-1, -1, -1 >,< -1, -1, 1 >,< 4.5, -1, 1 > }
                
                triangle{ <-1, -1, -1 >,<4.5, -1, -1>,<4.3, 0, -0.7> }
                triangle{ <-1, -1, -1 >,<-0.7, 0, -0.7>,<4.3, 0, -0.7> }
                
                triangle{ <-1, -1, 1 >,<4.5, -1, 1>,<4.3, 0, 0.7> }
                triangle{ <-1, -1, 1 >,<-0.7, 0, 0.7>,<4.3, 0, 0.7> }
                
                triangle{ <-1, -1, -1 >, <-1, -1, 1 >, < -0.7, 0, 0.7> }
                triangle{ <-1, -1, -1 >, <-0.7, 0, -0.7 >, < -0.7, 0, 0.7> }
                
                triangle{ <4.5, -1, -1 >, <4.5, -1, 1 >, < 4.3, 0, 0.7> }
                triangle{ <4.5, -1, -1 >, <4.3, 0, -0.7 >, < 4.3, 0, 0.7> }
                
                triangle{ <-0.7, 0, -0.7 >,< 4.3, 0, -0.7 >,< 4.3, 0, 0.7 > }
                triangle{ <-0.7, 0, -0.7 >,< -0.7, 0, 0.7 >,< 4.3, 0, 0.7 > }
        }
}

#declare space = union
{
        mesh
        {
                triangle{ <-7, -1, -1 >,< 7, -1, -1 >,< 7, -1, 1 > }
                triangle{ <-7, -1, -1 >,< -7, -1, 1 >,< 7, -1, 1 > }
                
                triangle{ <-7, -1, -1 >,<7, -1, -1>,<6.7, 0, -0.7> }
                triangle{ <-7, -1, -1 >,<-6.7, 0, -0.7>,<6.7, 0, -0.7> }
                
                triangle{ <-7, -1, 1 >,<7, -1, 1>,<6.7, 0, 0.7> }
                triangle{ <-7, -1, 1 >,<-6.7, 0, 0.7>,<6.7, 0, 0.7> }
                
                triangle{ <-7, -1, -1 >, <-7, -1, 1 >, < -6.7, 0, 0.7> }
                triangle{ <-7, -1, -1 >, <-6.7, 0, -0.7 >, < -6.7, 0, 0.7> }
                
                triangle{ <7, -1, -1 >, <7, -1, 1 >, < 6.7, 0, 0.7> }
                triangle{ <7, -1, -1 >, <6.7, 0, -0.7 >, < 6.7, 0, 0.7> }
                
                triangle{ <-6.7, 0, -0.7 >,< 6.7, 0, -0.7 >,< 6.7, 0, 0.7 > }
                triangle{ <-6.7, 0, -0.7 >,< -6.7, 0, 0.7 >,< 6.7, 0, 0.7 > }
        }
}

#declare return = union
{
        object
        {
                ctrl_1
        }
        object
        {
                ctrl_3
                rotate< 0, 90, 0 >
                translate< 1.0, 0, 0 >
        }
}

#declare keyset_1 = union
{
        object{ key translate< 0, 0, 0 > }
        object{ key translate< 2, 0, 0 > }
        object{ key translate< 4, 0, 0 > } 
        object{ key translate< 6, 0, 0 > }
}

#declare keyset_2 = union
{
        object{ key translate< 0, 0, 0 > texture{ skey_texture } }
        object{ keyset_1 translate< 4, 0, 0 > texture{ key_texture } }
        object{ keyset_1 translate< 13, 0, 0 > texture{ skey_texture } }
        object{ keyset_1 translate< 22, 0, 0 > texture{ key_texture } }
}

#declare keyset_3 = union
{
        object{ key translate< 0, 0, 0 > }
        object{ key translate< 2, 0, 0 > }
        object{ key translate< 4, 0, 0 > } 
        object{ key translate< 6, 0, 0 > }
        object{ key translate< 8, 0, 0 > }
        object{ key translate< 10, 0, 0 > } 
        object{ key translate< 12, 0, 0 > }
        object{ key translate< 14, 0, 0 > }
        object{ key translate< 16, 0, 0 > }
        object{ key translate< 18, 0, 0 > }
        object{ key translate< 20, 0, 0 > } 
        texture{ key_texture }
}

#declare keyset_4 = union
{
        object
        {
                keyset_3
        }
        object
        {
                key translate< 22, 0, 0 > 
        } 
        texture{ key_texture }
}

#declare num_pad = union
{
        union
        {
                object{ key translate< 0, 0, 0 > }
                object{ key translate< 2, 0, 0 > }
                object{ key translate< -2, 0, 0 > }
                object{ key translate< 0, 0, 2 > }
                object{ key translate< 0, 0, -2 > }
                object{ key translate< 2, 0, 2 > }
                object{ key translate< -2, 0, 2 > }
                object{ key translate< 2, 0, -2 > }
                object{ key translate< -2, 0, -2 > } 
                object{ key translate< 2, 0, -4 > } 
                object{ ctrl_2 translate< -2, 0, -4 > }
                texture{ key_texture }
        }
        union
        {
                object{ key translate< -2, 0, 4 > }
                object{ key translate< 2, 0, 4 > }
                object{ key translate< 0, 0, 4 > } 
                object{ key translate< 4, 0, 4 > } 
                object{ ctrl_2 rotate< 0, 90, 0 > translate< 4, 0, 2 > }
                object{ ctrl_2 rotate< 0, 90, 0 > translate< 4, 0, -2 > }
                texture{ skey_texture }
        }
}

#declare ext_pad = union
{
        union
        {
                object{ key translate< -2, 0, 8 > }
                object{ key translate< 2, 0, 8 > }
                object{ key translate< 0, 0, 8 > } 
                object{ key translate< -2, 0, 4 > }
                object{ key translate< 2, 0, 4 > }
                object{ key translate< 0, 0, 4 > } 
                object{ key translate< 0, 0, 2 > }
                object{ key translate< 0, 0, -2 > }
                object{ key translate< 2, 0, 2 > }
                object{ key translate< -2, 0, 2 > }
                object{ key translate< 2, 0, -4 > } 
                object{ key translate< -2, 0, -4 > } 
                object{ key translate< 0, 0, -4 > } 
                texture{ skey_texture }
        }
}


#declare letter_pad = union
{
        object
        {
                keyset_2
                translate< -16, 0, 8 >
        }
        union
        {
                object
                { 
                        key
                        translate< -16, 0, 4 >
                        texture{ key_texture }
                }
                object
                {   
                        keyset_4
                        translate< -14, 0, 4 >
                }
                object
                {
                        ctrl_2
                        translate< 10, 0, 4 >
                        texture{ skey_texture }
                }
                        
        }
        union
        {
                object
                {
                        ctrl_1
                        translate< -16, 0, 2>
                        texture{ skey_texture }
                }
                object
                {
                        keyset_4
                        translate< -13, 0, 2 >
                }
        }
        union
        {
                object
                {
                        shift_2
                        translate< -16, 0, 0 >
                        texture{ skey_texture }
                }
                object
                {
                        keyset_4
                        translate< -12.5, 0, 0 >
                }
        }
        union
        {
                object
                {
                        shift_1
                        translate< -16, 0, -2 >
                        texture{ skey_texture }
                }
                object
                {
                        keyset_3
                        translate< -13.5, 0, -2 >
                }
                object
                {
                        shift_3
                        translate< 8.5, 0, -2 >
                        texture{ skey_texture }
                }
        }
        union
        {
                object
                {
                        ctrl_1
                        translate< -16, 0, -4 >
                        texture{ skey_texture }
                }
                object
                {
                        ctrl_1
                        translate< -11, 0, -4 >
                        texture{ skey_texture }
                }
                object
                {
                        space
                        translate< -2, 0, -4 >
                        texture{ key_texture }
                }
                object
                {
                        ctrl_1
                        translate< 6, 0, -4 >
                        texture{ skey_texture }
                }
                object
                {
                        ctrl_1
                        translate< 11, 0, -4 >
                        texture{ skey_texture }
                }
        }
        object
        {
                return
                translate< 11, 0, 2 >
                texture{ skey_texture }
        }
}

#declare keys = union
{
        object
        {
                letter_pad
                translate< -6, 0, -4 >
        }
        object
        {
                ext_pad 
                translate< 11, 0, -4 >
        }
        object
        {
                num_pad
                translate< 18, 0, -4 >
        }
}
