#include "textures.inc"

#declare screen = union
{
        mesh
        {
                triangle{<-1, -1, 0>,<-1,1,0><1,1,0>}
                triangle{<1,1,0>,<1,-1,0>,<-1,-1,0>}
        }
}

#declare frame = union
{
        difference
        {       
                union
                {
                        intersection
                        {
                                cylinder
                                {
                                        < 0, 0, -1 >< 0, 0, 1 >,1
                                        scale< 40, 40, 15 >
                                }
                                box
                                {
                                        < -1, -1, -1 >< 1, 1, 1 >
                                        scale< 30, 30, 10 >
                                }
                        }
                        cylinder
                        {
                                < 0, 0, -1 >< 0, 0, 1 >,1
                                scale< 5, 5, 10 >
                                translate< -25, 25, 0 >
                        }
                        cylinder
                        {
                                < 0, 0, -1 >< 0, 0, 1 >,1
                                scale< 5, 5, 10 >
                                translate< 25, 25, 0 >
                        }
                        cylinder
                        {
                                < 0, 0, -1 >< 0, 0, 1 >,1
                                scale< 5, 5, 10 >
                                translate< -25, -25, 0 >
                        }
                        cylinder
                        {
                                < 0, 0, -1 >< 0, 0, 1 >,1
                                scale< 5, 5, 10 >
                                translate< 25, -25, 0 >
                        }
                        
                }
                difference
                {
                        box
                        {
                                < -1, -1, -1 >< 1, 1, 1 >

                        }
                        union
                        {
                                cylinder
                                {
                                        < 0, -1, 0 >< 0, 1, 0 >,0.1
                                        translate< 1, 0, 0 >
                                }
                                cylinder
                                {
                                        < 0, -1, 0 >< 0, 1, 0 >,0.1
                                        translate< -1, 0, 0 >
                                }
                                cylinder
                                {
                                        < -1, 0, 0 >< 1, 0, 0 >,0.1
                                        translate< 0, 1, 0 >
                                }
                                cylinder
                                {
                                        < -1, 0, 0 >< 1, 0, 0 >,0.1
                                        translate< 0, -1, 0 >
                                }
                                scale< 1, 1, 6.7 >
                        }
                        scale< 25, 25, 15 >
                }
        }
}

#declare display = union
{       
        object
        {
                frame
                texture{ pc_texture }
        }
        intersection
        {       
                difference
                {       
                        sphere
                        {
                                < 0, 0, 0 >,1
                        }
                        sphere
                        {
                                <0, 0, 0 >,0.999
                        }
                        scale< 500, 500, 500 >
                        translate< 0, 0, 490 >
                        texture{ glass_texture }
                } 
                box
                {
                        < -1, -1, -1 ><1, 1, 1 >
                        scale< 25,25,25 >
                }
        } 
        object
        {
                screen 
                texture{ screen_texture }
                scale< 20, 20, 1 >
                translate< 0, 0, -7 >
        } 
        object
        {
                screen
                texture{ pigment{ color rgb<1,1,1>}finish{ ambient 10}} 
                scale< 25, 25, 1 >
                translate< 0, 0, -5 >
        }
        
        difference
        {
                object
                {
                        screen
                        scale< 25, 25,1 >
                        translate< 0, 0, -7 >
                }
                box
                {
                        <-1,-1,-1>,<1,1,1>
                        scale< 20, 20, 20 >
                        translate< 0, 0, -7 >
                }
                //texture{ pigment{ color rgb<1,1,1>}finish{ ambient 10}} 
        }
}

#declare body = union
{
        object
        {
                display
                translate< 0, 0, -10 >
        }
        mesh
        {
                triangle{ < -1, -1, 0>,<-0.5, -0.7,1>,<-1, 1, 0 > }
                triangle{ < -1, 1, 0>,<-0.5, -0.7 ,1>,<-0.5, 0.7, 1 > }
                triangle{ < 1, -1, 0>,<0.5, -0.7,1>,<1, 1, 0 > }
                triangle{ < 1, 1, 0>,<0.5, -0.7 ,1>,<0.5, 0.7, 1 > }
                
                triangle{ < -1, 1, 0 >, < 1, 1, 0 >, <0.5, 0.7, 1 > }
                triangle{ < -1, 1, 0 >, < -0.5, 0.7, 1 >, <0.5, 0.7, 1 > }
                triangle{ < -1, -1, 0 >, < 1, -1, 0 >, <0.5, -0.7, 1 > }
                triangle{ < -1, -1, 0 >, < -0.5, -0.7, 1 >, <0.5, -0.7, 1 > }
                
                triangle{ < -0.5, -0.7, 1>, < -0.5, 0.7, 1 >, < 0.5, 0.7, 1 > }
                triangle{ < -0.5, -0.7, 1>, < 0.5, -0.7, 1 >, < 0.5, 0.7, 1 > }
                
                scale< 25, 25, 40 >
                texture{ pc_texture }
        }
}

#declare monitor = union
{       
        object
        {
                body
                scale< 1, 0.9, 1 >
                translate< 0, -5, 0 >
                rotate< 5, 0, 0 >
        }
        union
        {
                cylinder
                {
                        < 0, -1, 0 >< 0, 1, 0 >,1
                        scale< 10, 5, 10 >
                        translate< 0, -30, 0 >
                }
                cylinder
                {
                        < 0, -1, 0 >< 0, 1, 0 >,1
                        scale< 20, 0.5, 20 >
                        translate< 0, -35, 0 >
                }
                texture{ pc_texture }
        }
}