/*************************************************************************
 Persistance of Vision Raytracer V3.1 World definition file.

             COBBLESTONE GENERATOR FOR POV-Ray 3.1

 Created by: Thomas de Groot (the Netherlands)
     e-mail: t.degroot@inter.nl.net
         On: 15 May 1999;
    updated: 25 August 1999
             28 September 1999
  Copyright: May be freely used and modified.
             Acknowledgement of author is appreciated.

  The cobblestone was generated for POV-Ray V3.1 by
  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
  
   Patterns: Checkerboard Cobblestones (1)
             Brick-like Cobblestones (2)
             Herringbones (3)
 *************************************************************************/

// Total surface covered by the cobblestones:
#ifndef (OriginX) #declare OriginX=-5;    #end
#ifndef (OriginZ) #declare OriginZ=-5;    #end
#ifndef (EndX)    #declare EndX=5;        #end
#ifndef (EndZ)    #declare EndZ=5;        #end
// Number of the cobblestones in the X-direction:
#ifndef (N)       #declare N=20;          #end
// Cobblestone width:
#ifndef (R)       #declare R=0.3;         #end
// Crack width:
#ifndef (Crack)   #declare Crack=0.01;    #end
// Arching of the surface:
#ifndef (Arching) #declare Arching=false; #end
#ifndef (HumpOff)    #declare HumpOff=0.008;    #end
// Cobblestone pattern:
#ifndef (Pattern) #declare Pattern=2;     #end

default { texture {pigment {color <1,0,0>} } }


// ********  MATERIALS  *******

#ifndef (Cement)
#declare Cement = material {texture { pigment { color Tan} } }
#end

#ifndef (Cobbletex)
#declare Cobbletex= 
// This texture was originally designed by Charles Fusner.
   material {   
     texture {      
       pigment {
         granite
         color_map {
           [ 0.0     rgbft <0.499564, 0.499564, 0.499564, 0.0, 0.0> ]
           [ 0.25    rgbft <0.649707, 0.649707, 0.649707, 0.0, 0.0> ]
           [ 0.5     rgbft <0.499858, 0.499858, 0.499858, 0.0, 0.0> ]
           [ 0.75    rgbft <0.699587, 0.699587, 0.699587, 0.0, 0.0> ]
           [ 1.0     rgbft <0.499644, 0.499644, 0.499644, 0.0, 0.0> ]
         }
         frequency 100.0
         ramp_wave
       }      
       normal {
         crackle , 0.5
         warp {
           turbulence <0.500164, 0.500364, 0.499804>
           omega 0.500404
           lambda 1.999712
         }
       }      
       finish {
         ambient 0.1
         diffuse 0.549996
         specular 0.100002
         roughness 1.0
       }      
     }
     scale 0.25
   }
#end

// ********  SEEDS  *******

#declare Sx = seed(112358);
#declare Sy = seed(235813);
#declare Sz = seed(581321);


// ********  OBJECTS  *******

#declare Cobblestone =
 merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
 }

//superellipsoid { <0.3, 0.3> scale 0.5}

#declare HalfCobblestone =
 object { Cobblestone
   scale <0.5,1,1>
 }

// Width of the cobblestone pattern:
#declare Street_Width=EndX-OriginX;
// Vertical offset:
#declare VertOff=10*N;
#warning concat("Cobblestones calculation of Pattern ",str(Pattern,1,0)," started\n")

// ************  COBBLESTONE TYPES  ************
#switch (Pattern)
#case (1)

#declare M=Crack*(N-1);
#declare C_Length=(Street_Width-M)/N;
#declare C_Width=C_Length*R;

#declare T_Cobblestone =
union {
  object { Cobblestone
    scale <C_Length, C_Width, C_Width>
  }
  box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
    scale <(C_Length+Crack), (C_Width/2), (C_Width+Crack)>
    material { Cement }
  }
  translate <C_Length/2, -(C_Width/2), C_Width/2>
}

#declare J=OriginZ;

#declare Cobblestones=
union {
 #while (J<=abs(EndZ))
  #declare I=OriginX;
  #declare Hump=0;
  #declare N1=1;
  
   #while (N1<=N)
      object { T_Cobblestone
        material {
          Cobbletex
          rotate <rand(Sx), rand(Sy), rand(Sz)>
          translate <rand(Sx), rand(Sy), rand(Sz)>
        }
        
        #if (rand(Sy)<0.5)
            translate <I,-(rand(Sy)/VertOff)+Hump,J>}
        #else
            translate <I,(rand(Sy)/VertOff)+Hump,J>}
        #end
        
        #if (Arching=true)
          #if (N1<=N/2)
            #declare Hump=Hump+HumpOff;
          #else
            #declare Hump=Hump-HumpOff;
          #end
        #end
      
      #declare I=I+C_Length+Crack;
      #declare N1=N1+1;
   #end
   
   #declare J=J+C_Width+Crack;
 #end

} // end of union

#break

//---------------------------------------------------------
#case (2)

#declare M=Crack*N;
// Number of half-stones:
#declare Half=(N*2)+1;
#declare C_Length=((Street_Width-M)/Half)*2;
#declare C_Width=C_Length*R;

#declare T_Cobblestone =
union {
  object { Cobblestone
    scale <C_Length, C_Width, C_Width>
  }
  box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
    scale <C_Length+Crack, C_Width/2, C_Width+Crack>
    material { Cement }
  }
  translate <C_Length/2, -(C_Width/2), C_Width/2>
}

#declare T_HalfCobblestone =
union {
  object { HalfCobblestone
    scale <C_Length, C_Width, C_Width>
  }
  box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
    scale <0.5,1,1>
    scale <C_Length+Crack, -(C_Width/2), C_Width+Crack>
    material { Cement }
  }
  translate <C_Length/4, -(C_Width/2), C_Width/2>
}

#declare J=OriginZ;
#declare Offset=false;

#declare Cobblestones=
union {
   #while (J<=abs(EndZ))
     #declare I=OriginX;
     #declare Hump=0;
     
     #if (Offset=true)
       object { T_HalfCobblestone
         material {
           Cobbletex
           rotate <rand(Sx), rand(Sy), rand(Sz)>
           translate <rand(Sx), rand(Sy), rand(Sz)>
         }
           
         #if (rand(Sy)<0.5)
           translate <I,-(rand(Sy)/VertOff)+Hump,J>}
         #else
           translate <I,(rand(Sy)/VertOff)+Hump,J>}
         #end
         
     #end
     #declare N1=1;
     
     #while (N1<=N)
       object { T_Cobblestone
         material {
           Cobbletex
           rotate <rand(Sx), rand(Sy), rand(Sz)>
           translate <rand(Sx), rand(Sy), rand(Sz)>
         }
         
         #if (Offset=true)
           #if (rand(Sy)<0.5)
             translate <I+(C_Length/2)+Crack,-(rand(Sy)/VertOff)+Hump,J>}
           #else
             translate <I+(C_Length/2)+Crack,(rand(Sy)/VertOff)+Hump,J>}
           #end
           
         #else
           #if (rand(Sy)<0.5)
             translate <I,-(rand(Sy)/VertOff)+Hump,J>}
           #else
             translate <I,(rand(Sy)/VertOff)+Hump,J>}
           #end
         #end
         
         #if (Arching=true)
           #if (N1<=N/2)
             #declare Hump=Hump+HumpOff;
           #else
             #declare Hump=Hump-HumpOff;
           #end
         #end
      
         #declare I=I+C_Length+Crack;
         #declare N1=N1+1;
      #end
      
      #if (Offset=true)
        #declare Offset=false;
      #else
        object { T_HalfCobblestone
          material {
            Cobbletex
            rotate <rand(Sx), rand(Sy), rand(Sz)>
            translate <rand(Sx), rand(Sy), rand(Sz)>
          }
          
          #if (rand(Sy)<0.5)
            translate <I,-(rand(Sy)/VertOff)+Hump,J>}
          #else
            translate <I,(rand(Sy)/VertOff)+Hump,J>}
          #end
        
        #declare Offset=true;
      #end
      
      #declare J=J+C_Width+Crack;
    #end
    
} // end of union
  
#break

//---------------------------------------------------------
#case (3)

#declare M=Crack*(N-1);
#declare Xoff=(Street_Width-M)/N;
#declare Zoff=Xoff/2;
// Size of the individual stones as a function of Zoff:
#declare C_Width=sqrt(pow(Zoff,2)+pow(Zoff,2));
#declare C_Length=C_Width*2;


#declare T_Cobblestone =
union {
  object { Cobblestone
    scale <C_Length, C_Width, C_Width>
  }
  box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
    scale <C_Length+Crack, C_Width/2, C_Width+Crack>
    material{ Cement }
  }
  translate <0, -(C_Width/2), 0>
}

#declare J=OriginZ;
#declare Herring=false;

#declare Cobblestones=
union {
 #while (J<=abs(EndZ))
  #declare I=OriginX;
  #declare Hump=0;
  #declare N1=1;
  
   #while (N1<=N)
    #if (Herring=false)
      object { T_Cobblestone
        material {
          Cobbletex
          rotate <rand(Sx), rand(Sy), rand(Sz)>
          translate <rand(Sx), rand(Sy), rand(Sz)>
        }
        
        #if (rand(Sy)<0.5)
            rotate -45*y
            translate <I,-(rand(Sy)/VertOff)+Hump,J-(Zoff*0.5)>}
        #else
            rotate -45*y
            translate <I,(rand(Sy)/VertOff)+Hump,J-(Zoff*0.5)>}
        #end
      #declare Herring=true;  
    #else
      object { T_Cobblestone
        material {
          Cobbletex
          rotate <rand(Sx), rand(Sy), rand(Sz)>
          translate <rand(Sx), rand(Sy), rand(Sz)>
        }
        
        #if (rand(Sy)<0.5)
            rotate 45*y
            translate <I,-(rand(Sy)/VertOff)+Hump,J+(Zoff*0.5)>}
        #else
            rotate 45*y
            translate <I,(rand(Sy)/VertOff)+Hump,J+(Zoff*.5)>}
        #end
      #declare Herring=false;
    #end
      
    #if (Arching=true)
      #if (N1<=N/2)
          #declare Hump=Hump+HumpOff;
      #else
          #declare Hump=Hump-HumpOff;
      #end
    #end
      
      #declare I=I+(Xoff)+Crack;
      #declare N1=N1+1;
   #end
   
   #declare J=J+(Zoff*2)+Crack;
 #end

} // end of union

#end
#warning concat("Cobblestones calculation of Pattern ",str(Pattern,1,0)," finished\n")

#undef OriginX
#undef OriginZ
#undef EndX
#undef EndZ
#undef N
#undef R
#undef Crack
#undef Arching
#undef HumpOff
#undef Cement
#undef Cobbletex
#undef Pattern