#version unofficial megapov 0.7; 


#declare GrassTex=texture {
  pigment { wrinkles color_map {
            [0.25 color rgb <.5, 0.9, 0.2>*0.4]
            [0.5 color rgb <.3, 0.8, 0.1>*0.4]
            [0.85 color rgb <0.5, 1, 0>*0.4]}}
  normal {function {pigment {gradient z scale .3 translate -y/40 scallop_wave color_map {[0 rgb 0][1 rgb .25]}}}}
  finish {ambient 0.04 diffuse 0.5 specular 4 roughness 0.005}}


#declare GrassTex2=texture {
  pigment { wrinkles color_map {
            [0.25 color rgb <0.3, 1, 0.1>*0.4]
            [0.5 color rgb <0.35, 1, 0.2>*0.4]
            [0.85 color rgb <0.4, 1, 0>*0.4]}}
  normal {function {pigment {gradient z scale .3 translate -y/40 scallop_wave color_map {[0 rgb 0][1 rgb .25]}}}}
  finish {ambient 0.04 diffuse .5 specular 4 roughness .005}}

#declare R = seed(343);

#declare XP = -2.5;
#declare ZP = -2.5;

#declare blade = mesh {

 #declare No_Segs = 15;
 #declare C = 0;
 #declare Seg_length = .25;
 #declare Rot = 90-15;
 #declare Ox = 0;
 #declare Oy =0;
 #declare Nx = Seg_length;
 #declare Ny = Seg_length;
 #declare Z= 0.15;

    #while (C<No_Segs)

                #declare xdist = sin(radians(90-Rot))*Seg_length;
                #declare ydist = cos(radians(90-Rot))*Seg_length;
                   #declare No_Segs = 15+(rand(R)*10);
                    #declare Nx = Ox+xdist;
                    #declare Ny = Oy+ydist;


               #if (C<(No_Segs-1))
                 triangle{<Ox,Oy,Z> <Ox,Oy,-Z> <Nx,Ny,Z> }
                 triangle{<Ox,Oy,-Z> <Nx,Ny,Z> <Nx,Ny,-Z>}
               #else
                 triangle{<Ox,Oy,Z> <Ox,Oy,-Z> <Nx,Ny,0>}
               #end

                #declare Rot = Rot-pow((2+rand(R)*1.5),2);

                  #declare Ox = Nx;
                  #declare Oy = Ny;

                #declare Z=Z-0.012;
                #declare Seg_length = Seg_length +.01;
                #declare C=C+1;
    #end

}//end mesh

#declare Patch = union{
#declare Inc = .05;
#declare Angle = 0;
#declare CT = 0;

    #while (CT<15)

    object{blade
      rotate y* pow((2+rand(R)*180),2)
      scale .5+(rand(R)/2)
        translate<0,0,Inc+(rand(R)/3) >
          rotate y*Angle
          #if(mod(CT,3)=0)
            texture{GrassTex2}
          #else
            texture{GrassTex}
          #end
             }
       #declare CT = CT + 1;
       #declare Inc = Inc + .025;
                #if(CT>150)
                    #declare Angle = Angle + 7.5;
                #else
                    #declare Angle = Angle + 15;
                #end

    #end
}//end of union

#declare grasbusch = object{Patch scale 0.4}