//**************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Petal definition Type 0.1a000220e include file
// By S.Nishimura
//**************************************************


//**********************************************************************************
// check
#ifndef(T_petal)  #local T_petal  = texture { pigment { color rgb < 1, 0, 1 > } } #end
#ifndef(T_stamen) #local T_stamen = texture { pigment { color rgb < 1, 1, 0 > } } #end
#ifndef(T_twig)   #local T_twig   = texture { pigment { color rgb < 0, 1, 0 > } } #end
// definition
#local Torus_org =
torus { 4,0.6
 clipped_by { plane { z, 0 } rotate -(180+180)*y }
 clipped_by { plane { z, 0 } rotate -(270)*y }
 rotate -90*x
}
//
#local Calyx_org =
union {
 #local Ei=5; #local Si=0; #while(Si<Ei)
  cylinder { -4*y,4*y,1 scale <2,1,1> translate 2.3*x rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
}
#local Calyx_wrk = sphere { 0,8 clipped_by { plane { y,0 } } translate 8*y }
#local Calyx_seg = object { Calyx_wrk clipped_by { object { Calyx_org } } scale 0.66 }
//
#local Stamen_org =
union {
 torus { 100,0.08
 clipped_by { plane { z, 0 } rotate (-270+180)*y }
 clipped_by { plane { z, 0 } rotate (-273)*y }
 rotate -90*x translate 100*y }
 sphere { 0,0.14 translate <100*sin(radians(3)),100*(1-cos(radians(3))),0> }
 rotate 80*z translate -8*y
}
#local Stamen_seg =
union {
 union { cylinder { -2*y,-8*y, 0.08 } sphere { -2*y,0.14 } }
 #local Ej=4; #local Sj=0; #while(Sj<Ej)
 #local Ei=8; #local Si=0; #while(Si<Ei)
  object { Stamen_org rotate -5*z translate (1+Sj*0.24)*x rotate (360*Si/Ei+360*Sj/Ei/Ej)*y }
 #local Si=Si+1; #end
 #local Sj=Sj+1; #end
}
//
#local Petal_org =
difference {
 sphere { 0, 8 }
 sphere { 0, 16 translate < 6, 6, 0 > }
 texture { T_petal }
}
//
#declare Petal_seg = 
union {
 #local Ei=5; #local Si=0; #while(Si<Ei)
  object { Petal_org rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 sphere { 0, 8 clipped_by { plane { y,-7 } } texture { T_petal } }
 object { Stamen_seg texture { T_stamen } }
 sphere { 0, 3.4 clipped_by { plane { y,-1 } } texture { T_petal } scale < 1, 0.5, 1 > translate (-8+0.85+0.36)*y }
 object { Calyx_seg texture { T_twig } translate (-8-0.94+0.36)*y }
 sphere { 0, 1.4 clipped_by { plane { y,0 } } texture { T_twig } scale < 1, 0.5, 1 > translate (-8-0.3)*y }
 object { Torus_org texture { T_twig } translate < 4, -8, 0 > }
 translate < -4, 12, 0 >
}
//**********************************************************************************


 

  