//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Space line macro Ver 0.1r010321b include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
// sample line functions
/*
#macro Line_function(Tp,Pv,Func_type)
 #switch(Func_type)
  #case(1) #local Px=5*pi*Tp; #local Py=40*sin(Tp); #local Pz=0; #break    // sin
  #case(2) #local Px=10*Tp; #local Py=6*cos(Tp); #local Pz=0; #break       // cos
  #case(3) #local Px=40*cos(Tp); #local Py=40*sin(Tp); #local Pz=0; #break // circle

  #case(9) #local Px=40*cos(Tp); #local Py=6*Tp; #local Pz=40*sin(Tp); #break // helix
 #end
 #local Pv=< Px,Py,Pz >;
#end
*/
//**********************************************************************************
// cylinder space line macro
#macro Space_line(Lw,V1,Func_type)
#local Ts=V1.x; #local Te=V1.y; #local Ta=V1.z; #local Pv=<0,0,0>;
 Line_function(Ts,Pv,Func_type) #local P1=Pv;
 #while(Ts<Te)
 Line_function(Ts+Ta,Pv,Func_type) #local P2=Pv;
 #local D1=P1+(P2-P1)/3; #local D2=P1+(P2-P1)*2/3;
 sphere { P1, Lw } cylinder { P1, D1, Lw }
 Line_function(Ts+Ta*2,Pv,Func_type) #local P3=Pv;
 #local D3=P2+(P3-P2)/3; #local D4=P2+(P3-P2)*2/3;
 #local D5=D2+(D3-D2)/3; #local D6=D2+(D3-D2)*2/3;
 sphere { D1, Lw } cylinder { D1, D5, Lw }
 sphere { D5, Lw } cylinder { D5, D6, Lw }
 sphere { D6, Lw } cylinder { D6, D4, Lw }
 sphere { D4, Lw } cylinder { D4, P3, Lw }
 #local P1=P3;
 #local Ts=Ts+Ta*2; #end
#end
//----------------------------------------------------------------------------------
// sample parameters (Lw:line width V1:<Ts,Te,Ta> Func_type:function No.)
//union { Space_line(1,pi*< -1, 1,1/32>,1) pigment { color rgb 1 } }
//**********************************************************************************
#macro Cone_line(Lw,V1,V2,Func_type)
 Bio_line(Lw,V1,V2,Func_type)
#end
//----------------------------------------------------------------------------------
// cone space line macro
#macro Bio_line(Lw,V1,V2,Func_type)
#local Ws=V2.x; #local We=V2.y; #local Bh=V2.z;
#local Ts=V1.x; #local Te=V1.y; #local Ta=V1.z; #local Pv=<0,0,0>;
 Line_function(Ts,Pv,Func_type) #local P1=Pv; 
 #while(Ts<Te)
 Line_function(Ts+Ta,Pv,Func_type) #local P2=Pv;
 cone { <P1.x,P1.y+Bh*Ts,P1.z>,abs(Lw*cos(Ws+(We-Ws)*Ts/Te)),<P2.x,P2.y+Bh*(Ts+Ta),P2.z>,abs(Lw*cos(Ws+(We-Ws)*(Ts+Ta)/Te)) }
 sphere { <P2.x,P2.y+Bh*(Ts+Ta),P2.z>,abs(Lw*cos(Ws+(We-Ws)*(Ts+Ta)/Te)) }
 #local P1=P2;
 #local Ts=Ts+Ta; #end
#end
//----------------------------------------------------------------------------------
// sample parameters (Lw:line width V1:<Ts,Te,Ta> V2:<Ws,We,Bh> Func_type:function No.)
//union { Bio_line(2,pi*< -2, 2, 1/12 >,pi*< 0, 1/2.6, 0 >,9) pigment { color rgb 1 } }
//**********************************************************************************
#macro RtoSpherical_coordinates(Pv)
 #local RR=vlength(Pv); #local Rh=vlength(<Pv.x,0,Pv.z>);
 #if(Rh!=0) 
  #if(Pv.z/Rh>=0) #local Sg=1; #else #local Sg=-1; #end
  #local HH=Sg*acos(Pv.x/Rh);
 #else #local HH=0; #end
 #if(Pv.y/RR>=0) #local Sg=1; #else #local Sg=-1; #end 
 #local VV=Sg*acos(Rh/RR);
 #local Pv=<RR,HH,VV>;
#end
//----------------------------------------------------------------------------------
// space arrange macro
#macro Space_arrange(V1,Func_type)
#local Ts=V1.x; #local Te=V1.y; #local Ta=V1.z; #local Pv=<0,0,0>;
 Line_function(Ts,Pv,Func_type) #local P1=Pv;
 #while(Ts<Te)
 Line_function(Ts+Ta,Pv,Func_type) #local P2=Pv;
 #local Pv=P2-P1; RtoSpherical_coordinates(Pv)
 object { Obj_seg rotate degrees(Pv.z)*z rotate -degrees(Pv.y)*y translate P1 }
 #local P1=P2;
 #local Ts=Ts+Ta; #end
#end
//**********************************************************************************
// sample parameters (V1:<Ts,Te,Ta> Func_type:function No.)
//#local Obj_seg = cone { 0,2 10*x,0 pigment { color rgb 1 } }
//union { Space_arrange(pi*<-1,1,1/5>,3) }
//**********************************************************************************
