// Persistence Of Vision raytracer version 3.5 beta
// Sliding screen Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


camera { location < 40, 160, -200 >
	 look_at < 2, 50, -10 >
	 angle 50
}

light_source { < 200,340,200 > color rgb 1.2 fade_distance 400 fade_power 1 }
light_source { < 0,2,70 > color rgb 0.6 shadowless }

//----------------------------------------------------------------------------------
coordinate_color( 120, 0.3, 0.5, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
// twig
coordinate_color( 90, 1, 0.83, 1, 1 )
coordinate_color(  0, 0, 0.40, 1, 2 )
#local T_twig =
texture { 
  pigment { wood
            turbulence 0.8
            color_map { [ 0.3 rgb < R1, G1, B1 > ]
                        [ 0.6 rgb < R2, G2, B2 > ] } scale 0.2 }
}
//
#include "Curved_line.mcr.inc"
#local Pmax=1+4;
#local Vp=array[Pmax] #local Si=0; #while(Si<Pmax) #local Vp[Si]=<0,0>; #local Si=Si+1; #end
#local Vp[0]=<0,-180>; #local Vp[1]=<1,-90>; #local Vp[2]=<40,45>;
#local Vp[3]=<80,-5>; #local Vp[4]=<-20,0.5>;
#local Twig_obj = union { Curvature_line(1,1) texture { T_twig } rotate -90*x }
//----------------------------------------------------------------------------------
// leaf
coordinate_color( 100, 0.4, 0.4, 1, 1 )
#include "Leaf_typeA.def.inc"
#local Leaf_obj =
union {
 object { Leaf_seg }
 object { Leaf_seg rotate 180*y }
 pigment { color rgb < R1, G1, B1 > }
 finish { reflection 0.1 }
} 
//----------------------------------------------------------------------------------
// petal
coordinate_color( 350, 0.60, 0.4, 1, 1 )
coordinate_color( 340, 1.00, 0.6, 1, 2 )
#local T_petal =
texture { 
  pigment { wood
            turbulence 0.6
            color_map { [ 0.4 rgb < R1, G1, B1 > ]
                        [ 0.6 rgb < R2, G2, B2 > ] } }
  finish { ambient 0.2 reflection 0.1 } }
//
coordinate_color(  40, 0.70, 0.6, 1, 3 )
coordinate_color(  20, 0.70, 0.6, 1, 4 )
#local T_stamen =
texture { 
  pigment { gradient x
            color_map { [ 0.2 rgb < R3, G3, B3 > ]
                        [ 0.8 rgb < R4, G4, B4 > ] } }
  normal { bumps 0.5 scale 0.2 } } 
//
#include "Petal_typeA.def.inc"
//----------------------------------------------------------------------------------
// blossom
#local Blossom_seg =
union {
 object { Twig_obj }
 object { Leaf_obj scale 0.92 translate < 32+3, 11.4+2.3, 0 > }
 object { Petal_seg scale 0.9 rotate < 0, 180, 34 > translate < 31+3, 15+2.3, 0 > }
 object { Petal_seg rotate < 180, 180, 30 > translate < 25, 8.5, 0 > }
 object { Petal_seg rotate <-90,180,30> translate < 5, 1.5, 0 > }
}
//**********************************************************************************
// twig
coordinate_color( 360, 0.0, 0.6, 1, 1 )
coordinate_color(  10, 0.3, 0.4, 1, 2 )
#local Bud_twig =
union {
 torus { 25,1.5 sturm rotate -90*x
  clipped_by { plane { x, 0 } rotate (90-30)*z }
  clipped_by { plane { x, 0 } rotate 180*z }
  translate 25*y }
 cone { -50*x,2.0, 0,1.5 }
 texture { T_twig }
}
//----------------------------------------------------------------------------------
// leaf
coordinate_color( 60, 1.0, 0.4, 1, 1 )
//#include "Leaf_typeA.def.inc"
#local Bud_leaf = object { Leaf_seg pigment { color rgb < R1, G1, B1 > } scale 2 }
//----------------------------------------------------------------------------------
// bud
#include "Bud_typeA.def.inc"
#local Bud_obj =
union {
 object { Bud_seg scale < 0.5, 0.6, 0.5 > rotate  15*z }
 object { Bud_seg scale < 0.2, 0.8, 0.2 > rotate -30*z }
 object { Bud_seg scale < 0.7, 0.9, 0.8 > rotate -95*z }
 object { Bud_twig translate < -19, -8, 0 >}
 object { Bud_leaf rotate < 0, 90, -90 > translate -10*x }
 object { Bud_leaf rotate < 0,-90, -90 > translate < -32, -8, 0 > }
 translate <50+19,8,0>  
}
//**********************************************************************************
#local Blossom_obj =
union {
 union { object { Twig_obj }
         object { Petal_seg rotate <90,180,30> translate < 5, 1.5, 0 > }
                      scale 3 rotate < 0,0,180 > }
 object { Blossom_seg scale 3 }
 object { Bud_obj rotate < -80,20,0 > translate 2*y }
}
// rotate 180*y -10*x -8*z
object { Blossom_obj scale 0.8 rotate < 10,180,-8 > translate <50,0,60> no_shadow }
//**********************************************************************************
#include "Space_line.mcr.inc"
//----------------------------------------------------------------------------------
// space line functions
#macro Line_function(Tp,Pv,Func_type)
 #switch(Func_type)
  #case(1) #local Px=5*Tp; #local Py=pow(Tp,2); #local Pz=0; #break  // grass
  #case(2) #local Px=12*Tp; #local Py=0; #local Pz=3*cos(Tp); #break // rock

  #case(11) #local Px=sin(Tp); #local Py=5*Tp; #local Pz=0; #break   // deco
  #case(12) #local Px=5*Tp; #local Py=5*sin(Tp); #local Pz=0; #break
  #case(13) #local Px=5*sin(Tp); #local Py=3*Tp; #local Pz=0; #break
 #end
 #local Pv=< Px,Py,Pz >;
#end
//----------------------------------------------------------------------------------
// grass
coordinate_color(60,0.9,0.6,1,1)
#local P_grass = pigment { color rgb <R1,G1,B1> }
#local Grass_org = union { Bio_line(2,pi*< 0, 1, 1/12 >,pi*< 0, 1/2.4, 0 >,1) }
#local Grass_seg =
union {
 #local Ei=5; #local Si=0; #while(Si<Ei)
  object { Grass_org scale <1,9,2> rotate 360*Si/Ei*y }
  object { Grass_org scale <1,9,2> rotate -10*z rotate (360/Ei/3+360*Si/Ei)*y }
  object { Grass_org scale <1,9,2> rotate -20*z rotate (360/Ei*2/3+360*Si/Ei)*y }
 #local Si=Si+1; #end
}
// rock
coordinate_color(30,0.3,0.7,1,2)
#local T_rock =
 texture { pigment { color rgb <R2,G2,B2> } normal { bumps 0.4 scale 0.6 } }
#local Rock_org = union { Bio_line(18,pi*< 0, 0.8, 1/12 >,pi*< -1/8, 1/4, 0 >,2) scale 2 }
//----------------------------------------------------------------------------------
#local Zof =80;
union {
 object { Grass_seg pigment { P_grass } scale 0.45 rotate  90*y translate < -10,0,-42+Zof > }
 object { Grass_seg pigment { P_grass } scale 0.50 translate < 75,0,160+Zof > }
 object { Grass_seg pigment { P_grass } scale 0.60 rotate 270*y translate < -135,0,240+Zof > }
 object { Grass_seg pigment { P_grass } scale 0.70 rotate 180*y translate < -20,0,280+Zof > }
 object { Rock_org texture { T_rock } scale 0.6 rotate 190*y translate <-20,-6,-60+Zof> }
 object { Rock_org texture { T_rock } scale 0.7 rotate -10*y translate <60,-3,120+Zof> }
 object { Rock_org texture { T_rock } rotate 320*y translate <-160,-8,160+Zof> }
 object { Rock_org texture { T_rock } rotate 240*y translate <-40,-10,320+Zof> }
 object { Rock_org texture { T_rock } rotate 180*y translate <-80,-14,460+Zof> }
 translate -41*y
}
//**********************************************************************************
// water
coordinate_color(360,0.00,0.85,1,4)
coordinate_color(180,0.12,0.60,1,5)
coordinate_color(150,0.18,0.25,1,6)
coordinate_color(150,0.25,0.15,1,7)
#local P_water =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0,0.100 color rgb <R4,G4,B4> color rgb <R5,G5,B5> ]
                       [0.1,0.500 color rgb <R5,G5,B5> color rgb <R6,G6,B6> ]
                       [0.5,1.001 color rgb <R6,G6,B6> color rgb <R7,G7,B7> ] }
           scale <6,4,6>
 }
coordinate_color(120,1,0.5,1,3)
#local T_water =
texture {
 pigment { color rgb <R3,G3,B3> filter 0.9 }
 pigment { P_water transmit 0.7 }
 normal { ripples 0.75 frequency 10 }
 finish { reflection 0.3 conserve_energy }
}
#local I_water = interior { ior 1.02 caustics 0.04 }
#local M_water = material { texture { T_water scale 50 } interior { I_water } }
//----------------------------------------------------------------------------------
union {
 plane { y, 0 material { M_water } }
 plane { y,-9 pigment { color rgb 1 } normal { bumps 0.3 scale 24 } }
 translate -40*y
}
//**********************************************************************************
// decoration
coordinate_color(270,1.0,0.70,1,2)
coordinate_color( 60,0.9,0.75,1,3)
coordinate_color( 90,0.8,0.80,1,4)
#local P_deco =
 pigment { wood
           turbulence 0.6
           color_map { [0.0 rgb <R2,G2,B2> ]
                       [0.8 rgb <R3,G3,B3> ]
                       [1.0 rgb <R4,G4,B4> ] }
 }
#local F_deco = finish { crand 0.02 ambient 0.5 diffuse 0.63 phong 0.2 phong_size 10 }
#local T_deco = texture { pigment { P_deco } finish { F_deco } normal { bumps 0.05 } }
#local Deco_a = union { Bio_line(1,pi*< 0, 2, 1/8 >,pi*< 0, 1/2.4, 0 >,11) }
#local Deco_b = union { Bio_line(1,pi*< 0, 2, 1/8 >,pi*< 0, 1/2.4, 0 >,12) }
#local Deco_c =
union { 
 union { Bio_line(1,pi*< 0, 2, 1/8 >,pi*< 0, 1/2.4, 0 >,13) rotate 8*z
  translate <-10*cos(radians(45)),10*sin(radians(45)),0> }
 torus { 10,1
  clipped_by { plane { z,0 } rotate -(135+180)*y }
  clipped_by { plane { z,0 } rotate -(180)*y }
  rotate -90*x }
 translate 10*x 
}
#include "Sanskrit.char.inc"
#local Monjyu_seg =
union {
 object { Monjyu_char scale <2,1,2> translate <0,-0.5,0.2> }
 torus { 3,0.5 }
 rotate (-45-76+90)*y
}
#local Fugen_seg =
union {
 object { Fugen_char scale <2,1,2> translate <-0.1,-0.5,0.2> }
 torus { 3,0.5 }
 rotate (45-14)*y
}
#local Tr=46; #local Tx=Tr*cos(radians(45)); #local Ty=Tr*sin(radians(45));
#local Deco_org =
union {
 object { Deco_a rotate -45*z translate < Tx, Ty, 0 > }
 object { Deco_b rotate -45*z translate < Tx+4, Ty-4, 0 > }
 object { Deco_b rotate <0,180,-45> translate < Tx-4, Ty+4, 0 > }
 object { Deco_c rotate -60*z translate < Tx+2, Ty-2, 0 > }
 object { Deco_c rotate <0,180,-30> translate < Tx-2, Ty+2, 0 > }
 object { Monjyu_seg rotate -90*x translate (Tr+3+6)*y rotate -76*z }
 object { Fugen_seg rotate -90*x translate (Tr+3+6)*y rotate -14*z }
 texture { T_deco }
 rotate 45*z
}
union {
 torus { 45+1, 1 texture { T_deco } rotate -90*x }
 torus { 50, 0.5 texture { T_deco } rotate -90*x }
 object { Deco_org rotate -45*z }
 object { Deco_org rotate  45*z }
 object { Deco_org rotate 135*z }
 object { Deco_org rotate 225*z }
 translate <18,96,-100-4>
}
//----------------------------------------------------------------------------------
// wall
coordinate_color(20,0.6,0.8,1,1)
#local T_wall =
texture { 
 pigment { color rgb <R1,G1,B1> }
 finish { ambient 0.5 }
 normal { bumps 0.3 scale 0.2 }
}
#local Wall_seg =
difference {
 box { <-200,-100,-4>,<200,100,4> }
 cylinder {-10*z,10*z,45 scale 1.00001 }
 torus { 45,0.8 rotate -90*x }
}
// sliding
coordinate_color(30,1.0,0.70,1,2)
coordinate_color(25,0.9,0.75,1,3)
coordinate_color(20,0.8,0.80,1,4)
#local P_sliding =
 pigment { wood
           turbulence 0.6
           color_map { [0.8 rgb <R2,G2,B2> ]
                       [0.8 rgb <R3,G3,B3> ]
                       [1.0 rgb <R4,G4,B4> ] }
 }
#local T_sliding = texture { pigment { P_sliding } finish { ambient 0.5 } }
#local T_paper = texture { pigment { color rgbf <1,1,1,0.12> } finish { ambient 0.8 } }
#local Sliding_org = superellipsoid { <0.2,0.2> scale <0.5,45,1> }
#local Up =12;
#local Sliding_seg =
union {
 #local Ei=4; #local Si=0; #while(Si<Ei)
 #if(Si=0) #local Sc=2; #else #local Sc=1; #end
  object { Sliding_org scale <Sc,1,1> translate Up*Si*x }
  object { Sliding_org scale <1,0.5,1> translate 45/2*y rotate -90*z translate  Up*Si*y }
  object { Sliding_org scale <1,0.5,1> translate 45/2*y rotate -90*z translate -Up*Si*y }
 #local Si=Si+1; #end
 plane { z,0 clipped_by { box {<0,-45,-1>,<45,45,1>} } texture { T_paper } }
}
//
union {
 object { Wall_seg texture { T_wall } }
 object { Sliding_seg texture { T_sliding } translate 2.5*Up*x }
 object { Sliding_seg texture { T_sliding } rotate 180*y translate -2*Up*x }
 translate <18,96,-100>
}
//**********************************************************************************
// Signature
//#include "Sealpositive.sgn.inc"
#local Lc=< 40, 160, -200 >; #local La=< 2, 50, -10 >; #local Ag=50;
#local Sz=0.6; #local Lz=-vlength(Lc-La); #local Vx=(1-Sz)*Lz*tan(radians(Ag/2));
#local Tx=Vx+4-1.5; #local Ty=Vx+5-2; #local Tz=Sz*Lz;
#local Rx=degrees(atan2((Lc.y-La.y),sqrt(pow((Lc.x-La.x),2)+pow((Lc.z-La.z),2))));
#local Ry=180+degrees(atan2((Lc.x-La.x),(Lc.z-La.z))); #local Rz=0;
//object { Sealing scale 0.4 translate < Tx,Ty*3/4,Tz > rotate < Rx,Ry,Rz > translate La }
//----------------------------------------------------------------------------------