#version 3.5;

#include "transforms.inc"

// storing methods

#macro Get_Point(Origami,Pos)
  <Origami[0][Pos].red,Origami[0][Pos].green,Origami[0][Pos].blue>
#end

#macro Get_Point_Coords(Origami,Name)
  #local Pos=Find_Point(Origami[1],Name);
  #local Point=Get_Point(Origami,Pos);
  #local UV=Get_UV(Origami,Pos);
  <Point.x,Point.y,Point.z,UV.u,UV.v>
#end

#macro Get_UV(Origami,Pos)
  <Origami[0][Pos].filter,Origami[0][Pos].transmit>
#end

#macro Add_Point(Origami,Point,U,V,Name)
  #ifdef(Origami[0])
    #local Old=Origami[0]
    #local New_Points=array[dimension_size(Old,1)+1]
    #local New_Names=array[dimension_size(Old,1)+1]
    #local Counter=0;
    #while(Counter<dimension_size(Old,1))
      #ifdef(Old[Counter])
        #local New_Points[Counter]=Origami[0][Counter];
        #local New_Names[Counter]=Origami[1][Counter]
      #end
      #local Counter=Counter+1;
    #end
  #else
    #local New_Points=array[1]
    #local New_Names=array[1]
  #end
  #local Position=dimension_size(New_Points,1)-1;
  #local P=Point+<0,0,0>;
  #local New_Points[Position]=<P.x,P.y,P.z,U,V>;
  #local New_Names[Position]=Name
  #declare Origami[0]=New_Points
  #declare Origami[1]=New_Names
  (Position)
#end

#macro Add_PointUV(Origami,Point,Name)
  #local UV=<Point.filter,Point.transmit>;
  Add_Point(Origami,<Point.red,Point.green,Point.blue>,UV.u,UV.v,Name)
#end

#macro Copy_Point(Src,Dest,Name)
  Add_PointUV(Dest,Get_Point_Coords(Src,Name),Name);
#end

#macro Add_Triangle(Origami,P1,P2,P3)
  #ifdef(Origami[2])
    #local Triangles=Origami[2]
    #local New_Array=array[dimension_size(Triangles,1)+1]
    #local Counter=0;
    #while(Counter<dimension_size(Triangles,1))
      #ifdef(Triangles[Counter])
        #local New_Array[Counter]=Triangles[Counter];
      #end
      #local Counter=Counter+1;
    #end
  #else
    #local New_Array=array[1]
  #end
  #local Position=dimension_size(New_Array,1)-1;
  #local New_Array[Position]=<P1,P2,P3>;
  #declare Origami[2]=New_Array
#end

#macro Add_RTriangle(Origami,P1,P2,P3)
  Add_Triangle(Origami,P2,P1,P3)
#end
// operations

#macro Add_Quad(Origami,P1,P2,P3,P4)
  Add_Triangle(Origami,P1,P2,P3)
  Add_Triangle(Origami,P1,P3,P4)
#end

#macro Add_RQuad(Origami,P1,P2,P3,P4)
  Add_RTriangle(Origami,P1,P2,P3)
  Add_RTriangle(Origami,P1,P3,P4)
#end

#macro Add_Poly(Origami,Array)
  #local Counter=2;
  #while (Counter<dimension_size(Array,1))
    Add_Triangle(Origami,Array[0],Array[Counter-1],Array[Counter])
    #local Counter=Counter+1;
  #end
#end

#macro Add_RPoly(Origami,Array)
  #local Counter=2;
  #while (Counter<dimension_size(Array,1))
    Add_RTriangle(Origami,Array[0],Array[Counter-1],Array[Counter])
    #local Counter=Counter+1;
  #end
#end

#macro Find_Point(Names,Name)
  #local Pos=-1;
  #local Counter=0;
  #while (Counter<dimension_size(Names,1))
    #ifdef(Names[Counter])
      #if(strcmp(Names[Counter],Name)=0)
        #local Pos=Counter;
      #end
    #end
    #local Counter=Counter+1;
  #end
  (Pos)
#end

#macro Split_Triangles(Origami,Pos1,Pos2,New_Pos)
  #local Triangles=Origami[2]
  #local Triangle=0;
  #while (Triangle<dimension_size(Triangles,1))
    #ifdef(Triangles[Triangle])
      #if(Triangles[Triangle].x=Pos1)
        #if(Triangles[Triangle].y=Pos2)
          #local Triangles[Triangle]=<Pos1,New_Pos,Triangles[Triangle].z>;
          #declare Origami[2]=Triangles
          Add_Triangle(Origami,New_Pos,Pos2,Triangles[Triangle].z)
          #local Triangles=Origami[2]
        #else
          #if(Triangles[Triangle].z=Pos2)
            #local Triangles[Triangle]=<Pos1,Triangles[Triangle].y,New_Pos>;
            #declare Origami[2]=Triangles
            Add_Triangle(Origami,New_Pos,Triangles[Triangle].y,Pos2)
            #local Triangles=Origami[2]
          #end
        #end
      #else
        #if(Triangles[Triangle].y=Pos1)
          #if(Triangles[Triangle].z=Pos2)
            #local Triangles[Triangle]=<Triangles[Triangle].x,Pos1,New_Pos>;
            #declare Origami[2]=Triangles
            Add_Triangle(Origami,Triangles[Triangle].x,New_Pos,Pos2)
            #local Triangles=Origami[2]
          #else
            #if(Triangles[Triangle].x=Pos2)
              #local Triangles[Triangle]=<New_Pos,Pos1,Triangles[Triangle].z>;
              #declare Origami[2]=Triangles
              Add_Triangle(Origami,Pos2,New_Pos,Triangles[Triangle].z)
              #local Triangles=Origami[2]
            #end
          #end
        #else
          #if(Triangles[Triangle].z=Pos1)
            #if(Triangles[Triangle].x=Pos2)
              #local Triangles[Triangle]=<New_Pos,Triangles[Triangle].y,Pos1>;
              #declare Origami[2]=Triangles
              Add_Triangle(Origami,Pos2,Triangles[Triangle].y,New_Pos)
              #local Triangles=Origami[2]
            #else
              #if(Triangles[Triangle].y=Pos2)
                #local Triangles[Triangle]=<Triangles[Triangle].x,New_Pos,Pos1>;
                #declare Origami[2]=Triangles
                Add_Triangle(Origami,Triangles[Triangle].x,Pos2,New_Pos)
                #local Triangles=Origami[2]
              #end
            #end
          #end
        #end
      #end
    #end
    #local Triangle=Triangle+1;
  #end
  #declare Origami[2]=Triangles
#end

#macro Split_Edge(Origami,Name1,Name2,New_Name,Ratio)
  #local Pos1=Find_Point(Origami[1],Name1);
  #local Pos2=Find_Point(Origami[1],Name2);
  #local Point1=Get_Point(Origami,Pos1);
  #local Point2=Get_Point(Origami,Pos2);
  #local UV1=Get_UV(Origami,Pos1);
  #local UV2=Get_UV(Origami,Pos2);
  #local Point1=Point1+Ratio*(Point2-Point1);
  #local UV1=UV1+Ratio*(UV2-UV1);
  #local New_Pos=Add_Point(Origami,Point1,UV1.u,UV1.v,New_Name);
  Split_Triangles(Origami,Pos1,Pos2,New_Pos)
#end

#macro Get_Angle(Origami,NameA,NameO,NameB)
  #local PosA=Find_Point(Origami[1],NameA);
  #local PosO=Find_Point(Origami[1],NameO);
  #local PosB=Find_Point(Origami[1],NameB);
  #local PointA=Get_Point(Origami,PosA);
  #local PointO=Get_Point(Origami,PosO);
  #local PointB=Get_Point(Origami,PosB);
  #local EdgeA=PointA-PointO;
  #local EdgeB=PointB-PointO;
  VAngleD(EdgeA,EdgeB)
#end

#macro Intersect_3P_Plane_With_2P_Line(P1,P2,P3,L1,L2)
  #local Normal=vcross(P2-P1,P3-P1);
  #local Plane=plane{Normal 0 translate P1}
  trace(Plane,L1,vnormalize(L2-L1),Normal)
#end

#macro Split_Angle(Origami,NameA,NameO,NameB,Name1,Name2,New_Name,Ratio)
  #local PosA=Find_Point(Origami[1],NameA);
  #local PosO=Find_Point(Origami[1],NameO);
  #local PosB=Find_Point(Origami[1],NameB);
  #local Pos1=Find_Point(Origami[1],Name1);
  #local Pos2=Find_Point(Origami[1],Name2);
  #local PointA=Get_Point(Origami,PosA);
  #local PointO=Get_Point(Origami,PosO);
  #local PointB=Get_Point(Origami,PosB);
  #local Point1=Get_Point(Origami,Pos1);
  #local Point2=Get_Point(Origami,Pos2);
  #local EdgeA=PointA-PointO;
  #local EdgeB=PointB-PointO;
  #local Angle=Get_Angle(Origami,NameA,NameO,NameB);
  #local Normal=vcross(EdgeA,EdgeB);
  #local Point=vaxis_rotate(EdgeA,Normal,Ratio*Angle)+PointO;
  #local Point=Intersect_3P_Plane_With_2P_Line(PointO,Point,PointO+Normal,Point1,Point2);
  #local Dist1=vlength(Point-Point1);
  #local Dist2=vlength(Point-Point2);
  #local UV=Interpolate(Dist1,0,Dist1+Dist2,Get_UV(Origami,Pos1),Get_UV(Origami,Pos2),1);
  #local New_Pos=Add_Point(Origami,Point,UV.u,UV.v,New_Name);
  Split_Triangles(Origami,Pos1,Pos2,New_Pos)
#end

#macro Follow_Edge(Origami,NameA,NameB,Name1,Name2,New_Name)
  #local PosA=Find_Point(Origami[1],NameA);
  #local PosB=Find_Point(Origami[1],NameB);
  #local Pos1=Find_Point(Origami[1],Name1);
  #local Pos2=Find_Point(Origami[1],Name2);
  #local PointA=Get_Point(Origami,PosA);
  #local PointB=Get_Point(Origami,PosB);
  #local Point1=Get_Point(Origami,Pos1);
  #local Point2=Get_Point(Origami,Pos2);
  #local Edge1=Point1-PointB;
  #local Edge2=Point2-PointB;
  #local Normal=vcross(Edge1,Edge2);
  #local Point=Intersect_3P_Plane_With_2P_Line(PointA,PointB,PointB+Normal,Point1,Point2);
  #local Dist1=vlength(Point-Point1);
  #local Dist2=vlength(Point-Point2);
  #local UV=Interpolate(Dist1,0,Dist1+Dist2,Get_UV(Origami,Pos1),Get_UV(Origami,Pos2),1);
  #local New_Pos=Add_Point(Origami,Point,UV.u,UV.v,New_Name);
  Split_Triangles(Origami,Pos1,Pos2,New_Pos)
#end

#macro Mirror_Edge(Origami,NameA,NameB,Name1,Name2,NameM,NameN,New_Name)
  // A,B Edge to mirror
  // 1,2 Mirror Edge
  // M,N Edge to split
  #local PosA=Find_Point(Origami[1],NameA);
  #local PosB=Find_Point(Origami[1],NameB);
  #local Pos1=Find_Point(Origami[1],Name1);
  #local Pos2=Find_Point(Origami[1],Name2);
  #local PosM=Find_Point(Origami[1],NameM);
  #local PosN=Find_Point(Origami[1],NameN);
  #local PointA=Get_Point(Origami,PosA);
  #local PointB=Get_Point(Origami,PosB);
  #local Point1=Get_Point(Origami,Pos1);
  #local Point2=Get_Point(Origami,Pos2);
  #local PointM=Get_Point(Origami,PosM);
  #local PointN=Get_Point(Origami,PosN);
  #local EdgeAB=PointB-PointA;
  #local Edge12=Point2-Point1;
  #local Normal1=vcross(EdgeAB,Edge12);
  #local Normal2=vcross(Normal1,Edge12);
  #local Point=Intersect_3P_Plane_With_2P_Line(Point1,Point2,Point2+Normal1,PointA-Normal2,PointA);
  #if(vlength(Point)=0)
    #local Point=Intersect_3P_Plane_With_2P_Line(Point1,Point2,Point2+Normal1,PointA+Normal2,PointA);
  #end
  #local PointA1=2*Point-PointA;
  #local Point=Intersect_3P_Plane_With_2P_Line(Point1,Point2,Point2+Normal1,PointB-Normal2,PointB);
  #if(vlength(Point)=0)
    #local Point=Intersect_3P_Plane_With_2P_Line(Point1,Point2,Point2+Normal1,PointB+Normal2,PointB);
  #end
  #local PointB1=2*Point-PointB;
  #local Point=Intersect_3P_Plane_With_2P_Line(PointM,PointN,PointN+Normal1,PointA1,PointB1);
  #local DistM=vlength(Point-PointM);
  #local DistN=vlength(Point-PointN);
  #local UV=Interpolate(DistM,0,DistM+DistN,Get_UV(Origami,PosM),Get_UV(Origami,PosN),1);
  #local New_Pos=Add_Point(Origami,Point,UV.u,UV.v,New_Name);
  Split_Triangles(Origami,PosM,PosN,New_Pos)
#end

#macro Cross_Edge(Origami,NameA,NameB,Name1,Name2,New_Name)
  #local PosA=Find_Point(Origami[1],NameA);
  #local PosB=Find_Point(Origami[1],NameB);
  #local Pos1=Find_Point(Origami[1],Name1);
  #local Pos2=Find_Point(Origami[1],Name2);
  #local PointA=Get_Point(Origami,PosA);
  #local PointB=Get_Point(Origami,PosB);
  #local Point1=Get_Point(Origami,Pos1);
  #local Point2=Get_Point(Origami,Pos2);
  #local EdgeAB=PointB-PointA;
  #local Edge12=Point2-Point1;
  #local Normal=vcross(EdgeAB,Edge12);
  #local Point=Intersect_3P_Plane_With_2P_Line(PointA,PointB,PointB+Normal,Point1,Point2);
  Split_Edge(Origami,Name1,Name2,New_Name,vlength(Point-Point1)/vlength(Point1-Point2))
#end

#macro Around_Edge(Origami,Edge1,Edge2,Name,Angle)
  #local N1=Find_Point(Origami[1],Edge1);
  #local N2=Find_Point(Origami[1],Edge2);
  #local N3=Find_Point(Origami[1],Name);
  #local P1=<Origami[0][N1].red,Origami[0][N1].green,Origami[0][N1].blue>;
  #local P2=<Origami[0][N2].red,Origami[0][N2].green,Origami[0][N2].blue>;
  #local P3=<Origami[0][N3].red,Origami[0][N3].green,Origami[0][N3].blue>;
  #local Axis=vnormalize(P2-P1);
  #local P3=vaxis_rotate(P3-P1,Axis,Angle)+P1;
  #declare Origami[0][N3]=<P3.x,P3.y,P3.z,Origami[0][N3].filter,Origami[0][N3].transmit>;
#end

#macro Around_Edge_List(Origami,Edge1,Edge2,List,Angle)
  #local N1=Find_Point(Origami[1],Edge1);
  #local N2=Find_Point(Origami[1],Edge2);
  #local P1=<Origami[0][N1].red,Origami[0][N1].green,Origami[0][N1].blue>;
  #local P2=<Origami[0][N2].red,Origami[0][N2].green,Origami[0][N2].blue>;
  #local Axis=vnormalize(P2-P1);
  #local Counter=0;
  #while(Counter<dimension_size(List,1))
    #local N3=List[Counter];
    #local P3=<Origami[0][N3].red,Origami[0][N3].green,Origami[0][N3].blue>-P1;
    #local P3=vaxis_rotate(P3,Axis,Angle)+P1;
    #declare Origami[0][N3]=<P3.x,P3.y,P3.z,Origami[0][N3].filter,Origami[0][N3].transmit>;
    #local Counter=Counter+1;
  #end
#end

#macro Transform_Origami(Origami,Transform)
  #local Point=0;
  #while (Point<dimension_size(Origami[0],1))
    #local P=vtransform(Get_Point(Origami,Point),Transform);
    #local UV=Get_UV(Origami,Point);
    #declare Origami[0][Point]=<P.x,P.y,P.z,UV.u,UV.v>;
    #local Point=Point+1;
  #end
#end

// drawing methods

#macro Draw_Wireframe(Origami,Radius)
  union{
    #local Size=dimension_size(Origami[0],1);
    #local Edges=array[Size][Size]
    #local Vertices=array[Size]
    #local Triangles=Origami[2]
    #local Triangle=0;
    #while (Triangle<dimension_size(Triangles,1))
      #ifdef(Triangles[Triangle])
        #local P1=Triangles[Triangle].x;
        #local P2=Triangles[Triangle].y;
        #local P3=Triangles[Triangle].z;
        #ifndef(Vertices[P1])
          sphere{Get_Point(Origami,P1)Radius}
          #local Vertices[P1]=yes;
        #end
        #ifndef(Vertices[P2])
          sphere{Get_Point(Origami,P2)Radius}
          #local Vertices[P2]=yes;
        #end
        #ifndef(Vertices[P3])
          sphere{Get_Point(Origami,P3)Radius}
          #local Vertices[P3]=yes;
        #end
        #ifndef(Edges[P1][P2])
          cylinder{Get_Point(Origami,P1)Get_Point(Origami,P2)Radius}
          #local Edges[P1][P2]=yes;
        #end
        #ifndef(Edges[P2][P3])
          cylinder{Get_Point(Origami,P2)Get_Point(Origami,P3)Radius}
          #local Edges[P2][P3]=yes;
        #end
        #ifndef(Edges[P3][P1])
          cylinder{Get_Point(Origami,P3)Get_Point(Origami,P1)Radius}
          #local Edges[P3][P1]=yes;
        #end
      #end
      #local Triangle=Triangle+1;
    #end
  }
#end

#macro Draw_Flat_Mesh(Origami/*,Material*/)
  mesh{
    #local Triangles=Origami[2]
    #local Triangle=0;
    #while (Triangle<dimension_size(Triangles,1))
      #ifdef(Triangles[Triangle])
        triangle{
          Get_Point(Origami,Triangles[Triangle].x)
          Get_Point(Origami,Triangles[Triangle].y)
          Get_Point(Origami,Triangles[Triangle].z)
          uv_vectors
          Get_UV(Origami,Triangles[Triangle].x)
          Get_UV(Origami,Triangles[Triangle].y)
          Get_UV(Origami,Triangles[Triangle].z)
        }
      #end
      #local Triangle=Triangle+1;
    #end
    /*material{Material}*/
  }
#end

#macro Draw_Names(Origami,Size,Color)
  union{
    #local Point=0;
    #while (Point<dimension_size(Origami[0],1))
      #local Text=text{
        ttf
        "arial"
        Origami[1][Point]
        1 0
        scale <Size,Size,1>
      }
      object{
        Center_Object(Text)
        translate Get_Point(Origami,Point)
      }
      #local Point=Point+1;
    #end
    pigment{Color}
  }
#end

// data structures

#declare Init_Origami=array[3];
