#version 3.5;

#include "origami.inc"

#macro Wall(
  PaperSize
  FrameSize
)

#local Work=Init_Origami;
// initial points

#local C=Add_Point(Work,0,0,0,"C");
#local C1=Add_Point(Work,FrameSize*(x+y),FrameSize/PaperSize,FrameSize/PaperSize,"C1");
#local C2=Add_Point(Work,2*FrameSize*(x+y),2*FrameSize/PaperSize,2*FrameSize/PaperSize,"C2");
#local C3=Add_Point(Work,PaperSize*(x+y),1,1,"C3");

#local R=Add_Point(Work,PaperSize*x,1,0,"R");
#local R1=Add_Point(Work,FrameSize*x,FrameSize/PaperSize,0,"R1");
#local R2=Add_Point(Work,2*FrameSize*x,2*FrameSize/PaperSize,0,"R2");
#local R3=Add_Point(Work,FrameSize*(2*x+y),2*FrameSize/PaperSize,FrameSize/PaperSize,"R3");
#local R4=Add_Point(Work,PaperSize*x+FrameSize*y,1,FrameSize/PaperSize,"R4");
#local R5=Add_Point(Work,PaperSize*x+2*FrameSize*y,1,2*FrameSize/PaperSize,"R5");

#local L=Add_Point(Work,PaperSize*y,0,1,"L");
#local L1=Add_Point(Work,FrameSize*y,0,FrameSize/PaperSize,"L1");
#local L2=Add_Point(Work,2*FrameSize*y,0,2*FrameSize/PaperSize,"L2");
#local L3=Add_Point(Work,FrameSize*(2*y+x),FrameSize/PaperSize,2*FrameSize/PaperSize,"L3");
#local L4=Add_Point(Work,PaperSize*y+FrameSize*x,FrameSize/PaperSize,1,"L4");
#local L5=Add_Point(Work,PaperSize*y+2*FrameSize*x,2*FrameSize/PaperSize,1,"L5");

Add_Quad(Work,C,R1,C1,L1)
Add_Quad(Work,R1,R2,R3,C1)
Add_Quad(Work,R2,R,R4,R3)
Add_Quad(Work,L1,C1,L3,L2)
Add_Quad(Work,C1,R3,C2,L3)
Add_Quad(Work,R3,R4,R5,C2)
Add_Quad(Work,L2,L3,L4,L)
Add_Quad(Work,L3,C2,L5,L4)
Add_Quad(Work,C2,R5,C3,L5)

#local Angle1=170;
#local Angle2=170;

Around_Edge_List(Work,"R2","L5",array[8]{R1,C1,L3,L4,C,L1,L2,L},-Angle1)
Around_Edge_List(Work,"R1","L4",array[4]{C,L1,L2,L},Angle1)

Around_Edge_List(Work,"R5","C2",array[8]{R4,R3,C1,L1,C,R1,R2,R},-Angle2)
Around_Edge_List(Work,"R4","R3",array[4]{C,R1,R2,R},Angle2)

Transform_Origami(Work,transform{translate -Get_Point(Work,C3)})

Work

#end