// Persistence of Vision Ray Tracer Scene Description File
// File:   halong.pov
// Vers:   3.1
// Desc: 
// Date:   11/15/01
// Auteur: Dominique ROSSI
//

#declare DETAILED_WATER = yes ;
#declare DETAILED_WATER2 = yes ;
#declare WITH_VEGETATION = yes ;    
#declare TREE_NUMBER = 200 ;    // Default 200 
#declare WITH_GROUND_VEGETATION = yes ;
#declare DETAILED_SKY = yes ;
#declare BROUILLARD = yes ;

#version 3.1;
                              
global_settings { 
  assumed_gamma 1.0 
  ambient_light 0      
  }


camera {
  location  <0, 3, 0>
  look_at   < 0, 0,  30>
  angle 70          
  }

sky_sphere {        

  // PARTIE NUAGEUSE    
  pigment {
    bozo          
    turbulence 0.3
    color_map {
      [0.00 color rgb <1.0, 1.0, 0.8>]
      [0.50 color rgb <1.0, 0.6, 0.5>]
      [1.00 color rgb <1.0, 1.0, 0.8>]
      }     
    scale <0.06,0.02,0.03>     
    rotate 20*x
    }               

  // SUN    
  pigment { 
    gradient y
    color_map {
      [0.00 color rgbt <1.00, 0.60, 0.50,1>]
      [0.65 color rgbt <1.10, 0.50, 0.50,0.5>]
      [0.90 color rgbt <1.50, 1.00, 0.50, 0.4>]
      [1.00 color rgb <1.80, 1.80, 0.80>]
      }        
    scale <1,0.5,1>
    rotate <85 ,15 ,0>
    }             
         
  #if ( DETAILED_SKY = yes )
    
    // ZONE BLEUE-VERT HAUT DU CIEL    
    pigment { 
      gradient y
      color_map {
        [0.40 color rgbt <0.0,0.0,0.0, 0.0>]
        [0.50 color rgbt <0.0,0.3,0.2, 0.0>]
        [0.70 color rgbt <0.0,0.3,0.2, 0.7>]
        [1.00 color rgbt <0.0,0.3,0.2, 1.0>]
        }           
      rotate <120,5,0>             
      }  
  #end
  }


#if ( BROUILLARD = yes )
  fog {                         
    fog_type 2 distance 20000  
    color rgbt <0.3, 0.5, 0.5 , 0.0>
    fog_offset 500 fog_alt 1000 
    
    }                     
#end



                         
light_source {
  <10000, 30000, 100000>
  color rgb <1.00, 1.00 ,0.0>  
  }

// SURFACE MER


plane {   
  y, 0                      
#if ( DETAILED_WATER = no )
  texture {       
    pigment { color rgb < 0.05, 0.02, 0.02 >  }  
    finish { reflection 0.80 }
    }                           
#else
  texture {       
    pigment { color rgb <0.05, 0.05, 0.02 >  }  
    normal { bumps 0.03 scale <0.5, 0.25, 0.10> }
    finish { reflection 0.60 diffuse 0.5 ambient 0.1 } 
    }                   
#end
  }               

#if ( DETAILED_WATER2 = yes )
  plane {
    y, 0.01  
    texture 
      {       
      bozo
      texture_map {
        [ 0.60 pigment { color rgbt 1 }  
               ]
        [ 0.65 pigment { color rgb <0, 0.1, 0.1> }     
               normal { bumps 0.6 scale 0.005 }
               finish { reflection 0.8 } 
               ]
        }               
      scale 50 
      }          
    }                  
#end  

  
#declare MOUNTAIN = height_field {
  tga "halong_relief1.tga"
  smooth
  pigment { 
    granite
    color_map  {
      [0 color rgb 0 ]
      [1 color rgb <0.1,0.1,0> ]
      }
    scale <0.1,0.1,0.1>  
    }                    
  translate <-0.5, 0 , -0.5>  
  scale <200, 350, 250>
  }


// MOUNTAIN FROM LEFT tO RIGHT
object { MOUNTAIN scale <20,15,15> rotate -90*y translate <-6000, 0, 12000> }
object { MOUNTAIN scale 13   rotate 120*y translate <-6400, -50, 20000> }
object { MOUNTAIN scale 10   rotate 100*y translate <-4300, -50, 25000> }
object { MOUNTAIN scale <12,8,12>  rotate 80*y  translate <-2500, -50, 11000> }
object { MOUNTAIN scale <30,15,30>   rotate 150*y translate <-2300, -50, 20000> }
object { MOUNTAIN scale <50,30,30>   rotate 40*y  translate <1000, -50, 60000> }
object { MOUNTAIN scale <15,7,7>   rotate 20*y  translate <2800, -50, 8000> }
object { MOUNTAIN scale 10                translate <3000, -50, 20000>  }
object { MOUNTAIN scale 10   rotate -45*y translate <4000, -50, 20000>  }
object { MOUNTAIN scale <20,10,10>   rotate -285*y translate <3000, -50, 10000>  }
object { MOUNTAIN scale 7   rotate -45*y translate <2700, -2, 5450>   }
object { MOUNTAIN scale 0.15 rotate 120*y  translate <40, -1, 40>   }


  
// VEGETATION
#declare BRANCH = bicubic_patch {
    type 1
    flatness 0.1 // flatness value
    u_steps 5 // # of triangles to subdivide (1-5)
    v_steps 5 // # of triangles to subdivide (1-5)
    <0, 0, 0> <0.3, 1, 1> <0.5, 1, 1> <1, 0.6, 0>
    <0, 0, 0> <0.3, 1.2, 0> <0.5, 1.2, 0> <1, 0.6, 0>
    <0, 0, 0> <0.3, 1.2, 0> <0.5, 1.2, 0> <1, 0.6, 0>
    <0, 0, 0> <0.3, 1, -1> <0.5, 1, -1> <1, 0.6, 0>
    scale <10, 10, 5>  
    }




#declare TREE = union {

  object { BRANCH translate 3*y}
  object { BRANCH scale <1,1.2,1> rotate 120*y translate 5*y}
  object { BRANCH scale <1,1.5,1> rotate 50*y translate 5*y}
  cylinder { 0, 8*y , 1}
  texture {
    pigment { color rgb <0.02, 0.03, 0.01> }         
      
    }                      
  }
                  
     
// LEFT                     
#declare CENTER = <-1100, 0, 1000>;          
#declare RADIUS = 1200;

object { MOUNTAIN
  scale 1.5
  rotate 120*y
  translate CENTER + 380 * x  
  }

sphere {
  0,RADIUS
  texture {
    pigment { color rgb <0.2, 0.2, 0.1>}
    }
  scale <1,0.03,1>  
  translate CENTER -10*y
  }          
// VEGETATION ON THE LEFT 
#declare CPT = 0;
#declare R1 = seed(0);
                              
#if ( WITH_VEGETATION = yes )
  #while ( CPT < TREE_NUMBER )
  
  // POSITION
    #declare ALPHA = - rand(R1) * .65 ;
    #declare RAD = RADIUS - 140 + rand(R1) * 20;
    
  // SIZE AND DIRECTION  
    #declare SIZE = rand(R1) + .8 - ALPHA ;
    #declare BETA = rand(R1) * 360;
    #declare GAMMA = rand(R1) * 0.2-0.1;
    
    object { TREE   
      rotate BETA*y           
      rotate GAMMA * z
      scale SIZE 
      translate CENTER + < RAD *cos(ALPHA),3, RAD * sin(ALPHA)> 
      }                       
    #if ( WITH_GROUND_VEGETATION = yes )  
      object { TREE   
        rotate BETA*y + 60          
        rotate GAMMA * z 
        scale <SIZE ,SIZE * 0.4,SIZE>
        translate CENTER + < RAD *cos(ALPHA),3, RAD * sin(ALPHA)> 
        }           
    #end    
    #declare CPT = CPT + 1;  
    
  #end
#end

// TREES ON THE RIGHT
  object { TREE scale 0.3 rotate <0,50,20> translate <22 ,2 ,40 > } 
  object { TREE scale 0.3 rotate <0,150,20> translate <23.5 ,6 ,40 > } 
  object { TREE scale 0.4 rotate <0,130,15> translate <25 ,8 ,40 > } 
  object { TREE scale 0.4 rotate <0,180,20> translate <25.5 ,10,40 > } 
  object { TREE scale 0.5 rotate <0,300,20> translate <25 ,12 ,40 > } 



#declare COQUE = bicubic_patch {
    type 1 // patch_type (0..1)
    flatness 0.1 // flatness value
    u_steps 3 // # of triangles to subdivide (1-5)
    v_steps 3 // # of triangles to subdivide (1-5)
    <-3, 0.3, -0.5> <-2.8, 0.05, -0.8> <2.8, 0.05, -0.8> <3, 0.3, -0.5>
    <-3, 0.2, -.5> <-2.5, -1, -.5> <2.5, -1, -.5> <3, 0.2, -.5>
    <-3, 0.2, 0.5> <-2.5, -1, 0.5> <2.5, -1, 0.5> <3, 0.2, .5>
    <-3, 0.3, 0.5> <-2.8, 0.05, 0.8> <2.8, 0.05, 0.8> <3, 0.3, 0.5>
    }
     
// SAMPAN
union {
  // Coque
  object { COQUE }
    
  object { COQUE translate 0.01*y }                             
  // Panier     
  sor {
      6, // # of points
      <0.0 , 0.0> // list of <u,v> points
      <0.25, 0.0>
      <0.40, 0.4>
      <0.40, 0.6>
      <0.35, 0.7>
      <0.0 , 0.7>
      open
      translate 0.5*x  
    }       
  // NET
  union {    

    #declare NET_HEIGHT = 2.4 ;     
    #declare NET_RADIUS = 0.5 ;     
    #declare cpt = 0;
    #while ( cpt < 1 )
      torus { (1-cpt)*NET_RADIUS, 0.002 translate (NET_HEIGHT * cpt)*y }
      #declare cpt = cpt + 0.04 ;
    #end          
                        
    #declare cpt = 0;
    #while ( cpt < 360 )
      cylinder { <NET_RADIUS*cos(cpt),0,NET_RADIUS*sin(cpt)>, <0,NET_HEIGHT,0> , 0.002 }
      #declare cpt = cpt + 10;
    #end                              

    torus { NET_RADIUS, 0.01 }
    cylinder { <NET_RADIUS*cos(0),0,NET_RADIUS*sin(0)>, <0,NET_HEIGHT,0> , 0.004}      
    cylinder { <NET_RADIUS*cos(70),0,NET_RADIUS*sin(70)>, <0,NET_HEIGHT,0> , 0.004}      
    cylinder { <NET_RADIUS*cos(140),0,NET_RADIUS*sin(140)>, <0,NET_HEIGHT,0> , 0.004}      
    cylinder { <NET_RADIUS*cos(210),0,NET_RADIUS*sin(210)>, <0,NET_HEIGHT,0> , 0.004}      
    cylinder { <NET_RADIUS*cos(280),0,NET_RADIUS*sin(280)>, <0,NET_HEIGHT,0> , 0.004}      
    texture { pigment { color rgb 0.5 } }
    rotate -120*z
    translate <0.8,1.2,0>  
    }
// FISHER
    polygon {
      53,
      <77, 255>, <78, 246>, // FOOT
      <15, 90>, <10, 87>  // STICK
      <15, 78>, <50, 67> //HAND & ARM 
      <51, 59>, <45, 56> //menton 
      <42, 46>, <36, 41>  
      <17, 35>, <11, 30>  
      <54, 14>, <88, 34> //HAT 
      <84, 39>, <115, 72>  
      <132, 98>, <143, 117>  
      <143, 187>, <149, 218>  
      <151, 256>, <129, 256> //BACK LEG 
      <131, 219>, <122, 187>  
      <117, 183>, <112, 188>  
      <105, 221>, <105, 255>  
      <77, 255>, //END 

      <82, 243>,  
      <91 ,231 >, <88 ,209 >,
      <84 ,196 >, <91 ,154 >,
      <85 ,144 >, <86 ,123 >,
      <80 ,117 >, <76 ,122 >,
      <75 ,154 >, <64 ,160 >,  
      <60 ,171 >, <60 ,184 >,
      <82 ,243 >,

      <50 ,159 >, <25 ,90 >,
      <30 ,88 >, <34 ,94 >,
      <47 ,88 >, <56 ,90 >,
      <59 ,104 >, <57 ,148 >,
      <54 ,157 >, <50 ,159 >

      pigment { color rgb 0}
      scale 0.007
      scale <1,-1,1> 
      translate <-1.2,1.7,0>
      
      }                        
      
    // CORMORAN1
    sphere { 0 , 1 pigment {color rgb 0 }
      scale <0.1,0.4,0.1>
      translate <-2.7,0.3,0>
      }
    sphere { 0 , 1 pigment {color rgb 0 }
      scale <0.05,0.1,0.05>
      translate <-2.7,0.5,0>
      }
      
    // CORMORAN2
    sphere { 0 , 1 pigment {color rgb 0 }
      scale <0.1,0.4,0.1>
      translate <-2.3,0.3,0>
      }
    sphere { 0 , 1 pigment {color rgb 0 }
      scale <0.05,0.1,0.05>
      translate <-2.3,0.5,0>
      }
 


  scale 1.7
  rotate -15*y
  translate <7,-0.05,30>
  }                  
  
  