#include "jizhead.inc"

#declare Robe = union{
	object{torus{5,2.5}
		 scale <0.8,0.5,2> rotate<120,0,15> translate<-8.5,21,7.5>
		}
	object{torus{4.5,2}
		 scale <1.1,0.8,1.75> rotate<120,0,12> translate <-7.5,22,7.25>
		}
	object{torus{2.5,1.5} 
		scale<1,1.2,1.6> rotate<-60,0,0> translate <0,29,7.5>
		}
	object{torus{2.5,1.5} 
		scale<1,1.2,1.6> rotate<-45,0,0> translate <0,25.5,8>
		}
	object{torus{2.75,1.75} 
		scale<1.25,1.2,1.75> rotate<-45,0,-5> translate<0,25,9>
		}
	object{torus{4,2.5} 
		scale<1,1,1.5> rotate<75,60,0> translate <7.5,20,9>
		}
	object{torus{4.25,2.5} 
		scale<1,1,1.25> rotate<-45,120,0> translate<7.25,20.5,10>
		}
}

#declare Finger = union {
	intersection{ torus{6,1}
			object{Cube 
				translate<1,0,-1>
				rotate<0,30,0>
				scale 6 
				}
			}
	object{Sphere
		translate<6,0,0> rotate<0,30,0>
		}
	object{Sphere
		translate<6,0,0> rotate<0,120,0>
		}
	translate <3,0,5.2>
}

#declare LeftHand = union{
	object {Finger
		 rotate<-90,60,0> translate <3.5,0,3>
		}

	#declare FingerCount=1;
	#while ( FingerCount<=4)
		object{Finger
			 rotate<-90,90,0> translate <1.5*FingerCount,0,0>
			} 
	#declare FingerCount = FingerCount +1;
	#end
}

#declare RightHand = union{
	difference{
		union{
			object {Finger
				 rotate<-90,0,60> translate <-2,0,0>
				}
			#declare FingerCount=1;
			#while (FingerCount<=4)
			object {Finger 
				rotate <180,0,72> translate<-1.5*FingerCount,0,0>
				}
			#declare FingerCount = FingerCount +1;
			#end
			}
		object {Cube 
			translate<0,0,-1> rotate <-60,0,0> scale 9 
			}
		}
	
	object{
		blob {threshold 0.25
			sphere{<-6,0,0>,1,0.75}
			sphere{<-5,0,0>,1,0.9}
			sphere{<-4,0,0>,1,0.75}
			}
		}
	object {Sphere 
		scale <3.5,2.25,1> rotate<30,0,0> translate<-3,1,-0.1>
		}
}


#declare Orb = object{
	blob{ threshold 0.25
		sphere {<0,0,0>,7.5,0.5}
		sphere{<0,3,0>,2,0.8}
		}
}

#declare Foot= union{
  	#declare FootCount=0;
	#while (FootCount<5)
		union{	
			object{Sphere}
			object{cone{<0,0,0>,1,<0,1.4,5>,1.4}
			}
		translate<FootCount*1.2,0,0>
		}
	#declare FootCount = FootCount+1;
	#end
}

#declare Skirt = union {
	#declare SkirtCount=0;
	#while (SkirtCount<7)
		object{cone{<0,0,0>,2,<(1+SkirtCount/4)*cos(SkirtCount),-12,(1+SkirtCount/4)*sin(SkirtCount)>,1+SkirtCount/6}
			}
	#declare SkirtCount = SkirtCount +1;
	#end
}

#declare Lotus1 = union {
	difference{
		object{Sphere}
		object{Cube 
			scale <1,0.5,1> translate<0,0.5,0>
			}
		}
	torus{0.8,0.2}
}


#declare Lotus = union{
	#declare LotusCount=0;
	#while (LotusCount<5)
	object {Lotus1
		scale <8,8,8>
		rotate <30,0,0>
		translate<0,5,-10>
		rotate <0,72*LotusCount,0>
		}
	#declare LotusCount = LotusCount+1;
	#end
}

#declare JizoHalo =
intersection{
	union{
		object{ 
			Sphere
			scale <12,45,3>
			translate <0,5,12.5>
			}
		object{
			torus {1.1,0.2}
			rotate <75,0,0>
			scale <12,45,9>
			translate <0,5,12>
			}
		object{
			torus {10,1.5}
			rotate <72,0,0>
			translate <0,37.5,10>
			}
	}
	object{Sphere
		 scale 40 translate <0,40,20>
		}
}




#declare Jizo=union{
	object{Lotus}
	object{JizoHalo}
	object{Foot
		 rotate<0,-12,0> translate <6,7,-5>
		}
	object{Foot 
		rotate<0,12,0> translate <-6,7,-5>
		}
	object{Robe}
	object{Skirt 
		scale <2.25,1,2.25> rotate <10,0,0> translate<0,20,7.5>
		}
	object{Skirt 
		scale <2,1,2> rotate <20,10,0> translate <0,21,7.5>
		}
	object{JizHead
		 scale 6  translate <0,32,8>
		}
	object{Orb
		translate<17.5,25,-5>
		}
	object{LeftHand
		translate <12.5,21.5,0>
		}
	object{RightHand
		translate <-7.5,22.5,7.5>
		}
	
}
