#declare Short_Leg = box{
  <-0.1, 0, -0.2>
  < 0.1, 2,  0.2>
}

#declare Long_Leg = box{
  <-0.1, 0, -0.2>
  < 0.1, 4,  0.2>
}

#declare Clegger = box{
  <-1.05, 0, -0.08>
  < 1.05, 0.16,  0.08>
}

#declare Pillar = lathe
{
  cubic_spline // linear_spline | quadratic_spline | cubic_spline
  22, // number of points
  <0, 0>, <0, 0>, <1, 0> <0.5, 1>, <1, 2>, <0.5, 3>, <1, 4>, <0.5, 5>,
  <1, 6>, <0.5, 7>, <1, 8>, <0.5, 9>, <1, 10>, <0.5, 11>, <1, 12>, <0.5, 13>
  <1, 14>, <0.5, 15>, <1, 16>, <0.5, 17>, <0, 18>, <0, 18>
  scale <0.05, 0.1, 0.05>
}

#declare Seat = box{
  <-1.1, 0.0, -1.2>
  < 1.1, 0.1,  1.2>
}

#declare Chair = union{
  object {Long_Leg  translate <-1, 0,  1> }
  object {Long_Leg  translate < 1, 0,  1> }
  object {Short_Leg translate <-1, 0, -1> }
  object {Short_Leg translate < 1, 0, -1> }
  object {Clegger translate z rotate y*000 translate y*0.5}
  object {Clegger translate z rotate y*090 translate y*0.5}
  object {Clegger translate z rotate y*180 translate y*0.5}
  object {Clegger translate z rotate y*270 translate y*0.5}
  object {Clegger translate z rotate y*000 translate y*2.5}
  object {Clegger translate z rotate y*000 translate y*3.8}
  object {Pillar  translate <-0.8, 2.5, 1>}
  object {Pillar  translate <-0.6, 2.5, 1>}
  object {Pillar  translate <-0.4, 2.5, 1>}
  object {Pillar  translate <-0.2, 2.5, 1>}
  object {Pillar  translate <-0.0, 2.5, 1>}
  object {Pillar  translate < 0.2, 2.5, 1>}
  object {Pillar  translate < 0.4, 2.5, 1>}
  object {Pillar  translate < 0.6, 2.5, 1>}
  object {Pillar  translate < 0.8, 2.5, 1>}
  object {Pillar scale 1.2 translate <-1, 2.3, 1>}
  object {Pillar scale 1.2 translate < 1, 2.3, 1>}
  object {Seat translate y*1.9}
}
