//   Seance.pov - IRTC Nov and Dec, 2001
//   Ruy Flavio de Oliveira
//   POV-Ray 3.5 Beta 9

#include "textures.inc"


#declare GH = on; // Ghost
#declare AF = on; // Africa
#declare AM = on; // Americas
#declare EU = on; // Europe
#declare OC = on; // Oceania
#declare AR = on; // Arms
#declare RM = on; // Room
#declare MS = on; // Mesa
#declare CH = on; // Cadeiras
#declare MN = on; // Mesinha
#declare CR = on; // Ceramica
#declare VL = on; // Velas
#declare QD = on; // Quadro

//camera
#declare VIEW = 2; // 0 for Top, 1 for Front - Table-top level, 2 for Front - Upper level

#declare RD = on; // Radiosity on and off

//Azul = Europa
//Amarelo = Asia
//Preto = Africa
//Verde = Oceania
//Vermelho = America

camera{
#switch (VIEW)
  #case (0)
  	location < 0, 20, 0 >
  	look_at < 0, 0, 0 >
  	angle 80.000
  #break
  
  #case(1)
  	location < 0, 4.5, -20 >
  	look_at < 0, 4.5, 0 >
  	//angle 80.000
  #break
  
  #case(2)
  	location < 0, 15, -20 >
  	look_at < 0, 10, 0 >
  	angle 80.000
	#break
  
  #case(3)
  	location < 0, 15, -50 >
  	look_at < 0, 10, 0 >
  	angle 80.000
	#break
#end
}

//light_source{<0,19,-15> rgb 1}


//background { 1 }


global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  #if(RD)
  	radiosity{
  		//brightness 3.300
  		count 100
  		distance_maximum 0.000
  		error_bound 0.400
  		gray_threshold 0.500
  		low_error_factor 0.800
  		minimum_reuse 0.0150
  		nearest_count 6
  		recursion_limit 1
  	}
  #end
}

#if (AR)
  #include "Braco Direito - 02.inc"
  #include "Braco Esquerdo - 02.inc"
#end

#if (RM)
  #include "Room.inc"

  object{Room}
#end    

#if (QD)
  #declare Lado = difference{
    box{<-.5, 0, -0.5> <.5, 0.5, 0>}
    plane{y 0 rotate x*45}
  } 
  union {
    box { <-3.75, -5.25, 0> <3.75, 5.25, 0.001> pigment { image_map {jpeg "abraham.jpg" } scale <8, 11, 1> translate <-3.9, -5.6, 0> } finish { ambient 0.4 } }
    object { Lado              scale <8.4,1,1>  pigment{Dark_Wood} translate y* 5.2 }
    object { Lado rotate z*180 scale <8.4,1,1>  pigment{Dark_Wood} translate y*-5.2 }
    object { Lado              scale <11.4,1,1> pigment{Dark_Wood} rotate z*-90 translate x* 3.7 }
    object { Lado              scale <11.4,1,1> pigment{Dark_Wood} rotate z* 90 translate x*-3.7 }
    scale 0.7
    rotate y*90
    translate <14.99, 12, 2>
  }
#end

#if (MN)
  #include "Mesinha.inc"

  object {Mesinha scale 10 rotate x*90 texture { Dark_Wood } rotate x*90 translate y*6.05 translate x*-15 scale <1, 2, 1>}
#end    

#if (CR)
  #include "Ceramica.inc"

  object {Ceramica scale 5         rotate x*90 texture {White_Marble} finish { reflection 0.1 specular 1 } rotate x*90 translate y*5   translate <-14, 0,  -1> scale <1, 2, 1>}
  object {Ceramica scale <6, 7, 6> rotate x*90 texture {White_Marble} finish { reflection 0.1 specular 1 } rotate x*90 translate y*6.4 translate <-13.9, 0, 0.8> scale <1, 2, 1>}
#end    

#if (MS)
  #include "Mesa Redonda.inc"

  object {Mesa_Redonda scale 10  texture { Dark_Wood }}
#end    

#if (CH)
  #include "Chair.inc"

  object {Chair scale 2 texture {Dark_Wood} translate z*8 rotate y*-45 }
  object {Chair scale 2 texture {Dark_Wood} translate z*8 rotate y*45}
  object {Chair scale 2 texture {Dark_Wood} translate z*8 rotate y*-145}
  object {Chair scale 2 texture {Dark_Wood} translate z*8 rotate y*135}
#end    

#if (GH)
  #include "Ghost.inc"
  #include "Asia.inc"

  object {
    Ghost
    pigment{rgbt <1, 1, 1, 0.7>}
    finish {ambient 0.4}
    scale 0.5
    rotate x*-90
    translate y*15
    translate z*2
    rotate y*25
  }
  
  object {
    Asia
    pigment{rgbt <1, 1, 1, 0.4>}
    finish {ambient 0.4}
    scale 0.5
    rotate x*-90
    translate y*15
    translate z*2
    rotate y*25
  } 
#end


#if (AF)
  #include "Africa.inc"
  object {
    Africa
    pigment{rgb <0.2, 0.2, 0.2>}
    finish {specular 1}
    scale 0.4
    rotate x*-90
    translate y*10
    translate z*8
    rotate y*135
  }
    
  #if (AR)
    object {
      Braco_Direito
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb 0.2} scale 40 translate <-6, -4, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*-90
      rotate x*-20
      rotate y*-20
      translate <5, 9, -1.5>
    } 
    object {
      Braco_Esquerdo
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb 0.2} scale 40 translate <-6, -2, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*90
      rotate x*-20
      rotate y*-60
      translate <0, 9, -6>
    }
  #end
#end

#if (AM)
  #include "Americas.inc"
  object {
    Americas
    pigment{rgb <1, 0, 0>}
    finish {specular 1}
    scale 0.45
    rotate x*-90
    translate y*10.5
    translate z*8
    rotate y*-45
  }
    
  #if (AR)
    object {
      Braco_Direito
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb x} scale 40 translate <-6, -4, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*-90
      rotate x*-20
      rotate y*180
      translate <-8, 12, 0>
    } 
    object {
      Braco_Esquerdo
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb x} scale 40 translate <-6, -2, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*90
      rotate x*-20
      rotate y*90
      translate <-1.5, 12, 6.5>
    }
  #end
#end

#if (EU)
  #include "Europa.inc"
  object {
    Europa
    pigment{rgb <.2, .2, 1>}
    finish {specular 1}
    scale 0.7
    rotate x*-80
    translate y*7
    translate z*7
    rotate y*45
  } 
    
  #if (AR)
    object {
      Braco_Direito
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb <.2, .2, 1>} scale 40 translate <-6, -4, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*-90
      rotate x*-20
      rotate y*-90
      translate <1.5, 8, 5>
    } 
    object {
      Braco_Esquerdo
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb <.2, .2, 1>} scale 40 translate <-6, -2, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*90
      rotate x*-20
      rotate y*180
      translate <9, 8, -2>
    }
  #end
#end

#if (OC)
  #include "Oceania.inc"
  object {
    Oceania
    pigment{rgb <0, 1, 0>}
    finish {specular 1}
    scale 0.7
    rotate x*-90
    translate y*7
    translate z*7
    rotate y*-145
  } 
    
  #if (AR)
    object {
      Braco_Direito
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb y} scale 40 translate <-6, -4, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*-90
      rotate x*-20
      rotate y*60
      translate <0.5, 6, -5>
    } 
    object {
      Braco_Esquerdo
      scale 0.3
      pigment{checker pigment{rgb 1}, pigment{rgb y} scale 40 translate <-6, -2, 0.1> }
      finish {specular 1}
      scale 0.4
      rotate z*90
      rotate x*-20
      //rotate y*-60
      translate <-5, 6, -1>
    }
  #end
#end

#if (VL)
  #include "colors.inc"
  #include "candles.inc"
  
  /*object {
          cand (20,1.5,10,50,0) 
          hollow      double_illuminate
          scale .1
  #if (TEST_TEXTURE) tex()
  #else   wax (Wheat)  #end
  translate <1,6,-1>}*/
  
  object {
          cand (22,1.5,10,50,0)
          hollow   double_illuminate
          scale .1
  #if (TEST_TEXTURE) tex()
  #else  wax (Wheat) #end
  translate <-2,6,1>}
  
//  object {porta_candela texture {holder_metal} scale <.105,.1,.105> translate <1,4.5,-1>}
  object {porta_candela texture {holder_metal} scale <.105,.1,.105> translate <-2,4.5,1>}
#end