#version unofficial MegaPov 0.7;

// scene switches
#declare Scene_Radiosity		= on; 
#declare Scene_Flower_Stems		= on; 
#declare Scene_Flower_Heads		= on;
#declare Scene_Spheres			= on;
#declare Scene_Petals			= on;
#declare Scene_Sphere_Contents	= on;

// main flower definition

#include "colors.inc"
#include "13wtext1.inc" 

#include "13newtex.inc"

#include "13stem.inc"  
#include "13heads.inc"  
#include "skies.inc" 
#include "world1.inc"

sky_sphere {S_Cloud1}
global_settings { max_trace_level 10 }

camera {
	location <13,5,-2>
	look_at  <13,-1,8>  
	right 1.66*x  
}

light_source {<70,50,-50> color White}

#if (Scene_Radiosity = on)
global_settings { 
ini_option "+QR"
  
  
  radiosity{
    pretrace_start 0.08
    pretrace_end   0.04
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1.8      // CHANGE - range from 1 to 3
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
}
#end


#local Count1 = 0;  
#local Rows = 6;
#local Columns = 6;

#local XStep = 4; 
#local ZStep = 4;
#local YPlus = 2; 

#local XVar = 1.5;
#local ZVar = 1.5;

#local Apple = seed(13); 
#local Sauce = seed(13);
#local Pie = seed(13);
#local Muffin = seed(13); 
#local Blueberry = seed(169);

#while (Count1 < Rows)
#local Count2 = 0;      
#while (Count2 < Columns)

#local Rand1 = rand(Apple);                                     
#local Rand2 = rand(Apple);
#local Rand3 = rand(Apple);
#local Rand4 = rand(Muffin);
#local Rand5 = rand(Blueberry);

#if (rand(Apple) > .5) #local S1 = 1; #else #local S1 = -1; #end
#if (rand(Apple) > .5) #local S2 = 1; #else #local S2 = -1; #end
#if (rand(Pie) > .5) #local S3 = 1; #else #local S3 = -1; #end

#local RotateY = <0,(rand(Pie) * 15 * S3),0>; 
#local Translate = <	((XStep * Count1) + (Rand1 * XVar * S1)),
						((Rand2 * YPlus) - (YPlus / 2)),
						((ZStep * Count2) + (Rand3 * ZVar * S2))
			  		>;
#local Wobble1 = <0,0,((rand(Sauce) * -15) - 15)>; 
#local Wobble2 = <((rand(Sauce) * 5) + 5),0,0>;

// the stem
#if (Scene_Flower_Stems = on)
	object {Flower_Stem rotate RotateY translate Translate}
#end
// the flower head
#if (Scene_Flower_Heads = on)
	object {Flower_Head translate <0,1.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
#end
// the snow dome 
#if (Scene_Spheres = on)
#if (Rand4 > .1)
//difference {
sphere {<0,1,0>,1 
	material{Glass}  
	translate <0,1.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate
}

#end
#end 
// snow dome contents
#if (Scene_Sphere_Contents = on) 
#if (Rand4 > .1)  
	#if (Rand5 < .33)
	object {World3 translate <0,2.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
	#else 
		#if (Rand5 < .66)
		object {World2 translate <0,2.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
		#else
		object {World1 translate <0,2.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
		#end
	#end
#end
#end
// the flower petals
#if (Scene_Petals = on)
#if (Rand4 < .1)
	object {Petals1 translate <0,1.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
	#else
	#if (Rand4 < .3)
		object {Petals2 translate <0,1.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}	
	#else
		#if (Rand4 < .5)
			object {Petals3 translate <0,1.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
		#else
		#if (Rand4 < .7)
			object {Petals4 translate <0,1.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
		#else
			object {Petals5 translate <0,1.75,0> rotate Wobble1 rotate Wobble2 rotate RotateY translate Translate}
		#end
		#end
	#end
#end
#end

#local Count2 = (Count2 + 1);

#end

#local Count1 = (Count1 + 1);

#end


// mirror box
difference {
	box {<-10,5,-10><30,-30,30> texture{Mirror} no_shadow }
	box {<-5,10,-5,><25,-25,25> texture{Mirror} no_shadow }
}      



height_field
{
	tga              
	"grass_map.tga"
	translate <-.5,0,-.5>
	scale <50,15,50>
	translate <0,-20,0>     
	texture{Glossy_Green1}
}

