#version unofficial MegaPov 0.7;
/*
#include "colors.inc"  
#include "skies.inc"
#include "13wtext1.inc"
                    
sky_sphere {S_Cloud1}                    
                    
camera {
	location <0,1,-2.5>
	look_at  <0,0,0>
}

light_source {<1,2,-5> color White}
*/
//sphere {<0,0,0>,.95 material{Glass}}

// Plain yellowish sand for the beaches.
#declare Sand_Texture =
texture {
   pigment {color <0.9,0.8,0.5>}
}

// A green texture for grass, plants, trees, etc.
#declare Vege_Texture =
texture {
   pigment {color <0.1,0.6,0.1>}
}

// A brown texture for the soil, where the plants can't grow.
#declare Soil_Texture =
texture {
   pigment {color <0.7,0.6,0.5>}
}

// A grey texture for the rock, where there is not even any soil.
#declare Rock_Texture =
texture {
   pigment {color <0.6,0.6,0.6>}
}

// A white texture for the snow.
#declare Snow_Texture =
texture {
   pigment {color rgb 1.0}
   finish {ambient 0.1 diffuse 0.8}
}

// Now for the slope pattern textures.
// Before looking into these, try having a look at the
// texture of the height_field at the bottom of this file.

// A texture that has vegetation on the flat and low areas,
// soil on the steeper and higher areas, and rock on the
// steepest and highest areas.
// Notice how the altitude values fit to the pattern values
// in the texture_map of the height_field below.
#declare Vege2Rock_Texture =
texture {
   slope y
   texture_map {
      [0.45, Vege_Texture]
      [0.55, Soil_Texture]
      [0.65, Soil_Texture]
      [0.65, Rock_Texture]
   }
}

// A texture that has snow on the flat and high areas,
// and rock on the steeper and lower areas.
// Notice how the altitude values fit to the pattern values
// in the texture_map of the height_field below.
// The altitude values have been switched around because we
// want the snow near the top and not near the bottom.
#declare Rock2Snow_Texture =
texture {
   slope y
   texture_map {
      [0.75, Snow_Texture]
      [0.75, Rock_Texture]
   }
}

#declare World1a =
union {

difference {
sphere {<0,0,0>,.95 texture{Earth}} 
height_field
{
	tga
	"world1.tga"
	smooth
	texture {World_Tex1}
	translate <-.5,0, -.5>
	scale <1,.3,1> 
	scale 2
	inverse
}    
}

intersection {
sphere {<0,0,0>,.95 texture{Water}} 
height_field
{
	tga
	"world1.tga"
	smooth
	texture{Water}
	translate <-.5,0, -.5>
	scale <1,.3,1> 
	scale 2
	inverse 
} 
box {<-1.5,.1,1.5><1.5,-1.5,-1.5> texture{Water}}
}     

}  

#declare World2 =
difference {
sphere {<0,0,0>,.95 texture{Earth}} 
height_field
{
	tga
	"world2.tga"
	smooth
	texture {World_Tex2}
	translate <-.5,-.25, -.5>
	scale <1,.3,1> 
	scale 2
	inverse
}    
} 

#declare World3 =
difference {
sphere {<0,0,0>,.95 texture{Earth}} 
height_field
{
	tga
	"world3.tga"
	smooth
	texture {World_Tex3}
	translate <-.5,0, -.5>
	scale <1,.2,1> 
	scale 2
	inverse
}    
}

#declare World1 =
union {

object {World1a}

#local Norm = <0,0,0>;
#local Count3 = 0;
#local Qty3 = 50000;

#local Wobble = seed(13);

#while (Count3 < Qty3) 

	#local S1 = rand(Wobble);
	#if (S1 > .5) #local S1 = 1; #else #local S1 = -1; #end 
	
	#local S2 = rand(Wobble);
	#if (S2 > .5) #local S2 = 1; #else #local S2 = -1; #end   
	
	#local Start = <(rand(Wobble) * .95 * S1),10,(rand(Wobble) * .95 * S2)>;
	
	#local Inter = trace (World1a, Start, (Start - <0,20,0>));
	
	
	#if (Inter.y > .1) 
		#if (Inter.y < .21)
			sphere {Inter,.01 pigment{rgb (rand(Wobble) * <.3,.5,.3> + <.1,.2,.1>)}} 
		#end
	#end
	

	#local Count3 = (Count3 + 1);
#end   

}