// Persistence of Vision Ray Tracer Scene Description File
// File:   bus.inc
// Vers:   3.1
// Desc:   Bus 
// Date:   02/03/2002
// Auteur: Dominique ROSSI
//
#version 3.1;

#local TEST = no;

#if ( TEST = yes )
  global_settings {
    assumed_gamma 1.5
    adc_bailout 0.3   
    max_trace_level 2
    }
#end

#macro SE ( CORNER1, CORNER2, UV )
  superellipsoid {
    UV
    scale (CORNER2 - CORNER1) / 2 
    translate (CORNER1+CORNER2) / 2 
    
#end


#declare BUS = 
union {
  difference {
    // BEGIN OF BODYWORK
    union { 
      SE ( <0,0.3,-1.5>, <12,3,1.5>, <0.05, 0.15>)
        texture {
          // HORIZ. LINES
          pigment {
            gradient y 
            color_map {
              [0.9 rgb 1]
              [0.9 rgb 0]
              }
            scale 0.3
            }    
          finish { reflection 0.3 diffuse 1}
          }    
        // BLACK BORDER FOR WINDOWS
        texture {
          pigment {
            boxed
            color_map {
              [0.001 rgbt 1]
              [0.001 rgb 0]
              }
            scale <5.82, 0.69, 2>
            translate <6.05, 1.85, 0> 
            }    
          finish { diffuse 1}
          }  
        }                         
      // GAS BOXES ON THE ROOF   
      SE ( <3,2.0,-1.3>, <10,3.5,1.3>, <0.5,0.7>)
        pigment { rgb 1}
        finish { reflection 0.3 diffuse 1}
        }
      
        
      // BUMPERS  
      SE ( <-0.01,0.3,-1.51>, <12.01,0.5,1.51>, <0.05, 0.15> )
        pigment {rgb <0,0,0.6>}
        finish { diffuse 1}
        }           
      } // END OF BODYWORK 
           
    // HOLE FOR INTERIOR
    SE ( <0.02,0.32,-1.48>, <11.98,2.98,1.48>, <0.05, 0.15>)
      pigment {rgb 1}
      }        
    
    // HOLES FOR WHEELS
    SE (<2.6, 0, -2>, <3.4, 0.9, 2>, <0.5,0.0>) }
    SE (<8.6, 0, -2>, <9.4, 0.9, 2>, <0.5,0.0>) }
    
    // HOLES FOR WINDOWS  
    box { < 0.20,1.35,-1.6>, < 1.20, 2.5, 1.6>}
    box { < 1.30,1.5,-1.6>, < 2.70, 2.5, 1.6>}
    box { < 2.80,1.5,-1.6>, < 4.00, 2.5, 1.6>}
    box { < 4.10,1.5,-1.6>, < 6.00, 2.5, 1.6>}
    box { < 6.10,1.5,-1.6>, < 8.00, 2.5, 1.6>}
    box { < 8.10,1.5,-1.6>, <10.00, 2.5, 1.6>}
    box { <10.10,1.5,-1.6>, <11.80, 2.5, 1.6>}
    
    // HOLE FOR REAR WINDSHIELD
    box { <11.85, 1.8, -1.0>, <12.2, 2.5, 1.0>  
      pigment { rgb 1}
      }

    // HOLE FOR FRONT WINDSHIELD
    SE (<0.15, 1.1, -1.6>, <-0.2, 2.5, 1.6>, <0.5,0.0>) 
      pigment { rgb 1}
      }
    }

  // WINDOWS
  SE ( <0.01,0.31,-1.49>, <11.99,2.99,1.49>, <0.05, 0.15>)
    pigment {rgbt <0.2,0.2,0.2,0.4> }
    finish { reflection 0.4 diffuse 1 }
    }
  // WHEELS          
  torus { 0.3, 0.15 rotate 90*x translate <3,0.37,-1.4>}
//  torus { 0.3, 0.15 rotate 90*x translate <3,0.37, 1.4>}
  torus { 0.3, 0.15 rotate 90*x translate <9,0.37,-1.4>}
//  torus { 0.3, 0.15 rotate 90*x translate <9,0.37, 1.4>}

  // REAR BILLBOARD (IRTC)
  box { 0, 1 
    pigment {   
      image_map { sys "irtc.bmp"
        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        }
      rotate -90*y
      } 
    finish {ambient 2}  
    scale <0.01, 0.80, 2 >
    translate <12, 0.90, -1>
    }   
  
  // REAR NOTICE
  box { <12, 2.6, -1>, <12.01, 2.8, 1> pigment { rgb <1,1,2>*2} }
  
  // INSIDE LIGHT
  light_source { <6, 2.5, 0>, <1,1,0.5> 
    fade_distance 3 fade_power 20 
    area_light 10*x, z, 5, 5 }
    
  // RED REAR LIGHTS                  
  union {
    sphere { 0, 0.18 scale <0.3,0.3,1> translate <12,0.6,-1.05> }
    sphere { 0, 0.18 scale <0.3,0.3,1> translate <12,0.6, 1.05> }
    pigment { rgb <1,0.0,0>}
    finish { ambient 10 }
    }
  // ORANGE SIDE LIGHTS
  union {
    sphere { 0, 0.1 translate < 2,0.4,-1.47> }
    sphere { 0, 0.1 translate < 4,0.4,-1.47> }
    sphere { 0, 0.1 translate < 6,0.4,-1.47> }
    sphere { 0, 0.1 translate < 8,0.4,-1.47> }
    sphere { 0, 0.1 translate <10,0.4,-1.47> }
    pigment { rgb <1,0.3,0>}
    finish { ambient 10 }
    }
  bounded_by { box { <-0.1, 0, -1.6>, <12.1, 3.5, 1.6>} }
  } // End of Union


#if ( TEST = yes )
  camera {
    location  <20, 1.6, -5>
    //location  <6, 1.6, -20>
    look_at   <6, 1.6,  0.0>
    angle 40
    }
  
  sky_sphere {
    pigment { 
      agate
      //rgb <0.5,0.5,0.6>*0.01
      }
    }
  plane { y , 0 pigment { rgb 1 }}
  
  light_source {
    <30, 30, -30>
    color rgb 1  
    }    
  object { BUS }  
                     
#end  


