// Persistence of Vision Ray Tracer Scene Description File
// File:   .pov
// Vers:   3.1
// Desc: 
// Date:   01/07/02
// Auteur: Dominique ROSSI
//
#version 3.1;                

global_settings { 
  assumed_gamma 1.6         
  ambient_light 0.04
  adc_bailout 0.1
  max_trace_level 5
  }

#declare CAMERA_FOCUS = 0;
#declare BLUR = no;        // FOCAL BLUR
/*
   0 : NORMAL VIEW
   1 : FOCUS ON BUS
   2 : FOCUS ON CINEMA
   3 : FOCUS ON BUILDINGS
   4 : FOCUS ON GROUND BEAST
   5 : FOCUS ON FLYING DRAGON
*/
// CAMERA
camera {
  location  <-5.2, 1.6, 4>
  #if ( BLUR = yes )
    aperture 0.03
    focal_point <-3,0,9>
    blur_samples 20 
    confidence 0.95  
    variance 0.01
  #end
  #switch ( CAMERA_FOCUS )
    #case ( 0 ) look_at   <-3, 3, 20>  angle 80  #break  // NORMAL
    #case ( 1 ) look_at   < 3, 2, 20>  angle 40  #break  // BUS
    #case ( 2 ) look_at   < 5, 2, 18>  angle 30  #break  // CINEMA
    #case ( 3 ) look_at   < 1, 3, 20>  angle 40  #break  // BUILDINGS
    #case ( 4 ) look_at   <-4.4, 0.3,  8>  angle 50  #break  // BEAST
    #case ( 5 ) look_at   <-4.4, 3.5,  8>  angle 50  #break  // DRAGON
  #end
  }

#declare SKIES = yes;
  #declare AREA_LIGHTS = yes;  // FOR THE MOON LIGHT
  #declare SKY_SPHERE = yes; 
  #declare CLOUDS = yes;

#declare RIGHT_PART = yes;
  #declare PEOPLE = yes;
  #declare SHOW_BUS = yes;

#declare LEFT_PART = yes;
  #declare HOUSE1 = yes;
  #declare HOUSE2 = yes;
  #declare FANTASY_DOG = yes;
  #declare DETAILED_SIDEWALK = yes;
  #declare LAMPPOSTS = yes; 
  #declare LIZARDS = yes;
  
    
#declare FRONT_PART = yes;
#declare STREET = yes;    
#declare CROSSROAD = yes;     
// pour test
#declare DAYLIGHT = no;

#if ( DAYLIGHT = yes )
  light_source { 
    <0, 25, 0>
    color rgb 1 
    }             
#end


#if ( SKIES = yes )
  #if ( SKY_SPHERE = yes )
    sky_sphere {
      // DEEP BLUE  
      pigment { 
        gradient y
        color_map {
          [0.3 color rgb 0]
          [0.80 color rgb <0,0.05,0.10>]
          [0.993 color rgb <0.05,0.12,0.25>*0.7]
          [0.999 color rgb <0.05,0.12,0.25>*1.]
          [0.9999 color rgb <0.05,0.12,0.25>*1.5]
          }  
        rotate 60*x
        rotate -10*y
        }               
      // SUN RISE COLOR  
      pigment {
        gradient y 
        color_map {
          [0. rgbt <0.6,0.6,0.3,0.4>]
          [0.2 rgbt <0,0.05,0.10,1>]
          }
        }            
      // STARS  
      pigment {
        granite
        color_map {
          [0.75 color rgbt <0,0,0,1> ]
          [0.90 color rgb 1 ]
          }     
        scale 0.02  
        }    
      }
  #end                          
  
  // FULL MOON  
  sphere { <-400, 1250, 2150 >, 40 
    pigment { 
      bozo 
      color_map {
        [0 rgb 0.35]
        [1 rgb 0.5] }
      scale 10
      } 
    finish { diffuse 8 } 
    }
  
  // CLOUDS            
  #if ( CLOUDS = yes )   
    plane { y, 100  
      no_shadow
      hollow
      texture {
        bozo   
        turbulence 0.5
        texture_map {
          [0.00 pigment { rgb  <3,3,2> } ]
          [0.23 pigment { rgb  <5,5,3> } ]
          [0.29 pigment { rgbt <20, 50, 70, 0.2> } ]
          [0.31 pigment { rgbt <20, 50, 70, 0.8> } ]
          [0.33 pigment { rgbt <1.6, 3.2, 3.2, 1> } ]
          [0.35 pigment { rgbt <8, 16, 16, 1.0> } ]
          }  
        scale <200,1,200>  
        translate -70*x-205*z
        }                       
      clipped_by { box {<-400, 90, 100>, <400, 110, 900> } }  
      }      
  #end
#end
  
// FULL MOON LIGHT (BRIGHT)
light_source { 
  <-170, 105, 200>
  color rgb <0.3,0.3,0.2> 
  #if (AREA_LIGHTS = yes)         
    area_light <0,0,0>, <30,30,30>, 4, 4 
    adaptive 1 jitter     
  #end
  }             
                         
// BLUE MOON LIGHT
light_source { 
  <250, 300, -20>
  color rgb <0.0,0.10,0.15> * 0.2 
  #if (AREA_LIGHTS = yes)         
    area_light <0,0,0>, <30,30,30>, 4, 4 
    adaptive 1 jitter     
  #end
  }             

// FRONT BLUE LIGHT
light_source { 
  <0, 1.0, 0>
  color rgb <0.15,0.3,0.4> * 0.5     
  spotlight
  point_at <-7, -0.8, 9>
  radius 30
  falloff 45
  tightness 10          
  #if ( AREA_LIGHTS = yes )
    area_light x, y, 4, 4   
  #end
  }                

#if ( CROSSROAD = yes )
  #include "cross.inc"
#end

// GROUND
plane { y, -0.1 pigment { rgb 0.1 } } 

// STREET : EXTEND FROM X = -3.2 TO 4 AND Z = 0 TO 35
#if ( STREET = yes )     
  height_field {
  tga "street.tga"
  scale <7.3, 0.1, 35>
  translate <-3.3, 0, 6>
  texture {
    pigment {
      granite
      pigment_map {
        [0 color rgb 0]
        [1 color rgb 0.2] 
        }
      }
    normal { bumps 0.05}
    }
  }
  // REFLECTIVE SURFACE FOR WATER
  box { <-4, -1, 0>, <4, 0.026, 35>
    texture {
      normal { bumps 0.04 scale <0.005,0.1,0.1> }
      finish { reflection 0.3 } 
      }
    }      
#end    
            
// ********************************************************            
// LEFT PART
#if ( LEFT_PART = yes )

  // LEFT SIDEWALK  
  #if ( DETAILED_SIDEWALK = yes )
    #include "sidewalk.inc"
    object {SIDEWALK_15x60 
      scale <-0.25,0.15,0.25>
      translate <-3.2,0,2> 
      }         
  #end
  box { <-7,0,2>, <-3.2,0.13,30>
    pigment { color rgb 0.2 }
    }       

  // STREET NAME    
  #if ( LAMPPOSTS = yes )
    #include "reverbere.inc"         
    REVERBERE ( yes , <-4.4, 0.10, 8 > )
    REVERBERE ( no , <-4.4, 0.10, 16 > )
    REVERBERE ( no , <-4.4, 0.10, 24 > )
  #end                         

  // FANTASY_DOG     
  #if ( FANTASY_DOG = yes )
    #include "fantasy_dog.inc"
    object { fantasy_dog scale 1.3 rotate 60*y translate <-4.0, 0.15, 8.2 > }  
  #end                          
  
  // LIZARDS
  #if ( LIZARDS = yes )
    #include "lizard.inc"
    LIZARD ( 4, 0, 0, <-4.7, 4.3, 8.5>, <0,0,60>)
    LIZARD (40, 0, 0, <-4.0, 3.3, 7.5>, <0,-120,40>)
 
  #end                          
  
  

  
// LEFT HOUSES ****************************************************** 
  // HOUSE WITH THE WINDOW
    #if ( HOUSE1 = yes )
      #include "house1.inc"
    #end
    
  // NEXT HOUSE        
    #if ( HOUSE2 = yes )         
      box { <-6.85, 0, 12.1> , <-20, 5, 20> 
        pigment { rgb 0.2 }
        }        
      box { <-6.90, 0, 12.1> , <-20, 3.5, 20> 
        normal {bumps 1 scale 0.2}
        texture { finish {reflection 0.3}}
        }        
      box { <-6.80, 0, 12.1> , <-20, 5, 20> 
        texture {
          pigment { 
            image_map {
              sys "house2.bmp"
              interpolate 2
              transmit 255 1
              once
              }             
            scale <7, 3.5, 7>
            rotate <-10, 80, 0> 
            translate <-6.8, 0.0, 12.1> 
            }       
          finish { ambient 0.1 }  
          }                        
      }
    #end               

  // CORNER HOUSE  
    box { <-7,0,20.1> , <-20,6,30> 
      pigment { color rgb <0.2, 0.2, 0.2> }
      }                          

#end

// ***************************************************    
// RIGHT PART OF PICTURE

#if ( RIGHT_PART = yes )

  // RIGHT WALK FROM X=4 TO 8  
  box { <19, 0, 0>, <4.0, 0.20, 35> 
    texture {
      pigment{ color rgb <0.3, 0.3, 0.3>}
      }
    }

  union {
    cylinder { 0, 0.9*y, 0.07 translate < 4.2, 0, 14> }
    cylinder { 0, 0.9*y, 0.07 translate < 4.2, 0, 16> }
    cylinder { 0, 0.9*y, 0.07 translate < 4.2, 0, 18> }
    cylinder { 0, 0.9*y, 0.07 translate < 4.2, 0, 20> }
    sphere { 0, 0.08 translate < 4.2, 1.0, 14> }
    sphere { 0, 0.08 translate < 4.2, 1.0, 16> }
    sphere { 0, 0.08 translate < 4.2, 1.0, 18> }
    sphere { 0, 0.08 translate < 4.2, 1.0, 20> }
      pigment { color rgb <0.40, 0.40 ,0.30 >}          
      normal { bumps 0.1 scale 0.02 }
      finish { phong 1 metallic 0.3}
    }

  // BUS
  #if ( SHOW_BUS = yes )  
    #include "bus.inc"
    object { BUS 
      rotate 90*y   
      scale <0.9,1,1>
      translate <1.5,0,28>
      }
  #else
    box { <0, 0.2, 0>, <10,3, 2.8>
      rotate 90*y
      translate <0,0,28> 
      pigment { rgb <1,1,1> }
      finish { reflection 0.2 }
      }              
  #end  
  
  // HOUSES (POSITIONS ONLY) 
  // RIGHT HOUSES
  // ---------------------------------      
  // CINEMA, EXTEND FROM Z= 15 TO 23
  difference {
    box { <8,0,15> , <16,10,23> }
    // interior
    box { <8.4,0.5,15.2>, <14.4,5,22.8> }
    // window 1
    box { <7,0.5,15.5>, <9,3,18.5>}                     
    // window 2
    box { <7,0.5,19>, <9,3,22>}                     
    pigment { 
      granite         
      color_map {
        [0 rgb 1]
        [1 rgb 0.6]
        }
      scale <0.2,2,0.2>
      }
    }                    
  // OUTSIDE STEP  
  box { <7.7, 0, 15>, <8, 0.35, 23>                     
    pigment { 
      granite         
      color_map {
        [0 rgb 1]
        [1 rgb 0.6]
        }
      scale <0.2,2,0.2>
      }
    }  
  // INSIDE NOTICES
  box { < 8.4, 0.5, 22.79> , < 14.4, 4, 22.80> 
    pigment { image_map { sys "mur.bmp" } scale < 6, 3.5, 1> translate <8.4, 0.5, 1> }
    //finish {  } 
    }                        
  
  // CINEMA ROOF (FLAT ROOF)
  box { <7.8,10,14.8> , <16.2,10.3,23.2> pigment {color rgb 1}}   
  
  // WITH GARGOYLE
  box { 0, <1,1,0.5>
    pigment {
      image_map
        {
        sys "gargoyle.bmp" 
        map_type 0 
        once
        interpolate 2
        transmit 15 1
        }      
      }
    finish {ambient 0.2}   
    scale <1.5, 2.5, 0.3>
    rotate 20*y
    translate <8, 10.3, 18.5>  
    }

    
  // LIGHTS IN THE CINEMA
  light_source { <10,4,19>, color rgb <0.5,0.5,0.4>*2 
    fade_distance 5 
    fade_power 15
    #if ( AREA_LIGHTS = yes )
      area_light x, 3*z, 4, 4 
    #end
    }
  
  // ENSEIGNE CINEMA  
  cylinder { <8,4,23>, <8,9.2,23>, 0.05 
    pigment { color rgb 1 } 
    }
  cylinder { <6.5,9.2,23>, <8,9.2,23>, 0.05 
    pigment { color rgb 1 } 
    }
  box { <6.5,4,23> , <7.8,9,23.1> 
    pigment { color rgb <4,4,2> } 
    finish { ambient 20 diffuse 1 }
    }                       
  union {
    text { ttf "arial.ttf", "C", 1, 0 
      translate <0.15, -1, 0> }
    text { ttf "arial.ttf", "I", 1, 0
      translate <0.4, -2, 0> }
    text { ttf "arial.ttf", "N", 1, 0
      translate <0.15, -3, 0> }
    text { ttf "arial.ttf", "E", 1, 0
      translate <0.15, -4, 0> }
    text { ttf "arial.ttf", "M", 1, 0
      translate <0.1, -5, 0> }
    text { ttf "arial.ttf", "A", 1, 0
      translate <0.15, -6, 0> }
    scale <1,0.8,0.1>  
    translate < 6.7, 9, 22.99>
    }
    
  // AFFICHE 1                 
  light_source { < 7.0, 10, 20.5> , <2,2,1> 
    spotlight radius 30 falloff 40 tightness 5 point_at <7, 0, 20.5> }       
  box { 0, <1, 0.05, 0.05> translate <7, 10.05, 20.475>}  
  box { 0, <0.1, 0.1, 0.2> translate <7, 10.05, 20.4>}  
  box { <7.95,3.7,19.1> , <8,9,22> 
    pigment { image_map { sys "harry3.bmp" } rotate 90*y scale <1,5,2.9> translate <6.5,3.8,19.1>}
    finish { reflection 0.3 diffuse 1 ambient 1} 
    }                        
  // AFFICHE 2                 
  light_source { < 7.0, 10, 17.5> , <2,2,1> 
    spotlight radius 30 falloff 40 tightness 5 point_at <7, 0, 17.5> }       
  box { 0, <1, 0.05, 0.05> translate <7, 10.05, 17.475>}  
  box { 0, <0.1, 0.1, 0.2> translate <7, 10.05, 17.4>}  
  box { <7.95,3.7,16> , <8,9,18.9> 
    pigment { image_map { tga "starwars.tga" } rotate 90*y scale <1,5,2.9> translate <6.5,3.8,16>} 
    finish { reflection 0.3 diffuse 1 ambient 1}
    }                                                   
    
  // PEOPLE
  #if ( PEOPLE = yes )
    #include "people.inc"
    object {WOMAN1 rotate  20*y translate < 5,0.20,15>}  
    object {WOMAN2 rotate 200*y translate < 6,0.20,16>}  
    object {WOMAN3 rotate  20*y translate < 5,0.20,17>}  
    object {WOMAN1 rotate  20*y translate < 9,0.50,15>}  
    object {WOMAN2 rotate 200*y translate <10,0.50,16>}  
    object {WOMAN3 rotate  20*y translate < 9,0.50,17>}  
    object {WOMAN1 rotate 200*y translate < 5,0.20,18>}  
    object {  MAN2 rotate  20*y translate < 6,0.20,18>}  
    object {  MAN1 rotate 200*y translate < 7,0.20,18>}  
    object {  MAN2 rotate 200*y translate <10,0.50,18>}  
    object {WOMAN2 rotate  20*y translate < 5,0.20,19>}  
    object {WOMAN3 rotate 200*y translate < 6,0.20,19>}  
    object {WOMAN4 rotate  20*y translate < 7,0.20,19>}  
    object {WOMAN3 rotate  20*y translate < 5,0.20,20>}  
    object {WOMAN4 rotate 200*y translate < 6,0.20,20>}  
    object {  MAN1 rotate  20*y translate < 7,0.20,20>}  
  #end    
  
// LAST BUILDING ON THE RIGHT SIDE
  box { <8, 0, 23> , <14, 7, 30> pigment { rgb 1 } }  
    
#end      
    
// FRONT PART OF THE PICTURE  
#if ( FRONT_PART = yes )  

//******************************************************
// FRONT HOUSES
  
  // THE LEFT ONE WITH TOWERS  
  union {  box { <20,0,50> , <33,15,80>}
    cylinder { <23,0,50>, <23,15,50>, 3
      texture {                              
        pigment { brick color rgb 0.2 color rgb 0.5 brick_size <0.5,0.3, 0.5> mortar 0.02}
        }                       
      }
    cone { <23,15,50>, 3.3, <23,23,50>, 0 
      pigment {color rgb <0.2,0.1,0.3>} 
      finish { diffuse 2 phong 2}
      normal { bumps 0.2}
      }
    cylinder { <33,0,50>, <33,15,50>, 3
      texture {                              
        pigment { brick color rgb 0.2 color rgb 1 brick_size <0.5,0.3, 0.5> mortar 0.02}
        }                       
      }
    cone { <33,15,50>, 3.3, <33,23,50>, 0 
      pigment {color rgb <0.2,0.1,0.3>} 
      finish { diffuse 2 phong 2}
      normal { bumps 0.2}
      }
    cylinder { <23, 15, 50>, <33, 15, 50> ,0.5
      pigment {color rgb <0.2,0.1,0.3>} 
      finish { diffuse 2 phong 2}
      normal { bumps 3}
      }
    translate -35*x  
    }

// ROOFS AND TOWERS 
// BOX TOWER
  box { <0,0,0> , <1,1,1> 
    scale <20, 17, 15> 
    translate <15, 0, 80>
    texture {                              
      pigment { 
        gradient y
        color_map {
          [0.2 rgb 0]
          [0.2 rgb <1, 1, 0.7>]
          }       
        scale 1.5  
        }     
      finish { ambient 6 }  
      }                 
    }    
// Cylindric TOWER
  cylinder { 0*y , 35*y , 8 
    translate <60, 0, 120>
    texture {                              
      pigment { 
        gradient y
        color_map {
          [0.4 rgb 0]
          [0.4 rgb <1, 1, 0.7>]
          }       
        scale 1.5  
        }     
      finish { ambient 6 }  
      }                 
    }               

// BLACK BACK BUILDINGS
  box { 0,1 
    scale <200, 16, 10>    
    translate < 0, 0, 150>
    pigment { rgb 0 }
    }
  box { <-100, 0, -50>,<100, 15, -60> 
    pigment { rgb 0 }
    }

#end