// Persistence of Vision Ray Tracer Scene Description File
// File: fantasy_dog.inc
// Vers: 3.1
// Desc: Include for Worlds in Worls IRTC 
// Date: 02/09/2002 
// Auth: Dominique Rossi dom.rossi@wanadoo.fr

#local TEST = no;


#declare fantasy_dog =             
union {
  blob {                                       
  // patte arriere droite             
    //doigts
    cylinder { <-0.06,0.20,-0.22>,< 0.03, 0.20, -0.24> 0.02 2 }  
    cylinder { <-0.06,0.20,-0.22>,< 0.05, 0.20, -0.27> 0.02 2 }  
    cylinder { <-0.06,0.20,-0.22>,< 0.05, 0.20, -0.20> 0.02 2 }  
    //patte
    cylinder { <-0.06,0.20,-0.22>,<-0.12,0.28,-0.14> 0.04 2 }  
    cylinder { <-0.12,0.28,-0.14>,<0,0.30,-0.14> 0.06 2 }  
    cylinder { <0,0.30,-0.14>, <-0.04,0.33,-0.05> 0.06 2 }  
  
  // patte arriere gauche             
    //doigts
    cylinder { <-0.02,0.03,0.1>,<0.07,0,0.12> 0.02 2 }  
    cylinder { <-0.02,0.03,0.1>,<0.05,0,0.15> 0.02 2 }  
    cylinder { <-0.02,0.03,0.1>,<0.05,0,0.08> 0.02 2 }  
    //patte
    cylinder { <0,0.02,0.1>,<-0.07,0.15,0.1> 0.04 2 }  
    cylinder { <-0.07,0.15,0.1>,<0,0.25,0.1> 0.06 2 }  
    cylinder { <0,0.25,0.1>, <-0.04,0.3,0.08> 0.06 2 }  
  
  // patte milieu gauche             
    //doigts
    cylinder { <0.18,0.03,0.1>,<0.27,0,0.12> 0.02 2 }  
    cylinder { <0.18,0.03,0.1>,<0.25,0,0.15> 0.02 2 }  
    cylinder { <0.18,0.03,0.1>,<0.25,0,0.08> 0.02 2 }  
    //patte
    cylinder { <0.20,0.02,0.1>,<0.13,0.15,0.1> 0.04 2 }  
    cylinder { <0.13,0.15,0.1>,<0.20,0.25,0.1> 0.06 2 }  
    cylinder { <0.20,0.25,0.1>, <0.16,0.3,0.05> 0.06 2 }  
    
  // patte milieu droite             
    //doigts
    cylinder { <0.10,0.03,-0.1>,<0.19,0,-0.12> 0.02 2 }  
    cylinder { <0.10,0.03,-0.1>,<0.17,0,-0.15> 0.02 2 }  
    cylinder { <0.10,0.03,-0.1>,<0.17,0,-0.08> 0.02 2 }  
    //patte
    cylinder { <0.12,0.02,-0.1>,<0.13,0.15,-0.1> 0.04 2 }  
    cylinder { <0.13,0.15,-0.1>,<0.20,0.25,-0.1> 0.06 2 }  
    cylinder { <0.20,0.25,-0.1>,<0.16,0.30,-0.05> 0.06 2 }  
    
  // patte avant gauche             
    //doigts
    cylinder { <0.38,0.03,0.1>,<0.47,0,0.12> 0.02 2 }  
    cylinder { <0.38,0.03,0.1>,<0.45,0,0.15> 0.02 2 }  
    cylinder { <0.38,0.03,0.1>,<0.45,0,0.08> 0.02 2 }  
    //patte
    cylinder { <0.40,0.02,0.1>,<0.33,0.15,0.1> 0.04 2 }  
    cylinder { <0.33,0.15,0.1>,<0.40,0.25,0.1> 0.06 2 }  
    cylinder { <0.40,0.25,0.1>,<0.36,0.3,0.05> 0.06 2 }  
  
  // patte avant droite             
    //doigts
    cylinder { <0.38,0.03,-0.1>,<0.47,0,-0.12> 0.02 2 }  
    cylinder { <0.38,0.03,-0.1>,<0.45,0,-0.15> 0.02 2 }  
    cylinder { <0.38,0.03,-0.1>,<0.45,0,-0.08> 0.02 2 }  
    //patte
    cylinder { <0.40,0.02,-0.1>,<0.33,0.15,-0.1> 0.04 2 }  
    cylinder { <0.33,0.15,-0.1>,<0.40,0.25,-0.1> 0.06 2 }  
    cylinder { <0.40,0.25,-0.1>,<0.36,0.30,-0.05> 0.06 2 }  
    
  // BODY  
    cylinder { <0,0.3,0>,<0.2,0.25,0> 0.18 2 }  
    cylinder { <0.2,0.25,0>,<0.30,0.3,0> 0.1 2 }  
    cylinder { <0.30,0.25,0>,<0.40,0.3,0> 0.1 2 }  
    cylinder { <0.40,0.25,0>,<0.50,0.35,0> 0.08 2 }
    
  // TAIL    
    cylinder { <0,0.3,0>,<-0.1,0.25,0> 0.1 2 }  
    cylinder { <-0.1,0.25,0>,<-0.2,0.2,-0.05> 0.08 2 }  
    cylinder { <-0.2,0.2,-0.05>,<-0.3,0.2,-0.1> 0.05 2 }  
    cylinder { <-0.3,0.2,-0.1>, <-0.35,0.22,-0.2> 0.02 2 }  

  // HEAD 
    cylinder { <0.55, 0.30, 0>,<0.60, 0.30, 0> 0.12 2 }  
    sphere { <0.60, 0.40, -0.1>, 0.15, -1  }    
    sphere { <0.60, 0.40, 0.1>, 0.15, -1  }    
  // EYES   
    sphere { <0.53, 0.35, -0.06>, 0.03, 15 }    
    sphere { <0.53, 0.35,  0.06>, 0.03, 15 }  
    
    pigment {
      leopard      
      color_map {
        [0 color rgb <0.8,0.6,0.4>]
        [0.5 color rgb <0.3,0.1,0>]}
      turbulence 1
      scale 0.01
      }       
    sturm off
    }
  sphere { <0.535, 0.34, -0.067>, 0.02  pigment { rgb <1,2,2>*2 } }    
  sphere { <0.535, 0.34,  0.067>, 0.02  pigment { rgb <1,2,2>*2 } }  
  bounded_by { box {< -0.1, 0, -0.3>, <0.8, 0.4, 0.2>} }
  }  

#if ( TEST = yes )
  camera {
    location  <0.5, 0.5, -1.0>
    look_at   <0.25, 0.2,  0.0>
    angle 60
    }

  sky_sphere {
    pigment {
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
      }
    }
  
  light_source {
    0*x // light's position (translated below)
    color rgb 2
    translate <-30, 30, -30>
    }

  plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}

  object { fantasy_dog }


#end
