// Persistence of Vision Ray Tracer Scene Description File
// File:   reverbere.pov
// Vers:   3.1
// Desc:   include for a flying lizard
// Date:   02/02/2002
// Auteur: Dominique ROSSI
//           


#version 3.1;

#local TEST = no;

#declare LIZARD_TETE = 
    bicubic_patch {
      type 1 // patch_type (0..1)
      flatness 0.01 // flatness value
      u_steps 5 // # of triangles to subdivide (1-5)
      v_steps 5 // # of triangles to subdivide (1-5)
      < 0, 30,  0>, <40, 20,  0>, <85, 20,  0>, <100,-10,0>,
      < 4, 15, 15>, <43, 10,  7>, <80, 14, 10>, <100,-10,0>,
      <10,  0, 25>, <47,  0, 14>, <75,  7, 20>, <100,-10,0>,
      <20, -20, 30>, <50,-15,15>, <70,  0, 40>, <100,-10,0>
      scale 0.015
      }

#declare LIZARD_AILE =
    polygon {
      22,
      <0,0>, <5,30> , <5,40>, <2, 47>, <-5, 50>, 
      <0, 51>, <10, 60>, <20, 75>, <35, 90>, <60, 97>,
      <85, 100>, <67, 87>, <60, 77>, <60, 73>, <63, 69>, 
      <50, 63>, <40, 50>, <40, 40>, <43, 35>, <30, 27>,
      <20, 20>, <0, 0> 
      scale <0.02, 0.02, 0.02>
      }                  

#macro LIZARD (NUM, TEXT , TEXT2, TRANSL, ROTAT)
   
  #local R1 = seed(NUM);
  union { 
    union {
      object { LIZARD_AILE rotate 20*z scale <-2,2,2> rotate  40*x }                  
      object { LIZARD_AILE rotate 20*z scale <-2,2,2> rotate -40*x }       
      
      pigment {
        #switch ( TEXT2 )
          #case (0)
            agate    
            #break
          #case (1)
            bozo scale 0.5  
            #break
          #case (2)
            radial
            #break
        #end      
        color_map {
          [0   rgbft <1,1,0,0.2,0.2>]
          [0.5 rgbft <0,1,1,0.2,0.2>]
          [1   rgbft <1,0,1,0.2,0.2>]}
        }
      }
    sphere { 0, 1 scale <1, 0.3, 0.3> }
    cone {0, 0.1, <-1.5, -0.3, -0.4>, 0}
    cone {0, 0.1, <-1.5, -0.3,  0.4>, 0}
    #local I = 1;                     
    #local POINT1 = <-0.7, 0, 0>;
    #local POINT2 = <-1.3, 0, 0>;      
    #local SIZE = 0.15;
    #local I_ROTATE = <(rand(R1)-.5)*30,(rand(R1)-.5)*30 ,(rand(R1)-.5)* 30> ;       

    #while ( I < 10 )                  
      cone { POINT1, SIZE, POINT2, SIZE * 0.75 } 
      #local POINT = POINT2 + vrotate( ( POINT2 - POINT1) ,  I_ROTATE ) * 1;
      #local POINT1 = POINT2;
      #local POINT2 = POINT;
      #local SIZE = SIZE * 0.75;
      #local I = I + 1;
    #end                           
    
    
    #local POINT1 = <0, 0, 0>;
    #local POINT2 = <1, 0, 0>;      
    #local SIZE = 0.15;
    
    #local I_ROTATE = <(rand(R1)-.5)*30,(rand(R1)-.5)*30 ,(rand(R1)-.5)*30> ;       
    #local I = 1;                     

    #while ( I < 4 )                  
      cone { POINT1, SIZE, POINT2, SIZE * 0.75 } 
      #local POINT = POINT2 + vrotate( ( POINT2 - POINT1) ,  I_ROTATE ) * 1;
      #local POINT1 = POINT2;
      #local POINT2 = POINT;
      #local SIZE = SIZE * 0.75;
      #local I = I + 1;
    #end
    object {LIZARD_TETE scale <1,1, 1>*0.7 rotate I_ROTATE*<0,3,3> translate POINT1 }
    object {LIZARD_TETE scale <1,1,-1>*0.7 rotate I_ROTATE*<0,3,3> translate POINT1 }

    #switch ( TEXT )
      #case ( 0 )
        pigment {agate scale 1}
      #break
      #case ( 1 )
        pigment { rgb 1}
      #break  
      #case ( 2 )
        pigment {marble }
      #break  
      #case ( 3 )
        pigment {granite}
      #break  
    #end 
    scale 0.15
    rotate ROTAT
    translate TRANSL  
    
    }  
    
#end  


  
#if ( TEST = yes )
  // create a regular point light source
  light_source {
    <10, 1, -20> // light's position
    color rgb 1
    }                 
  // Create an infinite sphere around scene and allow any texture on it
  sky_sphere {
    pigment {
      agate
      color_map {
        [0 rgb <0,0.5,1>]
        [1 rgb <1,1,1>] 
        }
      scale 1  
      }
    }
  
  // set viewer's position in the scene
  camera
    {
    location  <4, 4, -8> // position of camera <X Y Z>
    look_at   <0, 0, 0> // point center of view at this point <X Y Z>
    angle 10
    }      
  
  LIZARD (4, 0, 0, 0, 0)

#end
