// Persistence of Vision Ray Tracer Scene Description File
// File:   ?.pov
// Vers:   3.1
// Desc: 
// Date:   mm/dd/yy
// Auteur: Dominique ROSSI
//
#version 3.1;

#local TEST = no;
#if ( TEST = yes )
  global_settings { assumed_gamma 1.0 }
  
  camera {
    location  <0.0, 0.5, -4.0>
    look_at   <0.0, 1.5,  0.0>
    angle 80
    }
  
  
  light_source {
    <-30, 30, -30>
    color rgb 1  
    }
  
  sky_sphere {
    pigment { 
      agate
      scale 0.1
      }
    }
#end

#declare WOMAN1 = 
  box { 0, <1,1,0.0001>
    pigment {
      image_map
        {
        sys "woman1.bmp" 
        map_type 0 
        interpolate 2
        transmit 15 1
        } 
      } 
    finish {ambient 1}   
    scale <0.6, 1.57, 1.7>  
    }
#declare WOMAN2 = 
  box { 0, <1,1,0.0001>
    pigment {
      image_map
        {
        sys "woman2.bmp" 
        map_type 0 
        interpolate 2
        transmit 15 1
        } 
      } 
    finish {ambient 1}   
    scale <0.6, 1.7, 1.7>  
    }
#declare WOMAN3 = 
  box { 0, <1,1,0.0001>
    pigment {
      image_map
        {
        sys "woman3.bmp" 
        map_type 0 
        interpolate 2
        transmit 15 1
        }      
      }
    finish {ambient 1}   
    scale <0.6, 1.65, 1.7>  
    }
#declare WOMAN4 = 
  box { 0, <1,1,0.0001>
    pigment {
      image_map
        {
        sys "woman4.bmp" 
        map_type 0 
        interpolate 2
        transmit 255 1
        }      
      }
    finish {ambient 1}   
    scale <0.6, 1.7, 1.7>  
    }
#declare MAN1 = 
  box { 0, <1,1,0.0001>
    pigment {
      image_map
        {
        sys "man1.bmp" 
        map_type 0 
        interpolate 2
        transmit 15 1
        } 
      } 
    finish {ambient 1}   
    scale <0.6, 1.75, 1.7>  
    }

#declare MAN2 = 
  box { 0, <1,1,0.0001>
    pigment {
      image_map
        {
        sys "man2.bmp" 
        map_type 0 
        interpolate 2
        transmit 255 1
        } 
      } 
    finish {ambient 1}   
    scale <0.6, 1.8, 1.7>  
    }

#if ( TEST = yes )
  object { WOMAN1 }  
#end