// Persistence of Vision Ray Tracer Scene Description File
// File:   reverbere.pov
// Vers:   3.1
// Desc:   include for a ancient reverbere
// Date:   02/02/2002
// Auteur: Dominique ROSSI
//           


#version 3.1;

#declare TEST = no;

// REVERBERE
#declare SUPPORT_LANTERNE = union {
  blob { cylinder { <20,  0, 0>, <40, 20, 0>, 10 1 } threshold .1}
  blob { cylinder { <40, 20, 0>, <60, 55, 0>, 10 1} threshold .1}
  blob { cylinder { <60, 55, 0>, <80, 70, 0>, 10 1} threshold .1}
  blob { cylinder { <80, 70, 0>, <90, 65, 0>, 10 1} threshold .1}
  scale <2,1.3,2>
  }


#macro REVERBERE ( WITH_PANNEL , POSITION )
  union {
  #if ( WITH_PANNEL = yes)
    // PANNEL   
    union {
      box { <-0.4, -0.2, -0.05 >, <0.4, 0.2, -0.09> }
      box { <-0.4, -0.2, 0.05 >, <0.4, 0.2, 0.09> } 
      pigment {
        boxed         
        color_map {
          [0.1 color rgb <1,1,1>]
          [0.1 color rgb <0,0,0.6>]
          }   
        scale <0.4,0.2,1>
        }
      translate 2.10*y  
      finish { diffuse 1}  
      }
    union { 
      text {
        ttf             // font type (only TrueType format for now)
        "times.ttf",  // Microsoft Windows-format TrueType font file name
        "Dr Jekyll",      // the string to create
        1,              // the extrusion depth
        0               // inter-character spacing
        scale <0.18,0.15,0.185>
        translate <-0.33, 2.13, -0.0925> }
      text {
        ttf             // font type (only TrueType format for now)
        "times.ttf",  // Microsoft Windows-format TrueType font file name
        "Street",      // the string to create
        1,              // the extrusion depth
        0               // inter-character spacing
        scale <0.2,0.15,0.185>
        translate <-0.23, 1.98, -0.0925> }
      pigment { rgb 1 }      
      finish { ambient 2 }  
      }
     
  #end    
    
  // COLUMN  
  torus { 1, 0.05 scale <0.15, 1.5, 0.15>}
  torus { 0.13, 0.02 translate 0.10*y }
  torus { 0.11, 0.02 translate 0.14*y }
  cone { 0*y, 0.14, 0.6*y,0.02}
  cone { 0*y, 0.12, 0.6*y,0.04}
  cone { 0*y, 0.08, 0.6*y,0.06}
  torus { 0.08, 0.02 translate 0.60*y }
  torus { 0.06, 0.02 translate 0.64*y }
  cone { 0.60*y, 0.08, 0.90*y, 0.00}
  cone { 0.60*y, 0.07, 0.90*y, 0.05}
  cone { 0.60*y, 0.05, 0.90*y, 0.07}
  cone { 0.60*y, 0.00, 0.90*y, 0.08}
  torus { 0.07, 0.02 translate 0.90*y }
  torus { 0.05, 0.02 translate .94*y }
  cone { 0.94*y, 0.06, 2.5*y, 0.04}   
  torus { 0.05, 0.02 translate 2.5*y }                 
  
  // HORIZ PART UNDER THE LAMP
  cylinder { -z, z, 1 scale <0.02, 0.02, 0.2> translate 2.45*y}
  
  // SUPPORT LANTERNE         
  object { SUPPORT_LANTERNE scale 0.001 rotate 45*y translate <0,2.5,0>}
  object { SUPPORT_LANTERNE scale 0.001 rotate 135*y translate <0,2.5,0>}
  object { SUPPORT_LANTERNE scale 0.001 rotate 225*y translate <0,2.5,0>}
  object { SUPPORT_LANTERNE scale 0.001 rotate 315*y translate <0,2.5,0>}
  box { -1, 1 scale <0.135,0.01,0.135> translate 2.6*y }
  
  // LAMP                    
  prism {
    conic_sweep
    linear_spline
    0.66,        // height 1
    1.0,        // height 2
    5,          // number of points
    < -1, -1>, < 1,  -1>, < 1, 1>, < -1,  1>, < -1, -1>
    scale <0.18,1,0.18>
    translate 1.93*y       
    texture {    
      pigment { rgbf <0.6,1.0,1.0,0.7> }       
      finish { specular 0.1  diffuse 1}
      }
    }            
  sphere { 2.70*y, 0.13  
     pigment { rgbf 1 }
     finish { specular 1 }
     no_shadow
     }
  light_source {
    <0, 2.76, 0>
    color rgb 1      
    area_light 0.1*x,0.1*z,3,3 
    fade_distance 1.5 fade_power 20
    } 

  light_source {
    <0, 2.5, 0>
    color rgb 0.4      
    area_light 0.5*x,0.5*z,3,3 
    spotlight
    radius 30 
    falloff 40 
    tightness 10 
    point_at 0
    }
                   
  // 4 METALLIC SIDES OF LAMP
  cylinder { < 0.12,2.59, 0.12>, < 0.18,2.92, 0.18>, 0.01}
  cylinder { < 0.12,2.59,-0.12>, < 0.18,2.92,-0.18>, 0.01}
  cylinder { <-0.12,2.59, 0.12>, <-0.18,2.92, 0.18>, 0.01}
  cylinder { <-0.12,2.59,-0.12>, <-0.18,2.92,-0.18>, 0.01}

  // UPPER PART OF THE LAMP
  box { -1, 1 scale <0.21,0.01,0.21> translate 2.92*y }
  prism {
    conic_sweep
    linear_spline
    -1,        // height 1
    -0.6,        // height 2
    5,          // number of points
    <-1,-1>, <1,-1>, <1,1>, <-1,1>, <-1,-1>
    scale <0.15,0.25,0.15>
    translate 3.17*y        
    }
  box { -1, 1 scale <0.12,0.005,0.12> translate 3.04*y }
  sphere { 0, 1 scale <0.1,0.05,0.1> translate 3.04*y }
  sphere { 0, 1 scale <0.04,0.05,0.04> translate 3.09*y }
  sphere { 0, 1 scale <0.07,0.03,0.07> translate 3.12*y }
  
  pigment { color rgb <0.40, 0.40 ,0.30 >}          
  normal { bumps 0.1 scale 0.02 }
  finish { phong 1 specular 0.2 metallic 0.3}
  scale <1, 1.25, 1>
  translate POSITION
  } 
#end  
  
  
#if ( TEST = yes )
  // create a regular point light source
  light_source {
    <10, 1, -20> // light's position
    color rgb 1
    }                 
  // Create an infinite sphere around scene and allow any texture on it
  sky_sphere {
    pigment {
      gradient y
      color_map { 
        [0.0 color rgb <0.7,0.7,1.0>*0] 
        [1.0 color blue 0.5*0] }
      }
    }
  
  // set viewer's position in the scene
  camera
    {
    location  <0.0, 2.0, -6.0> // position of camera <X Y Z>
    look_at   <0.0, 3,  0.0> // point center of view at this point <X Y Z>
    angle 20
    }      
  plane {y, 0 pigment { rgb 0.9}}  
  
  REVERBERE ( yes , <0,0,1>)

#end
