//#version unofficial MegaPov 0.5
#include "colors.inc"

#ifndef (Included_File)
	#declare Included_File=false;
#end

#if (!Included_File)
	#declare Final=false;
	
	#if (Final)
	  global_settings {
	    radiosity {
	      pretrace_start 0.08
	      pretrace_end   0.01
	      count 500
	
	      nearest_count 10
	      error_bound 0.02
	      recursion_limit 1
	
	      low_error_factor 0.2
	      gray_threshold 0.0
	      minimum_reuse 0.015
	      brightness 1
	
	      adc_bailout 0.01/2 
	      
	      normal on
	    }
	  }
	#end
#end

#include "petibonum.inc"
#declare Costume      = "child1.cdf" // Name of Costume Definition File eg. "sample.cdf"
#include "bmpeople.inc"
/****************************************************************
 Hand Settings
   Hand Rotation Vectors <X,Y,Z>
   <0,0,0> - fingers pointing down with thumbs foward.
*****************************************************************/
                                              // Right Hand
#declare BM_RFP_Pos    = <45,80,60,0>; //<  5, 45,  5,   0>;  // Pinky Finger
#declare BM_RFR_Pos    = <45,80,60,0>; //< 10, 30,  5,   0>;  // Ring Finger
#declare BM_RFM_Pos    = <45,80,60,0>; //<  5, 15,  5,   0>;  // Middle Finger
#declare BM_RFI_Pos    = <45,80,60,0>; //<  0, 10,  0,   0>;  // Index Finger
#declare BM_RFT_Pos    = <  0,-10,  5,  10>;  // Thumb
  
                                              // Left Hand
#declare BM_LFP_Pos    = <  5, 45,  5,   0>;  // Pinky Finger 
#declare BM_LFR_Pos    = < 10, 30,  5,   0>;  // Ring Finger  
#declare BM_LFM_Pos    = <  5, 15,  5,   0>;  // Middle Finger
#declare BM_LFI_Pos    = <  0, 10,  0,   0>;  // Index Finger 
#declare BM_LFT_Pos    = <  0,-10,  5,  10>;  // Thumb        

/****************************************************************
 Foot Settings
   Foot Rotation Vectors <X,Y,Z>
   <0,0,0> - toes pointing forward
*****************************************************************/

#declare BM_Toe_Angle  =<0,0,20>;  // x = Left Foot
                                  // y = ** Not Used **
                                  // z = Right Foot

/****************************************************************
 Hair Settings     
   Note: Hair drastically increases the parse time !
*****************************************************************/
#declare BM_Hair_On    = 0;          // Hair (1) - No Hair (0)
#declare BM_Hair_Rot   = <0,0,0>;    // Hair Rotation - Standard <0,0,0>
#declare BM_Hair_Arch  = 1;          // Arch hairline over head in line with ears (1) or Not (0)
#declare BM_Hair_Thck  = 0.1;       // Hair Thickness <0.15 to 0.5> - Standard: 0.25
#declare BM_Hair_Line  = 5;          // Hair Line Height (Best Settings 3 to 6) - Standard: 5 
#declare BM_Hair_LDpth = 0.7;        // Hairline profile Depth (Range: 0-Straight Fringe to 1-Widows Peak) - standard: 0.7
#declare BM_Hair_Wght  = 0.01;       // Hair Weight (Range 0.005 to 0.05) - Standard: 0.01
#declare BM_Hair_Hght  = 1;          // Hair Height (Range 1 to 2) - Standard: 1
#declare BM_Hair_Length= 2;         // Hair Length (1 to 20) - Standard: 10
#declare BM_Hair_Curl  = 0.05;       // Curliness (Range 0-Straight to 0.1-Curly) - Standard: 0.05

#ifdef (Costume)
    #include Costume
#end


#declare BM_PoseNo=-1; 
Blob_Man(BM_Gender,0)
#declare Child1 = object { 
	BlobMan 
	translate -y*min_extent(BlobMan).y
	scale 1.5 / (max_extent(BlobMan).y -min_extent(BlobMan).y)
	translate -0.1*y 
}


#if (!Included_File)

	#declare Grass1  =          
		material {
			texture {
				pigment { 
					granite
					colour_map
					{
						[ 0 rgb <0.1,0.3,0.05> ]
						[ 1 rgb <0.2,0.4,0.1> ]
					}
				}
				normal {
					bumps
					scale 0.1
					bump_size 0.05
				}
				finish {
					diffuse 0.7
					ambient 0.3
					specular 0
				}
			}
		}

	plane { y, 0 material {Grass1} }
	
	sky_sphere {
		pigment {
			gradient y
			pigment_map {
				[0.5 color rgb .7]
				[0.6 granite scale <1,0.25,1>
					colour_map {
						[ 0.1 rgb <.6,.6,.7> ]
						[ 0.9 rgb <.3,.4,.6> ]
					} 
				]
			}
	      scale 2
	      translate -1
		}
	}
	
	camera {
		location <-50,6,-20>
		sky y
		up 3*y
		right 4*x
		look_at 200*x-16*y
		angle 60
	}
	
	//
	// Lightting
	//
	#declare c = color rgb <.8, .85, 1>; 
	#declare s1 = color rgb <1, .8, .6>; 
	#declare n = 6;
	
	#if (Final)
	
		light_source {
		  <10000, 10000, -15000>
		  color s1*.6
		  area_light <1, 0, 2>, <-2, 2, 1>, 6, 6
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <0, 10000, 0>
		  color c
		  area_light x*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <-10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, 10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, -10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
	#else
		light_source {
		  <10000, 10000, -5000>
		  color rgb 1
		  area_light <100, 0, 200>, <-200, 200, 100>, 3, 3
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <-100, 100, 0>
		  color rgb .5
		  shadowless
		}
	#end
	
	light_source {
		<-60,30,-40> White
	}

	#declare loc=<1,0,1>*(<-50,6,-20>*19+<200,-16,0>)/20; 
	object { 
		Child1
		rotate y*180
		translate loc -0.05*y
	}
	
#end