//#version unofficial MegaPov 0.5
#include "colors.inc"

// various glass finishes, colors and interiors
//
#include "glass.inc"

#ifndef (Included_File)
	#declare Included_File=false;
#end

#if (!Included_File)
	#declare Final=false;
	
	#if (Final)
	  global_settings {
	    radiosity {
	      pretrace_start 0.08
	      pretrace_end   0.01
	      count 500
	
	      nearest_count 10
	      error_bound 0.02
	      recursion_limit 1
	
	      low_error_factor 0.2
	      gray_threshold 0.0
	      minimum_reuse 0.015
	      brightness 1
	
	      adc_bailout 0.01/2 
	      
	      normal on
	    }
	  }
	#end
#end

#declare rooft =
	texture {
		pigment { 
			cells scale <0.2,0.3,10>
			pigment_map {
				[ 0 rgb <0.5,0.1,0> ]
				[ 0.2 rgb <0.6,0.1,0.1> ]
				[ 1 rgb <0.7,0.1,0.1> ]
			}
		}
		normal { gradient y ramp_wave 
			scale 0.3
			bump_size 0.4
			slope_map {
				[0 <0,3>]
				[0.05 <1,3>]
				[0.05 <1,-0.1>]
				[1.00 <0,-0.1>]
			}
			turbulence 0.01
		} 
 
	}
	
#declare Terracotta =
	texture {
		pigment { rgb <0.9,0.5,0.4>*0.6 }
		finish { ambient 0 diffuse 1 specular 0 }
	}
	
#declare Brickwork =
	texture { 
		brick
			texture { pigment { Gray40 } }, // mortar
			texture { 
				pigment { 
					cells 
					scale <0.20,0.06,0.20>/2
					warp {
						repeat y*0.03           // repeat direction
						offset <0.20,0,0.20>/4    // translate when repeating
					}

					pigment_map {
						[ 0 rgb <0.8,0.2,0.1> ]
						[ 1 rgb <0.7,0.1,0.1> ]
					}
				}
			} // bricks	
			brick_size <0.20,0.06,0.20>/2
			mortar 0.01
	}

#declare White_PVC =
	texture {
		pigment { rgb 1 }
		finish { ambient 0 specular 0.3 diffuse 0.7 }
	}

#macro MakeSemi( n )
	union
	{
		// house body
		difference {
			box { <-5,0,-4> <5,5,4> 
				texture { 
					gradient y scale 5
					texture_map
					{
						[ 0.5 Brickwork translate n ]
						[ 0.5 pigment
							{
								cells translate y*n-z/2 scale <6.1, 6.1, 15>
								pigment_map 
								{
									[ 0 rgb <0.8,0.7,0.7> ]
									[ 0.2 rgb <0.6,0.75,0.9> ]
									[ 0.5 rgb 0.9 ]
									[ 0.6 rgb 1.0 ]
									[ 0.75 rgb <0.7,0.9,0.75> ]
									[ 1.0 rgb <0.95,1.0,0.9> ]
								}                 
							}
						]
					}
				}
			}
			// px Lounge
			box { <0.10,0.01,-3.70> <2.80,2.40,-0.10> pigment { White } }
			// px Lounge Window Gap
			box { <0.60,0.40,-4.10> <2.30,2.00,-3.60> texture { Brickwork } }
			// nx Lounge
			box { <-0.10,0.01,-3.70> <-2.80,2.40,-0.10> pigment { White } }
			// nx Lounge Window Gap
			box { <-0.60,0.40,-4.10> <-2.30,2.00,-3.60> texture { Brickwork } }

			// px Kitchen
			box { <2.90,0.01,-3.70> <4.80,2.40,-1.10> pigment { White } }
			// px Kitchen Doorway
			box { <3.00,-0.01,-4.10> <3.80,2.00,-3.60> texture { Brickwork } }
			// px Kitchen Window Gap
			box { <3.90,1.20,-4.10> <4.70,2.00,-3.60> texture { Brickwork } }
			// nx Kitchen
			box { <-2.90,0.01,-3.70> <-4.80,2.40,-1.10> pigment { White } }
			// nx Kitchen Doorway
			box { <-3.00,-0.01,-4.10> <-3.80,2.00,-3.60> texture { Brickwork } }
			// nx Kitchen Window Gap
			box { <-3.90,1.20,-4.10> <-4.70,2.00,-3.60> texture { Brickwork } }

			// px Bedroom
			box { <0.10,2.60,-3.70> <2.80,4.99,-0.10> pigment { White } }
			// px Bedroom Window Gap
			box { <0.30,3.80,-4.10> <2.50,4.80,-3.60> texture { Brickwork } }
			// nx Bedroom
			box { <-0.10,2.60,-3.70> <-2.80,4.99,-0.10> pigment { White } }
			// nx Bedroom Window Gap
			box { <-0.30,3.80,-4.10> <-2.50,4.80,-3.60> texture { Brickwork } }
                                      
			// px bathroom
			box { <2.90,2.6,-3.70> <4.80,4.99,-1.10> pigment { White } }
			// px bathroom Window Gap
			box { <3.00,3.80,-4.10> <4.70,4.80,-3.60> texture { Brickwork } }
			// nx bathroom
			box { <-2.90,2.6,-3.70> <-4.80,4.99,-1.10> pigment { White } }
			// nx bathroom Window Gap
			box { <-3.00,3.80,-4.10> <-4.70,4.80,-3.60> texture { Brickwork } }
		}
		
		// Window glass
		// (big sheet to fake glass for all doors/windows at once)
		box {
			<-4.99,0,-3.848> <4.99,5,-3.852>
			texture {
				pigment { Col_Glass_General }
				finish { F_Glass5 }
				normal { bumps 0.01 }
			}
			hollow on
			interior {
				I_Glass1
			}
		}
		
		// px Kitchen Door
		union {
			box { <3.00,-0.01,-3.84> <3.10,2.00,-3.87> }
			box { <3.70,-0.01,-3.84> <3.80,2.00,-3.87> }
			box { <3.00,-0.01,-3.84> <3.80,0.20,-3.87> }
			box { <3.00, 1.90,-3.84> <3.80,2.00,-3.87> }
			box { <3.00, 0.80,-3.84> <3.80,1.00,-3.87> }
			texture { White_PVC } 
		}
			
		// nx Kitchen Door
		union {
			box { <-3.00,-0.01,-3.84> <-3.10,2.00,-3.87> }
			box { <-3.70,-0.01,-3.84> <-3.80,2.00,-3.87> }
			box { <-3.00,-0.01,-3.84> <-3.80,0.20,-3.87> }
			box { <-3.00, 1.90,-3.84> <-3.80,2.00,-3.87> }
			box { <-3.00, 0.80,-3.84> <-3.80,1.00,-3.87> }
			texture { White_PVC } 
		}
		
		// px Lounge Window Frame
		union {
			box { <0.60,-0.01,-3.7> <0.62,2.00,-4> }
			box { <2.28,-0.01,-3.7> <2.30,2.00,-4> }
			box { <0.60, 0.40,-3.7> <2.30,0.42,-4.03> }  // window sill
			box { <0.60, 1.98,-3.7> <2.30,2.00,-4> }
			box { <0.60, 1.74,-3.84> <2.30,1.76,-3.87> } // thin crosspiece
			box { <1.41, 1.75,-3.84> <1.44,2.00,-3.87> } // thin vertical piece
			texture { White_PVC } 
		}

		// nx Lounge Window Frame
		union {
			box { <-0.60,-0.01,-3.7> <-0.62,2.00,-4> }
			box { <-2.28,-0.01,-3.7> <-2.30,2.00,-4> }
			box { <-0.60, 0.40,-3.7> <-2.30,0.42,-4.03> }  // window sill
			box { <-0.60, 1.98,-3.7> <-2.30,2.00,-4> }
			box { <-0.60, 1.74,-3.84> <-2.30,1.76,-3.87> } // thin crosspiece
			box { <-1.41, 1.75,-3.84> <-1.44,2.00,-3.87> } // thin vertical piece
			texture { White_PVC } 
		}

		// px bedroom Window Frame
		union {
			box { <0.30,3.80,-3.7> <0.32,4.80,-4> }
			box { <2.48,3.80,-3.7> <2.50,4.80,-4> }
			box { <0.30,3.80,-3.7> <2.50,3.82,-4.03> }  // window sill
			box { <0.30,4.78,-3.7> <2.50,4.80,-4> }
			box { <1.39,3.80,-3.84> <1.42,4.80,-3.87> } // thin vertical piece
			box { <0.84,3.80,-3.84> <0.86,4.80,-3.87> } // thin vertical piece
			box { <1.94,3.80,-3.84> <1.96,4.80,-3.87> } // thin vertical piece
			box { <0.85,4.53,-3.84> <1.95,4.55,-3.87> } // thin crosspiece
			texture { White_PVC } 
		}
		
		// nx bedroom Window Frame
		union {
			box { <-0.30,3.80,-3.7> <-0.32,4.80,-4> }
			box { <-2.48,3.80,-3.7> <-2.50,4.80,-4> }
			box { <-0.30,3.80,-3.7> <-2.50,3.82,-4.03> }  // window sill
			box { <-0.30,4.78,-3.7> <-2.50,4.80,-4> }
			box { <-1.39,3.80,-3.84> <-1.42,4.80,-3.87> } // thin vertical piece
			box { <-0.84,3.80,-3.84> <-0.86,4.80,-3.87> } // thin vertical piece
			box { <-1.94,3.80,-3.84> <-1.96,4.80,-3.87> } // thin vertical piece
			box { <-0.85,4.53,-3.84> <-1.95,4.55,-3.87> } // thin crosspiece
			texture { White_PVC } 
		}
		
		// px bathroom Window Frame
		union {
			box { <3.00,3.80,-3.7> <3.02,4.80,-4> }
			box { <4.68,3.80,-3.7> <4.70,4.80,-4> }
			box { <3.00,3.80,-3.7> <4.70,3.82,-4.03> }  // window sill
			box { <3.00,4.78,-3.7> <4.70,4.80,-4> }
			box { <3.52,3.80,-3.84> <3.54,4.80,-3.87> } // thin vertical piece
			box { <4.16,3.80,-3.84> <4.18,4.80,-3.87> } // thin vertical piece
			texture { White_PVC } 
		}
		
		// nx bathroom Window Frame
		union {
			box { <-3.00,3.80,-3.7> <-3.02,4.80,-4> }
			box { <-4.68,3.80,-3.7> <-4.70,4.80,-4> }
			box { <-3.00,3.80,-3.7> <-4.70,3.82,-4.03> }  // window sill
			box { <-3.00,4.78,-3.7> <-4.70,4.80,-4> }
			box { <-3.52,3.80,-3.84> <-3.54,4.80,-3.87> } // thin vertical piece
			box { <-4.16,3.80,-3.84> <-4.18,4.80,-3.87> } // thin vertical piece
			texture { White_PVC } 
		}
		
		// px kitchen Window Frame
		union {
			box { <3.90,1.20,-3.7> <3.92,2.00,-4> }
			box { <4.68,1.20,-3.7> <4.70,2.00,-4> }
			box { <3.90,1.20,-3.7> <4.70,1.22,-4.03> }  // window sill
			box { <3.90,1.98,-3.7> <4.70,2.00,-4> }
			box { <4.29,1.20,-3.84> <4.31,2.00,-3.87> } // thin vertical piece
			texture { White_PVC } 
		}
		
		// nx kitchen Window Frame
		union {
			box { <3.90,1.20,-3.7> <3.92,2.00,-4> }
			box { <4.68,1.20,-3.7> <4.70,2.00,-4> }
			box { <3.90,1.20,-3.7> <4.70,1.22,-4.03> }  // window sill
			box { <3.90,1.98,-3.7> <4.70,2.00,-4> }
			box { <4.29,1.20,-3.84> <4.31,2.00,-3.87> } // thin vertical piece 
			scale <-1,1,1>
			texture { White_PVC } 
		}
		
		// chimney
		box {
			<-0.2,5,-0.75> <0.2,8.75,0.75>
			texture { Brickwork }
		}
		
		// Chimney pots
		cone {
			<0,8.74,-0.19> 0.15
			<0,9.25,-0.19> 0.13
			texture { Terracotta }
		}
		cone {
			<0,8.74,0.19> 0.15
			<0,9.25,0.19> 0.13
			texture { Terracotta }
		}
		cone {
			<0,8.74,-0.57> 0.15
			<0,9.25,-0.57> 0.13
			texture { Terracotta }
		}
		cone {
			<0,8.74,0.57> 0.15
			<0,9.25,0.57> 0.13
			texture { Terracotta }
		}
		
		// roof divider
		box { 
			<-0.15,-3.0,-3.0> <0.15,3.0,3.0> rotate x*45 scale <1,0.8,1> translate 5.2*y
			pigment { rgb <0.5,0.6,0.5> } 
		}
        
        // roof co-ordinates
        #declare roof_apex_px = <1.84,8.35,0>;
        #declare roof_apex_nx = <-1.84,8.35,0>;
        
        #declare roof_corner_px_pz = <5.2,4.99,4.2>;
        #declare roof_corner_px_nz = <5.2,4.99,-4.2>;
        
        #declare roof_corner_nx_pz = <-5.2,4.99,4.2>;
        #declare roof_corner_nx_nz = <-5.2,4.99,-4.2>;
        
        // roof
		difference {
			intersection {
				box { 
					<-5.2,-3.0,-3.0> <5.2,3.0,3.0> rotate x*45 scale <1,0.8,1> translate 5*y
					texture {rooft translate n } 
				}
				box { 
					<-3.7,-3.7,-6.01> <3.7,3.7,6.01> rotate z*45 scale <1,1,1> translate 5*y 
					texture {rooft translate n  rotate y*90 } 
				}

			}
			plane { y,4.99 }
			texture {
				pigment { rgb <0.7,0.2,0.2> }
			}
		}

		// roof ridge tiles.
		sphere { roof_apex_px 0.08 texture { Terracotta } }
		sphere { roof_apex_nx 0.08 texture { Terracotta } }

		cylinder { roof_apex_px	roof_apex_nx 0.08 texture { Terracotta } }	
		
		cylinder { roof_apex_px	roof_corner_px_pz 0.08 texture { Terracotta } }	
		cylinder { roof_apex_px	roof_corner_px_nz 0.08 texture { Terracotta } }	
		cylinder { roof_apex_nx	roof_corner_nx_pz 0.08 texture { Terracotta } }	
		cylinder { roof_apex_nx	roof_corner_nx_nz 0.08 texture { Terracotta } }	
        
        // Guttering Parameters
        #local g_rad = 0.05;  // Pipe radius
        #local g_h_offset = 0.01; // distance between pipe and roof (horisontal)
        #local g_v_offset = -0.04; // distance between pipe and roof (vertical)
        
        // Guttering
        difference
        {
        	// The guttering as a closed pipe
        	union {
        		// pipe on the -x side
        		cylinder {
        			( roof_corner_nx_pz - (g_h_offset+g_rad)*x + g_v_offset*y )
        			( roof_corner_nx_nz - (g_h_offset+g_rad)*x + g_v_offset*y - (g_h_offset+2*g_rad)*z)
        			g_rad
        			open
        		}
        		// pipe on the +x side
        		cylinder {
        			( roof_corner_px_pz + (g_h_offset+g_rad)*x + g_v_offset*y )
        			( roof_corner_px_nz + (g_h_offset+g_rad)*x + g_v_offset*y - (g_h_offset+2*g_rad)*z)
        			g_rad
        			open
        		}
        		// pipe on the -z side
        		cylinder {
        			( roof_corner_nx_nz - (g_h_offset+2*g_rad)*x + g_v_offset*y - (g_h_offset+g_rad)*z)
        			( roof_corner_px_nz + (g_h_offset+2*g_rad)*x + g_v_offset*y - (g_h_offset+g_rad)*z)
        			g_rad
        			open
        		}
        	}
        	// Minus the top half (to open it up)
        	box {
        		(roof_corner_px_pz + (g_h_offset+3*g_rad)*<1,0,1> + g_v_offset*y   )
        		(roof_corner_nx_nz - (g_h_offset+3*g_rad)*<1,0,1> + (g_v_offset+2*g_rad)*y )
        	}
        	texture { White_PVC }
        }
        
        // Downpipe
        union {
        	difference {  
        		// roof_corner_nx_nz.y + g_v_offset
        		// roof_corner_nx_nz.z - (g_h_offset+g_rad)*z
        		cylinder { <0,roof_corner_nx_nz.y + g_v_offset,roof_corner_nx_nz.z - (g_h_offset+g_rad)> <0,roof_corner_nx_nz.y + g_v_offset-.3,roof_corner_nx_nz.z - (g_h_offset+g_rad)> g_rad}
        		sphere { <0,roof_corner_nx_nz.y + g_v_offset,roof_corner_nx_nz.z - (g_h_offset+g_rad)> g_rad}
        	}
        	sphere { <0,roof_corner_nx_nz.y + g_v_offset-.3,roof_corner_nx_nz.z - (g_h_offset+g_rad)> g_rad}
        	cylinder { <0,roof_corner_nx_nz.y + g_v_offset-.3,roof_corner_nx_nz.z - (g_h_offset+g_rad)> <0,roof_corner_nx_nz.y + g_v_offset-g_v_offset-.6,-(4+g_rad)> g_rad}
        	sphere { <0,roof_corner_nx_nz.y + g_v_offset-g_v_offset-.6,-(4+g_rad)> g_rad}
        	cylinder { <0,roof_corner_nx_nz.y + g_v_offset-g_v_offset-.6,-(4+g_rad)> <0,0,-(4+g_rad)> g_rad}
        	texture { White_PVC }
        }
        	        
		// colour any of the above that aren't coloured.
		pigment { White }
	}
#end

#if (!Included_File)

	#declare Grass1  =          
		material {
			texture {
				pigment { 
					granite
					colour_map
					{
						[ 0 rgb <0.1,0.3,0.05> ]
						[ 1 rgb <0.2,0.4,0.1> ]
					}
				}
				normal {
					bumps
					scale 0.1
					bump_size 0.05
				}
				finish {
					diffuse 0.7
					ambient 0.3
					specular 0
				}
			}
		}

	plane { y, 0 material {Grass1} }
	
	sky_sphere {
		pigment {
			gradient y
			pigment_map {
				[0.5 color rgb .7]
				[0.6 granite scale <1,0.25,1>
					colour_map {
						[ 0.1 rgb <.6,.6,.7> ]
						[ 0.9 rgb <.3,.4,.6> ]
					} 
				]
			}
	      scale 2
	      translate -1
		}
	}
	
	camera {
		location <-50,6,-20>
		sky y
		up 3*y
		right 4*z
		look_at 200*x-16*y
		angle 60
	}
	
	//
	// Lightting
	//
	#declare c = color rgb <.8, .85, 1>; 
	#declare s1 = color rgb <1, .8, .6>; 
	#declare n = 6;
	
	#if (Final)
	
		light_source {
		  <10000, 10000, -15000>
		  color s1*.6
		  area_light <1, 0, 2>, <-2, 2, 1>, 6, 6
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <0, 10000, 0>
		  color c
		  area_light x*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <-10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, 10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, -10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
	#else
		light_source {
		  <10000, 10000, -5000>
		  color rgb 1
		  area_light <100, 0, 200>, <-200, 200, 100>, 3, 3
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <-100, 100, 0>
		  color rgb .5
		  shadowless
		}
	#end
	
	light_source {
		<-60,30,-40> White
	}

	object { MakeSemi(n) rotate y*60 translate <-30,0,-18> }
	
#end