// Persistence of Vision Ray Tracer Scene Description File
// File: Bench.inc
// Vers: 3.5
// Desc: Makes a stone bench. Requires StoneWall.inc.
// Date: 12/13/2001
// Auth: Jeff M. Thomas
//
 
#macro Bench( BenchTexture )
  union
  {
    MakeStoneWall( <1.45,.07,.5>, <.05,.05,.05>, <0,0,0>, <1,1,1>, BenchTexture, StoneWallInterior, 0, .1, true, true )
    object{ StoneWall translate<0,.33,0>}
    MakeStoneWall( <.07,.25,.5>, <.05,.05,.05>, <0,0,0>, <1,1,1>, BenchTexture, StoneWallInterior, 0, .025, true, true )
    object{ StoneWall translate <-0.4625,.125,0>}
    object{ StoneWall rotate<0,180,0> translate <0.4625,.125,0>}
  }
#end

#declare BlankNormal=
  normal
  {
    agate
    slope_map
    {
      [0.0 <0,0>]
    }
    scale .4
  }
#declare BenchNormal=
  normal
  {
    agate
    slope_map
    {
      [0.0 <-.5,.1>]
      [0.3 <-.3,.2>]
      [0.8 <-.3,.2>]
      [1 <-.5,.1>]
    }
    scale .1
  }

#declare BenchTexture=
  texture
  {
    //pigment{ Gray }
    //T_Stone5
    StoneTexture
    normal
    {
      slope {
        <0.0,-1,0>//, 0, 0.5
        //altitude y, 1.000, 0.000
      }
      normal_map {
        [0.0 BlankNormal]
        [0.25 BlankNormal]
        [0.25 BenchNormal]
        [0.45 BenchNormal]
      }
    }
    finish { phong 0 }
  }
