/ Persistence of Vision Ray Tracer Scene Description File
// File: Candelabra.inc
// Vers: 3.5
// Desc: Makes a free standing Candelabra
// Date: 12/13/2001
// Auth: Jeff M. Thomas
//

#include "candles.inc"

#declare StandRand = seed(545);

#declare StandTexture=              
    texture
    { 
      pigment
      {   
        granite
        color_map 
        {
          [0.0 rgb <.0,.0,.0>]
          [0.3 rgb <.0,.0,.0>]
          [0.6 rgb <.1,.1,.1>]
          [0.6 rgb <.0,.0,.0>]
        }
      } 
      scale .3
      finish{ ambient 0.2 diffuse 0.6 } 
      normal { wrinkles 1 scale 0.5 }
    }
    //texture{ Rusty_Iron scale .5 }
    //texture{ T_Stone1 }
    //texture{ Brass_Valley }

#declare Arm=
  difference
  {
    difference
    {
      cylinder
      {
          <0,0,-.03> , <0,0,.03>, .4
          texture{ StandTexture }
      }
      cylinder
      {
          <0,0,-.031> , <0,0,.031>, .35
          texture{ StandTexture }
      }
      scale <1,.5,1>
    }                 
    box
    {
      <-.4,-.2,-.031>,<.4,0,.031>
      texture{ StandTexture }
    }
    box
    {
      <0,-.1,-.031>,<.5,.2,.031>
      texture{ StandTexture }
    }
  }

#declare CandleCup=
union
{
  difference
  {
    difference
    {
      sphere
      {
        <0,0,0> .05            
        texture{ T_Silver_1A }
      }
      sphere
      {
        <0,0,0> .045            
        texture{ T_Silver_1A }
      }
    }
    box
    {
      <-.1,-.02,-.1>,<.1,.1,.1>
      texture{ T_Silver_1A }
    }
  }
}

#macro MyCandleMod( Height, Drips, Flame )
      difference
      {
        union{
          O_CandleBody(Height, 0.1)
          object{O_Wick  translate y*(Height-.05)}
          #if (Flame)
            object{O_Flame translate y*(Height+.15)}
          #end
          CandleWax(Height, .1/*((rand(StandRand)/2)+.5)/10*/, Drips)
          scale .2
        }
        box{ <-.05,-.05,-.05>,<.05,.05,.05> translate <0,-.037,0> pigment{Gray} }
        translate<0,-.04,0>
        rotate< 0, rand(StandRand)*360, 0 >
      }
#end // MyCandleMod

#declare Foot=
    prism 
    {
      conic_sweep
      linear_spline
      0.251, // height 1
      1, // height 2
      5, // the number of points making up the shape...
      <4,4>,<0,4>,<0,0>,<4,0>,<4,4>
      translate<-2,0,-2>
      scale <1, 4, 1>
      scale .01
      texture{ StandTexture }
    }


#macro ACandleRack( Candle1, Candle2, Candle3, Candle4, Candle5, Flame1, Flame2, Flame3, Flame4, Flame5 )
union
{           
  // the rod
  cylinder
  {
      <0,-.94,0> , <0,.8,0>, .03
      texture{ StandTexture }
  }
  // the top
  union
  {
    object
    {
      Arm
      translate<.375,.8,0>
    }
    object
    {
      Arm
      rotate<0,180,0>
      translate<-.375,.8,0>
    }
    object
    {
      Arm
      rotate<180,180,0>
      translate<-.375,1.19,0>
    }
    object
    {
      Arm
      rotate<180,0,0>
      translate<.375,1.19,0>
    }                      
    // center circle
    difference
    {
      cylinder
      {
        <0,0,-.031> , <0,0,.031>, .10
        texture{ T_Copper_5A }
      }
      cylinder
      {
        <0,0,-.032> , <0,0,.032>, .08
        texture{ T_Copper_5A }
      }
      translate<0,.9960,0>
    }
    // candles
    union
    {
      MyCandleMod( Candle1, 1, Flame1 )
      CandleCup
      translate<0,1.24,0>      
    }
    union
    {
      MyCandleMod( Candle2, 1, Flame2 )
      CandleCup
      translate<-.34,1.07,0>      
    }
    union
    {
      MyCandleMod( Candle3, 1, Flame3 )
      CandleCup
      translate<0.34,1.07,0>      
    }
    union
    {
      MyCandleMod( Candle4, 1, Flame4 )
      CandleCup
      translate<0.16,1.11,0>//0.138
    }      
    union
    {
      MyCandleMod( Candle5, 1, Flame5 )
      CandleCup
      translate<-0.16,1.11,0>      
    }
  }
  // decorations on the rod
  sphere
  {
    <0,0,0> .06
    texture{ StandTexture }
    scale<1,.5,1>
    translate<0,.77,0>
  }
  sphere
  {
    <0,0,0> .05
    texture{ T_Copper_5A }
    scale<1,.75,1>
    translate<0,.385,0>
  }
  torus
  {
    .0325, .03
    texture{ StandTexture }
    scale<1,.35,1>
    translate<0,.385,0>
  }
  sphere
  {
    <0,0,0> .06
    texture{ T_Copper_5A }
    scale<1,.5,1>
  }
  sphere
  {
    <0,0,0> .05
    texture{ T_Copper_5A }
    scale<1,.75,1>
    translate<0,-.385,0>
  }
  torus
  {
    .025, .03
    texture{ StandTexture }
    scale<1,.35,1>
    translate<0,-.385,0>
  }
  // the base
  union
  {
    box
    {
      <-.2,-.01,-.2>,<.2,.01,.2>
      texture{ T_Copper_5A }
      translate<0,-.92,0>
    }
    box
    {
      <-.3,-.01,-.3>,<.3,.01,.3>
      texture{ StandTexture }
      translate<0,-.94,0>
    }
    // the feet
    object
    {
      Foot
      translate<-.28,-.99,-.28>
    }      
    object
    {
      Foot
      rotate <0, 90, 0>
      translate<-.28,-.99,.28>
    }      
    object
    {
      Foot
      rotate <0, -90, 0>
      translate<.28,-.99,-.28>
    }      
    object
    {
      Foot
      rotate <0, 180, 0>
      translate<.28,-.99,.28>
    }      
  }
  translate<0,-.02,0>
}
#end // ACandleRack
