// Persistence of Vision Ray Tracer Scene Description File
// File: Bauble.pov
// Vers: unofficial MegaPov 0.7
// Desc: This scene consist of five planetary objects contained in glass spheres
// Date: 14 Jan 2002
// Auth: Kenneth J. Schnardthorst


#version unofficial MegaPov 0.7;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "golds.inc"
global_settings { photons {count 20*10^23 jitter 0.4}}

camera {
        location <4,4,20>
        look_at <2,0,0>
}

light_source { <5,20,2> color White media_attenuation on photons {reflection on refraction on}}

//background { color rgb <0.094,0.092,0.195>}
plane {
	y,0
	texture {
	        pigment { color rgb <0.094,0.092,0.195>}
	        normal { bumps 0.44}
	}
	finish {
		ambient 0.5 diffuse 0.5
		phong 0.6 phong_size 25
	}
	translate < 0,-6,0>
}
plane {
	x,0
	texture {
	        pigment { color rgb <0.194,0.092,0.195>}
	        normal { bumps 0.44}
	}
	finish {
		ambient 0.5 diffuse 0.5
		phong 0.6 phong_size 500
	}
	translate < -20,0,0>
}
plane {
	z,0
	texture {
	        pigment { color rgb <0.194,0.092,0.195>}
	        normal { bumps 0.44}
	}
	finish {
		ambient 0.5 diffuse 0.5
		phong 0.6 phong_size 500
	}
	translate < 0,0,-20>
}

//First trinket//
union { union {
        difference {
                cylinder { <-.11,0,0> <.11,0,0> 2.5 texture{T20}}
                cylinder { <-.11,0,0> <.11,0,0> 2.4 open texture{T20}}
        }
        difference {
                cylinder { <0,0,-.11> <0,0,.11> 2.5 texture{T20}}
                cylinder { <0,0,-.11> <0,0,.11> 2.4 open texture{T20}}
        }
        difference {
                cylinder { <0,1.91,0> <0,1.81,0> 1.7 texture{T05}}
                cylinder { <0,1.91,0> <0,1.81,0> 1.6 open texture{T05}}
        }
        difference {
                cylinder { <0,-1.91,0> <0,-1.81,0> 1.7 texture{T05}}
                cylinder { <0,-1.91,0> <0,-1.81,0> 1.6 open texture{T05}}
        }
        sphere { <0,2.6,0> 0.2 texture {T02}}
        difference {
                cylinder { <-.04,2.8,0> <.04,2.8,0> .25 texture {T05}}
                cylinder { <-.04,2.8,0> <.04,2.8,0> .20 open texture {T05}}
                }
 
        torus { 1.8, 0.065
                pigment { color Yellow }
                scale <0.15,1.75,2.5>
                rotate <90,45,0>
                translate <0,7.40,0>
        }

        sphere { <0,0,0> 2.38 
                        texture{
                                pigment { colour rgbt<0.976,0.976,0.976,0.698> }
                                finish {
                                        diffuse 0.1  specular 0.8 
                                        roughness 0.01  reflection 0.01
                                        phong 1.0    phong_size 400
                                }
                        }
                        interior { ior 1.54}
                        hollow
        }
        }

        #declare Planet1 =
        texture {
                pigment {
                        leopard
                        color_map {
                                [0.0 rgbft <0.95, 0.79, 0.38, 0, 0>]
                                [0.38 rgbft <0.51, 0.72, 0.98, 0, 0>]
                                [0.96 rgbft <0.60, 0.69, 0.98, 0, 0>]
                                [1.0 rgbft <0.55, 0.67, 1.0, 0, 0>]
                        }
                }
                finish {ambient 0.2 diffuse 0.90}
                scale <0.2, 0.5, 0.2>
        }
        texture {
                pigment {
                        bozo
                        color_map {
                                [0.0 rgbt <1.0, 0.2, 0.2, 1.0>]
                                [0.8 rgbt <1.0, 1.0, 0.2, 0.45>]
                                [0.9 rgbt <1.0, 0.3, 1.0, 0.15>]
                                [1.0 rgbt <1.0, 1.0, 1.0, 0.1>]
                        }
                        turbulence 1.86
                }
                finish { ambient 0.3 diffuse 0.98}
                scale .4
        }

        #declare atmos1 = media {
                scattering {4 rgb <.7,.5,.5>*2}
                intervals 8
                samples 2,20
                confidence 0.9999
                variance 1/1000
                density {
                        spherical
                        color_map {
                                [0 rgbf <0,0,0,1>]
                                [.075 rgbf <.75,.75,.75,1>]
                                [.15 rgbf 1]
                                [.6 rgbf 1]
                                [.68 rgbf <0,0,0,1>]
                                [1 rgbf <0,0,0,1>]
                        }
                }
        }

        #declare atmos2= media {
                absorption rgb <.2,.2,.7>*2
                intervals 8
                samples 2,20
                confidence 0.9999
                variance 1/1000
                density {
                        spherical
                        color_map {
                                [0 rgbf <0,0,0,1>]
                                [.075 rgbf <.75,.75,.75,1>]
                                [.15 rgbf 1]
                                [.6 rgbf 1]
                                [.68 rgbf <0,0,0,1>]
                                [1 rgbf <0,0,0,1>]
                        }
                }
        }

        union{
                sphere {0, 1 texture {Planet1}}
                sphere {0, 1 hollow pigment {rgbt 1.0} interior {media {atmos1} media {atmos2}} scale 1.12}
        }
        translate <10,-.5,5>
}

//Second trinket//

union { union {
        difference {
                cylinder { <-.11,0,0> <.11,0,0> 2.5 texture{T20}}
                cylinder { <-.11,0,0> <.11,0,0> 2.4 open texture{T20}}
        }
        difference {
                cylinder { <0,0,-.11> <0,0,.11> 2.5 texture{T20}}
                cylinder { <0,0,-.11> <0,0,.11> 2.4 open texture{T20}}
        }
        difference {
                cylinder { <0,1.91,0> <0,1.81,0> 1.7 texture{T05}}
                cylinder { <0,1.91,0> <0,1.81,0> 1.6 open texture{T05}}
        }
        difference {
                cylinder { <0,-1.91,0> <0,-1.81,0> 1.7 texture{T05}}
                cylinder { <0,-1.91,0> <0,-1.81,0> 1.6 open texture{T05}}
        }
        sphere { <0,2.6,0> 0.2 texture {T02}}
        difference {
                cylinder { <-.04,2.8,0> <.04,2.8,0> .25 texture {T05}}
                cylinder { <-.04,2.8,0> <.04,2.8,0> .20 open texture {T05}}
        }
        sphere { <0,0,0> 2.38 
                texture{
                        pigment {
                                colour rgbt<0.976,0.976,0.976,0.698>
                        }
                        finish {
                                diffuse 0.1
                                specular 0.8    roughness 0.01
                                phong 1.0    phong_size 400
                                reflection 0.01
                        }
                }
                interior { ior 1.54}
                hollow
        }
        torus { 1.8, 0.065
                pigment {
                        color Red
                 }
                scale <0.15,1.75,2.5>
                rotate <90,0,0>
                translate <0,7.45,0>
        }
        scale <1.5,1.5,1.5>
        } 
#declare Planet1 =
texture {
        pigment {
                leopard
                color_map {
                        [0.0       rgbft <0.65969, 0.797203, 0.98611, 0.0, 0.0>]
                        [0.3879    rgbft <0.519608, 0.713725, 0.980392, 0.0, 0.0>]
                        [0.967972  rgbft <0.606863, 0.692157, 0.988235, 0.0, 0.0>]
                        [1.0       rgbft <0.5729, 0.656233, 1.0, 0.0, 0.0>]
                }
        }
        finish { ambient 0.0 diffuse 0.95 }
        scale <0.2, 0.4, 0.2>
}
texture {
        pigment {
                bozo
                color_map {
                        [0.0  rgbt <1.0, 1.0, 1.0, 1.0>]
                        [0.8  rgbt <1.0, 1.0, 1.0 ,0.45>]
                        [0.9  rgbt <1.0, 1.0, 1.0, 0.15>]
                        [1.0  rgbt <1.0, 1.0, 1.0, 0.1>]
                }
                turbulence 1.75
        }
        finish { ambient 0.0 diffuse 0.95 }
        scale .4
}

sphere {0, 1 texture {Planet1}}

#declare atmos = media {
        scattering {4, rgb <.4,.5,1>*5 extinction 0.005}
        absorption rgb <.6,.5,0>*5
        intervals 5
        samples 2, 20
        confidence 0.9999
        variance 1/1000
        density {
                spherical
                color_map {
                        [0,   rgbf <0,0,0,1>]
                        [.055, rgbf <.75,.75,.75,.01>]
                        [.075, rgbf <.2,.5,1,.01>]
                        [.6,   rgbf <.2,.5,1,1>]
                        [.61,  rgbf <0,0,0,1>]
                        [1,    rgbf <0,0,0,1>]
                }
        }
}

union {
        sphere {0, 1 texture {Planet1}}
        sphere {0, 1 hollow pigment {rgbt 1.0} interior {media {atmos}} scale 1.04}
}

#declare PMoonMare = pigment {
                wrinkles
                turbulence 0.2
                scale 0.5
                color_map { [0 rgb 1] [1 rgb 0] }
}
                
#declare PMoonCraters = pigment {
                granite
                scale 0.2
                color_map { [0 rgb 1] [1 rgb 0]}
}

#declare TMoon = texture {
        pigment {
                average
                pigment_map {
                        [0.85 PMoonMare]
                        [0.15 PMoonCraters]
                }
        }
}

#declare FCraters = function {pigment {PMoonCraters}}
#declare FMare = function {pigment {PMoonMare}}
       
#declare Sphere = function {"Sphere",<1>}
isosurface {
                function {Sphere (x,y,z)+(1-FCraters(x,y,z))*0.005+(1-FMare(x,y,z))*0.02}
                eval
                accuracy 0.001
                contained_by {sphere{0, 1}}
                texture {TMoon}
                scale .18
                translate <1.2,0,1.9>
}

#declare PMoonMare = pigment {
                wrinkles
                turbulence 0.2
                scale 0.5
                color_map { [0 rgb <.6,.2,.1>] [1 rgb <.2,.5,.3>] }
}
                
#declare PMoonCraters = pigment {
                granite
                scale 0.2
                color_map { [0 rgb 1] [1 rgb 0]}
}

#declare TMoon = texture {
        pigment {
                average
                pigment_map {
                        [0.85 PMoonMare]
                        [0.15 PMoonCraters]
                }
        }
}

#declare FCraters = function {pigment {PMoonCraters}}
#declare FMare = function {pigment {PMoonMare}}
       
#declare Sphere = function {"Sphere",<1>}
isosurface {
                function {Sphere (x,y,z)+(1-FCraters(x,y,z))*0.005+(1-FMare(x,y,z))*0.02}
                eval
                accuracy 0.001
                contained_by {sphere{0, 1}}
                texture {TMoon}
                scale .08
                translate <.8,.2,1.6>
}
translate <0,1,0>
}

//Third trinket//

union { union{
                difference {
                        cylinder { <0,0,-.1><0,0,0> 1.78 texture {T02}}
                        cylinder { <0,0,-.1><0,0,0> 1.75 open texture {T05}}
                        rotate <45,0,0>
                        translate <0,2.5,-2.5>
                }
                difference {
                        cylinder { <0,0,.1><0,0,0> 1.78 texture {T02}}
                        cylinder { <0,0,.1><0,0,0> 1.75 open texture {T05}}
                        rotate <-45,0,0>
                        translate <0,2.5,2.5>
                }
                difference {
                        cylinder { <-.1,0,0><0,0,0> 1.78 texture {T02}}
                        cylinder { <-.1,0,><0,0,0> 1.75 open texture {T05}}
                        rotate <0,0,-45>
                        translate <-2.5,2.5,0>
                }
                difference {
                        cylinder { <.1,0,0><0,0,0> 1.78 texture {T02}}
                        cylinder { <.1,0,0><0,0,0> 1.75 open texture {T05}}
                        rotate <0,0,45>
                        translate <2.5,2.5,0>
                }
                difference {
                        cylinder { <0,.1,0><0,0,0> 1 texture {T02}}
                        cylinder { <0,.1,0><0,0,0> .7 open texture {T05}}
                        rotate <0,0,0>
                        translate <0,3.8,0>
                }
                difference {
                        cylinder { <-.1,0,0><.1,0,0> 4 texture {T02}}
                        cylinder { <-.1,0,0><.1,0,0> 3.97 open texture {T05}}
                        rotate <0,0,0>
                        translate <0,0,0>
                }
                difference {
                        cylinder { <0,0,-.1><0,0,.1> 4 texture {T02}}
                        cylinder { <0,0,-.1><0,0,.1> 3.97 open texture {T05}}
                rotate <0,0,0>
                translate <0,0,0>
                }
                sphere { <0,4.2,0> .25
                        texture {T01}
                }
                difference {
                cylinder { <0,0,-.05><0,0,.05> .5 texture {T02}}
                cylinder { <0,0,-.05><0,0,.05> .47 open texture {T05}}
                translate <0,4.65,0>
                }
                sphere { <0,0,0> 3.95 
                        texture{
                                pigment {
                                        colour rgbt<0.976,0.976,0.976,0.698>
                                }
                                finish {
                                        diffuse 0.1
                                        specular 0.8  roughness 0.01
                                        phong 1.0  phong_size 400
                                        reflection 0.01
                                }
                        }
                        interior { ior 1.54}
                        hollow
                }
                torus { 1.8, 0.065
                        pigment {
                                color Red
                        }
                        scale <0.15,1.5,2.5>
                        rotate <90,90,0>
                        translate <0,9.45,0>
                }
                }
#declare Ring =
                texture {
                        pigment { 
                                onion 
                                color_map {
                                        [0.00 color rgb<0.1,0.6,0.9>]
                                        [0.28 color rgb<1.0,1.0,1.0>]
                                        [0.32 color rgb<0.9,0.2,0.5>]
                                        [0.40 color rgb<0.1,0.8,0.8>]
                                        [0.60 color rgb<0.2,0.2,0.8>]
                                        [1.00 color rgb<0.5,0.2,0.8>]
                                }
                        }
                        finish {ambient 0.0 diffuse 0.65}
                        scale <0.2,0.4,0.2>
                }
                difference {
                        cylinder {<0,0.001,0> <0,-0.001,0> 2.1 texture {Ring}}
                        cylinder {<0,0.001,0> <0,-0.001,0> 1.4 open texture {Ring}}
                        rotate <34,0,5>
                }

//Planet//
#declare Planet1 =
                texture {
                        pigment{
                                leopard
                                color_map {
                                        [0.0   rgbft <0.8696, 0.5972, 0.8961, 0.0, 0.0>]
                                        [0.39  rgbft <0.9569, 0.3372, 0.1803, 0.0, 0.0>]
                                        [0.96  rgbft <0.6068, 0.6921, 0.3289, 0.0, 0.0>]
                                        [1.0   rgbft <0.5729, 0.6233, 1.0, 0.0, 0.0>]
                                }
                        }
                        finish {ambient 0.0 diffuse 0.95}
                        scale <0.2,0.4,0.2>
                }
                texture {
                        pigment {
                                bozo
                                color_map {
                                        [0.0 rgbt <1,1,1,1>]
                                        [0.8 rgbt <.91,.651,.21,.65>]
                                        [0.9 rgbt <.71,.71,1,.25>]
                                        [1.0 rgbt <.41,.5,.31,.31>]
                                }
                                turbulence 1.45
                                octaves 4.0
                                lambda 8
                                omega 0.8
                        }
                        finish {ambient 0.0 diffuse 0.95}
                        scale .4
                }
                //sphere {0, 1 texture {Planet1}}

#declare atmos1 = media {
                        scattering {4, rgb<.4,.5,1>*2}
                        intervals 5
                        samples 2,20
                        confidence 0.9999
                        variance 1/1000
                        density {
                                spherical
                                color_map {
                                        [0,   rgbf <0,0,0,1>]
                                        [.055, rgbf <.75,.75,.75,.01>]
                                        [.075, rgbf <.2,.5,1,.01>]
                                        [.6,   rgbf <.2,.5,1,1>]
                                        [.61,  rgbf <0,0,0,1>]
                                        [1,    rgbf <0,0,0,1>]
                                }
                        }
                }
#declare atmos2 = media {
                        absorption rgb<.6,.5,0>*2
                        intervals 5
                        samples 2,20
                        confidence 0.9999
                        variance 1/1000
                        density {
                                spherical
                                color_map {
                                        [0,   rgbf <0,0,0,1>]
                                        [.055, rgbf <.75,.75,.75,.01>]
                                        [.075, rgbf <.2,.5,1,.01>]
                                        [.6,   rgbf <.2,.5,1,1>]
                                        [.61,  rgbf <0,0,0,1>]
                                        [1,    rgbf <0,0,0,1>]
                                }
                        }
                }

union {
        sphere {0, 1 texture{Planet1}}
        sphere {0, 1 hollow pigment {rgbt 1.0} interior {media {atmos1} media {atmos2}} scale 1.08
        }
}
translate <-4,-.5,5>
}

//Fourth trinket//

union { union {
        difference {
                cylinder { <-.11,0,0> <.11,0,0> 2.5 texture{T20}}
                cylinder { <-.11,0,0> <.11,0,0> 2.4 open texture{T20}}
        }
        difference {
                cylinder { <0,0,-.11> <0,0,.11> 2.5 texture{T20}}
                cylinder { <0,0,-.11> <0,0,.11> 2.4 open texture{T20}}
        }
        difference {
                cylinder { <0,1.91,0> <0,1.81,0> 1.7 texture{T05}}
                cylinder { <0,1.91,0> <0,1.81,0> 1.6 open texture{T05}}
        }
        difference {
                cylinder { <0,-1.91,0> <0,-1.81,0> 1.7 texture{T05}}
                cylinder { <0,-1.91,0> <0,-1.81,0> 1.6 open texture{T05}}
        }
        sphere { <0,2.6,0> 0.2 texture {T02}}
        difference {
                cylinder { <-.04,2.8,0> <.04,2.8,0> .25 texture {T05}}
                cylinder { <-.04,2.8,0> <.04,2.8,0> .20 open texture {T05}}
                }
 
        torus { 1.8, 0.065
                pigment { color Green }
                scale <0.15,1.5,2.5>
                rotate <90,45,0>
                translate <0,7.40,0>
        }

        sphere { <0,0,0> 2.38 
                        texture{
                                pigment {
                                        colour rgbt<0.976,0.976,0.976,0.698>
                                }
                                finish {
                                        diffuse 0.1
                                        specular 0.8    roughness 0.01
                                        phong 1.0    phong_size 400
                                        reflection 0.01
                                }
                        }
                        interior { ior 1.54}
                        hollow
        }
        }
#declare PMoonMare = pigment {
                wrinkles
                turbulence 0.2
                scale 0.5
                color_map { [0 rgb 1] [1 rgb 0] }
}
                
#declare PMoonCraters = pigment {
                granite
                scale 0.2
                color_map { [0 rgb 1] [1 rgb 0]}
}

#declare TMoon = texture {
        pigment {
                average
                pigment_map {
                        [0.85 PMoonMare]
                        [0.15 PMoonCraters]
                }
        }
        normal{
               average
               normal_map {
                          [0.85 wrinkles 0.3 turbulence 0.8]
                          [0.15 granite 0.5 scale 0.6]
                        }
                        scale 1/2
                }
                finish {ambient 0.001 diffuse 0.9}
        }

sphere { 0, 1 texture {TMoon} }
translate <4,1.5,-5>
}

//Fifth trinket//

union { union{
                difference {
                        cylinder { <0,0,-.1><0,0,0> 1.78 texture {T02}}
                        cylinder { <0,0,-.1><0,0,0> 1.75 open texture {T05}}
                        rotate <45,0,0>
                        translate <0,2.5,-2.5>
                }
                difference {
                        cylinder { <0,0,.1><0,0,0> 1.78 texture {T02}}
                        cylinder { <0,0,.1><0,0,0> 1.75 open texture {T05}}
                        rotate <-45,0,0>
                        translate <0,2.5,2.5>
                }
                difference {
                        cylinder { <-.1,0,0><0,0,0> 1.78 texture {T02}}
                        cylinder { <-.1,0,><0,0,0> 1.75 open texture {T05}}
                        rotate <0,0,-45>
                        translate <-2.5,2.5,0>
                }
                difference {
                        cylinder { <.1,0,0><0,0,0> 1.78 texture {T02}}
                        cylinder { <.1,0,0><0,0,0> 1.75 open texture {T05}}
                        rotate <0,0,45>
                        translate <2.5,2.5,0>
                }
                difference {
                        cylinder { <0,.1,0><0,0,0> 1 texture {T02}}
                        cylinder { <0,.1,0><0,0,0> .7 open texture {T05}}
                        rotate <0,0,0>
                        translate <0,3.8,0>
                }
                difference {
                        cylinder { <-.1,0,0><.1,0,0> 4 texture {T02}}
                        cylinder { <-.1,0,0><.1,0,0> 3.97 open texture {T05}}
                        rotate <0,0,0>
                        translate <0,0,0>
                }
                difference {
                        cylinder { <0,0,-.1><0,0,.1> 4 texture {T02}}
                        cylinder { <0,0,-.1><0,0,.1> 3.97 open texture {T05}}
                rotate <0,0,0>
                translate <0,0,0>
                }
                sphere { <0,4.2,0> .25
                        texture {T01}
                }
                difference {
                cylinder { <0,0,-.05><0,0,.05> .5 texture {T02}}
                cylinder { <0,0,-.05><0,0,.05> .47 open texture {T05}}
                translate <0,4.65,0>
                }
                sphere { <0,0,0> 3.95 
                        texture{
                                pigment {
                                        colour rgbt<0.976,0.976,0.976,0.698>
                                }
                                finish {
                                        diffuse 0.1
                                        specular 0.8  roughness 0.01
                                        phong 1.0  phong_size 400
                                        reflection 0.01
                                }
                        }
                        interior { ior 1.54}
                        hollow
                }
                torus { 1.8, 0.065
                        pigment {
                                color Red
                        }
                        scale <0.15,1.5,2.5>
                        rotate <90,90,0>
                        translate <0,9.45,0>
                }
                }
#declare Planet1 =
        texture {
                pigment {
                        leopard
                        color_map {
                                [0.0 rgbft <0.95, 0.39, 0.18, 0, 0>]
                                [0.38 rgbft <0.51, 0.72, 0.98, 0, 0>]
                                [0.96 rgbft <0.90, 0.29, 0.18, 0, 0>]
                                [1.0 rgbft <0.45, 0.67, 1.0, 0, 0>]
                        }
                }
                finish {ambient 0.2 diffuse 0.90}
                scale <0.2, 0.5, 0.2>
        }
        texture {
                pigment {
                        bozo
                        color_map {
                                [0.0 rgbt <1.0, 0.2, 0.2, 1.0>]
                                [0.8 rgbt <1.0, 1.0, 0.2, 0.45>]
                                [0.9 rgbt <1.0, 0.3, 1.0, 0.15>]
                                [1.0 rgbt <1.0, 1.0, 1.0, 0.1>]
                        }
                        turbulence 1.86
                }
                finish { ambient 0.3 diffuse 0.98}
                scale .4
        }

        #declare atmos1 = media {
                scattering {4 rgb <.7,.5,.5>*2}
                intervals 8
                samples 2,20
                confidence 0.9999
                variance 1/1000
                density {
                        spherical
                        color_map {
                                [0 rgbf <0,0,0,1>]
                                [.075 rgbf <.75,.75,.75,1>]
                                [.15 rgbf 1]
                                [.6 rgbf 1]
                                [.68 rgbf <0,0,0,1>]
                                [1 rgbf <0,0,0,1>]
                        }
                }
        }

        #declare atmos2= media {
                absorption rgb <.2,.2,.7>*2
                intervals 8
                samples 2,20
                confidence 0.9999
                variance 1/1000
                density {
                        spherical
                        color_map {
                                [0 rgbf <0,0,0,1>]
                                [.075 rgbf <.75,.75,.75,1>]
                                [.15 rgbf 1]
                                [.6 rgbf 1]
                                [.68 rgbf <0,0,0,1>]
                                [1 rgbf <0,0,0,1>]
                        }
                }
        }

        union{
                sphere {0, 1 texture {Planet1}}
                sphere {0, 1 hollow pigment {rgbt 1.0} interior {media {atmos1} media {atmos2}} scale 1.12}
                scale 2
        }
        #declare PMoonMare = pigment {
                wrinkles
                turbulence 0.2
                scale 0.5
                color_map { [0 rgb 1] [1 rgb 0] }
}
                
#declare PMoonCraters = pigment {
                granite
                scale 0.2
                color_map { [0 rgb 1] [1 rgb 0]}
}

#declare TMoon = texture {
        pigment {
                average
                pigment_map {
                        [0.85 PMoonMare]
                        [0.15 PMoonCraters]
                }
        }
}

#declare FCraters = function {pigment {PMoonCraters}}
#declare FMare = function {pigment {PMoonMare}}
       
#declare Sphere = function {"Sphere",<1>}
isosurface {
                function {Sphere (x,y,z)+(1-FCraters(x,y,z))*0.005+(1-FMare(x,y,z))*0.02}
                eval
                accuracy 0.001
                contained_by {sphere{0, 1}}
                texture {TMoon}
                scale .25
                translate <2.2,.50,1.0>
}
#declare PMoonMare = pigment {
                wrinkles
                turbulence 0.2
                scale 0.5
                color_map { [0 rgb 1] [1 rgb 0] }
}
                
#declare PMoonCraters = pigment {
                granite
                scale 0.2
                color_map { [0 rgb 1] [1 rgb 0]}
}

#declare TMoon = texture {
        pigment {
                average
                pigment_map {
                        [0.85 PMoonMare]
                        [0.15 PMoonCraters]
                }
        }
}

#declare FCraters = function {pigment {PMoonCraters}}
#declare FMare = function {pigment {PMoonMare}}
       
#declare Sphere = function {"Sphere",<1>}
isosurface {
                function {Sphere (x,y,z)+(1-FCraters(x,y,z))*0.005+(1-FMare(x,y,z))*0.02}
                eval
                accuracy 0.001
                contained_by {sphere{0, 1}}
                texture {TMoon}
                scale .31
                translate <2.2,-2,-1.9>
}
#declare PMoonMare = pigment {
                wrinkles
                turbulence 0.2
                scale 0.5
                color_map { [0 rgb 1] [1 rgb 0] }
}
                
#declare PMoonCraters = pigment {
                granite
                scale 0.2
                color_map { [0 rgb 1] [1 rgb 0]}
}

#declare TMoon = texture {
        pigment {
                average
                pigment_map {
                        [0.85 PMoonMare]
                        [0.15 PMoonCraters]
                }
        }
}

#declare FCraters = function {pigment {PMoonCraters}}
#declare FMare = function {pigment {PMoonMare}}
       
#declare Sphere = function {"Sphere",<1>}
isosurface {
                function {Sphere (x,y,z)+(1-FCraters(x,y,z))*0.005+(1-FMare(x,y,z))*0.02}
                eval
                accuracy 0.001
                contained_by {sphere{0, 1}}
                texture {TMoon}
                scale .18
                translate <1.8,0,1.9>
}

        translate <8.5,-.5,-10>
        }
        
//Rods//

cylinder { <16,13,-20> <-16,13,20> 0.2 texture {T15}}
cylinder { <-20,16.95,-10> <20,16.95,10> 0.2 texture {T15}}