#version unofficial megapov .7;
#debug "\nby   ____"
#debug "\n    /    |"
#debug "\n   "
#debug "/  /  |"
#debug "\n  /     / _"
#debug "__ ____ ____"
#debug "\n /  /  \\ / "
#debug " // __// . /"
#debug "\n/__//__//__"
#debug "//___//___/"

#declare blizzard = on;
#declare area_lights = on;
#declare radios = on;
#declare nerds = on;
#declare log_cabin = on;
#declare storm_cloud = on;
#declare ice_cream = on;
#declare cup = on;
#declare wall_and_countertop = on;
#declare props = on;
#declare crumbs = on;



camera{
	location <2.5,9,-5>
	look_at <0,4,0>
}
#macro gauss(RAndom_Seed)
	sqrt(-2*log(rand(RAndom_Seed)))*cos(2*pi*rand(RAndom_Seed))
#end





#if (radios)
	global_settings{radiosity{}}
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "radiosity"

#if (cup=0)
	#debug "\n  skipping "
#else
	#debug "\n"
#end
#debug "cup"
#if (cup)
	union{
		difference{
			union{
				cone{<0,0,0>,1.75,<0,6,0>,2}
				torus{2,.05 translate <0,6,0>}
				pigment {
					image_map {
						tga "blizzardcup2.tga"
						map_type 2	//cylindrical
						interpolate 2	//bilinear
					}
					scale <1,6,1>
					translate <0,1/15,0>
					rotate <0,-135,0>
				}
			}
			union{
				cone{<0,.1,0>,1.7,<0,6.01,0>,1.95}
				box{<-3,-3,0>,<3,10,-3>}
				pigment {
					image_map {
						tga "inside_cup.tga"
						map_type 2	//cylindrical
						interpolate 2	//bilinear
					}
					scale <1,6,1>
					translate <0,1/15,0>
					rotate <0,-135,0>
				}
			}
		}
		difference{
			union{
				cone{<.0025,0,0>,1.8,<.0025,6,0>,2.0025}
				torus{2.0025,.05 translate <.005,6,0>}
				pigment {
					image_map {
						tga "blizzardcup2.tga"
						map_type 2	//cylindrical
						interpolate 2	//bilinear
					}
					scale <1,6,1>
					translate <0,1/15,0>
					rotate <0,-135,0>
				}
			}
			union{
				cone{<.0025,.1,0>,1.75,<.0025,6.01,0>,1.9975}
				box{<-3,-3,0>,<3,10,3>}
				pigment {
					image_map {
						tga "inside_cup.tga"
						map_type 2	//cylindrical
						interpolate 2	//bilinear
					}
					scale <1,6,1>
					translate <0,1/15,0>
					rotate <0,-135,0>
				}
			}
		}
	}
#end


#if (ice_cream)
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "ice cream"
#if (ice_cream)
#debug "\n      snow_tex"
	#declare snow = 
		function{
			pigment {
				image_map{
					tga "snow3.tga"
					map_type 0
					once
					interpolate 2
				}
				rotate <90,0,0>
				translate <-.5,0,-.5>
				scale 2
			}
		}
	#declare bumpy = 
		function{
			pigment{
				bumps
				scale .01
			}
		}
	#debug "\n      ice cream"
	isosurface{
		function{y - .5 * snow(x,y,z) /*- .25 * snow(x+.02,y+.02,z+.02)*/ - .01*bumpy(x,y,z)}
		threshold 0
		accuracy .03
		contained_by{sphere{0,1}}
		max_gradient 4
		scale 1.96 translate <0,5.1,0>
		hollow
		material {
			texture{
				pigment {
					rgbt <.9,.95,.98,1> * <1,1,1,.85>
				}
				/*normal {
					crackle 
					scale .05
				}*/
				finish {
					ambient rgb <0.2, 0.2, 0.2>
					diffuse 0.6
					specular .3
					roughness 0.05
				}
			}
			interior{
				media{
					#declare Diffuse = 1.8;
						scattering{1, rgb <.55,.6,1>*10*Diffuse extinction 2/Diffuse}
						intervals 1
						samples 40
						method 3
				}
			}
		}
	}
#end

#if (log_cabin)
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "log cabin"
#if (log_cabin)
	
	#include "cabin.pov"
	object{cabin
		scale .55
		rotate <0,15,0>
		translate <.2,5.9,-.2>
	}
	light_source{
		<0,6.5,0>
		rgb <1,.5,0>
		area_light x*.1,y*.1 2,2 orient adaptive 1 jitter
		fade_power 3
		fade_distance 1
	}
#end

#if (storm_cloud)
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "storm_cloud"
#if (storm_cloud)
	#include "cloud.inc"
	object{cloud scale <.9,.6,.9>*.85 translate <.02,8.4,0>}
	//plane{-z,0 translate<0,0,13.2> pigment{checker rgb 1,rgb .8 scale 2.5}}
	
	global_settings {
		max_trace_level 128
	}
#end



#debug "\n scene.pov"

#include "scene.pov"





#if (blizzard)
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "blizzard"
#if (blizzard)
	
	#declare snow_pig = 
		pigment{
			bumps
			scale <.1,1,30>
			rotate <0,-30,0>
		}
	
	#declare success = 0;
	#declare fail = 0;
	#declare rs = seed(190245);
	#declare C = 0;
	#while (C<45000)
		#declare succ = 0;
		#declare pos = <.4*gauss(rs),rand(rs)*3.5 + 5,.5*gauss(rs)>;
		#declare test = eval_pigment(snow_pig,pos);
		//#debug concat("\ntester = ",str(vlength(test),0,4))
		#if (vlength(<pos.x,0,pos.z>) < 1.4 + .3*rand(rs) & (pos.y) < 7 + rand(rs)*1.5)
			#if (vlength(test) > .6+.65*rand(rs))
				#declare pos = <pos.x + pow(abs(8.5-pos.y-1.5),2)*.6-.3,pos.y,pos.z>;
				#if (sqrt((pos.x)*(pos.x) + (pos.z)*(pos.z)) > 1.8 & pos.y < 6)
				#else
					#if (pos.x < 1.5 + rand(rs)*.5)
						sphere{pos,.006 pigment{rgbt <1,1,1,0>} finish{ambient 1} no_shadow}
						#if (mod(C,500) = 0)
							#debug concat("\nsnowflake #",str(C,0,0),"\n",str(C/45000*100,0,1),"% done")
						#end
						#declare C = C+1;
						#declare success = success+1;
						#declare succ = 1;
					#end
				#end
			#end
		#end
		#if (succ = 0)
			#declare fail = fail+1;
		#end
	#end
	#debug concat("\n fail % = ",str(fail/(success+fail)*100,0,1),"%")
#end

/*
camera{
	location <0,30,0>
	orthographic
	up z*40
	right x*40*4/3
	look_at <0,0,0>
}*/


sphere{<0,0,0>,100
	hollow
	pigment {
		image_map {
			tga "room.tga"
			map_type 1	//spherical
			interpolate 2	//bilinear
		}
	}
	finish{
		//ambient 1
		diffuse .8
	}
	translate <0,8,0>
}



camera {
	perspective 
	location <2.2, 8.25, -4.4>
	up x*4*.4 right -y*3*.4
	look_at <0.0, 5.9, 0.0>
}

light_source{
	50*vnormalize(<0,5,-5>)
	rgb <1,.99,.96>
	#if (area_lights)
		#debug "\n"
	#else
		#debug "\n  skipping "
	#end
	#debug "area_lights"
	#if (area_lights)
		area_light <20,0,0>,<0,5,0>,7,3 jitter adaptive 1
	#end
}