#version unofficial megapov .7;
/*

light_source{<25,25,-25> rgb 1}
camera{
	location <2,2,-5>
	look_at <0,.5,0>
}*/
#macro gauss(RAndom_Seed)
	sqrt(-2*log(rand(RAndom_Seed)))*cos(2*pi*rand(RAndom_Seed))
#end


#declare rs = seed(10294);
#macro rv(rvs)
	(<gauss(rs),gauss(rs),gauss(rs)>*rvs)
#end

#declare woodtex = 
	material {
		texture{
			pigment {
				bozo
				color_map {
					[ 0.0 rgb <0.529992, 0.380529, 0.280903>*1.2 ]
					[ .75 rgb <0.529992, 0.421164, 0.296803>*.8 ]
					[ 1.0 rgb <0.659998, 0.594003, 0.594003>*1.5 ]
				}
				scale <.1, .01, .01>
			}
		}
	}


#declare dimx = 1.5;
#declare dimz = 1.5;
#macro rvc()
	rv(.01)
#end

#declare cabin = 
union{
	difference{
		union{
			#macro cabin_log(pA,pB,rad1,rad2,el)
				#declare vL = vnormalize(pA-pB);
				cone{pA,rad2,pA-el*vL,rad1}
				cone{pB,rad2,pB+el*vL,rad1}
				cylinder{pA-el*vL,pB+el*vL,rad1}
			#end
			#declare C = 0;
			union{
				#while (C<.8)
					cabin_log(<-(dimx/2+.1),C,-dimz/2>+rvc(),<(dimx/2+.1),C,-dimz/2>+rvc(),.05,.04,.1)
					cabin_log(<-(dimx/2+.1),C,dimz/2>+rvc(),<(dimx/2+.1),C,dimz/2>+rvc(),.05,.04,.1)
					#declare C = C+.1;
				#end
				material{woodtex}
			}
			#declare C = 0;
			union{
				#while (C<.8)
					cabin_log(<-dimx/2,C-.05,-(dimz/2+.1)>+rvc(),<-dimx/2,C-.05,(dimz/2+.1)>+rvc(),.05,.04,.1)
					cabin_log(<dimx/2,C-.05,-(dimz/2+.1)>+rvc(),<dimx/2,C-.05,(dimz/2+.1)>+rvc(),.05,.04,.1)
					#declare C = C+.1;
				#end
				material{woodtex rotate <0,90,0>}
			}
			#declare D = dimz;
			#declare C = .9;
			union{
				#while (D>=0)
					cabin_log(<-dimx/2,C-.05,-(D/2+.1)>+rvc(),<-dimx/2,C-.05,(D/2+.1)>+rvc(),.05,.04,.1)
					cabin_log(<dimx/2,C-.05,-(D/2+.1)>+rvc(),<dimx/2,C-.05,(D/2+.1)>+rvc(),.05,.04,.1)
					#declare D = D-.28;
					#declare C = C+.1;
				#end
				material{woodtex rotate <0,90,0>}
			}
		}
		box{<-.15,.35,-3>,<.15,.65,3> material{woodtex}}
		box{<0,-1,-.2>,<2,.6,.2> material{woodtex rotate <0,90,0>}}
	}
	
	
	
	
	union{
		#declare C = dimx/2+.1;
		#while (C>-dimx/2-.1)
			cylinder{
				<C,1.5,0>+rv(<.05,.02,.02>),
				<C,.82,-dimz/2-.25>+rv(<.05,.02,.02>),
				.005
				pigment {
					rgb <0.659998, 0.576379, 0.396002> + rv(<.02,.02,.02>)
				}
	
			}
			#declare C = C-.005;
		#end
	}
	union{
		#declare C = dimx/2+.1;
		#while (C>-dimx/2-.1)
			cylinder{
				<C,1.5,0>+rv(<.05,.02,.02>),
				<C,.82,dimz/2+.25>+rv(<.05,.02,.02>),
				.005
				pigment {
					rgb <0.659998, 0.576379, 0.396002> + rv(<.02,.02,.02>)
				}
	
			}
			#declare C = C-.005;
		#end
	}
	#declare vS = <0,1.5,0>-<0,.82,-dimz/2-.25>;
	cylinder{<dimx/2+.1,1.55,0> - vS*.25,<-dimx/2-.1,1.55,0> - vS*.25,.007 pigment{rgb .5}}
	cylinder{<dimx/2+.1,1.55,0> - vS*.5 ,<-dimx/2-.1,1.55,0> - vS*.5 ,.007 pigment{rgb .5}}
	cylinder{<dimx/2+.1,1.55,0> - vS*.75,<-dimx/2-.1,1.55,0> - vS*.75,.007 pigment{rgb .5}}
	
	#declare vS = <0,1.5,0>-<0,.82,dimz/2+.25>;
	cylinder{<dimx/2+.1,1.55,0> - vS*.25,<-dimx/2-.1,1.55,0> - vS*.25,.007 pigment{rgb .5}}
	cylinder{<dimx/2+.1,1.55,0> - vS*.5 ,<-dimx/2-.1,1.55,0> - vS*.5,.007 pigment{rgb .5}}
	cylinder{<dimx/2+.1,1.55,0> - vS*.75,<-dimx/2-.1,1.55,0> - vS*.75,.007 pigment{rgb .5}}
	
	#declare s1 = seed(13085);
	#debug "\n rooftop snow"
	blob{
		#declare C = dimx/2+.1;
		#while (C>-dimx/2-.1)
			#declare C1 = 0;
			#while (C1<5)
				sphere{0,.2,1 scale <1,.4,1>
					translate <C,1.5,0> + (-<C,1.5,0>+<C,.82,-dimz/2-.25>)*rand(s1)
				}
				#declare C1 = C1+1;
			#end
			#declare C = C-.005;
		#end
		#declare C = dimx/2+.1;
		#while (C>-dimx/2-.1)
			#declare C1 = 0;
			#while (C1<5)
				sphere{0,.2,1 scale <1,.4,1>
					translate <C,1.5,0> + (-<C,1.5,0>+<C,.82,dimz/2+.25>)*rand(s1)
				}
				#declare C1 = C1+1;
			#end
			#declare C = C-.005;
		#end
		sphere{<0,1.3,-.3>,.5,-20}
		sphere{<.5,1.2,-.4>,.5,-20}
		pigment{rgb .95}
		finish{diffuse .6 specular .1 roughness .1}
		normal{crackle scale .01}
	}
		
	
	
	
	/*box{<-dimx/2-.1,-.005,0>,<dimx/2+.1,.005,-sqrt(dimz*dimz/4+.5*.5)-.3>
		rotate <-35,0,0>
		pigment{rgb 1}
		translate <0,1.5,0>
	}
	box{<-dimx/2-.1,-.005,0>,<dimx/2+.1,.005,-sqrt(dimz*dimz/4+.5*.5)-.3>
		rotate <-35,0,0>
		pigment{rgb 1}
		translate <0,1.5,0>
		scale<1,1,-1>
	}*/
	
	
	
	
	bezier_patch {
		3,	3
		accuracy 0.01
		<-1,1,0>,<0,1,0>,<1,1,0>
		<-1,0,.2>,<0,0,.1>,<1,0,0>
		<-1,-1,.3>,<0,-1,0>,<1,-1,-.3>
		texture{
			pigment {
				image_map {
					tga "skin.tga"
					map_type 0	//planar
					interpolate 2	//bilinear
				}
				scale 2
				translate <1,1,0>
			}
			finish{diffuse .8 ambient .1}
	
		}
		scale .14
		translate <0,.5,-dimz/2>
	}
	
	bezier_patch {
		3,	3
		accuracy 0.01
		<-1,1,0>,<0,1,0>,<1,1,0>
		<-1,0,.3>,<0,0,.2>,<1,0,.3>
		<-1,-1,.8>,<0,-1,.6>,<1,-1,.7>
		texture{
			pigment {
				image_map {
					tga "skin.tga"
					map_type 0	//planar
					interpolate 2	//bilinear
				}
				scale 2
				translate <1,1,0>
			}
			finish{diffuse .8 ambient .1}
	
		}
		scale <.19,.3,.19>
		rotate <0,90,0>
		translate <dimx/2,.3,0>
	}


#declare cyl =
	function{x*x+z*z-1}

#declare chim = 
	function{
		pigment {
			image_map {
				tga "bricks.tga"
				map_type 2	//cylindrical
				once
				interpolate 2	//bilinear
			}
		}

	}
	
difference{
	isosurface{
		function(cyl(x,0,z) - chim(x,y,z))
		threshold 0
		accuracy .05
		contained_by{box{<-1.7,.0001,-1.7>,<1.5,.97,1.5>}}
		max_gradient 4
		pigment {
			image_map {
				tga "bricktex.tga"
				map_type 2	//cylindrical
				once
				interpolate 2	//bilinear
			}
		}
		scale <1,4,1>*.5
	}
	cylinder{-3*y,3*y,.4 pigment{rgb .5}}
	rotate <0,-90,0>
	scale <.2,.2,.2> 
	translate <-.5,1.4,-.2>
}



//cylinder{0,y,1.7 scale <1,4,1>*.5 scale .2 translate <-.5,1.4,-.2> pigment{rgb 1}}
//blob{
#declare c = 0;
#declare vel = <0,.5,0>;
#declare pos = <-.5,1.7,-.2>;
#declare wind = <3,0,0>;
#declare dt = .1;
#while (c < 7)
	#declare vel = (wind-vel)*.014 + vel*.995;
	#declare pos = pos + vel*dt;
	sphere{pos + rv(.01 + c*c*.005),.08 + c*.04
		no_shadow
		hollow
		pigment{rgbt <1,1,1,1>}
		interior{
			media {
				absorption rgb <.97,.95,.9>*(3-3*c/7)
				emission rgb <.2,.2,.2>*(1-c/7)
				scattering {
					1,
					rgb 1
					extinction (2-.2*c/7)
				 }
				density {
					granite
					color_map {
						[0 rgb 0]
						[1 rgb 1]
					}
				}
				method 3
				intervals 1
				samples 1
			}
		}
	}
	#declare c = c+dt;
#end
}
/*object{cabin}

global_settings{max_trace_level 64}



plane{-z,-20 pigment{rgb 1}}*/




