#version unofficial megapov .7;



#macro super(a,b,c)
	#local tr = (a+b)/2;
	#local sc = (a-b)/2;
	c
	scale sc
	translate tr
#end

#if (wall_and_countertop)
	#debug "\n"
#else
	#debug "\n  skipping wall and countertop"
#end
#if (wall_and_countertop)
	#debug "\n      countertop"
	superellipsoid{super(<-18,0,10>,<18,-1,-36>,.1)
		texture{
			pigment {
				image_map {
					tga "countersmall.tga"
					map_type 0	//planar
					interpolate 2	//bilinear
				}
				rotate <90,0,0>
				scale .75
			}
			finish{
				diffuse .8
				specular .5
				metallic .7
				roughness .1
			}
		}
	
			
	}
	#debug "\n      wall"
	box{<-20*12,-4*12,11>,<20*12,6*12,12>
		material {
			texture{
				pigment {
					image_map {
						tga "wallpaper.tga"
						map_type 0	//planar
						interpolate 2	//bilinear
					}
				}
				normal {
					bump_map {
						tga "wallpaperbump.tga"
						map_type 0	//planar
						interpolate 2	//bilinear
						use_color 
					}
					0.5 //amount
					scale <.1, .1, .1>
				}
				finish {
					diffuse .8
					specular .2
					roughness .05
					metallic .8
				}
			}
			scale <30,20,1>
			translate <10,0,0>
		}
	
	}
#end


#if (props)
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "props"
#if (props)
	
	#include "woods.inc"
	#debug "\n      wood border"
	prism {
		bezier_spline
		linear_sweep
		0.0, 	//Base height
		1.0, 	//Top height
		28,
		<-0.00000, 0.99259>,
		<0.38519, 1.00000>,
		<0.33333, 0.97073>,
		<0.33333, 0.85185>,
		<0.33333, 0.85185>,
		<0.33333, 0.74815>,
		<0.23704, 0.62222>,
		<0.24444, 0.62222>,
		<0.24444, 0.62222>,
		<0.25185, 0.62222>,
		<0.35043, 0.61588>,
		<0.24444, 0.22222>,
		<0.24444, 0.22222>,
		<0.19259, 0.02963>,
		<0.29630, -0.17037>,
		<0.18519, -0.20741>,
		<0.18519, -0.20741>,
		<0.17816, -0.20975>,
		<0.21935, -0.31185>,
		<0.20741, -0.40741>,
		<0.20741, -0.40741>,
		<0.20000, -0.46667>,
		<0.18519, -0.60000>,
		<0.00741, -0.59259>,
		<0.00741, -0.59259>,
		<0.00001, -0.59228>,
		<-0.00000, 0.99259>,
		<-0.00000, 0.99259>
		sturm
		rotate <90,90,0>
		rotate <180,180,0>
		scale <100,1.8,1.8>
		translate <0,2,11>
		translate <50,0,0>
		texture{T_Wood7 rotate <0,88,0>}
	}
	#declare rts = seed(12094);
	#declare xc = -30;
	#while (xc < 30)
		superellipsoid{super(<xc,-10,10.8>,<xc+1.5,2,12>,.1) 
			texture{T_Wood13 rotate <88,0,0> translate <rand(rts)*5,0,0> finish{ambient rand(rts)*.1 diffuse .6 + rand(rts)*.05}}
			//pigment {rgbf <1,.95,.9,.8>}
		}
		#declare xc = xc+1.5;
	#end
	#debug "\n      sign"
	#include "sign.pov"
	object{sign_ scale <2/3,1,1>*2.9 rotate <0,22,0>  translate <3,0,6>}
	
	
	#debug "\n      napkins"
	#include "napkins.pov"
	object{napkin_holder translate <0,1,0> scale 2.5 rotate <0,-3,0> translate <-8.5,0,6>}
	#debug "\n      bottles"
	#include "bottles.mcr"
	object{
		bottle(<-4,0,6>,<1,.3,.3>,<1.6,1.8,1.6>)
	}
	object{
		bottle(<-13,0,6.4>,<1,1,.3>,<1.6,1.8,1.6>)
	}
	#debug "\n      spoons"
	#include "spoons.pov"
	object{spoon rotate <30,-20,70> translate <.8,4,0>}
#end

#if (nerds)
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "nerds"
#if (nerds)
	#include "nerds.pov"
	//#include "nerddrop.pov"
	#declare nerd_size = .07;
	#include "preparsednerds.pov"
#end



#if (crumbs)
	#debug "\n"
#else
	#debug "\n  skipping "
#end
#debug "crumbs"
#if (crumbs)

	#declare crunch = 
		function{
			pigment{
				granite
				scale 2
			}
		}
	#macro crumb(pos,size_)		
		isosurface {
			function {
				x*x + y*y + z*z - (.1)*(.1) - 1*crunch(x,y,z)
			}
			accuracy 0.01
			method 2
			max_gradient 1.8
			threshold 0
			contained_by{sphere{0,1.1}}
			pigment {
				rgb <0.789990, 0.728740, 0.545113>*.8
			}
			finish{ambient .5}
			scale size_
			translate pos
			//no_shadow
		}
		//sphere{pos,size_ pigment{rgb 1}}
	#end
	
	#declare sd1 = seed(12409);
	#declare C = 0;
	#while (C<20)
		#declare rp = gauss(sd1)*.02;
		crumb(<-5 + gauss(sd1),.07+rp,gauss(sd1)>,.07+rp)
		#declare C = C+1;
	#end
#end











