/**
 * Desk ornament
 *
 * By the Lamere family
 */
#include "textures.inc"
#include "shapes.inc"
#include "colors.inc"
#include "golds.inc"
#include "stones2.inc"
#include "table.inc" 
#include "lamp.inc" 
#include "paper_pad.inc"
#include "pencil.inc"
#include "glass_cup.inc"
#include "chair.inc"
#include "picture.inc"

#declare ScaleFactor=3;
#declare Total=20;


camera {
      location <2.7, 3.5,  .3>
      look_at <2.2, 3.2, .6>
}



global_settings {
    max_trace_level 10
}

sky_sphere {
    pigment {
	color Black
    }
}

// light_source { <0, 20, 0> color rgb 1  shadowless}
//light_source { <7, 6, -5> color White shadowless}
light_source { <4, 9, 0> color White }
light_source { <-5, 9, 5> color White }


#declare wall = union {
	box { 
	    <0,0,0,> <1,1,.1>
	    pigment {color Tan}
	}
	scale <7, 5, 1>
}

#declare desk = union {
    object { table }
    object { tableLamp rotate y*40 translate <-1.5, HLeg, .8>}
    object { padOfPaper translate <-.6, HLeg, -1.0> rotate y*-15}
    object { pencil rotate x*90 translate <.2, HLeg + .05, -0.5>}
    // object { GlassCup translate <.6, HLeg, 0.5>}
    //object { pencil translate <.32, HLeg + .02, 0.6> rotate z*4}
    object { Picture rotate y* -60 translate <-2., HLeg, -.0> }
    object { chair rotate y * 18 translate z * -1.7}
}

#declare simpleOffice = union {
    object { desk }
   // object { wall translate <-3, 0, Depth/2 > }
    //object { wall rotate y*90 translate <-3, 0, Depth/2 > }
    // object { wall rotate y*90 translate <4, 0, Depth/2 > }
   // object { pencil scale <Scale, Scale, Scale> translate <3.3, 0, Depth/2> }
}

#declare Count = 1;
#declare XOffset = 1.6;
#declare YOffset = HLeg;
#declare ZOffset = .5;

#declare CurScale = 1;
#declare CurXOffset = 0;
#declare CurYOffset = 0;
#declare CurZOffset = 0;

#declare office = union {
#while (Count <= Total) 
    object { simpleOffice scale <CurScale, CurScale, CurScale>
             translate <CurXOffset, CurYOffset, CurZOffset>
    #declare CurXOffset = CurXOffset + XOffset * CurScale;
    #declare CurYOffset = CurYOffset + YOffset * CurScale;
    #declare CurZOffset = CurZOffset + ZOffset * CurScale;
    #declare  CurScale =  CurScale / ScaleFactor;
    }
    #declare Count = Count + 1;
#end
}

object { office }


