



#include "textures.inc"
#include "shapes.inc"
#include "colors.inc"
#include "golds.inc"
#include "stones2.inc"

#include "woods.inc"
#include "metals.inc"

#declare Width = 5;
#declare Depth = 2.5; 
#declare Delta = .1; 
#declare HLeg = 2.2;
#declare WLeg = (Width / 2) - .2;
#declare DLeg = (Depth / 2) - .2;

#declare leg = union {
    cylinder {
        <0, 0, 0>
        <0, HLeg - .1, 0>
	.05
	texture { T_Chrome_3A }
    }
    cylinder {
        <0, 0, 0>
        <0, .02, 0>
	.08
	pigment { Black }
    }
}


#declare tabletop = union {
    box {
    	<-Width/2 - Delta, -.05, -Depth/2> - Delta,
    	<Width/2 + Delta, .05, Depth/2 + Delta>
	texture { T_Silver_1A }
    }
    box {
    	<-Width/2 , -.051, -Depth/2>,
    	<Width/2, .051, Depth/2>
	// texture { T_Wood19 }
	// texture { T_Wood19 }
	pigment { rgb <.4, .4, .4>  }
	finish { specular .4 roughness .15 }
	normal {  bumps .25 scale .85 }
    }
}

#declare table = union {
    object { leg translate <-WLeg, 0, -DLeg> }
    object { leg translate <-WLeg, 0, DLeg> }
    object { leg translate <WLeg, 0, DLeg> }
    object { leg translate <WLeg, 0, -DLeg> }
    object { tabletop  translate y*HLeg - .051  }
}
