//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Blossom definition type 0.1a000408a include file
// By S.Nishimura
//**********************************************************************************



//**********************************************************************************
// petal
#local Ptl_r = 1.8 ; #local Ptl_w = 0.34;
coordinate_color( 360, 0.00, 0.99, 1, 1 )
coordinate_color( -30, 0.45, 0.77, 1, 2 )
#local Petal_base =
sphere { 0, 10*Ptl_r clipped_by { plane { y, 0 } }
 clipped_by { cylinder { 10*x,< 10, -Ptl_r*10-1/1000, 0 >,10 scale < 1/2, 1, Ptl_w > } }
 translate Ptl_r*10*y
 pigment { wood
           color_map { [ 0.0 rgb < R1, G1, B1 > ]
                       [ 1.0 rgb < R2, G2, B2 > ] } 
           scale < 0.5, 0.8, 0.8 >
           translate 40*y }
 normal { bumps 0.3 scale < 1, 1, 0.3 >*2 }
 finish { diffuse 0.6 }
hollow on
}
//
#local Petal_org =
union {
 object { Petal_base clipped_by { plane { z, 0 } rotate   0*y } rotate -8*x translate  0.28*z }
 object { Petal_base clipped_by { plane { z, 0 } rotate 180*y } rotate  8*x translate -0.28*z }
}
//
#local Petal_seg =
union {
#local Si=0; #local Ei=5; #while(Si<Ei)
 object { Petal_org rotate 360*Si/Ei*y }
#local Si=Si+1; #end
scale 2
}
// pistil
coordinate_color( 30, 0.7, 0.9, 1, 3 )
coordinate_color( 30, 1.0, 0.5, 1, 4 )
#local Pistil_seg =
union { 
 cylinder { 0,5*y 0.2 pigment { color rgbf < R3, G3, B3, 0.3 > } finish { reflection 0.6 } }
 sphere { 5*y, 0.4 pigment { color rgb < R4, G4, B4 > } normal { bumps 0.3 scale 0.3 } finish { reflection 0.6 } }
}
// Stamen
#local Stamen_org =
union {
 torus { 7,0.2 sturm rotate -90*x
  clipped_by { plane { x, 0 } rotate  90*z }
  clipped_by { plane { x, 0 } rotate -45*z }
  pigment { color rgbf < R3, G3, B3, 0.3 > }
  finish { reflection 0.6 }
  translate < 5, 5, 0 > }
 sphere { 5*y, 0.4
  pigment { color rgb < R4, G4, B4 > }
  normal { bumps 0.3 scale 0.3 }
  finish { reflection 0.6 }
  translate -2*x }
}
//
#local Stamen_seg =
union {
#local Si=0; #local Ei=8; #while(Si<Ei)
 object { Stamen_org translate -0.5*x rotate 360*Si/Ei*y }
#local Si=Si+1; #end
}
// Calyx
coordinate_color( 90, 0.4, 0.4, 1, 5 )
#local Calyx_org =
sphere { 1*y, 1 clipped_by { plane { y, 1 } }
clipped_by {
prism {
 linear_sweep
 bezier_spline 0,1,40
 <-0.49,-0.18><-0.49,0.026><-1.458,0.392><-1.383,0.571>
 <-1.383,0.571><-1.307,0.75><-0.48,0.333><-0.3,0.41>
 <-0.3,0.41><-0.12,0.487><-0.207,1.488><0,1.49>
 <0,1.49><0.207,1.492><0.161,0.465><0.34,0.39>
 <0.34,0.39><0.519,0.315><1.305,0.76><1.381,0.582>
 <1.381,0.582><1.457,0.403><0.51,0.006><0.51,-0.2>
 <0.51,-0.2><0.51,-0.406><1.176,-0.944><1.04,-1.08>
 <1.04,-1.08><0.904,-1.216><0.2,-0.55><0.02,-0.55>
 <0.02,-0.55><-0.16,-0.55><-0.921,-1.199><-1.058,-1.065>
 <-1.058,-1.065><-1.194,-0.93><-0.49,-0.386><-0.49,-0.18>
 scale 3/5
} }
pigment { color rgb < R5, G5, B5 > }
normal { bumps 3 }
}
//
#local Calyx_sub =
sphere { 1*y, 1 clipped_by { plane { y, 1 } }
clipped_by {
prism {
 linear_sweep
 bezier_spline 0,1,64
 <-1,0.99><-0.877,1.112><-0.662,0.938><-0.49,1>
 <-0.49,1><-0.318,1.062><-0.189,1.361><0,1.362>
 <0,1.362><0.189,1.364><0.338,1.05><0.51,0.99>
 <0.51,0.99><0.682,0.93><0.877,1.123><1,1>
 <1,1><1.123,0.877><0.947,0.676><1.01,0.5>
 <1.01,0.5><1.073,0.324><1.375,0.174><1.377,-0.02>
 <1.377,-0.02><1.38,-0.214><1.069,-0.354><1.01,-0.53>
 <1.01,-0.53><0.951,-0.706><1.143,-0.917><1.02,-1.04>
 <1.02,-1.04><0.897,-1.163><0.684,-0.952><0.51,-1.01>
 <0.51,-1.01><0.336,-1.068><0.201,-1.396><0.009,-1.393>
 <0.009,-1.393><-0.183,-1.389><-0.325,-1.104><-0.5,-1.04>
 <-0.5,-1.04><-0.675,-0.976><-0.885,-1.132><-1.01,-1.01>
 <-1.01,-1.01><-1.135,-0.887><-0.949,-0.702><-1.01,-0.53>
 <-1.01,-0.53><-1.071,-0.358><-1.378,-0.199><-1.376,-0.01>
 <-1.376,-0.01><-1.374,0.179><-1.083,0.318><-1.02,0.49>
 <-1.02,0.49><-0.957,0.662><-1.123,0.867><-1,0.99>
 scale 3/5
} }
pigment { color rgb < R5, G5, B5 > }
}
//
coordinate_color( 90, 1.0, 0.5, 1, 6 )
#local Calyx_seg =
union {
 object { Calyx_org translate (-0.4-1/1000)*y scale < 8, 1, 8 > rotate -23*y }
 object { Calyx_sub translate (-1-1/1000)*y scale < 1, 8, 1 > }
 sphere { 0, 1 clipped_by { plane { y, 0 } }
  pigment { color rgb < R6, G6, B6 > }
  scale < 1, 8, 1 > }
}
//
coordinate_color( 90, 0.7, 0.6, 1, 7 )
#local Twig_org =
 torus { 25,0.5 sturm rotate -90*x
  clipped_by { plane { x, 0 } rotate 90*z }
  clipped_by { plane { x, 0 } rotate -45*z }
 pigment { color rgb < R7, G7, B7 > }
 translate < 25, -6, 0 >
}
//
#declare Blossom_seg =
union {
 object { Petal_seg }
 object { Pistil_seg }
 object { Stamen_seg scale 0.8 rotate -45/3*y }
 object { Stamen_seg scale 0.9 rotate  45/3*y }
 object { Stamen_seg }
 object { Calyx_seg }
 object { Twig_org }
 translate < -7.40, 23.74, 0 >
}
//**********************************************************************************
