//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Curved line macro Ver 0.3r011112a include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
#macro Curve_write(File_name,Comment)
#ifndef(Tx0) #local Tx0=0; #end #ifndef(Tz0) #local Tz0=0; #end 
 #fopen Curve_data File_name write
 #write (Curve_data,Pmax,",\n")
 #local Si=0; #while(Si<Pmax)
  #write (Curve_data,Vp[Si].x,",",Vp[Si].y,",")
  #if(mod(Si+1,8)=0 & Si+1!=Pmax) #write (Curve_data,"\n") #end
 #local Si=Si+1; #end
 #write (Curve_data,"\n",Tx0,",",Tz0,",\n","\"",Comment,"\"",","," By S.Nishimura")
 #fclose Curve_data 
#end
//----------------------------------------------------------------------------------
#macro Curve_read(File_name)
 #fopen Curve_data File_name read
 #read (Curve_data,Pmax)
 #declare Vp=array[Pmax]
 #local Si=0; #while(Si<Pmax)
  #read (Curve_data,Pvx,Pvz) #declare Vp[Si]=<Pvx,Pvz>;
 #local Si=Si+1; #end
 #read (Curve_data,Tx0,Tz0)
 #fclose Curve_data 
#end
//**********************************************************************************
//sample
/*
#local Pmax=1+2*6; #local Vp=array[Pmax]
//
#local Vp[0]=< -48, 32 >; #local Vp[1]=< -43, 40 >;
#local Vp[2]=< -38, 32 >; #local Vp[3]=< -33, 40 >;
#local Vp[4]=< -28, 32 >; #local Vp[5]=< -18, 27 >;
#local Vp[6]=< -28, 23 >; #local Vp[7]=< -33, 15 >;
#local Vp[8]=< -38, 23 >; #local Vp[9]=< -43, 15 >;
#local Vp[10]=< -48, 23 >; #local Vp[11]=< -58, 27 >;
#local Vp[12]=Vp[0];
Curve_write("Contact.dat.txt","Contact_line data")
//Curve_read("Contact.dat.txt")
#local Curveobj = union { Contact_line(0.4, 4, 8) pigment { color rgb 1 } rotate -90*x scale 3 }
object { Curveobj translate <84,-82.25,0> } object { Curveobj translate <144,-82.25,0> }
*/
//**********************************************************************************
#macro FtoCurvature_cnv(V1,Mx,Func_type)
#local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
#local Px=0; #local Pz=0; #local Ox0=0; #local Oz0=0;
#declare Pmax=ceil((Ep-Sp)/Ap)+1;
#declare Vp=array[Pmax]
 Curve_function(Sp,Px,Pz,Func_type) #local Px1=Px; #local Pz1=Pz;
 #local Cnt=1; #while(Cnt<Pmax)
 Curve_function(Sp+Ap,Px,Pz,Func_type) #local Px2=Px; #local Pz2=Pz;
 #if(Cnt=1)
 #local Mrc=Mx*(Pz2-Pz1)+(Px2-Px1);
 #if((Px1=Px2 & tan(pi/2)=Mx) | (Px1=Px2 & tan(pi*3/2)=Mx) | (Pz2-Pz1)=Mx*(Px2-Px1) | Mrc=0) // line chek
  #local Tr1=0;
  #local Ta1=mod(degrees(atan2(-1,Mx))+360,360); 
  #declare Vp[0]=<Tr1,Ta1>;
  #local Tr2=sqrt(pow(Px2-Px1,2)+pow(Pz2-Pz1,2));
  #local Ta2=0;
  #declare Vp[1]=<Tr2,Ta2>;
  #declare Tx0=Px1; #declare Tz0=Pz1;
  #local Ox0=Px2-Tr2*cos(radians(Ta1)); #local Oz0=Pz2-Tr2*sin(radians(Ta1));//
 #else
  // center point
  Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #declare Tx0=Px1; #declare Tz0=Pz1;//#declare Tx0=Ox0; #declare Tz0=Oz0; 
  #local Tr1=0;
  #local Ra1=degrees(atan2(Pz1-Oz0,Px1-Ox0));
  #local Ta1=mod(Ra1+360,360);
  #declare Vp[0]=<Tr1,Ta1>;
  #local Tr2=sqrt(pow(Px2-Ox0,2)+pow(Pz2-Oz0,2));
  #local Ra2=degrees(atan2(Pz2-Oz0,Px2-Ox0));
  #local Ta2=mod(Ra2+360,360)-mod(Ra1+360,360);
  #if(Ta2<-180) #local Ta2=Ta2+360; #end #if(Ta2>180) #local Ta2=Ta2-360; #end 
  #declare Vp[1]=<Tr2,Ta2>;
 #end
 #end
//
 #if(Cnt>1)
 #if((Pz1-Oz0)*(Pz2-Pz1)=-(Px1-Ox0)*(Px2-Px1) | (Pz1-Oz0)*(Px2-Px1)=(Px1-Ox0)*(Pz2-Pz1)) // line chek
  #local Tr2=sqrt(pow(Px2-Px1,2)+pow(Pz2-Pz1,2));
  #local Ta2=0;
  #declare Vp[Cnt]=<Tr2,Ta2>;
  #local Ox0=(Px2-Px1)+Ox0; #local Oz0=(Pz2-Pz1)+Oz0;
 #else 
  // center point
  #local A=2*(Px2-Px1)*(Px1-Ox0)+2*(Pz2-Pz1)*(Pz1-Oz0);
  #local B=2*(Pz1-Pz2)*(Px1*Oz0-Pz1*Ox0);
  #local C=(Px1-Ox0)*(pow(Px1,2)-pow(Px2,2)+pow(Pz1,2)-pow(Pz2,2));
  #local Ox = (B-C)/A;                                 // center x
  #local Oz = ((Pz1-Oz0)/(Px1-Ox0))*(Ox-Px1)+Pz1;      // center z
  #local Tr2=sqrt(pow(Px2-Ox,2)+pow(Pz2-Oz,2));        // radius r
  // clipping arc
  #local Ra1=degrees(atan2(Pz1-Oz,Px1-Ox));
  #local Ra2=degrees(atan2(Pz2-Oz,Px2-Ox));
  #local Ta2=mod(Ra2+360,360)-mod(Ra1+360,360);
  #if(Ta2<-180) #local Ta2=Ta2+360; #end #if(Ta2>180) #local Ta2=Ta2-360; #end
  #declare Vp[Cnt]=<Tr2,Ta2>;
  #local Ox0=Ox; #local Oz0=Oz;
 #end
 #end
 #local Px1=Px2; #local Pz1=Pz2;
 #local Sp=Sp+Ap; #local Cnt=Cnt+1; #end
#end
//**********************************************************************************
//sample (Curve function data -> Curvature line data conversion)
/*
FtoCurvature_cnv(pi*<-1,2.6,1/8>,tan(radians(135)),0)
//Curve_write("test.dat.txt","Curvature cnv data")
//Curve_read("test.dat.txt")
union { Curvature_line(0.1,0) pigment { color rgb 1 } translate <Tx0,0,Tz0> rotate -90*x scale 20 }
*/
//**********************************************************************************
#macro Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Oc=0;
 #if((Px1=Px2 & tan(pi/2)=Mx) | (Px1=Px2 & tan(pi*3/2)=Mx) | (Pz2-Pz1)=Mx*(Px2-Px1)) #local Oc=3; #end
 #if(Mx*(Pz2-Pz1)+(Px2-Px1)=0) #local Oc=3; #end
 #if(Oc=0) 
  #if(Mx=0) #local Mx=1e-12; #end
  #local A= 2*((Pz2-Pz1)-Mx*(Px2-Px1));
  #local B=-2*(Px2-Px1)*(Mx*Pz1+Px1);
  #local C=(pow(Px2,2)-pow(Px1,2))+(pow(Pz2,2)-pow(Pz1,2));
  #local Oz0=(B+C)/A; #local Ox0=Mx*(Pz1-Oz0)+Px1;
 #end
#end
//**********************************************************************************
#macro Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
// radius line
#local Mrc=(Px1-Ox0)*(Pz2-Pz1)-(Pz1-Oz0)*(Px2-Px1);
// vartical line
#local Mvc=(Px1-Ox0)*(Px2-Px1)+(Pz1-Oz0)*(Pz2-Pz1);
// circle & straight line chek
#local Ltype=3;
#if(Mrc!=0 & Mvc!=0) 
 // center point
 #local A=2*(Px2-Px1)*(Px1-Ox0)+2*(Pz2-Pz1)*(Pz1-Oz0);
 #local B=2*(Pz1-Pz2)*(Px1*Oz0-Pz1*Ox0);
 #local C=(Px1-Ox0)*(pow(Px1,2)-pow(Px2,2)+pow(Pz1,2)-pow(Pz2,2));
 #local Ox = (B-C)/A;                                 // center x
 #local Oz = ((Pz1-Oz0)/(Px1-Ox0))*(Ox-Px1)+Pz1;      // center z
 #local Tr=sqrt(pow(Px2-Ox,2)+pow(Pz2-Oz,2));         // radius r
 // clipping arc
 #local Ra1=degrees(atan2(Pz1-Oz,Px1-Ox));
 #local Ra2=degrees(atan2(Pz2-Oz,Px2-Ox));
 // counterclockwise & clockwise chek
 #local Mc=Px1-Ox; #local Ms=Pz1-Oz;
 #if(Mc!=0) #local Mtan=Ms/Mc; #else #local Mtan=tan(pi/2); #end
 #local Vxv=(pow(Mtan,2)*Px2+Mtan*(Pz1-Pz2)+Px1)/(pow(Mtan,2)+1);
 #local Vzv=(pow(Mtan,2)*Pz1+Mtan*(Px1-Px2)+Pz2)/(pow(Mtan,2)+1);
 #local Vs=Vzv-Pz1; #local Vc=-(Vxv-Px1);
 #if(Mc!=0)
  #if(Mc*Vs>0) #local Ltype=1; #end
  #if(Mc*Vs<0) #local Ltype=2; #end
 #else
  #if(Ms*Vc>0) #local Ltype=1; #end
  #if(Ms*Vc<0) #local Ltype=2; #end 
 #end
#end
// line type
#switch(Ltype)
 #case(1)
  torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate -(Ra1+180)*y }
  clipped_by { plane { z, 0 } rotate -(Ra2)*y }
  translate < Ox, 0, Oz > }
 #break
 #case(2)
  torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate -(Ra1)*y }
  clipped_by { plane { z, 0 } rotate -(Ra2+180)*y }
  translate < Ox, 0, Oz > }
 #break
 #case(3)
  cylinder { < Px1, 0, Pz1 >,< Px2, 0, Pz2 >,Lw open }
  #local Ox=Ox0+(Px2-Px1);
  #local Oz=Oz0+(Pz2-Pz1);
 #break
#end
//
 #local Ox0=Ox;
 #local Oz0=Oz;
#end
//**********************************************************************************
//sample functions
/*
#macro Curve_function(Tp,Px,Pz,Func_type)
 #switch(Func_type)
 #case( 0) #local Px= 2*cos(radians(45*Tp)); #local Pz= 2*sin(radians(45*Tp)); #break // octagon
 #case( 1) #local Px= Tp; #local Pz= 1/3*pow(Px,2)+Px-1; #break // x^2
 #case( 2) #local Px= Tp; #local Pz= 1/3*pow(Px,3); #break      // x^3
 #case( 3) #local Px= Tp; #local Pz= sin(Tp); #break // sin
 #case( 4) #local Px= Tp; #local Pz= cos(Tp); #break // cos
 #case( 5) #local Px= 3*cos(Tp); #local Pz= 2*sin(Tp); #break   // ellipse
 #case( 6) #local Px= Tp*cos(Tp); #local Pz= Tp*sin(Tp); #break // spiral
 #case( 7) #local Rr= cos(2*Tp); #local Px= 3*Rr*cos(Tp); #local Pz= 2*Rr*sin(Tp); #break // 4leafs
 #case( 8) #local Rr= cos(3*Tp); #local Px= 3*Rr*cos(Tp); #local Pz= 2*Rr*sin(Tp); #break // 3leafs
 #case( 9) #local Rr= cos(4*Tp); #local Px= 3*Rr*cos(Tp); #local Pz= 2*Rr*sin(Tp); #break // 8leafs
 #case(10) #local Px= (2+3*cos(Tp))*cos(Tp)-2; #local Pz= (1.5+3*cos(Tp))*sin(Tp); #break // carjioid
 #case(11) #local Px= 3*pow(cos(Tp),3); #local Pz= 2*pow(sin(Tp),3); #break // asteloid
 #case(12) #local Rr= sin(Tp/2); #local Px= 3*Rr*cos(Tp); #local Pz= 2*Rr*sin(Tp); #break // leafs
 #case(13) #local Px= Tp; #local Pz= log(Tp); #break // log
 #case(14) #local Px= Tp-sin(Tp); #local Pz= 1-cos(Tp); #break // cycloid
 #case(15) #local Px= 3*pow(0.99,6*Tp)*cos(Tp); #local Pz= 3*pow(0.99,6*Tp)*sin(Tp); #break // spiral
 #case(16) #local Px= Tp; #local Pz= 2*Px; #break   // 2x
 #end
#end
*/
//**********************************************************************************
#macro Curved_line(Lw,V1,Mx,Func_type)
#local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
#local Px=0; #local Pz=0; #local Ox0=0; #local Oz0=0;
 Curve_function(Sp,Px,Pz,Func_type) #local Px1=Px; #local Pz1=Pz;
 #while(Sp<Ep)
 Curve_function(Sp+Ap,Px,Pz,Func_type) #local Px2=Px; #local Pz2=Pz;
 #if(Sp=V1.x) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Px1=Px2; #local Pz1=Pz2;
 #local Sp=Sp+Ap; #end
#end
//**********************************************************************************
//sample parameters (Lw:Bp:Ep:Ap:Mx:Func_type)
/*
union { Curved_line(0.1,pi*<-1,2.6,1/8>,tan(radians(135)),0) pigment { color rgb 1 } rotate -90*x scale 10 }
Curved_line(0.1,pi*<-1,1,1/8>,2/3*(-pi)+1,1)
Curved_line(0.1,pi*<-1,1,1/8>,pow(-pi,2),2)
Curved_line(0.1,pi*<-1,1,1/7>,cos(-pi),3)
Curved_line(0.1,pi*<-1,1,1/7>,-sin(-pi),4)
Curved_line(0.1,pi*<-1,1,1/8>,(-2/3)*(cos(-pi)/sin(-pi)),5)
Curved_line(0.1,pi*<-1/2,2,1/4>,(sin(-pi/2)-pi/2*cos(-pi/2))/(cos(-pi/2)+pi/2*sin(-pi/2)),6)
Curved_line(0.1,pi*<-1,1,1/46>,tan(radians(90)),7)
Curved_line(0.1,pi*<-1,1,1/76>,tan(radians(90)),8)
Curved_line(0.1,pi*<-1,1,1/120>,(-2/3)*(sin(4*-pi)*sin(-pi)+cos(-pi)*cos(4*-pi))/(sin(4*-pi)*cos(-pi)+sin(-pi)*cos(4*-pi)),9)
Curved_line(0.1,pi*<-1,1,1/10>,tan(radians(90)),10)
Curved_line(0.1,pi*<-1,1,1/38>,tan(0),11)
Curved_line(0.1,pi*<-2,2,1/14>,tan(radians(180)),12)
Curved_line(0.1,<0.1,3.8,1/6>,1/(0.1+1e-1),13)
Curved_line(0.1,pi*<-1,1,1/32>,tan(radians(180)),14)
Curved_line(0.1,pi*<0,8,1/4>,tan(radians(95)),15)
union { Curved_line(0.1,pi*<-1,1,1/2>,2,16) pigment { color rgb 1 } rotate -90*x scale 10 }
*/
//**********************************************************************************
#macro Contact_curve_function(Tp,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px,Pz)
 #local Px=(X0*pow(1-Tp,2)+(2+E1)*Xc*Tp*(1-Tp)+(1+E1+E2)*X1*pow(Tp,2))/(1+E1*Tp+E2*pow(Tp,2));
 #local Pz=(Z0*pow(1-Tp,2)+(2+E1)*Zc*Tp*(1-Tp)+(1+E1+E2)*Z1*pow(Tp,2))/(1+E1*Tp+E2*pow(Tp,2));
#end
//----------------------------------------------------------------------------------
#macro Contact_line(Lw,E1,E2)
#local Px=0; #local Pz=0; #local Ox0=0; #local Oz0=0;
#local Si=0; #while(Si<Pmax-2)
 #local X0=Vp[Si].x;   #local Z0=Vp[Si].y;
 #local Xc=Vp[Si+1].x; #local Zc=Vp[Si+1].y;
 #local X1=Vp[Si+2].x; #local Z1=Vp[Si+2].y; 
 // curve segment
 #local Sp=0; #local Ep=1; #local Ap=1/(10-1e-14);
 #if(Xc=X0) #local Mx=tan(pi/2); #else #local Mx=(Zc-Z0)/(Xc-X0); #end
 Contact_curve_function(Sp,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px,Pz) #local Px1=Px; #local Pz1=Pz;
 #while(Sp<Ep)
 Contact_curve_function(Sp+Ap,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px,Pz) #local Px2=Px; #local Pz2=Pz;
 #if(Sp=0) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Px1=Px2; #local Pz1=Pz2;
 #local Sp=Sp+Ap; #end
#local Si=Si+2; #end
#end
//**********************************************************************************
#macro Contact_curve(Lw,E1,E2)
 Contact_line(Lw,E1,E2)
#end
//**********************************************************************************
// sample parameters (Lw:line width E1:E2:De=pow(E1,2)-4*E2)
/*
#local Pmax=1+2*8; #local Vp=array[Pmax]
// vector
#local Vp[0]=< -10,-20 >; #local Vp[1]=< -20,-20 >;
#local Vp[2]=< -20,-10 >; #local Vp[3]=< -20,  0 >;
#local Vp[4]=< -20, 10 >; #local Vp[5]=< -20, 20 >;
#local Vp[6]=< -10, 20 >; #local Vp[7]=<   0, 20 >;
#local Vp[8]=<  10, 20 >; #local Vp[9]=<  20, 20 >;
#local Vp[10]=< 20, 10 >; #local Vp[11]=< 20,  0 >;
#local Vp[12]=< 20,-10 >; #local Vp[13]=< 20,-20 >;
#local Vp[14]=< 10,-20 >; #local Vp[15]=<  0,-20 >;
#local Vp[16]=Vp[0];
union { Contact_curve(0.8, 4, 0) pigment { color rgb 1 } rotate -90*x scale 3 }
*/
//**********************************************************************************
#macro Trammel_function(Tp,Ll,Vl,Px,Pz)
 #local Px=Vl*cos(Tp); #local Pz=(Ll-Vl)*sin(Tp);
#end
//----------------------------------------------------------------------------------
#macro Trammel_line(Lw,V1,Ll,Vl)
#local Sp=V1.x; #local Ep=V1.y; #local Ap=V1.z;
#if(Vl=0) #local Mx=tan(pi/2); #else #local Mx=-(Ll-Vl)/Vl*cos(Sp)/sin(Sp); #end
#local Px=0; #local Pz=0; #local Ox0=0; #local Oz0=0;
 Trammel_function(Sp,Ll,Vl,Px,Pz)   #local Px1=Px; #local Pz1=Pz;
 #while(Sp<Ep)
 Trammel_function(Sp+Ap,Ll,Vl,Px,Pz)#local Px2=Px; #local Pz2=Pz;
 #if(Sp=V1.x) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Px1=Px2; #local Pz1=Pz2;
 #local Sp=Sp+Ap; #end
#end
//**********************************************************************************
// sample parameters (Lw:line width V1:Sp,Ep,Ap Ll:trammel length Vl:transfer point)
/*
#local Si=0; #while(Si<2+5)
 union { Trammel_line(0.1,pi*<-1,1,1/24>,3,Si/2) pigment { color rgb 1 } rotate -90*x scale 20 }
#local Si=Si+1; #end
*/
//**********************************************************************************
// beginning Cover (Tr1=0)
#macro Beginning_cover(Cover_flag,Cvr)
 #if(Cvr=0) #declare Txb=Ox+Tr2*cos(radians(Ra1)); #declare Tzb=Oz+Tr2*sin(radians(Ra1)); #end
 #if(Cvr=3) #declare Txb=Tx; #declare Tzb=Tz; #end
 #switch(Cover_flag)
 #case(1) 
  #if(Cvr=0) disc { 0,z,Lw2 rotate -Ra1*y translate <Txb,0,Tzb> } #end
  #if(Cvr=3) disc { 0,x,Lw2 rotate -Rm*y translate <Txb,0,Tzb> } #end
 #break
 #case(2)
  #if(Cvr=0) sphere { 0,Lw2 rotate -Ra1*y translate <Txb,0,Tzb> } #end
  #if(Cvr=3) sphere { 0,Lw2 rotate -Rm*y translate <Txb,0,Tzb> } #end
 #break
 #end 
#end
//----------------------------------------------------------------------------------
// cutting cover (Tr2=0)
#macro Cutting_cover(Cover_flag,Cvr)
 #declare Txc=Ox+Tr1*cos(radians(Ra2)); #declare Tzc=Oz+Tr1*sin(radians(Ra2));
 #switch(Cover_flag)
 #case(1)
  #if(Cvr<3) disc { 0,z,Lw2 rotate -Ra2*y translate <Txc,0,Tzc> } #end
  #if(Cvr=3) disc { 0,x,Lw2 rotate -Rm*y translate <Txc,0,Tzc> } #end   
 #break
 #case(2)
  #if(Cvr<3) sphere { 0,Lw2 rotate -Ra2*y translate <Txc,0,Tzc> } #end
  #if(Cvr=3) sphere { 0,Lw2 rotate -Rm*y translate <Txc,0,Tzc> } #end   
 #break
 #end
#end
//----------------------------------------------------------------------------------
// ending cover
#macro Ending_cover(Cover_flag,Cvr)
 #if(Cvr<3) #declare Txe=Ox+Tr2*cos(radians(Ra2)); #declare Tze=Oz+Tr2*sin(radians(Ra2)); #end
 #if(Cvr=3) #declare Txe=Tx+Tr2*cos(radians(Rm)); #declare Tze=Tz+Tr2*sin(radians(Rm)); #end
 #switch(Cover_flag)
 #case(1) 
  #if(Cvr<3) disc { 0,z,Lw2 rotate -Ra2*y translate <Txe,0,Tze> } #end
  #if(Cvr=3) disc { 0,x,Lw2 rotate -Rm*y translate <Txe,0,Tze> } #end    
 #break
 #case(2)
  #if(Cvr<3) sphere { 0,Lw2 rotate -Ra2*y translate <Txe,0,Tze> } #end
  #if(Cvr=3) sphere { 0,Lw2 rotate -Rm*y translate <Txe,0,Tze> } #end    
 #break
 #end
#end
//**********************************************************************************
#macro Curvature_line(Lw,Cover_flag)
#local Lw2=Lw; #local Cec=0; #declare Txc=0; #declare Tzc=0;//
#local Tr1=Vp[0].x; #local Ta1=Vp[0].y; #local Ra2=Ta1;
 #local Cnt=1; #while(Cnt<Pmax)
 #local Tr2=Vp[Cnt].x; #local Ta2=Vp[Cnt].y;
 #local Tr=Tr2; #if(Tr2<0) #local Tr2=abs(Tr2); #local Ta=Ta2; #local Ta2=0; #end //cone
 #if(Cnt=1) #local Br=0; #else #local Br=Tr1; #end #local Lw1=Lw; //cover
#if(Cover_flag!=0 & Tr2!=0 & Cec=1) Cutting_cover(Cover_flag,Cvr) #end // cone Cutting cover
#if(Br!=0 & Tr2=0 & Cec!=1) Cutting_cover(Cover_flag,Cvr) #end // cutting cover (Tr2=0) Br=Tr1
#if(Br!=0 & Tr2=0 & Cec=1) #declare Txc=Ox+Tr1*cos(radians(Ra2)); #declare Tzc=Oz+Tr1*sin(radians(Ra2)); #end// cutting point
 #local Rtype=9; //(Tr2=0)
 #if(Br=0)
  #local Rtype=0;
 #else
  #if((Tr2!=0 & Ta1*Ta2>0) | (Tr2!=0 & Ta1=0 & Ta2>0)) #local Rtype=1; #end
  #if((Tr2!=0 & Ta1*Ta2<0) | (Tr2!=0 & Ta1=0 & Ta2<0)) #local Rtype=2; #end
 #end
 #if(Tr2!=0 & Ta2=0) #local Rtype=3; #end
 #if(Br=0 & Tr2=0) #local Rtype=9; #end
 #local Cvr=Rtype; //cover
 #switch(Rtype)
  #case(0)
   #local Ox=Txc-Tr2*cos(radians(Ra2));//#local Ox=0;
   #local Oz=Tzc-Tr2*sin(radians(Ra2));//#local Oz=0;
   #local Ra1=Ra2; #local Ra2=Ra2+Ta2;
  #break
  #case(1)
   #local Ox=(Tr1-Tr2)*cos(radians(Ra2))+Ox;
   #local Oz=(Tr1-Tr2)*sin(radians(Ra2))+Oz;
   #local Ra1=Ra2; #local Ra2=Ra2+Ta2;
  #break
  #case(2)
   #local Ox=(Tr1+Tr2)*cos(radians(Ra2))+Ox;
   #local Oz=(Tr1+Tr2)*sin(radians(Ra2))+Oz;
   #local Ra1=Ra2+180; #local Ra2=Ra2+180+Ta2;
  #break
  #case(3)
   #if(Ta1>=0) #local Rm=Ra2+ 90; #else #local Rm=Ra2+270; #end
   #if(Br=0)
    #local Ox=Txc-Tr2*cos(radians(Ra2));//
    #local Oz=Tzc-Tr2*sin(radians(Ra2));//
    #local Tr1=Tr2;
   #end
   #local Tx=Tr1*cos(radians(Ra2))+Ox; #local Tz=Tr1*sin(radians(Ra2))+Oz;
   #local Ox=Tr2*cos(radians(Rm))+Ox; #local Oz=Tr2*sin(radians(Rm))+Oz;
  #break
  #case(9)
   #local Ra1=0; #local Ra2=Ta2;//#local Ox=0; #local Oz=0; 
  #break
 #end
#if(Br=0 & Tr2!=0) Beginning_cover(Cover_flag,Cvr) #end // beginning Cover (Tr1=0) Br=Tr1
 #local Ej=1;
 #if(Ta2>0) #local Ltype=1; #end
 #if(Ta2<0) #local Ltype=2; #end
 #if(Ta2=0) #local Ltype=3; #end
 #if(Tr2=0) #local Ltype=9; #end
 #switch(Ltype)
  #case(1)
  #if(Ta2>180) #local Ej=2; #local Rae=Ra2; #local Ra2=Ra1+180; #end
  #local Sj=0; #while(Sj<Ej)
  torus { Tr2,Lw2
   clipped_by { plane { z, 0 } rotate -(Ra1+180)*y }
   clipped_by { plane { z, 0 } rotate -(Ra2)*y }
   translate < Ox, 0, Oz > }
  #if(Ej=2) #local Ra1=Ra2; #local Ra2=Rae; #end
  #local Sj=Sj+1; #end
  #break
  #case(2)
  #if(Ta2<-180) #local Ej=2; #local Rae=Ra2; #local Ra2=Ra1+180; #end
  #local Sj=0; #while(Sj<Ej)  
  torus { Tr2,Lw2
   clipped_by { plane { z, 0 } rotate -(Ra1)*y }
   clipped_by { plane { z, 0 } rotate -(Ra2+180)*y }
   translate < Ox, 0, Oz > }
  #if(Ej=2) #local Ra1=Ra2; #local Ra2=Rae; #end
  #local Sj=Sj+1; #end
  #break
  #case(3)
  #if(Tr>0)
   cylinder { 0,Tr2*x,Lw2 open rotate -Rm*y translate <Tx,0,Tz> }
  #else
   #local Lw1=Lw2*Ta;
   cone { 0,Lw2, Tr2*x,Lw1 open rotate -Rm*y translate <Tx,0,Tz> }
   #if(Lw1=0) #local Lw2=Lw; #else #local Lw2=Lw1; #end
  #end
  #break
  #case(9)
   #local Tr1=0; #local Ta1=0;
  #break
 #end
 #if(Tr<0 & Lw1=0) #local Cec=1; #else #local Cec=0; #end // cone chek
 #if(Ta2!=0) #local Tr1=Tr2; #local Ta1=Ta2; #end
 #local Cnt=Cnt+1; #end    
#if(Tr2!=0 & Cec!=1) Ending_cover(Cover_flag,Cvr) #end // ending cover
#end
//**********************************************************************************
// sample parameters (Lw:line width Cover_flag:0=open 1=disc 2=sphere)
/*
#local Pmax=1+3; #local Vp=array[Pmax]
#local Vp[0]=<0,80>; #local Vp[1]=<15,-60>; #local Vp[2]=<-30,1.2>; #local Vp[3]=<25,220>;
//Curve_write("Curvature.dat.txt","Curvature_line data")
//Curve_read("Curvature.dat.txt")
union { Curvature_line(1,0) pigment { color rgb 1 } rotate -90*x }
*/
//**********************************************************************************